
/*
 * @Description        : Displays skill meter on page load[jquery document.ready]
 * @Developed By       : Md Mashqur Ul Alam [22-01-17]
 * @parameter          : Null
 * @status             : Available
 */

$(function () {
    if ($("#skillP").html()) {
        displaySingleSkillMeter($("#skillP").html());
    }
    ;

    var meterId = $('div[id^="quiz_result_meter"]');    
    if (meterId.length > 0) {
        for (i = 0; i < meterId.length; i++) {
            assignMeterColor(meterId[i].id);
        }
    }    
    
});

/**
 * @Function            : assignMeterColor
 * @Description         : Updates the color value based on marks percentage while
 *                        displaying multiple skill meter
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-01-17
 * @Parameter           : meterID[dynamic id of the divs where skill meter displayed]
 * @Return              : NULL    
 * @Status              : Available       
 * */
function assignMeterColor(meterId){
    var percentValue = $('#'+meterId).attr('data-percent');
    if (percentValue <= 50) {
        $('#'+meterId).attr("data-fgcolor", "#fc0a0a");
    } else if (percentValue <= 70) {
        $('#'+meterId).attr("data-fgcolor", "#f7ea5b");
    } else if (percentValue <= 85) {
        $('#'+meterId).attr("data-fgcolor", "#32cd32");
    } else if (percentValue <= 100) {
        $('#'+meterId).attr("data-fgcolor", "#8CC73F");
    }
}

/**
 * @Function            : displayMultipleMeter
 * @Description         : Run the animation for displaying multiple meter
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-01-17
 * @Parameter           : meterClass [common class of the divs where meter displayed]
 * @Return              : NULL    
 * @Status              : Available       
 * */
function displayMultipleMeter(meterClass){
    $('.'+meterClass).empty();
    $('.'+meterClass).circliful();
}

/**
 * @Function            : displaySingleSkillMeter
 * @Description         : displays the single skill meter in quiz result
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-01-17
 * @Parameter           : Skillpercentage
 * @Return              : NULL    
 * @Status              : Available       
 * */
function displaySingleSkillMeter(Skillpercentage) {
    var SkiilValue = Skillpercentage.replace("%", "");
    if (SkiilValue <= 50) {
        $("#testPercentage").attr("data-fgcolor", "#fc0a0a");
    } else if (SkiilValue <= 70) {
        $("#testPercentage").attr("data-fgcolor", "#f7ea5b");
    } else if (SkiilValue <= 85) {
        $("#testPercentage").attr("data-fgcolor", "#32cd32");
    } else if (SkiilValue <= 100) {
        $("#testPercentage").attr("data-fgcolor", "#8CC73F");
    }

    $("#testPercentage").attr("data-percent", SkiilValue);
    $("#testPercentage").attr("data-text", Skillpercentage);

    $('.circlestat').circliful();
}


/**
 * @Function            : checkForAction
 * @Description         : Changes the result status and reloads the page
 * @Developed By        : Unknown
 * @Comment Added By    : Md Mashqur Ul Alam [22-01-17]
 * @Parameter           : url, action, ID
 * @Return              : NULL    
 * @Status              : Available       
 * */
function checkForAction(url, action, ID) {
    swal({
        title: "",
        text: "Are you sure you want to " + action + " ?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: "Yes",
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true},
            function (isConfirm) {
                if (isConfirm) {
                    var cfa_xmlhttp = create_xmlhttp();
                    var serverPage = url;
                    cfa_xmlhttp.open("GET", serverPage);
                    cfa_xmlhttp.onreadystatechange = function ()
                    {
                        if (cfa_xmlhttp.readyState == 4 && cfa_xmlhttp.status == 200)
                        {
                            location.reload();
                        }
                    };
                    cfa_xmlhttp.send(null);
                }
            });
}

