
// Fires All event after loading the pages completely
$(document).ready(function () {
// Displays the current city information by default after loading the page  
    displayCurrentCityCountry();

// Displays the tab content after clicking the current city
    $('#profileCurrentCity').click(function () {
        $('#aboutCurrentCity #mapOff').attr('id', 'map');
        $('#aboutBlocks').hide();
        $('#aboutTravel').hide();
        $('#aboutCurrentCity').show(function () {
            initMap();
        });

    });

// Handle the switching between tab content optional blocks
    $('#tabAbout').click(function () {
        displayCurrentCityCountry();
        $('#aboutCurrentCity').hide();
        $('#aboutTravel').hide();
        $('#aboutConnectivity').hide();
        $('#aboutMyLink').hide();
        $('#aboutpersonalInfo').hide();
        $('#aboutInterest').hide();
        $('#aboutEducation').hide();
        $('#aboutChangePassword').hide();
        $('#pendingLinkRequest, #linkedUser, #link_suggestion, #linkSuggestion').empty();
        $('#aboutBlocks').show();
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutTravel #map').attr('id', 'mapOff');
        $('#aboutConnectivity #map').attr('id', 'mapOff');
    });

// Displays the tab content after clicking the travel
    $('#profileTravel').click(function () {
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutConnectivity #map').attr('id', 'mapOff');
        $('#aboutTravel #mapOff').attr('id', 'map');
        $("#aboutCurrentCity").hide();
        $('#aboutBlocks').hide();
        $('#aboutTravel').show(function () {
            initTravelMap();
        });
    });

// Displays the tab content after clicking the connectivity
    $('#profileConnectivity').click(function () {
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutTravel #map').attr('id', 'mapOff');
        $('#aboutConnectivity #mapOff').attr('id', 'map');
        $("#aboutCurrentCity").hide();
        $("#aboutTravel").hide();
        $('#aboutBlocks').hide();
        $('#aboutConnectivity').show(function () {
            initLinkMap();
        });
    });
    

// Displays the tab content after clicking the My Link
    $('#profileMyLink').click(function(){
        $('#aboutBlocks').hide();
        $('#pendingReqUp').hide();        
        $('#pendingLinkRequest').hide();
        displayLinks();
        $('#aboutMyLink').slideDown('slow');
        displayMyLinkSuggestion();
        
    });
    
// Makes the pending button hidden by default
    $('#pendingButton').hide();
    
// Slide down the content after clicking pending request button    
    $('#pendingButton').click(function(){        
        $('#pendingLinkRequest').slideDown('slow');
        $('#pendingButton').hide();
        $('#pendingReqUp').show();
        $('#divideBar').show();
    });
// Slide up the content of pending request  
    $('#pendingReqUp').click(function(){
        $('#pendingLinkRequest').slideUp('slow');
        $('#pendingButton').show();
        $('#pendingReqUp').hide();
        $('#divideBar').hide();
    });
    
 // Displays the tab content after clicking Education
    $('#profileEducation').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutEducation').slideDown();
    });
    
 // Displays the tab content after clicking Interest
    $('#profileInterest').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutInterest').slideDown();
    });
    
// Displays the tab content after clicking Personal Info
    $('#profilePersonalInfo').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutpersonalInfo').slideDown();
    });
    
// Displays the tab content after clicking Change Password
    $('#profileChangePassword').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutChangePassword').slideDown();
    });
// Skill tab events
$('#tabSkill').click(function(){
    $('#skillBlocks').slideDown();
    $('#skillExperience').hide();
    $('#skillSelfAssessment').hide();
    $('#skillTtSkill').hide();
    $('#skillOverview').hide();
    $('#skillLanguage').hide();
});
    
// Displays the experience Content
    $('#profileExp').click(function(){
        $('#skillBlocks').hide();
        $('#skillExperience').slideDown();
    });
    
// Displays the self assessment Content
    $('#profileSelfAssessment').click(function(){
        $('#skillBlocks').hide();
        $('#skillSelfAssessment').slideDown();
    });
    
// Displays the TT Skill Content
    $('#profileTtSkill').click(function(){
        $('#skillBlocks').hide();
        $('#skillTtSkill').slideDown();
    });
    
// Displays the Skill Overview Content
    $('#profileSkillOverview').click(function(){
        $('#skillBlocks').hide();
        $('#skillOverview').slideDown(function(){
            displayMultipleMeter('meterCircle');
        });
        
    });
    
// Displays the Language Content
    $('#profileLanguage').click(function(){
        $('#skillBlocks').hide();
        $('#skillLanguage').slideDown();
    });
    
// Resource tab events
$('#tabResource').click(function(){
    $('#resourceBlocks').slideDown();
    $('#resourceNote').hide();
    $('#resourceAlert').hide();
    $('#resourceAssignment').hide();
    $('#resourceImage').hide();
    $('#resourceVideo').hide();
    });
    
// Displays Notes
    $('#profilePostNote').click(function(){
        $('#resourceBlocks').hide();
        $('#resourceNote').slideDown();
    });
// Displays Alert
    $('#profilePostAlert').click(function(){
        $('#resourceBlocks').hide();
        $('#resourceAlert').slideDown();
    });
// Displays Assignment
    $('#profilePostAssignment').click(function(){
        $('#resourceBlocks').hide();
        $('#resourceAssignment').slideDown();
    });
// Displays Image
    $('#profilePostImage').click(function(){
        $('#resourceBlocks').hide();
        $('#resourceImage').slideDown();
    });
// Displays Video
    $('#profilePostVideo').click(function(){
        $('#resourceBlocks').hide();
        $('#resourceVideo').slideDown();
    });


// Display Course Tab
    $('#tabCourse').click(function(){
        $('#courseBlocks').show();
        $('#courseLearner').hide();        
        $('#courseTeacher').hide();        
        $('#courseOrganization').hide();        
    });


// Display Learner Course
    $('#profileLearnerCourse').click(function(){
        $('#courseBlocks, #courseTeacher, #courseOrganization').hide();
        $('#courseLearner').slideDown();
        
    });
// Display Teacher Course
    $('#profileTeacherCourse').click(function(){
        $('#courseBlocks, #courseLearner, #courseOrganization').hide();
        $('#courseTeacher').slideDown();
        
    });

// Display Organization Course
    $('#profileOrganizationCourse').click(function(){
        $('#courseBlocks, #courseLearner, #courseTeacher').hide();
        $('#courseOrganization').slideDown();
        
    });
    
// Display Video Course Tab
    $('#tabVideoCourse').click(function(){
        $('#videocourseBlocks').show();
        $('#videocourseLearner').hide();        
        $('#videocourseTeacher').hide();        
        $('#videocourseOrganization').hide();        
    });


// Display Learner Video Course
    $('#profileLearnerVideoCourse').click(function(){
        $('#videocourseBlocks, #videocourseTeacher, #videocourseOrganization').hide();
        $('#videocourseLearner').slideDown();
        
    });
// Display Teacher Video Course
    $('#profileTeacherVideoCourse').click(function(){
        $('#videocourseBlocks, #videocourseLearner, #videocourseOrganization').hide();
        $('#videocourseTeacher').slideDown();
        
    });

// Display Organization Video Course
    $('#profileOrganizationVideoCourse').click(function(){
        $('#videocourseBlocks, #videocourseLearner, #videocourseTeacher').hide();
        $('#videocourseOrganization').slideDown();
        
    });

});


/*
 * @Function            : displayCurrentCityCountry
 * @Used IN             : profile page current city back info display
 * @Description         : displays information on the back flip of current city
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 16-11-2016 03:00 PM 
 * @Parameter           : None
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */

function displayCurrentCityCountry() {

    var profileUrl = $('#profileUrl').val();    
    var baseUrl = $('#baseUrl').val();
    $('#currentLocation').empty();
    $.post(baseUrl + 'get-current-location',{profile_url:profileUrl}, function (data) {        
        var value = JSON.parse(data);
        if (value !== null && value.person_current_latitude_longitude.length > 0) {
            var countryName = getCountryName(value.person_country);
            var cityName = value.person_city;
            $('#currentLocation').append(
                    '<h5 style="padding: 5px"><span>City : ' + cityName + '</span></h5>'
                    + '<h5 style="padding: 5px"><span>Country : ' + countryName + '</span></h5>'
                    + '<h5 style="padding: 5px"><span> Click To View on Map</span></h5>'
                    );
        } else {
            $('#currentLocation').append(
                    '<h5 style="padding: 50px 5px; "><span> Click To Add Your Current Location</span></h5>'
                    );
        }
    });
}

/*
 * @Function            : deleteLink
 * @Used IN             : profile link
 * @Description         : Unlink or Delete link
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 24-11-2016 03:57 PM 
 * @Parameter           : person_url[url of the person that will be deleted]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function deleteLink(personUrl){  
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'delete-link',{profile_url:personUrl},function(){
        $('#'+personUrl).hide();
    });
}

/*
 * @Function            : blockLink
 * @Used IN             : profile link
 * @Description         : Blocks link
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 24-11-2016 05:28 PM 
 * @Parameter           : person_url[url of the person that will be blocked]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function blockLink(personUrl){    
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'block-link',{profile_url:personUrl},function(){
        $('#'+personUrl).hide();
    });
}

/*
 * @Function            : acceptLinkRequest
 * @Used IN             : profile link
 * @Description         : Accepts Pending Link Request
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 24-11-2016 06:17 PM 
 * @Parameter           : person_url[url of the person that will be accepted]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function acceptLinkRequest(personUrl){    
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'accept-link-request',{profile_url:personUrl},function(){
        $('#divideBar').show();
        $('#'+personUrl).detach().prependTo('#linkedUser');       
    });
}
