function createXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest !== 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}
/*
 * @Function            : uploadProfileImage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : upload profile image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : imageFile[FILE]
 * @Return              : NULL      
 * @Status              : available      
 */
function uploadProfileImage(imageFile) {
    var xmlHttp;
    var height;
    // determines xml http object for ajax
    xmlHttp = createXMLHTTP(xmlHttp);
    var url = documentID('ajax_url').value;
    var formdata = new FormData();
    formdata.append("person_image", imageFile);
    xmlHttp.upload.addEventListener("progress", function (event) {

        documentID('progressBarView').style.display = 'block';
        documentID('uploadImageFrom').style.display = 'none';
        documentID('uploadPhotos').removeAttribute("onclick");
        documentID('uploadPhotos').style.cursor = 'default';
        var percent = (event.loaded / event.total) * 100;
        documentID("progressBar").setAttribute('style', 'width:' + Math.round(percent) + '%');
        if (Math.round(percent) === 100) {
            documentID('progressBarView').style.display = 'none';
            documentID('imageView').style.display = 'block';
            documentID('actionIcon').style.display = 'block';
            documentID('updateButton').style.display = 'none';
            documentID('saveButton').style.display = 'block';
            documentID('saveButton').className = 'btn btn-success col-sm-3';
            documentID('cancelButton').className = 'btn btn-danger col-sm-1';
        }

    }, false);
    xmlHttp.addEventListener("load", function () {
        var imageData = JSON.parse(xmlHttp.responseText);
        if (imageData.image_path === 0) {
            if (imageData.no_image_file === 1) {
                var errorMessage = 'No image file selected';
                showErrorMessage(errorMessage);
            } else if (imageData.error_file_loc === 1) {
                var errorMessage = 'Image file location does not valid';
                showErrorMessage(errorMessage);
            } else if (imageData.error_file_type === 1) {
                var errorMessage = 'Please Select : jpeg png jpg image file';
                showErrorMessage(errorMessage);
            } else if (imageData.error_valid_image === 1) {
                var errorMessage = 'Please select valid image file';
                showErrorMessage(errorMessage);
            } else if (imageData.error_image_size === 1) {
                var errorMessage = 'Image size less than 2 mb';
                showErrorMessage(errorMessage);
            }
        } else {
            if (imageData.image_height > 380) {
                height = 380;
            } else {
                height = imageData.image_height;
            }
            documentID('imageSource').setAttribute('style', 'width:' + imageData.image_width + 'px; height:' + height + 'px;');
            documentID('imageSource').src = imageData.image_path;
            documentID('imageSourceValue').value = imageData.image_path_value;
            documentID('imageHeight').value = height;
            documentID('imageWidth').value = imageData.image_width;
            documentID('uploadFile').value = '';
        }

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}


/*
 * @Function            : getProfileImage 
 * @Used IN             : @function-'uploadProfileImage'  this@JS
 * @Description         : get profile image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : inputFile[FILE]
 * @Return              : NULL      
 * @Status              : available      
 */
function getProfileImage(inputFile) {
    var file = inputFile.files[0];
    checkImageValidation(file);
}



/*
 * @Function            : checkImageValidation 
 * @Used IN             : @function-'getProfileImage'  this@JS
 * @Description         : check image validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : imageFile[FILE]
 * @Return              : NULL      
 * @Status              : available      
 */
function checkImageValidation(imageFile) {
    var imageName = imageFile.name;
    var allowedImageFileType = "jpeg png jpg";
    var fileExtention = imageName.split('.').pop().toLowerCase();
    var n = allowedImageFileType.search(fileExtention);
    if (n > -1) {
        if (imageFile.size < 5120000) {
            uploadProfileImage(imageFile);
        } else {
            documentID('errorMessageView').style.display = 'block';
            documentID('errorMessage').innerHTML = 'Image size more than 5 mb';
        }
    } else {
        documentID('errorMessageView').style.display = 'block';
        documentID('errorMessage').innerHTML = 'Please Select : jpeg png jpg image file';
    }
}


/*
 * @Function            : Auto 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : resize image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : None
 * @Return              : NULL      
 * @Status              : available      
 */
(function () {
    var uploadPhotos = documentID('uploadPhotos');
    var uploadFile = function (file) {
        if (file.length < 2) {

            checkImageValidation(file[0]);
        } else {
            documentID('errorMessageView').style.display = 'block';
            documentID('errorMessage').innerHTML = 'You can not select multiple file';
        }
    };
    uploadPhotos.ondrop = function (e) {
        e.preventDefault();
        this.className = 'tab-content panel-body';
        uploadFile(e.dataTransfer.files);
    };
    uploadPhotos.ondragover = function () {
        this.className = 'tab-content panel-body on-drop-image';
        return false;
    };
    uploadPhotos.ondragleave = function () {
        this.className = 'tab-content panel-body';
        return false;
    };
}());

$(document).ready(function () {
    $("#cropBox").draggable({containment: "#imageSource"});
    $("#cropBox").resizable({containment: "#imageSource"});


    $(document).on('click', 'button[id=cancelButton]', function () {
        cancelButtonAction();
    });
    
    
    /*
 * @Function            : cancelButtonAction 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : Disable the set profile image button
 * @Developed By        : MD Mashqur Ul Alam
 * @Start DateTime      : 14-01-17 
 * @Parameter           : None
 * @Return              : NULL      
 * @Status              : available      
 */
    function cancelButtonAction(){
        documentID('imageSource').setAttribute('style', 'width:' + 0 + 'px; height:' + 0 + 'px;');
        documentID('imageSource').src = '';
        documentID('imageSourceValue').value = '';
        documentID('imageHeight').value = 0;
        documentID('imageWidth').value = 0;
        documentID('uploadFile').value = '';
        documentID('actionIcon').style.display = 'none';
        documentID('imageView').display = 'none';
        documentID('uploadImageFrom').style.display = 'block';
        documentID('saveButton').className = 'btn btn-success col-sm-3 disabled';
        documentID('updateButton').className = 'btn btn-success col-sm-3 disabled';
    }
    
    $(document).on('click', 'li[id=uploadPhotoViewTab]', function(){        
       cancelButtonAction();
    });
    $(document).on('click', 'li[id=myPhotosTab]', function(){
        cancelButtonAction();
    });

});
$('#viewCropBox').click(function () {
    //documentID('cropBox').style.display = 'block';
    documentID('startCropping').style.display = 'block';
    $('#imageSource').Jcrop({
      aspectRatio: 1,
      onSelect: updateCoords
    });
});

function updateCoords(c)
{
    var x = $('#x').val(c.x);
    var y = $('#y').val(c.y);
    var w = $('#w').val(c.w);
    var h = $('#h').val(c.h);
//    console.log(x.val());
//    console.log(y.val());
//    console.log(w.val());
//    console.log(h.val());
};

function resizeImage(url){
    documentID('viewCropBox').style.display = 'none';
    documentID('left_rotate').style.display = 'none';
    documentID('right_rotate').style.display = 'none';
    documentID('startCropping').style.display = 'none';
    var crop_url = url;
    var img_source = $('#baseUrl').val() + $('#imageSourceValue').val();
    var person_url = $('#person_url').val();
    
    
    if (parseInt($('#w').val())) {
        var x = parseInt($('#x').val());
        var y = parseInt($('#y').val());
        var w = parseInt($('#w').val());
        var h = parseInt($('#h').val());
        
//        console.log(x);
//        console.log(y);
//        console.log(w);
//        console.log(h);
        
        $.ajax({
            url: crop_url,
            type: "POST",
            data: {"image_source" : img_source,'person_url': person_url, "x" : x, "y" : y, "w" : w, "h" : h},
            success: function (data)
            {
                //console.log(data);
                //$('.imageSource').attr("src", data);
            }
        });
    }
    else{
        alert('Please select a crop region then press OK.');
        return false;
    }
}

/*
 * @Function            :  
 * @Used IN             : @function-'resizeImage'
 * @Description         : rotate image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-06-2016 08:43 AM 
 * @Parameter           : Null
 * @Return              : NULL      
 * @Status              : available      
 */
(function () {
    var processHeight;
    var processWidth;
    var leftRotate = 0;
    var rightRotate = 0;
    $('#left_rotate').click(function () {
        var imageHeight = documentID('imageHeight').value;
        var imageWidth = documentID('imageWidth').value;
        if (imageHeight > 350) {
            processHeight = 350;
        } else {
            processHeight = imageHeight;
        }
        if (imageWidth > 350) {
            processWidth = 350;
        } else {
            processWidth = imageWidth;
        }

        ++leftRotate;
        if (leftRotate === 1) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'none';
            documentID('imageSource').setAttribute('style', 'transform: rotate(270deg); max-width:' + processWidth + 'px; max-height:' + processHeight + 'px; margin: auto;');
            documentID('rotate_degree').value = 270;
            rightRotate = 3;

            if (imageWidth > imageHeight) {
                documentID('imageSource').style.margin = '15% 0 0 0';
            }
        }
        if (leftRotate === 2) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'block';
            documentID('imageSource').setAttribute('style', 'transform: rotate(180deg); width:' + imageWidth + 'px; height:' + imageHeight + 'px;');
            documentID('rotate_degree').value = 180;
            rightRotate = 2;
        }
        if (leftRotate === 3) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'none';
            documentID('imageSource').setAttribute('style', 'transform: rotate(90deg); max-width:' + processWidth + 'px; max-height:' + processHeight + 'px; margin: auto;');
            documentID('rotate_degree').value = 90;
            rightRotate = 1;

            if (imageWidth > imageHeight) {
                documentID('imageSource').style.margin = '15% 0 0 0';
            }
        }
        if (leftRotate === 4) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'block';
            documentID('imageSource').setAttribute('style', 'transform: rotate(0deg); width:' + imageWidth + 'px; height:' + imageHeight + 'px;');
            documentID('rotate_degree').value = 0;
            leftRotate = 0;
            rightRotate = 0;
        }

    });
    $('#right_rotate').click(function () {
        var imageHeight = documentID('imageHeight').value;
        var imageWidth = documentID('imageWidth').value;
        if (imageHeight > 350) {
            processHeight = 350;
        } else {
            processHeight = imageHeight;
        }
        if (imageWidth > 350) {
            processWidth = 350;
        } else {
            processWidth = imageWidth;
        }

        ++rightRotate;
        if (rightRotate === 1) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'none';
            documentID('imageSource').setAttribute('style', 'transform: rotate(90deg); max-width:' + processWidth + 'px; max-height:' + processHeight + 'px; margin: auto;');
            documentID('rotate_degree').value = 90;
            leftRotate = 3;

            if (imageWidth > imageHeight) {
                documentID('imageSource').style.margin = '15% 0 0 0';
            }
        }
        if (rightRotate === 2) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'block';
            documentID('imageSource').setAttribute('style', 'transform: rotate(180deg); width:' + imageWidth + 'px; height:' + imageHeight + 'px;');
            documentID('rotate_degree').value = 180;
            leftRotate = 2;
        }
        if (rightRotate === 3) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'none';
            documentID('imageSource').setAttribute('style', 'transform: rotate(270deg); max-width:' + processWidth + 'px; max-height:' + processHeight + 'px; margin: auto;');
            documentID('rotate_degree').value = 270;
            leftRotate = 1;

            if (imageWidth > imageHeight) {
                documentID('imageSource').style.margin = '15% 0 0 0';
            }
        }
        if (rightRotate === 4) {
            documentID('cropBox').style.display = 'none';
            documentID('viewCropBox').style.display = 'block';
            documentID('imageSource').setAttribute('style', 'transform: rotate(0deg); width:' + imageWidth + 'px; height:' + imageHeight + 'px;');
            documentID('rotate_degree').value = 0;
            rightRotate = 0;
            leftRotate = 0;
        }

    });


}());


/*
 * @Function            : rotateProfileImage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : rotate image using php
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 19-06-2016 11:55 AM 
 * @Parameter           : rotateDegree
 * @Return              : NULL      
 * @Status              : available      
 */
function rotateProfileImage(rotateDegree) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var url = documentID('rotate_image_url').value;
    var imageSourceValue = documentID('imageSourceValue').value;
    var formdata = new FormData();
    formdata.append("rotate_degree", rotateDegree);
    formdata.append("image_path", imageSourceValue);
    xmlHttp.addEventListener("load", function () {

        var imageData = JSON.parse(xmlHttp.responseText);
        documentID('imageSource').setAttribute('style', 'width:' + imageData.image_width + 'px; height:' + imageData.image_height + 'px;');
        documentID('imageSource').src = imageData.image_path;
        documentID('imageSourceValue').value = imageData.image_path_value;
        documentID('imageHeight').value = imageData.image_height;
        documentID('imageWidth').value = imageData.image_width;

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}
/*
 * @Function            : closeErrorModal 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : close error modal
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : None
 * @Return              : NULL      
 * @Status              : available      
 */
function closeErrorModal() {
    documentID('errorMessage').innerHTML = '';
    documentID('errorMessageView').style.display = 'none';
}



/*
 * @Function            : showErrorMessage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : show error message
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : errorMesage[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function showErrorMessage(errorMesage) {
    documentID('progressBarView').style.display = 'none';
    documentID('uploadPhotos').setAttribute("onclick", "document.getElementById('uploadFile').click();");
    documentID('uploadPhotos').style.cursor = 'pointer';
    documentID('progressBarView').style.display = 'none';
    documentID('uploadImageFrom').style.display = 'block';
    documentID('imageView').style.display = 'none';
    documentID('actionIcon').style.display = 'none';
    documentID('saveButton').className = 'btn btn-success disabled';
    documentID('closeButton').className = 'btn btn-success disabled';
    documentID('errorMessageView').style.display = 'block';
    documentID('errorMessage').innerHTML = errorMesage;
}

/*
 * @Function            : saveProfilePhoto 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : save profile photo
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-06-2016 03:17 PM 
 * @Parameter           : url[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function saveProfilePhoto(url) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var rotateDegree = documentID('rotate_degree').value;
    var cropingValue;
    if ($('#cropBox').css('display') !== 'none') {
        cropingValue = 1;
        var top = $('#cropBox').position().top;
        var left = $('#cropBox').position().left;
        var imageTop = $('#imageSource').position().top;
        var imageLeft = $('#imageSource').position().left;
        var boxWidth = $('#cropBox').width();
        var boxHeight = $('#cropBox').height();
    } else {
        cropingValue = 0;
    }

    var imagePath = documentID('imageSourceValue').value;
    var imageHeight = documentID('imageHeight').value;
    var imageWidth = documentID('imageWidth').value;
    modifyImage(url, rotateDegree, cropingValue, top, left, imageTop, imageLeft, boxWidth, boxHeight, imagePath, imageHeight, imageWidth);
}

/*
 * @Function            : modifyImage 
 * @Used IN             : @function-'resizeImage'
 * @Description         : modify image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 16-06-2016 01:53 AM 
 * @Parameter           : url[STRING], top[INTEGER], left[INTEGER], width[INTEGER], height[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function modifyImage(url, rotateDegree, cropingValue, top, left, imageTop, imageLeft, boxWidth, boxHeight, imagePath, imageHeight, imageWidth) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var formdata = new FormData();
    formdata.append("degree", rotateDegree);
    formdata.append("crop_status", cropingValue);
    formdata.append("top", top);
    formdata.append("left", left);
    formdata.append("box_width", boxWidth);
    formdata.append("box_heigth", boxHeight);
    formdata.append("image_top", imageTop);
    formdata.append("image_left", imageLeft);
    formdata.append("imageHeigth", imageHeight);
    formdata.append("imageWidth", imageWidth);
    formdata.append("image_path", imagePath);

    xmlHttp.addEventListener("load", function () {

        if (xmlHttp.responseText === 'success') {
            location.reload();
        } else {
            location.reload();
        }

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}


/*
 * @Function            : updateProfilePhoto 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : update profile photo
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-06-2016 03:17 PM 
 * @Parameter           : url[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateProfilePhoto(url) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var contentLibraryId = documentID('contentLibraryId').value;
    var contentLibraryType = documentID('contentLibraryType').value;
    var formdata = new FormData();
    formdata.append("content_library_id", contentLibraryId);
    formdata.append("content_library_type", contentLibraryType);

    xmlHttp.addEventListener("load", function () {

        location.reload();

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}


/*
 * @Function            : viewAlbumImage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : update profile photo
 * @Developed By        : view album photo
 * @Start DateTime      : 23-06-2016 01:38 PM 
 * @Updated By          : Md Mashqur Ul Alam [14-01-17]
 * @Parameter           : personID[INTEGER],contentType[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function viewAlbumImage(personID, contentType) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var profileImagePath = documentID('profileImagePath').value;

    var formdata = new FormData();
    formdata.append("person_id", personID);
    formdata.append("content_library_type", contentType);
    formdata.append("image_type", '1');
    var url = documentID('viewAlbumImageUrl').value;

    xmlHttp.addEventListener("load", function () {

        var contentData = JSON.parse(xmlHttp.responseText);
        var output = '';
        var viewImageUrl = documentID('viewImageUrl').value;

        for (var i = 0; i < contentData.length; i++) {
            output += '<div class="col-sm-3 col-sm-3 col-xs-12" >';
            output += '<div id="imageViewDiv' + contentData[i].content_library_id + '" class="thumbnail">';
            output += '<img id="viewImageScorce' + contentData[i].content_library_id + '"';
            output += 'onclick="viewFullImage(' + contentData[i].content_library_id + ',1)"';
            output += 'src="' + viewImageUrl + '/' + contentData[i].content_library_location + '"';
            output += 'alt="Image" style="height: 200px; width: 100%; cursor: pointer;">';
            if (profileImagePath !== contentData[i].content_library_location) {
                output += '<a href="javascript:void(0)" onclick="updateProfilePictureStatus(' + contentData[i].content_library_id + ',2)"><i class="fa fa-times"></i></a>';
            }
            output += '</div></div>';
        }
        documentID('viewImage').innerHTML = output;
        documentID('viewSingleImageSrc').src = '';
        documentID('viewSingleImage').style.display = 'none';
        documentID('viewBackButton').style.display = 'block';
        documentID('profileImageContentType').value = contentType;
        documentID('backImageValue').value = 1;
        documentID('backImageType').value = 'profile';
        documentID('contentLibraryId').value = '';
        documentID('contentLibraryType').value = '';

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}



/*
 * @Function            : viewPostImage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : view post Image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 26-06-2016 02:48 PM 
 * @Parameter           : url[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function viewPostImage() {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var formdata = new FormData();
    formdata.append("image_type", '2');
    var url = documentID('viewAlbumImageUrl').value;

    xmlHttp.addEventListener("load", function () {

        var postData = JSON.parse(xmlHttp.responseText);
        var output = '';
        var viewImageUrl = documentID('viewImageUrl').value;

        for (var i = 0; i < postData.length; i++) {
            output += '<div class="col-sm-3 col-sm-3 col-xs-12" >';
            output += '<div id="imageViewDiv' + postData[i].post_id + '" class="thumbnail">';
            output += '<img id="viewImageScorce' + postData[i].post_id + '"';
            output += 'onclick="viewFullImage(' + postData[i].post_id + ',2)"';
            output += 'src="' + viewImageUrl + '/' + postData[i].post_details + '"';
            output += 'alt="Image" style="height: 200px; width: 100%; cursor: pointer;">';
            output += '</div></div>';
        }
        documentID('viewImage').innerHTML = output;
        documentID('viewSingleImageSrc').src = '';
        documentID('viewSingleImage').style.display = 'none';
        documentID('viewBackButton').style.display = 'block';
        documentID('backImageValue').value = 1;
        documentID('backImageType').value = 'post';
        documentID('contentLibraryId').value = '';
        documentID('contentLibraryType').value = '';

    }, false);
    xmlHttp.open("POST", url);
    xmlHttp.send(formdata);
}


/*
 * @Function            : viewAlbumImage 
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : update profile photo
 * @Developed By        : view album photo
 * @Start DateTime      : 23-06-2016 01:38 PM 
 * @Parameter           : personID[INTEGER],contentType[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateProfilePictureStatus(contentID, status) {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var deleteProfileImageUrl = documentID('deleteProfileImageUrl').value;
    var profileImagePath = documentID('profileImagePath').value;

    var formdata = new FormData();
    formdata.append("content_library_id", contentID);
    formdata.append("person_content_deletion_status", status);

    xmlHttp.addEventListener("load", function () {

        var contentData = JSON.parse(xmlHttp.responseText);
        var output = '';
        var viewImageUrl = documentID('viewImageUrl').value;

        if (status === 2) {
            output += '<div class="col-sm-12" id="errorMessageImageView" style="display: block;"><div class="alert alert-warning alert-dismissible alert-view" role="alert" style="position: absolute;z-index: 99999;top: -24px;left: 366px;height: 40px;">';
            output += '<button type="button" class="close" onclick="closeUndoModal()" aria-label="Close">';
            output += '<span aria-hidden="true">&times;</span></button> <a href="javascript:void(0)" onclick="updateProfilePictureStatus(' + contentID + ',1)"><strong>Undo</strong></a></div></div><br>';
        }

        output += '<div class="col-sm-12">';
        for (var i = 0; i < contentData.length; i++) {
            output += '<div class="col-sm-3 col-sm-3 col-xs-12" >';
            output += '<div id="imageViewDiv' + contentData[i].content_library_id + '" class="thumbnail">';
            output += '<img id="viewImageScorce' + contentData[i].content_library_id + '"';
            output += 'onclick="viewFullImage(' + contentData[i].content_library_id + ',1)"';
            output += 'src="' + viewImageUrl + '/' + contentData[i].content_library_location + '"';
            output += 'alt="Image" style="height: 200px; width: 100%; cursor: pointer;">';
            if (profileImagePath !== contentData[i].content_library_location) {
                output += '<a href="javascript:void(0)" onclick="updateProfilePictureStatus(' + contentData[i].content_library_id + ',2)"><i class="fa fa-times"></i></a>';
            }
            output += '</div></div>';
        }
        output += '</div>';
        documentID('viewImage').innerHTML = output;

    }, false);
    xmlHttp.open("POST", deleteProfileImageUrl);
    xmlHttp.send(formdata);
}


/*
 * @Function            : viewFullImage
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : view full image
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-06-2016 12:43 PM
 * @Updated By          : Md Mashqur Ul Alam [14-01-17]
 * @Parameter           : Null
 * @Return              : NULL      
 * @Status              : available      
 */
function viewFullImage(contentID, contentLibraryType) {
    documentID('saveButton').style.display = 'none';
    documentID('updateButton').style.display = 'block';
    documentID('updateButton').className = 'btn btn-success col-sm-3';
    documentID('cancelButton').style.display = 'block';
    //documentID('cancelButton').className = 'btn btn-danger col-sm-1';
    documentID('viewSingleImage').style.display = 'block';
    documentID('viewImage').setAttribute('style', ' margin-top: 30px;');
    var previouscontentLibraryId = documentID('contentLibraryId').value;

    if (previouscontentLibraryId !== '') {
        documentID('imageViewDiv' + previouscontentLibraryId).setAttribute('style', '');
    }
    documentID('imageViewDiv' + contentID).setAttribute('style', 'border:1px solid #80C12C');
    var imageSource = documentID('viewImageScorce' + contentID).src;
    documentID('viewSingleImageSrc').src = imageSource;
    documentID('contentLibraryId').value = contentID;
    documentID('contentLibraryType').value = contentLibraryType;
    documentID('backImageValue').value = 2;
}



/*
 * @Function            : backImageView
 * @Used IN             : @function-'view/user/profile_view/edit_profile_modal.php'
 * @Description         : back image View
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 27-06-2016 10:22 AM 
 * @Parameter           : Null
 * @Return              : NULL      
 * @Status              : available      
 */
function backImageView() {
    var backImageValue = documentID('backImageValue').value;
    var backImageType = documentID('backImageType').value;
    switch (backImageType) {
        case 'profile':
            if (backImageValue === '1') {
                viewImageDeshboard();
            }
            if (backImageValue === '2') {
                var personID = documentID('personID').value;
                var profileImageContentType = documentID('profileImageContentType').value;
                viewAlbumImage(personID, profileImageContentType);
            }
            break;
        case 'post':
            if (backImageValue === '1') {
                viewImageDeshboard();
            }
            if (backImageValue === '2') {
                viewPostImage();
            }
            break;
    }
}



/*
 * @Function            : viewImageDeshboard
 * @Used IN             : @function-'backImageView'  @this@JS
 * @Description         : view Image Deshboard
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 27-06-2016 11:42 AM 
 * @Updated By          : Md Mashqur Ul Alam [14-01-17]
 * @Parameter           : Null
 * @Return              : NULL      
 * @Status              : available      
 */
function viewImageDeshboard() {
    var xmlHttp;
    xmlHttp = createXMLHTTP(xmlHttp);

    var viewImageDeshboardUrl = documentID('viewImageDeshboardUrl').value;
    xmlHttp.open("GET", viewImageDeshboardUrl);
    xmlHttp.onreadystatechange = function ()
    {
        if (xmlHttp.readyState === 4 && xmlHttp.status === 200)
        {
            var imageData = JSON.parse(xmlHttp.responseText);
            var output = '';
            var viewImageUrl = documentID('viewImageUrl').value;

            if (imageData.content_result.length > 0) {
                for (var i = 0; i < imageData.content_result.length; i++) {
                    output += '<div class="col-sm-3 col-sm-3 col-xs-12" ><div class="thumbnail">';
                    output += '<img onclick="viewAlbumImage(' + imageData.content_result[i].content_library_type_id + ', ' + imageData.content_result[i].content_library_type + ')" src="' + viewImageUrl + '/' + imageData.person_info.person_image + '" alt="Image" style="height: 150px; width: 80%; cursor: pointer;">';
                    output += '<div class="caption" style="padding: 0px"><h3 style="text-align: center !important;margin: 5px"><strong>';
                    if (imageData.content_result[i].content_library_type === '1') {
                        output += 'Profile photo';
                    }
                    if (imageData.content_result[i].content_library_type === '2') {
                        output += 'Course Image';
                    }
                    output += '</strong></h3></div></div></div>';
                }
            }

            if (imageData.post_result.length > 0) {
                for (var i = 0; i < imageData.post_result.length; i++) {
                    output += '<div class="col-sm-3 col-sm-3 col-xs-12" ><div class="thumbnail">';
                    output += '<img onclick="viewPostImage()" src="' + viewImageUrl + '/' + imageData.post_result[i].post_details + '" alt="Image" style="height: 150px; width: 80%; cursor: pointer;">';
                    output += '<div class="caption" style="padding: 0px"><h3 style="text-align: center !important;margin: 5px"><strong>';
                    output += 'Post Image</strong></h3></div></div></div>';
                }
            }
            documentID('viewImage').innerHTML = output;
            documentID('viewBackButton').style.display = 'none';
        }
    };
    xmlHttp.send(null);
}

function closeUndoModal() {
    documentID('errorMessageImageView').style.display = 'none';
}