$(document).ready(function () {
    var paymentStatus;
    var pageNumber = 1;
    var baseUrl = $('#baseUrl').val();


    /*
     * @Description         : View invoice by datewise
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 10:54 AM    
     */
    $(document).on('change', 'select[id="paymentStatus"]', function () {
        paymentStatus = $('#' + this.id).val();
        pageNumber = 1;

        // View invoice Information
        viewInvoices();
    });


    /*
     * @Description         : View invoice for pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 05:54 AM    
     */
    $(document).on('click', 'a[id^="invoicePagination"]', function () {
        pageNumber = this.id.replace('invoicePagination', '');

        // View invoice Information
        viewInvoices();
    });


    /*
     * @Description         : View invoice by datewise and pagination
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 05:58 AM    
     */
    var viewInvoices = function () {
        $.ajax({
            type: 'post',
            url: baseUrl + 'user/search-invoice',
            data: {payment_status: paymentStatus, page_number: pageNumber},
//        beforeSend: function () {
//            $('#loading_image').show();
//            $('#view_register_student').attr('style', 'opacity:0.2');
//        },
//        complete: function () {
//            $('#loading_image').hide();
//            $('#view_register_student').attr('style', 'opacity:1');
//        },
            success: function (data) {
//                alert(data);
                var invoiceData = JSON.parse(data);
                $('#viewInvoice').html(invoiceData.view_page);
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    };


    /*
     * @Description         : refund request 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2017 12:16 PM    
     */
    var invoiceRendomId;
    $(document).on('click', 'a[id^="refundRequestInvoice"]', function () {
        invoiceRendomId = this.id.replace('refundRequestInvoice', '');
        $('#viewRefundRequestInvoiceModal').modal('show');
    }).on('click', 'button[id="modalNoButtonrefundImvoice"]', function () {
        $('#viewRefundRequestInvoiceModal').modal('hide');
    }).on('click', 'button[id="modalYesButtonrefundImvoice"]', function () {
        $.post(
                baseUrl + 'user/refund-request-invoice',
                {invoice_random_id: invoiceRendomId},
                function () {
                    location.reload();
                });
    });
    /*
     * @Description         : Cancel invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 06:25 PM    
     */
    $(document).on('click', 'a[id^="cancelInvoice"]', function () {
        var randomID = this.id.replace('cancelInvoice', '');

        var paymentStatus = Number($('#hiddenPaymentStatus' + randomID).val());

        if (paymentStatus !== 3) {
            $('#viewDoNotCancelInvoiceModal' + randomID).modal('show');
        } else {
            $('#viewCancelInvoiceModal' + randomID).modal('show');
        }
    }).on('click', 'button[id^="modalNoButton"]', function () {
        var randomID = this.id.replace('modalNoButton', '');
        $('#viewCancelInvoiceModal' + randomID).modal('hide');
    }).on('click', 'button[id^="modalYesButton"]', function () {
        var randomID = this.id.replace('modalYesButton', '');

        $.post(
                baseUrl + 'user/delete-invoice',
                {random_id: randomID},
                function () {
                    location.reload();
                });
    });
});

/*
 * @Description         : View invoice by datewise
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 23-11-2016 10:54 AM  
 * @Parameter           : StartData,endDate    
 */
var viewPaymentBYDate = function (startDate, endDate) {
    var todaysDate = getTodaysDate();

    if (startDate <= endDate) {
        if (todaysDate >= endDate) {
            viewInvoices(startDate, endDate);
            $('#errorMessage').html('');
        } else {
            $('#errorMessage').html('<span style="color:red;">Your can not select date after today!</span>');
        }
    } else {
        $('#errorMessage').html('<span style="color:red;">Please select date between to range!</span>');
    }
};


/*
 * @Function            : viewRegisterCourse 
 * @Description         : View register Course
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:51 PM  
 * @Parameter           : StartData,endDate
 * @Return              : NULL    
 * @Status              : Available        
 */
var viewInvoices = function (startDate, endDate) {
    var baseUrl = $('#baseUrl').val();

    $.ajax({
        type: 'post',
        url: baseUrl + 'user/search-invoice',
        data: {start_date: startDate, end_date: endDate},
//        beforeSend: function () {
//            $('#loading_image').show();
//            $('#view_register_student').attr('style', 'opacity:0.2');
//        },
//        complete: function () {
//            $('#loading_image').hide();
//            $('#view_register_student').attr('style', 'opacity:1');
//        },
        success: function (data) {
//            alert(data);
            var invoiceData = JSON.parse(data);
            $('#viewInvoice').html(invoiceData.view_page);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
};
/*
 * @Description         : get current date
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:38 PM 
 * @Status              : Available        
 */
var getTodaysDate = function () {
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!

    var yyyy = today.getFullYear();
    if (dd < 10) {
        dd = '0' + dd;
    }
    if (mm < 10) {
        mm = '0' + mm;
    }
    return yyyy + '-' + mm + '-' + dd;
};

//var refundRequestInvoice = function () {
//    alert(this.id);
//};