$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();

    /*
     * @Description         : View all invoices
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-01-2017 05:41 PM    
     */
    $(document).on('click', 'div[id^="viewAllInvoices"]', function () {
        var studentRolNumber = this.id.replace('viewAllInvoices', '');
        var paymentID = $('#paymentID' + studentRolNumber).val();
        var status = $('#status' + studentRolNumber).val();

        if (status !== '') {
            $('#displayAllInvoice' + studentRolNumber).slideUp('slow');
            $('#status' + studentRolNumber).val('');
        } else {
            $.ajax({
                type: 'post',
                url: baseUrl + 'user/view-all-earning-invoice',
                data: {payment_id: paymentID},
                beforeSend: function () {
                    $('#loadingImage' + studentRolNumber).slideDown('slow');
                },
                complete: function (jqXHR, textStatus) {
                    $('#loadingImage' + studentRolNumber).slideUp('slow');
                },
                success: function (data, status) {
                    if (status === 'success') {
                        var viewPage = JSON.parse(data);
                        $('#displayAllInvoice' + studentRolNumber).html(viewPage).slideDown('slow');
                        $('#status' + studentRolNumber).val(1);
                    }
                }
            });
        }
    });
    
    
    /*
     * @Description         : View total earning details
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 30-04-17    
     */
    $('#totalEarningDetail').click(function(){
        var baseUrl = $('#baseUrl').val();
        var status = $('#totalEarningStatus').val();
        
        if (status !== '') {
            $('#viewTotalEarningDetail').slideUp('slow');
            $('#totalEarningStatus').val('');
        } else {
            $.ajax({
                type: 'get',
                url: baseUrl + 'user/view-all-payment-request',                
                beforeSend: function () {
                    $('#totalEarningloadingImage').slideDown('slow');
                },
                complete: function (jqXHR, textStatus) {
                    $('#totalEarningloadingImage').slideUp('slow');
                },
                success: function (data, status) {
                    if (status === 'success') {
                        var viewPage = JSON.parse(data);
                        $('#viewTotalEarningDetail').html(viewPage).slideDown('slow');
                        $('#totalEarningStatus').val(1);
                    }
                }
            });
        }
    });
    
});