function checkxmlhttp(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest !== 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}
function document_id(el) {
    return document.getElementById(el); //Get the element with the specified ID
}
/*
 * @Function            : checkUserEmail  
 * @Used IN             : user/teacher/add_teacher_organization_view
 * @Description         : used to check person email
 * @Parameter           : useremail, url
 * @return              : none
 * @Developed By        : Tania Akter
 * @Start DateTime      : 11-06-2016
 * @Status              : available      
 */
function checkUserEmail(useremail, url) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("useremail", useremail);
    xmlhttp2.addEventListener("load", function () {
        if (xmlhttp2.responseText === '1') {
            document.getElementById('email_status_value').value = 2;            
        } else if (xmlhttp2.responseText === '2') {
            document.getElementById('email_status_value').value = 1;            
        }
    }, false);
    xmlhttp2.addEventListener("error", function () {
        alert("There is some problem in your browser, not working");
    }, false);
    xmlhttp2.addEventListener("abort", function () {
        alert("There is some problem in your browser, aborted");
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}

/*
 * @Function            : makeurl 
 * @Used IN             : user/teacher/add_teacher_organization_view
 * @Description         : used to make person url
 * @Parameter           : url(location)
 * @return              : none
 * @Developed By        : Tania Akter
 * @Start DateTime      : 12-06-2016
 * @Status              : available      
 */
//tania -6-08-2016
function makeurl(url, url2) {
    var firstname = document.getElementById('person_first_name').value;
    var lastname = document.getElementById('person_last_name').value;
    if (lastname === '') {
        profileID = firstname.toLowerCase();
    } else {
        profileID = firstname.toLowerCase() + '-' + lastname.toLowerCase();
    }
    var profileID = checkUrlCharacter(profileID);
    check_add_teacher_org_name(firstname, lastname, url2);  //add-06-08-2016
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("profileID", profileID);
    formdata.append("firstname", firstname);
    formdata.append("lastname", lastname);
    xmlhttp2.addEventListener("load", function () {
        if (xmlhttp2.responseText) {
            document.getElementById('profile_url').value = xmlhttp2.responseText;            
        }
    }, false);
    xmlhttp2.addEventListener("error", function () {
        alert("There is some problem in your browser, not working");
    }, false);
    xmlhttp2.addEventListener("abort", function () {
        alert("There is some problem in your browser, aborted");
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}
//tania 06-08-2016
function check_add_teacher_org_name(first_name, last_name, url) {
    var xmlhttp;
    xmlhttp = checkXMLHTTP(xmlhttp);
    var formdata = new FormData();
    formdata.append("first_name", first_name);
    formdata.append("last_name", last_name);
    xmlhttp.addEventListener("load", function () {
        if (xmlhttp.responseText === '1') {
            document.getElementById('add_teacher_org_forbidden_exists').value = '1';            
        } else if (xmlhttp.responseText === '2') {
            document.getElementById('add_teacher_org_forbidden_exists').value = '';           
        }
    }, false);
    xmlhttp.addEventListener("error", function () {
        alert("There is some problem in your browser, error");
    }, false);
    xmlhttp.addEventListener("abort", function () {
        alert("There is some problem in your browser, Aborted");
    }, false);
    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}




/*
 * @Function            : checkUrlCharacter 
 * @Used IN             : function[makeurl]
 * @Description         : used to check url character
 * @Parameter           : profileID(person url)
 * @return              : profileID
 * @Developed By        : Unknown
 * @Start DateTime      : Unknown
 * @Status              : available      
 */
function checkUrlCharacter(profileID) {
    for (i = 0; profileID.length > i; i++) {
        if (profileID.charAt(i) === ' ') {
            profileID = profileID.replace(/ +/g, '-');
        }
        if (profileID.charAt(i) === '.') {
            profileID = profileID.replace(/\./g, '');
        }
        if (profileID.charAt(i) === '-') {
            profileID = profileID.replace(/--/g, '-');
        }

    }
    profileID = profileID.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
    if (profileID.charAt(profileID.length - 1) === '-') {
        profileID = setCharAt(profileID, profileID.length - 1, '');
    }
    profileID = profileID.replace(/--/g, '-');
    profileID = profileID.replace(' ', '-');
    return profileID;
}

/*
 * @Function            : getprofileurl  
 * @Used IN             : user/teacher/add_teacher_organization_view 
 * @Description         : used to get url type by user and check it.
 * @Parameter           : typeurl, url(url location where value will be passed), url1(url location)
 * @return              : none
 * @Developed By        : Tania Akter
 * @Start DateTime      : 12-06-2016
 * @Status              : available      
 */
function getprofileurl(typeurl, url, url1) {
    if (typeurl === '') {
        makeurl(url);
    } else
        checkProfileUrl(typeurl, url1);
}

/*
 * @Function            : checkProfileUrl 
 * @Used IN             : function[getprofileurl] js[add_teacher_organization]
 * @Description         : used to check person url
 * @Parameter           : profileID(person url), url(url location)
 * @return              : true, false
 * @Developed By        : Tania Akter
 * @Start DateTime      : 11-06-2016
 * @Status              : available      
 */
function checkProfileUrl(profileID, url) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("profileID", profileID);
    xmlhttp2.addEventListener("load", function () {
        if (xmlhttp2.responseText === '1') {
            document.getElementById('url_exist').value = '1';            
            document_id('profile_url_message').innerHTML = '';

        } else if (xmlhttp2.responseText === '2') {
            document.getElementById('url_exist').value = '';            
            document_id('profile_url_message').innerHTML = '';
        }
    }, false);
    xmlhttp2.addEventListener("error", function () {
        alert("There is some problem in your browser, not working");
    }, false);
    xmlhttp2.addEventListener("abort", function () {
        alert("There is some problem in your browser, aborted");
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}

/*
 * @Function            : personImageUpload 
 * @Used IN             : user/teacher/add_teacher_organization_view
 * @Description         : used to upload person image
 * @developed By        : Unknown
 * @Start DateTime      : Unknown 
 * @return              : none
 * @Status              : available      
 */

function personImageUpload(input, objID) {
    document.getElementById('image').innerHTML = '';
    var node = document.createElement("img");
    document.getElementById("image").appendChild(node);
    node.setAttribute("id", objID);
    node.setAttribute("src", "");
    var file = input.files[0];
    if ((file.type === "image/jpeg") || (file.type === "image/gif") || (file.type === "image/png") || (file.type === "image/bmp"))
    {
        if (file.size > 2097152) {
            document.getElementById('image').innerHTML = '<span style="color:red;">Image size must less then 2 Mb</span>';
        } else {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#' + objID).attr('src', e.target.result);
                    $('#' + objID).attr('class', 'img-responsive');
                    document.getElementById('image_path').value = e.target.result;
                    var image_name = input.files[0]['name'];
                    document.getElementById('image_name').value = image_name;
                };
                reader.readAsDataURL(input.files[0]);
                document.getElementById('person_image_message').innerHTML = '';
            }
        }
    } else {
        document.getElementById('image').innerHTML = '<span style="color:red;">Image Format will be JPG,PNG,GIF,BMP</span>';
    }
}
/*
 * @Function            : checkGenderStatus 
 * @Used IN             : user/teacher/add_teacher_organization_view
 * @Description         : used to clear error message
 * @Developed By        : Unknown
 * @Start DateTime      : Unknown
 * @Status              : available      
 */
function checkGenderStatus() {
    document.getElementById('person_gender_message').innerHTML = '';
}
/*
 * @Function            : checkPersonStatus 
 * @Used IN             : user/teacher/add_teacher_organization_view
 * @Description         : used to clear error message
 * @Developed By        : Unknown
 * @Start DateTime      : Unknown
 * @Status              : available      
 */
function checkPersonStatus() {
    document.getElementById('person_status_message').innerHTML = '';
}

//edit org teacher
/*
 * @Function            : getUrlValue  
 * @Used IN             : user/teacher/edit_teacher
 * @Description         : used to get url value
 * @Parameter           : first_name 
 *                        last_name 
 *                        typeurl (url value typed by user)
 *                        name_url (url location in where name info passed to check)
 *                        make_url (url location in where name info passed to make url)
 *                        check_url (url location in where url info passed to check valid url) 
 * @return              : none
 * @Developed By        : Unknown
 * @Updated             : Tania Akter
 * @Start DateTime      : 08-08-2016
 * @Status              : available      
 */
function getUrlValue(first_name, last_name, typeurl, name_url, make_url, check_url) {
    if (typeurl === '') {
        makeProfileID(first_name, last_name, make_url);
    } else {
        edit_checkProfileUrl(typeurl, check_url);
    }
   check_add_teacher_org_name(first_name, last_name, name_url);
}

/*
 * @Function            : makeProfileID   
 * @Used IN             : function[getUrlValue] js[add_teacher_organization] 
 * @Description         : used to make url
 * @Parameter           : personFirstName,
 *                        personLastName, 
 *                        url (url location)
 * @return              : none
 * @Developed By        : Tania Akter
 * @Start DateTime      : 08-08-2016
 * @Status              : available      
 */
function makeProfileID(personFirstName, personLastName, url) {
    if (personLastName === '') {
        profileID = personFirstName.toLowerCase();
    } else {
        profileID = personFirstName.toLowerCase() + '-' + personLastName.toLowerCase();
    }
    var profileID = checkUrlCharacter(profileID);
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("profileID", profileID);
    xmlhttp2.addEventListener("load", function () {    
        document.getElementById('profile_url').value = xmlhttp2.responseText;       
   
    }, false);
    xmlhttp2.addEventListener("error", function () {
        alert("There is some problem in your browser, not working");
    }, false);
    xmlhttp2.addEventListener("abort", function () {
        alert("There is some problem in your browser, aborted");
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}

/*
 * @Function            : edit_checkProfileUrl  
 * @Used IN             : function[getUrlValue] js[add_teacher_organization]
 * @Description         : used to check url
 * @Parameter           : given_text(typed url), url(url location)
 * @return              : none
 * @Developed By        : Tania Akter
 * @Start DateTime      : 08-08-2016
 * @Status              : available      
 */
function edit_checkProfileUrl(given_text, url) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("given_text", given_text);
    xmlhttp2.addEventListener("load", function () {
        if (xmlhttp2.responseText === 1)
        {
            document.getElementById('url_exist').value = '1';            
        } else if (xmlhttp2.responseText === 2)
        {
            document.getElementById('url_exist').value = '';            
        }
    }, false);
    xmlhttp2.addEventListener("error", function () {
        alert("There is some problem in your browser, not working");
    }, false);
    xmlhttp2.addEventListener("abort", function () {
        alert("There is some problem in your browser, aborted");
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}