function createXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}




function addForm(url) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('form_view').innerHTML = xmlhttp.responseText;
            $('select#tokenize_placeholder').tokenize({placeholder: "Please Type Group Name"});
        }
    };
    xmlhttp.send(null);
}

function getUrlWithMeta(value) {
//    var regex = /(http):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithHttp = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithoutHttp = /^(?:(ftp|http|https):\/\/)?(?:[\w-]+\.)+[a-z]{3,6}$/;

    if (regexWithHttp.test(value)) {
        var urls = value.match(regexWithHttp);
        var string = value.replace(regexWithHttp, '');
        checkURL(urls[0], string, 'note');
    } else if (regexWithoutHttp.test(value)) {
        var value1 = 'http://' + value;
        documentID('note_detail').value = value1;
        checkURL(value1, '', '');
    } else {
        return false;
    }
}

function getAlertUrlWithMeta(value) {
//    var regex = /(http):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithHttp = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithoutHttp = /^(?:(ftp|http|https):\/\/)?(?:[\w-]+\.)+[a-z]{3,6}$/;

    if (regexWithHttp.test(value)) {
        var urls = value.match(regexWithHttp);
        var string = value.replace(regexWithHttp, '');
        checkURL(urls[0], string, 'alert');
    } else if (regexWithoutHttp.test(value)) {
        var value1 = 'http://' + value;
        documentID('alert_detail').value = value1;
        checkURL(value1, '', '');
    } else {
        return false;
    }
}


/*
 * @Function            : getEditTextDetails 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : get edit text details
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 06-06-2016 10:18 AM 
 * @Parameter           : text[STRING], type[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getEditTextDetails(text, type) {
    if (documentID('url_status') === null) {
        var regexWithHttp = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
        var regexWithoutHttp = /^(?:(ftp|http|https):\/\/)?(?:[\w-]+\.)+[a-z]{3,6}$/;
        if (regexWithHttp.test(text)) {
            var urls = text.match(regexWithHttp);
            var string = text.replace(regexWithHttp, '');

            checkURL(urls[0], string, type);
        }
        if (regexWithoutHttp.test(text)) {
            var url = 'http://' + text;

            checkURL(url, '', type);
        }
    }
}



function checkURL(url, string, type) {
    var youTubeURl = checkYouTubeURL(url);
    if (youTubeURl === 'error') {
        var vimoURl = checkVimoURL(url);
        if (vimoURl === 'error') {
            showUrlView(url, string, type, 3);
        } else {
            showUrlView(vimoURl, string, type, 2);
        }
    } else {
        showUrlView(youTubeURl, string, type, 1);
    }
}

function checkYouTubeURL(url) {
    var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
    if (url.match(regExp)) {
        var match = url.match(regExp);
        if (match && match[2].length === 11) {
            return match[2];
        } else {
            return 'error';
        }
    } else {
        return 'error';
    }
}

function checkVimoURL(url) {
    var vimeoRegex = /(?:vimeo)\.com.*(?:videos|video|channels|)\/([\d]+)/i;
    if (url.match(vimeoRegex)) {
        var parsed = url.match(vimeoRegex);
        return parsed[1];
    } else {
        return 'error';
    }

}


function showUrlView(url, string, type, urlType) {
    var urlViewResponse;
    urlViewResponse = createXMLHTTP(urlViewResponse);
    var baseUrl = $('#baseUrl').val();
    var serverUrl = baseUrl + 'post/show_view_url/post';

    documentID('URLview').style.display = 'block';
    documentID('loadingImage').style.visibility = 'visible';
    documentID("btn").disabled = true;
    if (documentID('note_detail')) {
        documentID('note_detail').disabled = true;
    } else if (documentID("alert_detail")) {
        documentID("alert_detail").disabled = true;
    }

    var formdata = new FormData();
    formdata.append("url", url);
    formdata.append("url_type", urlType);

    urlViewResponse.addEventListener("load", function () {
        documentID('loadingImage').style.visibility = 'hidden';
        documentID("btn").disabled = false;
        if (documentID("note_detail")) {
            documentID("note_detail").disabled = false;
        } else if (documentID("alert_detail")) {
            documentID("alert_detail").disabled = false;
        }

        documentID('check_url_status').value = 2;
        documentID('URLviewResponse').innerHTML = '';
        documentID('URLviewResponse').innerHTML = urlViewResponse.responseText;
        if (type === 'note') {
            documentID('note_detail').value = string;
        } else if (type === 'alert') {
            documentID('alert_detail').value = string;
        }

    }, false);
    urlViewResponse.open("POST", serverUrl);
    urlViewResponse.send(formdata);
}


function viewMorePost(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID(ID).innerHTML = xmlhttp.responseText;

            var hiddenID = documentID('hiddin_post_video_id').value;
            var hiddenURL = documentID('hiddin_post_video_url').value;

            var videoID = hiddenID.split('##');
            var videoURL = hiddenURL.split('##');

            for (var i = 0; i < videoID.length - 1; i++) {
                var vURL = videoURL[i];
                var subtitlePath = "";
                var playerID = 'video_player' + videoID[i];
                loaded(vURL, subtitlePath, playerID);
            }
        }
    };
    xmlhttp.send(null);
}

function compareArray(myArray, globalArray) {
    for (i = 0; i < myArray.length; i++) {
        if (globalArray.indexOf(myArray[i]) > -1) {
            continue;
        } else {
            return 0;
            break;
        }
    }
}

function stringToArray(string) {
    var newArray = new Array();
    var stringSplit = string.split(',');
    for (var i = 0; i < stringSplit.length - 1; i++) {
        newArray.push(stringSplit[i]);
    }
    return newArray;
}


function groupText(givenText) {
    var GroupForm = documentID('GroupForm');
    if (givenText == 4) {
        GroupForm.setAttribute('style', 'display:block');
    } else {
        GroupForm.setAttribute('style', 'display:none');
        documentID('group_error').innerHTML = '';
    }
}

function getPublicationStatus(value) {
    if (value === '1') {
        documentID('status_green').innerHTML = 'Publication status:';
        documentID('status_red').innerHTML = 'Public';
    } else if (value === '2') {
        documentID('status_green').innerHTML = 'Publication status:';
        documentID('status_red').innerHTML = 'TT User';
    } else if (value === '4') {
        documentID('status_green').innerHTML = 'Publication status:';
        documentID('status_red').innerHTML = 'Group';
    } else if (value === '3') {
        documentID('status_green').innerHTML = 'Publication status:';
        documentID('status_red').innerHTML = 'Link';
    }
    documentID('publication_status').value = value;
    groupText(value);
}

function viewDetails(url, htmlID, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID(htmlID + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}


function addNote(url) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    var selectGroupArray = new Array();

    var post_type = documentID('post_type').value;
    var note_detail1 = (documentID('note_detail').value).trim().replace(/\n/gm, '@br@');
    var timeZone = documentID('timeZone').value;
    var selected_group = documentID('to_address').value;
    var note_detail;

    //---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status').value === '2') {
        postUrlInfo = getPostUrlMetaData(postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------

    if (documentID('check_url_status').value === '1') {
        note_detail = note_detail1.replace(/  +/g, '');
        if (note_detail === '') {
            documentID('note_detail_error').innerHTML = "Please write your note";
            return false;
        } else {
            documentID('note_detail_error').innerHTML = "";
        }
    } else if ((documentID('check_url_status').value === '2')) {
        note_detail = note_detail1.replace(/  +/g, '');
    }

    var viewStatus = documentID('publication_status').value;
    if (viewStatus === '') {
        documentID('status_green').innerHTML = "<span style='color:red'>Please select publication Status</span>";
        return false;
    } else {
        documentID('status_green').innerHTML = "";
    }

    if (viewStatus == 4) {
        if (selected_group == '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selected_group);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    var formdata = new FormData();
    formdata.append("post_details", note_detail);
    formdata.append("post_publication_status", viewStatus);
    formdata.append("post_type", post_type);
    formdata.append("time_zone", timeZone);
    formdata.append("post_url_info", postUrlInfo);
    if (viewStatus == 4) {
        formdata.append("selected_group", selected_group);
    }
//
    xmlhttp.addEventListener("load", function () {

        documentID('form_view').innerHTML = '';
        documentID('main_view').innerHTML = xmlhttp.responseText;

        var hiddenID = documentID('hiddin_post_video_id').value;
        var hiddenURL = documentID('hiddin_post_video_url').value;

        var videoID = hiddenID.split('##');
        var videoURL = hiddenURL.split('##');

        for (var i = 0; i < videoID.length - 1; i++) {
            var vURL = videoURL[i];
            var subtitlePath = "";
            var playerID = 'video_player' + videoID[i];
            loaded(vURL, subtitlePath, playerID);
        }
    }, false);
    xmlhttp.addEventListener("error", function () {
        alert("Upload Failed");
    }, false);
    xmlhttp.addEventListener("abort", function () {
        alert("Upload Aborted");
    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
    return true;
}


/*
 * @Function            : updateNote 
 * @Used IN             : @function-'view/user/post_ajax/edit_post_from.php
 * @Description         : update note
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 06-06-2016 12:46 PM 
 * @Parameter           : url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateNote(url, postID) {
    var noteDetail = '';
    var selectGroupArray = new Array();
    var noteDetail1 = (documentID('note_detail').value).trim().replace(/\n/gm, '@br@');

    if (documentID('check_url_status').value === '1') {
        noteDetail = noteDetail1.replace(/  +/g, '');
        if (noteDetail === '') {
            documentID('note_detail_error').innerHTML = "Please write your note";
            return false;
        } else {
            documentID('note_detail_error').innerHTML = "";
        }
    } else if ((documentID('check_url_status').value === '2')) {
        noteDetail = noteDetail1.replace(/  +/g, '');
    }

    //---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status').value === '2') {
        postUrlInfo = getPostUrlMetaData(postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------
    var publicationStatus = documentID('publication_status').value;
    var selectedGroup = '';

    if (publicationStatus === '4') {
        selectedGroup = documentID('to_address').value;
        if (selectedGroup === '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selectedGroup);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    updatePostDetails(url, postID, noteDetail, postUrlInfo, publicationStatus, selectedGroup);
}



/*
 * @Function            : updateAlert 
 * @Used IN             : @function-'view/user/post_ajax/edit_post_from.php
 * @Description         : Update alert
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 07-06-2016 01:46 PM 
 * @Parameter           : url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateAlert(url, postID) {
    var alertDetail = '';
    var alertDetail1 = (documentID('alert_detail').value).replace(/\n/gm, '@br@');
    if (documentID('check_url_status').value === '1') {
        alertDetail = alertDetail1.replace(/  +/g, '');
        if (alertDetail === '') {
            documentID('alert_detail_error').innerHTML = "Please write your Alert";
            return false;
        } else {
            documentID('alert_detail_error').innerHTML = "";
        }
    } else if ((documentID('check_url_status').value === '2')) {
        alertDetail = alertDetail1.replace(/  +/g, '');
    }

    //---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status').value === '2') {
        postUrlInfo = getPostUrlMetaData(postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------
    var selectGroupArray = new Array();
    var publicationStatus = documentID('publication_status').value;
    var selectedGroup = '';

    if (publicationStatus === '4') {
        selectedGroup = documentID('to_address').value;
        if (selectedGroup === '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selectedGroup);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    updatePostDetails(url, postID, alertDetail, postUrlInfo, publicationStatus, selectedGroup);
}

/*
 * @Function            : updatePostDetails 
 * @Used IN             : @function-'updateNote'    @home.js
 * @Description         : update post details
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 06-06-2016 12:47 PM 
 * @Parameter           : noteDetail[STRING], postUrlInfo[STRING], publicationStatus[STRING], selectedGroup[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function updatePostDetails(url, postID, postDetail, postUrlInfo, publicationStatus, selectedGroup) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var formdata = new FormData();
    formdata.append("post_id", postID);
    formdata.append("post_details", postDetail);
    formdata.append("post_publication_status", publicationStatus);
    formdata.append("post_url_info", postUrlInfo);
    formdata.append("selected_group", selectedGroup);

    xmlhttp.addEventListener("load", function () {
        var obj = JSON.parse(xmlhttp.responseText);
        var redirectUrl = obj.base_url + obj.view_page + '/' + obj.encrypted_post_id + '/' + obj.type;
        window.location.href = redirectUrl;

    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}



/*
 * @Function            : getPostUrlMetaData 
 * @Used IN             : @function-'updateNote'   @home.js
 * @Description         : get post meta URL
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 06-06-2016 12:21 PM 
 * @Parameter           : postUrlInfo[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function getPostUrlMetaData(postUrlInfo) {
    if (documentID('url').value === '') {
        postUrlInfo = 'URL: ';
    } else {
        postUrlInfo = 'URL: ' + documentID('url').value;
    }

    if (documentID('title').value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('title').value;
    }

    if (documentID('description').value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('description').value;
    }

    if (documentID('author').value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('author').value;
    }
    return postUrlInfo;
}

function addAlert(url) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    var selectGroupArray = new Array();

    var postType = documentID('post_type').value;
    var alertDetail1 = (documentID('alert_detail').value).replace(/\n/gm, '@br@');
    var timeZone = documentID('timeZone').value;
    var selected_group = documentID('to_address').value;
    var alertDetail;
    var postUrlInfo = '';


//---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status').value === '2') {
        postUrlInfo = getPostUrlMetaData(postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------

    if (documentID('check_url_status').value === '1') {
        alertDetail = alertDetail1.replace(/  +/g, '');
        if (alertDetail === '') {
            documentID('alert_detail_error').innerHTML = "Please write your note";
            return false;
        } else {
            documentID('alert_detail_error').innerHTML = "";
        }
    } else if ((documentID('check_url_status').value === '2')) {
        alertDetail = alertDetail1.replace(/  +/g, '');
    }


    var viewStatus = documentID('publication_status').value;
    if (viewStatus === '') {
        documentID('status_green').innerHTML = "<span style='color:red'>Please select publication Status</span>";
        return false;
    } else {
        documentID('status_green').innerHTML = "";
    }

    if (viewStatus == 4) {
        if (selected_group == '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selected_group);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    var formdata = new FormData();
    formdata.append("post_details", alertDetail);
    formdata.append("post_publication_status", viewStatus);
    formdata.append("post_type", postType);
    formdata.append("time_zone", timeZone);
    formdata.append("post_url_info", postUrlInfo);

    if (viewStatus == 4) {
        formdata.append("selected_group", selected_group);
    }

    xmlhttp.addEventListener("load", function () {
        documentID('form_view').innerHTML = '';
        documentID('main_view').innerHTML = xmlhttp.responseText;

        var hiddenID = documentID('hiddin_post_video_id').value;
        var hiddenURL = documentID('hiddin_post_video_url').value;

        var videoID = hiddenID.split('##');
        var videoURL = hiddenURL.split('##');

        for (var i = 0; i < videoID.length - 1; i++) {
            var vURL = videoURL[i];
            var subtitlePath = "";
            var playerID = 'video_player' + videoID[i];
            loaded(vURL, subtitlePath, playerID);
        }
    }, false);
    xmlhttp.addEventListener("error", function () {
        alert("Upload Failed");
    }, false);
    xmlhttp.addEventListener("abort", function () {
        alert("Upload Aborted");
    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
    return true;
}


function getAssignmentFileName(inputFile) {
    var ext;
    var allowedFileType = "zip rar pdf doc docx xls xlsx pptx ppt txt";
    if (documentID('upload_status').value === '1') {
        documentID('upload_status').value = '';
    }

    var file = inputFile.files[0];
    var fileName = file.name;
    var fileExtention = ext = fileName.split('.').pop().toLowerCase();
    var n = allowedFileType.search(fileExtention);
    if (n > -1) {
        if (file.size < 52428800) {
            uploadAssignmentFile(inputFile);

            documentID('file_name').value = fileName;
            documentID('assignment_file_error').innerHTML = '';
        } else {
            documentID('assignment_file_error').innerHTML = 'File size must less then 50 Mb';
            documentID('file_name').value = '';
            documentID('assignment_file').value = '';
        }
    } else {
        documentID('assignment_file_error').innerHTML = 'Please select assignment type: zip, rar, pdf, doc, docx, xls, xlsx, pptx, ppt, txt';
        documentID('file_name').value = '';
        documentID('assignment_file').value = '';
    }
}

function uploadAssignmentFile(inputFile) {
    var assaingnmentReposse;
    assaingnmentReposse = createXMLHTTP(assaingnmentReposse);
    var baseurl = $('#baseUrl').val();
    var serverUrl = baseurl + 'upload-assignment';

    var file = inputFile.files[0];
    if (file) {
        var recentWorkFileID = documentID('hidden_uploaded_file_id').value;

        var formdata = new FormData();
        formdata.append("assignment_file", file);
        formdata.append("uploaded_file_id", recentWorkFileID);

        assaingnmentReposse.upload.addEventListener("progress", function (event) {
            var percent = (event.loaded / event.total) * 100;
            documentID("progressBar").setAttribute('style', 'width:' + Math.round(percent) + '%');

            if (Math.round(percent) === 100) {
                documentID('upload_status').value = '1';
            }
        }, false);

        assaingnmentReposse.addEventListener("load", function () {

            if (assaingnmentReposse.responseText === 'error_location') {
                documentID('assignment_file_error').innerHTML = 'File Location does not exists';
                documentID('file_name').value = '';
                documentID('assignment_file').value = '';
            } else if (assaingnmentReposse.responseText === 'error_size_zero') {
                documentID('assignment_file_error').innerHTML = 'File Size is Zero';
                documentID('file_name').value = '';
                documentID('assignment_file').value = '';
            } else if (assaingnmentReposse.responseText === 'error_size') {
                documentID('assignment_file_error').innerHTML = 'File size must less then 50 Mb';
                documentID('file_name').value = '';
                documentID('assignment_file').value = '';
            } else if (assaingnmentReposse.responseText === 'error_type') {
                documentID('assignment_file_error').innerHTML = 'Invalid File Type';
                documentID('file_name').value = '';
                documentID('assignment_file').value = '';
            } else {
                documentID("hidden_uploaded_file_id").value = assaingnmentReposse.responseText;
                documentID('assignment_file_error').innerHTML = '';
            }

        }, false);
        assaingnmentReposse.addEventListener("error", function () {
            documentID("progressbar").innerHTML = "Upload Failed";
        }, false);
        assaingnmentReposse.addEventListener("abort", function () {
            documentID("progressbar").innerHTML = "Upload Aborted";
        }, false);
        assaingnmentReposse.open("POST", serverUrl);
        assaingnmentReposse.send(formdata);
    }
}


/*
 * @Function            : getEditAssignmentFile 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 08:43 AM 
 * @Parameter           : file[FILE], url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function getEditAssignmentFile(file, url, postID) {
    if (documentID('assignment_file_upload_status').value !== '2') {
        var file1 = file.files[0];
        var fileName = file1.name;
        var allowedFileType = "zip rar pdf doc docx xls xlsx pptx ppt txt";
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var n = allowedFileType.search(fileExtention);
        if (n > -1) {
            if (file1.size < 52428800) {

                uploadEditAssignmentFile(file1, url, postID);

                documentID('file_name').value = fileName;
                documentID('assignment_file_error').innerHTML = '';
            } else {
                var fileError = 'File size must less then 50 Mb';
                getEditAssignmentFileError(fileError, '', '', 3);
            }
        } else {
            var fileError = 'Please select assignment type: zip, rar, pdf, doc, docx, xls, xlsx, pptx, ppt, txt';
            getEditAssignmentFileError(fileError, '', '', 3);
        }
    } else {
        var fileError = 'Please wait while uploading';
        getEditAssignmentFileError(fileError, '', '', 2);
    }
}


/*
 * @Function            : uploadEditAssignmentFile 
 * @Used IN             : @function-'getEditAssignmentFile'    @home.js 
 * @Description         : get edit upload assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 08:48 AM 
 * @Parameter           : file[FILE], url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function uploadEditAssignmentFile(file, url, postID) {
    var assaingnmentReposse;
    assaingnmentReposse = createXMLHTTP(assaingnmentReposse);

    var formdata = new FormData();
    formdata.append("assignment_file", file);
    formdata.append("post_id", postID);

    assaingnmentReposse.upload.addEventListener("progress", function (event) {
        documentID('viewProgressBar').style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID("progressBar").setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('assignment_file_upload_status').value = '1';
        } else {
            documentID('assignment_file_upload_status').value = '2';
        }

    }, false);

    assaingnmentReposse.addEventListener("load", function () {

        if (assaingnmentReposse.responseText === 'error_location') {
            var fileError = 'File Location does not exists';
            getEditAssignmentFileError(fileError, '', '', 3);
        } else if (assaingnmentReposse.responseText === 'error_size_zero') {
            var fileError = 'File Size is Zero';
            getEditAssignmentFileError(fileError, '', '', 3);
        } else if (assaingnmentReposse.responseText === 'error_size') {
            var fileError = 'File size must less then 50 Mb';
            getEditAssignmentFileError(fileError, '', '', 3);
        } else if (assaingnmentReposse.responseText === 'error_type') {
            var fileError = 'Invalid File Type';
            getEditAssignmentFileError(fileError, '', '', 3);
        } else {
            documentID('assignment_file_error').innerHTML = '';
            documentID('assignment_file').value = '';
        }

    }, false);
    assaingnmentReposse.open("POST", url);
    assaingnmentReposse.send(formdata);
}


/*
 * @Function            : getEditAssignmentFileError 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 07-06-2016 03:00 PM 
 * @Parameter           : fileError[STRING], value1[STRING], value2[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getEditAssignmentFileError(fileError, value1, value2, status) {
    documentID('assignment_file_error').innerHTML = fileError;
    documentID('file_name').value = value1;
    documentID('assignment_file').value = value2;
    documentID('assignment_file_upload_status').value = status;
}


function addAssignment(url) {
    if (documentID('upload_status').value === '1') {
        if (documentID('hidden_uploaded_file_id').value !== '') {
            var assaingnmentReposse1;
            assaingnmentReposse1 = createXMLHTTP(assaingnmentReposse1);
            var selectGroupArray = new Array();

            var assignmentFile = documentID('assignment_file').value;
            var selected_group = documentID('to_address').value;

            var viewStatus = documentID('publication_status').value;
            if (viewStatus === '4') {
                if (selected_group === '') {
                    documentID('status_green').innerHTML = 'Publication status:';
                    documentID('group_error').innerHTML = "Group Name is Required";
                    return false;
                } else {
                    documentID('group_error').innerHTML = "";
                    selectGroupArray = stringToArray(selected_group);
                    if (compareArray(selectGroupArray, allGroupId) === 0) {
                        documentID('group_error').innerHTML = "Please enter valid group name";
                        return false;
                    } else {
                        documentID('group_error').innerHTML = "";
                    }
                }
            }

            if (assignmentFile === '') {
                documentID('assignment_file_error').innerHTML = "Please add your assignment file";
                return false;
            } else {
                documentID('assignment_file_error').innerHTML = "";
            }
            if (viewStatus === '') {
                documentID('status_green').innerHTML = "<span style='color:red'>Please select publication Status</span>";
                return false;
            } else {
                documentID('status_green').innerHTML = "";
            }

            var file_upload_id = documentID('hidden_uploaded_file_id').value;

            var postViewStatus = (viewStatus === '') ? 1 : viewStatus;

            var formdata = new FormData();
            formdata.append("post_publication_status", postViewStatus);
            formdata.append("file_upload_id", file_upload_id);

            if (postViewStatus === '4') {
                formdata.append("selected_group", selected_group);
            }

            assaingnmentReposse1.addEventListener("load", function () {
                documentID('form_view').innerHTML = '';
                documentID('main_view').innerHTML = assaingnmentReposse1.responseText;

                var hiddenID = documentID('hiddin_post_video_id').value;
                var hiddenURL = documentID('hiddin_post_video_url').value;

                var videoID = hiddenID.split('##');
                var videoURL = hiddenURL.split('##');

                for (var i = 0; i < videoID.length - 1; i++) {
                    var vURL = videoURL[i];
                    var subtitlePath = "";
                    var playerID = 'video_player' + videoID[i];
                    loaded(vURL, subtitlePath, playerID);
                }
            }, false);
            assaingnmentReposse1.addEventListener("error", function () {
                alert("Upload Failed");
            }, false);
            assaingnmentReposse1.addEventListener("abort", function () {
                alert("Upload Aborted");
            }, false);

            assaingnmentReposse1.open("POST", url);
            assaingnmentReposse1.send(formdata);
            return true;
        } else {
            documentID('upload_status_error').innerHTML = 'Please wait while complete uploading';
        }
    } else {
        documentID('upload_status_error').innerHTML = 'Please wait while complete uploading';
    }
}


/*
 * @Function            : updateAssignment 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 09:40 AM 
 * @Parameter           : url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateAssignment(url, postID) {
    var uploadStatus = documentID('assignment_file_upload_status').value;
    if (uploadStatus !== '1') {
        documentID('assignment_file_error').innerHTML = "Please add your assignment file";
        return false;
    } else {
        documentID('assignment_file_error').innerHTML = "";
    }

    var selectGroupArray = new Array();
    var publicationStatus = documentID('publication_status').value;
    var selectedGroup = '';

    if (publicationStatus === '4') {
        selectedGroup = documentID('to_address').value;
        if (selectedGroup === '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selectedGroup);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    updateFilePostDetails(url, postID, publicationStatus, selectedGroup);
    return true;
}



/*
 * @Function            : updateFilePostDetails 
 * @Used IN             : @function-'updateAssignment'   @home.js
 * @Description         : update post file details
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 09:58 AM 
 * @Parameter           : url[STRING], postID[INTEGER], publicationStatus[INTEGER], selectedGroup[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateFilePostDetails(url, postID, publicationStatus, selectedGroup) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var formdata = new FormData();
    formdata.append("post_id", postID);
    formdata.append("post_publication_status", publicationStatus);
    formdata.append("selected_group", selectedGroup);

    xmlhttp.addEventListener("load", function () {

        var obj = JSON.parse(xmlhttp.responseText);
        var redirectUrl = obj.base_url + obj.view_page + '/' + obj.encrypted_post_id + '/' + obj.type;
        window.location.href = redirectUrl;

    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}

//----------------------------Start Image and Vedio file Management-----------------------

function uploadImageVedioFile(inputFile, postType, url) {
    var imageVedioReposse;
    imageVedioReposse = createXMLHTTP(imageVedioReposse);

    var file = inputFile.files[0];
    if (file) {
        var uploaded_imageVedio_id = documentID('hidden_uploaded_imageVedio_id').value;

        var formdata = new FormData();
        formdata.append("imagevediofile", file);
        formdata.append("post_type", postType);
        formdata.append("uploaded_imageVedio_id", uploaded_imageVedio_id);

        imageVedioReposse.upload.addEventListener("progress", function (event) {
            var percent = (event.loaded / event.total) * 100;
            documentID("progressBar").setAttribute('style', 'width:' + Math.round(percent) + '%');

            if (Math.round(percent) === 100) {
                documentID('imageVideo_upload_status').value = '1';
                $("button[id=btn]").attr('disabled', true);
                documentID('post_processing_image').style.display = 'block';
            }
        }, false);

        imageVedioReposse.addEventListener("load", function () {
            documentID('post_processing_image').style.display = 'none';
            $("button[id=btn]").attr('disabled', false);
            if (imageVedioReposse.responseText === 'error') {
                documentID('image_div').style.display = 'none';
                documentID('image_src').setAttribute('src', '');
                documentID('image_video_file_error').innerHTML = 'File is not valid';
                documentID('file_name').value = '';
                documentID('image_video_file').value = '';
                documentID("progressBar").setAttribute('style', 'width:' + 0 + '%');
            } else {
                documentID("hidden_uploaded_imageVedio_id").value = imageVedioReposse.responseText;
            }

        }, false);
        imageVedioReposse.open("POST", url);
        imageVedioReposse.send(formdata);
    }
}

function getImageVideoFileName(inputFile, url) {
    if (documentID('imageVideo_upload_status').value === '1') {
        documentID('imageVideo_upload_status').value = '';
    }

    var allowedFileType = "mp4 flv 3gp avi webm wmv jpeg gif png bmp jpg";
    var file = inputFile.files[0];
    var fileName = file.name;
    var fileExtention = fileName.split('.').pop().toLowerCase();
    var n = allowedFileType.search(fileExtention);
    if (n > -1) {
        var allowedImageFileType = "jpeg gif png bmp jpg";
        var allowedVedioFileType = "mp4 flv 3gp avi webm wmv";
        var nImage = allowedImageFileType.search(fileExtention);
        var nVedio = allowedVedioFileType.search(fileExtention);

        if (nImage > -1) {
            if (file.size < 2097152) {
                uploadImageVedioFile(inputFile, 4, url);

                documentID('image_div').style.display = 'block';
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#image_src')
                            .attr('src', e.target.result);
                };
                reader.readAsDataURL(inputFile.files[0]);
                documentID('file_name').value = fileName;
                documentID('image_video_file_error').innerHTML = '';

            } else {
                documentID('image_div').style.display = 'none';
                documentID('image_src').setAttribute('src', '');
                documentID('image_video_file_error').innerHTML = 'Image size must less then 2 Mb';
                documentID('file_name').value = '';
                documentID('image_video_file').value = '';
            }
        } else if (nVedio > -1) {
            if (file.size < 600000000) {

                uploadImageVedioFile(inputFile, 5, url);

                documentID('image_div').style.display = 'none';
                documentID('image_src').setAttribute('src', '');
                documentID('file_name').value = fileName;
                documentID('image_video_file_error').innerHTML = '';

            } else {
                documentID('image_div').style.display = 'none';
                documentID('image_src').setAttribute('src', '');
                documentID('image_video_file_error').innerHTML = 'Video size must less then 500 Mb';
                documentID('file_name').value = '';
                documentID('image_video_file').value = '';
            }
        }
    } else {
        documentID('image_div').style.display = 'none';
        documentID('image_src').setAttribute('src', '');
        documentID('image_video_file_error').innerHTML = 'Plesese Select Valid Image/Video File';
        documentID('file_name').value = '';
        documentID('image_video_file').value = '';
    }
}


/*
 * @Function            : getEditImageVideoFile 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 07-06-2016 03:00 PM 
 * @Parameter           : file[FILE], url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function getEditImageVideoFile(inputFile, url, postID) {
    if (documentID('image_video_file_upload_status').value !== '2') {
        var allowedFileType = "mp4 flv 3gp avi webm wmv jpeg gif png bmp jpg";
        var file = inputFile.files[0];
        var fileName = file.name;
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var n = allowedFileType.search(fileExtention);
        if (n > -1) {
            var allowedImageFileType = "jpeg gif png bmp jpg";
            var allowedVedioFileType = "mp4 flv 3gp avi webm wmv";
            var nImage = allowedImageFileType.search(fileExtention);
            var nVedio = allowedVedioFileType.search(fileExtention);

            if (nImage > -1) {
                if (file.size < 2097152) {

                    uploadEditImageVedioFile(file, 4, url, postID);

                    documentID('image_div').style.display = 'block';
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#image_src')
                                .attr('src', e.target.result);
                    };
                    reader.readAsDataURL(inputFile.files[0]);
                    documentID('file_name').value = fileName;
                    documentID('image_video_file_error').innerHTML = '';

                } else {
                    var errorMessage = 'Image size must less then 2 Mb';
                    getEditImageVideoFileError(errorMessage, 3);
                }
            } else if (nVedio > -1) {
                if (file.size < 26214400) {

                    uploadEditImageVedioFile(file, 5, url, postID);

                    documentID('image_div').style.display = 'none';
                    documentID('image_src').setAttribute('src', '');
                    documentID('file_name').value = fileName;
                    documentID('image_video_file_error').innerHTML = '';

                } else {
                    var errorMessage = 'Video size must less then 25 Mb';
                    getEditImageVideoFileError(errorMessage, 3);
                }
            }
        } else {
            var errorMessage = 'Plesese Select Valid Image/Video File';
            getEditImageVideoFileError(errorMessage, 3);
        }
    } else {
        var errorMessage = 'Please wait while uploading';
        getEditImageVideoFileError(errorMessage, 2);
    }
}

/*
 * @Function            : uploadEditImageVedioFile 
 * @Used IN             : @function-'getEditImageVideoFile'    this@js
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 10:41 AM 
 * @Parameter           : file[FILE], postType[INTEGER], url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function uploadEditImageVedioFile(file, postType, url, postID) {
    var assaingnmentReposse;
    assaingnmentReposse = createXMLHTTP(assaingnmentReposse);

    var formdata = new FormData();
    formdata.append("image_video_file", file);
    formdata.append("post_id", postID);
    formdata.append("post_type", postType);

    assaingnmentReposse.upload.addEventListener("progress", function (event) {
        documentID('viewProgressBar').style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID("progressBar").setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('image_video_file_upload_status').value = '1';
            $("button[id=btn]").attr('disabled', true);
            documentID('post_processing_image').style.display = 'block';
        } else {
            documentID('image_video_file_upload_status').value = '2';
        }

    }, false);

    assaingnmentReposse.addEventListener("load", function () {
        $("button[id=btn]").attr('disabled', false);
        documentID('post_processing_image').style.display = 'none';
        if (assaingnmentReposse.responseText === 'error_location') {
            var errorMessage = 'File Location does not exists';
            getEditImageVideoFileError(errorMessage, 3);
        } else if (assaingnmentReposse.responseText === 'error_type') {
            var errorMessage = 'Invalid File Type';
            getEditImageVideoFileError(errorMessage, 3);
        } else if (assaingnmentReposse.responseText === 'error_validation') {
            var errorMessage = 'Invalid Image/Video File';
            getEditImageVideoFileError(errorMessage, 3);
        } else if (assaingnmentReposse.responseText === 'error_size_zero') {
            var errorMessage = 'File Size is Zero';
            getEditImageVideoFileError(errorMessage, 3);
        } else if (assaingnmentReposse.responseText === 'error_size_image') {
            var errorMessage = 'Image size must less then 2 Mb';
            getEditImageVideoFileError(errorMessage, 3);
        } else if (assaingnmentReposse.responseText === 'error_size_video') {
            var errorMessage = 'Image size must less then 25 Mb';
            getEditImageVideoFileError(errorMessage, 3);
        } else {
            documentID('image_video_file_error').innerHTML = '';
            documentID('image_video_file').value = '';
        }

    }, false);
    assaingnmentReposse.open("POST", url);
    assaingnmentReposse.send(formdata);
}

/*
 * @Function            : getEditImageVideoFileError 
 * @Used IN             : @function-'getEditImageVideoFile'    this@js
 * @Description         : get edit assignment file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 07-06-2016 03:36 PM 
 * @Parameter           : errorMessage[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getEditImageVideoFileError(errorMessage, status) {
    documentID('viewProgressBar').style.display = 'none';
    documentID('image_div').style.display = 'none';
    documentID('image_src').setAttribute('src', '');
    documentID('image_video_file_error').innerHTML = errorMessage;
    documentID('file_name').value = '';
    documentID('image_video_file').value = '';
    documentID('image_video_file_upload_status').value = status;
}

function addImageVedio(url) {
    if (documentID('imageVideo_upload_status').value === '1') {
        var imageVedioReposse1;
        imageVedioReposse1 = createXMLHTTP(imageVedioReposse1);
        var selectGroupArray = new Array();

        var imageVideoFile = documentID('image_video_file').value;
        var selected_group = documentID('to_address').value;
        var viewStatus = documentID('publication_status').value;
        var file_name = documentID('file_name').value;

        if (imageVideoFile === '') {
            documentID('image_video_file_error').innerHTML = "Please select Image or vedio file";
            return false;
        } else {
            documentID('image_video_file_error').innerHTML = "";
        }
        if (viewStatus === '') {
            documentID('status_green').innerHTML = "<span style='color:red'>Please select publication Status</span>";
            return false;
        } else {
            documentID('status_green').innerHTML = "";
        }

        if (viewStatus === '4') {
            if (selected_group === '') {
                documentID('status_green').innerHTML = 'Publication status:';
                documentID('group_error').innerHTML = "Group Name is Required";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
                selectGroupArray = stringToArray(selected_group);
                if (compareArray(selectGroupArray, allGroupId) === 0) {
                    documentID('group_error').innerHTML = "Please enter valid group name";
                    return false;
                } else {
                    documentID('group_error').innerHTML = "";
                }
            }
        }

        var file_upload_id = documentID('hidden_uploaded_imageVedio_id').value;

        var formdata = new FormData();
        formdata.append("post_publication_status", viewStatus);
        formdata.append("file_name", file_name);
        formdata.append("file_upload_id", file_upload_id);

        if (viewStatus === '4') {
            formdata.append("selected_group", selected_group);
        }

        imageVedioReposse1.addEventListener("load", function () {
            console.log('in function');
            documentID('form_view').innerHTML = '';
            documentID('main_view').innerHTML = imageVedioReposse1.responseText;
            plyr.setup();

        }, false);

        imageVedioReposse1.open("POST", url);
        imageVedioReposse1.send(formdata);
        return true;
    } else {
        documentID('imageVideo_upload_status_error').innerHTML = 'Please wait while complete uploading';
    }
}


/*
 * @Function            : updateImageVideo 
 * @Used IN             : @function-'user/post_ajax/edit_post_from.php'
 * @Description         : update image video 
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-06-2016 11:53 AM 
 * @Parameter           : url[STRING], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function updateImageVideo(url, postID) {
    var uploadStatus = documentID('image_video_file_upload_status').value;
    if (uploadStatus !== '1') {
        documentID('image_video_file_error').innerHTML = "Please add your Image/Video file";
        return false;
    } else {
        documentID('image_video_file_error').innerHTML = "";
    }

    var selectGroupArray = new Array();
    var publicationStatus = documentID('publication_status').value;
    var selectedGroup = '';

    if (publicationStatus === '4') {
        selectedGroup = documentID('to_address').value;
        if (selectedGroup === '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selectedGroup);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    updateFilePostDetails(url, postID, publicationStatus, selectedGroup);
    return true;
}

//----------------------------End Image and Vedio file Management-----------------------


//---------------------------Start Like , Comments & Add to Libraary-----------------

function getLikeValue(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var serverPage = url;
    xmlhttp.open("GET", serverPage);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('action' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

function libraryAction(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID('action' + ID).innerHTML = xmlhttp.responseText;
        }
    }
    xmlhttp.send(null);
}


/*
 * @Function            : addWriteForm 
 * @Used IN             : @function-'view/user/home.php
 * @Description         : add post write form
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 11:47 AM 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function addWriteForm(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var serverPage = url;
    xmlhttp.open("GET", serverPage);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('add_write_form' + ID).style.display = 'block';
            documentID('add_write_form' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

function getCommentUrl(value, type, ID) {
    var urls;
    var string;
//    var regex = /(http):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithHttp = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    var regexWithoutHttp = /^(?:(ftp|http|https):\/\/)?(?:[\w-]+\.)+[a-z]{3,6}$/;

    if (regexWithHttp.test(value)) {
        var urls = value.match(regexWithHttp);
        var string = value.replace(regexWithHttp, '');

        checkCommentURL(urls[0], string, type, ID);
//        if (regex.test(value)) {
//            urls = value.match(regex);
//            string = value.replace(regex, '');
//            return showCommentUrlView(urls[0], string, type, ID);
//        } else {
//            if (type === 'comment') {
//                documentID('comment1' + ID).value = "";
//                documentID('comment1' + ID).placeholder = "Please type valid URL";
//            } else if (type === 'comment_reply') {
//                documentID('replay_comment' + ID).value = "";
//                documentID('replay_comment' + ID).placeholder = "Please type valid URL";
//            } else if (type === 'nested_reply') {
//                documentID('nested_reply' + ID).value = "";
//                documentID('nested_reply' + ID).placeholder = "Please type valid URL";
//            }
//        }
    } else if (regexWithoutHttp.test(value)) {
        urls = 'http://' + value;
        string = '';
        return showCommentUrlView(urls, string, type, ID);
    } else {
        return false;
    }
}

function checkCommentURL(url, string, type, postID) {
    var youTubeURl = checkYouTubeURL(url);
    if (youTubeURl === 'error') {
        var vimoURl = checkVimoURL(url);
        if (vimoURl === 'error') {
            showCommentUrlView(url, string, type, postID, 3);
        } else {
            showCommentUrlView(vimoURl, string, type, postID, 2);
        }
    } else {
        showCommentUrlView(youTubeURl, string, type, postID, 1);
    }
}

function showCommentUrlView(url, string, type, postID, videoType) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var baseurl = $('#baseUrl').val();
    var serverUrl = baseurl + 'post/show_view_url/comment';

    var commentUrlView = '';
    if (type === 'comment') {
        commentUrlView = documentID('comment_url_view' + postID);
        commentUrlView.setAttribute('style', 'display:block');
        commentUrlView.setAttribute('style', 'margin: 0 0 0 40px;');
        documentID('commentloadingImage' + postID).visible = true;
    } else if (type === 'comment_reply') {
        commentUrlView = documentID('comment_reply_url_view' + postID);
        commentUrlView.setAttribute('style', 'display:block');
        commentUrlView.setAttribute('style', 'margin-left:50px;');
        documentID('commentloadingImage' + postID).visible = true;
    } else if (type === 'nested_reply') {
        commentUrlView = documentID('nested_reply_url_view' + postID);
        commentUrlView.setAttribute('style', 'display:block');
        commentUrlView.setAttribute('style', 'margin:-10px 0 0 50px;');
        documentID('commentloadingImage' + postID).visible = true;
    }

    var formdata = new FormData();
    formdata.append("url", url);
    formdata.append("url_type", videoType);

    xmlhttp.addEventListener("load", function () {
        documentID('commentloadingImage' + postID).visible = false;
        documentID('check_url_status' + postID).value = 2;
        commentUrlView.innerHTML = '';
        commentUrlView.innerHTML = xmlhttp.responseText;
//        alert(xmlhttp.responseText);
        if (type === 'comment') {
            if (string === '') {
                documentID('comment1' + postID).value = "";
                documentID('comment1' + postID).placeholder = "Please enter";
            } else {
                documentID('comment1' + postID).value = string;
            }
        } else if (type === 'comment_reply') {
            if (string === '') {
                documentID('replay_comment' + postID).value = "";
                documentID('replay_comment' + postID).placeholder = "Please enter";
            } else {
                documentID('replay_comment' + postID).value = string;
            }
        } else if (type === 'nested_reply') {
            if (string === '') {
                documentID('nested_reply' + postID).value = "";
                documentID('nested_reply' + postID).placeholder = "Please enter";
            } else {
                documentID('nested_reply' + postID).value = string;
            }
        }

    }, false);
    xmlhttp.addEventListener("error", function () {
//        alert("Upload Failed");
    }, false);
    xmlhttp.addEventListener("abort", function () {
//        alert("Upload Aborted");
    }, false);

    xmlhttp.open("POST", serverUrl + '/' + postID);
    xmlhttp.send(formdata);
    return true;
}

function viewWrites(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID('view_comment' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}


/*
 * @Function            : onPress_ENTER 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : on press enter for posting comment
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : UNKNOWN 
 * @Parameter           : event, url[STRING], level[INTEGER], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function onPress_ENTER(event, url, level, ID) {
    var shiftKey = (event.shiftKey === true) ? true : false;
    var keyPressed = event.keyCode || event.which;
    if (keyPressed === 13) {
        if (shiftKey === false) {
            if (level === 'add_comment') {
                var commentStatus = documentID('comment_status').value;
                if (commentStatus === '1') { // submit comment and hold after view comment
                    documentID('comment_status').value = '2';
                    saveWrite(url, ID);
                }
            } else if (level === 'add_comment_reply') {
                var replyCommentStatus = documentID('reply_comment_status').value;
                if (replyCommentStatus === '1') { // submit comment and hold after view comment
                    documentID('reply_comment_status').value = '2';
                    saveReplayWrite(url, ID);
                }
            } else if (level === 'add_nested_reply') {
                var nestedReplyStatus = documentID('nested_reply_status').value;
                if (nestedReplyStatus === '1') { // submit comment and hold after view comment
                    documentID('nested_reply_status').value = '2';
                    saveNestedReply(url, ID);
                }
            }
        }
    } else {
        return false;
    }
}



/*
 * @Function            : saveWrite 
 * @Used IN             : @function-'onPress_ENTER'   @home.js
 * @Description         : save write from
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : UNKNOWN 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function saveWrite(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    //---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status' + ID).value === '2') {
        postUrlInfo = getUrlMetaData(ID, postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------

    var comment = '';
    var comment1 = documentID('comment1' + ID).value;
    if (documentID('check_url_status' + ID).value === '1') {   // if user put any URl 
        comment = comment1.replace(/  +/g, '');
        if (comment === '') {   // if user put any URl but does not put text value 
            documentID('add_write_form' + ID).innerHTML = '';
            documentID('add_write_form' + ID).style.display = 'none';
            return true;
        }
    } else if (documentID('check_url_status' + ID).value === '2') {
        comment = comment1.replace(/  +/g, '');
    }

    comment = comment.replace(/\n/gm, '@br@');

    var formdata = new FormData();
    formdata.append("post_comment_details", comment);
    formdata.append("post_url_info", postUrlInfo);

    xmlhttp.addEventListener("load", function () {

        documentID('view_comment' + ID).innerHTML = xmlhttp.responseText;
        documentID('add_write_form' + ID).innerHTML = '';
        documentID('add_write_form' + ID).style.display = 'none';

    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}



/*
 * @Function            : getUrlMetaData 
 * @Used IN             : @function-'saveWrite'   @home.js
 * @Description         : get url meta data
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 02-06-2016 03:05 PM 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function getUrlMetaData(ID, postUrlInfo) {
    if (documentID('url' + ID).value === '') {
        postUrlInfo = 'URL: ';
    } else {
        postUrlInfo = 'URL: ' + documentID('url' + ID).value;
    }

    if (documentID('title' + ID).value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('title' + ID).value;
    }

    if (documentID('description' + ID).value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('description' + ID).value;
    }

    if (documentID('author' + ID).value === '') {
        postUrlInfo += ' URL: ';
    } else {
        postUrlInfo += ' URL: ' + documentID('author' + ID).value;
    }
    return postUrlInfo;
}

//---------------------------End Like , Comments & Add to Libraary-----------------
//---------------------------Start Replay Like , Comments & Add to Libraary-----------------
/*
 * @Function            : get_course_by_category_id 
 * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
 * @Description         : get all available course using category ID  
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 02-02-2016 01:38 PM
 * @Updated Date Time   : 02-02-2016 01:38 PM
 * @Updated By          : MD Jaherul Islam
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL    
 * @Status              : Available       
 */
function getCommentLikeValue(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    var serverPage = url;
    xmlhttp.open("GET", serverPage);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('comment_like' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

/*
 * @Function            : replayWriteForm 
 * @Used IN             : @function-'user/home.php'
 * @Description         : view reply write form
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 02-06-2016 06:13 PM
 * @Updated By          : MD Jaherul Islam
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL    
 * @Status              : Available       
 */
function replayWriteForm(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('add_replay_write_form' + ID).style.display = 'block';
            documentID('add_replay_write_form' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}
/*
 * @Function            : deleteComment 
 * @Used IN             : @function-'user/home.php'
 * @Description         : delete comment  
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 01-06-2016 12:40 PM
 * @Parameter           : url[STRING], ID[INTEGER], type[INTEGER]
 * @Return              : NULL    
 * @Status              : Available       
 */
function deleteComment(url, ID, postID, type) {
    var deleteCommentReposse;
    deleteCommentReposse = createXMLHTTP(deleteCommentReposse);

    var formdata = new FormData();
    formdata.append("deleted_id", ID);
    formdata.append("post_id", postID);

    deleteCommentReposse.addEventListener("load", function () {

        if (type === 'comment') {
            documentID('view_comment' + postID).innerHTML = deleteCommentReposse.responseText;
        }
        if (type === 'reply') {
            documentID('comment_replay' + postID).innerHTML = deleteCommentReposse.responseText;
        }
        if (type === 'nested') {
            documentID('view_nested_replies' + postID).innerHTML = deleteCommentReposse.responseText;
        }
        if (type === 's_nested') {
            documentID('view_saaved_nested_replies' + postID).innerHTML = deleteCommentReposse.responseText;
        }

    }, false);

    deleteCommentReposse.open("POST", url);
    deleteCommentReposse.send(formdata);
}


/*
 * @Function            : saveReplayWrite 
 * @Used IN             : @function-'onPress_ENTER'   @home.js
 * @Description         : save reply write
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 02-06-2016 06:29 PM
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL    
 * @Status              : Available       
 */
function saveReplayWrite(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    //-------- - Start (if URL given in note)---------------------- -
    var postUrlInfo = '';
    if (documentID('check_url_status' + ID).value === '2') {
        postUrlInfo = getUrlMetaData(ID, postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------

    var reply_comment = '';
    var reply_comment1 = documentID('replay_comment' + ID).value;
    if (documentID('check_url_status' + ID).value === '1') {
        reply_comment = reply_comment1.replace(/  +/g, '');
        if (reply_comment === '') {
            documentID('add_replay_write_form' + ID).innerHTML = '';
            documentID('add_replay_write_form' + ID).style.display = 'none';
        }
    } else if (documentID('check_url_status' + ID).value === '2') {
        reply_comment = reply_comment1.replace(/  +/g, '');
    }
    reply_comment = reply_comment.replace(/\n/gm, '@br@');

    var formdata = new FormData();
    formdata.append("comment_replay_details", reply_comment);
    formdata.append("post_url_info", postUrlInfo);

    xmlhttp.addEventListener("load", function () {

        documentID('add_replay_write_form' + ID).innerHTML = '';
        documentID('add_replay_write_form' + ID).style.display = 'none';
        documentID('comment_replay' + ID).innerHTML = xmlhttp.responseText;

    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}

function viewMoreReply(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID('comment_replay' + ID).innerHTML = xmlhttp.responseText;
        }
    }
    xmlhttp.send(null);
}

/*
 * @Function            : getReplyLikeValue 
 * @Used IN             : @function-'view/user/home' 
 * @Description         : save or remove reply like value
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : Unknown 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function getReplyLikeValue(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('reply_comment_like' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

//---------------------------END Replay Like , Comments & Add to Libraary-----------------


//--------------------------Start Nested Reply View----------------------------------------


/*
 * @Function            : addNestedReplyForm 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : add nested reply from
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : Unknown 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function addNestedReplyForm(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('add_nested_reply_form' + ID).style.display = 'block';
            documentID('add_nested_reply_form' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}


/*
 * @Function            : saveNestedReply 
 * @Used IN             : @function-'onPress_ENTER'   @home.js
 * @Description         : add nested reply from
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : Unknown 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function saveNestedReply(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    //---------Start (if URL given in note)-----------------------
    var postUrlInfo = '';
    if (documentID('check_url_status' + ID).value === '2') {
        postUrlInfo = getUrlMetaData(ID, postUrlInfo);
    } else {
        postUrlInfo = 'null';
    }
    //---------End (if URL given in note)-----------------------

    var nestedReply = '';
    var nested_reply1 = documentID('nested_reply' + ID).value;
    if (documentID('check_url_status' + ID).value === '1') {
        nestedReply = nested_reply1.replace(/  +/g, '');
        if (nestedReply === '') {
            documentID('add_nested_reply_form' + ID).innerHTML = '';
            documentID('add_nested_reply_form' + ID).style.display = 'none';
        }
    } else if (documentID('check_url_status' + ID).value === '2') {
        nestedReply = nested_reply1.replace(/  +/g, '');
    }

    nestedReply = nestedReply.replace(/\n/gm, '@br@');

    var formdata = new FormData();
    formdata.append("nested_comment_details", nestedReply);
    formdata.append("post_url_info", postUrlInfo);

    xmlhttp.addEventListener("load", function () {

        documentID('add_nested_reply_form' + ID).innerHTML = '';
        documentID('add_nested_reply_form' + ID).style.display = 'none';
        documentID('view_saaved_nested_replies' + ID).style.display = 'block';
        documentID('view_saaved_nested_replies' + ID).innerHTML = xmlhttp.responseText;

    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
}


/*
 * @Function            : viewNestedReplies 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : view nested replies
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : Unknown 
 * @Parameter           : url[STRING], ID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function viewNestedReplies(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);

    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState === 4 && xmlhttp.status === 200)
        {
            documentID('view_nested_replies' + ID).style.display = 'block';
            documentID('view_nested_replies' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

function getNestedReplyLikeValue(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID('nested_reply_like' + ID).innerHTML = xmlhttp.responseText;
        }
    };
    xmlhttp.send(null);
}

//--------------------------END Nested Reply View----------------------------------------


//-------------------------- Start view Note Alert Action-------------------------------

function changePostStatus(url, type, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    swal({
        title: "",
        text: "Are you sure you want to Change this Status?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    xmlhttp.open("GET", url);
                    xmlhttp.onreadystatechange = function ()
                    {
                        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
                        {
                            if (type == 'note_alert') {
                                if (xmlhttp.responseText == 'delete') {
                                    location.reload();
                                } else {
                                    documentID('note_alert_action' + ID).innerHTML = xmlhttp.responseText;
                                }
                            } else if (type == 'content') {
                                if (xmlhttp.responseText == 'delete') {
                                    location.reload();
                                } else {
                                    documentID('content_action' + ID).innerHTML = xmlhttp.responseText;
                                }
                            }
                        }
                    }
                    xmlhttp.send(null);
                }
            });
}


function changePostDelete(url, type, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    swal({
        title: "",
        text: "Are you sure you want to delete this ?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    xmlhttp.open("GET", url);
                    xmlhttp.onreadystatechange = function ()
                    {
                        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
                        {
                            if (type == 'note_alert') {
                                if (xmlhttp.responseText == 'delete') {
                                    location.reload();
                                } else {
                                    documentID('note_alert_action' + ID).innerHTML = xmlhttp.responseText;
                                }
                            } else if (type == 'content') {
                                if (xmlhttp.responseText == 'delete') {
                                    location.reload();
                                } else {
                                    documentID('content_action' + ID).innerHTML = xmlhttp.responseText;
                                }
                            }
                        }
                    }
                    xmlhttp.send(null);
                }
            });
}

function editPost(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    xmlhttp.open("GET", url);
    xmlhttp.onreadystatechange = function ()
    {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
        {
            documentID('post_value' + ID).innerHTML = xmlhttp.responseText;
            $('select#tokenize_placeholder').tokenize({placeholder: "Please Type Group Name"});
            var post_publication_status = documentID('post_publication_status').value;
            getPublicationStatus(post_publication_status);
        }
    }
    xmlhttp.send(null);
}

function updateNoteAlert(url, ID) {
    var xmlhttp;
    xmlhttp = createXMLHTTP(xmlhttp);
    var selectGroupArray = new Array();

    var post_detail1 = documentID('post_detail').value;
    var selected_group = documentID('to_address').value;
    var previous_group = documentID('post_publication_status').value;
    var post_detail = post_detail1.replace(/  +/g, '');

    if (post_detail === '') {
        documentID('post_detail_error').innerHTML = "Please write your note";
        return false;
    } else {
        documentID('post_detail_error').innerHTML = "";
    }

    var viewStatus = documentID('publication_status').value;
    if (viewStatus == 4) {
        if (selected_group == '') {
            documentID('status_green').innerHTML = 'Publication status:';
            documentID('group_error').innerHTML = "Group Name is Required";
            return false;
        } else {
            documentID('group_error').innerHTML = "";
            selectGroupArray = stringToArray(selected_group);
            if (compareArray(selectGroupArray, allGroupId) === 0) {
                documentID('group_error').innerHTML = "Please enter valid group name";
                return false;
            } else {
                documentID('group_error').innerHTML = "";
            }
        }
    }

    var formdata = new FormData();
    formdata.append("post_details", post_detail);
    formdata.append("post_publication_status", viewStatus);
    formdata.append("previous_group", previous_group);
    if (viewStatus == 4) {
        formdata.append("selected_group", selected_group);
    }
//
    xmlhttp.addEventListener("load", function () {
        selectGroupArray = '';
//        document.getElementById('form_view').innerHTML = '';
        documentID('post_value' + ID).innerHTML = xmlhttp.responseText;
        xmlhttp.send(null);
    }, false);
    xmlhttp.addEventListener("error", function () {
        alert("Upload Failed");
    }, false);
    xmlhttp.addEventListener("abort", function () {
        alert("Upload Aborted");
    }, false);

    xmlhttp.open("POST", url);
    xmlhttp.send(formdata);
    return true;
}

function cancelUpdateNoteAlert(url, postID) {
    var cancelUpdateNoteAlertReposse;
    cancelUpdateNoteAlertReposse = createXMLHTTP(cancelUpdateNoteAlertReposse);

    var serverPage = url + '/' + postID;
    cancelUpdateNoteAlertReposse.open("GET", serverPage);
    cancelUpdateNoteAlertReposse.onreadystatechange = function ()
    {
        if (cancelUpdateNoteAlertReposse.readyState === 4 && cancelUpdateNoteAlertReposse.status === 200)
        {
            documentID('post_value' + postID).innerHTML = cancelUpdateNoteAlertReposse.responseText;
        }
    };
    cancelUpdateNoteAlertReposse.send(null);
}


//--------------------Download Assaignment-----------
function downloadAssignment(url, postID) {
    var iframe;
    iframe = document.getElementById("download-container");
    if (iframe === null)
    {
        iframe = document.createElement('iframe');
        iframe.id = "download-container";
        iframe.style.visibility = 'hidden';
        document.body.appendChild(iframe);
    }
    iframe.src = url + '/' + postID;
}

function downloadContentLibrary(url, ID) {
    var iframe;
    iframe = document.getElementById("download-container");
    if (iframe === null)
    {
        iframe = document.createElement('iframe');
        iframe.id = "download-container";
        iframe.style.visibility = 'hidden';
        document.body.appendChild(iframe);
    }
    iframe.src = url + '/' + ID;
}

//-------------------------- End view Note Alert Action-------------------------------
/*
 * @Function            : removePostUrl 
 * @Used IN             : @function-'view/user/home.php' 
 * @Description         : remove post URl
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 06-06-2016 10:03 AM 
 * @Parameter           : url[STRING], postCommentUrlID[INTEGER], postID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
function removePostUrl(url, postCommentUrlID, postID) {
    var removePostUrlReposse;
    removePostUrlReposse = createXMLHTTP(removePostUrlReposse);

    var formdata = new FormData();
    formdata.append("post_comment_url_id", postCommentUrlID);
    formdata.append("post_id", postID);

    removePostUrlReposse.addEventListener("load", function () {

        if (removePostUrlReposse.responseText === 'success') {
            documentID('editURLview').innerHTML = '';
            documentID('editURLview').style.display = 'none';
        }

    }, false);

    removePostUrlReposse.open("POST", url);
    removePostUrlReposse.send(formdata);
}



/*
 * @Function            : addSingleValue 
 * @Used IN             : @function-'uploadVideoFile' 
 * @Description         : Add single section for uploaded video course
 * @Developed By        : Copied from admin/video_course.js
 * @Start DateTime      : 06-03-2016 03:07 PM      
 * @Status              : available      
 */
function addSingleValue(field, addID) {
    var allUploadVideoOKcounter = new Array();
    var allUploadVideoOKcounter1 = documentID(field).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }

    if (allUploadVideoOKcounter.length < 0) {
        allUploadVideoOKcounter.push(addID);
    } else {
        if (allUploadVideoOKcounter.indexOf(addID) < 0) {
            allUploadVideoOKcounter.push(addID);
        }
    }
    documentID(field).value = allUploadVideoOKcounter;
}

/*
 * @Function            : removeSingleVideoSection 
 * @Used IN             : @function-'removeSingleVideo'
 * @                    : @function-'deleteSingleCourseWorkFile'
 * @Description         : remove single section for uploaded video course
 * @Developed By        : Copied from admin/video_course.js
 * @Start DateTime      : 06-03-2016 03:07 PM 
 * @Status              : available      
 */
function deleteSingleValue(field, removeID) {
    var allUploadVideoCounter = new Array();
    var allUploadVideoCounter1 = documentID(field).value;
    if (allUploadVideoCounter1 !== '') {
        allUploadVideoCounter = allUploadVideoCounter1.split(',');
    }
    if (allUploadVideoCounter.length > 0) {
        if (allUploadVideoCounter.indexOf(removeID) > -1) {
            var index = allUploadVideoCounter.indexOf(removeID);
            allUploadVideoCounter.splice(index, 1);
        }
        documentID(field).value = allUploadVideoCounter;
    }
}


function increaseHeight(o) {
    if (o.scrollHeight < 300) {
        o.style.overflow = "hidden";
        o.style.height = "0px";
        o.style.height = (o.scrollHeight) + "px";
    } else {
        o.style.overflow = "visible";
        o.style.height = "300px";
    }
    $('#' + o.id).removeClass('post_textarea_size');
}

function deletePost(url, postID, type) {
    $.post(url, {post_id: postID}, function () {
        if (type === '1') {
            location.reload();
        } else {
            var parentDiv = documentID('main_view');
            var childDiv = documentID('single_post' + postID);
            parentDiv.removeChild(childDiv);
        }
    });
}


// Initialize the javascript player
$(document).ready(function () {
    plyr.setup();
});