$(document).ready(function () {


    /*
     * @Description         : more course Name view
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-08-2016 11:05 AM
     * @Status              : available      
     */
    $(document).on('click', 'span[id^=moreCourseNameView]', function () {
        var divID = this.id;
        var courseUrl = divID.replace('moreCourseNameView', '');

        if ($('#moreCourseNameView' + courseUrl).text() === '>>>') {
            $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val());
            $('#moreCourseNameView' + courseUrl).text('<<<');
        } else {
            $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val().substr(0, 50));
            $('#moreCourseNameView' + courseUrl).text('>>>');
        }
    });


    /*
     * @Description         : View Free course for click free course tab
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-08-2016 11:05 AM
     * @Status              : available      
     */
    var courseType;
    $('#learnerFreeCourse').click(function () {
        pageNumber = 1;
        courseType = 'free';
        viewCourses();
    });

    $('#learnerPaidCourse').click(function () {
        pageNumber = 1;
        courseType = 'paid';
        viewCourses();
    });

    /*
     * @Description         : View register course for click register course tab
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-08-2016 11:05 AM
     * @Status              : available      
     */
    $('#learnerRegisterCourse').click(function () {
        pageNumber = 1;
        courseType = 'registration';
        viewCourses();
    });

    /*
     * @Description         : course pagination
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-08-2016 05:24 PM
     * @Status              : available      
     */
    var pageNumber;
    $(document).on('click', 'a[id^=freeCoursePagination]', function () {
        pageNumber = this.id.replace('freeCoursePagination', '');
        courseType = 'free';
        viewCourses();
    }).on('click', 'a[id^=paidCoursePagination]', function () {
        pageNumber = this.id.replace('paidCoursePagination', '');
        courseType = 'paid';
        viewCourses();
    }).on('click', 'a[id^=registerCoursePagination]', function () {
        pageNumber = this.id.replace('registerCoursePagination', '');
        courseType = 'registration';
        viewCourses();
    });

    /*
     * @Description         : View courses for click course tab
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-08-2016 11:05 AM
     * @Status              : available      
     */
    var viewCourses = function () {
        var serverUrl = $('#courseViewUrl').val();

        var courseData = {
            course_type: courseType,
            page_number: pageNumber
        };

        $.ajax({
            type: 'post',
            url: serverUrl,
            data: JSON.stringify(courseData),
            contentType: 'application/json; charser=utf-8',
            traditional: true,
            beforeSend: function () {
                switch (courseType) {
                    case 'free':
                        $('#loading_image').show();
                        $('#view_learner_free_course').attr('style', 'opacity:0');
                        break;
                        
                    case 'paid':
                        $('#loading_image').show();
                        $('#view_learner_paid_course').attr('style', 'opacity:0');
                        break;

                    case 'registration':
                        $('#loading_image').show();
                        $('#view_learner_register_course').attr('style', 'opacity:0');
                        break;
                }
            },
            complete: function () {
                switch (courseType) {
                    case 'free':
                        $('#loading_image').hide();
                        $('#view_learner_free_course').attr('style', 'opacity:1');
                        break;
                    
                    case 'paid':
                        $('#loading_image').hide();
                        $('#view_learner_paid_course').attr('style', 'opacity:1');
                        break;

                    case 'registration':
                        $('#loading_image').hide();
                        $('#view_learner_register_course').attr('style', 'opacity:1');
                        break;
                }
            },
            success: function (data, status) {
                if (status === 'success') {
                    switch (courseType) {
                        case 'free':
                            $('#view_learner_free_course').html(data);
                            break;
                            
                        case 'paid':
                            $('#view_learner_paid_course').html(data);
                            break;

                        case 'registration':
                            $('#view_learner_register_course').html(data);
                            break;
                    }
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    };
});



/*
 * @Description         : cancel course registration
 * @Developed By        : Md Jaherul Islam  
 * @Start DateTime      : 30-08-2016 01:22 PM
 * @Status              : available      
 */
var cancelCourseStatus = function (url, rollnumber, type) {
    var serverUrl = url + '/' + rollnumber + '/' + type;
    $.get(serverUrl, function () {
        location.reload();
    });
};

