$(document).ready(function () {
    /*
     * @Description         : get course rating value with mouseover and mouseout
     *                        and save value in database 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 22-08-2016 05:01 PM
     * @Status              : available      
     */

    var percent, rating, divID, courseUrl;
    var courseUrlArray = Array();

    $(document).on("mousemove", 'div[id^="ratingValue"]', function (event) {
        if (divID !== this.id) {
            divID = this.id;
        }
        courseUrl = divID.replace('ratingValue', '');

        var xCoor = event.offsetX;
        var divWidth = $('#' + divID).outerWidth();
        percent = Math.round((xCoor / divWidth) * 100);
        rating = (percent * 5) / 100;
        $('#ratingDiv' + courseUrl).attr('style', 'width:' + percent + '%');
    }).on("mouseout", 'div[id^="ratingValue"]', function () {
        var courseRating = $('#courseRating' + courseUrl).val();
        if ($.inArray(courseUrl, courseUrlArray) <= -1) {
            $('#ratingDiv' + courseUrl).attr('style', 'width:' + courseRating + '%');
        } else {
            $('#ratingDiv' + courseUrl).attr('style', 'width:' + courseUrlArray[courseUrl] + '%');
        }
    }).on("click", 'div[id^="ratingValue"]', function () {
        courseUrlArray.push(courseUrl);
        courseUrlArray[courseUrl] = percent;
        var ratingCourseUrl = $('#ratingCourseUrl').val();

        var ratingInfo = {
            course_url: courseUrl,
            rating_value: rating.toFixed(1)
        };

        $.ajax({
            type: 'post',
            url: ratingCourseUrl,
            data: JSON.stringify(ratingInfo),
            contentType: "application/json; charset=utf-8",
            traditional: true,
            success: function () {
                $('#ratingDiv' + courseUrl).attr('style', 'width:' + courseUrlArray[courseUrl] + '%');
            }
        });
    });



    /*
     * @Description         : get all course checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var all_course;
    $('#allCourse').click(function () {
        if ($('#allCourse').is(":checked")) {
            all_course = 1;

            courseUpcomming = courseRating = courseType = coursePriority = otherParentTopic = '';
            pageNumber = 1;
            childTopicArray.splice(0, childTopicArray.length);
            otherTopicArray.splice(0, otherTopicArray.length);
            skillLevelArray.splice(0, skillLevelArray.length);
            $('.course_checkbox').attr('checked', false);
        }

        viewCourses();
    });



    /*
     * @Description         : get child topic checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var childTopicArray = new Array();
    $(document).on("click", 'input[id^="courseTopic"]', function () {
        var divID = this.id;
        var topicID = divID.replace('courseTopic', '');
        if ($('#' + divID).is(":checked")) {
            childTopicArray.push(topicID);
        } else {
            if ($.inArray(topicID, childTopicArray) > -1) {
                childTopicArray.splice($.inArray(topicID, childTopicArray), 1);
            }
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });


    /*
     * @Description         : if course assign topic is inactive than get other topic value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var otherTopicArray = new Array();
    $('input[id^="otherTopic"]').click(function () {
        var divID = this.id;
        var othrTopicId = divID.replace('otherTopic', '');

        if ($('#' + divID).is(":checked")) {
            otherTopicArray.push(othrTopicId);
        } else {
            if ($.inArray(othrTopicId, otherTopicArray) > -1) {
                otherTopicArray.splice($.inArray(othrTopicId, otherTopicArray), 1);
            }
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });

    /*
     * @Description         : view all courses with using deleted or inactive topic ID
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 23-09-2016 09:47 AM
     * @Status              : available      
     */
    var otherParentTopic;
    $(document).on('click', 'input[id="other_parent_topic"]', function () {
        if ($('#' + this.id).is(":checked")) {
            otherParentTopic = 1;
        } else {
            otherParentTopic = '';
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });

    /*
     * @Description         : Course upcomming checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var courseUpcomming;
    $('#upcomming_course').click(function () {
        if ($('#upcomming_course').is(':checked')) {
            courseUpcomming = 1;
        } else {
            courseUpcomming = '';
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });


    /*
     * @Description         : Course Rating checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var courseRating;
    $('#rated_course').click(function () {
        if ($('#rated_course').is(':checked')) {
            courseRating = 1;
            coursePriority = '';
            $('input[id^="priorityLevel"]').attr('checked', false);
        } else {
            courseRating = '';
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });


    /*
     * @Description         : Course skilllevel checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var skillLevelArray = new Array();
    $('input[id^="skillLevel"]').click(function () {
        var divID = this.id;
        var skillLevel = divID.replace('skillLevel', '');
        if ($('#' + divID).is(':checked')) {
            skillLevelArray.push(skillLevel);
        } else {
            if ($.inArray(skillLevel, skillLevelArray) > -1) {
                skillLevelArray.splice(($.inArray(skillLevel, skillLevelArray)), 1);
            }
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });



    /*
     * @Description         : Course priority checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var coursePriority;
    $('input[id^="priorityLevel"]').click(function () {
        var divID = this.id;

        if ($('#' + divID).is(':checked')) {
            courseRating = '';
            var coursePriorityID = divID.replace('priorityLevel', '');
            if (coursePriorityID === '1') {
                coursePriority = 1;
                $('#priorityLevel2').attr('checked', false);
            }
            if (coursePriorityID === '2') {
                coursePriority = 2;
                $('#priorityLevel1').attr('checked', false);
            }
            $('#rated_course').attr('checked', false);
        } else {
            coursePriority = '';
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });



    /*
     * @Description         : Course type(free) checkbox value 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 05:01 PM
     * @Status              : available      
     */
    var courseType;
    $('#courseType').click(function () {
        if ($('#courseType').is(':checked')) {
            courseType = 1;
        } else {
            courseType = '';
        }
        all_course = '';
        pageNumber = 1;
        viewCourses();
        $('#allCourse').attr('checked', false);
    });



    /*
     * @Description         : View more Course name if course name exists 15 character 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 24-08-2016 05:01 PM
     * @Status              : available      
     */
    $(document).on("click", 'span[id^="moreCourseName"]', function () {
        var divID = this.id;
        courseUrl = divID.replace('moreCourseName', '');
        if ($('#' + divID).text() === 'more') {
            $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val());
            $('#' + divID).text('less');
        } else {
            $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val().substr(0, 15) + '...');
            $('#' + divID).text('more');
        }
    });


    /*
     * @Description         : View paginzation course value
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 24-08-2016 05:01 PM
     * @Status              : available      
     */
    var pageNumber;
    $(document).on("click", 'a[id^="pagination"]', function () {
        var divID = this.id;
        pageNumber = divID.replace('pagination', '');

        viewCourses();
    });




    /*
     * @Description         : view all courses with all requirements
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 24-08-2016 05:01 PM
     * @Updated Date Time   : 23-09-2016 10:02 AM
     * @Updated By          : MD Jaherul Islam
     * @Status              : available      
     */
    var viewCourses = function () {
        var allCourse = (all_course === undefined) ? 1 : all_course;
        var other_parent_topic = (otherParentTopic === undefined) ? '' : otherParentTopic;
        var course_upcomming = (courseUpcomming === undefined) ? '' : courseUpcomming;
        var course_type = (courseType === undefined) ? '' : courseType;
        var course_rating = (courseRating === undefined) ? '' : courseRating;
        var course_priority = (coursePriority === undefined) ? '' : coursePriority;
        var page_number = (pageNumber === undefined) ? 1 : pageNumber;
        var viewCoursesUrl = $('#viewCoursesUrl').val();

        var viewCourseData = {
            all_course: allCourse,
            child_topic_id: childTopicArray,
            other_topic_id: otherTopicArray,
            other_parent_topic: other_parent_topic,
            course_upcomming: course_upcomming,
            course_rating: course_rating,
            skill_level_id: skillLevelArray,
            course_priority: course_priority,
            course_type: course_type,
            page_number: page_number
        };

        $.ajax({
            type: 'post',
            url: viewCoursesUrl,
            data: JSON.stringify(viewCourseData),
            contentType: "application/json; charset=utf-8",
            traditional: true,
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_without_paginzation').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_without_paginzation').attr('style', 'opacity:1');
            },
            success: function (data, status) {
                if (status === 'success') {
                    $('#course_view').html(data);
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    };


    /*
     * @Description         : view full course name
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 27-08-2016 01:47 PM
     * @Status              : available      
     */
    $(document).on("click", "#moreCourseNameView", function () {
        if ($('#moreCourseNameView').text() === '>>>') {
            $('#courseNameView').text($('#hiddenCourseName').val());
            $('#moreCourseNameView').text('<<<');
        } else {
            $('#courseNameView').text($('#hiddenCourseName').val().substr(0, 50));
            $('#moreCourseNameView').text('>>>');
        }
    });


    /*
     * @Description         : download work file 
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 16-11-2016 10:32 AM
     * @Status              : available      
     */
    $(document).on('click', 'a[id^="download_work_file"]', function () {
        var ID = this.id.replace('download_work_file', '');
        var baseUrl = $('#baseUrl').val();
        var serverUrl = baseUrl + 'user/download-work-file/' + ID;
        var iframe;
        iframe = document.getElementById("download-container");
        if (iframe === null)
        {
            iframe = document.createElement('iframe');
            iframe.id = "download-container";
            iframe.style.visibility = 'hidden';
            document.body.appendChild(iframe);
        }
        iframe.src = serverUrl;
    });
});


/*
 * @Description         : view all child topic if clik "more" topic 
 * @Developed By        : Md Jaherul Islam  
 * @Start DateTime      : 22-08-2016 05:01 PM
 * @Status              : available      
 */
var viewChildTopic = function (topicInfo, parentTopicID) {
    var output = '';
    for (var i = 0; i < topicInfo.child_topic[parentTopicID].length; i++) {
        output += '<div class="checkbox checkbox-success">\n\
                                        <input type="checkbox" name="course" class="course_checkbox" id="courseTopic' + topicInfo.child_topic[parentTopicID][i].topic_id + '">\n\
                                        <label for="course">' + topicInfo.child_topic[parentTopicID][i].topic_name + '</label>\n\
                                    </div>';
    }
    $('#childTopic').append(output);
};



/*
 * @Description         : view all child topic if clik "more" topic 
 * @Developed By        : Md Jaherul Islam  
 * @Start DateTime      : 22-08-2016 05:01 PM
 * @Status              : available      
 */
var moreChildTopic = function (parentTopicID) {
    var totalChildTopic = $('#childTopic').children().length;
    var moreTopicUrl = $('#moreTopicUrl').val();
    var serverUrl = moreTopicUrl + '/' + parentTopicID + '/' + totalChildTopic;

    $.get(serverUrl, function (data, status) {
        if (status === 'success') {
            var topicInfo = JSON.parse(data);
            viewChildTopic(topicInfo, parentTopicID);

            var totalChildTopic1 = $('#childTopic').children().length;

            if (topicInfo.total_child_topic[parentTopicID] <= totalChildTopic1) {
                $('#moreChildTopic' + parentTopicID).hide();
            }
        }
    });
};

/*
 * @Function            : convertDecemaltoTime 
 * @Description         : convert time to decimal
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 12-07-2016 10:55 AM  
 * @Status              : available      
 */
function convertDecemaltoTime(numberOfClasses1, classHourPerDay1) {
    var numberOfClasses = parseInt(numberOfClasses1);
    var classMinutePerDay = parseFloat(classHourPerDay1);
    var classMinuts = numberOfClasses * classMinutePerDay;
    var classMiliSeconds = classMinuts * 60000;
    var timeObject = convertMillisecondsToDigitalClock(classMiliSeconds);
    return timeObject.clock;
}


/*
 * @Function            : convertMillisecondsToDigitalClock 
 * @Description         : convert milisecond to digital clock
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 12-07-2016 10:55 AM  
 * @Status              : available      
 */
function convertMillisecondsToDigitalClock(ms) {
    var hours = Math.floor(ms / 3600000); // 1 Hour = 36000 Milliseconds
    var minutes = Math.floor((ms % 3600000) / 60000); // 1 Minutes = 60000 Milliseconds
    var minutes1; // 1 Minutes = 60000 Milliseconds
    if (minutes.toString().length === 1) {
        minutes1 = minutes + '0';
    } else {
        minutes1 = minutes;
    }
    return {
        hours: hours,
        minutes: minutes,
        clock: hours + ":" + minutes1
    };
}

/*
 * @Description         : event for profile learner course pagination
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-03-17  
 * @Status              : available      
 */
$(document).on('click', 'a[id^="learnerPagination"]', function () {
    var currentPage = this.id.replace('learnerPagination', '');
    var url = $('#baseUrl').val() + 'learner-course-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#learnerCourseContent').html(data);
            });
});


/*
 * @Description         : event for profile teacher course pagination
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-03-17  
 * @Status              : available      
 */
$(document).on('click', 'a[id^="teacherPagination"]', function () {
    var currentPage = this.id.replace('teacherPagination', '');
    var url = $('#baseUrl').val() + 'teacher-course-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#teacherCourseContent').html(data);
            });
});

$(document).on('click', 'a[id^="learner_quiz_pagination"]', function () {
    var currentPage = this.id.replace('learner_quiz_pagination', '');
    var url = $('#baseUrl').val() + 'learner_profile_quiz_pagination';    
    var profileUrl = $('#profileUrl').val();
    //console.log(currentPage);
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#rows').html(data);
            });
});

(function () {
    var count = 1;
    $( "#view_more" ).click(function() {
        count += 1;
        var url = $('#baseUrl').val() + 'profile-skill-meter-pagination';    
        var profileUrl = $('#profileUrl').val();
        $.post(url,
                {
                    current_page: count,
                    profile_url: profileUrl
                },
                function (data) {
                    console.log(data);
                    $('#skil_meter').html(data);
            });
    });
})();

$(document).on('click', 'a[id^="work_experience_pagination"]', function () {
    var currentPage = this.id.replace('work_experience_pagination', '');
    var url = $('#baseUrl').val() + 'profile-work-experience-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#work_experience_view').html(data);
            });
});

$(document).on('click', 'a[id^="new_work_experience_pagination"]', function () {
    var currentPage = this.id.replace('new_work_experience_pagination', '');
    var url = $('#baseUrl').val() + 'work-exprience-form';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#work_experience_view').html(data);
            });
});

$(document).on('click', 'a[id^="profile_language_pagination"]', function () {
    var currentPage = this.id.replace('profile_language_pagination', '');
    var url = $('#baseUrl').val() + 'profile-language-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#skillLanguage').html(data);
            });
});
$(document).on('click', 'a[id^="profile_education_pagination"]', function () {
    var currentPage = this.id.replace('profile_education_pagination', '');
    var url = $('#baseUrl').val() + 'profile-education-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#profile_education_pagination').html(data);
            });
});

$(document).on('click', 'a[id^="group_detail_note_pagination_link"]', function () {
    var currentPage = this.id.replace('group_detail_note_pagination_link', '');
    var url = $('#baseUrl').val() + 'group-detail-note-pagination-link';    
    var groupUrl = $('#groupUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                group_url: groupUrl
            },
            function (data) {
                $('#group_note_view').html(data);
            });
});

$(document).on('click', 'a[id^="group_detail_alert_pagination_link"]', function () {
    var currentPage = this.id.replace('group_detail_alert_pagination_link', '');
    var url = $('#baseUrl').val() + 'group-detail-alert-pagination-link';    
    var groupUrl = $('#groupUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                group_url: groupUrl
            },
            function (data) {
                $('#group_alert_view').html(data);
            });
});

$(document).on('click', 'a[id^="group_detail_assignment_pagination_link"]', function () {
    var currentPage = this.id.replace('group_detail_assignment_pagination_link', '');
    var url = $('#baseUrl').val() + 'group-detail-assignment-pagination-link';    
    var groupUrl = $('#groupUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                group_url: groupUrl
            },
            function (data) {
                $('#group_assignment_view').html(data);
            });
});
/*
 * @Description         : event for profile organization course pagination
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 22-03-17  
 * @Status              : available      
 */
$(document).on('click', 'a[id^="organizationPagination"]', function () {
    var currentPage = this.id.replace('organizationPagination', '');
    var url = $('#baseUrl').val() + 'organization-course-pagination';    
    var profileUrl = $('#profileUrl').val();
    $.post(url,
            {
                current_page: currentPage,
                profile_url: profileUrl
            },
            function (data) {
                $('#organizationCourseContent').html(data);
            });
});

/*
 * @Description         : event for profile teacher video course pagination
 * @Developed By        : Md. Delwar Hossain
 * @Start DateTime      : 12-06-17  
 * @Status              : available      
 */
$(document).on('click', "a[id^=teacherVideoCoursePagination]", function(){
    var page_number = this.id.replace('teacherVideoCoursePagination', '');        
    var url = $('#baseUrl').val() + 'teacher-video-course-pagination'; 
    var tea_id = $('#teacher_id').val();
    $.post(url, 
            {
               page_number: page_number, 
               teacher_id: tea_id
            }, 
            function(data){
                $('#teacherVideoCourseContent').html(data);
       });
});

/*
 * @Description         : event for profile organization video course pagination
 * @Developed By        : Md. Delwar Hossain
 * @Start DateTime      : 13-06-17  
 * @Status              : available      
 */
$(document).on('click', "a[id^=organizationVideoCoursePagination]", function(){
    var page_number = this.id.replace('organizationVideoCoursePagination', '');        
    var url = $('#baseUrl').val() + 'organization-video-course-pagination'; 
    var org_id = $('#org_id').val();
    $.post(url, 
            {
               page_number: page_number, 
               org_id: org_id
            }, 
            function(data){
                $('#organizationVideoCourseContent').html(data);
       });
});