/*
 * @Function            : assignGradCertificate
 * @Description         : Assign Certificate to student after batch finish
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 27-02-17
 * @Parameter           : obj        
 * @Status              : Available       
 */
function assignGradCertificate(obj) {
    var studentRoll = obj.id.replace('student_roll', '');
    var courseBatchId = $('#courseBatchId').val();
    var url = $('#baseUrl').val()+'assign-certificate';    
    var ckd = $('#' + obj.id).is(':checked');
    if (ckd) {
        $.post(url,
                {
                    student_roll: studentRoll,
                    course_batch_id: courseBatchId
                },
                function(data){
                    if(data === ''){
                        $('#graduationCap'+studentRoll).show('slow');
                    }else{
                        $('#student_roll' + studentRoll).prop('checked', false);
                        $('#noCertificateData').modal('show');
                    }
                });
    } else {
        $('#cancelCertificateModal' + studentRoll).modal({backdrop: 'static', keyboard: false});
        $('#cancelCertificateModal' + studentRoll).modal('show');

    }

}


/*
 * @Description         : Certificate Cancel Modal Yes No Button functionality
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 01-03-17      
 */
$(document).on('click', 'button[id^=modalNoButtonsr]', function () {
    var studentRoll = this.id.replace('modalNoButtonsr', '');
    $('#cancelCertificateModal' + studentRoll).modal('hide');
    $('#student_roll' + studentRoll).prop('checked', true);
}).on('click', 'button[id^=modalYesButtonsr]', function () {
    var studentRoll = this.id.replace('modalYesButtonsr', '');
    var courseBatchId = $('#courseBatchId').val();
    var url = $('#baseUrl').val()+'cancel-certificate';  
    
    $.post(url,
            {
                student_roll: studentRoll,
                course_batch_id: courseBatchId
            },
            function(){
                $('#graduationCap'+studentRoll).hide('slow');
            });
});



/*
 * @Function            : validateCertificateImage 
 * @Description         : Validates certificate image type and size and
 *                        use ajax for uploading image
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 07-03-17
 * @Parameter           : objInput[object of input element]         
 * @Status              : Available       
 */
function validateCertificateImage(objInput) {
    if (validateImgType(objInput) && validateImgSize(objInput)) {
        var fileData = new FileReader();
        fileData.readAsDataURL(objInput.files[0]);
        fileData.onload = function () {
            $('#image, #image_display').show();
            $('#image_display').attr('src', fileData.result);
            $('#image .text-danger').remove();
        };
    } else {
        $('#image').show();
        $('#image_display').hide();
        $('#image').append('<p class="text-danger">Please input valid image type and size !</p>');
    }
}

/*
 * @Function            : validateImgType 
 * @Description         : Validates image type 
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 07-03-17
 * @Parameter           : objInput[object of input element]         
 * @Status              : Available       
 */
function validateImgType(objInput) {
    var imgExtension = ['jpg', 'jpeg', 'png', 'gif'];
    if ($.inArray($(objInput).val().split('.').pop(), imgExtension) !== -1) {
        return 'ok';
    }
}

/*
 * @Function            : validateImgSize 
 * @Description         : Validates image size
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 07-03-17
 * @Parameter           : objInput[object of input element]         
 * @Status              : Available       
 */
function validateImgSize(objInput) {
    if (objInput.files && objInput.files[0]) {
        var size = objInput.files[0].size;
        if (size < 2048000) {
            return 'ok';
        }
    }
}

