function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest !== 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}
function documentID(el) {
    return document.getElementById(el); //Get the element with the specified ID
}


function get_course_info(course_id, url) {
    // alert(url);
    if (course_id !== '') {
        var xmlhttp1 = checkXMLHTTP(xmlhttp1);
        var formdata = new FormData();
        formdata.append("course_id", course_id);
        xmlhttp1.addEventListener("load", function () {
            document.getElementById('course_info').innerHTML = xmlhttp1.responseText;
            $('#datetimepicker1').datetimepicker({
                viewMode: 'years',
                format: 'YYYY-MM-DD'

            });
            $('#datetimepicker5').datetimepicker({
                viewMode: 'years',
                format: 'YYYY-MM-DD'

            });
        }, false);
        xmlhttp1.addEventListener("error", function () {
            alert("There is some problem in your browser, not working");
        }, false);
        xmlhttp1.addEventListener("abort", function () {
            alert("There is some problem in your browser, aborted");
        }, false);
        xmlhttp1.open("POST", url);
        xmlhttp1.send(formdata);
    }
}
function check_start_date(course_start_date) {
    var course_batch_start_date = documentID('course_batch_start_date').value;
    if (course_batch_start_date < course_start_date) {
        document.getElementById('warning_message').innerHTML = "Batch start date is before course start date!";
    }
}


/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */

function assignBatch(url, student_id, total_checked, batch) {
    if (batch === '0') {
        alert('Please create batch first');
    } else {
        if (total_checked === '0') {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("student_id", student_id);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('batch' + student_id).innerHTML = xmlhttp1.responseText;
                document.getElementById('batch' + student_id).style.display = 'block';
//                document.getElementById('viewIcon' + student_id).style.display = 'none';
//                document.getElementById('deleteIcon' + student_id).style.display = 'block';
            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", url);
            xmlhttp1.send(formdata);
        } else if (total_checked === '1') {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("student_id", student_id);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('batch' + student_id).innerHTML = xmlhttp1.responseText;
                document.getElementById('batch' + student_id).style.display = 'block';
                document.getElementById('viewIcon' + student_id).style.display = 'block';
                document.getElementById('deleteIcon' + student_id).style.display = 'none';
                document.getElementById('addBatch' + student_id).style.display = 'block';

            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", url);
            xmlhttp1.send(formdata);

        } else if (total_checked === '2') {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("student_id", student_id);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('batch' + student_id).innerHTML = xmlhttp1.responseText;
                document.getElementById('viewIcon' + student_id).style.display = 'block';
                document.getElementById('deleteIcon' + student_id).style.display = 'none';
                document.getElementById('addBatch' + student_id).style.display = 'none';
            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", url);
            xmlhttp1.send(formdata);
        }

    }
}
/*
 * Function         : getBatchID
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */

function getBatchID(batchID, courseID, studentID, url, url1) {
    var count = count_checkbox(studentID); //count what numbers of checkbox xhecked
    if (count === 0) {
        if ($('#batch_id' + batchID + studentID).prop('checked')) {     //check checkbox is selected ?
            document.getElementById('deleteIcon' + studentID).style.display = 'block';
            document.getElementById('viewIcon' + studentID).style.display = 'none';
            document.getElementById('addBatch' + studentID).style.display = 'block';
        } else {
            document.getElementById('deleteIcon' + studentID).style.display = 'block';
            document.getElementById('viewIcon' + studentID).style.display = 'none';
            document.getElementById('addBatch' + studentID).style.display = 'block';
            remove_student_from_assigned_batch(batchID, studentID, courseID, url1);     //when unchecked checkbox student remove from assigned batch
        }
    } else if (count === 1) {           //1 means 1 checkbox selected
        if ($('#batch_id' + batchID + studentID).prop('checked')) {
            assign_student_from_unassigned_student_list(studentID);  //unassigned student     
            update_student_id(batchID, studentID, url);     //when checkbox checked student assign to a  batch
//            document.getElementById('deleteIcon' + studentID).style.display = 'none';
//            document.getElementById('viewIcon' + studentID).style.display = 'block';
            document.getElementById('addBatch' + studentID).style.display = 'block';
        } else {
            remove_student_from_assigned_batch(batchID, studentID, courseID, url1);     //when unchecked checkbox student remove from assigned batch
            document.getElementById('deleteIcon' + studentID).style.display = 'none';
            document.getElementById('viewIcon' + studentID).style.display = 'block';
            document.getElementById('addBatch' + studentID).style.display = 'block';
        }
    } else if (count === 2) { //2 means 2 checkbox is seleted
        if ($('#batch_id' + batchID + studentID).prop('checked')) {
            update_student_id(batchID, studentID, url);                    //when checkbox checked student assign to a  batch
            document.getElementById('addBatch' + studentID).style.display = 'none';
        } else {
            remove_student_from_assigned_batch(batchID, studentID, courseID, url1);     //when unchecked checkbox student remove from assigned batch
            document.getElementById('addBatch' + studentID).style.display = 'none';
        }
    } else if (count > 2) {     // if want to check more than two checkbox
        if ($('#batch_id' + batchID + studentID).prop('checked')) {
            $('#batch_id' + batchID + studentID).prop('checked', false);      //make checkbox disable for check
            alert('You can not select one student more then two batch');
        }
    }
}
//21-09-2016
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function assign_student_from_unassigned_student_list(studentID) {
    var value = $('#unassign_student_count').val();
    var unassigned_url = $('#unassigned_url').val();
    var course_url = $('#course_url').val();
    var redirect_url = $('#redirect_url').val();
    var base_url = $('#baseUrl').val();
    var url = base_url+redirect_url;
    
    if (value !== undefined) {
        if (value === '1') {
            window.location = url;
        } else {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("course_url", course_url);
            formdata.append("student_id", studentID);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('view_unassigned_student').innerHTML = xmlhttp1.responseText;
            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", unassigned_url);
            xmlhttp1.send(formdata);
        }
    }
}
/*
 * Function         : remove_student_from_assigned_batch
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function remove_student_from_assigned_batch(batchID, studentID, courseID, url1) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("batchID", batchID);
    formdata.append("studentID", studentID);
    formdata.append("courseID", courseID);
    xmlhttp1.addEventListener("load", function () {
        //  document.getElementById('batch' + studentID).innerHTML = xmlhttp1.responseText;
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url1);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */

function update_student_id(batchID, studentID, url) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("batchID", batchID);
    formdata.append("studentID", studentID);
    xmlhttp1.addEventListener("load", function () {
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function count_checkbox(studentID) {
    var count = 0;
    var checkboxes = document.getElementById('batch' + studentID).getElementsByTagName("input");
    for (var i = 0; i < checkboxes.length; i++)
    {
        checkboxes[i].checked ? count++ : null;
    }
    return count;
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function closeBatch(student_id) {
    document.getElementById('batch' + student_id).style.display = 'none';
//    document.getElementById('deleteIcon' + student_id).style.display = 'block';
//    document.getElementById('viewIcon' + student_id).style.display = 'none';
//    document.getElementById('addBatch' + student_id).style.display = 'block';
    location.reload();
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function viewBatch(url, student_id, course_id) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("student_id", student_id);
    formdata.append("course_id", course_id);
    xmlhttp1.addEventListener("load", function () {
        document.getElementById('batch' + student_id).innerHTML = xmlhttp1.responseText;
        // document.getElementById('batch' + student_id).style.display = 'block';
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function removeStudent(batchID, courseID, studentID, url) {
    var count = count_checkbox(studentID);
    if ($('#batch_id' + batchID + studentID).prop('checked')) {
    } else {
        if (count === 0) {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("batchID", batchID);
            formdata.append("studentID", studentID);
            formdata.append("courseID", courseID);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('batch' + studentID).innerHTML = 'none';
                document.getElementById('deleteIcon' + studentID).style.display = 'block';
                document.getElementById('addBatch' + studentID).style.display = 'block';
                document.getElementById('viewIcon' + studentID).style.display = 'none';
            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", url);
            xmlhttp1.send(formdata);
        } else if (count === 1) {
            var xmlhttp1;
            xmlhttp1 = checkXMLHTTP(xmlhttp1);
            var formdata = new FormData();
            formdata.append("batchID", batchID);
            formdata.append("studentID", studentID);
            formdata.append("courseID", courseID);
            xmlhttp1.addEventListener("load", function () {
                document.getElementById('batch' + studentID).innerHTML = xmlhttp1.responseText;
                document.getElementById('viewIcon' + studentID).style.display = 'block';
                document.getElementById('addBatch' + studentID).style.display = 'block';
            }, false);
            xmlhttp1.addEventListener("error", function () {
                alert("not working");
            }, false);
            xmlhttp1.addEventListener("abort", function () {
                alert("Aborted");
            }, false);
            xmlhttp1.open("POST", url);
            xmlhttp1.send(formdata);

        }
    }
}

/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */

function cancelBatch(course_batch_id, url) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("course_batch_id", course_batch_id);
    xmlhttp1.addEventListener("load", function () {
        location.reload();
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function deleteBatch(course_batch_id, url) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("course_batch_id", course_batch_id);
    xmlhttp1.addEventListener("load", function () {
        location.reload();
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function batchPagination(url, batch_type, page_number) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("batch_type", batch_type);
    formdata.append("page_number", page_number);
    xmlhttp2.addEventListener("load", function () {
        if (batch_type === 'created') {
            documentID('view_created_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'running') {
            documentID('view_running_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'finished') {
            documentID('view_finished_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'cancel') {
            documentID('view_cancel_batch').innerHTML = xmlhttp2.responseText;
        }
        $('html, body').animate({scrollTop: 0}, 'slow');
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function viewSearchBatch(search_value, person_id, url) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("search_value", search_value);
    formdata.append("person_id", person_id);
    xmlhttp1.addEventListener("load", function () {
        documentID('view_created_batch').innerHTML = xmlhttp1.responseText;

    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function searchBatch(batchType, url) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("batchType", batchType);
    xmlhttp1.addEventListener("load", function () {
        documentID('tt-search-area').innerHTML = xmlhttp1.responseText;
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function searchBatchTypeView(search_value, batch_type, url) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("batch_type", batch_type);
    formdata.append("search_value", search_value);
    xmlhttp2.addEventListener("load", function () {
        if (batch_type === 'created') {
            documentID('view_created_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'running') {
            documentID('view_running_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'finished') {
            documentID('view_finished_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'cancel') {
            documentID('view_cancel_batch').innerHTML = xmlhttp2.responseText;
        }
        $('html, body').animate({scrollTop: 0}, 'slow');
    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}

/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function batchPaginationCourse(url, batch_type, page_number, course_id) {
    var xmlhttp2;
    xmlhttp2 = checkXMLHTTP(xmlhttp2);
    var formdata = new FormData();
    formdata.append("batch_type", batch_type);
    formdata.append("page_number", page_number);
    formdata.append("course_id", course_id);
    xmlhttp2.addEventListener("load", function () {

        if (batch_type === 'created') {
            documentID('view_created_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'running') {
            documentID('view_running_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'finished') {
            documentID('view_finished_batch').innerHTML = xmlhttp2.responseText;
        }
        if (batch_type === 'cancel') {
            documentID('view_cancel_batch').innerHTML = xmlhttp2.responseText;
        }
        $('html, body').animate({scrollTop: 0}, 'slow');

    }, false);
    xmlhttp2.open("POST", url);
    xmlhttp2.send(formdata);
}
/*
 * Function         : 
 * Used IN          :
 * Description      : 
 * Parameter        :
 * return           :
 * redirect         :
 * Developed By     :
 * Date             : 
 */
function removeAssignStudent(studentID, batchID, studentNumber, url, url1) {
    var xmlhttp1;
    xmlhttp1 = checkXMLHTTP(xmlhttp1);
    var formdata = new FormData();
    formdata.append("studentID", studentID);
    formdata.append("batchID", batchID);
    xmlhttp1.addEventListener("load", function () {
        if (studentNumber === '1') {
            window.location = url1;
        } else {
            location.reload();
        }
    }, false);
    xmlhttp1.addEventListener("error", function () {
        alert("not working");
    }, false);
    xmlhttp1.addEventListener("abort", function () {
        alert("Aborted");
    }, false);
    xmlhttp1.open("POST", url);
    xmlhttp1.send(formdata);
}

/*------------------------- start unassigned student--------------*/
//22-09-2016 tania
var viewUnassignedStudentBYDate = function (startDate, endDate) {
    var todaysData = getTodaysDate();
    if (startDate <= endDate) {
        if (todaysData >= endDate) {
            viewUnassignedStudent(startDate, endDate);
            $('#errorMessage').html('');
        } else {
            $('#errorMessage').html('<span style="color:red;">Your can not select date after today!</span>');
        }
    } else {
        $('#errorMessage').html('<span style="color:red;">Please select date between to range!</span>');
    }
};

var viewUnassignedStudent = function (startDate, endDate) {
    var course_url = $('#course_url').val();
    var registerStudentUrl = $('#unassign_student_url').val();
    $.ajax({
        type: 'post',
        url: registerStudentUrl,
        data: {start_date: startDate, end_date: endDate, course_url: course_url},
        beforeSend: function () {
            $('#loading_image').show();
            $('#view_unassigned_student').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#view_unassigned_student').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#view_unassigned_student').html(data);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
};

$(document).ready(function () {
    $(document).on('click', 'a[id^=unassignStudentPagination]', function () {
        var course_url = $('#course_url').val();
        var paginationUrl = $('#pagination_url').val();
        var pageNumber = this.id.replace('unassignStudentPagination', '');
        $.ajax({
            type: 'post',
            url: paginationUrl,
            data: {course_url: course_url, page_number: pageNumber},
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_unassigned_student').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_unassigned_student').attr('style', 'opacity:1');
            },
            success: function (data) {
                $('#view_unassigned_student').html(data);
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    });
});
/*-------------------- 24-09-2016 end unassigned student------------------*/
/*-------------------- start not eligible student------------------*/

function makeNotEligible(url, student_id, course_id) {
    $.ajax({
        url: url,
        type: 'post',
        data: {student_id: student_id, course_id: course_id},
        success: function () {
            location.reload();
        }
    });
}

function makeEligible(url, student_id, course_id) {
    $.ajax({
        url: url,
        type: 'post',
        data: {student_id: student_id, course_id: course_id},
        success: function () {
            location.reload();
        }
    });
}
$(document).ready(function () {
    $(document).on('click', 'a[id^=notEligiblePagination]', function () {
        var course_url = $('#course_url').val();
        var paginationUrl = $('#not_eligible_pagination').val();
        var pageNumber = this.id.replace('notEligiblePagination', '');
        $.ajax({
            type: 'post',
            url: paginationUrl,
            data: {course_url: course_url, page_number: pageNumber},
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_not_eligible_student').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_not_eligible_student').attr('style', 'opacity:1');
            },
            success: function (data) {
                $('#view_not_eligible_student').html(data);
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    });
});

function NotEligibleBySearch(student_name, url) {
    // alert(student_name+ '  '+url);
    var course_url = $('#course_url').val();
    $.ajax({
        type: 'post',
        url: url,
        data: {student_name: student_name, course_url: course_url},
        beforeSend: function () {
            $('#loading_image').show();
            $('#view_not_eligible_student').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#view_not_eligible_student').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#view_not_eligible_student').html(data);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
}


/*-------------------- end not eligible student ------------------*/



/*
 -----------@@@RIPON@ Start register course student Part----------------------------------
 */
/*
 * @Function            : removeStudent 
 * @Used IN             : @function-'user/course/course_registered_student.php
 * @Description         : remove course register student
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 13-08-2016 01:41 pM  
 * @Parameter           : url[STRING], studentID[INTEGER]
 * @Return              : NULL    
 * @Status              : Available        
 */
function removeRegisterStudent(url, studentRoll) {
    $.post(url, {student_roll_number: studentRoll}, function () {
        location.reload();
    });
}

/*
 * @Function            : viewRegisteredStudentBYDate 
 * @Description         : View register student by datewise
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:40 PM  
 * @Parameter           : StartData,endDate
 * @Return              : NULL    
 * @Status              : Available        
 */
var viewRegisteredStudentBYDate = function (startDate, endDate) {
    var todaysData = getTodaysDate();

    if (startDate <= endDate) {
        if (todaysData >= endDate) {
            viewRegisterCourse(startDate, endDate);
            $('#errorMessage').html('');
        } else {
            $('#errorMessage').html('<span style="color:red;">Your can not select date after today!</span>');
        }
    } else {
        $('#errorMessage').html('<span style="color:red;">Please select date between to range!</span>');
    }
};


/*
 * @Function            : viewRegisterCourse 
 * @Description         : View register Course
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:51 PM  
 * @Parameter           : StartData,endDate
 * @Return              : NULL    
 * @Status              : Available        
 */
var viewRegisterCourse = function (startDate, endDate) {
    var courseID = $('#courseID').val();
    var registerStudentUrl = $('#registerStudentUrl').val();

    $.ajax({
        type: 'post',
        url: registerStudentUrl,
        data: {start_date: startDate, end_date: endDate, course_id: courseID},
        beforeSend: function () {
            $('#loading_image').show();
            $('#view_register_student').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#view_register_student').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#view_register_student').html(data);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
};

/*
 * @Description         : get current date
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:38 PM 
 * @Status              : Available        
 */
var getTodaysDate = function () {
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!

    var yyyy = today.getFullYear();
    if (dd < 10) {
        dd = '0' + dd;
    }
    if (mm < 10) {
        mm = '0' + mm;
    }
    return yyyy + '-' + mm + '-' + dd;
};
/*
 * @Description         : register student pagination
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 01:41 PM  
 * @Status              : Available        
 */
$(document).ready(function () {
    $(document).on('click', 'a[id^=registerCourseStudentPagination]', function () {
        var courseID = $('#courseID').val();
        var paginationUrl = $('#paginationUrl').val();
        var pageNumber = this.id.replace('registerCourseStudentPagination', '');

        $.ajax({
            type: 'post',
            url: paginationUrl,
            data: {course_id: courseID, page_number: pageNumber},
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_register_student').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_register_student').attr('style', 'opacity:1');
            },
            success: function (data) {
                $('#view_register_student').html(data);
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    });
});

/*
 -----------@@@RIPON@ End register course student Part----------------------------------
 */


/*---------------------------------------- start backend batch start date: 27-09-2016--------------------------------------------*/



function getCourseInfo(course_id, url) {
    //alert(course_id);
    if (course_id !== '') {
        $.ajax({
            url: url,
            type: 'post',
            data: {course_id: course_id},
            success: function (data) {
                $('#course_info').html(data);
                $('#datetimepicker1').datetimepicker({
                    viewMode: 'years',
                    format: 'YYYY-MM-DD'
                });
                $('#datetimepicker5').datetimepicker({
                    viewMode: 'years',
                    format: 'YYYY-MM-DD'
                });
                //runValidationEngine();
            }
        });
    }
}
function getCourseType(course_type, url) {
    if (course_type !== '') {
        $.ajax({
            url: url,
            type: 'post',
            data: {course_type: course_type},
            success: function (responseData) {
                if (course_type === '3' || course_type === '4') {
                    $("#search_area").show();
                } else if (course_type === '1' || course_type === '2') {
                    $("#search_area").hide();
                }
                $("#course_area").html(responseData);
            }
        });
    }
}

function getCourseSearchValue(search_value, course_type, url) {
    $.ajax({
        url: url,
        type: 'post',
        data: {search_value: search_value, course_type: course_type},
        success: function (responseData) {
            $("#course_area").html(responseData);
        }
    });
}

function cancel_batch(course_batch_id, url) {
    $.ajax({
        url: url,
        type: 'post',
        data: {course_batch_id: course_batch_id},
        success: function () {
            location.reload();
        }
    });
}

function delete_batch(course_batch_id, url) {
    $.ajax({
        url: url,
        type: 'post',
        data: {course_batch_id: course_batch_id},
        success: function () {
            location.reload();
        }
    });
}


/*
 * @Description         : Makes registered student not eligible for course
 * @Developed By        : Unknown
 * @Start DateTime      : Unknown  
 * @Status              : Available
 * @Commented By        : Md Mashqur Ul Alam [06-02-17]        
 */
function make_not_eligible(url, student_id, course_id) {
    $.ajax({
        url: url,
        type: 'post',
        data: {student_id: student_id, course_id: course_id},
        success: function () {
            location.reload();
        }
    });
}

/*
 * @Description         : Event fires when cross icon clicked in assigned student list
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 06-02-17
 * @Status              : Available      
 */
$(document).on('click', 'a[id^="removeAssignedStudent"]', function () {
    var studentId = this.id.replace('removeAssignedStudent', '');
    $("#removeAssignedStudentModal" + studentId).modal('show');
}).on('click', 'button[id^="modalNoButtonAssign"]', function () {
    var studentId = this.id.replace('modalNoButtonAssign', '');
    $("#removeAssignedStudentModal" + studentId).modal('hide');
}).on('click', 'button[id^="modalYesButtonAssign"]', function () {
    var studentId = this.id.replace('modalYesButtonAssign', '');
    adminRemoveAssignStudent(studentId);
});


/*
 * @Description         : Removes Assigned student from batch in Admin
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 06-02-17
 * @Parameter           : studentId
 * @Status              : Available        
 */
function adminRemoveAssignStudent(studentId) {
    var courseBatchId = $('#courseBatchId').val();
    var studentNumber = $('#studentNumber').val();
    var url = $('#baseUrl').val() + 'super_admin_batch/remove_assigned_student';
    $.post(url,
            {
                studentID: studentId,
                batchID: courseBatchId
            },
            function () {
                if (studentNumber === '1') {
                    window.location = $('#baseUrl').val() + 'super-admin/manage-batch';
                } else {
                    location.reload();
                }
            });
}


/*
 * @Description         : Get the course in search option of batch
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 13-02-17
 * @Parameter           : course_type, url
 * @Status              : Available        
 */
function searchBatchGetCourseType(course_type, url) {
    if (course_type !== '') {
        $.ajax({
            url: url,
            type: 'post',
            data: {course_type: course_type},
            success: function (responseData) {
                if (course_type === '3' || course_type === '4') {
                    $("#search_area").show();
                } else if (course_type === '1' || course_type === '2') {
                    $("#search_area").hide();
                }
                $("#course_area").html(responseData);
            }
        });
    }
}


/*
 * @Description         : Get the course in search option of batch
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 13-02-17
 * @Parameter           : search_value, course_type, url
 * @Status              : Available        
 */
function BatchGetCourseSearchValue(search_value, course_type, url) {
    $.ajax({
        url: url,
        type: 'post',
        data: {search_value: search_value, course_type: course_type},
        success: function (responseData) {
            $("#course_area").html(responseData);
        }
    });
}


/*
 * @Description         : Loads the view of batch based on course in search section
 *                        of batch
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 13-02-17
 * @Parameter           : courseId, url
 * @Status              : Available        
 */
function adminViewBatchByCourse(courseId, url) {
    $.ajax({
        type: 'post',
        url: url,
        data: {course_id: courseId},
        beforeSend: function () {
            $('#loading_image').show();
            $('#searchBatchMainContent').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#searchBatchMainContent').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#searchBatchMainContent').html(data);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
}


/*
 * @Description         : Loads the edit batch form in admin batch section editing
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 15-02-17
 * @Parameter           : Null
 * @Status              : Available        
 */
$(document).on('click', 'a[id^=ajaxEditBatch]', function () {
    var courseBatchId = this.id.replace('ajaxEditBatch', '');
    var url = $('#baseUrl').val() + 'super_admin_batch/ajax_edit_batch';
    $.ajax({
        type: 'post',
        url: url,
        data: {course_batch_id: courseBatchId},
        beforeSend: function () {
            $('#loading_image').show();
            $('#searchBatchMainContent').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#searchBatchMainContent').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#searchBatchMainContent').html(data);

            $('#datetimepicker1').datetimepicker({
                viewMode: 'years',
                format: 'YYYY-MM-DD'
            });

            $('#datetimepicker5').datetimepicker({
                viewMode: 'years',
                format: 'YYYY-MM-DD'
            });
            //$('#ajaxEditBatchForm').validationEngine();
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
});


/*
 * @Description         : Submits edit batch form and updates the edited batch
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 15-02-17
 * @Parameter           : Null
 * @Status              : Available        
 */
$('#ajax_batch_submit').click(function () {
    var url = $('#baseUrl').val() + 'super_admin_batch/ajax_update_batch';
    var courseBatchId = $('#courseBatchId').val();
    var courseBatchName = $('#edit_course_batch_name').val();
    var course = $('#edit_course').val();
    var courseBatchStartDate = $('#edit_course_batch_start_date').val();
    var courseBatchEndDate = $('#edit_course_batch_finish_date').val();
    $.post(url,
            {
                course_batch_id: courseBatchId,
                course: course,
                course_batch_name: courseBatchName,
                course_batch_start_date: courseBatchStartDate,
                course_batch_finish_date: courseBatchEndDate
            },
            function (data) {
                var output = JSON.parse(data);
                if (output === 'updated') {
                    var viewUrl = $('#baseUrl').val() + 'super_admin_batch/view_batch_by_course';
                    var courseId = course;
                    adminViewBatchByCourse(courseId, viewUrl);
                } else {
                    $('#searchBatchMainContent').html(output);
                }
            });

});


/*
 * @Description         : cancel batch in ajax serach batch section
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 15-02-17
 * @Parameter           : courseBatchId, url
 * @Status              : Available        
 */

function cancel_batch_search(courseBatchId, url) {
    $.post(url, {course_batch_id: courseBatchId}, function () { 
        var viewUrl = $('#baseUrl').val() + 'super_admin_batch/view_batch_by_course';
        var courseId = $('#course').val();
        adminViewBatchByCourse(courseId, viewUrl);
    });
}

/*
 * @Description         : delete batch in ajax serach batch section
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 15-02-17
 * @Parameter           : courseBatchId, url
 * @Status              : Available        
 */
function delete_batch_search(courseBatchId, url){
    $.post(url, {course_batch_id: courseBatchId}, function () { 
        var viewUrl = $('#baseUrl').val() + 'super_admin_batch/view_batch_by_course';
        var courseId = $('#course').val();
        adminViewBatchByCourse(courseId, viewUrl);
    });
}


/*
 * @Description         : set the curent batch tab of user in ajax search section
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 15-02-17
 * @Parameter           : Null
 * @Status              : Available        
 */
function setBatchTab(tabType){
    var url = $('#baseUrl').val()+'super_admin_batch/update_batch_tab';
    $.post(url, {batch_tab: tabType});
}

/*------------------------------------------------------------------------------------*/