function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}




/*
 * @Function            : getVideoCourseAccessLevel 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get video Course Access Level and 'BLOCK' video Group OR video Special User 'DIV'
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 06:07 PM
 * @Status              : available      
 */
//function getVideoCourseAccessLevel(accessLevel) {
//    if (accessLevel === '4') {
//        documentID('group_div').style.display = 'block';
//        documentID('special_user_div').style.display = 'none';
//        documentID('check_checkbox_name_div').innerHTML = '';
//        documentID('check_checkbox_name_div').style.display = 'none';
//    } else if (accessLevel === '5') {
//        documentID('group_div').style.display = 'none';
//        documentID('special_user_div').style.display = 'block';
//        documentID('check_checkbox_name_div').innerHTML = '';
//        documentID('check_checkbox_name_div').style.display = 'none';
//    } else {
//        documentID('group_div').style.display = 'none';
//        documentID('special_user_div').style.display = 'none';
//        documentID('check_checkbox_name_div').innerHTML = '';
//        documentID('check_checkbox_name_div').style.display = 'none';
//    }
//}




/*
 * @Function            : getCourseType 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get Course Type and 'BLOCK' video course price 'DIV'
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:07 PM
 * @Status              : available      
 */
function getCourseType(courseType) {
    if (courseType === '1') {
        documentID('video_course_Price').style.display = 'block';
    } else {
        documentID('video_course_Price').style.display = 'none';
    }
}

/*
 * @Function            : makeVideoCourseUrl 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Make video URL using course title
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
function makeVideoCourseUrl(profileID) {
    if (profileID === '') {
        documentID('video_course_url').value = '';
    } else {
        profileID = profileID.replace(/  +/g, '');
        for (i = 0; profileID.length > i; i++) {
            if (profileID.charAt(i) === ' ') {
                profileID = profileID.replace(/ +/g, '-');
            }
            if (profileID.charAt(i) === '.') {
                profileID = profileID.replace(/\./g, '');
            }
            if (profileID.charAt(i) === '-') {
                profileID = profileID.replace(/--/g, '-');
            }
        }

        profileID = profileID.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
        if (profileID.charAt(profileID.length - 1) === '-') {
            profileID = setCharAt(profileID, profileID.length - 1, '');
        }
        profileID = profileID.toLowerCase();
        checkVideoCourseURLExists(profileID, 1);
    }
    //checkJQueryValudation('video_course_url', 'video_course_url_error', 'input');
}


/*
 * @Function            : checkFolderName 
 * @Used IN             : @admin/video/add_video_course.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : check URl if it is Exists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 14-02-2016 07:54 PM
 * @Status              : available      
 */
function checkFolderName(folderName, url) {
    var videoFolderExistsResponse;
    videoFolderExistsResponse = checkXMLHTTP(videoFolderExistsResponse);

    var folderName1 = folderName.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("video_folder_name", folderName1);

    videoFolderExistsResponse.addEventListener("load", function () {

        if (videoFolderExistsResponse.responseText === '1') {
            documentID('folder_exists').value = '1';            
        } else if (videoFolderExistsResponse.responseText === '2') {
            documentID('folder_exists').value = '';
        }

    }, false);
    videoFolderExistsResponse.open("POST", url);
    videoFolderExistsResponse.send(formdata);
}



/*
 * @Function            : checkeditFolderName 
 * @Used IN             : @admin/video/edit_video_course.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : check URl if it is Exists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 14-02-2016 07:54 PM
 * @Status              : available      
 */
function checkeditFolderName(folderName, url, videoManagementID) {
    var videoFolderExistsResponse;
    videoFolderExistsResponse = checkXMLHTTP(videoFolderExistsResponse);

    var folderName1 = folderName.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("video_folder_name", folderName1);
    formdata.append("video_management_id", videoManagementID);

    videoFolderExistsResponse.addEventListener("load", function () {


        if (videoFolderExistsResponse.responseText === '1') {
            documentID('folder_exists').value = '1';            
        } else if (videoFolderExistsResponse.responseText === '2') {
            documentID('folder_exists').value = '';            
        }

    }, false);
    videoFolderExistsResponse.open("POST", url);
    videoFolderExistsResponse.send(formdata);
}



/*
 * @Function            : checkVideoCourseURLExists 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : check URl if it is Exists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
var checkVideoCourseURLExistsURL;
function checkVideoCourseURLExists(url, status) {
    var checkVideoCourseURLExistsResponse;
    checkVideoCourseURLExistsResponse = checkXMLHTTP(checkVideoCourseURLExistsResponse);

    var formdata = new FormData();
    formdata.append("video_course_url", url);
    formdata.append("url_status", status);

    checkVideoCourseURLExistsResponse.addEventListener("load", function () {

        if (status === 1) {
            documentID('video_course_url').value = checkVideoCourseURLExistsResponse.responseText;
        } else {
            if (checkVideoCourseURLExistsResponse.responseText === '1') {
                documentID('url_exist').value = 1;
                //checkJQueryValudation('video_course_url', 'video_course_url_error', 'input');
            } else if (checkVideoCourseURLExistsResponse.responseText === '2') {
                documentID('url_exist').value = '';
                //checkJQueryValudation('video_course_url', 'video_course_url_error', 'input');
            }
        }

    }, false);
    checkVideoCourseURLExistsResponse.open("POST", checkVideoCourseURLExistsURL);
    checkVideoCourseURLExistsResponse.send(formdata);
}




/*
 * @Function            : checkGroupPersonID 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//var checkGroupPersonURL;
//function checkGroupPersonID(groupID) {
//    var groupResponse1;
//    groupResponse1 = checkXMLHTTP(groupResponse1);
//
//    var courseID = documentID('video_course_id').value;
//    if (courseID) {
//        var fullURL = checkGroupPersonURL + '/' + groupID + '/' + courseID;
//        groupResponse1.open("GET", fullURL);
//        groupResponse1.onreadystatechange = function ()
//        {
//            if (groupResponse1.readyState === 4 && groupResponse1.status === 200)
//            {
//                if (groupResponse1.responseText === '1') {
//                    documentID('group_id' + groupID).checked = true;
//                    documentID('group_checkbox_error' + groupID).innerHTML = 'This group already have a registered user';
//                } else if (groupResponse1.responseText === '2') {
//                    getGroupIDValue(groupID);
//                }
//            }
//        };
//        groupResponse1.send(null);
//    } else {
//        getGroupIDValue(groupID);
//    }
//}



/*
 * @Function            : getGroupIDValue 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//var groupList = new Array();
//function getGroupIDValue(inputValue) {
//    documentID('hidden_search_group_name').value = '';
//    if ($("#group_id" + inputValue).is(":checked")) {
//        if (groupList.length < 5) {
//            groupList.push(inputValue);
//            documentID('hidden_search_group_name').value = groupList;
//        } else {
//            documentID('search_group_name_error').innerHTML = 'You can not selected more than 5 group';
//            documentID('group_id' + inputValue).checked = false;
//            documentID('hidden_search_group_name').value = groupList;
//        }
//    } else {
//        var index = groupList.indexOf(inputValue);
//        groupList.splice(index, 1);
//        documentID('hidden_search_group_name').value = groupList;
//        documentID('search_group_name_error').innerHTML = '';
//    }
//}



/*
 * @Function            : getSearchGroupName 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//function getSearchGroupName(url, inputValue) {
//    var groupResponse;
//    groupResponse = checkXMLHTTP(groupResponse);
//
//    var inputValue1 = inputValue.replace(/ +/g, '');
//    var searchGroupName;
//
//    if (inputValue1 === '') {
//        searchGroupName = 'null';
//    } else {
//        searchGroupName = inputValue1;
//    }
//
//    var fullURL = url + '/' + searchGroupName + '/' + groupList;
//    groupResponse.open("GET", fullURL);
//    groupResponse.onreadystatechange = function ()
//    {
//        if (groupResponse.readyState === 4 && groupResponse.status === 200)
//        {
//            documentID('check_checkbox_name_div').style.display = 'block';
//            documentID('check_checkbox_name_div').innerHTML = groupResponse.responseText;
//            documentID('search_group_name_error').innerHTML = '';
//        }
//    };
//    groupResponse.send(null);
//}


/*
 * @Function            : checkPersonID 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//var checkPersonURL;
//function checkPersonID(personID) {
//    var specialUserResponse1;
//    specialUserResponse1 = checkXMLHTTP(specialUserResponse1);
//
//    var courseID = documentID('video_course_id').value;
//    if (courseID) {
//        var fullURL = checkPersonURL + '/' + personID + '/' + courseID;
//        specialUserResponse1.open("GET", fullURL);
//        specialUserResponse1.onreadystatechange = function ()
//        {
//            if (specialUserResponse1.readyState === 4 && specialUserResponse1.status === 200)
//            {
//                if (specialUserResponse1.responseText === '1') {
//                    documentID('person_id' + personID).checked = true;
//                    documentID('special_checkbox_error' + personID).innerHTML = 'You can not remove registered student';
//                } else if (specialUserResponse1.responseText === '2') {
//                    getPersonIDValue(personID);
//                }
//            }
//        };
//        specialUserResponse1.send(null);
//    } else {
//        getPersonIDValue(personID);
//    }
//}
//


/*
 * @Function            : getPersonIDValue 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//var personList = new Array();
//function getPersonIDValue(inputValue) {
//    documentID('hidden_special_user_name').value = '';
//    if ($("#person_id" + inputValue).is(":checked")) {
//        if (personList.length < 10) {
//            personList.push(inputValue);
//            documentID('hidden_special_user_name').value = personList;
//        } else {
//            documentID('search_special_user_name_error').innerHTML = 'You can not selected more than 10 User';
//            documentID('person_id' + inputValue).checked = false;
//            documentID('hidden_special_user_name').value = personList;
//        }
//    } else {
//        var index = personList.indexOf(inputValue);
//        personList.splice(index, 1);
//        documentID('hidden_special_user_name').value = personList;
//        documentID('search_group_name_error').innerHTML = '';
//    }
//}


/*
 * @Function            : getSearchSpecialUser 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Copied from Course.js
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 10-02-2016 07:54 PM
 * @Status              : available      
 */
//function getSearchSpecialUser(url, inputValue) {
//    var specialUserResponse;
//    specialUserResponse = checkXMLHTTP(specialUserResponse);
//
//    var inputValue1 = inputValue.replace(/ +/g, '');
//    var searchGroupName;
//    if (inputValue1 === '') {
//        searchGroupName = 'null';
//    } else {
//        searchGroupName = inputValue1;
//    }
//
//    var fullURL = url + '/' + searchGroupName + '/' + personList;
//    specialUserResponse.open("GET", fullURL);
//    specialUserResponse.onreadystatechange = function ()
//    {
//        if (specialUserResponse.readyState === 4 && specialUserResponse.status === 200)
//        {
//            documentID('check_checkbox_name_div').style.display = 'block';
//            documentID('check_checkbox_name_div').innerHTML = specialUserResponse.responseText;
//            documentID('search_special_user_name_error').innerHTML = '';
//        }
//    };
//    specialUserResponse.send(null);
//}



/*
 * @Function            : changeVideoCourseStatus 
 * @Used IN             : @function-'Self'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Change all kind of status in manage-video
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 13-02-2016 01:29 PM
 * @Status              : available      
 */
function changeVideoCourseStatus(url, ID, type) {
    var changeVideoCourseStatusResponse;
    changeVideoCourseStatusResponse = checkXMLHTTP(changeVideoCourseStatusResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + type + " this Video?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("video_management_id", ID);
                    formdata.append("change_status", type);

                    changeVideoCourseStatusResponse.addEventListener("load", function () {

                        switch (type) {
                            case 'active':
                            case 'inactive':
                            case 'pending':
                            case 'approved':
                            case 'archive':
                                documentID('video_course_status' + ID).innerHTML = changeVideoCourseStatusResponse.responseText;
                                break;
                            case 'delete':
                                location.reload();
                                break;
                        }

                    }, false);
                    changeVideoCourseStatusResponse.open("POST", url);
                    changeVideoCourseStatusResponse.send(formdata);
                }
            });
}



/*
 * @Function            : getVideoUrl 
 * @Used IN             : @function-'admin/video/edit_video_course.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : check URL in edit video Course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 13-02-2016 07:13 PM
 * @Status              : available      
 */
function getVideoUrl(newURL, oldURL) {
    if (newURL !== oldURL) {
        checkVideoCourseURLExists(newURL, '');
    } else {
        documentID('url_exist').value = '';
    }
}



/*
 * @Function            : getVideoCourseSearchValue 
 * @Used IN             : @function-'admin/video/manage_video_course.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : view video course using search
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 14-02-2016 11:03 AM
 * @Status              : available      
 */
function getVideoCourseSearchValue(searchValue, url) {
    var searchVideoExistsResponse;
    searchVideoExistsResponse = checkXMLHTTP(searchVideoExistsResponse);

    var inputValue1 = searchValue.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("search_value", inputValue1);

    searchVideoExistsResponse.addEventListener("load", function () {

        documentID('view_video_courses').innerHTML = searchVideoExistsResponse.responseText;

    }, false);
    searchVideoExistsResponse.open("POST", url);
    searchVideoExistsResponse.send(formdata);
}



/*
 -----------@@@RIPON@ Start Video Course Work File Part----------------------------------
 */
/*
 * @Function            : getCategoryId 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'
 * @Developed By        : Ripon Jahrul
 * @Start DateTime      : 14-02-2016 05:14 PM         
 */
function getCategoryId(input, url) {
    var courseResponse;
    courseResponse = checkXMLHTTP(courseResponse);

    if (input !== '') {
        documentID('category_id_error').innerHTML = '';
        documentID('course_category_validate').value = '1';

        var formdata = new FormData();
        formdata.append("category_id", input);

        courseResponse.addEventListener("load", function () {

            documentID('course_id').innerHTML = courseResponse.responseText;

        }, false);
        courseResponse.open("POST", url);
        courseResponse.send(formdata);
    } else {
        documentID('category_id_error').innerHTML = 'Please Select Course Category';
        documentID('course_category_validate').value = '';
    }
}


/*
 * @Function            : get_course_by_category_id 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'      
 * @Description         : get all available course using category ID  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 14-02-2016 04:57 PM      
 * @Status              : available      
 */
function getCourseId(courseID, url) {
    var courseResponse1;
    courseResponse1 = checkXMLHTTP(courseResponse1);

    if (courseID !== '') {
        documentID('course_id_error').innerHTML = '';
        documentID('video_course_validate').value = '1';

        var formdata = new FormData();
        formdata.append("video_management_id", courseID);

        courseResponse1.addEventListener("load", function () {

            documentID('upload_video_section1').innerHTML = courseResponse1.responseText;

        }, false);
        courseResponse1.open("POST", url);
        courseResponse1.send(formdata);
    } else {
        documentID('course_id_error').innerHTML = 'Please Select Video Course';
        documentID('video_course_validate').value = '';
    }
}


/*
 * @Function            : getVideoSectionName 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'      
 * @Description         : Check sction Name
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 14-02-2016 05:15 PM      
 * @Status              : available      
 */
function getVideoSectionName(sectionName, sectionCounter, url) {
    var videoSectionResponse;
    videoSectionResponse = checkXMLHTTP(videoSectionResponse);
    var fileRegx = /^[0-9a-zA-Z\-, ]+$/;

    var categoryID = documentID('course_category_validate').value;
    var courseID = documentID('video_course_validate').value;

    if (categoryID === '1' && courseID === '1') {
        if (sectionName !== '') {
            documentID('video_section_name_errror' + sectionCounter).innerHTML = '';

            if (fileRegx.test(sectionName)) {

                var formdata = new FormData();
                formdata.append("video_section_name", sectionName);
                formdata.append("video_management_id", documentID('course_id').value);
                formdata.append("all_upload_id", documentID('allUploadVideoID_sec_' + sectionCounter).value);

                videoSectionResponse.addEventListener("load", function () {

                    if (videoSectionResponse.responseText === '1') {
                        documentID('video_section_validate' + sectionCounter).value = '';
                        documentID('video_section_name_errror' + sectionCounter).innerHTML = 'Video Section Name Already Exists';
                    } else if (videoSectionResponse.responseText === '2') {
                        documentID('video_section_validate' + sectionCounter).value = '1';
                        documentID('video_section_name_errror' + sectionCounter).innerHTML = '';
                    }

                }, false);
                videoSectionResponse.open("POST", url);
                videoSectionResponse.send(formdata);
            } else {
                documentID('video_section_validate' + sectionCounter).value = '';
                documentID('video_section_name_errror' + sectionCounter).innerHTML = 'No Special Caracter Allow Accept -,';
            }
        } else {
            documentID('video_section_validate' + sectionCounter).value = '';
            documentID('video_section_name_errror' + sectionCounter).innerHTML = 'Please Type Course Secion Name';
        }
    } else {
        documentID('video_section_name' + sectionCounter).value = '';
        documentID('video_section_name' + sectionCounter).placeholder = 'Please complete previous input properly';
    }
}


/*
 * @Function            : getVideoName 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get Video Name and check exists or others 
 * @                    : @Update1 - check video name using upload video ID if any video upload 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-02-2016 12:28 PM  
 * @Updated Date Time   : 20-02-2016 10:56 PM
 * @Updated By          : Ripon Jaherul          
 * @Status              : available      
 */
function getVideoName(sectionCounter, videoCounter, url) {
    documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
    var videoNameResponse;
    videoNameResponse = checkXMLHTTP(videoNameResponse);

    var categoryID = documentID('course_category_validate').value;
    var courseID = documentID('video_course_validate').value;
    var sectionNameValidate = documentID('video_section_validate' + sectionCounter).value;

    if (categoryID === '1' && courseID === '1' && sectionNameValidate === '1') {
        var fileRegx = /^[0-9a-zA-Z\-, ]+$/;
        var videoName = documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).value;
        if (videoName !== '') {
            if (fileRegx.test(videoName)) {
                var uploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
                if (uploadVideoID1 !== '') {
                    var uploadVideoID2 = uploadVideoID1.split(',');
                    var uploadVideoID = uploadVideoID2[0];
                    var videoCourseID = documentID('course_id').value;
                    var videoName1 = videoName.replace(/  +/g, ' ');
                    var uploadSingleVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;

                    var formdata = new FormData();
                    formdata.append("upload_video_name", videoName1);
                    formdata.append("video_management_id", videoCourseID);
                    formdata.append("upload_video_id", parseInt(uploadVideoID));
                    formdata.append("upload_video_id1", parseInt(uploadSingleVideoID));

                    videoNameResponse.addEventListener("load", function () {

                        if (videoNameResponse.responseText === '1') {
                            documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                            documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Video Name Already Exists';
                        } else if (videoNameResponse.responseText === '2') {
                            documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
                            documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                        }

                    }, false);
                    videoNameResponse.open("POST", url);
                    videoNameResponse.send(formdata);
                } else {
                    documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
                }
            } else {
                documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'No Special Caracter Allow Accept -,';
            }
        } else {
            documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please Type Video Name';
        }
    } else {
        documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).placeholder = 'Please complete previous input properly';
    }
}



/*
 * @Function            : viewCourseCategory 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Fixed course and category view
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 16-02-2016 03:43 PM      
 * @Status              : available      
 */
var viewCourseCategoryURL;
function viewCourseCategory(videoManagementID) {
    var courseCategoryResponse;
    courseCategoryResponse = checkXMLHTTP(courseCategoryResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoManagementID);

    courseCategoryResponse.addEventListener("load", function () {

        documentID('course_category_view').innerHTML = courseCategoryResponse.responseText;

    }, false);
    courseCategoryResponse.open("POST", viewCourseCategoryURL);
    courseCategoryResponse.send(formdata);
}


/*
 * @Function            : getVideoFileSize 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get uploaded file size and total file size in user profile
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 16-02-2016 03:43 PM      
 * @Status              : available      
 */
var videoFileSizeResponseURL;
function getVideoFileSize(videoManagementID, videoFile, sectionCounter, videoCounter) {
    var videoFileSizeResponse;
    videoFileSizeResponse = checkXMLHTTP(videoFileSizeResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoManagementID);
    formdata.append("upload_file", videoFile);

    videoFileSizeResponse.addEventListener("load", function () {

        documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = videoFileSizeResponse.responseText;

    }, false);
    videoFileSizeResponse.open("POST", videoFileSizeResponseURL);
    videoFileSizeResponse.send(formdata);
}


/*
 * @Function            : addSingleValue 
 * @Used IN             : @function-'uploadVideoFile -     (@2-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'getWorkFileStatus -   (@1-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'uploadVideoWorkFile - (@2-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Add single section for uploaded video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-02-2016 07:04 PM      
 * @Status              : available      
 */
function addSingleValue(field, sectionCounter, addID) {
    var allUploadVideoOKcounter = new Array();
    var allUploadVideoOKcounter1 = documentID(field + sectionCounter).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }

    if (allUploadVideoOKcounter.length < 0) {
        allUploadVideoOKcounter.push(addID);
    } else {
        if (allUploadVideoOKcounter.indexOf(addID) < 0) {
            allUploadVideoOKcounter.push(addID);
        }
    }
    documentID(field + sectionCounter).value = allUploadVideoOKcounter;
}

/*
 * @Function            : removeSingleVideoSection 
 * @Used IN             : @function-'removeSingleVideo -    (@6-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'getVideoWorkFile -     (@2-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'uploadVideoWorkFile -  (@1-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'getWorkFileStatus -    (@1-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'removeUploadWorkFile - (@3-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'getVideoFile -         (@2-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @                    : @function-'uploadVideoFile -      (@1-times)'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove single section for uploaded video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-02-2016 07:04 PM      
 * @Status              : available      
 */
function deleteSingleValue(field, sectionCounter, removeID) {
    var allUploadVideoCounter = new Array();
    var allUploadVideoCounter1 = documentID(field + sectionCounter).value;
    if (allUploadVideoCounter1 !== '') {
        allUploadVideoCounter = allUploadVideoCounter1.split(',');
    }
    if (allUploadVideoCounter.length > 0) {
        if (allUploadVideoCounter.indexOf(removeID) > -1) {
            var index = allUploadVideoCounter.indexOf(removeID);
            allUploadVideoCounter.splice(index, 1);
        }
        documentID(field + sectionCounter).value = allUploadVideoCounter;
    }
}

/*
 * @Function            : uploadVideoFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Upload video file in Database
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 16-02-2016 10:38 PM      
 * @Status              : available      
 */
var sectionName = new Array();
function uploadVideoFile(videoFile, sectionCounter, videoCounter, url, fileStatus) {
    var uploadVideoResponse;
    uploadVideoResponse = checkXMLHTTP(uploadVideoResponse);

    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    var allUploadVideoID = new Array();
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }

    var videoManagementID = documentID('course_id').value;
    var videoSectionName = documentID('video_section_name' + sectionCounter).value;
    var videoSectionName1 = videoSectionName.replace(/  +/g, ' ');
    var videoName = documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).value;
    var videoName1 = videoName.replace(/  +/g, ' ');
    var videoTranscript = documentID('upload_video_transcript' + sectionCounter + '_video' + videoCounter).value;
    var videoTranscript1 = videoTranscript.replace(/  +/g, ' ');

    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;

    var formdata = new FormData();
    formdata.append("video_file", videoFile);
    formdata.append("video_management_id", videoManagementID);
    formdata.append("upload_video_section_name", videoSectionName1);
    formdata.append("upload_video_name", videoName1);
    formdata.append("upload_video_transcript", videoTranscript1);
    formdata.append("upload_video_access_level", fileStatus);
    formdata.append("upload_video_id", uploadVideoID);
    formdata.append("all_upload_video_id", allUploadVideoID);

    uploadVideoResponse.upload.addEventListener("progress", function (event) {

        if (documentID('editFileName_sec_' + sectionCounter + '_video' + videoCounter)) {
            documentID('editFileName_sec_' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('editFileName_sec_' + sectionCounter + '_video' + videoCounter).style.display = 'none';
        }

        documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>Upload Completed</span>';
            documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '1';

            addSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);

            viewCourseCategory(videoManagementID);

            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).removeAttribute("disabled");
            documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('processing_image' + sectionCounter + '_video' + videoCounter).style.display = 'block';
            
        } else {
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).setAttribute('disabled', '');
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>' + Math.round(percent) + '% uploading</span>';
        }

    }, false);

    uploadVideoResponse.addEventListener("load", function () {

        if (uploadVideoResponse.responseText === 'error') {
            documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Uploading invalid video file';

            deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);

        } else {
            var videoUploadID = uploadVideoResponse.responseText;

            if (allUploadVideoID.length < 1) {
                allUploadVideoID.push(videoUploadID);
            } else {
                if (allUploadVideoID.indexOf(videoUploadID) < 0) {
                    allUploadVideoID.push(videoUploadID);
                }
            }
            
            getVideoFileSize(videoManagementID, videoFile, sectionCounter, videoCounter);
            documentID('processing_image' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
            addSingleValue('allUploadVideoID1_sec_', sectionCounter, videoUploadID);
            documentID('allUploadVideoID_sec_' + sectionCounter).value = allUploadVideoID;
            documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value = videoUploadID;
            documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = videoFile.name;
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        }

    }, false);
    uploadVideoResponse.open("POST", url);
    uploadVideoResponse.send(formdata);
}
/*
 * @Function            : getVideoFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get Video file for validation
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-02-2016 05:33 PM   
 * @Updated Date Time   : 16-02-2016 12:59 PM
 * @Updated By          : Ripon Jaherul    
 * @Status              : available      
 */
function getVideoFile(videoFile, sectionCounter, videoCounter, url) {
    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadVideoID) {
        deleteSingleValue('allUploadVideoID_sec_', sectionCounter, uploadVideoID);
    }

    deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);

    var categoryID = documentID('course_category_validate').value;
    var courseID = documentID('video_course_validate').value;
    var sectionNameValidate = documentID('video_section_validate' + sectionCounter).value;
    var videoNameValidate = documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value;
    var fileStatusName = document.getElementsByName('upload_video_access_level[' + sectionCounter + '][' + videoCounter + ']');
    var fileStatus = '';
    for (var i = 0; i < fileStatusName.length; i++) {
        if (fileStatusName[i].checked) {
            fileStatus = fileStatusName[i].value;
        }
    }

    if (categoryID === '1' && courseID === '1' && sectionNameValidate === '1' && videoNameValidate === '1' && fileStatus !== '') {
        var allowedVedioFileType = "mp4 flv 3gp webm avi wmv";
        var file = videoFile.files[0];
        var fileName = file.name;
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var n = allowedVedioFileType.search(fileExtention);
        if (n > -1) {
            if (file.size < 524288000) {

                uploadVideoFile(file, sectionCounter, videoCounter, url, fileStatus);

            } else {
                documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
                documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Video size must less then 500 Mb';
            }
        } else {
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please select vedio type: mp4 flv';
        }
    } else {
        documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
        documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}


/*
 * @Function            : removeUploadWorkFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove upload work file 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 17-02-2016 04:45 PM      
 * @Status              : available      
 */
var removeUploadWorkFileURl;
function removeUploadWorkFile(uploadWorkFileID, sectionCounter, videoCounter) {
    var removeUploadWorkFileResponse;
    removeUploadWorkFileResponse = checkXMLHTTP(removeUploadWorkFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete this Work File?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("work_files_management_id", uploadWorkFileID);

                    removeUploadWorkFileResponse.addEventListener("load", function () {

                        documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value = '';
                        documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                        documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';

                        deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
                        deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, uploadWorkFileID);
                        deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

                    }, false);
                    removeUploadWorkFileResponse.open("POST", removeUploadWorkFileURl);
                    removeUploadWorkFileResponse.send(formdata);
                }
            });
}

/*
 * @Function            : getWorkFileStatus 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more video file 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-02-2016 11:59 PM      
 * @Status              : available      
 */
function getWorkFileStatus(workFileStatus, sectionCounter, videoCounter, url) {
    var getWorkFileStatusResponse;
    getWorkFileStatusResponse = checkXMLHTTP(getWorkFileStatusResponse);

    var videoManagementID = documentID('course_id').value;
    var videoUploadStatus = documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value;

    if (videoUploadStatus === '1') {
        documentID('work_file_status_validate_sec_' + sectionCounter + '_video' + videoCounter).value = '1';
        documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        if (workFileStatus === '1') {
            var formdata = new FormData();
            formdata.append("video_management_id", videoManagementID);
            formdata.append("section_counter", sectionCounter);
            formdata.append("video_counter", videoCounter);

            getWorkFileStatusResponse.addEventListener("load", function () {

                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = getWorkFileStatusResponse.responseText;

                addSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);


            }, false);
            getWorkFileStatusResponse.open("POST", url);
            getWorkFileStatusResponse.send(formdata);

        } else if (workFileStatus === '2') {
            var uploadWorkFileID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;
            if (uploadWorkFileID) {

                removeUploadWorkFile(uploadWorkFileID, sectionCounter, videoCounter);

            } else {
                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';

                deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
            }
        }
    } else {
        documentID('work_file_yes' + sectionCounter + '_video' + videoCounter).checked = false;
        documentID('work_file_no' + sectionCounter + '_video' + videoCounter).checked = false;
        documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}



/*
 * @Function            : getWorkFileName 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : check work file name for several validation
 * @                    : @Update1 - check work file name usinf section wise
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 17-02-2016 11:45 AM  
 * @Updated Date Time   : 20-02-2016 11:04 AM
 * @Updated By          : Ripon Jaherul           
 * @Status              : available      
 */
function getWorkFileName(workFileName, sectionCounter, videoCounter, url) {
    var workFileNameResponse;
    workFileNameResponse = checkXMLHTTP(workFileNameResponse);

    var uploadSingleVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadSingleVideoID) {
        if (workFileName !== '') {
            var fileRegx = /^[0-9a-zA-Z\-, ]+$/;
            if (fileRegx.test(workFileName)) {
                var workFileName1 = workFileName.replace(/  +/g, ' ');

                var uploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
                if (uploadVideoID1 !== '') {
                    var uploadVideoID2 = uploadVideoID1.split(',');
                    var uploadVideoID = uploadVideoID2[0];


                    var formdata = new FormData();
                    formdata.append("upload_video_id", uploadVideoID);
                    formdata.append("work_files_name", workFileName1);
                    formdata.append("upload_video_id1", parseInt(uploadSingleVideoID));

                    workFileNameResponse.addEventListener("load", function () {

                        if (workFileNameResponse.responseText === '1') {
                            documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                            documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Work FIle Name Already Exists';
                        } else if (workFileNameResponse.responseText === '2') {
                            documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
                            documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                        }

                    }, false);
                    workFileNameResponse.open("POST", url);
                    workFileNameResponse.send(formdata);
                } else {
                    documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
                }
            } else {
                documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'No Special Caracter Allow Accept -,';
            }
        } else {
            documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please Type Work FIle Name';
        }
    }
}


/*
 * @Function            : getWorkFileSize 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get Work FIle size 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 17-02-2016 02:19 PM      
 * @Status              : available      
 */
function getWorkFileSize(videoManagementID, workFile, sectionCounter, videoCounter) {
    var videoFileSizeResponse;
    videoFileSizeResponse = checkXMLHTTP(videoFileSizeResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoManagementID);
    formdata.append("upload_file", workFile);

    videoFileSizeResponse.addEventListener("load", function () {

        documentID('view_work_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = videoFileSizeResponse.responseText;

    }, false);
    videoFileSizeResponse.open("POST", videoFileSizeResponseURL);
    videoFileSizeResponse.send(formdata);
}

/*
 * @Function            : uploadVideoWorkFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Upload work file in database
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 17-02-2016 12:39 AM      
 * @Status              : available      
 */
function uploadVideoWorkFile(workFile, sectionCounter, videoCounter, url, fileStatus) {
    var workFileResponse;
    workFileResponse = checkXMLHTTP(workFileResponse);

    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    var workFileName = documentID('work_files_name_sec' + sectionCounter + '_video' + videoCounter).value;
    var workFileName1 = workFileName.replace(/  +/g, ' ');
    var videoManagementID = documentID('course_id').value;

    var uploadVideoWorkID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;

    var formdata = new FormData();
    formdata.append("upload_video_id", uploadVideoID);
    formdata.append("video_work_file", workFile);
    formdata.append("work_files_name", workFileName1);
    formdata.append("work_files_management_access_level", fileStatus);
    formdata.append("work_files_management_id", uploadVideoWorkID);

    workFileResponse.upload.addEventListener("progress", function (event) {

        if (documentID('editWorkFileName_sec_' + sectionCounter + '_video' + videoCounter)) {
            documentID('editWorkFileName_sec_' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('editWorkFileName_sec_' + sectionCounter + '_video' + videoCounter).style.display = 'none';
        }
        documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>Upload Completed</span>';
            documentID('work_file_upload_status_sec' + sectionCounter + '_video' + videoCounter).value = '1';

            addSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).removeAttribute("disabled");
        } else {
            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).setAttribute("disabled", '');
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>' + Math.round(percent) + '% uploading</span>';
        }

    }, false);

    workFileResponse.addEventListener("load", function () {

        if (workFileResponse.responseText === 'error') {
            documentID('view_work_file_name' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('work_file_upload_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Uploading invalid video file';

            deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

        } else {
            var workFileUploadID = workFileResponse.responseText;

            addSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, workFileUploadID);

            documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value = workFileUploadID;
            documentID('view_work_file_name' + sectionCounter + '_video' + videoCounter).value = workFile.name;
            documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';

            getWorkFileSize(videoManagementID, workFile, sectionCounter, videoCounter);
        }

    }, false);
    workFileResponse.addEventListener("error", function () {
    }, false);
    workFileResponse.addEventListener("abort", function () {
        alert("Upload Aborted");
    }, false);
    workFileResponse.open("POST", url);
    workFileResponse.send(formdata);
}


/*
 * @Function            : getVideoWorkFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : get Work file and check all kiond of validation 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 17-02-2016 12:38 AM      
 * @Status              : available      
 */
function getVideoWorkFile(workFile, sectionCounter, videoCounter, url) {
    var uploadVideoWorkID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadVideoWorkID) {
        deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, uploadVideoWorkID);
    }

    deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

    var workFileNameValidate = documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value;
    var fileStatusName = document.getElementsByName('work_files_management_access_level[' + sectionCounter + '][' + videoCounter + ']');
    var fileStatus = '';
    for (var i = 0; i < fileStatusName.length; i++) {
        if (fileStatusName[i].checked) {
            fileStatus = fileStatusName[i].value;
        }
    }

    if (workFileNameValidate === '1' && fileStatus !== '') {
        documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';

        var file = workFile.files[0];
        var fileName = file.name;
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var allowedFileType = " zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                            docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                            xlsm mpp obi pst snp xsn olm  ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                            onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                            xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                            accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                            mam sldm maq accdu cnv maw xslb";

        var n = allowedFileType.search(fileExtention);
        if (n > -1) {
            if (file.size < 10485760) {

                uploadVideoWorkFile(file, sectionCounter, videoCounter, url, fileStatus);

            } else {
                documentID('work_file_upload_status_sec' + +sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_work_file_name' + +sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_work_file_size_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
                documentID('upload_work_file_error_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = 'File size must less then 10 Mb';
            }
        } else {
            documentID('work_file_upload_status_sec' + +sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_work_file_name' + +sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_work_file_size_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_work_file_error_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = 'Please select work file type: zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                            docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                            xlsm mpp obi pst snp xsn olm ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                            onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                            xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                            accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                            mam sldm maq accdu cnv maw xslb';
        }
    } else {
        documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}



/*
 * @Function            : removeSingleVideoSection 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove single section for uploaded video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-02-2016 11:13 PM      
 * @Status              : available      
 */
function removeSingleVideoSection(sectionCounter, url) {
    var video_course_url = $('#video_course_url_check').val();
    var removeSingleVideoSectionResponse;
    removeSingleVideoSectionResponse = checkXMLHTTP(removeSingleVideoSectionResponse);

    var allSectionCounter = new Array();
    var allSectionCounter1 = documentID('allSectionCounter').value;
    allSectionCounter = allSectionCounter1.split(',');
    var allUploadVideoID = documentID('allUploadVideoID1_sec_' + sectionCounter).value;

    var count_sec = allSectionCounter.length;
    console.log(count_sec);
    
    if (allSectionCounter.length > 1) {
        swal({
            title: "",
            text: "Are you sure you want to Delete Section?",
            showCancelButton: true,
            confirmButtonColor: '#8CC73F',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        if (allUploadVideoID !== '') {
                            var formdata = new FormData();
                            formdata.append("all_upload_video_id", allUploadVideoID);

                            removeSingleVideoSectionResponse.addEventListener("load", function () {
                                
                                if (removeSingleVideoSectionResponse.responseText === 'success') {
                                    var parentDiv = documentID('video_section_area');
                                    var childDiv = documentID('upload_video_section' + sectionCounter);
                                    if(count_sec !='1'){
                                        childDiv.remove();
                                    }
                                    //parentDiv.removeChild(childDiv);
                                    deleteSingleValue('allSectionCounter', '', sectionCounter);
                                }

                            }, false);
                            removeSingleVideoSectionResponse.open("POST", url);
                            removeSingleVideoSectionResponse.send(formdata);
                        } else {
                            var parentDiv = documentID('video_section_area');
                            var childDiv = documentID('upload_video_section' + sectionCounter);
                            if(video_course_url !==''){
                                childDiv.remove();
                            }else{
                                parentDiv.removeChild(childDiv);
                            }
                            deleteSingleValue('allSectionCounter', '', sectionCounter);
                        }
                    }
                });
    } else {
        swal({
            title: "",
            text: "You can not delete single Video Section",
            type: "warning",
            confirmButtonColor: '#01ba11',
            confirmButtonText: 'OK',
            closeOnConfirm: true
        });
    }
}


/*
 * @Function            : removeSingleVideo 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove Single upload video
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-02-2016 03:53 PM      
 * @Status              : available      
 */
function removeSingleVideo(sectionCounter, videoCounter, url) {
    var video_course_url = $('#video_course_url_check').val();
    var removeSingleVideoResponse;
    removeSingleVideoResponse = checkXMLHTTP(removeSingleVideoResponse);

    var allUploadVideoID = new Array();
    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }
    var count_video = allUploadVideoID.length;
    //console.log(count_video);
    
    if (allUploadVideoID.length >= 0) {
        swal({
            title: "",
            text: "Are you sure you want to Delete Video?",
            showCancelButton: true,
            confirmButtonColor: '#8CC73F',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        var upload_video_id = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
                        var upload_video_work_file_id = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;

                        if (upload_video_id !== '') {
                            var formdata = new FormData();
                            formdata.append("upload_video_id", upload_video_id);

                            removeSingleVideoResponse.addEventListener("load", function () {

                                if (removeSingleVideoResponse.responseText === 'success') {

                                    deleteSingleValue('allUploadVideoCounter_sec_', sectionCounter, videoCounter);
                                    deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);
                                    deleteSingleValue('allUploadVideoID_sec_', sectionCounter, upload_video_id);
                                    deleteSingleValue('allUploadVideoID1_sec_', sectionCounter, upload_video_id);
                                    if (upload_video_work_file_id) {
                                        deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
                                        deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);
                                        deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, upload_video_work_file_id);
                                    }

                                    var parentDiv = documentID('upload_video_section' + sectionCounter);
                                    var childDiv = documentID('upload_video_area' + sectionCounter + '_video' + videoCounter);
                                    
                                    if(count_video == '1'){
                                        parentDiv.remove();
                                        if(video_course_url !=''){
                                            window.location = video_course_url;
                                        }
                                    }else{
                                        childDiv.remove();
                                    }
                                    //window.location = video_course_url;
                                }
                                

                            }, false);
                            removeSingleVideoResponse.open("POST", url);
                            removeSingleVideoResponse.send(formdata);
                        } else {
                            var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
                            var allUploadVideoCounter = new Array();
                            if (allUploadVideoCounter1 !== '') {
                                allUploadVideoCounter = allUploadVideoCounter1.split(',');
                            }
                            if (allUploadVideoCounter.length > 0) {
                                if (allUploadVideoCounter.indexOf(videoCounter) > -1) {
                                    var index = allUploadVideoCounter.indexOf(videoCounter);
                                    allUploadVideoCounter.splice(index, 1);
                                }
                                documentID('allUploadVideoCounter_sec_' + sectionCounter).value = allUploadVideoCounter;
                            }

                            var parentDiv = documentID('upload_video_section' + sectionCounter);
                            var childDiv = documentID('upload_video_area' + sectionCounter + '_video' + videoCounter);
                            if(video_course_url !=''){
                                parentDiv.remove();
                                window.location = video_course_url;
                            }else{
                                parentDiv.removeChild(childDiv);
                            }
                        }
                    }
                });
    } else {
        swal({
            title: "",
            text: "You can not delete single Video",
            type: "warning",
            confirmButtonColor: '#01ba11',
            confirmButtonText: 'OK',
            closeOnConfirm: true
        });
    }
}



/*
 * @Function            : addMoreVideo 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more video file 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-02-2016 11:59 PM      
 * @Status              : available      
 */
function addMoreVideo(sectionCounter, url) {
    var video_course_url = $('#video_course_url_check').val();
    //console.log(video_course_url);
    
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var addMoreVideoResponse;
    addMoreVideoResponse = checkXMLHTTP(addMoreVideoResponse);

    var uploadVideoCounter = new Array();
    var uploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
    if (uploadVideoCounter1 !== '') {
        uploadVideoCounter = uploadVideoCounter1.split(',');
    }

    var videoCounter;
    var tempArray = new Array();
    if (uploadVideoCounter.length === 1) {
        videoCounter = uploadVideoCounter[0];
    } else {
        for (var i = 0; i < uploadVideoCounter.length; i++) {
            tempArray.push(uploadVideoCounter[i]);
        }
        videoCounter = Math.max.apply(Math, tempArray);
    }
    var videoCounter1 = parseInt(videoCounter);

    var fileStatusName = document.getElementsByName('work_file_status[' + sectionCounter + '][' + videoCounter1 + ']');
    var fileStatus = '';
    for (var i = 0; i < fileStatusName.length; i++) {
        if (fileStatusName[i].checked) {
            fileStatus = fileStatusName[i].value;
        }
    }

    var allUploadVideoOKcounter = new Array();
    var allUploadVideoID = new Array();
    var allUploadVideoWorkFileCounter = new Array();
    var allUploadVideoWorkFileID = new Array();
    var allUploadVideoWorkFileOKCounter = new Array();


    var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + sectionCounter).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }
    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }

    var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileCounter1 !== '') {
        allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
    }
    var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileID1 !== '') {
        allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
    }
    var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileOKCounter1 !== '') {
        allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
    }

    if ((uploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
        documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

        if (fileStatus !== '') {
            documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter1).innerHTML = '';

            if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

                var videoCourseID = documentID('course_id').value;
                var formdata = new FormData();
                formdata.append("video_counter", videoCounter1);
                formdata.append("section_counter", sectionCounter);
                formdata.append("video_management_id", videoCourseID);
                addMoreVideoResponse.addEventListener("load", function () {

                    var parentDiv = documentID('upload_video_section' + sectionCounter);
                    var div1 = document.createElement('div');
                    var previous_div = documentID('upload_video_area' + sectionCounter + '_video' + videoCounter1);
                    ++videoCounter1;
                    div1.id = 'upload_video_area' + sectionCounter + '_video' + videoCounter1;
                    parentDiv.appendChild(div1);
                    
                    div1.innerHTML = addMoreVideoResponse.responseText;
                    var allCounter = uploadVideoCounter + ',' + videoCounter1;
                    documentID('allUploadVideoCounter_sec_' + sectionCounter).value = allCounter;


                }, false);
                addMoreVideoResponse.open("POST", url);
                addMoreVideoResponse.send(formdata);
            } else {
                documentID('video_course_submit_error' + sectionCounter).innerHTML = 'Please submit form correctly';
            }
        } else {
            documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter1).innerHTML = 'Please Select Work FIle Status';
        }
    } else {
        documentID('video_course_submit_error' + sectionCounter).innerHTML = 'Please submit form correctly';
    }
}


/*
 * @Function            : getSectionArea 
 * @Used IN             : @function-'addMoreVideoSection'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-02-2016 12:54 PM      
 * @Status              : available      
 */
function getSectionArea(sectionCounter, url) {
    var video_course_url = $('#video_course_url_check').val();
    //console.log(video_course_url);
    var getSectionAreaResponse;
    getSectionAreaResponse = checkXMLHTTP(getSectionAreaResponse);
    var videoManagementID = documentID('course_id').value;

    var formdata = new FormData();
    formdata.append("section_counter", sectionCounter);
    formdata.append("video_management_id", videoManagementID);
    getSectionAreaResponse.addEventListener("load", function () {

        var parentDiv = documentID('video_section_area');
        var div1 = document.createElement('div');
        var previous_div = documentID('upload_video_section' + sectionCounter);
        ++sectionCounter;
        div1.id = 'upload_video_section' + sectionCounter;
        parentDiv.appendChild(div1);
        
        div1.innerHTML = getSectionAreaResponse.responseText;
        var allsectionCounter1 = documentID('allSectionCounter').value;
        var allSecctionCounter = allsectionCounter1 + ',' + sectionCounter;
        documentID('allSectionCounter').value = allSecctionCounter;

    }, false);
    getSectionAreaResponse.open("POST", url);
    getSectionAreaResponse.send(formdata);
}
/*
 * @Function            : addMoreVideoSection 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-02-2016 02:27 AM      
 * @Status              : available      
 */
function addMoreVideoSection(url) {
    if (documentID('course_category_id').value !== '') {
        if (documentID('course_id').value !== '') {
            var allsectionCounter = new Array();
            var allsectionCounter1 = documentID('allSectionCounter').value;
            if (allsectionCounter1 !== '') {
                allsectionCounter = allsectionCounter1.split(',');
            }

            var sectionCounter1;
            var tempArray = new Array();
            if (allsectionCounter.length === 1) {
                sectionCounter1 = allsectionCounter[0];
            } else {
                for (var i = 0; i < allsectionCounter.length; i++) {
                    tempArray.push(allsectionCounter[i]);
                }
                sectionCounter1 = Math.max.apply(Math, tempArray);
            }
            var sectionCounter = parseInt(sectionCounter1);

            var allUploadVideoCounter = new Array();
            var allUploadVideoOKcounter = new Array();
            var allUploadVideoID = new Array();
            var allUploadVideoWorkFileCounter = new Array();
            var allUploadVideoWorkFileID = new Array();
            var allUploadVideoWorkFileOKCounter = new Array();
            var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
            if (allUploadVideoCounter1 !== '') {
                allUploadVideoCounter = allUploadVideoCounter1.split(',');
            }
            var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + sectionCounter).value;
            if (allUploadVideoOKcounter1 !== '') {
                allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
            }
            var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
            if (allUploadVideoID1 !== '') {
                allUploadVideoID = allUploadVideoID1.split(',');
            }
            var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + sectionCounter).value;
            if (allUploadVideoWorkFileCounter1 !== '') {
                allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
            }
            var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + sectionCounter).value;
            if (allUploadVideoWorkFileID1 !== '') {
                allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
            }
            var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + sectionCounter).value;
            if (allUploadVideoWorkFileOKCounter1 !== '') {
                allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
            }

            var videoCounter1;
            var tempArray1 = new Array();
            if (allUploadVideoCounter.length === 1) {
                videoCounter1 = allUploadVideoCounter[0];
            } else {
                for (var i = 0; i < allUploadVideoCounter.length; i++) {
                    tempArray1.push(allUploadVideoCounter[i]);
                }
                videoCounter1 = Math.max.apply(Math, tempArray1);
            }
            var videoCounter2 = parseInt(videoCounter1);
            var fileStatusName = document.getElementsByName('work_file_status[' + sectionCounter + '][' + videoCounter2 + ']');
            var fileStatus = '';
            for (var i = 0; i < fileStatusName.length; i++) {
                if (fileStatusName[i].checked) {
                    fileStatus = fileStatusName[i].value;
                }
            }

            if ((allUploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
                if (fileStatus !== '') {
                    if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                        documentID('section_error').innerHTML = '';
                        getSectionArea(sectionCounter, url);

                    } else {
                        documentID('section_error').innerHTML = 'Please Submit previous input properly';
                    }
                } else {
                    documentID('section_error').innerHTML = 'Please Submit previous input properly';
                }
            } else {
                documentID('section_error').innerHTML = 'Please Submit previous input properly';
            }
        } else {
            documentID('course_id_error').innerHTML = 'Please Select Video Course';
        }
    } else {
        documentID('category_id_error').innerHTML = 'Please Select Course Category';
    }
}


/*
 * @Function            : checkVideoCourseWorkFIle 
 * @Used IN             : @function-'admin/video/add_video_work_file.php/edit_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 23-02-2016 06:22 PM      
 * @Status              : available      
 */
function checkVideoCourseWorkFIle() {
    var videoSatus1;
    var workSatus1;
    if (documentID('course_category_id').value !== '') {
        if (documentID('course_id').value !== '') {
            var allsectionCounter = new Array();
            var allsectionCounter1 = documentID('allSectionCounter').value;
            if (allsectionCounter1 !== '') {
                allsectionCounter = allsectionCounter1.split(',');
            }

            for (var i = 0; i < allsectionCounter.length; i++) {
                if (documentID('video_section_validate' + allsectionCounter[i]).value === '') {
                    videoSatus1 = '2';
                    documentID('video_section_name_errror' + allsectionCounter[i]).innerHTML = 'Please type valid section name';
                    break;
                } else {
                    videoSatus1 = '1';
                }

                var allUploadVideoCounter = new Array();
                var allUploadVideoOKcounter = new Array();
                var allUploadVideoID = new Array();
                var allUploadVideoWorkFileCounter = new Array();
                var allUploadVideoWorkFileID = new Array();
                var allUploadVideoWorkFileOKCounter = new Array();
                var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoCounter1 !== '') {
                    allUploadVideoCounter = allUploadVideoCounter1.split(',');
                }
                var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoOKcounter1 !== '') {
                    allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
                }
                var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoID1 !== '') {
                    allUploadVideoID = allUploadVideoID1.split(',');
                }
                var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoWorkFileCounter1 !== '') {
                    allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
                }
                var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoWorkFileID1 !== '') {
                    allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
                }
                var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + allsectionCounter[i]).value;
                if (allUploadVideoWorkFileOKCounter1 !== '') {
                    allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
                }

                if ((allUploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
                    for (var j = 0; j < allUploadVideoCounter.length; j++) {
                        if (documentID('video_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[j]).value === '1') {
                            videoSatus1 = '1';
                        } else {
                            videoSatus1 = '2';
                            documentID('video_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[j]).innerHTML = 'Please type valid video name';
                            break;
                        }
                    }
                    for (var k = 0; k < allUploadVideoCounter.length; k++) {
                        if (documentID('work_file_status_validate_sec_' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '1') {
                            videoSatus1 = '1';
                        } else {
                            videoSatus1 = '2';
                            documentID('video_work_file_status_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = 'Please select work file status';
                            break;
                        }
                    }

                    if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                        for (var k = 0; k < allUploadVideoWorkFileCounter.length; k++) {
                            if (documentID('work_files_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '1') {
                                workSatus1 = '1';
                            } else {
                                workSatus1 = '2';
                                documentID('work_files_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = 'Please type valid work file name';
                                break;
                            }
                        }
                    } else {
                        workSatus1 = '2';
                        break;
                    }
                } else {
                    videoSatus1 = '2';
                    break;
                }
            }

        } else {
            documentID('course_id_error').innerHTML = 'Please Select Video Course';
            return false;
        }
    } else {
        documentID('category_id_error').innerHTML = 'Please Select Course Category';
        return false;
    }

    if (videoSatus1 === '2') {
        documentID('submit_error').innerHTML = 'Please Submit previous input properly';
        return false;
    }
    if (workSatus1 === '2') {
        documentID('submit_error').innerHTML = 'Please Submit previous input properly';
        return false;
    }
}



/*
 * @Function            : deleteSingleWorkFile 
 * @Used IN             : @function-'admin/video/view_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 22-02-2016 05:44 PM      
 * @Status              : available      
 */
function deleteSingleWorkFile(url, workFileID) {
    var deleteSingleWorkFileResponse;
    deleteSingleWorkFileResponse = checkXMLHTTP(deleteSingleWorkFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete this work file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("work_files_management_id", workFileID);

                    deleteSingleWorkFileResponse.addEventListener("load", function () {

                        location.reload();

                    }, false);
                    deleteSingleWorkFileResponse.open("POST", url);
                    deleteSingleWorkFileResponse.send(formdata);
                }
            });
}


/*
 * @Function            : deleteSingleUploadVideo 
 * @Used IN             : @function-'admin/video/view_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 22-02-2016 05:44 PM      
 * @Status              : available      
 */
function deleteSingleUploadVideo(url, uploadVideoID) {
    var deleteSingleUploadVideoResponse;
    deleteSingleUploadVideoResponse = checkXMLHTTP(deleteSingleUploadVideoResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete this work file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("upload_video_id", uploadVideoID);

                    deleteSingleUploadVideoResponse.addEventListener("load", function () {

                        if (deleteSingleUploadVideoResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    deleteSingleUploadVideoResponse.open("POST", url);
                    deleteSingleUploadVideoResponse.send(formdata);
                }
            });
}


/*
 * @Function            : deleteCourseVideoFile 
 * @Used IN             : @function-'admin/video/manage_video_work_file.php'       'back_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : Delete all video course Video file with work file
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 22-02-2016 05:44 PM      
 * @Status              : available      
 */
function deleteCourseVideoFile(url, videoCourseID) {
    var deleteCourseVideoFileResponse;
    deleteCourseVideoFileResponse = checkXMLHTTP(deleteCourseVideoFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete video file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("video_course_id", videoCourseID);

                    deleteCourseVideoFileResponse.addEventListener("load", function () {

                        if (deleteCourseVideoFileResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    deleteCourseVideoFileResponse.open("POST", url);
                    deleteCourseVideoFileResponse.send(formdata);
                }
            });
}
/*
 -----------@@@RIPON@ End Video Course Work File Part----------------------------------
 */