$(document).ready(function () {
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 9-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : pagination manage send invitation 
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : 
     * @Return              : 
     * @value               : searchInput keep the value of search field
     *                        url keep the value of url 
     *                        formdata keep the data which is pass on ajax 
     * @Status              : Available
     * @version             : v2.1       
    * */
    $(document).on('click', "a[id^=manage_send_video_course_invitation_pagination]", function () {
        var page_number = this.id.replace('manage_send_video_course_invitation_pagination', '');
        var baseUrl = $('#baseUrl').val();

        var search_value = $('#manage_send_video_course_invitation_search').val();

        if(search_value != ''){
            var searchInput = (search_value.replace(/  +/g, ' ')).trim();
            var url = baseUrl + 'search-manage-send-video-course-invitation';
            var formdata = new FormData(); 
            formdata.append("search_value", searchInput);
            formdata.append('page_number', page_number);
        }
        else{
            var url = baseUrl + 'pagination-manage-send-video-course-invitation';
            var formdata = new FormData(); 
            formdata.append('page_number', page_number);
        }
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#view_manage_send_video_course_invitation').html(data);
            }
        });    
    });
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 10-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : pagination of view video course invitation 
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : viewVideoCourseInvitation()
     * @Parameter           : 
     * @Return              : 
     * @value               : page_number keep the value of page_number
     * @Status              : Available
     * @version             : v2.1       
    * */
    var page_number;
    var send_invitation_tab;
    $(document).on('click', 'a[id^=anonymous_view_video_course_invitation_pagination]', function () {
        page_number = this.id.replace('anonymous_view_video_course_invitation_pagination', '');
        send_invitation_tab = 'anonymous';
        viewVideoCourseInvitation();
    }).on('click', 'a[id^=user_view_video_course_invitation_pagination]', function () {
        page_number = this.id.replace('user_view_video_course_invitation_pagination', '');
        send_invitation_tab = 'user';
        viewVideoCourseInvitation();
    });
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 10-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : pagination of view video course invitation 
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : null
     * @Return              : null
     * @value               : video_course_url keep the value of video_course_url
     *                        url keep the value of where ajax called
     *                        formdata keep the data which is pass on ajax 
     * @Status              : Available
     * @version             : v2.1       
    * */
    function viewVideoCourseInvitation() {
        var video_course_url = $('#view_video_course_url').val();
        var url = $('#view_video_course_invitation_url').val();
        
        var formdata = new FormData(); 
        formdata.append('video_course_url', video_course_url);
        formdata.append('send_invitation_tab', send_invitation_tab);
        formdata.append('page_number', page_number);

        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                switch (send_invitation_tab) {
                    case 'anonymous':
                        $('#loading_image').show();
                        $('#view_send_video_course_anonymous_all_invitation').attr('style', 'opacity:0');
                        break;
                        
                    case 'user':
                        $('#loading_image').show();
                        $('#view_send_video_course_user_all_invitation').attr('style', 'opacity:0');
                        break;
                }
            },
            complete: function () {
                switch (send_invitation_tab) {
                    case 'anonymous':
                        $('#loading_image').hide();
                        $('#view_send_video_course_anonymous_all_invitation').attr('style', 'opacity:1');
                        break;
                    
                    case 'user':
                        $('#loading_image').hide();
                        $('#view_send_video_course_user_all_invitation').attr('style', 'opacity:1');
                        break;
                }
            },
            success: function (data, status) {
                if (status === 'success') {
                    switch (send_invitation_tab) {
                        case 'anonymous':
                            $('#view_send_video_course_anonymous_all_invitation').html(data);
                            break;
                            
                        case 'user':
                            $('#view_send_video_course_user_all_invitation').html(data);
                            break;
                    }
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    };
});
    
    
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : email preview
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : 
     * @Return              : null
     * @value               : msg keep the data of invitation_message
     * @Status              : Available
     * @version             : v2.1       
    * */
    function email_preview() {
        if($('#dvEmailPreview').is(':hidden')) {
            var msg = $('#invitation_message').val();
            $('#inv_msg').html(msg);
            $("#dvEmailPreview").show();
        }
        else{
            $("#dvEmailPreview").hide();
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : input field show based on send_invitation_type
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : send_invitation_type
     * @Return              : null
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    function getSendInvitationType(send_invitation_type) {
        if(send_invitation_type !== '1'){
            $('#invite_user').show();
            $('#invite_anonymous').hide();

        }else{
            $('#invite_user').hide();
            $('#invite_anonymous').show();
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : check input field value [only integer] for send_invitation_type [2,3,4]
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : null
     * @Return              : boolean
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    $("#invitation_send_to_user").keypress(function (e) {
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
            $("#invitation_send_to_user_error").html("Only integer numbers are allow.").show().delay(1500).fadeOut("slow");
            return false;
        }
    });

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : check inputed email valid or not
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : email
     * @Return              : null
     * @value               : emails keep split email value 
     *                        invalidEmails keep invalid Email list
     * @Status              : Available
     * @version             : v2.1       
    * */
    function checkEmail(email){
        var emails = email.split(',');
        var invalidEmails = [];
        for (i = 0; i < emails.length; i++) { 
            if(!validateEmail(emails[i].trim())) {
              invalidEmails.push(emails[i].trim());
            }
        }
        if(invalidEmails != ''){
            $('#invitation_send_to_anonymous_error').show();
            $('#invitation_send_to_anonymous_error').html(invalidEmails + ' is incorrect');
        }else{
            $('#invitation_send_to_anonymous_error').hide();
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : email validation check
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : email
     * @Return              : email
     * @value               : re regex of check email valid or not
     * @Status              : Available
     * @version             : v2.1       
    * */
    function validateEmail(email) {
        var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
        return re.test(email);
    }

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send invitation
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : setTimeout()
     * @Parameter           : url,invitation_id
     * @Return              : 
     * @value               : video_course_url keep the value of video_course_url
     *                        total_invitation_user_number keep the value of total_invitation_user_number
     *                        sent_invitation_user_number keep the value of sent_invitation_user_number
     * @Status              : Available
     * @version             : v2.1       
    * */
    function sendInvitation(url,invitation_id){
        var video_course_url = $('#video_course_url').val();
        var total_invitation_user_number = $('#total_invitation_user_number'+ invitation_id).val();

        $.ajax({
            type: "POST",
            url: url,
            data: {
                invitation_id:invitation_id,
                video_course_url:video_course_url
            }
        }).success(function(data){
            var values = JSON.parse(data);
            var sent_invitation_user_number = total_invitation_user_number - values.invitation_user_number;
            if(values.invitation_user_number != 0){
                $('#pending'+invitation_id).hide();
                $('#processing'+invitation_id).show();
                $('#sent'+invitation_id).hide();

                setTimeout(function(){sendInvitation(url,invitation_id);}, 3000);
                $('#invitation_user_number'+invitation_id).html(values.invitation_user_number);
                $('#sent_invitation_user_number'+invitation_id).html(sent_invitation_user_number);
            }else{
                $('#pending'+invitation_id).hide();
                $('#processing'+invitation_id).hide();
                $('#sent'+invitation_id).show();

                $('#invitation_user_number'+invitation_id).html(values.invitation_user_number);
                $('#sent_invitation_user_number'+invitation_id).html(sent_invitation_user_number);
                $('#send_invitation'+invitation_id).hide();
            }
        });        
    }

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send invitation again
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : url,invitation_receive_person_id
     * @Return              : 
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    function sendInvitationAgain(url, invitation_receive_person_id){
        var formdata = new FormData(); 
        formdata.append("invitation_receive_person_id", invitation_receive_person_id);
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#send_invitation_again'+invitation_receive_person_id).hide();
                $('#send_invitation_again_successfull'+invitation_receive_person_id).show();
            }
        });
    }

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send registration invitation
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : url,invitation_receive_person_id
     * @Return              : 
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    function sendSiteRegistrationInvitation(url, invitation_receive_person_id){
        var formdata = new FormData(); 
        formdata.append("invitation_receive_person_id", invitation_receive_person_id);
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                if(data == 'sent'){
                    $('#send_registration_invitation'+invitation_receive_person_id).hide();
                    $('#send_registration_invitation_successfull'+invitation_receive_person_id).show();
                }
            }
        });
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : delete invitation receive person info
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : url,invitation_receive_person_id
     * @Return              : 
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    function deleteInvitationReceivePerson(url, invitation_receive_person_id){
        var page_number = $('#page_number').val();
        var formdata = new FormData(); 
        formdata.append("invitation_receive_person_id", invitation_receive_person_id);
        formdata.append("page_number", page_number);
        swal({
            title: "",
            text: "Are you sure, you want to Delete this invitation receive person?",
            showCancelButton: true,
            confirmButtonColor: '#73AE28',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function (data)
                    {
                        $('#view_invitation_receive_person').html(data);
                    }
                });
            }
        });
    }

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 9-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : search manage send invitation 
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : search_value, url
     * @Return              : 
     * @value               : searchInput keep the value of search field
     * @Status              : Available
     * @version             : v2.1       
    * */
    function searchSendVideoCourseInvitation(search_value, url){
        var searchInput = (search_value.replace(/  +/g, ' ')).trim();
        var formdata = new FormData(); 
        formdata.append("search_value", searchInput);

        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#view_manage_send_video_course_invitation').html(data);
            }
        });
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 10-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : search send invitation user list by user email
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : search_value, url
     * @Return              : 
     * @value               : searchInput keep the search input value
     *                        invitation_id keep the invitation_id value
     *                        formdata keep the data which is pass on ajax
     * @Status              : Available
     * @version             : v2.1       
    * */
    function searchSendVideoCourseInvitationUserList(search_value, url){
        var searchInput = (search_value.replace(/  +/g, ' ')).trim();
        var invitation_id = $('#invitation_id').val();
        var formdata = new FormData(); 
        formdata.append("search_value", searchInput);
        formdata.append("invitation_id", invitation_id);

        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#view_invitation_receive_person').html(data);
            }
        });
    }

    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 10-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send invitation user list pagination
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : 
     * @Parameter           : search_value, url
     * @Return              : 
     * @value               : searchInput keep the search input value
     *                        page_number keep the page_number value
     *                        search_value keep the search field value
     *                        invitation_id keep the invitation_id value
     *                        formdata keep the data which is pass on ajax
     * @Status              : Available
     * @version             : v2.1       
    * */
    $(document).on('click', "a[id^=send_video_course_invitation_user_list_pagination]", function () {
        var page_number = this.id.replace('send_video_course_invitation_user_list_pagination', '');
        var baseUrl = $('#baseUrl').val();

        var search_value = $('#send_video_course_invitation_user_list_search').val();
        var invitation_id = $('#invitation_id').val();

        if(search_value != ''){
            var searchInput = (search_value.replace(/  +/g, ' ')).trim();
            var url = baseUrl + 'search-send-video-course-invitation-user-list';
            var formdata = new FormData(); 
            formdata.append("search_value", searchInput);
            formdata.append("invitation_id", invitation_id);
            formdata.append('page_number', page_number);
        }
        else{
            var url = baseUrl + 'pagination-send-video-course-invitation-user-list';
            var formdata = new FormData(); 
            formdata.append("invitation_id", invitation_id);
            formdata.append('page_number', page_number);
        }
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#view_invitation_receive_person').html(data);
            }
        });    
    });
