
// Fires All event after loading the pages completely
$(document).ready(function () {
// Displays the current city information by default after loading the page  
    displayCurrentCityCountry();

// Displays the tab content after clicking the current city
    $('#profileCurrentCity').click(function () {
        $('#aboutCurrentCity #mapOff').attr('id', 'map');
        $('#aboutBlocks').hide();
        $('#aboutTravel').hide();
        $('#aboutCurrentCity').show(function () {
            initMap();
        });

    });

// Handle the switching between tab content optional blocks
    $('#tabAbout').click(function () {
        displayCurrentCityCountry();
        $('#aboutCurrentCity').hide();
        $('#aboutTravel').hide();
        $('#aboutConnectivity').hide();
        $('#aboutMyLink').hide();
        $('#aboutpersonalInfo').hide();
        $('#aboutInterest').hide();
        $('#aboutEducation').hide();
        $('#aboutChangePassword').hide();
        $('#pendingLinkRequest, #linkedUser, #link_suggestion, #linkSuggestion').empty();
        $('#aboutBlocks').show();
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutTravel #map').attr('id', 'mapOff');
        $('#aboutConnectivity #map').attr('id', 'mapOff');
    });

// Displays the tab content after clicking the travel
    $('#profileTravel').click(function () {
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutConnectivity #map').attr('id', 'mapOff');
        $('#aboutTravel #mapOff').attr('id', 'map');
        $("#aboutCurrentCity").hide();
        $('#aboutBlocks').hide();
        $('#aboutTravel').show(function () {
            initTravelMap();
        });
    });

// Displays the tab content after clicking the connectivity
    $('#profileConnectivity').click(function () {
        $('#aboutCurrentCity #map').attr('id', 'mapOff');
        $('#aboutTravel #map').attr('id', 'mapOff');
        $('#aboutConnectivity #mapOff').attr('id', 'map');
        $("#aboutCurrentCity").hide();
        $("#aboutTravel").hide();
        $('#aboutBlocks').hide();
        $('#aboutConnectivity').show(function () {
            initLinkMap();
        });
    });
    

// Displays the tab content after clicking the My Link
    $('#profileMyLink').click(function(){
        $('#aboutBlocks').hide();
        $('#pendingReqUp').hide();        
        $('#pendingLinkRequest').hide();
        displayLinks();
        $('#aboutMyLink').slideDown('slow');
        displayMyLinkSuggestion();
        
    });
// Makes the pending button hidden by default
    $('#pendingButton').hide();
    
// Slide down the content after clicking pending request button    
    $('#pendingButton').click(function(){        
        $('#pendingLinkRequest').slideDown('slow');
        $('#pendingButton').hide();
        $('#pendingReqUp').show();
        $('#divideBar').show();
    });
// Slide up the content of pending request  
    $('#pendingReqUp').click(function(){
        $('#pendingLinkRequest').slideUp('slow');
        $('#pendingButton').show();
        $('#pendingReqUp').hide();
        $('#divideBar').hide();
    });
    
 // Displays the tab content after clicking Education
    $('#profileEducation').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutEducation').slideDown();
    });
    
 // Displays the tab content after clicking Interest
    $('#profileInterest').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutInterest').slideDown();
    });
    
// Displays the tab content after clicking Personal Info
    $('#profilePersonalInfo').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutpersonalInfo').slideDown();
    });
    
// Displays the tab content after clicking Change Password
    $('#profileChangePassword').click(function(){
        $('#aboutBlocks').hide();
        $('#aboutChangePassword').slideDown();
    });
// Skill tab events
$('#tabSkill').click(function(){
    $('#skillBlocks').slideDown();
    $('#skillExperience').hide();
    $('#skillSelfAssessment').hide();
    $('#skillTtSkill').hide();
    $('#skillOverview').hide();
    $('#skillLanguage').hide();
});
    
// Displays the experience Content
    $('#profileExp').click(function(){
        $('#skillBlocks').hide();
        $('#skillExperience').slideDown();
    });
    
// Displays the self assessment Content
    $('#profileSelfAssessment').click(function(){
        $('#skillBlocks').hide();
        $('#skillSelfAssessment').slideDown();
    });
    
// Displays the TT Skill Content
    $('#profileTtSkill').click(function(){
        $('#skillBlocks').hide();
        $('#skillTtSkill').slideDown();
    });
    
    
// Displays the Skill Overview Content
    $('#profileSkillOverview').click(function(){
        $('#skillBlocks').hide();
        $('#skillOverview').slideDown(function(){
            displayMultipleMeter('meterCircle');
        });
        
    });
    
// Displays the Language Content
    $('#profileLanguage').click(function(){
        $('#skillBlocks').hide();
        $('#skillLanguage').slideDown();
    });

});


/*
 * @Function            : displayCurrentCityCountry
 * @Used IN             : profile page current city back info display
 * @Description         : displays information on the back flip of current city
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 16-11-2016 03:00 PM 
 * @Parameter           : None
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */

function displayCurrentCityCountry() {

    var profileUrl = $('#profileUrl').val();    
    var baseUrl = $('#baseUrl').val();
    $('#currentLocation').empty();    
    $.post(baseUrl + 'admin/get-current-location',{profile_url:profileUrl}, function (data) {       
        var value = JSON.parse(data);
        if (value !== null && value.person_current_latitude_longitude.length > 0) {
            var countryName = getCountryName(value.person_country);
            var cityName = value.person_city;
            $('#currentLocation').append(
                    '<h5 style="padding: 5px"><span>City : ' + cityName + '</span></h5>'
                    + '<h5 style="padding: 5px"><span>Country : ' + countryName + '</span></h5>'
                    + '<h5 style="padding: 5px"><span> Click To View on Map</span></h5>'
                    );
        } else {
            $('#currentLocation').append(
                    '<h5 style="padding: 50px 5px; "><span> Click To Add Your Current Location</span></h5>'
                    );
        }
    });
}

/*
 * @Function            : deleteLink
 * @Used IN             : profile link
 * @Description         : Unlink or Delete link
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 04-01-2017
 * @Parameter           : person_url[url of the person that will be deleted]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function deleteLink(personUrl){
    var deletedBy = $('#profileUrl').val();
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'admin/delete-link',
           {
               profile_url:personUrl,
               deleted_by: deletedBy
           },
           function(){
        $('#'+personUrl).hide();
    });
}

/*
 * @Function            : blockLink
 * @Used IN             : profile link
 * @Description         : Blocks link
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 04-01-2017  
 * @Parameter           : person_url[url of the person that will be blocked]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function blockLink(personUrl){
    var blockedBy = $('#profileUrl').val();
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'admin/block-link',
           {
               profile_url:personUrl,
               blocked_by:blockedBy
           },
           function(){
        $('#'+personUrl).hide();
    });
}

/*
 * @Function            : acceptLinkRequest
 * @Used IN             : profile link
 * @Description         : Accepts Pending Link Request
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 04-01-2017
 * @Parameter           : person_url[url of the person that will be accepted]
 * @View                : None
 * @Redirect            : None
 * @Return              : NULL    
 * @Status              : Available       
 */
function acceptLinkRequest(personUrl){
    var acceptedBy = $('#profileUrl').val();
    var baseUrl = $('#baseUrl').val();   
    $.post(baseUrl+'admin/accept-link-request',
           {
               profile_url:personUrl,
               accepted_by: acceptedBy
           },
           function(){
        $('#divideBar').show();
        $('#'+personUrl).detach().prependTo('#linkedUser');       
    });
}


