$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();
    var invoiceID = $('#invoiceID').val();
    var numberRegExp = /^\d+(?:\.\d{1,2})?$/;
    var regxExp = /^[0-9a-zA-Z\-]+$/;
    var currencyType, paymentType;

    /*
     * @Description         : get invoice information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-01-2017 10:01 AM  
     */
    var paidAmount;
    var serverUrl = baseUrl + 'admin/invoice-get-refund-info';
    $.post(serverUrl, {'invoice_id': invoiceID}, function (data) {
        var paymentData = JSON.parse(data);
        var paidAmount1 = parseFloat(paymentData.paid_amount);
        paidAmount = Number(paidAmount1.toFixed(2));
    });

    /*
     * @Description         : get currency type and view payment type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 10:50 AM  
     */
    $(document).on('change', 'select[id^="currency"]', function () {
        currencyType = $('#' + this.id).val();
        viewPaymentType();
    });

    /*
     * @Description         : get payment type and view button
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 11:03 AM  
     */
    $(document).on('change', 'select[id="view_payment_type"]', function () {
        paymentType = $('#' + this.id).val();
        viewPaymentButton();
    });
    /*
     * @Description         : view payment type drop down list
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 10:53 AM  
     */
    function viewPaymentType() {
        var paymenttypeView = '';

        switch (currencyType) {
            case '1':
                paymenttypeView += '<option value=""> Select Payment Method </option><option value="1">Cash Payment</option><option value="3">bKash Payment</option><option value="2">Cheque Payment</option>';
                break;
            case '2':
                paymenttypeView += '<option value=""> Select Payment Method </option><option value="1">Cash Payment</option><option value="2">Cheque Payment</option>';
                break;
            default:
                paymenttypeView += '<option value=""> Select Payment Method </option>';
                break;
        }
        $('#view_payment_type').html(paymenttypeView);
        // update payment button
        paymentType = '';
        viewPaymentButton();
    }


    /*
     * @Description         : view payment Button
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 11:09 AM  
     */
    function viewPaymentButton() {
        var buttonView = '';

        switch (paymentType) {
            case '1':
                buttonView = '<button type="button" class="btn btn-success" style="font-size: 14px;" id="cashBtn">Cash Payment</button>';
                break;
            case '2':
                buttonView = '<button type="button" class="btn btn-success" style="font-size: 14px;" id="chequeBtn">Cheque Payment</button>';
                break;
            case '3':
                buttonView = '<button type="button" class="btn btn-success" style="font-size: 14px;" id="bKashBtn">bKash Payment</button>';
                break;
            default:
                buttonView = '<button type="button" class="btn btn-success" style="font-size: 14px;" id="paymentBtn">Choose Payment Method</button>';
                break;
        }
        $('#change_button').html(buttonView);
    }


    /*
     * ---------------------Start Cash Payment--------------------------------------
     */
    var receiptNumber, paymentAmount;
    var receiptValidate, paymentValidate;
    /*
     * @Description         : view cash payment modal
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 11:27 AM  
     */
    $(document).on('click', 'button[id="cashBtn"]', function () {
        $('#cashModal').modal('show');
    });


    /*
     * @Description         : open cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 11:53 AM  
     */
    $(document).on('click', 'a[id="openCashButton"]', function () {
        showCashPaymenrForm();
    });



    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:04 PM  
     */
    $(document).on('click', 'a[id="closeCashButton"]', function () {
        hideCashPaymenrForm();
    });


    /*
     * @Description         : show cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:42 PM  
     */
    function showCashPaymenrForm() {
        $('#openCashButton').hide('slow');
        $('#closeCashButton').show('slow');
        $('#cashform').slideDown("slow");
    }


    /*
     * @Description         : hide cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:43 PM  
     */
    function hideCashPaymenrForm() {
        $('#openCashButton').show('slow');
        $('#closeCashButton').hide('slow');
        $('#cashform').slideUp("slow");
    }

    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:19 PM  
     */
    $(document).on('blur', 'input[id="cashReceiptNumber"]', function () {
        receiptNumber = $('#' + this.id).val();
        if (receiptNumber !== '') {
            if (regxExp.test(receiptNumber)) {
                $.post(baseUrl + 'admin/check-cash-receipt-number',
                        {receipt_number: receiptNumber},
                        function (data) {
                            if (data === '1') {
                                receiptValidate = 1;
                                $('#cashReceiptNumber_error').html('Receipt number already exists!').fadeIn('slow');
                            } else {
                                receiptValidate = '';
                                $('#cashReceiptNumber_error').html('').fadeOut('slow');
                            }
                        });
            } else {
                receiptValidate = 1;
                $('#cashReceiptNumber_error').html('No special caracter allow accept -').fadeIn('slow');
            }
        } else {
            receiptValidate = 1;
            $('#cashReceiptNumber_error').html('Please type cash receipt number').fadeIn('slow');
        }
    });

    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:27 PM  
     */
    $(document).on('keyup', 'input[id="cashPaymentAmount"]', function () {
        var paymentAmount1 = parseFloat($('#' + this.id).val());
        paymentAmount = Number(paymentAmount1.toFixed(2));

        if (paymentAmount !== '') {
            if (checkPaymentAmount(paymentAmount) === 1) {
                paymentValidate = 1;
                $('#cashPaymentAmount_error').html('Invalid payment amount').fadeIn('slow');
            } else {
                paymentValidate = '';
                $('#cashPaymentAmount_error').html('').fadeOut('slow');
            }
        } else {
            paymentValidate = 1;
            $('#cashPaymentAmount_error').html('Please type payment amount').fadeIn('slow');
        }
    });

    /*
     * @Description         : add cash refund amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-01-2017 02:32 PM  
     */
    $(document).on('click', 'button[id="addCash"]', function () {
        if (receiptValidate !== undefined && paymentValidate !== undefined) {
            if (receiptValidate === '' && paymentValidate === '') {
                $('#cashsubmit_error').html('').html('').fadeOut('slow');

                var sign = (currencyType === '1') ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
                $('#viewCashInfo').slideDown('slow');
                $('#receiptNumber').html(encodeURIComponent(receiptNumber));
                $('#totalAmount').html(paymentAmount + sign);

                hideCashPaymenrForm();
            } else {
                $('#cashsubmit_error').html('').html('Please type proper input').fadeIn('slow');
            }
        } else {
            $('#cashsubmit_error').html('Please type proper input').fadeIn('slow');
        }
    });



    /*
     * @Description         : check submit form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 19-11-2016 02:25 PM  
     */
    $(document).on('click', 'button[id="cashPayment"]', function () {
        if (receiptValidate !== undefined && paymentValidate !== undefined) {
            if (receiptValidate !== '' && paymentValidate !== '') {
                $('#submit_error').html('please update your payment').fadeIn('slow');
            } else {
                $('#submit_error').html('').fadeOut('slow');

                var formData = new FormData();
                formData.append('invoice_id', invoiceID);
                formData.append('receipt_number', receiptNumber);
                formData.append('currency_type', currencyType);
                formData.append('paid_amount', paymentAmount);

                $.ajax({
                    type: 'post',
                    url: baseUrl + 'admin/payment/save-refund-cash',
                    data: formData,
                    async: true,
                    processData: false,
                    cache: false,
                    contentType: false,
                    traditional: true,
                    success: function (data, textStatus, jqXHR) {
                        var cashData = JSON.parse(data);
                        if (cashData.error === undefined) {
                            window.location.href = cashData.redirect_url;
                        }
                    }
                });
            }
        } else {
            $('#submit_error').html('please update your payment').fadeIn('slow');
        }
    });
    /*
     * ---------------------End Cash Payment--------------------------------------
     */


    /*
     * ---------------------Start bKash Payment--------------------------------------
     */
    var mobileNumber, trxID, bKashPayAmount;
    var ckMobileValidate, ckTrxIDValidate, ckbKashPayAmountValidate;
    /*
     * @Description         : view cash payment modal
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:34 PM  
     */
    $(document).on('click', 'button[id="bKashBtn"]', function () {
        $('#bkashModal').modal('show');
    });

    /*
     * @Description         : open bKash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:24 PM  
     */
    $(document).on('click', 'a[id="openbKashButton"]', function () {
        showbKashPaymentForm();
    });



    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:34 PM  
     */
    $(document).on('click', 'a[id="closebKashButton"]', function () {
        hidebKashPaymentForm();
    });


    /*
     * @Description         : show cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:42 PM  
     */
    function showbKashPaymentForm() {
        $('#openbKashButton').hide('slow');
        $('#closebKashButton').show('slow');
        $('#bKashForm').slideDown("slow");
    }


    /*
     * @Description         : hide cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:43 PM  
     */
    function hidebKashPaymentForm() {
        $('#openbKashButton').show('slow');
        $('#closebKashButton').hide('slow');
        $('#bKashForm').slideUp("slow");
    }


    /*
     * @Description         : check bKash Mobile number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:45 PM  
     */
    $(document).on('keyup', 'input[id="bkash_mobile_number"]', function () {
        mobileNumber = Number($('#' + this.id).val());
        if (mobileNumber !== '') {
            if (numberRegExp.test(mobileNumber)) {
                ckMobileValidate = '';
                $('#bkashMobileNumber_error').html('').fadeOut('slow');
            } else {
                ckMobileValidate = 1;
                $('#bkashMobileNumber_error').html('Invalid mobile number').fadeIn('slow');
            }
        } else {
            ckMobileValidate = 1;
            $('#bkashMobileNumber_error').html('Please type bKash mobile number').fadeIn('slow');
        }
    });


    /*
     * @Description         : check bKash Transaction number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:50 PM  
     */
    $(document).on('keyup', 'input[id="bkash_transaction_id"]', function () {
        trxID = Number($('#' + this.id).val());
        if (trxID !== '') {
            if (numberRegExp.test(trxID)) {
                ckTrxIDValidate = '';
                $('#bkashTransactionID_error').html('').fadeOut('slow');
            } else {
                ckTrxIDValidate = 1;
                $('#bkashTransactionID_error').html('Invalid transaction id').fadeIn('slow');
            }
        } else {
            ckTrxIDValidate = 1;
            $('#bkashTransactionID_error').html('Please type bKash transaction id').fadeIn('slow');
        }
    });


    /*
     * @Description         : check bKash Transaction number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 26-11-2016 03:50 PM  
     */
    $(document).on('keyup', 'input[id="check_payment_amount"]', function () {
        var bKashPayAmount1 = parseFloat($('#' + this.id).val());
        bKashPayAmount = Number(bKashPayAmount1.toFixed(2));
        if (bKashPayAmount !== '') {
            if (checkPaymentAmount(bKashPayAmount) === 1) {
                ckbKashPayAmountValidate = 1;
                $('#paymentAmount_error').html('Invalid payment amount').fadeIn('slow');
            } else {
                ckbKashPayAmountValidate = '';
                $('#paymentAmount_error').html('').fadeOut('slow');
            }
        } else {
            ckbKashPayAmountValidate = 1;
            $('#paymentAmount_error').html('Please type bKash payment amount').fadeIn('slow');
        }
    });


    /*
     * @Description         : add cheque amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-11-2016 10:32 AM  
     */
    $(document).on('click', 'input[id="add_bKashAmount"]', function () {
        if (ckMobileValidate !== undefined && ckTrxIDValidate !== undefined && ckbKashPayAmountValidate !== undefined) {
            if (ckMobileValidate === '' && ckTrxIDValidate === '' && ckbKashPayAmountValidate === '') {
                $('#bKashSubmit_error').html('').fadeOut('slow');

                $('#viewbKashInfo').slideDown('slow');
                var sign = (currencyType === '1') ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
                $('#bkashMobileNumber_view').html(mobileNumber);
                $('#bkashTransactionID_view').html(trxID);
                $('#paymentAmount_view').html(bKashPayAmount + sign);

                hidebKashPaymentForm();
            } else {
                $('#bKashSubmit_error').html('Please type proper input').fadeIn('slow');
            }
        } else {
            $('#bKashSubmit_error').html('Please type proper input').fadeIn('slow');
        }
    });



    /*
     * @Description         : save cheque payment Amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-11-2016 11:10 AM  
     */
    $(document).on('click', 'button[id="bKashPayBtn"]', function () {
        if (ckMobileValidate !== undefined && ckTrxIDValidate !== undefined && ckbKashPayAmountValidate !== undefined) {
            if (ckMobileValidate === '' && ckTrxIDValidate === '' && ckbKashPayAmountValidate === '') {
                $('#bKashSubmit_error1').html('').fadeOut('slow');

                var formData = new FormData();
                formData.append('invoice_id', invoiceID);
                formData.append('mobile_number', mobileNumber);
                formData.append('transaction_id', trxID);
                formData.append('currency_type', currencyType);
                formData.append('paid_amount', bKashPayAmount);

                $.ajax({
                    type: 'post',
                    url: baseUrl + 'admin/payment/save-refund-bkash',
                    data: formData,
                    async: true,
                    processData: false,
                    cache: false,
                    contentType: false,
                    traditional: true,
                    success: function (data, textStatus, jqXHR) {
                        var cashData = JSON.parse(data);
                        if (cashData.error === undefined) {
                            window.location.href = cashData.redirect_url;
                        }
                    }
                });
            } else {
                $('#bKashSubmit_error1').html('please update your payment').fadeIn('slow');
            }
        } else {
            $('#bKashSubmit_error1').html('please update your payment').fadeIn('slow');
        }
    });
    /*
     * ---------------------End bKash Payment--------------------------------------
     */




    /*
     * ---------------------Start Cheque Payment--------------------------------------
     */
    var bankID, accountNumber, chequePayAmount;
    var chequeBankValidate, chequeBankBranchValidate, chequeAccValidate, chequePayValidate;
    /*
     * @Description         : view Cheque payment modal
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:51 PM  
     */
    $(document).on('click', 'button[id="chequeBtn"]', function () {
        $('#checkPaymentModal').modal('show');
    });

    /*
     * @Description         : open cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 19-11-2016 04:53 AM  
     */
    $(document).on('click', 'a[id="openChequeButton"]', function () {
        showChequePaymenrForm();
    });



    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:04 PM  
     */
    $(document).on('click', 'a[id="closeChequeButton"]', function () {
        hideChequePaymenrForm();
    });


    /*
     * @Description         : show cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:42 PM  
     */
    function showChequePaymenrForm() {
        $('#openChequeButton').hide('slow');
        $('#closeChequeButton').show('slow');
        $('#chequeForm').slideDown("slow");
    }


    /*
     * @Description         : hide cash payment form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:43 PM  
     */
    function hideChequePaymenrForm() {
        $('#openChequeButton').show('slow');
        $('#closeChequeButton').hide('slow');
        $('#chequeForm').slideUp("slow");
    }



    /*
     * @Description         : check bank ID validation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 04:43 PM  
     */
    $(document).on('change', 'select[id="bank_id"]', function () {
        bankID = $('#' + this.id).val();
        var output = '<option  value="">Select Bank Branch</option>';
        if (bankID !== '') {
            $.post(baseUrl + 'admin/get-bank-branch-data', {bank_id: bankID}, function (data) {
                var branchData = JSON.parse(data);

                if (branchData.length > 0) {
                    var i = 0;
                    $.each(branchData, function () {
                        output += '<option value="' + branchData[i].bank_branch_id + '">' + branchData[i].bank_branch_name + '</option>';
                        i++;
                    });
                    $('#bank_branch_id').html(output);
                }
            });
            chequeBankValidate = '';
            $('#bankID_error').html('').fadeOut('slow');
        } else {
            chequeBankValidate = 1;
            $('#bank_branch_id').html(output);
            $('#bankID_error').html('Please select Bank Name').fadeIn('slow');
        }
    });


    /*
     * @Description         : get bank branch ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-01-2017 04:47 PM  
     */
    var bankBranchID;
    $(document).on('change', 'select[id="bank_branch_id"]', function () {
        bankBranchID = $('#' + this.id).val();

        if (bankBranchID !== '') {
            chequeBankBranchValidate = '';
            $('#bankBranchID_error').html('').fadeOut('slow');
        } else {
            chequeBankBranchValidate = 1;
            $('#bankBranchID_error').html('Please select Bank Branch Name').fadeIn('slow');
        }
    });

    /*
     * @Description         : check cheaque account number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:19 PM  
     */
    $(document).on('keyup', 'input[id="cheque_account_number"]', function () {
        accountNumber = $('#' + this.id).val();
        if (accountNumber !== '') {
            if (regxExp.test(accountNumber)) {
                chequeAccValidate = '';
                $('#check_account_number_error').html('').fadeOut('slow');
            } else {
                chequeAccValidate = 1;
                $('#check_account_number_error').html('No special caracter allow accept -').fadeIn('slow');
            }
        } else {
            chequeAccValidate = 1;
            $('#check_account_number_error').html('Please type cheque account number').fadeIn('slow');
        }
    });



    /*
     * @Description         : close cash payment view
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 18-11-2016 12:27 PM  
     */
    $(document).on('keyup', 'input[id="cheque_payment_amount"]', function () {
        chequePayAmount = Number($('#' + this.id).val()).toFixed(2);
        if (chequePayAmount !== '') {
            if (checkPaymentAmount(chequePayAmount) === 1) {
                chequePayValidate = 1;
                $('#payment_amount_error').html('Invalid payment amount').fadeIn('slow');
            } else {
                chequePayValidate = '';
                $('#payment_amount_error').html('').fadeOut('slow');
            }
        } else {
            chequePayValidate = 1;
            $('#payment_amount_error').html('Please type payment amount').fadeIn('slow');
        }
    });


    /*
     * @Description         : add cheque amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-11-2016 10:32 AM  
     */
    $(document).on('click', 'input[id="add_cheque"]', function () {
        if (chequeBankValidate !== undefined && chequeAccValidate !== undefined && chequePayValidate !== undefined) {
            if (chequeBankValidate === '' && chequeBankBranchValidate === '' && chequeAccValidate === '' && chequePayValidate === '') {
                $('#chequeSubmit_error').html('').fadeOut('slow');

                $('#viewChequeInfo').slideDown('slow');
                var sign = (currencyType === '1') ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
                var bankName = $('#bank_id option:selected').text();
                var bankBranchName = $('#bank_branch_id option:selected').text();
                $('#view_bank_name').html(bankName);
                $('#view_bank_branch_name').html(bankBranchName);
                $('#view_check_account_number').html(accountNumber);
                $('#view_check_payment_amount').html(chequePayAmount + sign);

                hideChequePaymenrForm();
            } else {
                $('#chequeSubmit_error').html('').html('Please type proper input').fadeIn('slow');
            }
        } else {
            $('#chequeSubmit_error').html('Please type proper input').fadeIn('slow');
        }
    });



    /*
     * @Description         : save cheque payment Amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-11-2016 11:10 AM  
     */
    $(document).on('click', 'button[id="chequePayment"]', function () {
        if (chequeBankValidate !== undefined && chequeAccValidate !== undefined && chequePayValidate !== undefined) {
            if (chequeBankValidate === '' && chequeAccValidate === '' && chequePayValidate === '') {
                $('#chequeSubmit_error1').html('').fadeOut('slow');

                var formData = new FormData();
                formData.append('invoice_id', invoiceID);
                formData.append('bank_branch_id', bankBranchID);
                formData.append('account_number', accountNumber);
                formData.append('currency_type', currencyType);
                formData.append('paid_amount', chequePayAmount);

                $.ajax({
                    type: 'post',
                    url: baseUrl + 'admin/payment/save-refund-check',
                    data: formData,
                    async: true,
                    processData: false,
                    cache: false,
                    contentType: false,
                    traditional: true,
                    success: function (data, textStatus, jqXHR) {
                        var cashData = JSON.parse(data);
                        if (cashData.error === undefined) {
                            window.location.href = cashData.redirect_url;
                        }
                    }
                });
            } else {
                $('#chequeSubmit_error1').html('').html('please update your payment').fadeIn('slow');
            }
        } else {
            $('#chequeSubmit_error1').html('please update your payment').fadeIn('slow');
        }
    });

    /*
     * ---------------------End Cheque Payment--------------------------------------
     */


    /*
     * @Description         : check payment amount
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 25-11-2016 10:29 AM
     */
    var checkPaymentAmount = function (amount) {
        if (numberRegExp.test(amount)) {
            if (amount < 1) {
                return 1;
            } else {
                return (paidAmount >= amount) ? '' : 1;
            }
        } else {
            return 1;
        }
    };
});

