$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();
    /*
     * @Description         : get payment from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 10:40 AM   
     */
    $(document).on('click', 'input[id^=paymentMethod]', function () {
        var ID = this.id.replace('paymentMethod', '');
        if (ID === '1') {
            $('#bkashMethodView').slideDown();
            $('#checkMethodView').slideUp();
        }
        if (ID === '2') {
            $('#checkMethodView').slideDown();
            $('#bkashMethodView').slideUp();
        }
        if (ID === '3') {
            $('#paypalMethodView').slideDown();
        }
    });

    /*
     * @Description         : ceeck bkash number existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 10:58 AM   
     */
    $(document).on('keyup', 'input[id="bkashNumber"]', function () {
        var bkashNumber = $('#' + this.id).val();

        $.post(baseUrl + 'admin/check-payment-bkash-number', {bkash_number: bkashNumber}, function (data) {
            if (data === '1') {
                $('#bkashNumberExistence').val(1);
            } else {
                $('#bkashNumberExistence').val('');
            }
        });
    });

    /*
     * @Description         : update bkash payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:47 AM   
     */
    var previousBkashNumber;
    $(document).on('click', 'a[id^="editBkashInfo"]', function () {
        var bKashPaymentID = this.id.replace('editBkashInfo', '');

        $.post(baseUrl + 'admin/get-bkash-payment-info', {bkash_payment_id: bKashPaymentID}, function (data) {
            var bkashPaymentData = JSON.parse(data);

            $('#updateBkashMethodView').slideDown('slow');
            $('#bkashPaymentID').val(bKashPaymentID);
            previousBkashNumber = bkashPaymentData.bkash_number;
            $('#edit_bkash_number').val(bkashPaymentData.bkash_number);
            $('input[name=edit_bkash_number_type][value=' + bkashPaymentData.bkash_number_type + ']').attr('checked', true);
        });
    });


    /*
     * @Description         : check bkash number for edit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 11:55 AM   
     */
    $(document).on('keyup', 'input[id="edit_bkash_number"]', function () {
        var bkashNumber = $('#' + this.id).val();

        if (bkashNumber !== previousBkashNumber) {
            $.post(baseUrl + 'admin/check-payment-bkash-number', {bkash_number: bkashNumber}, function (data) {
                if (data === '1') {
                    $('#editbkashNumberExistence').val(1);
                } else {
                    $('#editbkashNumberExistence').val('');
                }
            });
        } else {
            $('#editbkashNumberExistence').val('');
        }
    });


    /*
     * @Description         : delete bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 02:50 PM   
     */
    $(document).on('click', 'a[id^="deleteBkashInfo"]', function () {
        var bkashPaymentId = this.id.replace('deleteBkashInfo', '');
        $('#viewDeleteBkashPaymentModal' + bkashPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtonbKashPayment"]', function () {
        var bkashPaymentId = this.id.replace('modalNoButtonbKashPayment', '');
        $('#viewDeleteBkashPaymentModal' + bkashPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonbKashPayment"]', function () {
        var bkashPaymentId = this.id.replace('modalYesButtonbKashPayment', '');

        $.post(baseUrl + 'admin/delete-bkash-payment-method', {bkash_payment_id: bkashPaymentId}, function () {
            location.reload();
        });
    });


//    ------------------------------check part-------------------------------

    /*
     * @Description         : get bank ID for view bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 11:51 PM   
     */
    var bankId;
    $(document).on('change', 'select[id=bankId]', function () {
        var output = '<option value="">Select Bank Branch</option>';
        bankId = $('#' + this.id).val();
        var output1 = getBranchDataView(bankId, output);
        $('#bankBranchId').html(output1);
    });

    /*
     * @Description         : check account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-12-2016 03:23 PM   
     */
    $(document).on('blur', 'input[id="personAccountNumber"]', function () {
        var accountNumber = $('#' + this.id).val();
        if (bankId !== '') {
            $.post(baseUrl + 'admin/check-account-number', {bank_id: bankId, account_number: accountNumber}, function (data) {
                if (data === '1') {
                    $('#accountNumberExists').val(1);
                } else {
                    $('#accountNumberExists').val('');
                }
            });
        }
    });


    /*
     * @Description         : update check payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 09:50 AM   
     */
    var previousAccountNumber;
    $(document).on('click', 'a[id^="editCheckInfo"]', function () {
        var checkPaymentID = this.id.replace('editCheckInfo', '');
        var output = '<option value="">Select Bank Branch</option>';

        $.post(baseUrl + 'admin/get-check-payment-info', {check_payment_id: checkPaymentID}, function (data) {
            var checkPaymentData = JSON.parse(data);

            $('#updateCheckMethodView').slideDown('slow');
            bankId = checkPaymentData.branch_info.bank_id;
            $('#editBankId').val(checkPaymentData.branch_info.bank_id);
            var output1 = getBranchDataView(checkPaymentData.branch_info.bank_id, output);
            $('#edit_BankBranchId').html(output1);
            $('#edit_BankBranchId').val(checkPaymentData.branch_info.bank_branch_id);

            $('#checkPaymentID').val(checkPaymentID);
            previousAccountNumber = checkPaymentData.check_payment_info.person_account_number;
            $('#edit_person_account_number').val(checkPaymentData.check_payment_info.person_account_number);
        });
    });

    /*
     * @Description         : check account number for edit check amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 10:09 AM   
     */
    $(document).on('blur', 'input[id="edit_person_account_number"]', function () {
        var accountNumber = $('#' + this.id).val();
        if (bankId !== '') {
            if (previousAccountNumber !== accountNumber) {
                $.post(baseUrl + 'admin/check-account-number', {bank_id: bankId, account_number: accountNumber}, function (data) {
                    if (data === '1') {
                        $('#edit_AccountNumberExists').val(1);
                    } else {
                        $('#edit_AccountNumberExists').val('');
                    }
                });
            } else {
                $('#edit_AccountNumberExists').val('');
            }
        }
    });

    /*
     * @Description         : delete check payment method
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 31-12-2016 10:59 PM   
     */
    $(document).on('click', 'a[id^=deletecheckInfo]', function () {
        var checkPaymentId = this.id.replace('deletecheckInfo', '');
        $('#viewDeleteCheckPaymentModal' + checkPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtoncheckPayment"]', function () {
        var checkPaymentId = this.id.replace('modalNoButtoncheckPayment', '');
        $('#viewDeleteCheckPaymentModal' + checkPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtoncheckPayment"]', function () {
        var checkPaymentId = this.id.replace('modalYesButtoncheckPayment', '');

        $.post(baseUrl + 'admin/delete-check-payment-method', {check_payment_id: checkPaymentId}, function () {
            location.reload();
        });
    });

    //---------------------paypal account view-----------------------------------
    /*
     * @Description         : check paypal email ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2017 11:30 AM   
     */
    $(document).on('keyup', 'input[id="paypalEmail"]', function () {
        var paypalEmail = $('#' + this.id).val();

        $.post(baseUrl + 'admin/check-paypal-email', {paypal_email: paypalEmail}, function (data) {
            if (data === '1') {
                $('#paypalEmailEsists').val(1);
            } else {
                $('#paypalEmailEsists').val('');
            }
        });
    });

    /*
     * @Description         : check bank branch name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:43 PM   
     */
    var previousPaypalEmail;
    $(document).on('click', 'a[id^="editPaypalPayment"]', function () {
        var paymentMethodId = this.id.replace('editPaypalPayment', '');

        $.post(baseUrl + 'admin/get-paypal-payment-info', {payment_method_id: paymentMethodId}, function (data) {
            var paypalPaymentInfo = JSON.parse(data);

            $('#updatePaypalMethodView').slideDown('slow');
            $('#edit_PaypalEmail').val(paypalPaymentInfo.paypal_email);
            previousPaypalEmail = paypalPaymentInfo.paypal_email;
            $('#payPalMethodid').val(paymentMethodId);
        });
    });

    /*
     * @Description         : check paypal email ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 11:48 AM   
     */
    $(document).on('blur', 'input[id="edit_PaypalEmail"]', function () {
        var paypalEmail = $('#' + this.id).val();

        if (previousPaypalEmail !== paypalEmail) {
            $.post(baseUrl + 'admin/check-paypal-email', {paypal_email: paypalEmail}, function (data) {
                if (data === '1') {
                    $('#edit_paypalEmailEsists').val(1);
                } else {
                    $('#edit_paypalEmailEsists').val('');
                }
            });
        } else {
            $('#edit_paypalEmailEsists').val('');
        }
    });

    /*
     * @Description         : delete paypal payment information
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 31-12-2016 12:27 PM   
     */
    $(document).on('click', 'a[id^=deletePaypalInfo]', function () {
        var paypalPaymentId = this.id.replace('deletePaypalInfo', '');
        $('#viewDeletePaypalPaymentModal' + paypalPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtonpaypalPayment"]', function () {
        var paypalPaymentId = this.id.replace('modalNoButtonpaypalPayment', '');
        $('#viewDeletePaypalPaymentModal' + paypalPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonpaypalPayment"]', function () {
        var paypalPaymentId = this.id.replace('modalYesButtonpaypalPayment', '');
        
        $.post(baseUrl + 'admin/delete-paypal-payment-method', {paypal_payment_id: paypalPaymentId}, function () {
            location.reload();
        });
    });
});


/*
 * @Description         : get all bank branch name by bank ID
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 26-12-2016 02:55 PM   
 */
function getBankData(bankId) {
    var output;
    var baseUrl = $('#baseUrl').val();
    $.ajax({
        type: 'POST',
        url: baseUrl + 'admin/get-bank-branch',
        data: {bank_id: bankId},
        dataType: 'html',
        async: false,
        success: function (data) {
            output = data;
        }
    });
    return output;
}


/*
 * @Description         : get all branch data view
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 26-12-2016 02:58 PM   
 */
function getBranchDataView(bankId, output) {
    var bankBranchData = JSON.parse(getBankData(bankId));

    var i = 0;
    $.each(bankBranchData, function () {
        output += '<option value="' + bankBranchData[i].bank_branch_id + '">' + bankBranchData[i].bank_branch_name + '</option>';
        i++;
    });
    return output;
}