function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}




/*
 -----------@@@RIPON@ Start Add Menu Part----------------------------------
 */
/*
 * @Function            : getMenuType 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : get menu type and check other option
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 05:32 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function getMenuType(menuType, url) {
    var parentMenuResponse;
    parentMenuResponse = checkXMLHTTP(parentMenuResponse);

    // call menu order function for menu order
    getMenuOrder();

    var fullURL = url + menuType;
    parentMenuResponse.open("GET", fullURL);
    parentMenuResponse.onreadystatechange = function ()
    {
        if (parentMenuResponse.readyState === 4 && parentMenuResponse.status === 200)
        {
            documentID('parent_menu').innerHTML = parentMenuResponse.responseText;
            getParentMenu();
            getSectionTextField();
        }
    };
    parentMenuResponse.send(null);
}



/*
 * @Function            : getSection 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : get Menu Section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:46 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
var menuSectionURL;
function getParentMenu(parentMenu1) {
    var menuSectionResponse;
    menuSectionResponse = checkXMLHTTP(menuSectionResponse);

    var menuType = 'null';
    var parentMenu = 'null';

    if (documentID('menu_type').value !== '') {
        menuType = documentID('menu_type').value;
    }
    if (parentMenu1 !== '') {
        parentMenu = parentMenu1;
    }

    // call menu order function for menu order
    getMenuOrder();

    var fullURL = menuSectionURL + menuType + '/' + parentMenu;
    menuSectionResponse.open("GET", fullURL);
    menuSectionResponse.onreadystatechange = function ()
    {
        if (menuSectionResponse.readyState === 4 && menuSectionResponse.status === 200)
        {
            getSectionTextField();
            documentID('menu_section_name').innerHTML = menuSectionResponse.responseText;
        }
    };
    menuSectionResponse.send(null);
}



/*
 * @Function            : checkManuExists 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : check manu name if it is exists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 05:36 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function checkManuExists(menuName, url) {
    var menuNameResponse;
    menuNameResponse = checkXMLHTTP(menuNameResponse);

// call makeManuUrl() function for Make menu
    makeManuUrl(menuName);

    var manuName1 = menuName.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("manu_name", manuName1);

    menuNameResponse.addEventListener("load", function () {
        documentID('manu_name_exist').value = menuNameResponse.responseText;
    }, false);
    menuNameResponse.open("POST", url);
    menuNameResponse.send(formdata);
}



/*
 * @Function            : getSectionTextField 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : add section field
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:08 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function getSectionTextField(value) {
    // call menu order function for menu order
    getMenuOrder();
    if (value === '1') {
        documentID('section_text').style.display = 'block';
        documentID('section_text').setAttribute("style", "padding-top: 12px;");
    } else {
        documentID('section_text').style.display = 'none';
    }
}



/*
 * @Function            : checkUrlCharacter 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : Check menu all kind of special character 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:14 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function checkUrlCharacter(profileID) {
    for (i = 0; profileID.length > i; i++) {
        if (profileID.charAt(i) === ' ') {
            profileID = profileID.replace(/ +/g, '-');
        }
        if (profileID.charAt(i) === '.') {
            profileID = profileID.replace(/\./g, '');
        }
        if (profileID.charAt(i) === '-') {
            profileID = profileID.replace(/--/g, '-');
        }

    }
    profileID = profileID.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
    if (profileID.charAt(profileID.length - 1) === '-') {
        profileID = setCharAt(profileID, profileID.length - 1, '');
    }
    profileID = profileID.replace(/--/g, '-');
    profileID = profileID.replace(' ', '-');
    return profileID.toLowerCase();
}



/*
 * @Function            : makeManuUrl 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : Make make URL
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:14 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function makeManuUrl(profileID) {
    if (profileID === '') {
        documentID('menu_url').value = '';
    } else {
        var profileID1 = checkUrlCharacter(profileID);
        documentID('menu_url').value = profileID1;
        checkProfileUrl(profileID);
    }
}



/*
 * @Function            : checkProfileUrl 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : check menu URL if it is exists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:25 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
var menuURLExists;
function checkProfileUrl(menuURL) {
    var menuURLResponse;
    menuURLResponse = checkXMLHTTP(menuURLResponse);

    if (menuURL !== '') {
        var fullURL = menuURLExists + menuURL;
        menuURLResponse.open("GET", fullURL);
        menuURLResponse.onreadystatechange = function ()
        {
            if (menuURLResponse.readyState === 4 && menuURLResponse.status === 200)
            {
                if (menuURLResponse.responseText === '1')
                {
                    documentID('url_exist').value = 1;
                } else if (menuURLResponse.responseText === '2')
                {
                    documentID('url_exist').value = '';
                }
            }
        };
        menuURLResponse.send(null);
    }
}




/*
 * @Function            : getMenuOrder 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : get Menu Order
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 06:46 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
var menuOrderURL;
var menuOrder = new Array();
function getMenuOrder() {
    var menuOrderResponse;
    menuOrderResponse = checkXMLHTTP(menuOrderResponse);

    var menu_type = 'null';
    var parentMenu = 'null';
    var menuSection = 'null';

    if (documentID('menu_type').value !== '') {
        menu_type = documentID('menu_type').value;
    }

    if (documentID('parent_menu').value !== '') {
        parentMenu = documentID('parent_menu').value;
    }
    if (documentID('menu_section_name').value !== '') {
        menuSection = documentID('menu_section_name').value;
    }
//alert(menuOrderURL);
//    alert(menu_type + '---' + parentMenu + '---' + menuSection);

    var fullURl = menuOrderURL + menu_type + '/' + parentMenu + '/' + menuSection;
    menuOrderResponse.open("GET", fullURl);
    menuOrderResponse.onreadystatechange = function ()
    {
        if (menuOrderResponse.readyState === 4 && menuOrderResponse.status === 200)
        {
//            alert(menuOrderResponse.responseText);
            var menuOrderStr = menuOrderResponse.responseText;
            if (menuOrderStr !== '') {
                menuOrder = menuOrderStr.split(",");
//                alert(menuOrder.length)
                for (var i = 0; i < menuOrder.length + 1; i++) {
                    if (parseInt(menuOrder[i]) !== i + 1) {
                        documentID('menu_order').value = i + 1;
                        break;
                    } else {
                        continue;
                    }
                }
            } else {
                documentID('menu_order').value = 1;
            }
        }
    };
    menuOrderResponse.send(null);
}




/*
 * @Function            : getMenuOrder 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : get Menu Order
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 09-02-2016 07:46 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function getInputMenuOrder(input) {
    if (menuOrder.indexOf(input) !== -1) {
        documentID('menu_order').value = '';
        documentID('menu_order').placeholder = 'Please change menu order';
    }
}


/*
 -----------@@@RIPON@ End Add Menu Part----------------------------------
 */




/*
 -----------@@@RIPON@ Start Manage Menu Part----------------------------------
 */


/*
 * @Function            : changeOrder 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : Change menu order using manage menu
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 10-02-2016 11:11 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function changeOrder(url, ID, status) {
    var menuOrderResponse1;
    menuOrderResponse1 = checkXMLHTTP(menuOrderResponse1);

    swal({
        title: "",
        text: "Are you sure you want to Change this Order?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var fullURL = url + '/' + ID + '/' + status;
                    menuOrderResponse1.open("GET", fullURL);
                    menuOrderResponse1.onreadystatechange = function ()
                    {
                        if (menuOrderResponse1.readyState === 4 && menuOrderResponse1.status === 200)
                        {
                            if (menuOrderResponse1.responseText === 'success') {
                                location.reload();
                            }
                        }
                    };
                    menuOrderResponse1.send(null);
                }
            });
}




/*
 * @Function            : checkChildID 
 * @Used IN             : @self                      @add_menu_form-[View]
 * @Description         : Check child menu if there is a child menu
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 10-02-2016 11:13 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
var checkChildIDURL;
function checkChildID(url, type, ID) {
    var childIDResponse;
    childIDResponse = checkXMLHTTP(childIDResponse);

    var fullURl = checkChildIDURL + ID;
    childIDResponse.open("GET", fullURl);
    childIDResponse.onreadystatechange = function ()
    {
        if (childIDResponse.readyState === 4 && childIDResponse.status === 200)
        {
            if (childIDResponse.responseText === '1') {
                swal({
                    title: "",
                    text: "You can not delete this menu?",
                    type: "warning",
                    confirmButtonColor: '#8CC73F',
                    confirmButtonText: 'OK',
                    closeOnConfirm: true
                });
            } else if (childIDResponse.responseText === '2') {
                changeMenuStatus(url, type, ID);
            }
        }
    };
    childIDResponse.send(null);
}



/*
 * @Function            : checkChildID 
 * @Used IN             : @self                      @(admin/menu/manage_menu.php) -[View]
 * @Description         : Change menu status
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : Unknown
 * @Updated Date Time   : 10-02-2016 11:17 PM
 * @Updated By          : Ripon Jaherul  
 * @Status              : available      
 */
function changeMenuStatus(url, type, ID) {
    var menuStatusResponse;
    menuStatusResponse = checkXMLHTTP(menuStatusResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + type + " this?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var fullURL = url + '/' + type;
                    menuStatusResponse.open("GET", fullURL);
                    menuStatusResponse.onreadystatechange = function ()
                    {
                        if (menuStatusResponse.readyState === 4 && menuStatusResponse.status === 200)
                        {
                            if (type === 'delete') {
                                location.reload();
                            } else {
                                documentID('menu_action' + ID).innerHTML = menuStatusResponse.responseText;
                            }
                        }
                    };
                    menuStatusResponse.send(null);
                }
            });
}


/*
 * @Function            : getMenuSearch 
 * @Used IN             : @function-'view/admin/menu/manage_menu.php' [14]
 * @Description         : search menu 
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 10-05-2016 06:05 PM 
 * @Parameter           : searchValue[STRING], url[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getMenuSearch(searchValue1, url) {
    var menuSearchResponse;
    menuSearchResponse = checkXMLHTTP(menuSearchResponse);

    var searchValue = searchValue1.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("search_value", searchValue);

    menuSearchResponse.addEventListener("load", function () {

        alert(menuSearchResponse.responseText);

    }, false);
    menuSearchResponse.open("POST", url);
    menuSearchResponse.send(formdata);
}