
/*
 * @Author              : Kazol 
 * @CreatedDate         : 27-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : add-video-section
 * @Description         : This function is used for add section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id
 * @Return              : $result    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function add_video_section(){
    var baseUrl = $('#baseUrl').val();
    var section_name = $('#video_course_section_name').val();
    var video_course_id = $('#section_id_indivisual_video_course').val();
    var person_id = $('#person_id').val();
    $.post(baseUrl+'add-video-section',
    {
       section_name : section_name,
       video_course_id : video_course_id,
       person_id : person_id
    },
    function(data){
        if(data === 'no_section'){
            $('#video_section_error').show();
            $('#video_section_error').html('Please Type Section Name');
        }else{
            if(data === 'no_table'){
                $('#video_section_error').show();
                $('#video_section_error').html('Table may not exist');
            }else{
                if(data === 'section_name_exist'){
                $('#video_section_error').show();
                $('#video_section_error').html('Section name Already Exist');
                }else{
                    $('#all_manage_video_course_section').html(data);
                    $('#video_course_section_name').val('');
                    $('#video_section_error').hide();
                }
            }
            
        }
    });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 05-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : edit-video-section
 * @Description         : This function is used for edit section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function edit_section(section_id){
    $('#add_video_course_section').hide();
    $('#update_video_course_section').show();
    var baseUrl = $('#baseUrl').val();
    $.post(baseUrl+'edit-video-section',
    {
        section_id : section_id
    },
    function(data){
        if(data === 'no_table'){
            $('#edit_video_section_error').show();
            $('#edit_video_section_error').html('Table may not exist');
        }else{
            var section_information = JSON.parse(data);
            //console.log(section_information);
            var section_name = section_information.section_name;
            var section_id = section_information.section_id;
            $("#update_video_course_section_name").val(section_name);
            $("#section_id_of_video_course").val(section_id);
        }
    });
 }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : manage-video-section-by-ajax
 * @Description         : This function is used for selecting all section for managing by ajax 
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 function manage_section_by_ajax(){
     var video_course_id = $('#section_id_indivisual_video_course').val();
     var baseUrl = $('#baseUrl').val();
     $.post(baseUrl+'manage-video-section-by-ajax',
     {
         video_course_id : video_course_id
     },function(data){
        if(data === 'no_table'){
            $('#manage_video_section_error').show();
            $('#manage_video_section_error').html('Table may not exist');
        }else{
             $('#all_manage_video_course_section').html(data);
        }
    });
 }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for hide and show the add and edit section div
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 function add_section(){
    $('#video_section_error').hide();
    $('#add_video_course_section').show();
    $('#update_video_course_section').hide();
 }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : update-video-section
 * @Description         : This function is used for update video course section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 function update_video_section(){
     var section_id = $('#section_id_of_video_course').val();
     var section_name = $('#update_video_course_section_name').val();
     var search_video_section = $('#search_video_section').val();
     var page_number = $('#pagination_page_number').val();
     console.log(page_number);
     var video_course_id = $('#section_id_indivisual_video_course').val();
     var baseUrl = $('#baseUrl').val();
     $.post(baseUrl+'update-video-section',
     {
         section_id : section_id,
         section_name : section_name,
         video_course_id : video_course_id,
         search_input : search_video_section,
         page_number : page_number
     },function(data){
         if(data === 'no_section'){
             $('#edit_video_section_error').show();
             $('#edit_video_section_error').html('Please Type Section Name');
         }else{
             if(data === 'no_table'){
                $('#edit_video_section_error').show();
                $('#edit_video_section_error').html('Table may not exist');
             }else{
                if(data === 'found'){
                   $('#edit_video_section_error').show();
                   $('#edit_video_section_error').html('Section Name Already Exist');
                }else{
                   $('#all_manage_video_course_section').html(data);
                   $('#update_video_course_section').hide();
                   $('#edit_video_section_error').hide();
                }
             }
             
        }
     });
 }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for pagination of search video course section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : search_value, url
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 function search_video_course_section(search_value, url){
     var search_input = (search_value.replace(/  +/g, ' ')).trim();
     var video_course_id = $('#section_id_indivisual_video_course').val();
     $.post(url,{
         search_input : search_input,
         video_course_id : video_course_id
     },function(data){
         $('#all_manage_video_course_section').html(data);
     });
 }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : pagination-video-section
 * @Description         : This function is used for paginating video section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 $(document).ready(function(){
     $(document).on('click',"a[id^=video_course_section_pagination]",function(){
         var video_course_id = $('#section_id_indivisual_video_course').val();
         var search_video_section = $('#search_video_section').val();
         var page_number = this.id.replace('video_course_section_pagination', '');
         var baseUrl = $('#baseUrl').val();
         
        if(search_video_section != ''){
            var url = baseUrl+'search-video-section';
            
            var formdata = new FormData(); 
            formdata.append("video_course_id", video_course_id);
            formdata.append("search_input", search_video_section);
            formdata.append("page_number", page_number);
        }else{
            var url = baseUrl+'pagination-video-section';
            var formdata = new FormData(); 
            formdata.append("video_course_id", video_course_id);
            formdata.append("page_number", page_number);
        }
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#all_manage_video_course_section').html(data);
            }
        });
    });
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : order-video-section-when-video-exist
 * @Description         : This function is used for getting the video when admin wants to order video after any video by 
 *                        selecting after from the dropdown 
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    $(document).on('change','select[id="video_order"]',function(){
        var order = $('#'+this.id).val();
        //var manage_video_id = $('#move_video_by_manage_video_id').val();
        //console.log(manage_video_id);
        var output = '<option value="">Select Video Name</option>';
        if(order === '2'){
            $('#video_name_view').show();
            var baseUrl = $('#baseUrl').val();
            var section_id = $('#order_video_by_section_id').val();
            var manage_video_id = $('#move_video_by_manage_video_id').val();
            //console.log(manage_video_id);
            $.post(baseUrl+'order-video-section-when-video-exist',
            {
                section_id : section_id,
                manage_video_id : manage_video_id
            },function(data){
                var video = JSON.parse(data);
                console.log(video);
                for (var i = 0; i < video.video_id.length; i++) {
                    output += '<option value="' + video.video_id[i] + '">' + video.video_name[i] + '</option>';
                }

                $('#selected_video_ordering').html(output);
            });
        }else {
            $('#video_name_view').hide();
        }
    });
/*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for hiding the ordering div 
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    $(document).on('click', 'button[id="CancelBtn"]', function () {
        $('#view_section_order').hide();
    });
    //////////////
    
//    $(document).on('click','button[id="move_video_of_a_section"]',function(){
//        var baseUrl = $('#baseUrl').val();
//        var manage_video_id = $('#move_video_by_manage_video_id').val();
//        console.log(baseUrl);
//        console.log(manage_video_id);
//        
//    });
});
/*
 * @Author              : Kazol 
 * @CreatedDate         : 07-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for hide and show the add/edit section error message
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function check_section_name(section_value){
    if(section_value != ''){
        $('#video_section_error').hide();
        $('#edit_video_section_error').hide();
    }else{
        $('#video_section_error').show();
        $('#video_section_error').html('Please Type Section Name');
        $('#edit_video_section_error').show();
        $('#edit_video_section_error').html('Please Type Section Name');
    }
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : order-video-section-when-video-exist
 * @Description         : This function is used for add video to section by checking the section have videos or don't have
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function add_video_to_section(url, video_course_id, section_id, manage_video_id){
    
    $.post(url,
    {
        video_course_id : video_course_id,
        section_id : section_id,
        manage_video_id : manage_video_id
    },function(data){
        $('#section_order_for_video_section').html(data);
    });
}

function show_div_for_moving_video(id){
    $('#view_section_order').show();
    $('#move_video_by_manage_video_id').val(id);
    //console.log(id);
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : delete-single-section-video
 * @Description         : This function is used for delete a video of a section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : url, section_id, manage_video_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function delete_single_section_video(url, section_id, manage_video_id){
    var formdata = new FormData();
    formdata.append("section_id", section_id);
    formdata.append("manage_video_id", manage_video_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this video ?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function ()
                    {
                        location.reload();
                    }
                });
            }
        });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for delete a section and its contains all videos and workfiles
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : url, video_course_id, section_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function delete_section(url, video_course_id, section_id){
    console.log(video_course_id);
    console.log(section_id);
    var formdata = new FormData();
    formdata.append("video_course_id", video_course_id);
    formdata.append("section_id", section_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this Section ?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function ()
                    {
                        location.reload();
                    }
                });
            }
        });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : search-section-video
 * @Description         : This function is used for search video by giving input in the search box
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : search_value, url
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function manage_section_video_search(search_value, url){
    var searchInput = (search_value.replace(/  +/g, ' ')).trim();
    var manage_admin_video_status = $('#manage_section_video_status').val();
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    var section_id = $('#order_video_by_section_id').val();
    
    var formdata = new FormData(); 
    formdata.append("search_value", searchInput);
    formdata.append("manage_admin_video_status", manage_video_status);
    formdata.append("section_id", section_id);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : search-section-video
 * @Description         : This function is used for search video by selecting video status from dropdown
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : manage_admin_video_status, url
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function manage_section_video_status(manage_admin_video_status, url){
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    var search_value = $('#manage_section_video_search').val();
    var searchInput = (search_value.replace(/  +/g, ' ')).trim();
    var section_id = $('#order_video_by_section_id').val();
    
    var formdata = new FormData(); 
    formdata.append("manage_admin_video_status", manage_video_status);
    formdata.append("search_value", searchInput);
    formdata.append("section_id", section_id);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : search-section-video, pagination-section-video
 * @Description         : This function is used for search and pagination of a single section video 
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
$(document).on('click', "a[id^=manage_section_video_pagination]", function () {
    var page_number = this.id.replace('manage_section_video_pagination', '');
    var section_id = $('#order_video_by_section_id').val();
    var baseUrl = $('#baseUrl').val();
    
    var search_value = $('#manage_section_video_search').val();
    var manage_admin_video_status = $('#manage_section_video_status').val();
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    
    if(search_value != '' || (search_value == '' && manage_video_status != '0')){
        var searchInput = (search_value.replace(/  +/g, ' ')).trim();
        var url = baseUrl + 'search-section-video';
        var formdata = new FormData(); 
        formdata.append("search_value", searchInput);
        formdata.append("manage_admin_video_status", manage_video_status);
        formdata.append('page_number', page_number);
        formdata.append('section_id', section_id);
    }
    else{
        var url = baseUrl + 'pagination-section-video';
        var formdata = new FormData(); 
        formdata.append('page_number', page_number);
        formdata.append('section_id', section_id);
    }
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });    
});
/*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : delete-section-single-resolution-video
 * @Description         : This function is used for delete single resolution video of a video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : url, manage_video_location_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function deleteSectionSingleResolutionVideo(url, manage_video_location_id){
    var formdata = new FormData();
    formdata.append("manage_video_location_id", manage_video_location_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this resolution video?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
    function(isConfirm){
        if(isConfirm){
            $.ajax({
                url: url,
                type: "POST",
                data: formdata,
                contentType: false,
                cache: false,
                processData: false,
                success: function ()
                {
                    location.reload();
                }
            });
        }
    });
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : delete-section-video-workfile
 * @Description         : This function is used for delete workfile of a single video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : url, work_file_type_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function deleteSectionVideoWorkfile(url, work_file_type_id){
    var formdata = new FormData(); 
    formdata.append("work_file_type_id", work_file_type_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this work file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
    function (isConfirm) {
        if (isConfirm) {
            $.ajax({
                url: url,
                type: "POST",
                data: formdata,
                contentType: false,
                cache: false,
                processData: false,
                success: function ()
                {
                    location.reload();
                }
            });
        }
    });
}


