$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();
    /*
     * @Description         : View all invoices
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-01-2017 05:41 PM    
     */
    $(document).on('click', 'div[id^="viewAllInvoices"]', function () {
        var studentRollNumber = this.id.replace('viewAllInvoices', '');
        var paymentID = $('#paymentID' + studentRollNumber).val();
        var status = $('#status' + studentRollNumber).val();

        if (status !== '') {
            $('#displayAllInvoice' + studentRollNumber).slideUp('slow');
            $('#status' + studentRollNumber).val('');
        } else {
            $.ajax({
                type: 'post',
                url: baseUrl + 'admin/view-all-earning-invoice',
                data: {payment_id: paymentID},
                beforeSend: function () {
                    $('#loadingImage' + studentRollNumber).slideDown('slow');
                },
                complete: function (jqXHR, textStatus) {
                    $('#loadingImage' + studentRollNumber).slideUp('slow');
                },
                success: function (data, status) {
                    if (status === 'success') {
                        var viewPage = JSON.parse(data);
                        $('#displayAllInvoice' + studentRollNumber).html(viewPage).slideDown('slow');
                        $('#status' + studentRollNumber).val(1);
                    }
                }
            });
        }
    });

    /**
     * @Description         : update payment invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-01-2016 12:04 PM 
     * */
    $(document).on('click', 'a[id^="activeInvoice"]', function () {
        var invoiceId = this.id.replace('activeInvoice', '');
        $('#viewActiveInvoiceModal' + invoiceId).modal('show');
    }).on('click', 'button[id^="modalNoButtonActiveInvoice"]', function () {
        var invoiceId = this.id.replace('modalNoButtonActiveInvoice', '');
        $('#viewActiveInvoiceModal' + invoiceId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonActiveInvoice"]', function () {
        var invoiceId = this.id.replace('modalYesButtonActiveInvoice', '');

        $.post(baseUrl + 'admin/update-payment-status', {temp_invoice_id: invoiceId}, function (data) {
//            var invoiceData = JSON.parse(data);
            var earningInvoiceActionHtmlView = '<a target="_blank" href="' + baseUrl + 'admin/view-invoice/' + invoiceId + '"><i class="fa fa-dollar" title="View Invoice"></i></a><span>&nbsp;</span>';
            $('#earningInvoiceAction' + invoiceId).html(earningInvoiceActionHtmlView);
        });
    });
});
