$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();
    /* 
     * @Description         : get course register input for search student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-02-2017 11:32 AM    
     */
    $(document).on('keyup', 'input[id="searchCourseRegisterText"]', function () {
        var searchInput = $('#' + this.id).val();

        $.post(
                baseUrl + 'admin/search-course-register-student',
                {search_input: searchInput, payment_status: 'null', selected_date: 'null'},
                function (data) {
                    var viewPage = JSON.parse(data);
                    $('#view_learner_course').html(viewPage);
                });
    });


    /* 
     * @Description         : get payment Status for search student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-02-2017 11:32 AM    
     */
    $(document).on('change', 'select[id="paymentStatus"]', function () {
        var paymentStatus = $('#' + this.id).val();

        $.post(
                baseUrl + 'admin/search-course-register-student',
                {search_input: 'null', payment_status: paymentStatus, selected_date: 'null'},
                function (data) {
                    var viewPage = JSON.parse(data);
                    $('#view_learner_course').html(viewPage);
                });
    });

    /*
     * @Description         : View all invoices
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-02-2017 04:51 PM    
     */
    $(document).on('click', 'a[id^="viewAllInvoices"]', function () {
        var studentRollNumber = this.id.replace('viewAllInvoices', '');
        var paymentID = $('#paymentID' + studentRollNumber).val();
        var status = $('#status' + studentRollNumber).val();

        if (status !== '') {
            $('#displayAllInvoice' + studentRollNumber).slideUp('slow');
            $('#status' + studentRollNumber).val('');
        } else {
            $.ajax({
                type: 'post',
                url: baseUrl + 'admin/view-all-earning-invoice',
                data: {payment_id: paymentID},
                beforeSend: function () {
                    $('#loadingImage' + studentRollNumber).slideDown('slow');
                },
                complete: function (jqXHR, textStatus) {
                    $('#loadingImage' + studentRollNumber).slideUp('slow');
                },
                success: function (data, status) {
                    if (status === 'success') {
                        var viewPage = JSON.parse(data);
                        $('#displayAllInvoice' + studentRollNumber).html(viewPage).slideDown('slow');
                        $('#status' + studentRollNumber).val(1);
                    }
                }
            });
        }
    });


    /**
     * @Description         : update payment invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-01-2016 12:04 PM 
     * */
    $(document).on('click', 'a[id^="activeInvoice"]', function () {
        var invoiceId = this.id.replace('activeInvoice', '');
        $('#viewActiveInvoiceModal' + invoiceId).modal('show');
    }).on('click', 'button[id^="modalNoButtonActiveInvoice"]', function () {
        var invoiceId = this.id.replace('modalNoButtonActiveInvoice', '');
        $('#viewActiveInvoiceModal' + invoiceId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonActiveInvoice"]', function () {
        var invoiceId = this.id.replace('modalYesButtonActiveInvoice', '');

        $.post(baseUrl + 'admin/update-payment-status', {temp_invoice_id: invoiceId}, function (data) {
            var invoiceData = JSON.parse(data);
            var paymentStatus = (invoiceData.payment_status === 2) ? 'Partial Paid' : 'Paid';
            $('#paymentStatusMessage' + invoiceData.student_info.student_roll_number).html('</strong>' + paymentStatus + '</strong>');
            var earningInvoiceActionHtmlView = '<a target="_blank" href="' + baseUrl + 'admin/view-invoice/' + invoiceId + '"><i class="fa fa-dollar" title="View Invoice"></i></a><span>&nbsp;</span>';
            $('#earningInvoiceAction' + invoiceId).html(earningInvoiceActionHtmlView);
            $('#viewActiveInvoiceModal' + invoiceId).modal('hide');
        });
    });

});


/* 
 * @Description         : get Date for search student
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 05-02-2017 11:34 AM    
 */
function getCourseRegisterStudentDate(date) {
    var baseUrl = $('#baseUrl').val();

    $.post(
            baseUrl + 'admin/search-course-register-student',
            {search_input: 'null', payment_status: 'null', selected_date: date},
            function (data) {
                var viewPage = JSON.parse(data);
                $('#view_learner_course').html(viewPage);
            });
}
;