$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();

    /* 
     * @Description         : get parent topic for child topic
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-11-2016 10:50 AM
     * @Status              : Available        
     */
    $('#parent_topic_id').change(function () {
        var parentTopic = $('#parent_topic_id').val();

        if (parentTopic !== '') {
            viewChildTopic(parentTopic);
        }
    });

    /* 
     * @Description         : check server side validation for topic
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2017 02:44 PM    
     */
    var serverTopicId = $('#server_topic_id').val();
    if (serverTopicId !== '') {
        $('#parent_topic_id').val(serverTopicId);
        viewChildTopic(serverTopicId);
    }

    /* 
     * @Description         : view child topic 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2017 01:05 PM    
     */
    function viewChildTopic(parentTopic) {
        var viewOutput = '<option value="">Select Child Topic</option>';
        $.post(
                baseUrl + 'admin/course/child-topic',
                {parent_topic: parentTopic},
                function (data) {
                    var childTopicData = JSON.parse(data);

                    for (var i = 0; i < childTopicData.length; i++) {
                        viewOutput += '<option value="' + childTopicData[i].topic_id + '">' + childTopicData[i].topic_name + '</option>';
                    }
                    $('#child_topic_id').html(viewOutput);



                    /* 
                     * @Description         : check server side validation for child topic
                     * @Developed By        : MD Jaherul Islam
                     * @Start DateTime      : 12-01-2017 02:44 PM    
                     */
                    var serverChildTopicId = $('#server_child_topic_id').val();
                    if (serverChildTopicId !== '') {
                        $('#child_topic_id').val(serverChildTopicId);
                        viewCourses(serverChildTopicId);
                    }
                });
    }



    /* 
     * @Description         : get course by topic
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2017 09:56 AM    
     */
    $('#child_topic_id').change(function () {
        var childTopicID = $('#' + this.id).val();

        if (childTopicID !== '') {
            viewCourses(childTopicID);
        }

    });


    /* 
     * @Description         : view course name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2017 01:05 PM    
     */
    function viewCourses(childTopicID) {
        var url = (window.location.href).split('/');
        var personUrl = url[url.length - 1];
        var output = '<option value="">Select Course</option>';

        $.post(baseUrl + 'admin/get-course-by-topic',
                {child_topic_id: childTopicID, person_url: personUrl},
                function (data) {
                    var courseData = JSON.parse(data);
                    var i = 0;
                    $.each(courseData, function () {
                        output += '<option value="' + courseData[i].url + '">' + courseData[i].url + '</option>';
                        i++;
                    });
                    $('#course_id').html(output);


                    /* 
                     * @Description         : check server side validation for course ID
                     * @Developed By        : MD Jaherul Islam
                     * @Start DateTime      : 12-01-2017 02:44 PM    
                     */
                    var server_course_id = $('#server_course_id').val();
                    if (server_course_id !== '') {
                        $('#course_id').val(server_course_id);
                    }
                });
    }


    /* 
     * @Description         : check server side validation for topic
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2017 02:44 PM    
     */
    var server_coupon_id = $('#server_coupon_id').val();
    if (server_coupon_id !== '') {
        $('#coupon_id').val(server_coupon_id);
    }
});