<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome_model extends CI_Model {

    public function check_url_type($code) {
        $this->db->select('*');
        $this->db->from('tbl_url');
        $this->db->where('url', $code);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

//---------------Start Menu part--------------------------------------------------

    /**
     * @Function            : generate_menu 
     * @Description         : view mega menu
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    public function generate_menu() {
        $data = array();
        $data['header_menu'] = $this->select_published_menu(1);

        foreach ($data['header_menu'] as $header_menu_value) {
            $data['child_menu'][$header_menu_value->menu_id] = $this->select_all_child_menu($header_menu_value->menu_id);

            foreach ($data['child_menu'][$header_menu_value->menu_id] as $child_menu_value) {
                $data['child_menu_array'][$header_menu_value->menu_id][] = $child_menu_value->menu_id;
                $data['header_section'][$child_menu_value->menu_id] = $this->select_all_section(1, $child_menu_value->menu_id);

                foreach ($data['header_section'][$child_menu_value->menu_id] as $section_value) {
                    $data['child_menu_with_section'][$section_value->menu_section][$section_value->parent_menu_id] = $this->select_child_menu_with_section(1, $section_value->parent_menu_id, $section_value->menu_section);
                }
            }
        }

        $data['footer_section'] = $this->select_all_section(2, 0);
        if ($data['footer_section'])
 {
        foreach ($data['footer_section'] as $section_value) {
            $data['child_menu_with_section'][$section_value->menu_section] = $this->select_child_menu_with_section(2, $section_value->parent_menu_id, $section_value->menu_section);
        }
 }
        $data['view_category'] = $this->select_all_published_category();
        return $data;
    }

    public function generate_footer_menu() {
        $data['footer_section'] = $this->select_all_section(2, 0);
        foreach ($data['footer_section'] as $section_value) {
            $data['child_menu_with_section'][$section_value->menu_section] = $this->select_child_menu_with_section(2, $section_value->parent_menu_id, $section_value->menu_section);
        }
        $data['view_category'] = $this->select_all_published_category();
        return $data;
    }

    public function select_published_menu($menu_type) {
        $sql = "SELECT * 
                FROM 
                    tbl_menu AS m,
                    tbl_url AS u
                WHERE 
                        m.url_id = u.url_id
                  	AND m.menu_type = '$menu_type'
                    AND m.parent_menu_id = '0'
                    AND m.menu_section = '0'
                    AND m.menu_status = '1'
                    ORDER BY menu_order ASC";
        return $this->db->query($sql)->result();
    }

    public function select_all_child_menu($parent_menu_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_menu AS m,
                    tbl_url AS u
                WHERE 
                    parent_menu_id = '$parent_menu_id'
                AND m.url_id = u.url_id
                AND m.menu_section = '0'
                AND m.menu_status = '1'
                ORDER BY menu_order ASC";
        return $this->db->query($sql)->result();
    }

    public function select_all_section($menu_type, $menu_id) {
        $sql = "SELECT DISTINCT menu_section,parent_menu_id 
                FROM 
                    tbl_menu AS m
                WHERE 
                    m.parent_menu_id = '$menu_id'
                    AND m.menu_type = '$menu_type'
                    AND m.menu_section != '0'
                    AND m.menu_status = '1'
                    ORDER BY menu_id ASC";
        $query = $this->db->query($sql);
        
        if($query == false)
    {
        return $query;
    }
    return $query->result();
    }

    public function select_child_menu_with_section($menu_type, $parent_id, $section_name) {
        $sql = "SELECT * 
                FROM 
                    tbl_menu AS m,
                    tbl_url AS u
                WHERE 
                    m.url_id =  u.url_id
               	AND m.menu_type = '$menu_type'
               	AND m.parent_menu_id = '$parent_id'
                AND m.menu_section = '$section_name'
                AND m.menu_status = '1'
                ORDER BY menu_order ASC";
        return $this->db->query($sql)->result();
    }

    public function select_all_published_category() {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS c,
                    tbl_url AS u
                WHERE 
                    c.url_id = u.url_id
                AND c.course_category_home_page_view = '2'
                AND c.course_category_status = '1'
                ORDER BY c.course_category_id ASC";
        return $this->db->query($sql)->result();
    }

//---------------End Menu part--------------------------------------------------








 

    public function select_course_category2($parent_course_category = null) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_url as u"
                . " WHERE "
                . "         cc.url_id = u.url_id "
        ;
        if ($parent_course_category) {
            $sql .= "     AND parent_course_category = $parent_course_category";
        }

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_parent_course_category() {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_url as u"
                . " WHERE "
                . "         cc.url_id = u.url_id "
                . "     AND cc.course_category_home_page_view = '1' "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_parent_course_category_by_menu_id($menu_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_url as u"
                . " WHERE "
                . "         cc.course_category_status = '1' "
                . "     AND cc.course_category_access_level = '1' "
                . "     AND cc.menu_id = '$menu_id' "
                . "     AND cc.url_id = u.url_id "
                . "     AND cc.course_category_home_page_view = '1' "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_parent_video_course_category($menu_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc,"
                . "     tbl_url as u "
                . " WHERE "
                . "         cc.menu_id = '$menu_id' "
                . "     AND u.url_id = cc.url_id "
                . "     AND cc.course_category_home_page_view = '1' "
        ;

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_parent_video_course_category_by_menu_id($menu_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc,"
                . "     tbl_url as u "
                . " WHERE "
                . "         cc.menu_id = '$menu_id' "
                . "     AND u.url_id = cc.url_id "
                . "     AND cc.course_category_home_page_view = '1' "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_video_course_category($parent_course_category) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc,"
                . "     tbl_url as u "
                . " WHERE "
                . "         cc.parent_course_category = '$parent_course_category' "
                . "      AND u.url_id = cc.url_id "
                . "      AND cc.course_category_home_page_view ='1'"
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_all_parent_category($menu_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_menu as m, "
                . "     tbl_url as u "
                . " WHERE "
                . "          m.menu_id = '$menu_id' "
                . "      AND cc.menu_id = m.menu_id "
                . "      AND u.url_id = cc.url_id "
                . "      AND cc.course_category_home_page_view ='1'"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_course_category_by_parent_course_category($course_category_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc,"
                . "     tbl_url as u "
                . " WHERE "
                . "          cc.parent_course_category = '$course_category_id' "
                . "      AND u.url_id = cc.url_id "
                . "      AND cc.course_category_home_page_view ='1'"
        ;

        $result = $this->db->query($sql)->result();
        if ($result) {
            return $result;
        }

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc,"
                . "     tbl_url as u "
                . " WHERE "
                . "             cc.parent_course_category = '$course_category_id' "
                . "         AND u.url_id = cc.url_id "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_course($course_category_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_course_category as cc, "
                . "     tbl_person as p, "
                . "     tbl_url as u"
                . " WHERE "
                . "         cc.course_category_id = '$course_category_id' "
                . "     AND cc.course_category_id = c.course_category_id "
                . "     AND p.person_id = c.resource_person_id "
                . "     AND u.url_id = c.url_id"
                . "     AND c.course_status = '1'"
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_video_course($course_category_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm, "
                . "     tbl_course_category as cc, "
                . "     tbl_person as p, "
                . "     tbl_url as u"
                . " WHERE "
                . "         cc.course_category_id = '$course_category_id' "
                . "     AND cc.course_category_id = vm.course_category_id "
                . "     AND p.person_id = vm.person_id "
                . "     AND u.url_id = vm.url_id"
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_all_video($course_category_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management vm, "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         vm.course_category_id = '$course_category_id' "
                . "     AND uv.video_management_id = vm.video_management_id "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_all_video_by_video_management_id($video_management_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management vm, "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         vm.video_management_id = '$video_management_id' "
                . "     AND uv.video_management_id = vm.video_management_id "
        ;

        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_top_video($course_category_id, $upload_video_id = null) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management vm, "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         vm.course_category_id = '$course_category_id' "
                . "     AND uv.video_management_id = vm.video_management_id "
        ;

        if ($upload_video_id) {
            $sql .= " AND uv.upload_video_id = '$upload_video_id'";
        }

        $result = $this->db->query($sql)->row();

        return $result;
    }

    public function select_video_management_top_video($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_access_level = 1"
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function selected_course_view_info($course_id) {

        $sql = "SELECT *"
                . " FROM "
                . "      tbl_course as c, "
                . "      tbl_person as pi, "
                . "      tbl_upload_video as up, "
                . "      tbl_work_files_management as wf, "
                . "      tbl_url as u "
                . "   WHERE"
                . "           c.course_id = '$course_id' "
                . "       AND wf.upload_video_id = up.upload_video_id "
                . "       AND u.url_id = c.url_id "
                . "       GROUP BY c.course_id "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function selected_course_detail_info($course_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_url as u, "
                . "     tbl_person as p,"
                . "     tbl_resource_person as rp "
                . " WHERE "
                . "         c.course_id = '$course_id' "
                . "     AND u.url_id = c.url_id"
                . "     AND c.resource_person_id =  rp.resource_person_id "
                . "     AND rp.person_id = p.person_id "
        ;

        $result = $this->db->query($sql)->row();

        return $result;
    }

    public function selected_course_info_by_id($course_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_url as u "
                . " WHERE "
                . "         c.course_id = '$course_id' "
                . "     AND u.url_id = c.url_id "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function count_course_view($data) {
        $user_id = $this->session->userdata('user_id');
        if ($data && $data->person_id != $user_id) {
            $this->db->set('course_view', $data->course_view + 1);
            $this->db->where('course_id', $data->course_id);
            $this->db->update('tbl_course');
        }
    }

    public function selected_active_course_info_by_id($course_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_url as u "
                . " WHERE "
                . "         c.course_id = '$course_id' "
                . "     AND u.url_id = c.url_id "
                . "     AND (c.course_status = 1 OR c.course_status = 4)"
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_person_course_permission($course_id, $person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_person_permission as cpp "
                . " WHERE "
                . "         cpp.person_id IN ($person_id)"
                . "     AND cpp.course_id = $course_id"
        ;
        $result = $this->db->query($sql)->row();
        if ($result) {
            return true;
        } else {
            return false;
        }
    }

    public function check_person_video_course_permission($video_management_id, $person_email) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_person_permission as vcpp "
                . " WHERE "
                . "         vcpp.course_person_permission_email LIKE '%" . $person_email . "%'"
                . "     AND vcpp.video_management_id = '$video_management_id'"
        ;
        $result = $this->db->query($sql)->row();
        if ($result) {
            return true;
        } else {
            return false;
        }
    }

    public function select_person_group_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group_member as gm "
                . " WHERE "
                . "         gm.person_id = '$person_id' "
                . "     AND gm.group_member_status = 1"
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_person_course_group_permission($course_id, $person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_group_permission as cgp,"
                . "     tbl_group_member as gm "
                . " WHERE "
                . "         gm.person_id = '$person_id' "
                . "      AND 	gm.group_id IN (cgp.group_id) "
                . "     AND cgp.course_id = '$course_id' "
                . "     AND gm.group_member_status = 1";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_person_video_course_group_permission($course_id, $person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_group_permission as vcgp,"
                . "     tbl_group_member as gm "
                . " WHERE "
                . "         gm.person_id = '$person_id' "
                . "     AND vcgp.group_id = gm.group_id "
                . "     AND vcgp.course_id = '$course_id' "
                . "     AND gm.group_member_status = 1"
        ;
        $result = $this->db->query($sql)->row();
        if ($result) {
            return true;
        } else {
            return false;
        }
        return $result;
    }

    /**
     * Created date     : 2016-01-18
     * Name             : Mahabub-A-Mawla
     * Modified date    : 
     * Modifier name    : 
     * Work             : count group for video course group permission
     * Call from        : welcome controller -> video_course_group_permission_redirect
     *                    
     */
    public function count_group_by_video_course_group_permission($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_group_permission as vcgp "
                . " WHERE "
                . "         vcgp.video_management_id = '$video_management_id' "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function selected_course_student_info($course_id, $person_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_url as u, "
                . "     tbl_student as s, "
                . "     tbl_person as p "
                . " WHERE "
                . "         c.course_id = '$course_id' "
                . "     AND s.course_id = '$course_id' AND s.person_id = '$person_id' "
                . "     AND u.url_id = c.url_id"
                . "     AND c.person_id =  p.person_id"
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * Created date     : 2016-01-18
     * Name             : Mahabub-A-Mawla
     * Modified date    : 
     * Modifier name    : 
     * Work             : video course student information, student personal information and profile url
     * Call from        : check_video_course_permission
     * 
     */
    public function selected_video_course_student_info($video_management_id, $person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm, "
                . "     tbl_url as u, "
                . "     tbl_student as s, "
                . "     tbl_person as p "
                . " WHERE "
                . "         vm.video_management_id = '$video_management_id' "
                . "     AND s.course_id = '$video_management_id' "
                . "     AND s.person_id = '$person_id' "
                . "     AND u.url_id = vm.url_id"
                . "     AND s.person_id =  p.person_id
                        AND s.student_type = 2 ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

// End 'selected_video_course_student_info' function

    public function selected_video_course_view_info($video_management_id) {

        $sql = "SELECT *"
                . " FROM "
                . "      tbl_video_management as vm, "
                . "      tbl_person as pi, "
                . "      tbl_upload_video as up, "
                . "      tbl_work_files_management as wf, "
                . "      tbl_url as u "
                . "   WHERE"
                . "           vm.video_management_id = '$video_management_id' "
                . "       AND pi.person_id = vm.person_id "
                . "       AND wf.upload_video_id=up.upload_video_id "
                . "       AND u.url_id = vm.url_id "
                . "       GROUP BY vm.video_management_id "
        ;

        $result = $this->db->query($sql)->row();
        echo '<pre>';
        print_r($sql);
        exit();
        return $result;
    }

    public function add_to_wish($data) {

        $this->db->insert('tbl_wish_list_management', $data);
    }

    /*
     * Save Video Management Information 
     * @Author          : Suddam Hossain
     * @function Name   : select_virtual_class_feature
     * @paremeter       : none
     * @return          : data
     */

    public function select_virtual_class_number() {
        $sql = "SELECT  DISTINCT virtual_classroom_number "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number != '' "
                . "     AND fp.feature_price_status = 1 "
                . "     AND fp.feature_price_talhatraining = 2";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            :   check_user_able_to_take_feature()
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-20 06:30 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   check_user_able_to_take_feature
     *
     * @parameter           :   NO but POST
     * @Return              :   NO but echo as responce text
     * @Redirect            :   no
     * 
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function check_user_able_to_take_feature() {
        $person_id = $this->session->userdata('user_id');
        $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
        if ($person_id) {
            if ($data['person_info']->organization_id != '' && $data['person_info']->resource_person_type == 3) {
                $data['organization_info'] = $this->profile_model->select_organization_info_by_id($data['person_info']->organization_id);
                if ($data['organization_info']->person_id == $data['person_info']->person_id) {
                    $token = 'allow';
                } else {
                    $token = 'org-teacher';
                }
            } else if ($data['person_info']->resource_person_type == 1) {
                $token = 'tt-teacher';
            } else if ($data['person_info']->resource_person_type == 2) {
                $token = 'allow';
            } else {
                $token = 'learner';
            }
        } else {
            $token = 'non-register';
        }
        return $token;
    }

    /**
     * @Function            :   set_message_for_feature_privilege_and_redirect($data)
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-21 12:30 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   set_message_for_feature_privilege_and_redirect
     *
     * @parameter           :   NO but $data including person_info and token of three user ('learner', 'org-teacher', 'tt-teacher')
     * @Return              :   redirect url
     * @Redirect            :   no
     * 
     * @External call       :   
     * @Internal call       :   
     *
     * */
    public function set_message_for_feature_privilege_and_redirect($data) {
        $message = array(
            "learner" => "You are not able to take any feature please change user type from your profile",
            "org-teacher" => "You are not able to take any feature please contact with your organization",
            "tt-teacher" => "You are not able to take any feature please contact with TalhaTraining"
        );
        $sdata['feature_not_allow'] = $message[$data['token']];
        $this->session->set_userdata($sdata);
        return $data['person_info']->url . '/my-billing';
    }

    public function select_virtual_class_per_day_info($classroom_number) {
        $sql = "SELECT  DISTINCT virtual_classroom_per_day "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number = '$classroom_number' "
                . "     AND fp.feature_price_status = 1 "
                . "     AND fp.feature_price_talhatraining = 2 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_virtual_cls_attendees_info($classroom_number, $class_per_day) {
        $sql = "SELECT  DISTINCT virtual_classroom_attendees_number "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number = '$classroom_number' "
                . "     AND fp.virtual_classroom_per_day = '$class_per_day' "
                . "     AND fp.feature_price_status = 1 "
                . "     AND fp.feature_price_talhatraining = 2 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_virtual_cls_type_info($v_classroom_number, $class_per_day, $v_attendees_number) {
        $sql = "SELECT DISTINCT fp.virtual_classroom_type "
                . " FROM tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number = '$v_classroom_number'"
                . "     AND fp.virtual_classroom_per_day = '$class_per_day' "
                . "     AND fp.virtual_classroom_attendees_number = '$v_attendees_number'"
                . "     AND fp.feature_price_status = 1 "
                . "     AND fp.feature_price_talhatraining = 2 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_virtual_classroom_storage() {

        $this->db->select('feature_price_storage');
        $this->db->distinct();
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->result();
        return $result;
    }

    public function select_virtual_classroom_price() {

        $this->db->select('virtual_classroom_price');
        $this->db->distinct();
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->result();
        return $result;
    }

    public function select_virtual_classroom_feature_info_by_id($explore_expert_resume_feature_id) {
        $this->db->select('*');
        $this->db->distinct();
        $this->db->where('feature_price_id', $explore_expert_resume_feature_id);
        $this->db->where('feature_price_status', 1);
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->row();
        return $result;
    }

    public function select_online_exam_feature_info_by_id($online_exam_feature_id) {
        $this->db->select('*');
        $this->db->distinct();
        $this->db->where('feature_price_id', $online_exam_feature_id);
        $this->db->where('feature_price_status', 1);
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->row();
        return $result;
    }

    public function select_explore_expert_resume_feature_info_by_id($explore_expert_resume_feature_id) {
        $this->db->select('*');
        $this->db->distinct();
        $this->db->where('feature_price_id', $explore_expert_resume_feature_id);
        $this->db->where('feature_price_status', 1);
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->row();
        return $result;
    }

    public function select_virtual_cls_info($v_classroom_number, $v_classroom_per_day, $v_attendees_number, $v_class_type) {
        $sql = "SELECT * "
                . " FROM "
                . "         tbl_feature_price as fp "
                . " WHERE "
                . "         fp.feature_price_status  = '1' "
                . "     AND fp.feature_price_talhatraining = '2'"
                . "     AND fp.virtual_classroom_number = '$v_classroom_number'"
                . "     AND fp.virtual_classroom_per_day = '$v_classroom_per_day'"
                . "     AND fp.virtual_classroom_attendees_number = '$v_attendees_number'"
                . "     AND fp.virtual_classroom_type = '$v_class_type'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_virtual_cls_str_info($v_classroom_number, $v_attendees_number, $v_class_type) {

        $this->db->select('*');
        $this->db->from('tbl_feature_price');
        $this->db->where('virtual_classroom_number', $v_classroom_number);
        $this->db->where('virtual_classroom_attendees_number', $v_attendees_number);
        $this->db->where('virtual_classroom_type', $v_class_type);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_online_exam_price_info($given_text) {

        $this->db->select('*');
        $this->db->from('tbl_feature_price');
        $this->db->where('online_exam_feature_number', $given_text);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_expert_resumePrice_info($given_text) {

        $this->db->select('*');
        $this->db->from('tbl_feature_price');
        $this->db->where('explore_expert_resume_per_day', $given_text);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_online_exam_number() {
        $sql = "SELECT * FROM tbl_feature_price as fp WHERE fp.online_exam_feature_number != '' AND fp.feature_price_status = 1";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /*
     * 
     * @Author          : Suddam Hossain
     * @function Name   : select_virtual_class_feature
     * @paremeter       : none
     * @return          : data
     * @Date            : 23-06-2015
     */

    public function select_explore_expert_resume_number() {
        $sql = "SELECT * FROM tbl_feature_price as fp WHERE fp.explore_expert_resume_per_day != '' AND fp.feature_price_status = 1";
        $result = $this->db->query($sql)->result();
        return $result;
    }


    public function delete_draft_post($post_id) {
        $this->db->where('post_id', $post_id);
        $this->db->delete('tbl_post');
    }

    /**
     * Database Save Report Bug info
     * @author Abdullah Al Mamun
     * date --- 12/03/2016 (dd/mm/yyyy  )
     */
    public function save_support_report_bug_info($data) {
        $this->db->insert('tbl_support', $data);
        $last_id = $this->db->insert_id();
        return $last_id;
    }


    /*
     * Select Report Bug details info
     * @author Abdullah Al Mamun
     * date --- 14/03/2016 (dd/mm/yyyy  )
     * Modify date --- 14/03/2016 (dd/mm/yyyy  )
     */

    public function select_bug_report_details_info($support_id) {
        $query = "SELECT p.person_first_name,p.person_last_name,p.person_image,s.* FROM tbl_support as s,tbl_person as p WHERE s.person_id=p.person_id AND support_id='$support_id' ";
        $query_result = $this->db->query($query);
        $result = $query_result->row();
        return $result;
    }
    
    public function select_bug_reply_info($support_id)
    {
    $sql="SELECT * FROM  tbl_support_reply WHERE  support_id ='$support_id'  ";
    $result=$this->db->query($sql)->result();
    return $result;
    }

    /*
     * select_ajax_report_bug_check
     * @author Abdullah Al Mamun
     * date --- 24/03/2016 (dd/mm/yyyy  )
     * Paramiter --- Yes 
     */

    public function select_ajax_report_bug_check($bug_title) {
        $sql = "SELECT * FROM tbl_report_bug WHERE bug_title='$bug_title' ";
        return $this->db->query($sql)->result();
    }

    public function save_reply_bug_attachment_info($bdata) {
        $this->db->insert('tbl_support_attachment', $bdata);
    }

    /**
     * @Function            : all-group-view
     * @Used IN             : welcome controllere
     * @Description         : for all group
     * @Developed By        : afrin jahan noumin
     * @Start DateTime      : 27-03-2016 4:54 AM   
     * @Status              : available      
     * */
    public function count_select_all_group() {

        $sql = " SELECT * FROM  tbl_group as g , tbl_url as u "
                . " WHERE group_status=1 AND g.url_id=u.url_id ";
        $result = $this->db->query($sql)->result();
        return $result;
    }
    public function category_select_all_group($number) {

        $sql = " SELECT * FROM  tbl_group as g , tbl_url as u "
                . " WHERE group_status=1 AND g.url_id=u.url_id"
                . " LIMIT  $number ,10";
        $result = $this->db->query($sql)->result();
        return $result;
    }
     public function count_category_select_all_group() {

        $sql = " SELECT * FROM  tbl_group as g , tbl_url as u "
                . " WHERE group_status=1 AND g.url_id=u.url_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }
     public function select_all_group($number) {

        $sql = " SELECT * FROM  tbl_group as g , tbl_url as u "
                . " WHERE group_status=1 AND g.url_id=u.url_id ";
        if($number){
            $sql.= " LIMIT $number ,10 ";
        }
        else if($number==NULL){
             $sql.= " LIMIT 10 ";
            
        }
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_group_creator_info($group_creator) {

        $sql = " SELECT * FROM  tbl_person as p , tbl_url as u "
                . " WHERE p.person_id = '$group_creator' AND p.url_id= u.url_id ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_all_group_member($group_id) {
        $sql = "SELECT * FROM  tbl_group_member WHERE  group_id='$group_id' AND group_member_status=1";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_membership_info($group_id, $user_id) {
        $sql = "SELECT * FROM tbl_group_member WHERE group_id='$group_id' AND person_id='$user_id' AND  	(group_member_status=1 OR  	group_member_status=4 OR	group_member_status=3 OR  	group_member_status=5)";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function save_group_member_info($group_id, $user_id) {
        $data = array();
        $data['person_id'] = $user_id;
        $data['group_id'] = $group_id;
        $data['group_join_date_time'] = date('h-i-s-a-m-d-Y', (time()));
        $data['group_member_status'] = 3;
        $this->db->insert('tbl_group_member', $data);
    }

    public function check_group_status($group_id) {
        $sql = "SELECT * FROM   tbl_group WHERE  group_id = '$group_id' AND group_status=1";
        $result = $this->db->query($sql)->row();
        return $result;
    }
   public function count_select_all_group_popular() {

      $sql = "SELECT  DISTINCT gt.group_type_id ,gt.*
                    FROM tbl_group AS g,
                    tbl_group_type AS gt
                    WHERE (gt.group_type_id = g.group_type_id
                    AND (gt.group_type_status=1 OR gt.group_type_status=4))
                    
                    ORDER BY (SELECT count(*) AS total 
                    FROM tbl_group AS g
                    WHERE g.group_type_id = gt.group_type_id
                    AND g.group_status=1) ";

            $result = $this->db->query($sql)->result();

            return $result;

    }
    public function select_all_group_popular($number) {
            $sql = "SELECT  DISTINCT gt.group_type_id ,gt.*
                    FROM tbl_group AS g,
                    tbl_group_type AS gt
                    WHERE (gt.group_type_id = g.group_type_id
                    AND (gt.group_type_status=1 OR gt.group_type_status=4))
                    
                    ORDER BY (SELECT count(*) AS total 
                    FROM tbl_group AS g
                    WHERE g.group_type_id = gt.group_type_id
                    AND g.group_status=1) DESC
                    LIMIT $number ";

            $result = $this->db->query($sql)->result();

            return $result;

    }

    public function select_all_group_latest($number) {
            $sql = "SELECT * FROM   tbl_group_type WHERE  "
                    . " (group_type_status=1 OR group_type_status=4) "
                    . " ORDER BY group_type_id  DESC"
                    . "  LIMIT $number  ";
            $result = $this->db->query($sql)->result();
            return $result;
    }
    
    public function select_all_group_type() {

            $sql = "SELECT * FROM   tbl_group_type WHERE  "
                    . " (group_type_status=1 OR group_type_status=4) ";
            $result = $this->db->query($sql)->result();
            return $result;
       
    }    

    public function select_type_wise_group($group_type_id, $group_type_id_array,$number) {
        if (count($group_type_id_array) > 1) {
            $sql = "SELECT * FROM   tbl_group as g, tbl_url as u  WHERE g.group_type_id IN ($group_type_id) "
                    . " AND  g.group_status=1 AND g.url_id= u.url_id"
                    . " LIMIT $number , 10";
            $result = $this->db->query($sql)->result();
            return $result;
        } else if (count($group_type_id_array) == 1) {
            $sql = "SELECT * FROM   tbl_group as g, tbl_url as u  "
                    . " WHERE g.group_type_id = $group_type_id "
                    . " AND  g.group_status=1 AND g.url_id= u.url_id"
                    . " LIMIT $number , 10";
            $result = $this->db->query($sql)->result();
            return $result;
        }
    }
 public function count_select_type_wise_group($group_type_id, $group_type_id_array) {
        if (count($group_type_id_array) > 1) {
            $sql = "SELECT * FROM   tbl_group as g, tbl_url as u  WHERE g.group_type_id IN ($group_type_id) "
                    . " AND  g.group_status=1 AND g.url_id= u.url_id";
                  
            $result = $this->db->query($sql)->result();
            return $result;
        } else if (count($group_type_id_array) == 1) {
            $sql = "SELECT * FROM   tbl_group as g, tbl_url as u  "
                    . " WHERE g.group_type_id = $group_type_id "
                    . " AND  g.group_status=1 AND g.url_id= u.url_id";
            $result = $this->db->query($sql)->result();
            return $result;
        }
    }
    //end group view by Afrin jahan Noumin
}
