<?php

defined('BASEPATH') OR exit('No direct script access allowed');

//   @=> all function of this model randomly used in different controller and model

class Utility_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->library('image_lib');
    }

    /**
     * @Function            : save_information_in_database 
     * @Description         : Save Information into Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-04-2016 10:31 AM
     * @Parameter           : $table_name[STRING], $data[ARRAY]
     * @Return              : $id[INTEGER]    
     * @Status              : available      
     * */
    function save_information_in_database($table_name, $data) {
        $this->db->insert($table_name, $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : update_information_in_database 
     * @Description         : Update Information in to Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-04-2016 10:31 AM
     * @Parameter           : table_name[STRING], table_id[INTEGER], get_id[INTEGER], data[ARRAY]
     * @Return              : NULL    
     * @Status              : Available     
     * */
    function update_information_in_database($table_name, $table_id, $get_id, $data) {
        $this->db->where($table_id, $get_id);
        $this->db->update($table_name, $data);
    }

    /**
     * @Function            : delete_information_in_database 
     * @Description         : Delete Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-04-2016 10:31 AM
     * @Parameter           : table_name[STRING], table_id[INTEGER], get_id[INTEGER]
     * @Return              : NULL 
     * @Status              : available      
     * */
    function delete_information_in_database($table_name, $table_id, $get_id) {
        $this->db->where($table_id, $get_id);
        $this->db->delete($table_name);
    }
    
    /**
     * @Function            : delete_registered_course_information_in_database 
     * @Description         : Delete registered course student Information from Database
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 19-04-2017 11:45 AM
     * @Parameter           : $roll_number
     * @Return              : NULL 
     * @Status              : available      
     * */
    function delete_registered_course_information_in_database($roll_number){
//        $tables = array('tbl_payment', 'tbl_invoice', 'tbl_random');

//        $this->db->join('tbl_student' , 'tbl_payment.person_id= tbl_student.person_id');
//        $this->db->join('tbl_invoice', 'tbl_payment.payment_id = tbl_invoice.payment_id');
//        $this->db->join('tbl_random', 'tbl_invoice.invoice_id = tbl_random.random_type_id');
//        $this->db->where('tbl_student.person_id= tbl_payment.person_id');
//        $this->db->where('tbl_student.student_type_id = tbl_payment.payment_type_id');
//        $this->db->join('tbl_student' , 'tbl_payment.person_id= tbl_student.person_id');
//        $this->db->where('tbl_payment.payment_status = 3');
//        $this->db->where('tbl_student.student_roll_number', $roll_number);
//        
//        $this->db->delete('tbl_payment');
        
        
        $sql = "DELETE p, i, r FROM tbl_payment p JOIN tbl_student s JOIN tbl_invoice i JOIN tbl_random r 
                WHERE p.person_id= s.person_id AND 
                    p.payment_type_id = s.student_type_id AND 
                    p.payment_status = '3' AND p.payment_id = i.payment_id
                    AND i.invoice_id = r.random_type_id
                    AND s.student_roll_number = '$roll_number'";
    
        $this->db->query($sql);
    }

    /**
     * @Function            : delete_multiple_field_in_table 
     * @Description         : delete_multiple_field_in_table
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 03:10 PM
     * @Parameter           : table_name[STRING], table_id[INTEGER], $topic_id[STRING]
     * @Return              : NULL 
     * @Status              : available      
     * */
    function delete_multiple_field_in_table($table_name, $table_id, $deleted_id) {
        $sql = "DELETE FROM $table_name WHERE $table_id IN ($deleted_id)";
        $this->db->query($sql);
    }

    /**
     * @Function            : get_single_table_information 
     * @Description         : get single table information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-08-2016 10:35 PM
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name], 
     *                        $table_id=>[table id]
     * @Return              : NULL 
     * @Status              : available      
     * */
    function get_single_table_information($field, $table_name, $table_id, $get_id) {
        return $this->db->select($field)->from($table_name)->where($table_id, $get_id)->get()->row();
    }

    /**
     * @Function            : get_table_information 
     * @Description         : get table information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-10-2016 12:23 PM
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name]
     * @Return              : $table_info 
     * @Status              : available      
     * */
    function get_table_information($field, $table_name, $condition) {
        return $this->db->select($field)->from($table_name)->where($condition)->get()->row();
    }

    /**
     * @Description         : get all work file for manage work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-11-2016 11:43 AM      
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name],$condition[]
     * */
    function total_row($field, $table_name, $condition) {
        return $this->db->select($field)->from($table_name)->where($condition)->count_all_results();
    }

    /**
     * @Function            : get_all_table_data 
     * @Description         : get all table information 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-11-2016 12:07 PM
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name]
     * @Return              : $table_info 
     * @Status              : available      
     * */
    function get_all_table_data($field, $table_name, $condition) {
        return $this->db->select($field)->from($table_name)->where($condition)->get()->result();
    }

    /**
     * @Function            : removem_diretcory 
     * @Description         : Delete directory with all child
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-04-2016 10:31 AM      
     * @Parameter           : $dir [full path]
     * @Return              : NULL     
     * @Status              : available
     * */
    public function remove_directory($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir") {
                        $this->remove_directory($dir . "/" . $object);
                    } else {
                        unlink($dir . "/" . $object);
                    }
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }

    /**
     * @Function            : remove_directory_with_root 
     * @Description         : Delete directory with all child without parent
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 16-07-2016 03:36 PM  
     * @Parameter           : $dir [full path]
     * @Return              : NULL     
     * @Status              : available
     * */
    public function remove_directory_without_root($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir") {
                        $this->remove_directory($dir . "/" . $object);
                    } else {
                        unlink($dir . "/" . $object);
                    }
                }
            }
            reset($objects);
        }
    }

    /*
     * @Function            : list_folder_files 
     * @Description         : get all file from folder and sub folder
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-07-2016 04:37 PM 
     * @Parameter           : $dir[STRING], $sub_folder[STRING]
     * @Return              : $file_list[ARRAY]      
     * @Status              : available      
     */

    private $file_list = Array();

    function list_folder_files($dir, $sub_folder = NUll) {
        $scan_files = scandir($dir);

        foreach ($scan_files as $file) {
            if ($file != '.' && $file != '..') {
                if (is_file("$dir/$file")) {
                    if ($sub_folder != '') {
                        $this->file_list[] = "$sub_folder/$file";
                    } else {
                        $this->file_list[] = $file;
                    }
                }

                if (is_dir("$dir/$file")) {
                    if ($sub_folder != '') {
                        $this->list_folder_files("$dir/$file", "$sub_folder/$file");
                    } else {
                        $this->list_folder_files("$dir/$file", $file);
                    }
                }
            }
        }
        return $this->file_list;
    }

    /*
     * @Function            : folder_list 
     * @Description         : get all folder from folder and sub folder
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-07-2016 03:32 PM 
     * @Parameter           : $dir[STRING], $sub_folder[STRING]
     * @Return              : $dir_list[ARRAY]      
     * @Status              : available      
     */

    private $dir_list = Array();

    function folder_list($directory, $sub_folder = NULL) {
        $scan_files = array_diff(scandir($directory), array('.', '..'));

        foreach ($scan_files as $file) {
            if (is_dir($directory . '/' . $file)) {
                if ($sub_folder != '') {
                    $this->dir_list[] = $sub_folder . '/' . $file;
                } else {
                    $this->dir_list[] = $file;
                }

                if ($sub_folder != '') {
                    $this->folder_list($directory . '/' . $file, "$sub_folder/$file");
                } else {
                    $this->folder_list($directory . '/' . $file, $file);
                }
            }
        }
        return $this->dir_list;
    }

    /*
     * @Function            : is_dir_empty 
     * @Description         : check if any directory is empty
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-07-2016 03:32 PM 
     * @Parameter           : $dir[STRING]
     * @Return              : TURE/NULL      
     * @Status              : available      
     */

    function is_dir_empty($dir) {
        if (!is_readable($dir)) {
            return NULL;
        } else {
            return (count(scandir($dir)) == 2);
        }
    }

    /**
     * @Function            : get_profile_url 
     * @Description         : get profile URl using person_id
     * @Developed By        : MD JAherul Islam
     * @Start DateTime      : 12-04-2016 09:55 AM   
     * @Status              : available      
     * */
    public function get_profile_url($person_id) {
        $sql = "SELECT url
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->url;
    }

    /**
     * @Function            : get_content_library_info_by_content_library_id 
     * @Description         : get content library information by content library ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 17-07-2016 10:00 AM 
     * @Parameter           : $content_library_id[INTEGER]
     * @Return              : $data[ARRAY]        
     * @Status              : available      
     * */
    function get_content_library_info_by_content_library_id($content_library_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_content_library AS pcl 
                WHERE pcl.content_library_id = '$content_library_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : register_student 
     * @Description         : Register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-04-2016 01:46 AM   
     * @Status              : available      
     * */
    function register_student($course_id, $student_id, $type) {
        $data['course_id'] = $course_id;
        $data['person_id'] = $student_id;
        $data['student_type'] = $type;
        $this->db->insert('tbl_student', $data);
    }

    /**
     * @Function            : getBrowser 
     * @Description         : get browser
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-04-2016 04:42 PM   
     * @Status              : available      
     * */
    function get_browser_name() {
        $this->load->library('user_agent');

        if ($this->agent->is_browser()) {
            $agent = $this->agent->browser() . ' ' . $this->agent->version();
        } elseif ($this->agent->is_robot()) {
            $agent = $this->agent->robot();
        } elseif ($this->agent->is_mobile()) {
            $agent = $this->agent->mobile();
        } else {
            $agent = 'Unidentified User Agent';
        }
        return $agent;
    }

    /**
     * @Function            : get_date_different_with_current_date 
     * @Description         : get date different with current date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-04-2016 05:09 PM   
     * @Status              : available      
     * */
    public function get_date_different_with_current_date($current_date) {
        $sql = "SELECT *, DATEDIFF('$current_date', post_date_time) AS DiffDate
                FROM
                    tbl_post
                WHERE
                    post_status = '5'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : time_format_for_read_write 
     * @Description         : time format for read write status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-04-2016 10:10 AM   
     * @Status              : available      
     * */
    function time_format_for_read_write($user_time) {
        $current_date = date('Y-m-d H:i:s', time());
        $formated_current_date = new DateTime($current_date);
        $formated_user_date = new DateTime($user_time);

        $interval = $formated_user_date->diff($formated_current_date);

        if ($interval->format("%y")) {
            echo ' ' . $interval->format("%y year");
        }
        if ($interval->format("%m")) {
            echo ' ' . $interval->format("%m month");
        }
        if ($interval->format("%d")) {
            echo ' ' . $interval->format("%d days");
        }
        if ($interval->format("%h")) {
            echo ' ' . $interval->format("%h hours");
        }
        if ($interval->format("%i")) {
            echo ' ' . $interval->format("%i minutes");
        }
        echo ' ' . $interval->format("%s seconds");
        echo ' Ago ';
    }

    /**
     * @Function            : date_time_format_with_offset 
     * @Description         : date time format with offset
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-05-2016 10:23 AM   
     * @Status              : available      
     * */
    function date_time_format_with_offset($date_time) {
        $milisecond_date = strtotime($date_time) - $this->session->userdata('time_offset');
        return date('Y-m-d H:i:s', $milisecond_date);
    }

    /**
     * @Function            : encode_id 
     * @Description         : encode id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-04-2016 03:38 PM   
     * @Status              : available      
     * */
    function encode_id($id, $prv_string, $replace_string) {
        $id1 = $this->encrypt->encode($id);
        return str_replace($prv_string, $replace_string, $id1);
    }

    /**
     * @Function            : decode_id 
     * @Description         : decode id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-04-2016 03:38 PM   
     * @Status              : available      
     * */
    function decode_id($id, $prv_string, $replace_string) {
        $id1 = str_replace($prv_string, $replace_string, $id);
        return $this->encrypt->decode($id1);
    }

    /**
     * @Function            : replace_first 
     * @Description         : replace first match if occur multiple times
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 05:03 PM 
     * @Parameter           : $find[STRING], $replace[STRING], $subject[STRING]
     * @Return              : $subject[STRING]           
     * @Status              : available      
     * */
    function replace_first($find, $replace, $subject) {
        return implode($replace, explode($find, $subject, 2));
    }

    /**
     * @Function            : pagination 
     * @Description         : pagination
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-08-2016 05:34 PM 
     * @Parameter           : $find[STRING], $replace[STRING], $subject[STRING]
     * @Return              : $paginzation_data[ARRAY]           
     * @Status              : available      
     * */
    function pagination($page_url, $total_rows, $per_page) {
        $config = Array();
        $config['base_url'] = base_url("$page_url");
        $config['total_rows'] = $total_rows;
        $config['per_page'] = $per_page;
        $config['num_links'] = 9;
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open'] = '<nav class="course-pagination"><ul class="pagination">';
        $config['full_tag_close'] = '</ul></nav>';
        $config['first_link'] = '&laquo;';
        $config['first_tag_open'] = '<li aria-hidden="true" title="First Page">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = '&raquo;';
        $config['last_tag_open'] = '<li aria-hidden="true" title="Last Page">';
        $config['last_tag_close'] = '</li>';
        $config['next_link'] = '&rarr;';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&larr;';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active" style="background-color: #80c12c !important;"><a href="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
    }

    /**
     * @Function            : remove_session_data 
     * @Used IN             : @function-'manage_course'      super_admin_course[@controller]
     * @Description         : get all parameter of function and remove session data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 12:53 PM 
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function remove_session_data() {
        $num_arg = func_get_args();
        foreach ($num_arg as $value) {
            $this->session->unset_userdata($value);
        }
    }

    /**
     * @Function            : get_integer_value_from_array 
     * @Description         : get integer value from ARRAY
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 14-08-2016 01:10 PM 
     * @Parameter           : $arg[Array]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function get_integer_value_from_array($arg) {
        $arr = Array();
        foreach ($arg AS $val) {
            $temp = (int) $val;
            if ($temp != 0) {
                $arr[] = $temp;
            }
        }
        return $arr;
    }

    /**
     * @Description         : set Single table information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 11:48 AM 
     * */
    private $field_name;
    private $tbl_name;
    private $condition;

    function set_single_row_info($field_name, $tbl_name, $condition) {
        $this->field_name = $field_name;
        $this->tbl_name = $tbl_name;
        $this->condition = $condition;
        return $this;
    }

    /**
     * @Description         : get Single table information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 11:48 AM 
     * */
    function get_single_row_info() {
        return $this->db->select($this->field_name)
                        ->from($this->tbl_name)
                        ->where($this->condition)->get()->row();
    }

    /**
     * @Description         : get all table data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 25-11-2016 04:34 PM 
     * */
    function get_all_data() {
        return $this->db->select($this->field_name)
                        ->from($this->tbl_name)
                        ->where($this->condition)->get()->result();
    }

    /**
     * @Description         : set primary key
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 02-12-2016 12:05 PM 
     * */
    private $table_id;

    function set_table_id($table_id) {
        $this->table_id = $table_id;
        return $this;
    }

    /**
     * @Description         : set condition
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 02-12-2016 12:05 PM 
     * */
    private $id;

    function set_id($id) {
        $this->id = $id;
        return $this;
    }

    /**
     * @Description         : set table 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 02-12-2016 12:05 PM 
     * */
    function set_table($tbl_name) {
        $this->tbl_name = $tbl_name;
        return $this;
    }

    /**
     * @Description         : delete single row from tbl
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 02-12-2016 12:03 PM 
     * */
    function delete() {
        $this->db->where($this->table_id, $this->id);
        $this->db->delete($this->tbl_name);
    }

    public function __destruct() {
        if (!empty($this->field_name)) {
            unset($this->field_name);
        }
        if (!empty($this->tbl_name)) {
            unset($this->tbl_name);
        }
        if (!empty($this->condition)) {
            unset($this->condition);
        }
    }

    //---------------------@START------------temporary function for Quiz----------------------------------
    /**
     * @Function            : changed_special_character_to_text 
     * @Used In             : function[save_quiz_all_tinymce_information] model[quiz_model]
     * @Description         : 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : unknown 
     * @Parameter           : $id[INTEGER], $file_path[STRING], $type[INTEGER]
     * @Return              : $id[INTEGER]           
     * @Status              : available      
     * */
    function changed_special_character_to_text($message) {
        $special_character = $this->special_characters();
        $special_character_text = $this->text_for_special_character();
        $combine_array = array_combine($special_character, $special_character_text);
        $view_message = $message;
        $i = 0;
        while (count($combine_array) > $i) {
            $view_message = str_replace($special_character[$i], $special_character_text[$i], $view_message);
            $i++;
        }
        return $view_message;
    }

    /**
     * @Function            : changed_text_to_special_character 
     * @Description         : change text to special character in tinymce
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 05:32 PM
     * @Parameter           : $message[STRING]
     * @Return              : $message[STRING]    
     * @Status              : Available       
     * */
    function changed_text_to_special_character($message) {
        $special_character = $this->special_characters();
        $special_character_text = $this->text_for_special_character();
        $combine_array = array_combine($special_character, $special_character_text);
        $view_message = $message;
        $i = 0;
        while (count($combine_array) > $i) {
            $view_message = str_replace($special_character_text[$i], $special_character[$i], $view_message);
            $i++;
        }
        return $view_message;
    }

    function special_characters() {
        $special_characters = Array("!", "@", "$", "%", "^", "&", "*", "_", "+", "-", "/", "`", "'", "|", ":", ";", "<", ">", "?", "~", "=");
        return $special_characters;
    }

    function text_for_special_character() {
        $text_for_special_character = array(
            "(exclamation)", "(at)", "(dolar)", "(percent)", "(accent)", "(ampersand)", "(asterisk)", "(lowline)", "(plussign)", "(minussign)", "(solidus)", "(graveaccent)", "(apostrophe)", "(verticalbar)", "(colon)", "(semicolon)", "(lessthansign)", "(greaterthansign)", "(questionmark)", "(tilde)", "(equalsign)");
        return $text_for_special_character;
    }

    /**
     * @Function            : get_tinymce_description 
     * @Description         : get tinymce description
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 09:54 AM 
     * @Parameter           : $string[STRING]
     * @Return              : NULL           
     * @Status              : available      
     * */
    function get_tinymce_description($id, $upload_dir, $description, $type) {
        $href_match = Array();
        $src_match = Array();
        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);

        if ($src_match[1]) {
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir);
            }

            for ($i = 0; $i < count($src_match[1]); $i++) {
                $main_full_path = urldecode($src_match[1][$i]);
                if (preg_match('/source/', $main_full_path)) {
                    $main_full_path_array = explode('?', $main_full_path);
                    $cut_string_array = explode('source', $main_full_path_array[0]);
                    $main_file_path = 'source' . $cut_string_array[1];
                    if (is_file($main_file_path)) {
                        $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                    }
                }
            }
        }

        if ($href_match[1]) {
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir);
            }

            for ($i = 0; $i < count($href_match[1]); $i++) {
                $main_full_path = urldecode($href_match[1][$i]);
                if (preg_match('/source/', $main_full_path)) {
                    $cut_string_array = explode('source', $main_full_path);
                    $main_file_path = 'source' . $cut_string_array[1];
                    if (is_file($main_file_path)) {
                        $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                    }
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : upload_tinymc_file 
     * @Description         : upload tinymce file
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 11:07 AM 
     * @Parameter           : $description[STRING], $main_full_path[STRING], $main_file_path[STRING], $upload_dir[STRING]
     * @Return              : $description[STRING]           
     * @Status              : available      
     * */
    function upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, $count) {
        $path_array = explode('/', $main_file_path);
        $file_name = $path_array[count($path_array) - 1];
        $file_path = '';

        if (count($path_array) > $count) {
            for ($i = 1; $i <= (count($path_array) - $count); $i++) {
                $upload_dir.='/' . $path_array[$i + ($count - 2)];
                $file_path.='/' . $path_array[$i + ($count - 2)];
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0777, true);
                }
            }

            $saved_file_path = substr($file_path, 1) . '/' . $file_name;
            $file_saved_id = $this->save_content_library_file($saved_file_path, $type, $id);
            $description = $this->replace_first($main_full_path, $file_saved_id, urldecode($description));
        } else {
            $target_file = $upload_dir . '/' . $file_name;
            copy($main_file_path, $target_file);

            $file_saved_id = $this->save_content_library_file($file_name, $type, $id);
            $description = $this->replace_first($main_full_path, $file_saved_id, urldecode($description));
        }
        return $description;
    }

    /**
     * @Function            : save_tinymce_file 
     * @Description         : save tinymce file
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 12:30 PM 
     * @Parameter           : $id[INTEGER], $file_path[STRING], $type[INTEGER]
     * @Return              : $id[INTEGER]           
     * @Status              : available      
     * */
    function save_tinymce_file($id, $file_path, $type) {
        $data = Array();
        $data['person_id'] = $id;
        $data['person_content_library_location'] = $file_path;
        $data['person_content_library_type'] = $type;
        return $this->save_information_in_database('tbl_person_content_library', $data);
    }

    /**
     * @Function            : view_tinyMce_information 
     * @Description         : view tinyMce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 06:46 PM 
     * @Parameter           : $id[INTEGER], $file_path[STRING], $type[INTEGER]
     * @Return              : $id[INTEGER]           
     * @Status              : available      
     * */
    function view_tinyMce_information($creator_id, $course_url, $description) {
        $href_match = Array();
        $src_match = Array();

        $update_description = $this->changed_text_to_special_character($description);
        preg_match_all('@href="([^"]+)"@', $update_description, $href_match);
        preg_match_all('@src="([^"]+)"@', $update_description, $src_match);

        if ($href_match[1]) {
            for ($i = 0; $i < count($href_match[1]); $i++) {
                $temp_description = str_replace($href_match[0][$i], '(*rfile#)', $update_description);
                $content_library_info = $this->get_content_library_info_by_content_library_id($href_match[1][$i]);
                $person_url = $this->person_model->get_profile_url($creator_id);
                $file_path = base_url() . 'content-library/' . $person_url . '/my-work-file/' . $course_url . '/' . $content_library_info->person_content_library_location;
                $full_file_path = str_replace($href_match[1][$i], $file_path, $href_match[0][$i]);
                $update_description = str_replace('(*rfile#)', $full_file_path, $temp_description);
            }
        }
        if ($src_match[1]) {
            for ($i = 0; $i < count($src_match[1]); $i++) {
                $temp_description = str_replace($src_match[0][$i], '(*rfile#)', $update_description);
                $content_library_info = $this->get_content_library_info_by_content_library_id($src_match[1][$i]);
                $person_url = $this->person_model->get_profile_url($creator_id);
                $file_path = base_url() . 'content-library/' . $person_url . '/my-work-file/' . $course_url . '/' . $content_library_info->content_library_location;
                $full_file_path = str_replace($src_match[1][$i], $file_path, $src_match[0][$i]);
                $update_description = str_replace('(*rfile#)', $full_file_path, $temp_description);
            }
        }
        return $update_description;
    }

    function update_tinymce_information($id, $person_url, $url, $description, $previous_description) {
        $href_match = Array();
        $src_match = Array();
        $old_content_id_array = $this->get_all_content_library_id($previous_description);
        $old_content_path_array = $this->get_all_content_library_path($person_url, $url, $old_content_id_array);

        $combine_array = array_combine($old_content_id_array, $old_content_path_array);

        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);

        if ($href_match[1]) {
            for ($i = 0; $i < count($href_match[1]); $i++) {
                if (preg_match('/content-library/', $href_match[1][$i])) {
                    $file_path_array = explode('content-library', $href_match[1][$i]);
                    $modify_file_path = 'content-library' . $file_path_array[1];

                    if (in_array($modify_file_path, $old_content_path_array)) {
                        foreach ($combine_array as $key => $value) {
                            if ($modify_file_path == $value) {
                                $description = $this->replace_first($href_match[1][$i], $key, $description);
                            }
                        }
                    }
                }
            }
        }

        if ($src_match[1]) {
            for ($i = 0; $i < count($src_match[1]); $i++) {
                if (preg_match('/content-library/', $src_match[1][$i])) {
                    $file_path_array = explode('content-library', $src_match[1][$i]);
                    $modify_file_path = 'content-library' . $file_path_array[1];
                    if (in_array($modify_file_path, $old_content_path_array)) {
                        foreach ($combine_array as $key => $value) {
                            if ($modify_file_path == $value) {
                                $description = $this->replace_first($src_match[1][$i], $key, $description);
                            }
                        }
                    }
                }
            }
        }

        $upload_dir = 'content-library/' . $person_url . '/my-work-file/' . $url;
        $update_content_id_array = $this->get_all_content_library_id($description);
        $remaining_content_id_array = array_diff($old_content_id_array, $update_content_id_array);

        $type = 4; // for quiz content library
        $find_path = "$upload_dir/"; // find file from source directory
        $update_description = $this->get_update_tinymce_description($id, $upload_dir, $description, $type, $find_path); // if update new file in tinymce
        return $update_description;
    }

    /**
     * @Function            : get_all_content_library_id 
     * @Used IN             : @function-'  '  [@Model]
     * @Description         : get content library ID using Tinymce Description
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:39 AM   
     * @Parameter           : $description[STRING]
     * @Return              : $content_library_id[ARRAY]  
     * @Status              : available      
     * */
    function get_all_content_library_id($description) {
        $old_href_match = Array();
        $old_src_match = Array();
        preg_match_all('@href="([^"]+)"@', $this->changed_text_to_special_character($description), $old_href_match);
        preg_match_all('@src="([^"]+)"@', $this->changed_text_to_special_character($description), $old_src_match);
        return array_merge($old_href_match[1], $old_src_match[1]);
    }

    /**
     * @Function            : get_all_content_library_path 
     * @Used IN             : @function-''  [@Model]
     * @Description         : get content library path array using Tinymce Description
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:37 AM   
     * @Parameter           : $person_url[STRING], $course_url[STRING], $old_content_id_array[ARRAY]
     * @Return              : $content_path_array[ARRAY]  
     * @Status              : available      
     * */
    function get_all_content_library_path($person_url, $course_url, $old_content_id_array) {
        $old_content_path_array = Array();
        for ($i = 0; $i < count($old_content_id_array); $i++) {
            $content_library_info = $this->get_content_library_info_by_content_library_id($old_content_id_array[$i]);
            $old_content_path_array[] = 'content-library/' . $person_url . '/my-work-file/' . $course_url . '/' . $content_library_info->person_content_library_location;
        }
        return $old_content_path_array;
    }

    /**
     * @Function            : get_total_content_library_path 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : get total content library if content_path remaining several times 
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-06-2016 11:26 AM   
     * @Parameter           : $id[INTEGER], $type[INTEGER], $file_path[STRING]
     * @Return              : $total_row[INTEGER]  
     * @Status              : available      
     * */
    function get_total_content_library_path($id, $type, $file_path) {
        $sql = "SELECT count(*) AS total 
                FROM tbl_person_content_library AS pcl
                WHERE 
                    pcl.person_id = '$id' AND pcl.person_content_library_type = '$type'
                AND pcl.person_content_library_location = '$file_path'";
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : remove_content_library_file 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : remove content library file
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:27 AM   
     * @Parameter           : $id[INTEGER], $old_content_id_array[ARRAY], $type[INTEGER], $upload_dir[STRING]
     * @Return              : Null  
     * @Status              : available      
     * */
    function remove_content_library_file($id, $old_content_id_array, $type, $upload_dir) {
        foreach ($old_content_id_array as $value) {
            $content_library_info = $this->get_content_library_info_by_content_library_id($value);
            $total_content_library = $this->get_total_content_library_path($id, $type, $content_library_info->person_content_library_location);
            if ($total_content_library == 1) {
                $remove_file = $upload_dir . '/' . $content_library_info->person_content_library_location;
                if (is_file($remove_file)) {
                    unlink($remove_file);
                }
            }
            $this->delete_information_in_database('tbl_person_content_library', 'person_content_library_id', $value);
        }
    }



    /**
     * @Function            : get_update_tinymce_description 
     * @Used IN             : @function-'update_tinymce_information'  super_admin_course[@controller],
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 12:22 PM 
     * @Parameter           : $id[INTEGER], $upload_dir[STRING], $description[STRING], $type[INTEGE], $find_path[STRING]
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function get_update_tinymce_description($id, $upload_dir, $description, $type, $find_path) {
        $href_match = Array();
        $src_match = Array();
        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);

        if ($src_match[1]) {
            $description = $this->update_tinymce_source_file($id, $src_match[1], $description, $upload_dir, $type, $find_path);
        }

        if ($href_match[1]) {
            $description = $this->update_tinymce_hyperlink_file($id, $href_match[1], $description, $upload_dir, $type, $find_path);
        }
        return $description;
    }

    /**
     * @Function            : update_tinymce_source_file 
     * @Used IN             : @function-'get_update_tinymce_description'  this[@Model]
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 12:22 PM 
     * @Parameter           : $id[INTEGER], $src_match[STRING], $description[STRING], $upload_dir[STRING], $type[STRING],$find_path[STRING]
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function update_tinymce_source_file($id, $src_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($src_match); $i++) {
            $main_full_path = urldecode($src_match[$i]);
            if (preg_match("/content-library/", $main_full_path)) {
                $main_full_path_array = explode('?', $main_full_path);
                $cut_string_array = explode($find_path, $main_full_path_array[0]);
                $main_file_path = $find_path . $cut_string_array[1];
                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : update_tinymce_hyperlink_file 
     * @Used IN             : @function-'get_update_tinymce_description'  this[@Model]
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 30-07-2016 03:54 PM 
     * @Parameter           : $id[INTEGER], $src_match[STRING], $description[STRING], $upload_dir[STRING], $type[STRING],$find_path[STRING]
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function update_tinymce_hyperlink_file($id, $href_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($href_match); $i++) {
            $main_full_path = urldecode($href_match[$i]);
            if (preg_match("/content-library/", $main_full_path)) {
                $cut_string_array = explode($find_path, $main_full_path);
                $main_file_path = $find_path . $cut_string_array[1];
                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                }
            }
        }
        return $description;
    }

    function save_content_library_file($file_path, $type, $type_id) {
        $data = Array();
        $data['person_content_library_location'] = $file_path;
        $data['person_content_library_type'] = $type;
        $data['person_id'] = $type_id;
        return $this->save_information_in_database('tbl_person_content_library', $data);
    }

    function update_all_tinymce_information($id, $upload_dir, $description, $type, $find_path) {
        $href_match = Array(); // all hiperlink file remain in this Array
        $src_match = Array(); // all Source file remain in this Array
        preg_match_all('@href="([^"]+)"@', $description, $href_match); // if matched any "href" file than push "$href_match" Array 
        preg_match_all('@src="([^"]+)"@', $description, $src_match); // if matched any "src" file than push "$src_match" Array

        if ($src_match[1]) { // if found any "src" file
            if (!is_dir($upload_dir)) { // does not remaining content folder for tinymce file
                mkdir($upload_dir, 0777, true); // Create a folder by uploaded url
            }
            // save tinymce source file in content library and upload file in "$upload_dir"
            $description = $this->save_tinymce_source_file($id, $src_match[1], $description, $upload_dir, $type, $find_path);
        }

        if ($href_match[1]) { // if found any "href" file
            if (!is_dir($upload_dir)) {// does content folder for tinymce file
                mkdir($upload_dir, 0777, true); // Create a folder by uploaded url
            }
            // save tinymce hiperlink file in content library and upload file in "$upload_dir"
            $description = $this->save_tinymce_hyperlink_file($id, $href_match[1], $description, $upload_dir, $type, $find_path);
        }
        return $description;
    }

    function save_tinymce_source_file($id, $src_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($src_match); $i++) { // Running loop based of $src file Array
            $main_full_path = urldecode($src_match[$i]); // Remove all "%20" From String"
            if (preg_match("/$find_path/", $main_full_path)) {
// if file path matched into System "$find_path" Such as - source/content-library....
                $main_full_path_array = explode('?', $main_full_path); // if upload any image in then add extra "?" in "src" file
                $cut_string_array = explode($upload_dir, $main_full_path_array[0]); // Explode file path with "$find_path" 
                $main_file_path = $upload_dir . $cut_string_array[1]; // concat $find_path with main src file
                if (is_file($main_file_path)) { // check if in this path content any file
                    // save tinymce file in content library and upload file in "$upload_dir"
                    $description = $this->upload_tinymc_file1($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                }
            }
        }
        return $description;
    }

    function save_tinymce_hyperlink_file($id, $href_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($href_match); $i++) { // Running loop based of $src file Array
            $main_full_path = urldecode($href_match[$i]); // Remove all "%20" From String"
            if (preg_match("/$find_path/", $main_full_path)) { // if file path matched into System "$find_path" Such as - source/content-library....
                $cut_string_array = explode($find_path, $main_full_path); // Explode file path with "$find_path" 
                $main_file_path = $find_path . $cut_string_array[1]; // concat $find_path with main src file
                if (is_file($main_file_path)) { // check if in this path content any file
                    // save tinymce file in content library and upload file in "$upload_dir"
                    $count = 5; // upload file from 'source' Directory
                    $description = $this->upload_tinymc_file1($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, $count);
                }
            }
        }
        return $description;
    }

    function upload_tinymc_file1($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, $count) {
        $path_array = explode('/', $main_file_path); // explode file path if found any slash
        $file_name = $path_array[count($path_array) - 1]; // get file name
        $file_path = '';

        if (count($path_array) > $count) { // if file uploaded in multiple folder
            for ($i = 1; $i <= (count($path_array) - $count); $i++) { // looping based on folder directory
                $upload_dir.='/' . $path_array[$i + ($count - 2)]; // if found several folder then concat with upload dir
                $file_path.='/' . $path_array[$i + ($count - 2)];
                if (!is_dir($upload_dir)) { // if new directory not found create directory
                    mkdir($upload_dir, 0777, true);
                }
            }
            $target_file = "$upload_dir/$file_name"; // uploaded file directory
            $saved_file_path = substr($file_path, 1) . '/' . $file_name; // get fine name with path if file uploaded in several flder
// save upload file path in content_library table and uploaded in to target path
            $description = $this->save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $saved_file_path, $description);
        } else {
            $target_file = $upload_dir . '/' . $file_name; // uploaded file directory
            // save upload file path in content_library table and uploaded in to target path
            $description = $this->save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $file_name, $description);
        }
        return $description;
    }

    function save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $file_name, $description) {
        copy($main_file_path, $target_file); // copy file from 'source' to 'content-library' directory
        // file path saved in database
        $file_saved_id = $this->save_content_library_file($file_name, $type, $id);
        // saved path insert ID replace to uploaded directory
        return $this->replace_first($main_full_path, $file_saved_id, urldecode($description));
    }

//------------------------tania new (22-08-16)-------------------------------

    function upload_tinymc_file_question_option($id, $description, $main_full_path, $main_file_path, $upload_dir, $type) {
        $path_array = explode('/', $main_file_path);
        $file_name = $path_array[count($path_array) - 1];
        $file_path = '';

        if (count($path_array) > 3) {
            for ($i = 1; $i <= (count($path_array) - 3); $i++) {
                $upload_dir.='/' . $path_array[$i + 1];
                $file_path.='/' . $path_array[$i + 1];
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0777, true);
                }
            }
            $target_file = $upload_dir . '/' . $file_name;
            copy($main_file_path, $target_file);

            $saved_file_path = substr($file_path, 1) . '/' . $file_name;
            $file_saved_id = $this->save_tinymce_file_question_option($id, $saved_file_path, $type);
            $description = str_replace($main_full_path, $file_saved_id, urldecode($description));
        } else {
            $target_file = $upload_dir . '/' . $file_name;
            copy($main_file_path, $target_file);

            $file_saved_id = $this->save_tinymce_file_question_option($id, $file_name, $type);
            $description = str_replace($main_full_path, $file_saved_id, urldecode($description));
        }
        return $description;
    }

    function save_tinymce_file_question_option($id, $file_path, $type) {
        $data = Array();
        $data['person_id'] = $id;
        $data['person_content_library_location'] = $file_path;
        $data['person_content_library_type'] = $type;
        return $this->save_information_in_database('tbl_person_content_library', $data);
    }

    function update_tinymce_information_question_option($id, $person_url, $url, $description, $previous_description) {
        $href_match = Array();
        $src_match = Array();
        $old_content_id_array = $this->get_all_content_library_id($previous_description);
        $old_content_path_array = $this->get_all_content_library_path($person_url, $url, $old_content_id_array);

        $combine_array = array_combine($old_content_id_array, $old_content_path_array);

        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);

        if ($href_match[1]) {
            for ($i = 0; $i < count($href_match[1]); $i++) {
                if (preg_match('/content-library/', $href_match[1][$i])) {
                    $file_path_array = explode('content-library', $href_match[1][$i]);
                    $modify_file_path = 'content-library' . $file_path_array[1];

                    if (in_array($modify_file_path, $old_content_path_array)) {
                        foreach ($combine_array as $key => $value) {
                            if ($modify_file_path == $value) {
                                $description = $this->replace_first($href_match[1][$i], $key, $description);
                            }
                        }
                    }
                }
            }
        }

        if ($src_match[1]) {
            for ($i = 0; $i < count($src_match[1]); $i++) {
                if (preg_match('/content-library/', $src_match[1][$i])) {
                    $file_path_array = explode('content-library', $src_match[1][$i]);
                    $modify_file_path = 'content-library' . $file_path_array[1];
                    if (in_array($modify_file_path, $old_content_path_array)) {
                        foreach ($combine_array as $key => $value) {
                            if ($modify_file_path == $value) {
                                $description = $this->replace_first($src_match[1][$i], $key, $description);
                            }
                        }
                    }
                }
            }
        }

        $upload_dir = 'content-library/' . $person_url . '/my-work-file/' . $url;
        $update_content_id_array = $this->get_all_content_library_id($description);

        $type = 4; // for quiz content library
        $find_path = "$upload_dir/"; // find file from source directory
        $update_description = $this->get_update_tinymce_description($id, $upload_dir, $description, $type, $find_path); // if update new file in tinymce
        return $update_description;
    }

    function get_tinymce_description_question_option($id, $upload_dir, $description, $type) {
        $href_match = Array();
        $src_match = Array();
        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);
        if ($src_match[1]) {
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir);
            }

            for ($i = 0; $i < count($src_match[1]); $i++) {
                $main_full_path = urldecode($src_match[1][$i]);
                $main_full_path_array = explode('?', $main_full_path);

                $cut_string_array = explode('source', $main_full_path_array[0]);
                $main_file_path = 'source' . $cut_string_array[1];

                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file_question_option($id, $description, $main_full_path, $main_file_path, $upload_dir, $type);
                }
            }
        }

        if ($href_match[1]) {
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir);
            }

            for ($i = 0; $i < count($href_match[1]); $i++) {
                $main_full_path = urldecode($href_match[1][$i]);
                $cut_string_array = explode('source', $main_full_path);
                $main_file_path = 'source' . $cut_string_array[1];
                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file_question_option($id, $description, $main_full_path, $main_file_path, $upload_dir, $type);
                }
            }
        }
        return $description;
    }

    //---------------------@END------------temporary function for Quiz----------------------------------
}
