<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User_course_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Course Common Query Part----------------------------------
     */

    /**
     * @Function            : select_course_information_by_course_id 
     * @Used IN             : @function-'chnage_course_permission'     super_admin_course[@controller]
     * @Description         : get course information using course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 10:10 AM
     * @Parameter           : $course_id[INTEGER]
     * @Return              : $course_info[ARRAY]    
     * @Status              : available      
     * */
    function get_course_infomation_by_course_id($course_id) {
        $sql = "SELECT * FROM tbl_course AS c WHERE c.course_id = '$course_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_course_infomation_with_url_by_course_id 
     * @Used IN             : @function-'course_list.php'     [@view]
     * @                    : @function-'send_email_for_add_course'     mailer_model[@Model]
     * @Description         : get course information with course url using course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 03:51 PM
     * @Parameter           : $course_id[INTEGER]
     * @Return              : $course_info[ARRAY]    
     * @Status              : available      
     * */
    function get_course_information_with_url_by_course_id($course_id) {
        return $this->db->select('*')->from('tbl_course AS c')->join('tbl_url AS u', 'c.url_id = u.url_id')
                        ->where('c.course_id', $course_id)->get()->row();
    }

    /**
     * @Function            : get_course_information_with_url_by_course_url 
     * @Used IN             : @function-'send_email_for_add_course'     mailer_model[@Model]
     * @Description         : get course information with course url using course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-07-2016 05:46 PM
     * @Parameter           : $course_url[STRING]
     * @Return              : $course_info[ARRAY]    
     * @Status              : available      
     * */
    function get_course_information_with_url_by_course_url($course_url) {
        return $this->db->select('*,c.person_id AS course_creator_id')->from('tbl_course AS c')
                        ->join('tbl_url AS u', 'c.url_id = u.url_id')
                        //->join('tbl_price AS p','p.price_type_id = c.course_id')
                        ->where('u.url', $course_url)->get()->row();
    }

    /**
     * @Function            : get_information_for_add_course 
     * @Used IN             : @function-'add_course'               user_course[@controller]
     * @                    : @function-'upload_course_work_file'  user_course[@controller]
     * @Description         : get information for course authentication 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 05:33 PM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_information_for_course($data) {
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->resource_person_model->select_resource_person_information_by_person_id($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {// for TT Teached
                $data['person_info'] = $this->person_model->get_single_person_information_by_person_id(1);
            }
            if ($data['resource_person_info']->resource_person_type == 3) { // for Orgnization Teacher
                $data['organization_info'] = $this->organization_model->organization_information_by_resource_person_id($data['resource_person_info']->resource_person_id);
                $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($data['organization_info']->person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->resource_person_model->select_resource_person_information_by_person_id($data['person_info']->person_id);
            $data['organization_info'] = $this->organization_model->select_single_organization_info_by_person_id($data['person_info']->person_id);
        }
        return $data;
    }

    /**
     * @Function            : side_menu_info 
     * @Description         : get side menu information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 06-08-2016 11:56 PM
     * @Parameter           : $data, $active_menu, $active_sub_menu
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function side_menu_info($data, $active_menu, $active_sub_menu) {
        $data['active_menu'] = $sdata['active_menu'] = ($active_menu == '') ? $this->session->userdata('active_menu') : $active_menu;
        $data['active_sub_menu'] = $sdata['active_sub_menu'] = ($active_sub_menu == '') ? $this->session->userdata('active_sub_menu') : $active_sub_menu;
        $data['active_sub_menu_item'] = $sdata['active_sub_menu_item'] = 'Course';
        $this->session->set_userdata($sdata);
        $data['left_side_menu_view'] = 1;
        $data['left_side'] = 1;
        return $data;
    }

    /*
      -----------@@@RIPON@ End Course Common Query Part----------------------------------
     */


    /*
      -----------@@@RIPON@ Start Add Course Part----------------------------------
     */

    /**
     * @Function            : get_course_information 
     * @Used IN             : @function-'add_course'                        user_course[@controller],
     * @                    : @function-'get_information_for_edit_course'   user_course[@controller],
     * @Description         : get course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 12:19 PM   
     * @Parameter           : $course_data[ARRAY]
     * @Return              : $course_data[ARRAY]      
     * @Status              : available      
     * */
    function get_course_information($course_data) {
        $side_menu_data = $this->side_menu_info($course_data, '', '');

        if ($side_menu_data['person_info']->person_role == 4) {
            $side_menu_data['all_resource_person'] = $this->resource_person_model->get_all_resource_person_info_by_organizarion_id($side_menu_data['organization_info']->organization_id);
        }
        $side_menu_data['parent_topic'] = $this->topic_model->select_all_parent_topic_id_if_child();
        return $side_menu_data;
    }

    /**
     * @Function            : save_course_information 
     * @Used IN             : @function-'add_course'   user_course[@controller],
     * @Description         : save course information 
     *                      : @Update2=> add topic replace with course category
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 09:38 AM
     * @Updated Date Time   : 09-05-2016 11:27 AM       10-08-2016 10:50 AM
     * @Updated By          : MD Jaherul Islam          MD Jaherul Islam  
     * @Parameter           : $person_id[INTEGER],$data[ARRAY]
     * @Return              : $course_id[INTEGER]      
     * @Status              : available      
     * */
    public function save_course_information($person_id, $data) {
        $course_data = Array();
        $course_data['person_id'] = $data['person_info']->person_id;
        $course_data['course_name'] = $this->input->post('course_name', TRUE);
        $course_data['topic_id'] = $this->topic_model->save_other_topic($data['person_info']->person_id, $this->input->post('parent_topic_id', TRUE), $this->input->post('topic_id', TRUE));
        $course_data['resource_person_id'] = $this->resource_person_model->save_resource_person_info($this->input->post('resource_person_id', TRUE), $data);
        $course_data['course_level'] = $this->input->post('course_level', TRUE);
        $course_data['number_of_classes'] = $this->input->post('number_of_classes', TRUE);
        $course_data['class_hour_per_day'] = $this->input->post('class_hour_per_day', TRUE);
        $course_data['course_start_date'] = $this->input->post('course_start_date', TRUE);
        $course_data['course_finished_date'] = $this->input->post('course_finished_date', TRUE);
        $course_data['last_date_of_registration'] = $this->input->post('last_date_of_registration', TRUE);
        $course_data['class_time'] = date('H:i:s', strtotime($this->input->post('class_time', TRUE)));
        $course_data['course_work_files'] = $this->input->post('course_work_files', TRUE);
        $course_data['course_access_level'] = $this->input->post('course_access_level', TRUE);
        $course_data['course_language'] = $this->input->post('course_language', TRUE);

        return $this->save_course_more_information($person_id, $data, $course_data);
    }

    /**
     * @Function            : save_course_more_information 
     * @Used IN             : @function-'save_course_information'   this[@Model],
     * @Description         : save course more information 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 04:51 PM
     * @Modified By         : Md. Delwar Hossain
     * @Start DateTime      : 4-05-2017 10:22 AM
     * @Parameter           : $person_id[INTEGER],$data[ARRAY],$course_data[ARRAY]
     * @Return              : $course_id[INTEGER]           
     * @Status              : available      
     * */
    function save_course_more_information($person_id, $data, $course_data) {
        if($this->input->post('draft', TRUE)){
            $course_data['course_status'] = ($data['resource_person_info']->person_special_permission == 1) ? 4 : 5;
        }
        if($this->input->post('add_course', TRUE)){
            $course_data['course_status'] = ($data['resource_person_info']->person_special_permission == 1) ? 4 : 3;
        }
        
        $course_days = $this->input->post('course_days', TRUE);
        $course_data['course_days'] = ($course_days != '') ? implode(',', $course_days) : '';
        $course_data['url_id'] = $this->url_model->create_course_url($this->input->post('course_url', TRUE));
        $course_data['course_type'] = $this->input->post('course_type', TRUE);

        $course_resource_person_edit = $this->input->post('course_resource_person_edit', TRUE);
        $course_data['course_resource_person_edit'] = ($course_resource_person_edit != '' ? 1 : 2);

        $course_resource_person_view_invoice = $this->input->post('course_resource_person_view_invoice', TRUE);
        $course_data['course_resource_person_view_invoice'] = ($course_resource_person_view_invoice != '' ? 1 : 2);

        $course_resource_person_pay_invoice = $this->input->post('course_resource_person_pay_invoice', TRUE);
        $course_data['course_resource_person_pay_invoice'] = ($course_resource_person_pay_invoice != '' ? 1 : 2);
        $course_data['upcoming_course'] = 2;

        $course_id = $this->utility_model->save_information_in_database('tbl_course', $course_data);
        // Save Course other Information
        $this->save_course_other_information($person_id, $course_id, $data, $course_data);
        return $course_id;
    }

    /**
     * @Function            : save_course_other_information 
     * @Used IN             : @function-'save_course_more_information'   this[@Model],
     * @Description         : save course related other information 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 04:44 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : $person_id[INTEGER],$course_id[INTEGER],$data[ARRAY],$course_data[ARRAY]          
     * @Status              : available      
     * */
    function save_course_other_information($person_id, $course_id, $data, $course_data) {
        if ($course_data['course_type'] == '1') { // save course price information
            $type = 1; // Course Price Type
            $this->price_model->save_price_information($type, $course_id);
        }
        // Save Course tinymce information
        $this->save_course_all_tinymce_information($person_id, $data['person_info']->person_id, $course_id, $course_data['url_id']);
        // Save Notification for add Course
        $notification_id = $this->notification_course_model->save_add_course_notification($course_id, $course_data);  // save notification for add course
        // Send Email for Add Course
        $this->mailer_model->send_email_for_add_course($notification_id);
    }

    /**
     * @Function            : save_course_all_tinymce_information 
     * @Used IN             : @function-'save_course_information'    this[@Model]
     * @Description         : save course all tinymce information information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 03:09 PM   
     * @Parameter           : $person_id[INTEGER], $course_id[[INTEGER], $course_url_id[[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_course_all_tinymce_information($sess_person_id, $person_id, $course_id, $course_url_id) {
        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) {
            $course_updated_training_objectives = $this->save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_training_objectives);
            $data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) {
            $course_updated_training_outline = $this->save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_training_outline);
            $data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $data['course_training_outline'] = '';
        }

        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);

        $person_url = $this->person_model->get_profile_url($sess_person_id);
        $directory = 'source/' . $person_url . '/';
        $this->utility_model->remove_directory_without_root($directory);
    }

    /**
     * @Function            : save_course_tinymce_value 
     * @Used IN             : @function-'save_course_information'       user_course_model[@Model]
     * @Description         : save course tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 10:34 AM 
     * @Parameter           : $person_id[INTEGER], $course_id[INTEGER], $course_url_id[INTEGER], $course_description[STRING]
     * @Return              : $tinymce_description[STRING]            
     * @Status              : available      
     * */
    function save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_description) {
        $person_url = $this->person_model->get_profile_url($person_id);
        $destination_path = 'content-library/' . $person_url . '/my-work-file';
        $type = '1,5'; // url type
        $c_type = 2; // content library type for course
        $find_path = 'source'; // find file from source directory
        $course_url_info = $this->url_model->get_url_by_url_id($course_url_id, $type);
        $new_directory = $destination_path . '/' . $course_url_info->url;

        return $this->tinymce_model->get_tinymce_description($course_id, $new_directory, $course_description, $c_type, $find_path);
    }

    /*
      -----------@@@RIPON@ End Add Course Part----------------------------------
     */






    /*
      -----------@@@RIPON@ Start Edit Course Part (25-07-16)----------------------------------
     */

    /**
     * @Function            : get_information_for_edit_course 
     * @Used IN             : @function-'edit_course'   this[@Controller]
     * @Description         : get information for edit course  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-07-2016 01:10 PM
     * @Parameter           : $course_url[STRING],$data[ARRAY]
     * @Return              : $data[ARRAY]           
     * @Status              : available      
     * */
    function get_information_for_edit_course($data) {
        $data['course_creator_info'] = $this->person_model->get_single_person_information_by_person_id($data['course_info']->course_creator_id);
        $course_data = $this->get_information_for_course($data);
        if ($course_data['course_info']->course_type == 1) { // for paid course
            $course_data['course_price_info'] = $this->price_model->get_single_price_information(1, $course_data['course_info']->course_id);
        }
        $course_data['parent_topic_info'] = $this->topic_model->select_topic_info_by_topic_id($course_data['course_info']->topic_id);
        return $this->get_course_information($course_data);
    }

    /**
     * @Function            : update_course_information 
     * @Used IN             : @function-'edit_course'   user_course[@Controller]
     * @Description         : update course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 11:40 AM
     * @Parameter           : $data[ARRAY]
     * @Return              : $course_id[INTEGER]           
     * @Status              : available      
     * */
    function update_course_information($data) {
        $course_data = Array();
        $course_data['course_name'] = $this->input->post('edit_course_name', TRUE);
        $course_data['topic_id'] = $this->topic_model->save_other_topic($data['course_info']->course_creator_id, $this->input->post('parent_topic_id', TRUE), $this->input->post('topic_id', TRUE));
        $course_data['resource_person_id'] = $this->resource_person_model->save_resource_person_info($this->input->post('resource_person_id', TRUE), $data);
        $course_data['course_level'] = $this->input->post('course_level', TRUE);
        $course_data['number_of_classes'] = $this->input->post('number_of_classes', TRUE);
        $course_data['class_hour_per_day'] = $this->input->post('class_hour_per_day', TRUE);
        $course_data['course_start_date'] = $this->input->post('course_start_date', TRUE);
        $course_data['course_finished_date'] = $this->input->post('course_finished_date', TRUE);
        $course_data['last_date_of_registration'] = $this->input->post('last_date_of_registration', TRUE);
        $course_data['class_time'] = date('H:i:s', strtotime($this->input->post('class_time', TRUE)));
        $course_data['course_work_files'] = $this->input->post('course_work_files', TRUE);
        $course_data['course_access_level'] = $this->input->post('course_access_level', TRUE);
        $course_data['course_language'] = $this->input->post('course_language', TRUE);

        // Update Course more information
        $this->update_course_more_information($data, $course_data);
    }

    /**
     * @Function            : update_course_more_information 
     * @Used IN             : @function-'update_course_information'   this[@Model]
     * @Description         : update more course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 04:52 PM
     * @Modified By         : Md. Delwar Hossain
     * @Start DateTime      : 4-05-2017 11:22 AM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : Null 
     * @Status              : available      
     * */
    function update_course_more_information($data, $course_data) {
        if($data['course_info']->course_status == 1 || $data['course_info']->course_status == 4){
            $course_data['course_status'] = 3;
        }        
        $course_days = $this->input->post('course_days', TRUE);
        $course_data['course_days'] = ($course_days != '') ? implode(',', $course_days) : '';

        $course_type = $this->input->post('course_type', TRUE);
        $course_data['course_type'] = ($course_type == '') ? 2 : $course_type;

        if ($data['resource_person_info']->person_role == 4) {
            $course_resource_person_edit = $this->input->post('course_resource_person_edit', TRUE);
            $course_data['course_resource_person_edit'] = ($course_resource_person_edit != '' ? 1 : 2);

            $course_resource_person_view_invoice = $this->input->post('course_resource_person_view_invoice', TRUE);
            $course_data['course_resource_person_view_invoice'] = ($course_resource_person_view_invoice != '' ? 1 : 2);

            $course_resource_person_pay_invoice = $this->input->post('course_resource_person_pay_invoice', TRUE);
            $course_data['course_resource_person_pay_invoice'] = ($course_resource_person_pay_invoice != '' ? 1 : 2);
        }

        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;
        if (is_dir($upload_dir)) {
            // update tinymce information if remain directory with Course url
            $course_more_data = $this->update_course_all_tinymce_information($data, $course_data);
        } else {
            // update tinymce information
            $course_more_data = $this->update_course_all_tinymce_information_for_url_non_existence($data, $course_data);
        }

        // Update Course information
        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $data['course_info']->course_id, $course_more_data);
        // update course related other information
        $this->update_course_other_informtion($data, $course_data);
    }

    /**
     * @Function            : update_course_more_information 
     * @Used IN             : @function-'update_course_more_information'   this[@Model]
     * @Description         : update course related other information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 04:53 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : Null 
     * @Status              : available      
     * */
    function update_course_other_informtion($data, $course_data) {
//        if ($this->input->post('course_url', TRUE) != $data['course_info']->url) { // if Course new url or Old url does not same
//            $this->url_model->update_front_end_course_url($data['course_creator_info']->url, $data['course_info']->url_id, $data['course_info']->url, $this->input->post('course_url', TRUE));
//        }

        if ($data['course_info']->course_type == '1') { // Delete price information
            $this->price_model->delete_price_information(1, $data['course_info']->course_id);
        }

        if ($course_data['course_type'] == '1') { // Save price information
            $this->price_model->save_price_information(1, $data['course_info']->course_id);  // save course price information
        }

        // notification for Update COurse
        $notification_id = $this->notification_course_model->save_update_course_notification($data['course_info']->course_id, $data, $course_data, 2);  // save notification for add course
        // send mail for update course for Update COurse
        $this->mailer_model->send_email_for_edit_course($notification_id);
    }

    /**
     * @Function            : update_course_all_tinymce_information 
     * @Used IN             : @function-'update_course_information'   this[@Model]
     * @Description         : update tinymce information if remain directory with Course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-07-2016 04:57 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : $course_data[ARRAY] 
     * @Status              : available      
     * */
    function update_course_all_tinymce_information($data, $course_data) {
        $type = 2; // content library type for course
        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;

        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) { // if found Course_training_objective
            $course_updated_training_objectives = $this->tinymce_model->update_tinymce_information($data['course_info']->course_id, $data['course_creator_info']->url, $data['course_info']->url, $course_training_objectives, $data['course_info']->course_training_objectives, $type);
            $course_data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $course_data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) { // if found course_training_outline
            $course_updated_training_outline = $this->tinymce_model->update_tinymce_information($data['course_info']->course_id, $data['course_creator_info']->url, $data['course_info']->url, $course_training_outline, $data['course_info']->course_training_outline, $type);
            $course_data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $course_data['course_training_outline'] = '';
        }
        // remove all used file and Empty directory
        $this->remove_course_tinymce_file($type, $upload_dir, $data, $course_data);
        $this->tinymce_model->check_folder_for_tinymce($data['course_info']->course_id, $upload_dir);
        return $course_data;
    }

    /**
     * @Function            : update_course_all_tinymce_information_for_non_existence 
     * @Used IN             : @function-'update_course_more_information'   this[@Model]
     * @Description         : update course Tinymce information if course url does not existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-07-2016 06:14 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : $course_data[ARRAY]  
     * @Status              : available      
     * */
    function update_course_all_tinymce_information_for_url_non_existence($data, $course_data) {
        $type = 2; // content library type for course
        $find_path = 'source'; // find file from source directory
        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;

        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) { // if found Course_training_objective
            $course_updated_training_objectives = $this->tinymce_model->get_tinymce_description($data['course_info']->course_id, $upload_dir, $course_training_objectives, $type, $find_path);
            $course_data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $course_data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) { // if found course_training_outline
            $course_updated_training_outline = $this->tinymce_model->get_tinymce_description($data['course_info']->course_id, $upload_dir, $course_training_outline, $type, $find_path);
            $course_data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $course_data['course_training_outline'] = '';
        }

        $directory = 'source/' . $data['course_creator_info']->url . '/';
        $this->utility_model->remove_directory_without_root($directory); // Remove file from TINYMCE source derectory
        return $course_data;
    }

    /**
     * @Function            : remove_course_tinymce_file 
     * @Used IN             : @function-'update_course_information'   this[@Model]
     * @Description         : Remove unused tinymce file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-07-2016 04:03 PM
     * @Parameter           : $type[INTEGER](Which type - Course/Video Course/Quiz.....) 
     *                        $upload_dir[STRING],$data[ARRAY],$course_data[ARRAY]
     * @Return              : Null 
     * @Status              : available      
     * */
    function remove_course_tinymce_file($type, $upload_dir, $data, $course_data) {
        if ($course_data['course_training_objectives'] == '') {
            if ($data['course_info']->course_training_objectives != '') { // tinymce have file
                $this->content_library_model->remove_multiple_content_library_file($data['course_info']->course_id, $data['course_info']->course_training_objectives, $type, $upload_dir);
            }
        }
        if ($course_data['course_training_outline'] == '') {
            if ($data['course_info']->course_training_outline != '') { // tinymce have file
                $this->content_library_model->remove_multiple_content_library_file($data['course_info']->course_id, $data['course_info']->course_training_outline, $type, $upload_dir);
            }
        }
    }

    /*
      -----------@@@RIPON@ End Edit Course Part (25-07-16)----------------------------------
     */








    /*
      -----------@@@RIPON@ Start Course View Part (organization & Teacher)----------------------------------
     */

    /**
     * @Function            : get_all_course_value 
     * @Used IN             : @function-'organization_course_list'  user_course[@controller]
     * @Description         : get all course value if course as Draft,Pending, Active or Apporved
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 09:55 AM  
     * @Parameter           : $data[ARRAY], $person_role[INTEGER], $limit[INTEGER]
     * @Return              : $active_course_data[ARRAY]    
     * @Status              : Available        
     * */
    function get_all_course_value($data, $person_role, $limit) {
        $draft_course_status = '5,6';
        $active_course_status = '1,4';
        if ($person_role == 4) {
            $draft_course_data = $this->select_all_draft_courses($data, $data['person_info']->person_id, $draft_course_status, $limit, '');
            $submit_course_data = $this->select_all_submit_courses($draft_course_data, $data['person_info']->person_id, 3, $limit, '');
            $active_course_data = $this->select_all_active_courses($submit_course_data, $data['person_info']->person_id, $active_course_status, $limit, '');
        } else {
            $draft_course_data = $this->select_all_draft_courses($data, $data['person_info']->person_id, $draft_course_status, $limit, $data['resource_person_info']->resource_person_id);
            $submit_course_data = $this->select_all_submit_courses($draft_course_data, $data['person_info']->person_id, 3, $limit, $data['resource_person_info']->resource_person_id);
            $active_course_data = $this->select_all_active_courses($submit_course_data, $data['person_info']->person_id, $active_course_status, $limit, $data['resource_person_info']->resource_person_id);
        }
        return $active_course_data;
    }

    /**
     * @Function            : select_all_draft_courses 
     * @Used IN             : @function-'get_all_course_value'              this[@Model] (2)
     * @                    : @function-'view_draft_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Get all draft courses
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 10:14 AM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_draft_course[ARRAY]    
     * @Status              : Available    
     * */
    function select_all_draft_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['draft_courses'] = $this->select_all_courses($person_id, $status, $limit, $resource_person_id);
        foreach ($data['draft_courses'] as $course_value) {
            $data['student_info'][$course_value->course_id] = $this->student_model->get_all_concat_student_id_list_by_course_id(1, $course_value->course_id);
            $data['price_info'][$course_value->course_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
        }
        $data['total_draft_courses'] = $this->get_total_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_submit_courses 
     * @Used IN             : @function-'get_all_course_value'                   this[@Model] (2)
     *                      : @function-'view_submission_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Select all pending courses
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 12:14 PM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_pending_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_submit_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['submit_courses'] = $this->select_all_courses($person_id, $status, $limit, $resource_person_id);
        foreach ($data['submit_courses'] as $course_value) {
            $data['student_info'][$course_value->course_id] = $this->student_model->get_all_concat_student_id_list_by_course_id(1, $course_value->course_id);
            $data['price_info'][$course_value->course_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
        }
        $data['total_submit_courses'] = $this->get_total_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_active_courses 
     * @Used IN             : @function-'get_all_course_value'               this[@Model] (2)
     *                      : @function-'view_active_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Select all pending courses
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 01:14 PM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_active_or_apporved_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_active_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['active_courses'] = $this->select_all_courses($person_id, $status, $limit, $resource_person_id);
        foreach ($data['active_courses'] as $course_value) {
            $data['student_info'][$course_value->course_id] = $this->student_model->get_all_concat_student_id_list_by_course_id(1, $course_value->course_id);
            $data['price_info'][$course_value->course_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
            //start tania 20-09-2016 used for count unassigned active courses student        
            $assigned_student = $this->batch_model->get_assigned_student($course_value->course_id);
            $assigned_student_array = array_unique(explode(',', $assigned_student));
            $register_student = $this->batch_model->get_register_student($course_value->course_id);
            $register_student_array = array_unique(explode(',', $register_student));
            $data['unasigned_student_active'][$course_value->course_id] = $unasigned_student = array_diff($register_student_array, $assigned_student_array);
            //end                        
        }
        $data['total_active_courses'] = $this->get_total_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_courses 
     * @Used IN             : @function-'select_all_draft_courses'    this[@Model]
     * @                    : @function-'select_all_submit_courses'   this[@Model]
     * @                    : @function-'select_all_active_courses'   this[@Model]
     * @Description         : Select all courses with some condition
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 03:00 PM  
     * @Parameter           : $person_id[INTEGER], $course_status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_courses($person_id, $course_status, $limit, $resource_person_id) {
        $course_id = $this->session->userdata("course_id");
        $sql = "SELECT * 
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE 
                    c.person_id = '$person_id'";
        if ($course_id != '') {
            $sql.=" AND c.course_id != '$course_id'";
        }
        if ($resource_person_id != '') {
            $sql.=" AND c.resource_person_id = '$resource_person_id'";
        }
        $sql.=" AND c.course_status IN ($course_status)
                AND c.url_id = u.url_id
                LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_course 
     * @Used IN             : @function-'select_all_draft_courses'    this[@Model]
     * @                    : @function-'select_all_submit_courses'   this[@Model]
     * @                    : @function-'select_all_active_courses'   this[@Model]
     * @Description         : Select total courses with some condition
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-05-2016 03:43 PM  
     * @Parameter           : $person_id[INTEGER], $course_status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $total_course[INTEGER]    
     * @Status              : Available        
     * */
    function get_total_course($person_id, $course_status, $resource_person_id) {
        $course_id = $this->session->userdata("course_id");
        $sql = "SELECT count(*) AS total 
                FROM 
                    tbl_course AS c
                WHERE 
                    c.person_id = '$person_id'";
        if ($course_id != '') {
            $sql.=" AND c.course_id != '$course_id'";
        }
        if ($resource_person_id != '') {
            $sql.=" AND c.resource_person_id = '$resource_person_id'";
        }
        $sql.=" AND c.course_status IN ($course_status)";
        return $this->db->query($sql)->row();
    }
    
    function get_course_creator_info_by_course_url($course_url){
        $this->db->select('*')
                ->from('tbl_person AS p')
                ->join('tbl_course AS c','p.person_id = c.person_id')
                ->join('tbl_url AS u', 'c.url_id = u.url_id')
                ->where('u.url',$course_url);
        return $this->db->get()->row();
    }

    /*
      -----------@@@RIPON@ End Course View Part (organization & Teacher)----------------------------------
     */






    /*
      -----------@@@RIPON@ Start Learner Course View Part(06-09-16)----------------------------------
     */

    /**
     * @Function            : get_learner_free_course_value 
     * @Used IN             : @function-'learner_course_list'           user_course[@controller]
     * @                    : @function-'learner_course_pagination'     user_course[@controller]
     * @Description         : get learner all free course by person id 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 10:51 AM
     * @Updated Date Time   : 30-08-2016 11:45 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $person_id[INTEGER],$limit[INTEGER]
     * @Return              : free_course_list    
     * @Status              : Available       
     * */
    function get_learner_free_course_value($course_data, $person_id, $course_id, $page_number) {
        $limit = ($page_number - 1) * 10;
        $course_data['free_courses'] = $this->select_learner_course_list(2, $person_id, $course_id, $limit);
        $course_data['total_free_courses'] = $this->select_learner_total_course_list(2, $person_id);

        $params = array('url' => '', 'div_id' => 'freeCoursePagination', 'total_row' => $course_data['total_free_courses'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $course_data['free_course_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $course_data;
    }
    
    /**
     * @Function            : get_learner_paid_course_value 
     * @Used IN             : @function-'learner_course_list'           user_course[@controller]
     * @                    : @function-'learner_course_pagination'     user_course[@controller]
     * @Description         : get learner all paid course by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 29-03-2017
     * @Parameter           : $person_id[INTEGER],$limit[INTEGER]
     * @Return              : paid_course_list    
     * @Status              : Available       
     * */
    function get_learner_paid_course_value($course_data, $person_id, $course_id, $page_number) {
        $limit = ($page_number - 1) * 10;
        $course_data['paid_courses'] = $this->select_learner_paid_course_list(1, $person_id, $course_id, $limit);

        foreach ($course_data['paid_courses'] as $course_value) {
            $course_data['price_info'][$course_value->student_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
        }
        $course_data['total_paid_courses'] = $this->select_learner_total_paid_course_list(1, $person_id);
        $course_data['random_number'] = $this->get_user_invoice_random_number_payment_amount_by_person_id($person_id);
        
        $params = array('url' => '', 'div_id' => 'paidCoursePagination', 'total_row' => $course_data['total_paid_courses'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $course_data['paid_course_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $course_data;
    }
    
    /**
     * @Function            : get_register_course_value 
     * @Used IN             : @function-'learner_course_list'           user_course[@controller]
     * @                    : @function-'learner_course_pagination'     user_course[@controller]
     * @Description         : get learner all register course by person id 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 10:54 AM
     * @Updated Date Time   : 30-08-2016 12:04 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $person_id[INTEGER],$limit[INTEGER]
     * @Return              : register_course_list    
     * @Status              : Available       
     * */
    function get_register_course_value($course_data, $person_id, $course_id, $page_number) {
        $limit = ($page_number - 1) * 10;
        $course_data['register_courses'] = $this->select_learner_register_course_list(1, $person_id, $course_id, $limit);

        foreach ($course_data['register_courses'] as $course_value) {
            $course_data['price_info'][$course_value->student_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
        }
        $course_data['total_register_courses'] = $this->select_learner_total_register_course_list(1, $person_id);
        $course_data['random_number'] = $this->get_user_invoice_random_number_by_person_id($person_id);
    
        $params = array('url' => '', 'div_id' => 'registerCoursePagination', 'total_row' => $course_data['total_register_courses'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $course_data['register_course_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $course_data;
    }
    
    /**
     * @Function            : get_user_invoice_random_number_by_person_id 
     * @Used IN             : @function-'get_register_course_value'     user_course[@controller]
     * @Description         : get learner all registered course random number by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 29-03-2017 09:30 AM
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_user_invoice_random_number_by_person_id($person_id){
        $this->db->select('*')
            ->from('tbl_person AS pr')
            ->join('tbl_payment AS p','pr.person_id = p.person_id')
            ->join('tbl_course AS c','p.payment_type_id = c.course_id')
            ->join('tbl_invoice AS i', 'p.payment_id = i.payment_id')
            ->join('tbl_random AS r', 'i.invoice_id = r.random_type_id')
            ->where('p.person_id', $person_id);
        
        return $this->db->get()->result_array();
    }
    
    /**
     * @Function            : get_user_invoice_random_number_payment_amount_by_person_id 
     * @Used IN             : @function-'get_register_course_value'     user_course[@controller]
     * @Description         : get learner all paid course payment amount by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 30-03-2017 11:00 AM
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_user_invoice_random_number_payment_amount_by_person_id($person_id){
        $this->db->select('*')
                ->from('tbl_person AS pr')
                ->join('tbl_payment AS p','pr.person_id = p.person_id')
                ->join('tbl_course AS c','p.payment_type_id = c.course_id')
                ->join('tbl_invoice AS i', 'p.payment_id = i.payment_id')
                ->join('tbl_invoice_payment AS ip', 'i.invoice_id = ip.invoice_id')
                ->join('tbl_random AS r', 'i.invoice_id = r.random_type_id')
                ->where('p.person_id', $person_id)
                ->where('random_type = 1') ;
        
        return $this->db->get()->result_array();
    }

    /**
     * @Function            : select_learner_free_course_list 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get learner all free course by person id 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 06:32 PM
     * @Updated Date Time   : 31-08-2016 03:25 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $course_type=>[Free/Paid], $person_id=>[Course Register ID],$limit=>limit
     * @Return              : $free_course_list    
     * @Status              : Available       
     * */
    public function select_learner_course_list($course_type, $person_id, $course_id, $limit) {
        $sql = "SELECT *,c.person_id AS course_creator_id 
                FROM tbl_student AS s,tbl_course AS c,tbl_url AS u
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id
                AND c.course_type = '$course_type' AND s.person_id = '$person_id' 
                AND c.url_id = u.url_id AND c.course_status IN (1,4)";
        if ($course_id != '') {
            $sql.=" AND c.course_id != '$course_id'";
        }
        $sql.=" LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }
    
    
    public function select_learner_register_course_list($course_type, $person_id, $course_id, $limit) {
        $sql = "SELECT *,c.person_id AS course_creator_id 
                FROM tbl_student AS s,tbl_course AS c,tbl_url AS u,tbl_payment AS p 
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id
                AND c.course_id = p.payment_type_id AND s.person_id = p.person_id AND p.payment_status IN (3)
                AND c.course_type = '$course_type' AND s.person_id = '$person_id' 
                AND c.url_id = u.url_id AND c.course_status IN (1,4)";
        if ($course_id != '') {
            $sql.=" AND c.course_id != '$course_id'";
        }
        $sql.=" LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }
    
    /**
     * @Function            : select_learner_paid_course_list 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get learner all paid course by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 30-03-2017 012:32 PM
     * @Parameter           : $course_type=>[Paid], $person_id=>[Course Register ID],$limit=>limit
     * @Status              : Available       
     * */
    public function select_learner_paid_course_list($course_type, $person_id, $course_id, $limit) {
        $sql = "SELECT *,c.person_id AS course_creator_id 
                FROM tbl_student AS s,tbl_course AS c,tbl_url AS u,tbl_payment AS p 
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id
                AND c.course_id = p.payment_type_id AND s.person_id = p.person_id AND p.payment_status IN (1,2,6)
                AND c.course_type = '$course_type' AND s.person_id = '$person_id' 
                AND c.url_id = u.url_id AND c.course_status IN (1,4)";
        if ($course_id != '') {
            $sql.=" AND c.course_id != '$course_id'";
        }
        $sql.=" LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_single_learner_course 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get Single learner all free course by person id 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-09-2016 06:13 PM
     * @Parameter           : $course_type=>[Free/Paid], $person_id=>[Course Register ID],$course_id=>limit
     * @Return              : $free_course_list    
     * @Status              : Available       
     * */
    function get_single_learner_course($person_id, $course_id) {
        $sql = "SELECT *,c.person_id AS course_creator_id 
                FROM tbl_student AS s,tbl_course AS c,tbl_url AS u
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id
                AND s.person_id = '$person_id' 
                AND c.url_id = u.url_id AND c.course_id = '$course_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_learner_total_free_course_list 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get learner total free course by person id 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-08-2016 03:25 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : total_free_course    
     * @Status              : Available       
     * */
    function select_learner_total_course_list($course_type, $person_id) {
        $sql = "SELECT count(*) AS total
                FROM tbl_student AS s,tbl_course AS c
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id  AND c.course_status IN (1,4) 
                AND c.course_type = '$course_type' AND s.person_id = '$person_id'";
        return $this->db->query($sql)->row()->total;
    }
    
    /**
     * @Function            : select_learner_total_paid_course_list 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get learner total Paid course by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 30-03-2017
     * @Parameter           : $person_id[INTEGER]
     * @Return              : total_paid_course    
     * @Status              : Available       
     * */
    function select_learner_total_paid_course_list($course_type, $person_id) {
        $sql = "SELECT count(*) AS total
                FROM tbl_student AS s,tbl_course AS c,tbl_payment AS p
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id  AND c.course_status IN (1,4) 
                AND c.course_id = p.payment_type_id AND s.person_id = p.person_id AND p.payment_status IN (1,2,6)
                AND c.course_type = '$course_type' AND s.person_id = '$person_id'";
        return $this->db->query($sql)->row()->total;
    }
    
    /**
     * @Function            : select_learner_total_register_course_list 
     * @Used IN             : @function-'learner_course_list'     user_course[@controller]
     * @Description         : get learner total register course by person id 
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 30-03-2017
     * @Parameter           : $person_id[INTEGER]
     * @Return              : total_register_course    
     * @Status              : Available       
     * */
    function select_learner_total_register_course_list($course_type, $person_id) {
        $sql = "SELECT count(*) AS total
                FROM tbl_student AS s,tbl_course AS c,tbl_payment AS p
                WHERE s.student_type = '1' AND s.student_type_id = c.course_id  AND c.course_status IN (1,4) 
                AND c.course_id = p.payment_type_id AND s.person_id = p.person_id AND p.payment_status IN (3)
                AND c.course_type = '$course_type' AND s.person_id = '$person_id'";
        return $this->db->query($sql)->row()->total;
    }
    
    /**
     * @Function            : get_all_course_register_student 
     * @Used IN             : @function-'registered_student_list'     user_course[@controller]
     * @Description         : get all course register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 03:26 PM
     * @Parameter           : $course_id[INTEGER]
     * @Return              : Null    
     * @Status              : Available       
     * */
    function get_all_course_register_student($data, $date, $page_number) {
        $limit = ($page_number - 1) * 10;
        $data['course_register_student'] = $this->get_all_student_list_by_course_id(1, $data['course_info']->course_id, $date, $limit);
        $data['total_course_register_student'] = $this->get_total_student_by_course_id(1, $data['course_info']->course_id, $date);
        $params = array('url' => '', 'div_id' => 'registerCourseStudentPagination', 'total_row' => $data['total_course_register_student'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['register_course_student_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }
    
    function get_invoice_random_number_payment_status_by_person_id($payment_type, $payment_type_id){
        $this->db->select('pay.payment_status,pay.payment_type_id, pay.person_id, inv.invoice_id, ran.random_number')
                ->from('tbl_payment AS pay , tbl_student AS s')
                ->join('tbl_person AS p', 's.person_id = p.person_id')
                ->join('tbl_url AS u', 'p.url_id = u.url_id')
                ->join('tbl_invoice AS inv', 'pay.payment_id = inv.payment_id')
                ->join('tbl_random AS ran', 'inv.invoice_id = ran.random_type_id')
                ->where('p.person_id = pay.person_id')
                ->where('student_eligibility',1)
                ->where(Array('pay.payment_type' => $payment_type, 'pay.payment_type_id' => $payment_type_id, 's.student_type'=>$payment_type, 's.student_type_id'=>$payment_type_id));
        return $this->db->get()->result_array();

    }

    /**
     * @Function            : get_all_student_list_by_course_id 
     * @Used IN             : @function-'registered_student_list'   this[Model]
     * @Description         : get all student information bu course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 03:08 PM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_all_student_list_by_course_id($student_type, $student_type_id, $date, $limit) {
//        echo '<pre>';
//        print_r($date);
//        print_r($limit);
//        exit();
        
        $this->db->select('*')
                ->from('tbl_student AS s')
                ->join('tbl_person AS p', 's.person_id = p.person_id')
                ->join('tbl_url AS u', 'p.url_id = u.url_id')
                ->where('student_eligibility', 1)
                ->where(Array('s.student_type' => $student_type, 's.student_type_id' => $student_type_id));
        if ($date) {
            $this->db->where("DATE(s.register_date_time) BETWEEN '$date[sess_start_date]' AND '$date[sess_end_date]'");
        }
        return $this->db->limit(10, $limit)->get()->result();
    }

    /**
     * @Function            : get_all_student_list_by_course_id 
     * @Used IN             : @function-"registered_student_list'   this[Model]
     * @Description         : get all student information by course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 03:08 PM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_total_student_by_course_id($student_type, $student_type_id, $date) {
        $this->db->select('*')
                ->from('tbl_student')
                ->where('student_eligibility', 1)
                ->where(Array('student_type' => $student_type, 'student_type_id' => $student_type_id));
        if ($date) {
            $this->db->where("DATE(register_date_time) BETWEEN '$date[sess_start_date]' AND '$date[sess_end_date]'");
        }
        return $this->db->count_all_results();
    }

    /*
      -----------@@@RIPON@ End Learner Course View Part(06-09-16)----------------------------------
     */
}
