<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of url_model
 *
 * @author rIpOn
 */
class Url_model extends CI_Model {

    const tbl_name = 'tbl_url';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : get_single_url_information 
     * @Description         : get url by url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 10:29 AM
     * @Parameter           : $url[STRING]
     * @Return              : url_info    
     * @Status              : Available       
     * */
    function get_single_url_information($url) {
        $sql = "SELECT * FROM tbl_url AS u WHERE u.url = '$url'";
        return $this->db->query($sql)->row();
    }

    /**
     * @start
     * User Management
      ================
      Add/Edit User-> B
     */

    /**
     * @Function            : add_user_url 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Save url in DB 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-01-2016 10:02 PM   
     * @Status              : available      
     * */
    function add_user_url() {
        $udata['url'] = $this->input->post('profile_url', TRUE);
        $udata['url_type'] = '10';
        $this->db->insert('tbl_url', $udata);
        $data['url_id'] = $this->db->insert_id();

        // Create folder folling url
        $this->create_folder($udata['url']);
        $data['url'] = $udata['url'];
        return $data;
    }

    // End of the function

    /**
     * Date : 18-01-2016
      Name: Ripon
      Work: Update User Url (back end)
      End : 18-01-2016
     */
    function update_user_url() {
        $person_url = $this->input->post('profile_url', TRUE);
        $person_old_url = $this->input->post('old_url', TRUE);

        if ($person_old_url != $person_url) {
            $data['url'] = $person_url;
            $this->db->set('url', $data['url']);
            $this->db->set('url_type', 10);
            $this->db->where('url_id', $this->input->post('url_id', TRUE));
            $this->db->update('tbl_url');

            // rename folder
            rename('./content-library/' . $person_old_url, './content-library/' . $person_url);
            $data['person_last_change_url_date'] = date('Y-m-d', time() - $this->session->userdata('time_offset'));
        } else {
            $data['url'] = $person_old_url;
            $data['person_last_change_url_date'] = NULL;
        }
        return $data;
    }

    /**
     * Date : 20-01-2016
      Name: Ripon
      Work: update_person_url (for front end profile)
      End : 20-01-2016
     */
    function update_person_url($user_id, $url_id, $url, $old_url) {
        $url1 = $this->create_url($url);
        $this->update_url($url_id, $url1);

        $old_url_folder = './content-library/' . $old_url;
        if (file_exists($old_url_folder)) {
            rename('./content-library/' . $old_url, './content-library/' . $url1);
        }
        $this->update_person_info($user_id);
        $this->set_url_in_session($url1);
        return $url1;
    }

    /**
     * Date : 18-10-2016
      Name: Ripon
      Work: save_menu_information (back end)
      End : 18-01-2016
     */
    function save_menu_url() {
        $url_data['url'] = $this->input->post('menu_url', TRUE);
        $url_data['url_type'] = 1;
        $this->db->insert('tbl_url', $url_data);
        return $this->db->insert_id();
    }

    /**
     * Date : 18-10-2016
      Name: Ripon
      Work: update_menu_information (back end)
      End : 18-01-2016
     */
    function update_menu_url() {
        $menu_url = $this->input->post('menu_url', TRUE);
        $old_menu_url = $this->input->post('old_menu_url', TRUE);

        if ($menu_url != $old_menu_url) {
            $url_info = $this->get_single_url_information($old_menu_url);
            $this->update_url($url_info->url_id, $menu_url);
//            $url_info = $this->get_url_info_for_course_and_video_course($old_menu_url);
//            if ($url_info) {
//                $this->update_url($url_info->url_id, $menu_url);
//            } else {
//                $url_id = $this->input->post('url_id', TRUE);
//                $old_menu_info = $this->get_menu_info_by_url($old_menu_url);
//                $course_info = $this->course_model->get_single_public_course_by_menu_id($old_menu_info->menu_id);
//                if ($course_info) {
//                    $this->update_url($course_info->url_id, $menu_url);
//                    $this->update_url($url_id, $menu_url);
//                }
//                $video_course_info = $this->user_video_model->get_single_public_video_course_by_menu_id($old_menu_info->menu_id);
//                if ($video_course_info) {
//                    $this->update_url($video_course_info->url_id, $menu_url);
//                    $this->update_url($url_id, $menu_url);
//                }
//                if (!$course_info && !$video_course_info) {
//                    $this->update_url($url_id, $menu_url);
//                }
//            }
        }
    }

    function get_menu_info_by_url($url) {
        $sql = "SELECT * 
                FROM 
                    tbl_url AS u,
                    tbl_menu AS m 
                WHERE 
                    u.url = '$url'
                AND u.url_type = '1'    
                AND u.url_id = m.url_id";
        return $this->db->query($sql)->row();
    }

    /*
     * @Function            : get_url_info_for_course_and_video_course 
     * @Used IN             : @function-'update_menu_url'     this[@Model]
     * @Description         : get url information by course or video course URL
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-05-2016 11:15 AM 
     * @Parameter           : $old_menu_url[STRING]
     * @Return              : NULL      
     * @Status              : available      
     */

    function get_url_info_for_course_and_video_course($old_menu_url) {
        $sql = "SELECT * 
                FROM tbl_url AS u
                WHERE 
                    u.url = '$old_menu_url'
                AND u.url_type IN (5,8)";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : save_course_url 
     * @Used IN             : @function-'add_course'    super_admin_course[@Controller]
     * @Description         : save course URL
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 10:27 AM  
     * @Updated Date Time   : 14-07-2016 04:27 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $menu_id[INTEGER]
     * @Return              : $url_id[INTEGER]    
     * @Status              : Available        
     * */
    function save_course_url($menu_id) {
        if ($menu_id != '') {
            $menu_info = $this->super_admin_model->select_menu_by_id($menu_id);
            return $menu_info->url_id;
        } else {
            $course_url = $this->create_url($this->input->post('course_url', TRUE));
            return $this->save_url($course_url, 5);
        }
    }

    /**
     * @Function            : update_course_url_for_back_end 
     * @Used IN             : @function-'update_course_information'    super_admin_course_model[@Model]
     * @Description         : Update Course url information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-01-2016 10:27 AM  
     * @Updated Date Time   : 11-08-2016 04:12 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $menu_id[INTEGER]
     * @Return              : $url_id    
     * @Status              : Available        
     * */
    function update_course_url_for_back_end($menu_id, $data, $upload_dir) {
        $new_url_id = '';
        if ($menu_id != '') {
            if ($data['course_info']->url_type == 5) {
                $this->utility_model->delete_information_in_database('tbl_url', 'url_id', $data['course_info']->url_id);
            }
            $menu_info = $this->super_admin_model->select_menu_by_id($menu_id);
            $new_url_id = $menu_info->url_id;
        } else {
            if ($data['course_info']->url_type == 1) {
                $course_url = $this->create_url($this->input->post('edit_course_name', TRUE));
                $new_url_id = $this->save_url($course_url, 5);
            }
            if ($data['course_info']->url_type == 5) {
                $url_data['url'] = $this->input->post('course_url', TRUE);
                $this->utility_model->update_information_in_database('tbl_url', 'url_id', $data['course_info']->url_id, $url_data);
                $new_url_id = $data['course_info']->url_id;
            }
        }

        $type = '1,5';
        $url_info = $this->get_url_by_url_id($new_url_id, $type);
        if (is_dir($upload_dir)) {
            $new_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $url_info->url;
            if ($upload_dir != $new_dir) {
                rename($upload_dir, $new_dir);
            }
        }
        return $new_url_id;
    }

    /**
     * @Function            : assign_menu_url 
     * @Used IN             : @function-'save_course_information'      super_admin_course_model[@Model],
     * @Used IN             : @function-'update_course_information'    super_admin_course_model[@Model],
     * @Description         : assign menu url in course  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-05-2016 10:42 AM
     * @Parameter           : $course_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function assign_menu_url_in_course($course_id) {
        $course_info = $this->user_course_model->select_course_information_by_course_id($course_id);
        $menu_info = $this->super_admin_model->select_menu_by_id($course_info->menu_id);
        $this->url_model->update_url($course_info->course_url_id, $menu_info->url);
    }

    /**
     * @Function            : assign_menu_url_in_video_course 
     * @Used IN             : @function-'update_video_course_information'      super_admin_video_model[@Model],
     * @Used IN             : @function-'update_video_course_information'      super_admin_video_model[@Model],
     * @Description         : assign menu url in video course  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-05-2016 10:53 AM
     * @Parameter           : $video_course_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function assign_menu_url_in_video_course($video_course_id) {
        $video_course_info = $this->user_video_model->get_single_video_course_information_by_id($video_course_id);
        $menu_info = $this->super_admin_model->select_menu_by_id($video_course_info->menu_id);
        $this->url_model->update_url($video_course_info->video_course_url_id, $menu_info->url);
    }

    function update_url_for_assign_menu($url_id, $name) {
        $url1 = $this->create_url($name);
        $url = $this->check_url_exists($url1);
        $this->update_url($url_id, $url);
    }

    /**
     * @End
     * User Management
      ================
      Add/Edit User-> B
     */
    /**
      @Start
      Registration
      =============
     */
    /**
     * Date : 18-10-2016
      @Name: Ripon
      Work: save_person_url (front end- when new user registration)
      End : 18-01-2016
     */

    /**
     * @function            :save_person_url
     * @Used In             :function['index'] controller['sign_up']
     * @Description         :used to save person url
     * @Updated BY          :Tania Akter
     * @Updated Date        :24-05-2016
     * @Status              : Available 
     * 
     */
    function save_person_url() {
        $udata['url'] = preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('person_first_name', TRUE));
        if ($this->input->post('person_last_name', TRUE)) {
            $udata['url'] .= '-' . preg_replace('/[^A-Za-z0-9 -]/', '', $this->input->post('person_last_name', TRUE));
        }
        $url = $this->create_url($udata['url']);
        $url_forbidden = $this->check_forbidden_exists($url);
        if ($url_forbidden) {
            return $this->save_url($url_forbidden, 10);
        } else {
            return $this->save_url($url, 10);
        }
    }

    /* tania
     * @Function            : check_forbidden_exists 
     * @Used IN             : function[save_person_url] model[url_model]
     *                        function[make_org_teacher_url_existance] controller[add_teacher_organization]
     * @Description         : used to check url exist in tbl_forbidden
     * @parameter           : $profile_url (person url)
     * @Developed By        : Tania Akter
     * @Start DateTime      : 24-05-2016 5:43 AM
     * @Status              : available      
     */

    function check_forbidden_exists($profile_url) {
        $i = 0;
        do {
            $sql = "SELECT forbidden_name FROM tbl_forbidden  WHERE forbidden_name = '$profile_url' AND forbidden_type='1' ";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $profile_url .= ++$i;
            }
        } while ($result);
        return $profile_url;
    }

    /**
      @End
      Registration
      =============
     */
    /**
     * @Start
      Course
      Add Course/Edit Course -> Both F&B
      Add Course/Edit Course->Add/Change Teacher->F
      Add Category/Edit Category->Add/Change Category->F
     */

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'save_video_management_information'  User_video_model[@Model]
     * @Description         : save course category url  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-01-2016 01:38 PM     
     * @Status              : available      
     * */
    function create_course_category_url($course_category_name) {
        $url = $this->create_url($course_category_name);
        return $this->save_url($url, 3);
    }

    /**
     * @Function            : create_course_url 
     * @Used IN             : @function-'save_course_more_information'   user_course_model[@Model],
     * @Description         : save course url information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 04:51 PM
     * @Parameter           : $course_url[STRING]
     * @Return              : $url_id[INTEGER]           
     * @Status              : available      
     * */
    function create_course_url($course_url) {
        $url = $this->create_url($course_url);
        return $this->save_url($url, 5);
    }

    /**
     * @Function            : update_front_end_course_url 
     * @Used IN             : @function-'update_course_other_informtion'     user_course_model[@Model]
     * @Description         : update front course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-07-2016 02:47 PM  
     * @Parameter           : $person_url[STRING], $url_id[INTEGER], $odl_url[STRING], $new_url[STRING]
     * @Return              : Null    
     * @Status              : Available        
     * */
    function update_front_end_course_url($person_url, $url_id, $old_url, $new_url) {
        $create_url = $this->make_existence_url($this->create_url($new_url));
        $this->update_url($url_id, $create_url);

        $old_dir = 'content-library/' . $person_url . '/my-work-file/' . $old_url;
        $new_dir = 'content-library/' . $person_url . '/my-work-file/' . $create_url;
        if (is_dir($old_dir)) {
            rename($old_dir, $new_dir);
        }
    }

    /**
     * @Function            : save_video_course_url 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Save url in DB 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 02:02 PM   
     * @Status              : available      
     * */
    function save_video_course_url() {
        $video_url = $this->input->post('video_course_url', TRUE);
        return $this->save_url($video_url, 8);
    }

    /**
     * @Function            : update_video_course_url 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Save url in DB 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 07:23 PM   
     * @Status              : available      
     * */
    function update_video_course_url($url_id, $new_url) {
        $this->update_url($url_id, $new_url);
    }

    /**
     * @Function            : create_classroom_url 
     * @Used IN             : @function-'save_classroom_information'      classroom_model[@Model]
     * @Description         : save classroom URL
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-01-2016 01:38 PM          
     * @Status              : available      
     * */
    function create_classroom_url($classroom_title) {
        $url = $this->create_url($classroom_title);
        return $this->save_url($url, 11);
    }

    /**
     * @Function            : update_classroom_url 
     * @Used IN             : @function-'save_update_classroom_url'   classroom[@controller],
     * @Description         : update_classroom_url (front end- when user create course)
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 10-01-2016 01:38 PM    
     * @Status              : available      
     * */
    function update_classroom_url($url_id, $url) {
        $url1 = $this->create_url($url);
        $url2 = $this->check_url_exists($url1);
        $this->update_url($url_id, $url2);
        return $url2;
    }

    /**
     * @start
     * User Management
      ================
      group
     */

    /**
     * @Function            : add_user_url 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Save url in DB 
     * @Developed By        :afrin jahan noumin
     * @Start DateTime      : 18-01-2016 10:02 PM   
     * @Status              : available      
     * */
    public function save_group_url() {
        $group_url = $this->input->post('group_url', TRUE);
        return $this->save_url($group_url, 2);
    }

    /**
     * @Function            : create_resource_person_url 
     * @Used IN             : @function-'save_person_info_for_resource_person'       resource_person_model[@Model]
     * @Description         : Create resource person URL
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-09-2016 12:28 PM      
     * @Parameter           : $person_first_name[STRING]
     * @Return              : $url_id[INTEGER]        
     * @Status              : available      
     * */
    function create_resource_person_url($person_first_name) {
        $url = $this->create_url($person_first_name);
        $this->create_folder($url);
        return $this->save_url($url, 10);
    }

    /**
     * Function             : create_teacher_url_for_organization
     * Description          : used to create url for org teacher 
     * Used In              : function[save_teacher_information_by_organization] model[add_teacher_organization_model]
     * Developed By         : Ripon
     * Srtart Date          : Unknown
     * parameter            : $url1(person url) 
     * return               : $data(array contain url id)
     * status               : available
     */
    function create_teacher_url_for_organization($url1) {
        $url = $this->create_url($url1);
        $this->create_folder($url);
        $check_url = $this->check_forbidden_exists($url);
        $data['url_id'] = $this->save_url($check_url, 10);
        $data['url'] = $url;
        return $data;
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_teacher_url_for_organization (front end- when user create teacher)
      End : 19-01-2016
     */
    function update_teacher_url_for_organization($url_id, $profile_url, $old_url) {
        $url = $this->create_url($profile_url);
        $this->update_url($url_id, $url);

        if (file_exists($old_url)) {
            rename('./content-library/' . $old_url, './content-library/' . $url);
            $data['person_last_change_url_date'] = date('Y-m-d', time() - $this->session->userdata('time_offset'));
        }
        $data['url_id'] = $url_id;
        $data['url'] = $url;
        return $data;
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_group_url (front end- when user create Group)
      End : 19-01-2016
     */
    function create_group_url($url) {
        $url1 = $this->create_url($url);
        return $this->save_url($url1, 2);
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_group_url (front end- when user create Group)
      End : 19-01-2016
     */
    function update_group_url($url_id, $url) {
        $url1 = $this->create_url($url);
        return $this->update_url($url_id, $url1);
    }

    /**
     * Date : 29-02-2016
      @Name: Mahabub-A-Mawla
      Work: create_topic_url (front end- when user create Quiz, from back end when super-admin/admin add topic)
      End : 29-02-2016
     */
    function create_topic_url($url) {
        $url1 = $this->create_url($url);
        return $this->save_url($url1, 13);
    }

    /**
     * Date : 29-02-2016
      @Name: Mahabub-A-Mawla
      Work: update_topic_url (front end- when user create Quiz, from back end when super-admin/admin edit topic)
      End : 29-02-2016
     */
    function update_topic_url($url_id, $url) {
        $url1 = $this->create_url($url);
        $this->update_url($url_id, $url1);
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_quiz_url (front end- when user create Quiz)
      End : 19-01-2016
     */
    function create_quiz_url($url) {
        $url1 = $this->create_url($url);
        return $this->save_url($url1, 4);
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_quiz_url (front end- when user create Quiz)
      End : 19-01-2016
     */
    function update_quiz_url($url_id, $url) {
        $url1 = $this->create_url($url);
        $this->update_url($url_id, $url1);
    }

    /**
     * @Function            : update_user_password 
     * @Used IN             : @function-'save_video_course_information1'      user_video_model[@Model] - [99]
     * @Description         : save video course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-10-2016 09:55 AM  
     * @Parameter           : $url[STRING]
     * @Return              : $url_id[INTEGER]    
     * @Status              : Available        
     * */
    function save_vedio_url($url) {
        $url1 = $this->create_url($url);
        return $this->save_url($url1, 8);
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: save_vedio_url (front end- when user create vedio)
      End : 19-01-2016
     */
    function update_video_url($url_id, $url) {
        $url1 = $this->create_url($url);
        $this->update_url($url_id, $url1);
    }

    /**
     * Date : 19-10-2016
      @Name: Ripon
      Work: create_quiz_url (front end- when user create Quiz)
      End : 19-01-2016
     */
    function update_vedio_url($url_id, $url) {
        $url1 = $this->create_url($url);
        $this->update_url($url_id, $url1);
    }

    /**
     * @End
      Course
      Add Course/Edit Course -> Both F&B
      Add Course/Edit Course->Add/Change Teacher->F
      Add Category/Edit Category->Add/Change Category->F
     */

    /**
      Date :
     * Function             : create_folder
     * Used In              : Function[create_teacher_url_for_organization] model[url_model]
     * Description          : used to create folder 
     * parameter            : $profile_url
     * Developed By         : Ripon
     * Date                 : 18-01-2016
     */
    public function create_folder($profile_url) {
        if (!file_exists('content-library/' . $profile_url)) {
            $folder_Data = array('assignment-file', 'my-image', 'my-video', 'my-work-file', 'tt-content');
            for ($i = 0; $i < count($folder_Data); $i++) {
                $folder = 'content-library/' . $profile_url . '/' . $folder_Data[$i] . '/';
                mkdir($folder, 0777, true);
            }
        }
    }

    /**
     * @Function            : create_url 
     * @Description         : create url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 04:47 PM
     * @Parameter           : $name[STRING]
     * @Return              : $created_url[STRING]    
     * @Status              : Available       
     * */
    public function create_url($name) {
        $string6 = '';
        $string = strtolower($name); //Make alphanumeric (removes all other characters)
        $string1 = preg_replace("/[^a-z0-9_\s-]/", "", $string); //Clean up multiple dashes or whitespaces
        $string2 = preg_replace("/[\s-]+/", " ", $string1); //Convert whitespaces and underscore to dash
        $string3 = preg_replace("/[\s_]/", "-", $string2);
        $string4 = preg_replace("/[-]+/", "-", $string3);

        if (substr($string4, 0, 1) == "-") {
            $string5 = substr_replace($string4, '', 0, 1);
        } else {
            $string5 = $string4;
        }

        if (substr($string5, -1) == '-') {
            $string6 = substr_replace($string5, '', (strlen($string5) - 1), (strlen($string5)));
        } else {
            $string6 = $string5;
        }
        return $string6;
    }

    /**
     * @Function            : update_url 
     * @Used IN             : @function-'update_video_course_url'  this[@Model],
     * @Description         : Update URL
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-01-2016 01:38 PM      
     * @Status              : available      
     * */
    public function update_url($url_id, $url) {
        $this->db->set('url', $url);
        $this->db->where('url_id', $url_id);
        $this->db->update('tbl_url');
    }

    /**
      Date : 19-01-2016
      @Name: Ripon
      Work: update_url
      Update : 19-01-2016
     */
    public function set_url_in_session($url) {
        $sdata['profile_id'] = $sdata['view_person_url'] = $url;
        $this->session->set_userdata($sdata);
    }

    /**
      Date : 20-01-2016
      @Name: Ripon
      Work: update_person_info
      Update : 20-01-2016
     */
    public function update_person_info($user_id) {
        $person_last_change_url_date = date('Y-m-d', time() - $this->session->userdata('time_offset'));
        $this->db->set('person_last_change_url_date', $person_last_change_url_date);
        $this->db->where('person_id', $user_id);
        $this->db->update('tbl_person');
    }

    /**
     * @Function            : check_url_exists
     * @Used IN             : @function-'check_video_course_url_exists'     super_admin_video[@controller],
     * @Description         : Check URL if it exists  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 01:56 PM
     * @Updated Date Time   : 07-09-2016 04:03 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $profile_url[STRING]
     * @Return              : $profile_url[STRING]  
     * @Status              : available      
     * */
    public function check_url_exists($profile_url) {
        $i = 0;
        do {
            $result = $this->db->select('*')->get_where('tbl_url', array('url' => $profile_url))->row();
            if ($result) {
                $profile_url .= ++$i;
            }
        } while ($result);
        return $profile_url;
    }

    /**
     * @Function            : check_url_exists1 
     * @Used IN             : @function-'check_video_course_url_exists'     user_video[@controller]
     * @Description         : Check URL if it exists  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 01:38 PM
     * @Updated Date Time   : 07-06-2016 04:03 PM
     * @Updated by          : Afrin jahan noumin
     * @Parameter           : $profile_url[STRING]
     * @Return              : 1/2    
     * @Status              : available      
     * */
    public function check_url_exists1($profile_url) {
        $result = $this->db->select('*')->get_where('tbl_url', array('url' => $profile_url))->row();
        if ($result) {
            return 1; // 1 for exits url
        } else {
            return 2; // 2 for not exits
        }
    }

    /**
     * @Function            : save_url 
     * @Used IN             : @function-'save_video_course_url'  super_admin_video[@controller],
     *                        function ['save_person_url'] model['url_model']
     * @Description         : Save url in DB 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-01-2016 10:02 PM   
     * @Parameter           : $profile_url[STRING], $type[INTEGER]
     * @Return              : $url_id[INTEGER]
     * @Status              : available      
     * */
    public function save_url($profile_url, $type) {
        $url_data['url'] = $this->make_existence_url($profile_url);
        $url_data['url_type'] = $type;
        return $this->utility_model->save_information_in_database('tbl_url', $url_data);
    }

    /**
     * @Function            : get_url_by_url_id 
     * @Description         : get url information by url ID and type
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-05-2016 03:06 PM   
     * @Parameter           : $url_id[INTEGER], $type[INTEGER]
     * @Return              : $url_info[ARRAY]    
     * @Status              : available      
     * */
    function get_url_by_url_id($url_id, $type) {
        $sql = "SELECT * FROM tbl_url AS u WHERE u.url_id = '$url_id' AND u.url_type IN ($type)";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_forbidden_url_exists 
     * @Description         : check forbidden url exists
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-05-2016 04:19 PM
     * @Parameter           : $url[STRING], $type[INTEGER]
     * @Return              : $forbidden_url_data[ARRAY]    
     * @Status              : Available       
     * */
    function check_forbidden_url_exists($url, $type) {
        $this->db->select('*')->from('tbl_forbidden')
                ->where('forbidden_name', $url)
                ->where_in('forbidden_type', explode(',', $type));
        return $this->db->get()->row();
    }

    /**
     * @Function            : make_forbidden_url 
     * @Description         : make forbidden url 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 01:14 PM
     * @Parameter           : $url[STRING], $type[INTEGER]
     * @Return              : $new_forbidden_url[STRING] 
     * @Status              : Available       
     * */
    function make_forbidden_url($url, $type) {
        $i = 0;
        do {
            $result = $this->check_forbidden_url_exists($url, $type);
            if ($result) {
                $url .= ++$i;
            }
        } while ($result);
        return $url;
    }

    /**
     * @Function            : make_existence_url
     * @Description         : make url if existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 02:43 PM
     * @Parameter           : $url[STRING]
     * @Return              : $url[STRING] 
     * @Status              : Available       
     * */
    function make_existence_url($url) {
        $type = '1,2,3,4';
        $url1 = $this->check_url_exists($url);
        return $this->make_forbidden_url($url1, $type);
    }

    /**
     * @Function            : check_url_existence
     * @Description         : check url existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-07-2016 03:56 PM
     * @Parameter           : $url[STRING]
     * @Return              : $url[STRING] 
     * @Status              : Available       
     * */
    function check_url_existence($url) {
        $result = $this->check_url_exists1($url);

        if ($result == 2) { // if url does not exists them check forbidden url
            $type = '1,2,3,4';
            $result1 = $this->check_forbidden_url_exists($url, $type);
            if ($result1) {
                return 1;  // 1 for exits url
            } else {
                return 2; // 2 for exits url
            }
        } else {
            return $result;
        }
    }

    // this will be delete after complete course/video course

    /**
     * Date : 18-10-2016
      Name: Ripon
      Work: save_course_category_url (back end)
      End : 18-01-2016
     */
    function save_course_category_url() {
        $course_category_url = $this->input->post('course_category_url', TRUE);

        $url_data['url'] = $course_category_url;
        $url_data['url_type'] = 3;
        $this->db->insert('tbl_url', $url_data);
        return $this->db->insert_id();
    }

    /**
     * Date : 18-10-2016
      Name: Ripon
      Work: update_course_category_url (back end)
      End : 18-01-2016
     */
    function update_course_category_url($course_category_url) {
        $url_id = $this->input->post('old_url_id', TRUE);
        $this->db->set('url', $course_category_url);
        $this->db->where('url_id', $url_id);
        $this->db->update('tbl_url');
    }

    /**
     * @Function            : course_creator_url
     * @Description         : get_course_creator_url_by_course_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 11:18 AM
     * @Parameter           : $course_id
     * @Return              : $course_creator_url    
     * @Status              : Available        
     * */
    function course_creator_url($course_id) {
        return $this->db->select('u.url')->from('tbl_course AS c')
                        ->join('tbl_person AS p', 'c.person_id = p.person_id')
                        ->join('tbl_url AS u', 'p.url_id = u.url_id')
                        ->where('c.course_id', $course_id)->get()->row()->url;
    }

    private $url;

    function set_url($url) {
        $this->url = $url;
        return $this;
    }

    function check_url() {
        $this->url = $this->create_url($this->url);
        $this->url = $this->make_existence_url($this->url);
        return $this;
    }

    private $type;

    function set_type($type) {
        $this->type = $type;
        return $this;
    }

    function save() {
        $data = [];
        $data['url'] = $this->url;
        $data['url_type'] = $this->type;
        $this->db->insert(self::tbl_name, $data);
        return $this;
    }

    private $url_id;

    function create_insert_id() {
        $this->url_id = $this->db->insert_id();
        return $this;
    }

    function get_id() {
        return $this->url_id;
    }

    function get_url() {
        return $this->url;
    }

}
