<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of topic_model
 *
 * @author Md Jaherul Islam
 */
class Topic_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : save_topic_info 
     * @Used IN             : @function-'add_topic'     admin_topic[@controller],
     * @Description         : save topic information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 11:33 AM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : available      
     * */
    function save_topic_info() {
        $data = ArraY();
        $data['person_id'] = $this->session->userdata('person_id');
        $data['topic_name'] = $this->input->post('topic_name', TRUE);

        $parent_topic_id = $this->input->post('parent_topic_id', TRUE);
        $data['parent_topic_id'] = $parent_topic_id != '' ? $parent_topic_id : 0;
        $data['topic_status'] = $this->input->post('topic_status', TRUE);
        $this->db->insert('tbl_topic', $data);
    }

    /**
     * @Function            : update_topic_info 
     * @Used IN             : @function-'edit_topic'     admin_topic[@controller],
     * @Description         : update topic information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 06:31 PM
     * @Parameter           : $topic_id[INTEGER]
     * @Return              : NULL    
     * @Status              : available      
     * */
    function update_topic_info($topic_info) {
        $data = ArraY();
        $data['person_id'] = $topic_info->person_id;
        $data['topic_name'] = $this->input->post('topic_name', TRUE);

        $parent_topic_id = $this->input->post('parent_topic_id', TRUE);
        $data['parent_topic_id'] = $parent_topic_id != '' ? $parent_topic_id : 0;
        $data['topic_status'] = $this->input->post('topic_status', TRUE);
        $this->utility_model->update_information_in_database('tbl_topic', 'topic_id', $topic_info->topic_id, $data);
    }

    /**
     * @Function            : select_all_topic 
     * @Used IN             : @function-'add_topic'        admin_topic[@controller],
     * @                    : @function-'manage_topic'     admin_topic[@controller],
     * @Description         : select all topic
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 11:49 AM
     * @Parameter           : NULL
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function select_all_topic($topic_status) {
        $sql = "SELECT * 
                FROM tbl_topic AS t
                WHERE t.topic_status IN ($topic_status)";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_parent_topic_info 
     * @Used IN             : @function-'manage_topic'                       admin_topic[@controller],
     * @Used IN             : @function-'get_informaton_for_edit_course'     super_admin_course[@controller],
     * @Description         : select topic information by topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 12:58 PM
     * @Parameter           : $topic_id[INTEGER]
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function select_topic_info_by_topic_id($topic_id) {
        //$sql = "SELECT * FROM tbl_topic AS t WHERE t.topic_id = '$topic_id'";
        //return $this->db->query($sql)->row();        
        $result = $this->db->select('*')->from('tbl_topic')
                           ->where('topic_id', $topic_id)
                           ->get()->row();
        return $result;
    }

    /**
     * @Function            : select_active_topic_info_by_topic_id 
     * @Used IN             : @function-'select_all_parent_topic_id_if_child'     this[@Model]
     * @Description         : select active topic information by multiple topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 12:58 PM
     * @Updated Date Time   : 07-09-2016 03:31 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $topic_id[STRING]
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function select_active_topic_info_by_topic_id($topic_id) {
        $this->db->select('*')
                ->from('tbl_topic')
                ->where_in('topic_id', explode(',', $topic_id))
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->result();
    }

    /**
     * @Function            : select_all_parent_topic 
     * @Used IN             : @function-'add_topic'     admin_topic[@controller],
     * @Description         : select all parent topic
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 02:58 PM
     * @Parameter           : Null
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function select_all_parent_topic($topic_id = NULL) {
        $sql = "SELECT * 
                FROM tbl_topic AS t 
                WHERE t.parent_topic_id = '0' AND t.topic_status IN (1,5)";
        if ($topic_id != NULL) {
            $sql.= " AND t.topic_id != '$topic_id'";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_concat_parent_topic_id 
     * @Used IN             : @function-''     admin_topic[@controller],
     * @Description         : get all concat parent topic parent topic
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-09-2016 05:23 PM
     * @Parameter           : Null
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function get_concat_parent_topic_id($status) {
        return $this->db->select('GROUP_CONCAT(topic_id) AS topic_id')
                        ->from('tbl_topic')->where('parent_topic_id', 0)
                        ->where_in('topic_status', explode(',', $status))->get()->row()->topic_id;
    }

    /**
     * @Function            : select_all_parent_topic_id_if_child 
     * @Used IN             : @function-'get_informaton_for_add_course'     super_admin_course_model[@Model]
     * @Description         : select all parent ID if there is remaining child topic
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 06:38 PM
     * @Parameter           : Null
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function select_all_parent_topic_id_if_child() {
        $topic_id = $this->get_concat_parent_topic_id_if_child();
        return $this->select_active_topic_info_by_topic_id($topic_id);
    }

    /**
     * @Function            : select_all_parent_topic_with_child 
     * @Used IN             : @function-'get_informaton_for_add_course'     super_admin_course_model[@Model]
     * @Description         : select concat parent ID if there is remaining child topic
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 06:38 PM
     * @Updated Date Time   : 07-09-2016 03:23 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : Null
     * @Return              : $parent_topic_id[STRING]    
     * @Status              : available      
     * */
    function get_concat_parent_topic_id_if_child() {
        $this->db->select('GROUP_CONCAT(DISTINCT(parent_topic_id))  AS parent_topic_id')
                ->from('tbl_topic')
                ->where("parent_topic_id != '0'")
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->row()->parent_topic_id;
    }

    /**
     * @Function            : get_all_child_topic_by_parent_topic_id 
     * @Used IN             : @function-'view_child_topic'     super_admin_course[@controller]
     * @Description         : select all child topic by parent toic ID
     * @                    : @Update1-> Convert Active query
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 06:09 PM
     * @Updated Date Time   : 07-09-2016 04:18 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $parent_topic_id[INTEGER]
     * @Return              : $all_topic[Data]    
     * @Status              : available      
     * */
    function get_all_child_topic_by_parent_topic_id($parent_topic_id, $person_id = '') {
        $this->db->select('*')->from('tbl_topic')->where('parent_topic_id', $parent_topic_id)
                ->where_in('topic_status', Array(1, 5));
        if ($person_id) {
            $this->db->or_where("person_id = '$person_id' AND parent_topic_id = '$parent_topic_id' AND topic_status IN (2,3,4)");
        }
        return $this->db->get()->result();
    }

    /**
     * @Function            : get_all_child_topic_by_parent_topic_id 
     * @Used IN             : @function-'change_topic_status'     admin_topic[@controller],
     * @Description         : select concat child topic by parent topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 02:58 PM
     * @Parameter           : $parent_topic_id[INTEGER]
     * @Return              : $all_topic_id[String]    
     * @Status              : available      
     * */
    function get_all_concat_child_topic_by_parent_topic_id($parent_topic_id) {
        return $this->db->select('GROUP_CONCAT(topic_id) AS all_topic_id')
                        ->from('tbl_topic')->where_in('parent_topic_id', explode(',', $parent_topic_id))
                        ->get()->row()->all_topic_id;
    }

    /**
     * @Function            : check_topic_name 
     * @Used IN             : @function-'check_topic_name'     admin_topic[@controller],
     * @Description         : check topic name existence
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 20-07-2016 03:52 PM
     * @Parameter           : $parent_topic_id[INTEGER], $topic_name[STRING]
     * @Return              : $topic_data[ARRAY]    
     * @Status              : available      
     * */
    function check_topic_name($topic_id, $parent_topic_id, $topic_name) {
        $sql = "SELECT * FROM tbl_topic AS t ";
        if ($parent_topic_id != '0') {
            $sql.=" WHERE (LOWER(t.topic_name) = '$topic_name' AND t.parent_topic_id = '0') "
                    . "OR (LOWER(t.topic_name) = '$topic_name' AND t.parent_topic_id = '$parent_topic_id')";
            if ($topic_id != '0') {
                $sql.=" AND t.topic_id != '$topic_id'";
            }
        } else {
            $sql.=" WHERE LOWER(t.topic_name) = '$topic_name'";
            if ($topic_id != '0') {
                $sql.=" AND t.topic_id != '$topic_id'";
            }
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : change_topic_status 
     * @Used IN             : @function-'change_topic_status'     admin_topic[@controller],
     * @Description         : change topic status
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-07-2016 01:10 PM
     * @Parameter           : $topic_id[INTEGER], $status[STRING]
     * @Return              : NULL 
     * @Status              : available      
     * */
    function change_topic_status($topic_id, $status) {
        $data = Array();
        if ($status == 'Delete') {
            $all_topic_id = $this->get_all_concat_child_topic_by_parent_topic_id($topic_id);
            if ($all_topic_id != '') {
                $this->utility_model->delete_multiple_field_in_table('tbl_topic', 'topic_id', $all_topic_id);
            }
            $this->utility_model->delete_information_in_database('tbl_topic', 'topic_id', $topic_id);
        } else {
            switch ($status) {
                case 'Active': $data['topic_status'] = 1;
                    break;
                case 'Inactive': $data['topic_status'] = 2;
                    break;
                case 'Archive': $data['topic_status'] = 3;
                    break;
                case 'Pending': $data['topic_status'] = 4;
                    break;
                case 'Approve': $data['topic_status'] = 5;
                    break;
            }
            $this->utility_model->update_information_in_database('tbl_topic', 'topic_id', $topic_id, $data);
        }
    }

    /**
     * @Function            : save_other_topic 
     * @Used IN             : @function-'save_course_information'       user_course_model[@Model]
     * @Used IN             : @function-'update_course_information'     user_course_model[@Model]
     * @Description         : save topic if user select other
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-07-2016 10:56 AM
     * @Parameter           : $person_id[INTEGER],$topic_id[INTEGER]
     * @Return              : $topic_id[INTEGER] 
     * @Status              : available      
     * */
    function save_other_topic($person_id, $parent_topic_id, $topic_id) {
        if ($topic_id == 'other') {
            $topic_data['person_id'] = $person_id;
            $topic_data['parent_topic_id'] = $parent_topic_id;
            $topic_data['topic_name'] = $this->input->post('other_topic_name', TRUE);
            $topic_data['topic_status'] = 4;
            return $this->utility_model->save_information_in_database('tbl_topic', $topic_data);
        } else {
            return $topic_id;
        }
    }

    /**
     * @Function            : get_course_assign_parent_topic_info 
     * @Used IN             : @function-'get_course_left_sidebar_data'       course_model[@Model]
     * @Description         : Get course assign parent topic information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 17-08-2016 11:30 AM
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function get_course_assign_parent_topic_info() {
        $parent_topic_id = $this->course_assign_concat_parent_topic_id();
        if ($parent_topic_id != '') {
            return $this->select_active_topic_info_by_topic_id($parent_topic_id);
        } else {
            return Array();
        }
    }

    /**
     * @Function            : course_assign_concat_parent_topic_id 
     * @Used IN             : @function-'get_course_left_sidebar_data'       course_model[@Model]
     * @Description         : Get course assign parent topic concat ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 17-08-2016 11:30 AM
     * @Parameter           : Null
     * @Return              : $parent_topic_id
     * @Status              : available      
     * */
    function course_assign_concat_parent_topic_id($arg = '') {
        $sql = "SELECT GROUP_CONCAT(DISTINCT(t.parent_topic_id)) AS topic_id
                FROM tbl_course AS c, tbl_topic AS t
                WHERE c.topic_id = t.topic_id";
        if ($arg == '') {
            $sql.=" AND c.course_status IN (1,4) AND t.topic_status IN (1,5)";
        }
        return $this->db->query($sql)->row()->topic_id;
    }

    /**
     * @Function            : get_course_assign_child_topic_info_by_topic_id 
     * @Used IN             : @function-'get_course_left_sidebar_data'       course_model[@Model]
     * @Description         : Get course assign child topic info by topic id
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 17-08-2016 12:07 AM
     * @Parameter           : $topic_id[INTEGER]
     * @Return              : $topic_info[ARRAY]
     * @Status              : available      
     * */
    function get_course_assign_child_topic_info_by_topic_id($topic_id, $status, $limit = '') {
        $sql = "SELECT * 
                FROM tbl_topic AS t,tbl_course AS c
                WHERE t.parent_topic_id IN ($topic_id) AND t.topic_status IN ($status)
                AND t.topic_id = c.topic_id AND c.course_status IN (1,4) GROUP BY t.topic_id";
        if ($limit != '') {
            $sql.= " LIMIT $limit,3";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_course_assign_concat_child_topic_info_by_topic_id 
     * @Used IN             : @function-'view_all_courses'       course[@Controller]
     * @Description         : Get course assign concat child topic info by topic id
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-08-2016 10:36 AM
     * @Parameter           : $topic_id[INTEGER],$status
     * @Return              : $topic_info[ARRAY]
     * @Status              : available      
     * */
    function get_course_assign_concat_child_topic_info_by_topic_id($topic_id, $status) {
        $topic_id_array = ArraY();
        $topic_info = $this->get_course_assign_child_topic_info_by_topic_id($topic_id, $status);

        foreach ($topic_info as $value) {
            $topic_id_array[] = $value->topic_id;
        }
        return $topic_id_array;
    }

    /**
     * @Function            : get_all_concat_child_topic 
     * @Used IN             : @function-''       course[@Controller]
     * @Description         : Get all concat child topic 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-09-2016 04:33 PM
     * @Parameter           : Null
     * @Return              : $topic_id
     * @Status              : available      
     * */
    function get_all_concat_child_topic() {
        return $this->db->select('GROUP_CONCAT(topic_id) AS topic_id')
                        ->from('tbl_topic')->where('parent_topic_id != 0')->get()->row()->topic_id;
    }

    /**
     * @Function            : get_all_course_assign_topic 
     * @Used IN             : @function-''       course[@Controller]
     * @Description         : Get all Course assign concat child topic 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-09-2016 04:42 PM
     * @Parameter           : Null
     * @Return              : $topic_id
     * @Status              : available      
     * */
    function get_all_course_assign_topic() {
        return $this->db->select('GROUP_CONCAT(DISTINCT topic_id) AS topic_id')
                        ->from('tbl_course')->where_in('course_status', Array(1, 4))->get()->row()->topic_id;
    }

    /**
     * @Function            : get_inactive_and_deleted_child_topic_id 
     * @Used IN             : @function-''       course[@Controller]
     * @Description         : Get all inactive and delete child topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-09-2016 05:49 PM
     * @Parameter           : Null
     * @Return              : $topic_id
     * @Status              : available      
     * */
    function get_inactive_and_deleted_child_topic_id() {
        $status = '2,3,4';
        $delete_child_topic = array_diff(explode(',', $this->topic_model->get_all_course_assign_topic()), explode(',', $this->topic_model->get_all_concat_child_topic()));
        $inactive_parent_id = $this->topic_model->get_concat_parent_topic_id($status);
        $parent_id_by_inactive_child = Array();
        $parent_topic = $this->topic_model->select_all_parent_topic();
        if ($parent_topic) {
            foreach ($parent_topic AS $value) {
                $child_topic_info = $this->topic_model->get_all_child_topic_by_parent_topic_id($value->topic_id);
                if (!$child_topic_info) {
                    $parent_id_by_inactive_child[] = $value->topic_id;
                }
            }
        }
        $inactive_parent_id_array = ($inactive_parent_id != '') ? explode(',', $inactive_parent_id) : Array();
        $all_inactive_parent_id = implode(',', array_unique(array_merge($parent_id_by_inactive_child, $inactive_parent_id_array)));
        $inactive_child_id = ($all_inactive_parent_id == '') ? '' : $this->get_all_concat_child_topic_by_parent_topic_id($all_inactive_parent_id);
        return array_filter(array_unique(array_merge(explode(',', $inactive_child_id), $delete_child_topic)));
    }

}
