<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of tinymce_model
 *
 * @author MD Jaherul Islam
 */
class Tinymce_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : get_tinymce_description
     * @Used IN             : @function-'save_course_information'  user_course_model[@Model] 
     * @                    : @function-'update_course_all_tinymce_information_for_url_non_existence'  user_course_model[@Model] 
     * @Description         : get tinymce description with uploading all kind of file
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 09:54 AM 
     * @Parameter           : $id[INTEGER](Course id/Video Course Id/Quiz ID.....), 
     *                        $upload_dir[STRING](which directory uploaded in tinymce file), 
     *                        $description[STRING](Tinymce description with all files), 
     *                        $type[INTEGER](Which type - Course/Video Course/Quiz.....), 
     *                        $find_path[STRING](In this System tinymce find file with specific pathe such AS - source/content-library....)
     * @Return              : $description[STRING] (Return tinymce description after uploading all kind of file)           
     * @Status              : available      
     * */
    function get_tinymce_description($id, $upload_dir, $description, $type, $find_path) {
        $href_match = Array(); // all hiperlink file remain in this Array
        $src_match = Array(); // all Source file remain in this Array
        preg_match_all('@href="([^"]+)"@', $description, $href_match); // if matched any "href" file than push "$href_match" Array 
        preg_match_all('@src="([^"]+)"@', $description, $src_match); // if matched any "src" file than push "$src_match" Array

        if ($src_match[1]) { // if found any "src" file
            if (!is_dir($upload_dir)) { // does not remaining content folder for tinymce file
                mkdir($upload_dir, 0777, true); // Create a folder by uploaded url
            }
            // save tinymce source file in content library and upload file in "$upload_dir"
            $description = $this->save_tinymce_source_file($id, $src_match[1], $description, $upload_dir, $type, $find_path);
        }

        if ($href_match[1]) { // if found any "href" file
            if (!is_dir($upload_dir)) {// does content folder for tinymce file
                mkdir($upload_dir, 0777, true); // Create a folder by uploaded url
            }
            // save tinymce hiperlink file in content library and upload file in "$upload_dir"
            $description = $this->save_tinymce_hyperlink_file($id, $href_match[1], $description, $upload_dir, $type, $find_path);
        }
        return $description;
    }

    /**
     * @Function            : save_tinymce_source_file 
     * @Used IN             : @function-'get_tinymce_description'      this[@Model]  
     * @Description         : save tinymce source file in content library and upload file in "$upload_dir"
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 10:20 AM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....), 
     *                        $src_match[ARRAY] (All "src" file AS ARRAY)
     *                        $description[STRING](Tinymce description with all files), 
     *                        $upload_dir[STRING](which directory uploaded in tinymce file), 
     *                        $type[INTEGER](Which type - Course/Video Course/Quiz.....),  
     *                        $find_path[INTEGRE] (In this System tinymce find file with specific pathe such AS - source/content-library....)
     * @Return              : $description[STRING] (Return tinymce description after uploading all "src" file)                
     * @Status              : available      
     * */
    function save_tinymce_source_file($id, $src_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($src_match); $i++) { // Running loop based of $src file Array
            $main_full_path = urldecode($src_match[$i]); // Remove all "%20" From String"
            if (preg_match("/$find_path/", $main_full_path)) {  // if file path matched into System "$find_path" Such as - source/content-library....
                $main_full_path_array = explode('?', $main_full_path); // if upload any image in then add extra "?" in "src" file
                $cut_string_array = explode($find_path, $main_full_path_array[0]); // Explode file path with "$find_path" 
                $main_file_path = $find_path . $cut_string_array[1]; // concat $find_path with main src file
                if (is_file($main_file_path)) { // check if in this path content any file
                    // save tinymce file in content library and upload file in "$upload_dir"
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 3);
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : save_tinymce_source_file 
     * @Used IN             : @function-'get_tinymce_description'      this[@Model]  
     * @Description         : save tinymce source file in content library and upload file in "$upload_dir"
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 10:20 AM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....), 
     *                        $href_match[ARRAY] (All "href" file AS ARRAY)
     *                        $description[STRING](Tinymce description with all files), 
     *                        $upload_dir[STRING](which directory uploaded in tinymce file), 
     *                        $type[INTEGER](Which type - Course/Video Course/Quiz.....),  
     *                        $find_path[INTEGRE] (In this System tinymce find file with specific pathe such AS - source/content-library....)
     * @Return              : $description[STRING] (Return tinymce description after uploading all "src" file)                
     * @Status              : available      
     * */
    function save_tinymce_hyperlink_file($id, $href_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($href_match); $i++) { // Running loop based of $src file Array
            $main_full_path = urldecode($href_match[$i]); // Remove all "%20" From String"
            if (preg_match("/$find_path/", $main_full_path)) { // if file path matched into System "$find_path" Such as - source/content-library....
                $cut_string_array = explode($find_path, $main_full_path); // Explode file path with "$find_path" 
                $main_file_path = $find_path . $cut_string_array[1]; // concat $find_path with main src file
                if (is_file($main_file_path)) { // check if in this path content any file
                    // save tinymce file in content library and upload file in "$upload_dir"
                    $count = 3; // upload file from 'source' Directory
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, $count);
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : upload_tinymc_file 
     * @Used IN             : @function-'save_tinymce_source_file'           this[@Model]  
     * @                    : @function-'save_tinymce_hyperlink_file'        this[@Model]  
     * @                    : @function-'update_tinymce_source_file'         this[@Model]  
     * @                    : @function-'update_tinymce_hyperlink_file'      this[@Model]  
     * @Description         : save tinymce file in content library and upload file in "$upload_dir"
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 11:07 AM 
     * @Parameter           : $id (Course id/Video Course Id/Quiz ID.....), 
     *                        $description (Tinymce description with all files), 
     *                        $main_full_path (full uploaded file path with root), 
     *                        $main_file_path (full uploaded file path without root), 
     *                        $upload_dir (which directory uploaded in tinymce file), 
     *                        $type (Which type - Course/Video Course/Quiz.....), 
     *                        $count [if File get FROM 'source' OR 'content-library' then check how manu 'SLASH' their have]
     * @Return              : $description[STRING] (Return tinymce description after uploading all file)              
     * @Status              : available      
     * */
    function upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, $count) {
        $path_array = explode('/', $main_file_path); // explode file path if found any slash
        $file_name = $path_array[count($path_array) - 1]; // get file name
        $file_path = '';

        if (count($path_array) > $count) { // if file uploaded in multiple folder
            for ($i = 1; $i <= (count($path_array) - $count); $i++) { // looping based on folder directory
                $upload_dir.='/' . $path_array[$i + ($count - 2)]; // if found several folder then concat with upload dir
                $file_path.='/' . $path_array[$i + ($count - 2)];
                if (!is_dir($upload_dir)) { // if new directory not found create directory
                    mkdir($upload_dir, 0777, true);
                }
            }
            $target_file = "$upload_dir/$file_name"; // uploaded file directory
            $saved_file_path = substr($file_path, 1) . '/' . $file_name; // get fine name with path if file uploaded in several flder
            // save upload file path in content_library table and uploaded in to target path
            $description = $this->save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $saved_file_path, $description);
        } else {
            $target_file = $upload_dir . '/' . $file_name; // uploaded file directory
            // save upload file path in content_library table and uploaded in to target path
            $description = $this->save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $file_name, $description);
        }
        return $description;
    }

    /**
     * @Function            : save_file_path 
     * @Used IN             : @function-'upload_tinymc_file'         this[@Model]  - (2)
     * @Description         : save tinymce file in content library and upload file in "$upload_dir"
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 11:03 AM 
     * @Parameter           : $id (Course id/Video Course Id/Quiz ID.....), 
     *                        $type (Which type - Course/Video Course/Quiz.....), 
     *                        $main_full_path (full uploaded file path with root), 
     *                        $main_file_path (full uploaded file path without root),
     *                        $target_file (uploaded file path) 
     *                        $file_name (upload file name)
     *                        $description (Tinymce description with all files)
     * @Return              : $description[STRING] (Return tinymce description after uploading all file)              
     * @Status              : available      
     * */
    function save_file_path($id, $type, $main_full_path, $main_file_path, $target_file, $file_name, $description) {
        copy($main_file_path, $target_file); // copy file from 'source' to 'content-library' directory
        // file path saved in database
        $file_saved_id = $this->content_library_model->save_content_library_file($file_name, $type, $id);
        // saved path insert ID replace to uploaded directory
        return $this->utility_model->replace_first($main_full_path, $file_saved_id, urldecode($description));
    }

    /**
     * @Function            : view_tinyMce_information 
     * @Used IN             : @function-'view/user/course/edit_course.php'   (2)
     * @Description         : view tinymce information with all file path
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 23-07-2016 02:46 PM 
     * @Parameter           : $creator_id (Course Creator ID), 
     *                        $course_url (Course url), 
     *                        $description (Tinymce description with all files saved ID)
     * @Return              : $update_description[STRING] (Tinymce description with all files path)           
     * @Status              : available      
     * */
    function view_tinyMce_information($creator_id, $course_url, $description) {
        $href_match = Array(); // all hiperlink file saved ID remain in this Array
        $src_match = Array(); // all source file saved ID remain in this Array
        // change text to html tag
        $update_description = $this->changed_text_to_special_character($description);
        preg_match_all('@href="([^"]+)"@', $update_description, $href_match); // if matched any "href" ID than push "$href_match" Array 
        preg_match_all('@src="([^"]+)"@', $update_description, $src_match); // if matched any "href" ID than push "$src_match" Array 

        if ($href_match[1]) { // if found any "href" ID
            $update_description = $this->view_tinymce_hiperlink_file($href_match, $creator_id, $course_url, $update_description);
        }
        if ($src_match[1]) { // if found any "src" ID
            $update_description = $this->view_tinymce_source_file($src_match, $creator_id, $course_url, $update_description);
        }
        return $update_description;
    }

    /**
     * @Function            : view_tinymce_hiperlink_file 
     * @Used IN             : @function-'view_tinyMce_information'    this[@model]
     * @Description         : view tinymce information with all hiperlink file path
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 11:41 AM 
     * @Parameter           : $href_match[ARRAY] (all "href" file ID)
     *                        $creator_id (Course Creator ID), 
     *                        $course_url (Course url), 
     *                        $update_description (Tinymce description with all files saved ID)
     * @Return              : $update_description[STRING] (Tinymce description with all files path)           
     * @Status              : available      
     * */
    function view_tinymce_hiperlink_file($href_match, $creator_id, $course_url, $update_description) {
        for ($i = 0; $i < count($href_match[1]); $i++) { // looping ound number of "href" ID found
            //// get content library information by content library ID
            $content_library_info = $this->content_library_model->get_content_library_info_by_content_library_id($href_match[1][$i]);
            if ($content_library_info) {
// Replace if "href" matched and replace an Unique String 
                $temp_description = str_replace($href_match[0][$i], '(*rfile#)', $update_description);
                // get person URl by course creator ID
                $person_url = $this->person_model->get_profile_url($creator_id);
                // file path
                $file_path = base_url() . 'content-library/' . $person_url . '/my-work-file/' . $course_url . '/' . $content_library_info->content_library_location;
                $full_file_path = str_replace($href_match[1][$i], $file_path, $href_match[0][$i]);
                $update_description = str_replace('(*rfile#)', $full_file_path, $temp_description);
            }
        }
        return $update_description;
    }

    /**
     * @Function            : view_tinymce_source_file 
     * @Used IN             : @function-'view_tinyMce_information'    this[@model]
     * @Description         : view tinymce information with all source file path
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 11:41 AM 
     * @Parameter           : $src_match[ARRAY] (all "src" file ID)
     *                        $creator_id (Course Creator ID), 
     *                        $course_url (Course url), 
     *                        $update_description (Tinymce description with all files saved ID)
     * @Return              : $update_description[STRING] (Tinymce description with all files path)           
     * @Status              : available      
     * */
    function view_tinymce_source_file($src_match, $creator_id, $course_url, $update_description) {
        for ($i = 0; $i < count($src_match[1]); $i++) { // looping ound number of "src" ID found
            //// get content library information by content library ID
            $content_library_info = $this->content_library_model->get_content_library_info_by_content_library_id($src_match[1][$i]);
            if ($content_library_info) {
// Replace if "href" matched and replace an Unique String 
                $temp_description = str_replace($src_match[0][$i], '(*rfile#)', $update_description);
                // get person URl by course creator ID
                $person_url = $this->person_model->get_profile_url($creator_id);
                $file_path = base_url() . 'content-library/' . $person_url . '/my-work-file/' . $course_url . '/' . $content_library_info->content_library_location;
                $full_file_path = str_replace($src_match[1][$i], $file_path, $src_match[0][$i]);
                $update_description = str_replace('(*rfile#)', $full_file_path, $temp_description);
            }
        }
        return $update_description;
    }

    /**
     * @Function            : update_tinymce_information 
     * @Used IN             : @function-'update_course_all_tinymce_information'  user_course_model[@model]
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 12:22 PM 
     * @Parameter           : $id[INTEGER](Course id/Video Course Id/Quiz ID.....), 
     *                        $person_url[STRING](login Person URL), 
     *                        $url[STRING](Course url/Video Course url/Quiz url.....), 
     *                        $description[STRING](Tinymce description with all files), 
     *                        $previous_description[STRING](Previous saved Tinymce description with all files), 
     *                        $type[INTEGER](Which type - Course/Video Course/Quiz.....)
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function update_tinymce_information($id, $person_url, $url, $description, $previous_description, $type) {
        $href_match = $src_match = Array(); // all hiperlink and Source file remain in this Array
        // get all content library ID by previous saved Description 
        $old_content_id_array = $this->content_library_model->get_all_content_library_id_from_tinymce($previous_description);
        // get all content library path by previous saved Description 
        $old_content_path_array = $this->content_library_model->get_all_content_library_path_by_id($person_url, $url, $old_content_id_array);
        // Combine $old_content_id_array and $old_content_path_array ARRAY
        $combine_array = array_combine($old_content_id_array, $old_content_path_array);

        preg_match_all('@href="([^"]+)"@', $description, $href_match); // if matched any "href" file than push "$href_match" Array 
        preg_match_all('@src="([^"]+)"@', $description, $src_match); // if matched any "src" file than push "$src_match" Array

        if ($href_match[1]) { // if found any "href" file
            $description = $this->replace_tinymce_hyperlink_file($href_match[1], $description, $old_content_path_array, $combine_array);
        }

        if ($src_match[1]) { // if found any "href" file
            $description = $this->replace_tinymce_source_file($src_match[1], $description, $old_content_path_array, $combine_array);
        }

        $upload_dir = 'content-library/' . $person_url . '/my-work-file/' . $url;
        $update_content_id_array = $this->content_library_model->get_all_content_library_id_from_tinymce($description);
        $remaining_content_id_array = array_diff($old_content_id_array, $update_content_id_array);

        if ($remaining_content_id_array) { // IF delete some file from tinymce
            $this->content_library_model->delete_content_library($remaining_content_id_array);
        }

        $find_path = "$upload_dir/"; // find file from source directory
        // if update new file in tinymce
        return $this->get_update_tinymce_description($id, $upload_dir, $description, $type, $find_path);
    }

    /**
     * @Function            : replace_tinymce_hyperlink_file 
     * @Used IN             : @function-'update_tinymce_information'  this[@model]
     * @Description         : replace tynemce file path to conten library ID if hyperlink file found
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 02:34 PM 
     * @Parameter           : $href_match[ARRAY](if "href" file found), 
     *                        $description[STRING](Tinymce description with all files),
     *                        $old_content_path_array[Array](all content library path of previous file uploaded), 
     *                        $combine_array[Array](Combine all content library ID and path of previous file uploaded)
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function replace_tinymce_hyperlink_file($href_match, $description, $old_content_path_array, $combine_array) {
        for ($i = 0; $i < count($href_match); $i++) { // looping if found "href" file
            if (preg_match('/content-library/', $href_match[$i])) { // matched with content-library
                $file_path_array = explode('content-library', $href_match[$i]);
                $modify_file_path = 'content-library' . $file_path_array[1];

                if (in_array($modify_file_path, $old_content_path_array)) { // if file pathe remaining '$old_content_path_array'
                    foreach ($combine_array as $key => $value) {
                        if ($modify_file_path == $value) { // if modify path same as path then replace
                            $description = $this->utility_model->replace_first($href_match[$i], $key, $description);
                        }
                    }
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : replace_tinymce_source_file 
     * @Used IN             : @function-'update_tinymce_information'  this[@model]
     * @Description         : replace tynemce file path to conten library ID if source file found
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-07-2016 02:34 PM 
     * @Parameter           : $src_match[ARRAY](if "src" file found), 
     *                        $description[STRING](Tinymce description with all files),
     *                        $old_content_path_array[Array](all content library path of previous file uploaded), 
     *                        $combine_array[Array](Combine all content library ID and path of previous file uploaded)
     * @Return              : $description[INTEGER]           
     * @Status              : available      
     * */
    function replace_tinymce_source_file($src_match, $description, $old_content_path_array, $combine_array) {
        for ($i = 0; $i < count($src_match); $i++) { // looping if found "src" file
            if (preg_match('/content-library/', $src_match[$i])) { // matched with content-library
                $file_path_array = explode('content-library', $src_match[$i]);
                $modify_file_path = 'content-library' . $file_path_array[1];

                if (in_array($modify_file_path, $old_content_path_array)) { // if file pathe remaining '$old_content_path_array'
                    foreach ($combine_array as $key => $value) {
                        if ($modify_file_path == $value) { // if modify path same as path then replace
                            $description = $this->utility_model->replace_first($src_match[$i], $key, $description);
                        }
                    }
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : get_update_tinymce_description 
     * @Used IN             : @function-'update_tinymce_information'  super_admin_course[@controller],
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 12:22 PM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....), 
     *                        $upload_dir[STRING], 
     *                        $description[STRING](Tinymce description with all files), 
     *                        $type[INTEGER](Which type - Course/Video Course/Quiz.....) 
     *                        $find_path[STRING] (In this System tinymce find file with specific pathe such AS - source/content-library....)
     * @Return              : $description[INTEGER] (Tinymce description with all files saved ID),           
     * @Status              : available      
     * */
    function get_update_tinymce_description($id, $upload_dir, $description, $type, $find_path) {
        $href_match = Array();
        $src_match = Array();
        preg_match_all('@href="([^"]+)"@', $description, $href_match);
        preg_match_all('@src="([^"]+)"@', $description, $src_match);

        if ($src_match[1]) {
            $description = $this->update_tinymce_source_file($id, $src_match[1], $description, $upload_dir, $type, $find_path);
        }

        if ($href_match[1]) {
            $description = $this->update_tinymce_hyperlink_file($id, $href_match[1], $description, $upload_dir, $type, $find_path);
        }
        return $description;
    }

    /**
     * @Function            : update_tinymce_source_file 
     * @Used IN             : @function-'get_update_tinymce_description'  this[@Model]
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 27-07-2016 12:22 PM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....), 
     *                        $src_match[STRING] (if "src" file found),
     *                        $description[STRING] (Tinymce description with Source files),      
     *                        $upload_dir[STRING] (Uploaded file Directory)
     *                        $type[STRING] (Which type - Course/Video Course/Quiz.....) 
     *                        $find_path[STRING] (Tinymce description with Source files ),      
     * @Return              : $description[INTEGER] (Tinymce description with Source files saved ID),            
     * @Status              : available      
     * */
    function update_tinymce_source_file($id, $src_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($src_match); $i++) {
            $main_full_path = urldecode($src_match[$i]);
            if (preg_match("/content-library/", $main_full_path)) {
                $main_full_path_array = explode('?', $main_full_path);
                $cut_string_array = explode($find_path, $main_full_path_array[0]);
                $main_file_path = $find_path . $cut_string_array[1];
                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : update_tinymce_hyperlink_file 
     * @Used IN             : @function-'get_update_tinymce_description'  this[@Model]
     * @Description         : update tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 30-07-2016 03:54 PM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....),
     *                        $href_match[ARRAY](if "href" file found),
     *                        $description[STRING] (Tinymce description with Hyperlink files),
     *                        $upload_dir[STRING]  (Uploaded file Directory)
     *                        $type[STRING] (Which type - Course/Video Course/Quiz.....) 
     *                        $find_path[STRING] (Tinymce description with Hyperlink files ),  
     * @Return              : $description[INTEGER] (Tinymce description with Source files saved ID),           
     * @Status              : available      
     * */
    function update_tinymce_hyperlink_file($id, $href_match, $description, $upload_dir, $type, $find_path) {
        for ($i = 0; $i < count($href_match); $i++) {
            $main_full_path = urldecode($href_match[$i]);
            if (preg_match("/content-library/", $main_full_path)) {
                $cut_string_array = explode($find_path, $main_full_path);
                $main_file_path = $find_path . $cut_string_array[1];
                if (is_file($main_file_path)) {
                    $description = $this->upload_tinymc_file($id, $description, $main_full_path, $main_file_path, $upload_dir, $type, 5);
                }
            }
        }
        return $description;
    }

    /**
     * @Function            : check_folder_for_tinymce 
     * @Used IN             : @function-'update_course_all_tinymce_information'    user_course_model[@Model],
     * @Description         : check empty folder and unused file from tinymce
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 30-07-2016 03:37 PM 
     * @Parameter           : $id[INTEGER] (Course id/Video Course Id/Quiz ID.....),
     *                        $upload_dir[STRING] (Upoaded file Directory)
     * @Return              : Null          
     * @Status              : available      
     * */
    function check_folder_for_tinymce($id, $upload_dir) {
        $file_list = $this->utility_model->list_folder_files($upload_dir);
        foreach ($file_list as $value) {
            $content_library_info = $this->content_library_model->check_content_library_path(2, $id, $value);
            if (!$content_library_info) {
                $file = "$upload_dir/$value";
                if (is_file($file)) { // Remove unused file
                    unlink($file);
                }
            }
        }
        // Remove empty folder list
        $folder_list = array_reverse($this->utility_model->folder_list($upload_dir));

        foreach ($folder_list as $folder) {
            if ($this->utility_model->is_dir_empty("$upload_dir/$folder")) {
                rmdir("$upload_dir/$folder");
            }
        }
    }

    /**
     * @Function            : changed_special_character_to_text 
     * @Used IN             : @function-'save_video_course_information1'     user_video_model[@Model] [105]
     * @Description         : change special character to text in tinymc
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 05:32 PM
     * @Parameter           : $message[STRING]
     * @Return              : $message[STRING]    
     * @Status              : Available       
     * */
    function changed_special_character_to_text($message) {
        $special_character = $this->special_characters();
        $special_character_text = $this->text_for_special_character();
        $combine_array = array_combine($special_character, $special_character_text);
        $view_message = $message;
        $i = 0;
        while (count($combine_array) > $i) {
            $view_message = str_replace($special_character[$i], $special_character_text[$i], $view_message);
            $i++;
        }
        return $view_message;
    }

    /**
     * @Function            : changed_text_to_special_character 
     * @Description         : change text to special character in tinymce
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 05:32 PM
     * @Parameter           : $message[STRING]
     * @Return              : $message[STRING]    
     * @Status              : Available       
     * */
    function changed_text_to_special_character($message) {
        $special_character = $this->special_characters();
        $special_character_text = $this->text_for_special_character();
        $combine_array = array_combine($special_character, $special_character_text);
        $view_message = $message;
        $i = 0;
        while (count($combine_array) > $i) {
            $view_message = str_replace($special_character_text[$i], $special_character[$i], $view_message);
            $i++;
        }
        return $view_message;
    }

    /**
     * @Function            : changed_text_to_special_character 
     * @Description         : all special character array
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 05:32 PM
     * @Parameter           : NUll
     * @Return              : $special_characters[ARRAY]    
     * @Status              : Available       
     * */
    function special_characters() {
        $special_characters = Array("!", "@", "$", "%", "^", "&", "*", "_", "+", "-", "/", "`", "'", "|", ":", ";", "<", ">", "?", "~", "=");
        return $special_characters;
    }

    /**
     * @Function            : text_for_special_character 
     * @Description         : all text for special character
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-03-2016 05:32 PM
     * @Parameter           : NULL
     * @Return              : $text_for_special_character[ARRAY]    
     * @Status              : Available       
     * */
    function text_for_special_character() {
        $text_for_special_character = array(
            "(exclamation)", "(at)", "(dolar)", "(percent)", "(accent)", "(ampersand)", "(asterisk)", "(lowline)", "(plussign)", "(minussign)", "(solidus)", "(graveaccent)", "(apostrophe)", "(verticalbar)", "(colon)", "(semicolon)", "(lessthansign)", "(greaterthansign)", "(questionmark)", "(tilde)", "(equalsign)");
        return $text_for_special_character;
    }

}
