<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Super_Admin_Video_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Video Course Part----------------------------------
     */

    /**
     * @Function            : save_video_course_information 
     * @Used IN             : @function-'add_video_course'  super_admin_video[@controller],
     * @Description         : Save all video information in DATABASE
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-02-2016 02:12 PM
     * @Updated Date Time   : 13-02-2016 11:53 PM
     * @Updated By          : Ripon Jaherul     
     * @Status              : available      
     * */
    function save_video_course_information($url_id) {
        $data['course_category_id'] = $this->input->post('course_category_id', TRUE);
        $data['resource_person_id'] = $this->input->post('resource_person_id', TRUE);
        $data['person_id'] = $this->session->userdata('person_id');
        $data['url_id'] = $url_id;

        if ($this->input->post('menu_id', TRUE)) {
            $data['menu_id'] = $this->input->post('menu_id', TRUE);
        } else {
            $data['menu_id'] = 0;
        }
        $data['video_course_title'] = $this->input->post('video_course_title', TRUE);
        $data['video_folder_name'] = $this->input->post('video_folder_name', TRUE);

        // Make course video folder
        $diriectory = 'content-library/' . $this->session->userdata('person_url') . '/my-video/' . $data['video_folder_name'] . '/';
        mkdir($diriectory, 0777, true);

        if ($this->input->post('video_training_objectives', TRUE)) {
            $data['video_training_objectives'] = $this->get_tinymce_description_value($this->input->post('video_training_objectives', TRUE));
        } else {
            $data['video_training_objectives'] = NULL;
        }

        if ($this->input->post('video_training_outline', TRUE)) {
            $data['video_training_outline'] = $this->get_tinymce_description_value($this->input->post('video_training_outline', TRUE));
        } else {
            $data['video_training_outline'] = NULL;
        }

        if ($this->input->post('video_management_meta_title', TRUE)) {
            $data['video_management_meta_title'] = $this->input->post('video_management_meta_title', TRUE);
        } else {
            $data['video_management_meta_title'] = NULL;
        }

        if ($this->input->post('video_management_meta_keywords', TRUE)) {
            $data['video_management_meta_keywords'] = implode(',', $this->input->post('video_management_meta_keywords', TRUE));
        } else {
            $data['video_management_meta_keywords'] = NULL;
        }

        if ($this->input->post('video_management_meta_description', TRUE)) {
            $data['video_management_meta_description'] = $this->input->post('video_management_meta_description', TRUE);
        } else {
            $data['video_management_meta_description'] = NULL;
        }

        if ($this->input->post('video_management_author', TRUE)) {
            $data['video_management_author'] = $this->input->post('video_management_author', TRUE);
        } else {
            $data['video_management_author'] = NULL;
        }

        if ($this->input->post('video_management_keyword', TRUE)) {
            $data['video_management_keyword'] = implode(',', $this->input->post('video_management_keyword', TRUE));
        } else {
            $data['video_management_keyword'] = NULL;
        }

        $data['video_language'] = $this->input->post('video_language', TRUE);

        if ($this->input->post('video_management_rating', TRUE)) {
            $data['video_management_rating'] = $this->input->post('video_management_rating', TRUE);
        } else {
            $data['video_management_rating'] = NULL;
        }

        $data['video_management_level'] = $this->input->post('video_management_level', TRUE);
        $data['video_access_level'] = $this->input->post('video_access_level', TRUE);
        $data['video_management_status'] = $this->input->post('video_management_status', TRUE);
        $data['video_course_type'] = $this->input->post('video_course_type', TRUE);

        if ($data['video_course_type'] == 1) {
            $data['video_course_price_currency'] = $this->input->post('video_course_price_currency', TRUE);
            $data['video_course_price'] = $this->input->post('video_course_price', TRUE);
        }

        $video_course_id = $this->save_information_in_database('tbl_video_management', $data);
        if ($data['menu_id'] != 0) {
            $this->url_model->assign_menu_url_in_video_course($video_course_id);
        }

//        $this->save_video_course_access_permission($video_course_id, $data);
    }

    /**
     * @Function            : save_video_course_access_permission 
     * @Used IN             : @function-'save_video_course_information'  this[@Model]
     * @Description         : Save video course permission 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-07-2016 03:24 PM     
     * @Status              : available      
     * */
//    function save_video_course_access_permission($video_course_id, $data) {
//        $pData['course_video_course_type'] = 2; // for video course
//        $pData['course_video_course_id'] = $video_course_id;
//        if ($data['video_access_level'] == 4) {  // video course save for group
//            $pData['course_video_course_permission_type'] = 1; // for group
//            $pData['course_video_course_permission_type_id'] = implode(",", $this->input->post('group_id', TRUE));
//        } else if ($data['video_access_level'] == 5) {  // video course save for Special User
//            $pData['course_video_course_permission_type'] = 2; // for special user
//            $pData['course_video_course_permission_type_id'] = implode(",", $this->input->post('special_user_id', TRUE));
//        }
//        $this->db->insert('tbl_course_video_course_permission', $pData);
//    }

    /**
     * @Function            : update_video_course_information 
     * @Used IN             : @function-'edit_video_course'  super_admin_video[@controller],
     * @Description         : Update all video information in DATABASE
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 13-02-2016 07:30 PM     
     * @Updated By          : Md Jaherul Islam
     * @Updated DateTime    : 11-07-2016 03:37 PM     
     * @Status              : available      
     * */
    function update_video_course_information($video_course_info, $new_video_url) {
        $data['course_category_id'] = $this->input->post('course_category_id', TRUE);
        $data['resource_person_id'] = $this->input->post('resource_person_id', TRUE);
        $data['video_course_title'] = $this->input->post('video_course_title', TRUE);

        if ($this->input->post('menu_id', TRUE)) {
            $data['menu_id'] = $this->input->post('menu_id', TRUE);
        } else {
            $data['menu_id'] = 0;
            if ($video_course_info->menu_id != 0) {
                if ($new_video_url == $video_course_info->url) {
                    $this->url_model->update_url_for_assign_menu($video_course_info->video_course_url_id, $data['video_course_title']);
                }
            }
        }

        if ($this->input->post('video_training_objectives', TRUE)) {
            $data['video_training_objectives'] = $this->get_tinymce_description_value_for_edit($this->input->post('video_training_objectives', TRUE), $video_course_info->video_training_objectives);
        } else {
            $data['video_training_objectives'] = NULL;
        }

        if ($this->input->post('video_folder_name', TRUE) != $video_course_info->video_folder_name) {
            $data['video_folder_name'] = $this->input->post('video_folder_name', TRUE);
            $this->rename_video_course_folder_name($video_course_info, $this->input->post('video_folder_name', TRUE));
        } else {
            $data['video_folder_name'] = $video_course_info->video_folder_name;
        }

        if ($this->input->post('video_training_outline', TRUE)) {
            $data['video_training_outline'] = $this->get_tinymce_description_value_for_edit($this->input->post('video_training_outline', TRUE), $video_course_info->video_training_outline);
        } else {
            $data['video_training_outline'] = NULL;
        }

        if ($this->input->post('video_management_meta_title', TRUE)) {
            $data['video_management_meta_title'] = $this->input->post('video_management_meta_title', TRUE);
        } else {
            $data['video_management_meta_title'] = NULL;
        }

        if ($this->input->post('video_management_meta_keywords', TRUE)) {
            $data['video_management_meta_keywords'] = implode(',', $this->input->post('video_management_meta_keywords', TRUE));
        } else {
            $data['video_management_meta_keywords'] = NULL;
        }

        if ($this->input->post('video_management_meta_description', TRUE)) {
            $data['video_management_meta_description'] = $this->input->post('video_management_meta_description', TRUE);
        } else {
            $data['video_management_meta_description'] = NULL;
        }

        if ($this->input->post('video_management_author', TRUE)) {
            $data['video_management_author'] = $this->input->post('video_management_author', TRUE);
        } else {
            $data['video_management_author'] = NULL;
        }

        if ($this->input->post('video_management_keyword', TRUE)) {
            $data['video_management_keyword'] = implode(',', $this->input->post('video_management_keyword', TRUE));
        } else {
            $data['video_management_keyword'] = NULL;
        }

        $data['video_language'] = $this->input->post('video_language', TRUE);

        if ($this->input->post('video_management_rating', TRUE)) {
            $data['video_management_rating'] = $this->input->post('video_management_rating', TRUE);
        } else {
            $data['video_management_rating'] = NULL;
        }

        $data['video_management_level'] = $this->input->post('video_management_level', TRUE);
        $data['video_access_level'] = $this->input->post('video_access_level', TRUE);
        $data['video_management_status'] = $this->input->post('video_management_status', TRUE);
        $data['video_course_type'] = $this->input->post('video_course_type', TRUE);

        if (($data['video_course_type'] == 1)) {
            $data['video_course_price_currency'] = $this->input->post('video_course_price_currency', TRUE);
            $data['video_course_price'] = $this->input->post('video_course_price', TRUE);
        }
        if (($data['video_course_type'] == 2) && ($video_course_info->video_course_type == 1)) {
            $data['video_course_price_currency'] = NULL;
            $data['video_course_price'] = NULL;
        }
        $this->update_information_in_database('tbl_video_management', 'video_management_id', $video_course_info->video_management_id, $data);
        if ($data['menu_id'] != 0) {
            $this->url_model->assign_menu_url_in_video_course($video_course_info->video_management_id);
        }
    }

    /**
     * @Function            : delete_video_course_permision_info 
     * @Used IN             : @function-'save_video_course_information'   super_admin_video_model[@Model]
     * @Description         : delete video course information
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-07-2016 03:43 PM
     * @Status              : available      
     * */
    function delete_video_course_permision_info($video_course_type, $video_course_id, $video_course_permission_type) {
        $result = $this->super_admin_course_model->get_course_permission_information($video_course_type, $video_course_id, $video_course_permission_type);
        $this->utility_model->delete_information_in_database('tbl_course_video_course_permission', 'course_video_course_permission_id', $result->course_video_course_permission_id);
    }

    /**
     * @Function            : save_information_in_database 
     * @Used IN             : @function-'save_video_course_information'   super_admin_video_model[@Model],
     * @                    : @function-'upload_video_for_video_course'   super_admin_video[@Controller],
     * @                    : @function-'upload_video_course_work_file'   super_admin_video[@Controller],
     * @Description         : Save Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 11:52 AM
     * @Status              : available      
     * */
    function save_information_in_database($table_name, $data) {
        $this->db->insert($table_name, $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : update_information_in_database 
     * @Used IN             : @function-'update_video_course_information'   this[@Model],
     * @                    : @function-'upload_video_for_video_course'     super_admin_video[@Controller]
     * @                    : @function-'upload_video_course_work_file'     super_admin_video[@Controller]
     * @                    : @function-'save_upload_video_information'     this[@Model],
     * @Description         : Update Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 07:46 AM
     * @Status              : available      
     * */
    function update_information_in_database($table_name, $table_id, $id, $data) {
        $this->db->where($table_id, $id);
        $this->db->update($table_name, $data);
    }

    /**
     * @Function            : rename_video_course_folder_name 
     * @Used IN             : @function-'update_video_course_information'   super_admin_video_model[@Model],
     * @Description         : Update Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 02:00 pM
     * @Status              : available      
     * */
    function rename_video_course_folder_name($video_course_info, $folder_name) {
        $result = $this->get_single_video_course_information_by_id($video_course_info->video_management_id);
        $course_creator_url = $this->get_profile_url($result->course_creator_id);

        $old_diriectory = './content-library/' . $course_creator_url . '/my-video/' . $result->video_folder_name;
        $new_diriectory = './content-library/' . $course_creator_url . '/my-video/' . $folder_name;

        if (file_exists($old_diriectory)) {
            rename($old_diriectory, $new_diriectory);
        }
    }

    /**
     * @Function            : select_all_video_course 
     * @Used IN             : @function-'manage_video_course'                super_admin_video[@Controller],
     * @Used IN             : @function-'get_video_course_by_search_value'   super_admin_video[@Controller],
     * @Description         : Select all video 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 12:45 AM
     * @Status              : available      
     * */
    function select_all_video_course($number, $search_value = NULL) {
        $sql = "SELECT * 
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id";
        if ($search_value != NULL) {
            $sql.=" AND (vm.video_course_title LIKE '%$search_value%' OR cc.course_category_name LIKE '%$search_value%')";
        }
        $sql.= " ORDER BY vm.video_management_id ASC";
        $sql.=" LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_video_course 
     * @Used IN             : @function-'manage_video_course'                super_admin_video[@Controller],
     * @Used IN             : @function-'get_video_course_by_search_value'   super_admin_video[@Controller],
     * @Description         : Select total video 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 11:21 AM
     * @Status              : available      
     * */
    function get_total_video_course($search_value = NULL) {
        $sql = "SELECT count(*) AS total 
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id";
        if ($search_value != NULL) {
            $sql.=" AND (vm.video_course_title LIKE '%$search_value%' OR cc.course_category_name LIKE '%$search_value%')";
        }
        $sql.= " ORDER BY vm.video_management_id ASC";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_video_course_information_by_id 
     * @Used IN             : @function-'change_video_course_status_by_id'                    super_admin_video_model[@Model],
     * @                    : @function-'rename_video_course_folder_name'                     super_admin_video_model[@Model],
     * @                    : @function-'check_edit_video_folder_name_exists'                 super_admin_video[@Controller],
     * @                    : @function-'view_video_course_access_level_by_video_course_id'   super_admin_video[@Controller],
     * @                    : @function-'upload_video_for_video_course'                       super_admin_video[@Controller],
     * @                    : @function-'view_course_category_for_video_course'               super_admin_video[@Controller],
     * @                    : @function-'view_video_course_file_size_by_video_course_id'      super_admin_video[@Controller],
     * @                    : @function-'get_video_course_work_file_view'                     super_admin_video[@Controller],
     * @                    : @function-'add_single_video_course_area'                        super_admin_video[@Controller],
     * @                    : @function-'add_video_course_section_area'                       super_admin_video[@Controller],
     * @                    : @function-'delete_video_course_all_video_file'                  super_admin_video[@Controller],
     * @Description         : Select Single video By video_course_id 
     * @                    : @Update1 -> add course_creator_id in SQL Query 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 01:58 PM
     * @Updated Date Time   : 14-02-2016 02:02 PM
     * @Updated By          : Ripon Jaherul
     * @Status              : available      
     * */
    public function get_single_video_course_information_by_id($video_course_id) {
        $sql = "SELECT *,vm.person_id AS course_creator_id 
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND vm.video_management_id = '$video_course_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_video_course_information_by_url 
     * @Used IN             : @function-'edit_video_course'              this[@Model],
     * @                    : @function-'view_video_course_work_file'    super_admin_video[@Controller]
     * @                    : @function-'edit_video_course_work_file'    super_admin_video[@Controller]
     * @Description         : Select Single video By video_course_url 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 03:48 PM
     * @Status              : available      
     * */
    public function get_single_video_course_information_by_url($video_course_url) {
        $sql = "SELECT * ,vm.person_id AS course_creator_id, vm.url_id AS video_course_url_id
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND u.url = '$video_course_url' AND u.url_type = '8'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_profile_url 
     * @Used IN             : @function-'delete_video_course_folder'                           this[@Model],
     * @                    : @function-'check_edit_video_folder_name_exists'                  super_admin_video[@Controller],
     * @                    : @function-'upload_video_for_video_course'                        super_admin_video[@Controller],
     * @                    : @function-'view_video_course_file_size_by_video_course_id'       super_admin_video[@Controller],
     * @                    : @function-'upload_video_course_work_file'                        super_admin_video[@Controller],
     * @                    : @function-'remove_upload_video_course_work_file'                 super_admin_video[@Controller],
     * @                    : @function-'delete_single_video_course_area'                      super_admin_video[@Controller-2 times]
     * @                    : @function-'remove_video_course_section_area'                     super_admin_video[@Controller-2 times]
     * @                    : @function-'delete_video_course_all_video_file'                   super_admin_video[@Controller]
     * @                    : @function-'rename_video_course_folder_name'                      this[@Model],
     * @                    : @function-'save_video_course_work_file'                          this[@Model],
     * @Description         : get profile URl using person_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 12:57 PM   
     * @Status              : available      
     * */
    public function get_profile_url($person_id) {
        $sql = "SELECT url
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->url;
    }

    /**
     * @Function            : delete_video_course_folder 
     * @Used IN             : @function-'change_video_course_status_by_id'  this[@Model],
     * @Description         : Delete video course folder name 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 12:57 PM    
     * @Status              : available      
     * */
    function delete_video_course_folder($video_management_id) {
        $result = $this->get_single_video_course_information_by_id($video_management_id);
        $course_creator_url = $this->get_profile_url($result->course_creator_id);

        $diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $result->video_folder_name;
        if (file_exists($diriectory)) {
            $this->remove_directory($diriectory);
        }
    }

    /**
     * @Function            : removem_diretcory 
     * @Used IN             : @function-'delete_work_file'                     this[@controller],
     * @                    : @function-'remove_video_course_section_area'     super_admin_video[@controller],
     * @                    : @function-'delete_single_video_course_area'      super_admin_video[@controller],
     * @                    : @function-'delete_video_course_all_video_file'   super_admin_video[@controller],
     * @Description         : Delete directory with all child
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 04-02-2016 12:07 PM      
     * @Status              : available (copied from  'super_admin'@controller)      
     * */
    public function remove_directory($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir") {
                        $this->remove_directory($dir . "/" . $object);
                    } else {
                        unlink($dir . "/" . $object);
                    }
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }

    /**
     * @Function            : change_video_course_status_by_id 
     * @Used IN             : @function-'change_video_course_status_by_id'   super_admin_video[@Controller],
     * @Description         : change and delete video course with video management id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 01:45 PM
     * @Status              : available      
     * */
    function change_video_course_status_by_id($video_management_id, $status) {
        if ($status == 'delete') {
            $result = $this->get_single_video_course_information_by_id($video_management_id);
            if ($result->video_access_level == 4) {
                $this->delete_group_permision($video_management_id, 2);
            } elseif ($result->video_access_level == 5) {
                $this->delete_special_user_permision($video_management_id, 2);
            }
            $this->delete_video_course_folder($video_management_id);
            $this->delete_single_video_course_by_id($video_management_id);
        } else {
            switch ($status) {
                case 'active':
                    $this->db->set('video_management_status', 1);
                    break;
                case 'inactive':
                    $this->db->set('video_management_status', 6);
                    break;
                case 'archive':
                    $this->db->set('video_management_status', 2);
                    break;
                case 'approved':
                    $this->db->set('video_management_status', 4);
                    break;
                case 'pending':
                    $this->db->set('video_management_status', 3);
                    break;
                case 'draft':
                    $this->db->set('video_management_status', 5);
                    break;
            }
            $this->db->where('video_management_id', $video_management_id);
            $this->db->update('tbl_video_management');
        }
    }

    /**
     * @Function            : delete_single_video_course_by_id 
     * @Used IN             : @function-'change_video_course_status_by_id'   super_admin_video_model[@Model],
     * @Description         : delete video course using video management id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 13-02-2016 02:16 PM
     * @Status              : available      
     * */
    function delete_single_video_course_by_id($video_management_id) {
        $sql = "DELETE vm,u
                    FROM 
                        tbl_video_management AS vm,
                        tbl_url AS u
                    WHERE 
                        vm.url_id = u.url_id
                    AND vm.video_management_id = '$video_management_id'";
        $this->db->query($sql);
    }

    /**
     * @Function            : get_tinymce_description_value 
     * @Used IN             : @function-'save_video_course_information'   super_admin_video_model[@Model],
     * @Description         : Get TinyMC value from multiple input value
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Copied from     -  'super_Admin_course_model'
     * @Status              : available      
     * */
    public function get_tinymce_description_value($description1) {
        $description = '';
        for ($i = 0; $i < count($description1); $i++) {
            if ($description1[$i] != '') {
                $description = $description1[$i];
                break;
            }
        }
        return $description;
    }

    /**
     * @Function            : get_tinymce_description_value_for_edit 
     * @Used IN             : @function-'update_video_course_information'   super_admin_video_model[@Model],
     * @Description         : Get TinyMC value from multiple input value
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Copied from     -  'super_Admin_course_model'
     * @Status              : available      
     * */
    public function get_tinymce_description_value_for_edit($description, $old_description) {
        $counter = 0;
        for ($i = 0; $i < count($description); $i++) {
            if ($description[$i] == $old_description) {
                $counter++;
            }
        }
        if ($counter == 4) {
            return $old_description;
        } else {
            return $this->get_tinymce_description_value_for_edit1($description, $old_description);
        }
    }

    /**
     * @Function            : get_tinymce_description_value_for_edit1 
     * @Used IN             : @function-'update_video_course_information'   super_admin_video_model[@Model],
     * @Description         : Get TinyMC value from multiple input value
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Copied from     -  'super_Admin_course_model'
     * @Status              : available      
     * */
    public function get_tinymce_description_value_for_edit1($description, $old_description) {
        $description1 = '';
        for ($i = 0; $i < count($description); $i++) {
            if ($description[$i] != $old_description) {
                $description1 = $description[$i];
                break;
            }
        }
        return $description1;
    }

    /*
      -----------@@@RIPON@ End Video Course Part----------------------------------
     */



    /*
      -----------@@@RIPON@ Start Video Course Work File Part----------------------------------
     */

    /**
     * @Function            : select_all_video_course_by_video_work_file 
     * @Used IN             : @function-'manage_video_course_work_file'    super_admin_video[@Controller],
     * @Description         : view all video course whach have video file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 04:07 PM
     * @Status              : available      
     * */
    function select_all_video_course_by_video_work_file() {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm,
                    tbl_url AS u,
                    tbl_course_category AS cc
                WHERE 
                    uv.video_management_id = vm.video_management_id
                AND vm.url_id = u.url_id
                AND vm.course_category_id = cc.course_category_id
                GROUP BY 
                    uv.video_management_id
                ORDER BY 
                    uv.upload_video_id DESC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_course_video_details_by_video_course_id 
     * @Used IN             : @function-'manage_video_course_work_file'           super_admin_video[@Controller],
     * @                    : @function-'view_video_course_work_file'             super_admin_video[@Controller]
     * @                    : @function-'delete_video_course_all_video_file'      super_admin_video[@Controller]
     * @Description         : select all uploaded video using video_course_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 04:29 PM
     * @Status              : available      
     * */
    function select_all_course_video_details_by_video_course_id($video_course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm
                WHERE 
                    uv.video_management_id = '$video_course_id'
                AND uv.video_management_id = vm.video_management_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_video_course_section_by_video_course_id 
     * @Used IN             : @function-'edit_video_course_work_file'    super_admin_video[@Controller]
     * @Description         : select all uploaded video section using video_course_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 11:56 PM
     * @Status              : available      
     * */
    function select_all_video_course_section_by_video_course_id($video_course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'
                GROUP BY uv.upload_video_section_name
                ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : save_video_course_work_file 
     * @Used IN             : @function-'add_video_course_work_file'    super_admin_video[@Controller],
     * @                    : @function-'edit_video_course_work_file'    super_admin_video[@Controller],
     * @Description         : Save video course work file into database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 10:21 AM
     * @Status              : available      
     * */
    function save_video_course_work_file() {
        $all_section_counter1 = explode(',', $this->input->post('all_section_counter', TRUE));
        $all_section_counter = array_filter($all_section_counter1);
        
        for ($i = 0; $i < (count($all_section_counter)); $i++) {
            $all_video_counter1 = $this->input->post('all_upload_video_ok_counter', TRUE);
            if(array_key_exists($all_section_counter[$i], $all_video_counter1)){
                $all_video_counter2 = $all_video_counter1[$all_section_counter[$i]];
            }
            $all_video_counter3 = explode(',', $all_video_counter2);
            $all_video_counter = array_filter($all_video_counter3);

            $all_upload_video1 = $this->input->post('all_upload_video_id', TRUE);
            if(array_key_exists($all_section_counter[$i], $all_upload_video1)){
                $all_upload_video2 = $all_upload_video1[$all_section_counter[$i]];
            }
            $all_upload_video3 = explode(',', $all_upload_video2);
            $all_upload_video = array_filter($all_upload_video3);

            $video_section_name1 = $this->input->post('video_section_name', TRUE);
            if(array_key_exists($all_section_counter[$i], $video_section_name1)){
                $video_section_name2 = $video_section_name1[$all_section_counter[$i]];
            }
            $video_section_name = trim(preg_replace('/\s+/', ' ', $video_section_name2));

            $video_upload_info1 = $this->get_upload_video_information_by_upload_video_id($all_upload_video[0]);            
            $course_creator_url = $this->super_admin_video_model->get_profile_url($video_upload_info1->course_creator_id);            
           
            if ($video_upload_info1->upload_video_section_name != $video_section_name) {
                $old_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info1->video_folder_name . '/' . $video_upload_info1->upload_video_section_name;
                $old_diriectory = str_replace(' ', '-', $old_diriectory);
                $new_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info1->video_folder_name . '/' . $video_section_name;
                $new_diriectory = str_replace(' ', '-', $new_diriectory);
                if (is_dir($old_diriectory)) {
                    rename($old_diriectory, $new_diriectory);
                }
            }

            $combine_array = array_combine($all_video_counter, $all_upload_video);
            for ($j = 0; $j < count($combine_array); $j++) {
                $this->save_upload_video_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_counter, $all_upload_video);
            }

            if (($this->input->post('all_upload_video_work_file_ok_counter', TRUE) != '') && ($this->input->post('all_upload_video_work_file_id', TRUE))) {
                $all_video_work_file_counter1 = $this->input->post('all_upload_video_work_file_ok_counter', TRUE);
                if(array_key_exists($all_section_counter[$i], $all_video_work_file_counter1)){
                    $all_video_work_file_counter2 = $all_video_work_file_counter1[$all_section_counter[$i]];
                }
                $all_video_work_file_counter3 = explode(',', $all_video_work_file_counter2);
                $all_video_work_file_counter = array_filter($all_video_work_file_counter3);

                $all_upload_video_work_file_id1 = $this->input->post('all_upload_video_work_file_id', TRUE);
                $all_upload_video_work_file_id2 = $all_upload_video_work_file_id1[$all_section_counter[$i]];
                $all_upload_video_work_file_id3 = explode(',', $all_upload_video_work_file_id2);
                $all_upload_video_work_file_id = array_filter($all_upload_video_work_file_id3);
                if ($all_video_work_file_counter && $all_upload_video_work_file_id) {
                    $combine_array1 = array_combine($all_video_work_file_counter, $all_upload_video_work_file_id);
                    for ($k = 0; $k < count($combine_array1); $k++) {
                        $this->save_video_work_file_information($i, $k, $course_creator_url, $video_section_name, $all_section_counter, $all_video_work_file_counter, $all_upload_video_work_file_id);
                    }
                }
            }
        }
    }

    /**
     * @Function            : save_upload_video_information 
     * @Used IN             : @function-'save_video_course_work_file'         this[@Model]
     * @Description         : Save Upload video information course work file into database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 10:21 AM
     * @Status              : available      
     * */
    function save_upload_video_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_counter, $all_upload_video) {
        $video_upload_info = $this->get_upload_video_information_by_upload_video_id($all_upload_video[$j]);

        if ($video_upload_info->upload_video_section_name != $video_section_name) {
            $data['upload_video_section_name'] = $video_section_name;
        } else {
            $data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
        }
        $work_files_url = explode('.', $video_upload_info->upload_video_location);
        //$this->cf->dd($work_files_url);
        if(array_key_exists(1, $work_files_url)){
            $file_extension = $work_files_url[1];
        }
        $section_directory = '/my-video/' . $video_upload_info->video_folder_name . '/' . $data['upload_video_section_name'];

        $upload_video_name1 = $this->input->post('upload_video_name', TRUE);
        if(isset($upload_video_name1[$all_section_counter[$i]][$all_video_counter[$j]])){
            $upload_video_name2 = $upload_video_name1[$all_section_counter[$i]][$all_video_counter[$j]];
        
            $upload_video_name = trim(preg_replace('/\s+/', ' ', $upload_video_name2));
            if ($video_upload_info->upload_video_name != $upload_video_name) {
                $data['upload_video_name'] = $upload_video_name;

                $data['upload_video_location'] = $section_directory . '/' . "$upload_video_name"."_converted_720p.mp4";

                $old_video_file = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info->video_folder_name . '/' . $data['upload_video_section_name'] . '/' . "$video_upload_info->upload_video_name.$file_extension";
                $new_video_file = 'content-library/' . $course_creator_url . $data['upload_video_location'];
                if (file_exists($old_video_file)) {
                    rename($old_video_file, $new_video_file);
                }
            } else {
                $data['upload_video_name'] = $video_upload_info->upload_video_name;
                $data['upload_video_location'] = $section_directory . '/' . "$video_upload_info->upload_video_name"."_converted_720p.mp4";
            }
        }else {
                $data['upload_video_name'] = $video_upload_info->upload_video_name;
                $data['upload_video_location'] = $section_directory . '/' . "$video_upload_info->upload_video_name"."_converted_720p.mp4";
            }

        $upload_video_transcript1 = $this->input->post('upload_video_transcript', TRUE);
        if(isset($upload_video_transcript1[$all_section_counter[$i]][$all_video_counter[$j]])){
            $upload_video_transcript2 = $upload_video_transcript1[$all_section_counter[$i]][$all_video_counter[$j]];
            $upload_video_transcript = trim(preg_replace('/\s+/', ' ', $upload_video_transcript2));
            if ($video_upload_info->upload_video_transcript != $upload_video_transcript) {
                $data['upload_video_transcript'] = $upload_video_transcript;
            } else {
                $data['upload_video_transcript'] = $video_upload_info->upload_video_transcript;
            }
        }

        $upload_video_access_level1 = $this->input->post('upload_video_access_level', TRUE);
        if(isset($upload_video_access_level1[$all_section_counter[$i]][$all_video_counter[$j]])){
            $upload_video_access_level = $upload_video_access_level1[$all_section_counter[$i]][$all_video_counter[$j]];
        
            if ($video_upload_info->upload_video_access_level != $upload_video_access_level) {
                $data['upload_video_access_level'] = $upload_video_access_level;
            } else {
                $data['upload_video_access_level'] = $video_upload_info->upload_video_access_level;
            }
        }
        
        $data['upload_video_location'] = str_replace(' ', '-', $data['upload_video_location']);        
        $data['upload_video_status'] = 1;
        $this->update_information_in_database('tbl_upload_video', 'upload_video_id', $all_upload_video[$j], $data);
    }

    /**
     * @Function            : save_video_work_file_information 
     * @Used IN             : @function-'save_video_course_work_file'         this[@Model]
     * @Description         : Save Upload video work file information course work file into database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 22-02-2016 10:21 AM
     * @Status              : available      
     * */
    function save_video_work_file_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_work_file_counter, $all_upload_video_work_file_id) {
        $video_work_file_info = $this->get_upload_video_work_file_info_by_work_file_id($all_upload_video_work_file_id[$j]);

        if ($video_work_file_info->work_file_folder_name != $video_section_name) {
            $data['work_file_folder_name'] = $video_section_name;
        } else {
            $data['work_file_folder_name'] = $video_work_file_info->work_file_folder_name;
        }
        $work_files_url = explode('.', $video_work_file_info->work_files_url);
        $file_extension = $work_files_url[1];
        $section_directory = '/my-video/' . $video_work_file_info->video_folder_name . '/' . str_replace(' ', '-', $data['work_file_folder_name']);

        $work_files_name1 = $this->input->post('work_files_name', TRUE);
        $work_files_name2 = $work_files_name1[$all_section_counter[$i]][$all_video_work_file_counter[$j]];
        $work_files_name = trim(preg_replace('/\s+/', ' ', $work_files_name2));
        if ($video_work_file_info->work_files_name != $work_files_name) {
            $data['work_files_name'] = $work_files_name;
            $data['work_files_url'] = $section_directory . '/' . "$work_files_name.$file_extension";

            $old_video_file = 'content-library/' . $course_creator_url . '/my-video/' . $video_work_file_info->video_folder_name . '/' . $data['work_file_folder_name'] . '/' . "$video_work_file_info->work_files_name.$file_extension";
            $new_video_file = 'content-library/' . $course_creator_url . $data['work_files_url'];
            if (file_exists($old_video_file)) {
                rename($old_video_file, $new_video_file);
            }
        } else {
            $data['work_files_name'] = $video_work_file_info->work_files_name;
            $data['work_files_url'] = $section_directory . '/' . "$video_work_file_info->work_files_name.$file_extension";
        }

        $work_files_management_access_level1 = $this->input->post('work_files_management_access_level', TRUE);
        if(isset($work_files_management_access_level1[$all_section_counter[$i]][$all_video_work_file_counter[$j]])){
            $work_files_management_access_level = $work_files_management_access_level1[$all_section_counter[$i]][$all_video_work_file_counter[$j]];
            if ($video_work_file_info->work_files_management_access_level != $work_files_management_access_level) {
                $data['work_files_management_access_level'] = $work_files_management_access_level;
            } else {
                $data['work_files_management_access_level'] = $video_work_file_info->work_files_management_access_level;
            }
        }
        else {
            $data['work_files_management_access_level'] = $video_work_file_info->work_files_management_access_level;
        }
        $data['work_files_status'] = 1;
        $this->update_information_in_database('tbl_work_files_management', 'work_files_management_id', $all_upload_video_work_file_id[$j], $data);
    }

    /**
     * @Function            : get_all_course_by_category_id 
     * @Used IN             : @function-'get_video_course_value_by_category_id'    super_admin_video[@Controller],
     * @Description         : view all course using category ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 04:51 PM
     * @Status              : available      
     * */
    function get_all_course_by_category_id($category_id) {
        $video_management_id = $this->get_unique_video_course_id_in_upload_video_tbl();
        $sql = "SELECT *
                FROM
                    tbl_video_management AS vm
                WHERE 
                    vm.course_category_id = '$category_id'
                    AND (vm.video_management_status = '1' OR vm.video_management_status = '4')";
        if ($video_management_id) {
            $sql.=" AND vm.video_management_id NOT IN ($video_management_id)";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_unique_video_course_id_in_upload_video_tbl 
     * @Used IN             : @function-'get_all_course_by_category_id'     this[@Model],
     * @Description         : view all course using category ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 04:21 PM
     * @Status              : available      
     * */
    function get_unique_video_course_id_in_upload_video_tbl() {
        $video_course_id_array = array();
        $sql = "SELECT DISTINCT video_management_id
                FROM 
                    tbl_upload_video";
        $result = $this->db->query($sql)->result();
        foreach ($result as $value) {
            $video_course_id_array[] = $value->video_management_id;
        }
        return implode(',', $video_course_id_array);
    }

    /**
     * @Function            : check_video_course_section_name 
     * @Used IN             : @function-'check_video_section_name_existence'    super_admin_video[@Controller],
     * @Description         : check video section name
     * @                    : @Update1 ->add all_upload_id in SQL QUery
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-02-2016 05:51 PM
     * @Updated Date Time   : 23-02-2016 12:08 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    function check_video_course_section_name($video_management_id, $video_section_name, $all_upload_id) {
        $sql = "SELECT *
                FROM
                    tbl_upload_video AS uv
                WHERE 
                 uv.video_management_id = '$video_management_id'
                 AND uv.upload_video_section_name = '$video_section_name'";
        if ($all_upload_id) {
            $sql.= " AND uv.upload_video_id NOT IN ($all_upload_id)";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_upload_video_name 
     * @Used IN             : @function-'check_video_name_existence'    super_admin_video[@Controller],
     * @Description         : check upload video name
     * @                    : @update1 ->check upload_video_id in Query
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-02-2016 01:16 PM
     * @Updated Date Time   : 23-02-2016 12:11 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    function check_upload_video_name($video_management_id, $video_section_name, $video_name, $upload_video_id) {
        $sql = "SELECT *
                FROM
                    tbl_upload_video AS uv
                WHERE 
                 uv.video_management_id = '$video_management_id'
                 AND uv.upload_video_section_name = '$video_section_name'
                 AND uv.upload_video_name = '$video_name'";
        if ($upload_video_id != '') {
            $sql.=" AND uv.upload_video_id != '$upload_video_id'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_video_course_work_file_name_existence 
     * @Used IN             : @function-'check_video_course_work_file_name_existence'    super_admin_video[@Controller],
     * @Description         : check video course work file name existence
     * @                    : @Update1 - change query (check all_upload id in single section name)
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 12:01 PM
     * @Updated Date Time   : 20-02-2016 11:27 PM
     * @Updated By          : Ripon Jaherul  
     * @Status              : available      
     * */
    function check_video_course_work_file_name_existence($all_upload_video_id, $work_files_name, $upload_video_id) {
        $sql = "SELECT *
                FROM 
                    tbl_work_files_management AS wfm
                WHERE 
                    wfm.upload_video_id IN ($all_upload_video_id)
                AND wfm.work_files_name = '$work_files_name'";
        if ($upload_video_id != '') {
            $sql.=" AND wfm.upload_video_id != '$upload_video_id'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_upload_video_information_by_upload_video_id 
     * @Used IN             : @function-'upload_video_course_work_file'                 super_admin_video[@Controller]
     * @                    : @function-'upload_video_for_video_course'                 super_admin_video[@Controller]-2 times
     * @                    : @function-'check_video_name_existence'                    super_admin_video[@Controller]
     * @                    : @function-'check_video_course_work_file_name_existence'   super_admin_video[@Controller]
     * @                    : @function-'delete_single_video_course_area'               super_admin_video[@Controller]
     * @                    : @function-'remove_video_course_section_area'              super_admin_video[@Controller]
     * @                    : @function-'save_video_course_work_file'                   this[@Model]
     * @                    : @function-'save_upload_video_information'                 this[@Model]
     * @                    : @function-'save_video_course_work_file'                   this[@Model]
     * @Description         : get all upload video information using upload_video_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 12:01 PM
     * @Status              : available      
     * */
    function get_upload_video_information_by_upload_video_id($upload_video_id) {
        $sql = "SELECT * ,vm.person_id AS course_creator_id
                FROM 
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm
                WHERE 
                    uv.video_management_id = vm.video_management_id
                AND uv.upload_video_id = '$upload_video_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : delete_single_video_course_by_upload_video_id 
     * @Used IN             : @function-'delete_single_video_course_area'     super_admin_video[@Controller] 2-times
     * @Description         : delete uploaded video in upload_video_course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 06:01 PM
     * @Status              : available      
     * */
    function delete_single_video_course_by_upload_video_id($upload_video_id) {
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->delete('tbl_upload_video');
    }

    /**
     * @Function            : get_upload_video_work_file_info_by_work_file_id 
     * @Used IN             : @function-'upload_video_course_work_file'          super_admin_video[@Controller],
     * @                    : @function-'remove_upload_video_course_work_file'   super_admin_video[@Controller],
     * @                    : @function-'delete_single_video_course_area'        super_admin_video[@Controller],
     * @                    : @function-'save_video_work_file_information'       super_admin_video[@Controller],
     * @Description         : get all upload video work file Information using $work_file_ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 12:01 PM
     * @Status              : available      
     * */
    function get_upload_video_work_file_info_by_work_file_id($work_file_id) {
        $sql = "SELECT *, vm.person_id AS course_creator_id
                FROM
                    tbl_work_files_management AS wfm,
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm
                WHERE 
                    wfm.work_files_management_id = '$work_file_id'
                AND wfm.upload_video_id = uv.upload_video_id
                AND uv.video_management_id = vm.video_management_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_upload_video_work_file_info_by_work_file_id 
     * @Used IN             : @function-'delete_single_video_course_area'           super_admin_video[@Controller]
     * @                    : @function-'get_work_file_info_by_video_upload_id'     super_admin_video[@Controller]
     * @                    : @function-'edit_video_course_work_file'               super_admin_video[@Controller]
     * @                    : @function-'delete_single_video_course_area'           super_admin_video[@Controller]
     * @Description         : get video work file using video_upload _id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-02-2016 06:36 PM
     * @Status              : available      
     * */
    function get_work_file_info_by_video_upload_id($upload_video_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_work_files_management AS wfm
                WHERE 
                    wfm.upload_video_id = '$upload_video_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : change_work_file_status_in_course_video 
     * @Used IN             : @function-'upload_video_course_work_file'           super_admin_video[@Controller],
     * @                    : @function-'remove_upload_video_course_work_file'    super_admin_video[@Controller],
     * @Description         : change work file status in 'tbl_upload_video'
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 05:26 PM
     * @Status              : available      
     * */
    function change_work_file_status_in_course_video($upload_video_id, $status) {
        $this->db->set('video_work_files', $status);
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    /**
     * @Function            : remove_upload_video_course_work_file_by_work_file_id 
     * @Used IN             : @function-'remove_upload_video_course_work_file'    super_admin_video[@Controller],
     * @Used IN             : @function-'delete_single_video_course_area'         super_admin_video[@Controller]-2 times
     * @Description         : Remove work file from database using work_file_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 05:27 PM
     * @Status              : available      
     * */
    function remove_upload_video_course_work_file_by_work_file_id($work_files_management_id) {
        $this->db->where('work_files_management_id', $work_files_management_id);
        $this->db->delete('tbl_work_files_management');
    }

    /**
     * @Function            : get_all_upload_id_by_section_name1 
     * @Used IN             : @function-'edit_video_course_work_file'        super_admin_video[@Controller],
     * @                    : @function-'delete_single_video_course_area'    super_admin_video[@Controller],
     * @Description         : get all upload video id using Upload_video_section_name
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-02-2016 12:06 AM
     * @Status              : available      
     * */
    function get_all_upload_id_by_section_name1($video_course_id, $upload_video_section_name) {
        $sql = "SELECT *
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.upload_video_section_name = '$upload_video_section_name'
                    AND uv.video_management_id = '$video_course_id'
                    ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : delete_all_course_video_file 
     * @Used IN             : @function-'delete_video_course_all_video_file'        super_admin_video[@Controller]
     * @Description         : Delete all course work file using video_upload_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-02-2016 01:40 PM
     * @Status              : available      
     * */
    function delete_all_course_video_file($all_upload_id) {
        $sql = "DELETE uv 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.upload_video_id IN ($all_upload_id)";
        $this->db->query($sql);
    }

    /**
     * @Function            : delete_all_video_course_work_file 
     * @Used IN             : @function-'delete_video_course_all_video_file'        super_admin_video[@Controller]
     * @Description         : Delete all course work file using video_upload_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-02-2016 01:37 PM
     * @Status              : available      
     * */
    function delete_all_video_course_work_file($all_upload_id) {
        $sql = "DELETE wfm 
                FROM 
                    tbl_work_files_management wfm
                WHERE 
                    wfm.upload_video_id IN ($all_upload_id)";
        $this->db->query($sql);
    }

    /*
      -----------@@@RIPON@ End Video Course Work File Part----------------------------------
     */














    /*
     * Save Video Management Information 
     * @Author          : Mahabub-A-Mawla
     * @function Name   : save_video_management_information
     * @paremeter       : none
     * @return          : none
     */

    public function save_video_management_information() {

        $data['resource_person_id'] = $this->session->userdata('person_id');
        $data['video_folder_name'] = $this->input->post('video_folder_name', TRUE);
        $data['video_title'] = $this->input->post('video_title', TRUE);
        $video_url = $this->input->post('video_url', TRUE);
        $data['video_price'] = $this->input->post('video_price', TRUE);
        $data['video_work_files'] = $this->input->post('video_work_files', TRUE);
        $data['video_training_objectives'] = $this->input->post('video_training_objectives', TRUE);
        $data['video_training_outline'] = $this->input->post('video_training_outline', TRUE);
        $data['video_management_meta_description'] = $this->input->post('video_management_meta_description', TRUE);
        $data['video_management_meta_keywords'] = $this->input->post('video_management_meta_keywords', TRUE);
        $data['video_management_author'] = $this->input->post('video_management_author', TRUE);
        $data['video_management_status'] = $this->input->post('video_status', TRUE);
        $data['video_permissions'] = $this->input->post('video_permissions', TRUE);
        $data['video_access_level'] = $this->input->post('video_access_level', TRUE);
        $data['video_language'] = $this->input->post('video_language', TRUE);

        /*
         * Save URL Information 
         */

        $url_data['url'] = $video_url;
        $url_data['url_type'] = 8;
        $url_data['url_status'] = 1;
        $this->db->insert('tbl_url', $url_data);
        $url_id = $this->db->insert_id();
        $data['url_id'] = $url_id;

        /*
         * Manage Category or Other Category
         */
        $course_category = $this->input->post('group_type', TRUE);
        if ($course_category == 'other') {
            $ndata = array();
            $ndata['course_category_name'] = $this->input->post('group_other_type', TRUE);
            $this->db->insert('tbl_course_category', $ndata);
            $data['course_category_id'] = $this->db->insert_id();
        } else {
            $data['course_category_id'] = $this->input->post('group_type', TRUE);
        }

        $this->db->insert('tbl_video_management', $data);
    }

//    public function save_upload_video_information($data) {
//        $this->db->insert('tbl_upload_video', $data);
//        $upload_video_id = $this->db->insert_id();
//        return $upload_video_id;
//    }

    public function save_upload_file_information($wdata) {
        $this->db->insert('tbl_work_files_management', $wdata);
    }

    public function select_video_category() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm,"
                . "     tbl_course_category as cc"
                . " WHERE "
                . "     vm.course_category_id = cc.course_category_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_video_training_list($category_id = NULL) {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        if ($category_id) {
            $this->db->where('course_category_id', $category_id);
        }
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_video_item($category = null, $start, $limit, $status = null, $short = null) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_upload_video as uv, "
                . "     tbl_video_management as vm "
                . "     "
                . " WHERE "
                . "         uv.video_management_id = vm.video_management_id "
                . "     AND vm.course_category_id = cc.course_category_id";

        if ($limit != '' && $limit != 'all' && $start >= 0) {
            $sql .= " LIMIT $start, $limit ";
        }

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_video_management_info($video_management_id) {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        $this->db->where('video_management_id', $video_management_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_video_by_id($video_id) {
        $this->db->select('*');
        $this->db->from('tbl_upload_video');
        $this->db->where('upload_video_id', $video_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_video_item_by_management_id($video_management_id) {
        $sql = "SELECT * FROM tbl_upload_video as uv WHERE uv.video_management_id = $video_management_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_video_item($video_management_id = null, $video_id) {
        $sql = "SELECT * FROM tbl_upload_video as uv WHERE uv.video_management_id = $video_management_id AND uv.upload_video_id != $video_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /*
     * Video Active, Inactive, Archive 
     */

    public function make_video_active($upload_video_id) {
        $this->db->set('upload_video_status', '1');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function make_video_inactive($upload_video_id) {
        $this->db->set('upload_video_status', '0');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function archive_video($upload_video_id) {
        $this->db->set('upload_video_status', '2');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    /*
     * END Video Active, Inactive, Archive
     */

    public function select_all_video_management_item($category = null, $start, $limit, $status = null, $short = null) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_upload_video as uv, "
                . "     tbl_video_management as vm,"
                . "     tbl_person as p"
                . " WHERE "
                . "         uv.video_management_id = vm.video_management_id "
                . "     AND p.person_id = vm.resource_person_id "
                . "     AND vm.course_category_id = cc.course_category_id ";
        $sql .= " GROUP BY vm.video_management_id";
        if ($limit != '' && $limit != 'all' && $start >= 0) {
            $sql .= " LIMIT $start, $limit ";
        }

        $result = $this->db->query($sql)->result();
        return $result;
    }

    /*
     * Start Video Management Active, Inactive, Archive
     */

    public function make_video_management_active($video_management_id) {
        $this->db->set('video_management_status', '1');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    public function make_video_management_inactive($video_management_id) {
        $this->db->set('video_management_status', '0');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    public function archive_video_management($video_management_id) {
        $this->db->set('video_management_status', '2');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    /*
     * END Video Management Active, Inactive, Archive
     */




    /*
     * Start Video Course function @@this will be deleted after complete Course/ideo course
     */

    public function select_all_menu($course_menu_id1 = NULL) {
        $course_menu_id_string = '';
        $menu_url_id_array = explode(',', $this->get_assigned_menu_url_id_in_course());
        $course_menu_id_array = explode(',', $this->get_menu_id_by_url_id($menu_url_id_array));
        $video_course_menu_id = $this->get_video_course_menu_id();
        if ($video_course_menu_id) {
            foreach ($video_course_menu_id as $value) {
                $course_menu_id_array[] = $value->menu_id;
            }
        }
        if ($course_menu_id_array) {
            $course_menu_id_string = implode(",", array_filter($course_menu_id_array));
        }

        $sql = "SELECT * 
                FROM 
                    `tbl_menu`
                WHERE 
                    `menu_section` != '0' AND menu_status = '1' AND menu_type = '1'";
        if ($course_menu_id_string != '') {
            $sql.= " AND menu_id NOT IN ($course_menu_id_string)";
        }
        if ($course_menu_id1 != NULL) {
            $sql.=" OR menu_id = '$course_menu_id1'";
        }
        return $this->db->query($sql)->result();
    }

    function get_menu_id_by_url_id($url_id_array) {
        return $this->db->select('GROUP_CONCAT(menu_id) AS menu_id')->from('tbl_menu')
                        ->where_in('url_id', $url_id_array)->get()->row()->menu_id;
    }

    public function get_video_course_menu_id() {
        $sql = "SELECT 
                    menu_id
                FROM 
                    tbl_video_management
                WHERE 
                    menu_id != '0'";
        return $this->db->query($sql)->result();
    }

    function get_assigned_menu_url_id_in_course() {
        $course_url_id = $this->get_all_course_url_id();
        if ($course_url_id != '') {
            return $this->super_admin_model->get_all_menu_url_id($course_url_id);
        } else {
            return '';
        }
    }

    function get_all_course_url_id() {
        $this->db->select('GROUP_CONCAT(c.url_id) AS course_url_id')->from('tbl_course AS c');
        return $this->db->get()->row()->course_url_id;
    }

    public function select_all_course_category_for_course() {
        $sql = "SELECT * 
                FROM 
                    `tbl_course_category`
                WHERE 
                    (course_category_status = '1' OR course_category_status = '5')";
        return $this->db->query($sql)->result();
    }

    public function select_all_resource_persons() {
        $sql = "SELECT * 
                FROM 
                    tbl_person as p, 
                    tbl_resource_person as rp
                WHERE 
                    p.person_id= rp.person_id
                    AND rp.resource_person_type = '1'
                    AND p.person_status = '1'";
        return $this->db->query($sql)->result();
    }

    public function select_all_course_category_name() {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS cc
                WHERE 
                    (cc.course_category_status = '1' 
                    OR cc.course_category_status = '5')";
        return $this->db->query($sql)->result();
    }

    /**
     * Date :
      Name: Ripon
      Work: save_course_category_information (back end)
      Update : 18-01-2016
     */
    public function save_course_category_information($course_category_url_id) {
        $data = array();

        if ($this->input->post('course_category_meta_description', TRUE)) {
            $data['course_category_meta_description'] = $this->get_tinymce_description_value($this->input->post('course_category_meta_description', TRUE));
        }

        if ($this->input->post('course_category_description', TRUE)) {
            $data['course_category_description'] = $this->get_tinymce_description_value($this->input->post('course_category_description', TRUE));
        }


        $data['course_category_name'] = $this->input->post('course_category_name', TRUE);

        $data['person_id'] = $this->input->post('person_id', TRUE);
        if ($this->input->post('course_category_id', TRUE)) {
            $data['course_category_parent_id'] = $this->input->post('course_category_id', TRUE);
        }

        if ($this->input->post('course_category_meta_keywords', TRUE)) {
            $data['course_category_meta_keywords'] = implode(",", $this->input->post('course_category_meta_keywords', TRUE));
        }
        $data['course_category_author'] = $this->input->post('course_category_author', TRUE);

        $data['course_category_access_level'] = $this->input->post('course_category_access_level', TRUE);

        if ($this->input->post('course_category_home_page_view', TRUE) == '') {
            $data['course_category_home_page_view'] = 1;
        } else {
            $data['course_category_home_page_view'] = $this->input->post('course_category_home_page_view', TRUE);
        }

        $data['course_category_status'] = $this->input->post('course_category_status', TRUE);  //this value Comes From Hidden Field (which selected by controller function add_course_category OR add_video_course_category)


        /*
         * Save URL Information 
         */
        $data['url_id'] = $course_category_url_id;
//        
        $this->db->insert('tbl_course_category', $data);
    }

    public function check_category_name_existance($category_name1) {
        $category_name = str_replace("%20", ' ', $category_name1);
        $sql = "SELECT * 
                FROM 
                    tbl_course_category
                WHERE 
                    course_category_name = '$category_name'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : total_course_category 
     * @Used IN             : @function-'manage_course_category'            super_admin_course[@controller],
     * @                    : @function-'get_course_category_by_status'     super_admin_course[@controller],
     * @                    : @function-'search_course_category'            super_admin_course[@controller],
     * @Description         : get total course for pagination  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 06-02-2016 06:48 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function total_course_category($status, $search_value) {
        $sql = "SELECT 
                    count(*) AS total_course_category
                FROM 
                    tbl_course_category AS c,
                    tbl_url AS u
                WHERE 
                    c.url_id = u.url_id";
        if ($status != '') {
            $sql.=" AND course_category_status = '$status'";
        }
        if ($search_value != '') {
            $sql.=" AND (c.course_category_name LIKE '%$search_value%')";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_all_course_category 
     * @Used IN             : @function-'manage_course_category'           super_admin_course[@controller],
     * @                    : @function-'get_course_category_by_status'    super_admin_course[@controller],
     * @                    : @function-'search_course_category'           super_admin_course[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 06-02-2016 05:44 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function select_all_course_category($sort, $search_value, $status, $number) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    c.person_id = p.person_id
                AND c.url_id = u.url_id";
        if ($status != '') {
            $sql.=" AND c.course_category_status = '$status'";
        }
        if ($search_value != '') {
            $sql.=" AND (c.course_category_name LIKE '%$search_value%')";
        }
        if ($sort != '') {
            $sql.=" ORDER BY c.course_category_name $sort";
        }
        if ($sort == '' && $status == '') {
            $sql.=" ORDER BY c.course_category_id ASC";
        }
        $sql.=" LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_parent_course_category 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown    
     * @Status              : available      
     * */
    public function get_parent_course_category($course_category_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category
               	    WHERE course_category_id = '$course_category_id'";
        return $this->db->query($sql)->row();
    }

    public function change_course_category_action($category_id, $type) {
        if ($type == 'delete') {
            $sql = "DELETE c,u
                    FROM 
                        tbl_course_category AS c,
                        tbl_url AS u
                    WHERE 
                        c.course_category_id = '$category_id' 
                    AND c.url_id = u.url_id";
            $this->db->query($sql);
        } else {
            switch ($type) {
                case 'public':
                    $this->db->set('course_category_access_level', 1);
                    break;
                case 'tt_user':
                    $this->db->set('course_category_access_level', 2);
                    break;
                case 'yes':
                    $this->db->set('course_category_home_page_view', 2);
                    break;
                case 'no':
                    $this->db->set('course_category_home_page_view', 1);
                    break;
                case 'active':
                    $this->db->set('course_category_status', 1);
                    break;
                case 'inactive':
                    $this->db->set('course_category_status', 2);
                    break;
                case 'pending':
                    $this->db->set('course_category_status', 4);
                    break;
                case 'approved':
                    $this->db->set('course_category_status', 5);
                    break;
                case 'archive':
                    $this->db->set('course_category_status', 3);
                    break;
            }
            $this->db->where('course_category_id', $category_id);
            $this->db->update('tbl_course_category');
        }
    }

    /**
     * @Function            : select_category_value_by_category_id 
     * @Used IN             : @function-'check_home_view_status'  super_admin_course[@controller], also using other @function
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : unknown
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function select_category_value_by_category_id($category_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS  c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    c.course_category_id = '$category_id'
                AND c.person_id = p.person_id
                AND c.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    function check_course_by_category_id($category_id) {
        $sql = "SELECT * FROM tbl_video_management WHERE course_category_id = '$category_id'";
        return $this->db->query($sql)->result();
    }

    function check_course_name_exists($course_name1) {
        $course_name = str_replace("%20", ' ', $course_name1);
        $sql = "SELECT * FROM tbl_course WHERE course_name = '$course_name'";
        return $this->db->query($sql)->row();
    }

    public function check_category_child_id($id) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category
                WHERE 
                    course_category_parent_id = '$id'";
        return $this->db->query($sql)->result();
    }

    public function get_single_category_by_url($category_url) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS c,
                    tbl_url AS u
                WHERE 
                    c.url_id = u.url_id
                AND u.url = '$category_url'";
        return $this->db->query($sql)->row();
    }

    public function select_all_course_category_name_for_edit($category_url) {
        $category_id = $this->get_category_id($category_url)->course_category_id;
        $category_id_array = $this->get_child_id_in_array($category_id);
        $category_string = implode(",", $category_id_array);

        $sql = "SELECT *
                FROM 
                    tbl_course_category
                WHERE 
                    course_category_id != '$category_id'";
        if ($category_string) {
            $sql.=" AND course_category_id NOT IN ($category_string)";
        }
        return $this->db->query($sql)->result();
    }

    public function get_category_id($param) {
        $sql = "SELECT c.course_category_id
                FROM 
                    tbl_course_category AS c,
                    tbl_url AS u
                WHERE 	
                    c.url_id = u.url_id
                AND u.url = '$param'";
        return $this->db->query($sql)->row();
    }

    function get_child_id_in_array($category_id) {
        $category_id_array = Array();

        $result = $this->get_child_id($category_id);
        foreach ($result as $value) {
            $category_id_array[] = $value->course_category_id;
//            $this->get_child_id_in_array($value->course_category_id);

            $result1 = $this->get_child_id($value->course_category_id);
            foreach ($result1 as $value1) {
                $category_id_array[] = $value1->course_category_id;

                $result2 = $this->get_child_id($value1->course_category_id);
                foreach ($result2 as $value2) {
                    $category_id_array[] = $value2->course_category_id;

                    $result3 = $this->get_child_id($value2->course_category_id);
                    foreach ($result3 as $value3) {
                        $category_id_array[] = $value3->course_category_id;
                    }
                }
            }
        }
        return $category_id_array;
    }

    public function get_child_id($course_id) {
        $sql = "SELECT course_category_id
                FROM 
                    tbl_course_category
                WHERE 
                    course_category_parent_id = '$course_id'";
        return $this->db->query($sql)->result();
    }

    public function update_course_category_information($category_id) {
        $category_info = $this->select_category_value_by_category_id($category_id);

        $data = array();
        if ($this->input->post('course_category_meta_description', TRUE)) {
            $data['course_category_meta_description'] = $this->get_tinymce_description_value_for_edit($this->input->post('course_category_meta_description', TRUE), $category_info->course_category_meta_description);
        }
        if ($this->input->post('course_category_description', TRUE)) {
            $data['course_category_description'] = $this->get_tinymce_description_value_for_edit($this->input->post('course_category_description', TRUE), $category_info->course_category_description);
        }

        $data['course_category_name'] = $this->input->post('course_category_name', TRUE);
        $data['person_id'] = $this->input->post('person_id', TRUE);
        if ($this->input->post('course_category_id', TRUE)) {
            $data['course_category_parent_id'] = $this->input->post('course_category_id', TRUE);
        }

        if ($this->input->post('course_category_meta_keywords', TRUE)) {
            $data['course_category_meta_keywords'] = implode(",", $this->input->post('course_category_meta_keywords', TRUE));
        }

        $data['course_category_author'] = $this->input->post('course_category_author', TRUE);

        $data['course_category_access_level'] = $this->input->post('course_category_access_level', TRUE);

        if ($this->input->post('course_category_home_page_view', TRUE) == '') {
            $data['course_category_home_page_view'] = 1;
        } else {
            $data['course_category_home_page_view'] = $this->input->post('course_category_home_page_view', TRUE);
        }

        $data['course_category_status'] = $this->input->post('course_category_status', TRUE);  //this value Comes From Hidden Field (which selected by controller function add_course_category OR add_video_course_category)

        /*
         * Save URL Information 
         */

        $this->db->where('course_category_id', $category_id);
        $this->db->update('tbl_course_category', $data);
    }

    /*
      -----------@@@RIPON@ Start Course Topic Part----------------------------------
     */

    /**
     * @Function            : save_course_topic 
     * @Used IN             : @Function-(add_course_topic)           super_admin_course[@controller],
     * @Description         : Save Course Topic for view course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 09:38 AM
     * @Status              : available      
     * */
    function save_course_topic() {
        $data['course_topic_name'] = $this->input->post('course_topic_name', TRUE);
        $this->db->insert('tbl_course_topic', $data);
    }

    /**
     * @Function            : select_all_course_topic_name 
     * @Used IN             : @Function-(manage_course_topic)           super_admin_course[@controller],
     * @Description         : Save Course Topic for view course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:07 AM
     * @Status              : available      
     * */
    function select_all_course_topic_name() {
        $sql = "SELECT * FROM tbl_course_topic";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : delete_course_topic_by_topic_id 
     * @Used IN             : @Function-(delete_course_topic)           super_admin_course[@controller],
     * @Description         : Delete Course Topic using Topic_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:46 AM
     * @Status              : available      
     * */
    function delete_course_topic_by_topic_id($course_topic_id) {
        $this->db->where('course_topic_id', $course_topic_id);
        $this->db->delete('tbl_course_topic');
    }

    /**
     * @Function            : check_course_topic_name_existence 
     * @Used IN             : @Function-(delete_course_topic)           super_admin_course[@controller],
     * @Description         : Save Course Topic for view course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 10:07 AM
     * @Status              : available      
     * */
    function check_course_topic_name_existence($course_topic_name) {
        $sql = "SELECT * FROM tbl_course_topic
                WHERE course_topic_name = '$course_topic_name'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : person_available_disk_space (copied from 'Welcome_model') 
     * @Used IN             : @function-'person_available_disk_space'                      super_admin_course[@controller],
     * @                    : @function-'view_video_course_file_size_by_video_course_id'   super_admin_video[@controller],
     * @Description         : full size of content library for login user 
     * @Developed By        : Ripon Jahrul 
     * @Start DateTime      : 02-02-2016 04:10 PM      
     * */
    public function person_available_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->person_available_disk_space($each);
        }
        return $size;
    }

    /**
     * @Function            : select_all_topic 
     * @Used IN             : @Function-'index'                     course[@controller],
     * @                    : @Function-'get_more_course_topic'     course[@controller],
     * @                    : @Function-'index'                     video_course[@controller],
     * @Description         : get all topic which have useded as technology 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 11:57 AM
     * @Status              : Available      
     * */
    public function select_all_topic($counter) {
        $sql = "SELECT * FROM tbl_course_topic LIMIT $counter";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_topic 
     * @Used IN             : @Function-'index'                     course[@controller],
     * @                    : @Function-'get_more_course_topic'     course[@controller],
     * @                    : @Function-'index'                     video_course[@controller]
     * @Description         : get all topic which have useded as technology 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 07-02-2016 11:57 AM
     * @Status              : Available      
     * */
    public function get_total_topic() {
        $sql = "SELECT count(*) AS total_topic FROM tbl_course_topic ";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End Course Topic Part----------------------------------
     */
}
