<?php

class Super_admin_quiz_model extends CI_Model {

//put your code here
    public function admin_login_check($data) {
        $this->db->select('*');
        $this->db->from('tbl_person_information pi');
        $this->db->where('email', $data['user_email']);
        $this->db->where('password', md5($data['user_password']));
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function check_topic_name_existance($topic_name) {
        $sql = "SELECT * FROM tbl_topic as q WHERE q.topic_name LIKE '$topic_name'";
        $result = $this->db->query($sql)->row();
        if ($result) {
            return 1;
        } else {
            return 2;
        }
    }

    public function check_quiz_public_id($public_id) {
        $sql = "SELECT * FROM tbl_quiz as q WHERE q.quiz_public_id = '$public_id'";
        $result = $this->db->query($sql)->row();
        if ($result) {
            return 1;
        } else {
            return 2;
        }
    }

    public function save_unique_url($url, $url_type, $url_status) {
        $url = preg_replace('/[^A-Za-z0-9 -]/', '', $url);
        $url = str_replace('.', '-', $url);
        $url = str_replace(' ', '-', $url);
        $url = $temp_url = strtolower($url);
        $i = 1;
        do {
            $sql = "SELECT * FROM tbl_url as u WHERE u.url = '$temp_url'";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $temp_url = $url;
                $temp_url .=$i;
                $i++;
            }
        } while ($result);

        $url = $temp_url;
        $url_data['url'] = $url;
        $url_data['url_type'] = $url_type;
        $this->db->insert('tbl_url', $url_data);
        return $this->db->insert_id();
    }

   

    /* END topic management */

    public function save_quiz_info() {
        $person_id = $this->session->userdata('person_id');
        $data = array();
        $data['quiz_name'] = $this->input->post('quiz_name', true);
        $data['quiz_topics_specification'] = $this->input->post('quiz_topics_specification', true);
        $data['total_number_of_question'] = $this->input->post('total_number_of_question', true);
//        $data['total_time'] = $this->input->post('total_time', true);
        $url = $this->input->post('quiz_url', true);
        $data['url_id'] = $quiz_url_id = $this->url_model->create_quiz_url($url);
        $data['quiz_public_id'] = strtolower($this->input->post('quiz_public_id', true));

        $data['quiz_random_static'] = $this->input->post('quiz_random_static', true);
//        if ($data['quiz_random_static'] == 1) {
//            $data['total_number_of_question'] = $this->input->post('total_number_of_question', true);
//            $data['total_number_of_question'] = $this->input->post('total_number_of_question', true);
//        } else {
            $data['total_number_of_question'] = 0;
//        }

//        $data['quiz_permission'] = $this->input->post('quiz_permission', true);
        $data['quiz_pulication_status'] = $this->input->post('quiz_pulication_status', true);
        $data['quiz_created_by'] = $this->session->userdata('person_id');
        $data['quiz_created_date_time'] = date('Y-m-d H:i:s', time() - $this->session->userdata('time_offset'));
        $data['quiz_status'] = $this->input->post('quiz_status', true);

        $this->db->insert('tbl_quiz', $data);
        $quiz_id = $this->db->insert_id();

        $this->quiz_model->save_quiz_all_tinymce_information($person_id, $quiz_id, $quiz_url_id);   //used to save tinymce information
        return $quiz_id;
    }

    public function update_quiz_info($data) {
        $quiz_url = $data['quiz_url'];
        $quiz_id = $data['quiz_info']->quiz_id;
        $quiz_url_id = $data['quiz_info']->url_id;
        $quiz_created_by = $data['quiz_info']->quiz_created_by;
        $pre_quiz_description = $data['quiz_info']->quiz_description;
        $person_url = $this->person_model->get_profile_url($quiz_created_by);
        $first_question = $this->select_quiz_first_question($quiz_id);
        $id_list = $data['id_list'];
        $data = array();
        if ($this->input->post('quiz_description', FALSE)) {        //added by tania
            $quiz_description_update = $this->utility_model->update_tinymce_information($quiz_id, $person_url, $quiz_url, $this->input->post('quiz_description', FALSE), $pre_quiz_description);
            $qdata['quiz_description'] = $this->utility_model->changed_special_character_to_text($quiz_description_update);
        }

        $qdata['quiz_name'] = $this->input->post('quiz_name', true);
        $qdata['quiz_topics_specification'] = $this->input->post('quiz_topics_specification', true);

        $qdata['total_number_of_question'] = $this->input->post('total_number_of_question', true);
        $qdata['total_time'] = $this->input->post('total_time', true);

        $url_id = $this->input->post('url_id', true);
        $url = strtolower($this->input->post('quiz_url', true));

        $this->url_model->update_quiz_url($url_id, $url);

        $qdata['quiz_public_id'] = strtolower($this->input->post('quiz_public_id', true));

        $qdata['quiz_random_static'] = $this->input->post('quiz_random_static', true);
//        if ($qdata['quiz_random_static'] == 1) {
//            $qdata['total_number_of_question'] = $this->input->post('total_number_of_question', true);
//        }

//        $qdata['quiz_permission'] = $this->input->post('quiz_permission', true);
        $qdata['quiz_pulication_status'] = $quiz_pulication_status = $this->input->post('quiz_pulication_status', true);
        $qdata['quiz_created_by'] = $this->session->userdata('person_id');
        $qdata['quiz_updated_date_time'] = date('Y-m-d H:i:s', time() - $this->session->userdata('time_offset'));
        $qdata['quiz_status'] = $this->input->post('quiz_status', true);

        $this->db->where('quiz_id', $quiz_id);
        $this->db->update('tbl_quiz', $qdata);

        if ($quiz_pulication_status == 4) {
            $previous_id = explode(',', $id_list);
            $selected_id = $this->input->post('selected_id', true);
            $selected_id = explode(',', $selected_id);
            for ($i = 0; $i < count($previous_id); $i++) {
                if (!in_array($previous_id[$i], $selected_id)) {
                    $this->db->where('quiz_id', $quiz_id);
                    $this->db->where('group_id', $previous_id[$i]);
                    $this->db->delete('tbl_group_quiz_permission');
                }
            }

            for ($i = 0; $i < count($selected_id); $i++) {
                if (!in_array($selected_id[$i], $previous_id)) {
                    $g_data = array();
                    $g_data['group_id'] = $selected_id[$i];
                    $g_data['quiz_id'] = $quiz_id;
                    $this->db->insert('tbl_group_quiz_permission', $g_data);
                }
            }
        } else if ($quiz_pulication_status == 5) {
            $previous_id = explode(',', $id_list);
            $selected_id = $this->input->post('selected_id', true);
            $selected_id = explode(',', $selected_id);
            for ($i = 0; $i < count($previous_id); $i++) {
                if (!in_array($previous_id[$i], $selected_id)) {
                    $this->db->where('quiz_id', $quiz_id);
                    $this->db->where('course_id', $previous_id[$i]);
                    $this->db->delete('tbl_course_quiz_permission');
                }
            }

            for ($i = 0; $i < count($selected_id); $i++) {
                if (!in_array($selected_id[$i], $previous_id)) {
                    $g_data = array();
                    $g_data['course_id'] = $selected_id[$i];
                    $g_data['quiz_id'] = $quiz_id;
                    $this->db->insert('tbl_course_quiz_permission', $g_data);
                }
            }
        } else if ($quiz_pulication_status == 6) {
            $previous_id = explode(',', $id_list);
            $selected_id = $this->input->post('selected_id', true);
            $selected_id = explode(',', $selected_id);
            for ($i = 0; $i < count($previous_id); $i++) {
                if (!in_array($previous_id[$i], $selected_id)) {
                    $this->db->where('quiz_id', $quiz_id);
                    $this->db->where('video_management_id', $previous_id[$i]);
                    $this->db->delete('tbl_video_course_quiz_permission');
                }
            }

            for ($i = 0; $i < count($selected_id); $i++) {
                if (!in_array($selected_id[$i], $previous_id)) {
                    $g_data = array();
                    $g_data['video_management_id'] = $selected_id[$i];
                    $g_data['quiz_id'] = $quiz_id;
                    $this->db->insert('tbl_video_course_quiz_permission', $g_data);
                }
            }
        }

        $data['points_per_answer'] = $this->input->post('points_per_answer');
        $data['time_limit'] = $this->input->post('time_limit', true);

        //UPDATE POINTS PER ANSWER 
        if ($data['points_per_answer'] != $first_question->points_per_answer) {
            $all_question = $this->select_all_question_by_quiz_id($quiz_id);
            foreach ($all_question as $v_question) {
                $this->db->set('points_per_answer', $data['points_per_answer']);
                $this->db->set('time_limit', $data['time_limit']);
                $this->db->where('question_id', $v_question->question_id);
                $this->db->update('tbl_question');
            }
        }
    }

    function get_quiz_description_by_quiz_id($quiz_id) {
        $sql = "SELECT quiz_description FROM tbl_quiz WHERE quiz_id= '$quiz_id'";
        return $result = $this->db->query($sql)->row();
    }

    function save_quiz_tinymce_information_edit($person_id, $topic_id, $topic_url_id, $topic_detail) {
        $person_url = $this->person_model->get_profile_url($person_id);
        $destination_path = 'content-library/' . $person_url . '/my-work-file';
        $topic_url_info = $this->url_model->get_url_by_url_id($topic_url_id, 13); //0=invalid_url_no_url;1=menu;2=group;3=course_category;4=quiz;5=course;8=video_course;10=Person_Public_Profile;11=classroom; 13=quiz_topic
        $new_directory = $destination_path . '/' . $topic_url_info->url;
        return $this->utility_model->get_tinymce_description($topic_id, $new_directory, $topic_detail, 13);
    }

    /* -------------------------------------- end edit tinymec------------------------------------- */

    public function select_quiz_group_permission($quiz_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_group_quiz_permission as gqp "
                . " WHERE "
                . "         q.quiz_public_id = '$quiz_public_id' "
                . "     AND q.quiz_id = gqp.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_course_permission_by_course_id($course_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_quiz_permission as cqp "
                . " WHERE "
                . "         cqp.course_id = '$course_id' ";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_video_course_permission_by_course_id($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_quiz_permission as vcqp "
                . " WHERE "
                . "         vcqp.video_management_id = '$video_management_id' ";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_course_permission($quiz_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_course_quiz_permission as cqp "
                . " WHERE "
                . "         q.quiz_public_id = '$quiz_public_id' "
                . "     AND q.quiz_id = cqp.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_video_course_permission($quiz_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_video_course_quiz_permission as vcqp "
                . " WHERE "
                . "         q.quiz_public_id = '$quiz_public_id' "
                . "     AND q.quiz_id = vcqp.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_course_quiz_permission($course_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c, "
                . "     tbl_course_quiz_permission as cqp "
                . " WHERE "
                . "         c.course_id = '$course_id' "
                . "     AND c.course_id = cqp.course_id ";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_video_course_quiz_permission($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm, "
                . "     tbl_video_course_quiz_permission as vcqp "
                . " WHERE "
                . "         vm.video_management_id = '$video_management_id' "
                . "     AND vm.video_management_id = vcqp.video_management_id ";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_attendees($quiz_id) {
        $sql = "SELECT DISTINCT qr.person_id  "
                . " FROM "
                . "     tbl_quiz_result as qr "
                . " WHERE "
                . "         qr.quiz_id = '$quiz_id' "
                . " ORDER BY qr.quiz_receive_marks DESC "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_group_quiz_attendees_by_group_id($group_id, $quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_quiz as q, "
                . "     tbl_group_quiz_permission as gqp, "
                . "     tbl_group_member as gm "
                . " WHERE  "
                . "         qr.quiz_id = '$quiz_id' "
                . "     AND gqp.quiz_id = q.quiz_id "
                . "     AND qr.person_id = gm.person_id "
                . "     AND gm.group_id = '$group_id' "
                . " GROUP BY qr.quiz_result_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_course_quiz_attendees_by_course_id($course_id, $quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_quiz_permission as cqp, "
                . "     tbl_quiz_result as qr "
                . " WHERE "
                . "         cqp.course_id = '$course_id' "
                . "     AND cqp.quiz_id = '$quiz_id' ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_video_course_quiz_attendees_by_course_id($video_management_id, $quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_quiz_permission as vcqp, "
                . "     tbl_quiz_result as qr "
                . " WHERE "
                . "         vcqp.video_management_id = '$video_management_id' "
                . "     AND vcqp.quiz_id = '$quiz_id' ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function check_group_assigned_in_quiz($group_id, $quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group_quiz_permission as gqp "
                . " WHERE "
                . "         gqp.quiz_id = '$quiz_id' "
                . "     AND gqp.group_id = '$group_id' "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_course_assigned_in_quiz($course_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_quiz_permission as cqp "
                . " WHERE "
                . "         cqp.course_id = '$course_id' "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_video_course_assigned_in_quiz($video_course_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_quiz_permission as vcqp "
                . " WHERE "
                . "         vcqp.video_management_id = '$video_course_id' "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function save_question_info() {
        $person_id = $this->session->userdata('person_id');
        $data = array();
        $quiz_id = $this->input->post('quiz_id', true);
        $quiz_info = $this->select_quiz_by_url($quiz_id);
        $quiz_creator_url = $this->person_model->get_profile_url($quiz_info->quiz_created_by);

        $data['quiz_id'] = $quiz_id = $quiz_info->quiz_id;
        $data['points_per_answer'] = $this->input->post('points_per_answer');
        $data['time_limit'] = $this->input->post('time_limit', true);
        $data['question_type'] = $question_type = $this->input->post('question_type', true);
        $data['question_status'] = 1;
        $data['question_created_by'] = $this->session->userdata('person_id');
        $this->db->insert('tbl_question', $data);
        $question_id = $this->db->insert_id();

        $upload_dir = 'content-library/' . $quiz_creator_url . '/my-work-file/' . $quiz_info->url;
        if (is_dir($upload_dir)) {

            $question_details = $this->input->post('question_details', FALSE);

            if ($question_details) {
                $find_path = 'content-library';
                $question_details_update = $this->utility_model->update_all_tinymce_information($quiz_id, $upload_dir, $question_details, 4, $find_path);
                $data['question_details'] = $this->utility_model->changed_special_character_to_text($question_details_update);
            } else {
                $data['question_details'] = '';
            }
            $this->utility_model->update_information_in_database('tbl_question', 'question_id', $question_id, $data);
            $this->question_option_for_tinymce($question_id, $upload_dir, $quiz_id, $person_id, $quiz_info, 1);
        } else {
            $this->save_quiz_all_tinymce_information_add_question($person_id, $quiz_id, $quiz_info->url_id, $question_id);
            $this->question_option_for_tinymce($question_id, $upload_dir, $quiz_id, $person_id, $quiz_info, 2);
        }
    }

//tania 26-08-2016     
    function question_option_for_tinymce($question_id, $upload_dir, $quiz_id, $person_id, $quiz_info, $found) {
        $question_option = $this->input->post('option', FALSE);
        $question_status = $this->input->post('status', TRUE);
        for ($i = 0; $i < count($question_option); $i++) {
            $mcqdata['question_id'] = $question_id;
            if ($i == $question_status) {
                $mcqdata['question_option_status'] = 1;
            } else {
                $mcqdata['question_option_status'] = 0;
            }
            $this->db->insert('tbl_question_option', $mcqdata);
            $question_option_id = $this->db->insert_id();
            if ($found == 1) {
                if ($question_option[$i]) {
                    $find_path = 'content-library';
                    $question_details_update = $this->utility_model->update_all_tinymce_information($quiz_id, $upload_dir, $question_option[$i], 4, $find_path);
                    $qdata['question_option'] = $this->utility_model->changed_special_character_to_text($question_details_update);
                } else {
                    $qdata['question_option'] = '';
                }
                $this->utility_model->update_information_in_database('tbl_question_option', 'question_option_id', $question_option_id, $qdata);
            } else if ($found == 2) {
                $this->save_quiz_all_tinymce_information_question_option($person_id, $quiz_info->url_id, $question_option_id, $question_option[$i]);
            }
        }
    }

    /* ------------------------------start  add tinymec question --------------------------------------- */

//tania 23-07-2016
    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */
    function save_quiz_all_tinymce_information_add_question($person_id, $quiz_id, $quiz_url_id, $question_id) {
        $question_details = $this->input->post('question_details', FALSE);
        if ($question_details) {
            $question_details_update = $this->save_quiz_tinymce_information_add_question($person_id, $quiz_id, $quiz_url_id, $question_details);
            $data['question_details'] = $this->utility_model->changed_special_character_to_text($question_details_update);
        } else {
            $data['question_details'] = '';
        }
        $this->utility_model->update_information_in_database('tbl_question', 'question_id', $question_id, $data);
    }

    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function save_quiz_tinymce_information_add_question($person_id, $quiz_id, $quiz_url_id, $question_details) {
        $person_url = $this->person_model->get_profile_url($person_id);

        $destination_path = 'content-library/' . $person_url . '/my-work-file';
        $quiz_url_info = $this->url_model->get_url_by_url_id($quiz_url_id, 4); //0=invalid_url_no_url;1=menu;2=group;3=course_category;4=quiz;5=course;8=video_course;10=Person_Public_Profile;11=classroom; 13=quiz_topic
        $new_directory = $destination_path . '/' . $quiz_url_info->url;
        return $this->utility_model->get_tinymce_description($quiz_id, $new_directory, $question_details, 4);
    }

    /* ----------------------------- end   add tinymec question --------------------------------------- */

    /* ------------------------ start question option tinymec ------------------------------------------ */
    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function save_quiz_all_tinymce_information_question_option($person_id, $quiz_url_id, $question_option_id, $question_option) {
        if ($question_option) {
            $question_option_update = $this->save_quiz_tinymce_information_question_option($person_id, $quiz_url_id, $question_option);
            $data['question_option'] = $this->utility_model->changed_special_character_to_text($question_option_update);
        } else {
            $data['question_option'] = '';
        }
        $this->utility_model->update_information_in_database('tbl_question_option', 'question_option_id', $question_option_id, $data);
    }

    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function remove_tinymec_directory($person_id) {
        $person_url = $this->person_model->get_profile_url($person_id);
        $directory = 'source/' . $person_url . '/';
        $this->utility_model->remove_directory_without_root($directory);
    }

    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function save_quiz_tinymce_information_question_option($person_id, $quiz_url_id, $question_option) {
        $person_url = $this->person_model->get_profile_url($person_id);
        $destination_path = 'content-library/' . $person_url . '/my-work-file';
        $quiz_url_info = $this->url_model->get_url_by_url_id($quiz_url_id, 4); //0=invalid_url_no_url;1=menu;2=group;3=course_category;4=quiz;5=course;8=video_course;10=Person_Public_Profile;11=classroom; 13=quiz_topic
        $new_directory = $destination_path . '/' . $quiz_url_info->url;
        return $this->utility_model->get_tinymce_description_question_option($person_id, $new_directory, $question_option, 4);
    }

    /* ----------------------------------- end  question option tinymec ------------------------------------------------------ */


    /* ------------------------ start question option fill in the blanks tinymec ------------------------------------------ */
    /*
     * Function         : 
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */

    function save_quiz_all_tinymce_information_question_option_fill_in_blanks($person_id, $quiz_url_id, $question_option_id) {
        $question_option = $this->input->post('option', FALSE);
        if ($question_option) {
            $question_option_update = $this->save_quiz_tinymce_information_question_option($person_id, $quiz_url_id, $question_option);
            $data['question_option'] = $this->utility_model->changed_special_character_to_text($question_option_update);
        } else {
            $data['question_option'] = '';
        }
        /*
         * Function         : 
         * Used IN          : 
         * Description      : 
         * Parameter        : 
         * return           : 
         * redirect         : 
         * Developed By     : Tania Akter
         * Date             : 
         */
        $this->utility_model->update_information_in_database('tbl_question_option', 'question_option_id', $question_option_id, $data);
        $person_url = $this->person_model->get_profile_url($person_id);
        $directory = 'source/' . $person_url . '/';
        $this->utility_model->remove_directory_without_root($directory);
    }

    /* ----------------------------- end  question option fill in the blanks tinymec ------------------------------------- */

    function select_question_options_by_question_id($question_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_question_option as qo"
                . " WHERE "
                . "         qo.question_id = '$question_id' "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function save_grade_info($quiz_id) {
        $data = array();
        $data['grade_total_number'] = $this->input->post('grade_total_number');
        $data['grade_name'] = $this->input->post('grade_name');
        $data['grade_number'] = $this->input->post('grade_number');

        for ($i = 0; $i < count($data['grade_name']); $i++) {
            $gdata['quiz_id'] = $quiz_id;
            $gdata['grade_total_number'] = $data['grade_total_number'];
            $gdata['grade_name'] = $data['grade_name'][$i];
            $gdata['grade_number'] = $data['grade_number'][$i];
            $gdata['grade_status'] = 1;
            $this->db->insert('tbl_grade', $gdata);
        }
    }

    public function select_quiz_grade($quiz_id) {
        $sql = "SELECT * FROM tbl_grade  WHERE quiz_id= '$quiz_id'  ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_grade_by_id($grade_id) {
        $sql = "SELECT * FROM tbl_grade  WHERE grade_id= '$grade_id'  ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function update_grade_info($quiz_id) {
        $data = array();
        $grade_id = $this->input->post('grade_id');
        $data['grade_total_number'] = $this->input->post('grade_total_number');
        $data['grade_name'] = $this->input->post('grade_name');
        $data['grade_number'] = $this->input->post('grade_number');

        for ($i = 0; $i < count($data['grade_name']); $i++) {
            $gdata = array();
            $gdata['quiz_id'] = $quiz_id;
            $gdata['grade_total_number'] = $data['grade_total_number'];
            $gdata['grade_name'] = $data['grade_name'][$i];
            $gdata['grade_number'] = $data['grade_number'][$i];
            $gdata['grade_status'] = 1;

            if ($grade_id[$i]) {
                $this->db->where('grade_id', $grade_id[$i]);
                $this->db->update('tbl_grade', $gdata);
            } else {
                $this->db->insert('tbl_grade', $gdata);
            }
        }
    }

    public function select_quiz_all_grade($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_grade as g"
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.quiz_id = g.quiz_id "
                . " ORDER BY g.grade_number DESC"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_active_grade($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_grade as g"
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.quiz_id = g.quiz_id "
                . "     AND g.grade_status = 1";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_inactive_grade($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_grade as g"
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.quiz_id = g.quiz_id "
                . "     AND g.grade_status = 0"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_archive_grade($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_grade as g"
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.quiz_id = g.quiz_id "
                . "     AND g.grade_status = 2"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function active_selected_grade($grade_id) {
        $this->db->set('grade_status', 1);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function inactive_selected_grade($grade_id) {
        $this->db->set('grade_status', 0);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function archive_selected_grade($grade_id) {
        $this->db->set('grade_status', 2);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function save_certificate_information() {
        $cdata = array();
        $cdata['certificate_created_by'] = $this->session->userdata('person_id');
        $cdata['certificate_name'] = $this->input->post('certificate_name', TRUE);
        $cdata['certificate_public_id'] = str_replace(' ', '-', $cdata['certificate_name']);
        $cdata['certificate_share_status'] = $this->input->post('certificate_share_status', TRUE);
        $cdata['certificate_status'] = $this->input->post('certificate_status', TRUE);
        $cdata['certificate_public_id'] .= rand(111, 999);

        $certificate_description = $this->input->post('certificate_description');

        for ($i = 0; $i < 4; $i++) {
            if ($certificate_description[$i]) {
                $cdata['certificate_description'] = $certificate_description[$i];
            }
        }
        /*
         * Start Image Upload
         */
        if ($_FILES['company_image']['name']) {
            $config['upload_path'] = 'site/images/quiz/certificate/original/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '300';
            $config['max_width'] = '2000';
            $config['max_height'] = '2000';
            $error = '';
            $fdata = array();
            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('company_image')) {
                $error = $this->upload->display_errors();
                echo $error;
                exit();
            } else {
                $fdata = $this->upload->data();
                $cdata['certificate_image'] = $config['upload_path'] . $fdata['file_name'];
            }
        }
        // END Create Thumbnail
        /*
         * End Image Ipload
         */
        $this->db->insert('tbl_certificate', $cdata);
        $certicate_id = $this->db->insert_id();

        return $certicate_id;
    }

    public function update_quiz_certificate($certificate_id) {
        $previous_quizes = $this->input->post('previous_quizes', TRUE);
        $previous_quizes = explode(',', $previous_quizes);

        $quiz_id = $this->input->post('to_address', TRUE);
        $quiz_id = explode(',', $quiz_id);

        for ($i = 0; $i < count($quiz_id); $i++) {
            if (!in_array($quiz_id[$i], $previous_quizes)) {

                $this->db->set('certificate_id', $certificate_id);
                $this->db->where('quiz_id', $quiz_id[$i]);
                $this->db->update('tbl_quiz');
            }
        }
        for ($i = 0; $i < count($previous_quizes); $i++) {
            if (!in_array($previous_quizes[$i], $quiz_id)) {
                $this->db->set('certificate_id', NULL);
                $this->db->where('quiz_id', $previous_quizes[$i]);
                $this->db->update('tbl_quiz');
                echo 'remove certificate';
            }
        }
        redirect('quizes/certificate');
    }

    public function update_certificate_information($certificate_id) {
        $cdata = array();
        $cdata['certificate_name'] = $this->input->post('certificate_name', TRUE);

        $certificate_description = $this->input->post('certificate_description');
        for ($i = 0; $i < 4; $i++) {
            if ($certificate_description[$i]) {
                $cdata['certificate_description'] = $certificate_description[$i];
            }
        }

        $cdata['certificate_share_status'] = $this->input->post('certificate_share_status', TRUE);
        $cdata['certificate_status'] = $this->input->post('certificate_status', TRUE);

        /*
         * Start Image Upload
         */
        if ($_FILES['company_new_image']['name']) {
            $config['upload_path'] = 'site/images/quiz/certificate/original/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '300';
            $config['max_width'] = '2000';
            $config['max_height'] = '2000';
            $error = '';
            $fdata = array();
            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('company_new_image')) {
                $error = $this->upload->display_errors();
                echo $error;
                exit();
            } else {
                $fdata = $this->upload->data();
                $cdata['certificate_image'] = $config['upload_path'] . $fdata['file_name'];
            }
        }
        // END Image Upload

        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate', $cdata);
        $certicate_id = $this->db->insert_id();

        return $certicate_id;
    }

    public function select_quiz_certificate($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_certificate as c"
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND c.quiz_id = q.quiz_id ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_all_certificate() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_certificate";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_quiz_by_certificate($certificate_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_certificate as c, "
                . "     tbl_quiz q "
                . " WHERE "
                . "         c.certificate_id = '$certificate_id' "
                . "     AND c.certificate_id = q.certificate_id ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_certificate_by_id($certificate_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_certificate"
                . " WHERE "
                . "         certificate_id = '$certificate_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_certificate_by_public_id($certicate_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_certificate"
                . " WHERE "
                . "         certificate_public_id = '$certicate_public_id'"
                . "     AND certificate_status = 1";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_certificate_by_public_id($certicate_public_id) {
        $person_id = $this->session->userdata('person_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_certificate"
                . " WHERE "
                . "             certificate_created_by = '$person_id' "
                . "         AND certificate_public_id = '$certicate_public_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function active_selected_certificate($certificate_id) {
        $this->db->set('certificate_status', 1);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function inactive_selected_certificate($certificate_id) {
        $this->db->set('certificate_status', 0);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function archive_selected_certificate($certificate_id) {
        $this->db->set('certificate_status', 2);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function update_question_info($question_id, $question_details) {
        $data = array();
        $quiz_url = $this->input->post('quiz_id', true);
        $quiz_info = $this->select_quiz_by_url($quiz_url);
        $first_question = $this->select_quiz_first_question($quiz_info->quiz_id);

        $data['quiz_id'] = $quiz_id = $quiz_info->quiz_id;
        $quiz_creator_info = $this->super_admin_quiz_model->get_quiz_creator_info_by_quiz_id($quiz_id);

        if ($this->input->post('question_details', FALSE)) {  //added by tania            
            $question_details_update = $this->utility_model->update_tinymce_information($quiz_id, $quiz_creator_info->url, $quiz_url, $this->input->post('question_details', FALSE), $question_details);
            $data['question_details'] = $this->utility_model->changed_special_character_to_text($question_details_update);
            $this->remove_tinymec_directory($quiz_creator_info->person_id);
        }

        $data['question_type'] = $question_type = $this->input->post('question_type', true);
        $data['question_status'] = 1;
        $data['question_created_by'] = $this->session->userdata('person_id');
        $data['points_per_answer'] = $this->input->post('points_per_answer', TRUE);
        $data['time_limit'] = $this->input->post('time_limit', TRUE);
        $this->db->where('question_id', $question_id);
        $this->db->update('tbl_question', $data);

        if ($question_type == 3) {
            if ($this->input->post('question_details', TRUE)) {
                $data['question_details'] = $this->get_tinymce_description_value($this->input->post('question_details', FALSE));
            }

            $desc_answer = $this->input->post('desc_answer', true);
            $desc_answer = (explode(" ", $desc_answer));
            $words = array(".", "?", ":", ",", ";", "(", ")", "=", "+", "!");
            $desc_answer = str_replace($words, "", $desc_answer);
            $words = array("am", "is", "are", "was", "were", "has", "have", "had", "can", "could", "can", "may", "might", "shall", "will", "should", "would", "a", "an", "the", "of", "in", "to", "with", "as", "at", "for", "on", "by", "from", "not", "no");
            foreach ($desc_answer as $v_answer) {
                if (!in_array($v_answer, $words)) {
                    $desc_answer_keys[] = $v_answer;
                }
            }
            if ($desc_answer_keys) {
                $unique_ans_keys = array_unique($desc_answer_keys);
            } else {
                $unique_ans_keys = '';
            }
            $descript_ans_keys = (implode(", ", $unique_ans_keys));

            $odata = array();
            $odata['question_option'] = $this->input->post('desc_answer', true);
            $odata['descriptive_ans_keyword'] = $descript_ans_keys;
            $odata['question_option_status'] = 1;

            $this->db->where('question_id', $question_id);
            $this->db->update('tbl_question_option', $odata);
        } else if ($question_type == 1) {           //tania
            $question_option = $this->input->post('option', FALSE);
            $question_status = $this->input->post('status', TRUE);
            $question_options_old = $this->select_question_options_by_question_id($question_id);
            for ($i = 0; $i < count($question_option); $i++) {
                if ($i == $question_status) {
                    $mcqdata['question_option_status'] = 1;
                } else {
                    $mcqdata['question_option_status'] = 0;
                }
                $question_option_update = $this->utility_model->update_tinymce_information($quiz_id, $quiz_creator_info->url, $quiz_url, $question_option[$i], $question_options_old[$i]->question_option);
                $mcqdata['question_option'] = $this->utility_model->changed_special_character_to_text($question_option_update);
                $this->db->where('question_option_id', $question_options_old[$i]->question_option_id);
                $this->db->update('tbl_question_option', $mcqdata);
            }
        } else if ($question_type == 2) {
            $true_false_option_info = $this->select_question_options_by_question_id($question_id);
            $question_status = $this->input->post('status', TRUE);
            foreach ($true_false_option_info as $value) {
                if ($value->question_option_id == $question_status) {
                    $truedata['question_option_status'] = 1;
                } else {
                    $truedata['question_option_status'] = 0;
                }
                $this->db->where('question_option_id', $value->question_option_id);
                $this->db->update('tbl_question_option', $truedata);
            }
        } else if ($question_type == 4) {
            $question_options_id = $this->select_fill_in_the_blanks_options_by_question_id($question_id);
            $filldata['question_option'] = $this->input->post('option', FALSE);
            $this->db->where('question_option_id', $question_options_id->question_option_id);
            $this->db->update('tbl_question_option', $filldata);
        }
    }

    public function update_question_info_my() {
        $data = array();
        $quiz_url = $this->input->post('quiz_id', true);
        $quiz_info = $this->select_quiz_by_url($quiz_url);
        $first_question = $this->select_quiz_first_question($quiz_info->quiz_id);

        $data['quiz_id'] = $quiz_info->quiz_id;
        $data['question_details'] = $this->input->post('question_details', true);
        $data['points_per_answer'] = $this->input->post('points_per_answer', true);
        $data['time_limit'] = $this->input->post('time_limit', true);

        $data['question_type'] = $question_type = $this->input->post('question_type', true);
        $data['question_status'] = 1;
        $data['question_created_by'] = $this->session->userdata('person_id');
        $this->db->insert('tbl_question', $data);

        $insert_id = $this->db->insert_id();

        if ($question_type == 3) {
            $question = $this->input->post('question_details', true);

            $desc_answer = $this->input->post('desc_answer', true);
            $desc_answer = (explode(" ", $desc_answer));
            $words = array(".", "?", ":", ",", ";", "(", ")", "=", "+", "!");
            $desc_answer = str_replace($words, "", $desc_answer);
            $words = array("am", "is", "are", "was", "were", "has", "have", "had", "can", "could", "can", "may", "might", "shall", "will", "should", "would", "a", "an", "the", "of", "in", "to", "with", "as", "at", "for", "on", "by", "from", "not", "no");
            foreach ($desc_answer as $v_answer) {
                if (!in_array($v_answer, $words)) {
                    $desc_answer_keys[] = $v_answer;
                }
            }
            if ($desc_answer_keys) {
                $unique_ans_keys = array_unique($desc_answer_keys);
            } else {
                $unique_ans_keys = '';
            }
            $descript_ans_keys = (implode(", ", $unique_ans_keys));

            $odata = array();
            $odata['question_id'] = $insert_id;
            $odata['descriptive_ans_keyword'] = $descript_ans_keys;
            $odata['question_option_status'] = 1;
            $this->db->insert('tbl_question_option', $odata);
        } else {
            $odata = array();
            foreach ($_POST['option'] as $key => $v_contents) {
                $odata[$key]['question_id'] = $insert_id;
                $odata[$key]['question_option'] = $v_contents;
                if ($key == $_POST['status'][0]) {
                    $odata[$key]['question_option_status'] = 1;
                } else {
                    $odata[$key]['question_option_status'] = 0;
                }
                $this->db->insert('tbl_question_option', $odata[$key]);
            }
        }

        //UPDATE POINTS PER ANSWER 
        if ($data['points_per_answer'] != $first_question->points_per_answer) {
            $all_question = $this->select_all_question_by_quiz_id($quiz_info->quiz_id);
            foreach ($all_question as $v_question) {
                $this->db->set('points_per_answer', $data['points_per_answer']);
                $this->db->set('time_limit', $data['time_limit']);
                $this->db->where('question_id', $v_question->question_id);
                $this->db->update('tbl_question');
            }
        }
    }

    public function select_quiz($config) {
        $per_page_view = $config['per_page_view'];
        $start_limit_value = $config['start_limit_value'];

        $sql = "SELECT "
                . "     q.*, t.topic_name, p.person_first_name, u.url "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_topic as t, "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         q.quiz_topics_specification = t.topic_id "
                . "     AND q.quiz_created_by = p.person_id "
                . "     AND u.url_id = q.url_id ";
        if ($config['quiz_editor_id'] != '') {
            $sql .= " AND q.quiz_created_by = '$config[quiz_editor_id]'";
        }
        if ($config['search_value']) {
            $sql .= " AND q.quiz_name LIKE '%" . $config['search_value'] . "%'";
        }

        $sql .= " ORDER BY q.quiz_id DESC ";

        if ($per_page_view) {
            $sql .= " LIMIT $start_limit_value,$per_page_view";
        }

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_topic_specific_latest_quiz($topic_url, $start = NULL, $limit = NULL, $status = NULL, $short = NULL) {
        $sql = "SELECT "
                . "     q.*, t.topic_name, p.person_first_name, u.url "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_topic as t, "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         u.url = '$topic_url'"
                . "     AND t.url_id = u.url_id "
                . "     AND q.quiz_topics_specification = t.topic_id "
                . "     AND q.quiz_created_by = p.person_id ";

        $sql .= " AND ( q.quiz_pulication_status = 1 OR q.quiz_pulication_status = 2 OR q.quiz_pulication_status = 5 OR q.quiz_pulication_status = 6 )"
                . " ORDER BY q.quiz_id DESC";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_topic_specific_popular_quiz($topic_url, $start = NULL, $limit = NULL, $status = NULL, $short = NULL) {
        $sql = "SELECT "
                . "     q.*, t.topic_name, p.person_first_name, u.url "
                . " FROM "
                . "     tbl_quiz as q, "
                . "     tbl_topic as t, "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         u.url = '$topic_url'"
                . "     AND t.url_id = u.url_id "
                . "     AND q.quiz_topics_specification = t.topic_id "
                . "     AND q.quiz_created_by = p.person_id ";

        $sql .= " AND ( q.quiz_pulication_status = 1 OR q.quiz_pulication_status = 2 OR q.quiz_pulication_status = 5 OR q.quiz_pulication_status = 6 )"
                . " ORDER BY q.quiz_taken_number DESC";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_quiz() {
        $this->db->select('*');
        $this->db->from('tbl_quiz');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_quiz_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         q.quiz_created_by = '$person_id' "
                . "     AND (q.quiz_status = 0 OR q.quiz_status = 1)"
                . "     AND q.url_id = u.url_id "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_learner_all_quiz_by_person_id($person_id) {
        $sql = "SELECT DISTINCT q.*, u.url, t.* "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_topic as t,"
                . "     tbl_quiz as q, "
                . "     tbl_url as u "
                . " WHERE "
                . "         qr.person_id = '$person_id' "
                . "     AND qr.quiz_id = q.quiz_id "
                . "     AND q.url_id = u.url_id "
                . "     AND q.quiz_topics_specification = t.topic_id"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_active_quiz_by_person_id($person_id) {
        $sql = "SELECT *  FROM  
            tbl_quiz as q, 
            tbl_url as u                
            WHERE 
            q.quiz_created_by = '$person_id'
            AND q.quiz_status = 1 
            AND q.url_id = u.url_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//tania 14-08-2016   
    function select_all_active_quiz_by_super_admin() {
        $sql = "SELECT * FROM tbl_quiz as q,
                tbl_url as u
                WHERE q.quiz_status ='1'
                AND q.url_id = u.url_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_inactive_quiz_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         q.quiz_created_by = '$person_id' "
                . "     AND q.quiz_status = 0 "
                . "     AND q.url_id = u.url_id "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_archived_quiz_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         q.quiz_created_by = '$person_id' "
                . "     AND q.quiz_status = 2 "
                . "     AND q.url_id = u.url_id "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_quiz_by_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND u.url_id = q.url_id "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_quiz_by_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND u.url_id = q.url_id "
                . "     AND q.quiz_status = 1 "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_all_status_by_url($quiz_url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u, tbl_topic as t "
                . " WHERE "
                . "         u.url = '$quiz_url' "
                . "     AND u.url_id = q.url_id "
                . "     AND t.topic_id = q.quiz_topics_specification "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_all_status_by_public_id($quiz_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u, tbl_topic as t "
                . " WHERE "
                . "         q.quiz_public_id = '$quiz_public_id' "
                . "     AND u.url_id = q.url_id "
                . "     AND t.topic_id = q.quiz_topics_specification "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_by_public_id($quiz_public_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u, tbl_topic as t "
                . " WHERE "
                . "         q.quiz_public_id = '$quiz_public_id' "
                . "     AND u.url_id = q.url_id "
                . "     AND q.quiz_status = 1 "
                . "     AND t.topic_id = q.quiz_topics_specification "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_by_url($url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         u.url = '$url' "
                . "     AND u.url_id = q.url_id"
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_quiz_by_url($url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         u.url = '$url' "
                . "     AND u.url_id = q.url_id "
                . "     AND q.quiz_status = 1 "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_inactive_quiz_by_url($url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         u.url = '$url' "
                . "     AND u.url_id = q.url_id "
                . "     AND q.quiz_status = 0 "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_archived_quiz_by_url($url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u "
                . " WHERE "
                . "         u.url = '$url' "
                . "     AND u.url_id = q.url_id "
                . "     AND q.quiz_status = 2 "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_question as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.question_status = 1 "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_person_rank($quiz_id) {
        $sql = "SELECT DISTINCT qr.person_id  "
                . " FROM "
                . "     tbl_quiz_result as qr "
                . " WHERE "
                . "         qr.quiz_id = '$quiz_id' "
                . "     AND qr.quiz_result_status = 1 "
                . " ORDER BY qr.quiz_receive_marks DESC"
        ;

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_inactive_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_question as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.question_status = 0 "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_archived_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_question as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.question_status = 2 "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_sugested_quiz() {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         (q.quiz_pulication_status = 1 OR q.quiz_pulication_status = 2)"
                . "     AND q.quiz_status = 1 "
                . " ORDER BY q.quiz_taken_number DESC"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_popular_quiz($start, $limit, $status, $short = NULL) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         (q.quiz_pulication_status = 1 OR q.quiz_pulication_status = 2)"
                . "     AND q.quiz_status = 1 "
                . " ORDER BY q.quiz_taken_number DESC"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_active_popular_quiz($start, $limit, $status, $short = NULL) {

        $sql = "SELECT q.*, u.url "
                . " FROM "
                . "     tbl_quiz as q, tbl_url as u  "
                . " WHERE "
                . "         q.quiz_status = 1 "
                . "     AND u.url_id = q.url_id "
                . " ORDER BY q.quiz_taken_number DESC "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_latest_quiz_topic() {

        $sql = "SELECT DISTINCT t.*, u.url "
                . " FROM "
                . "     tbl_topic as t, tbl_url as u "
                . " WHERE "
                . "         (t.topic_status = 1 OR t.topic_status = 4)"
                . "     AND u.url_id = t.url_id "
                . " ORDER BY t.topic_id DESC "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_popular_quiz_topic() {

        $sql = "SELECT DISTINCT q.quiz_topics_specification, t.*, u.url "
                . " FROM "
                . "     tbl_quiz as q, tbl_topic as t, tbl_url as u  "
                . " WHERE "
                . "         t.topic_id = q.quiz_topics_specification "
                . "     AND (t.topic_status = 1 OR t.topic_status = 4)"
                . "     AND q.quiz_status = 1 "
                . "     AND u.url_id = t.url_id "
                . " ORDER BY q.quiz_taken_number DESC "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function change_quiz_status($quiz_id, $status) {
        $this->db->set('quiz_status', $status);
        $this->db->where('quiz_id', $quiz_id);
        $this->db->update('tbl_quiz');
    }

    public function delete_selected_quiz($data) {
        $quiz_id = $data['quiz_info']->quiz_id;
        $url_id = $data['quiz_info']->url_id;
        $data['quiz_all_question'] = $this->select_active_question_by_quiz_id($data['quiz_info']->quiz_id);

        //delete quiz and quiz url
        $sql = " DELETE FROM tbl_quiz WHERE quiz_id = '$quiz_id' ";
        $this->db->query($sql);
        $sql = " DELETE FROM tbl_url WHERE url_id = '$url_id' ";
        $this->db->query($sql);

        // delete quiz all attendees result
        $sql = " DELETE FROM tbl_quiz_result WHERE quiz_id = '$quiz_id' ";
        $this->db->query($sql);

        // delete quiz question option
        foreach ($data['quiz_all_question'] as $value) {
            $sql = " DELETE FROM tbl_question_option WHERE question_id = '$value->question_id' ";
            $this->db->query($sql);
        }
        // delete quiz all question
        $sql = " DELETE FROM tbl_question WHERE quiz_id = '$quiz_id' ";
        $this->db->query($sql);
    }

    public function select_question($start, $limit, $status, $short = NULL) {
        $sql = "SELECT * "
                . "FROM tbl_question";

        if ($status != '') {
            $sql .= "WHERE question_status = '$status' ";
        }
        if ($short) {
            $sql .= " ORDER BY created_date_time '$short' ";
        } else {
            $sql .= " ORDER BY created_date_time DESC ";
        }
        if ($limit != '' && $start >= 0) {
            $sql .= " LIMIT $start, $limit ";
        }
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_active_question($quiz_id) {
        $sql = "SELECT * "
                . " FROM tbl_question as q, tbl_quiz as qz "
                . " WHERE "
                . "         q.question_status = 1 "
                . "     AND q.quiz_id = qz.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM tbl_question as q, tbl_quiz as qz "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND q.quiz_id = qz.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_active_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM tbl_question as q, tbl_quiz as qz "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id'"
                . "     AND q.question_status = 1 "
                . "     AND q.quiz_id = qz.quiz_id ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function active_selected_question($question_id) {
        $this->db->set('question_status', 1);
        $this->db->where('question_id', $question_id);
        $this->db->update('tbl_question');
    }

    public function inactive_selected_question($question_id) {
        $this->db->set('question_status', 0);
        $this->db->where('question_id', $question_id);
        $this->db->update('tbl_question');
    }

    public function archive_selected_question($question_id) {
        $this->db->set('question_status', 2);
        $this->db->where('question_id', $question_id);
        $this->db->update('tbl_question');
    }

// update by tania 27-08-2016
    function select_multiple_choice_question($quiz_id) {
        $sql = "SELECT * FROM 
        tbl_question as q, tbl_quiz as qz
        WHERE qz.quiz_id = '$quiz_id' 
        AND qz.quiz_id = q.quiz_id 
        AND q.question_type = '1' 
        AND q.question_status = '1'";
        return $this->db->query($sql)->result();
    }

    public function select_currect_ans($question_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_question_option as qo"
                . " WHERE"
                . "         q.question_id = '$question_id' "
                . "     AND qo.question_id = q.question_id "
                . "     AND qo.question_option_status = 1";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_mcq_currect_ans($question_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_question_option as qo"
                . " WHERE"
                . "         q.question_id = '$question_id' "
                . "     AND qo.question_id = q.question_id "
                . "     AND qo.question_option_status = 1";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_true_false_currect_ans($question_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_question_option as qo"
                . " WHERE"
                . "         q.question_id = '$question_id' "
                . "     AND qo.question_id = q.question_id "
                . "     AND qo.question_option_status = 1";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_true_false_question($quiz_id) {
        $sql = "SELECT * FROM tbl_question as q,
                tbl_quiz as qz WHERE
                qz.quiz_id = '$quiz_id' 
                AND qz.quiz_id = q.quiz_id 
                AND q.question_type = '2'
                AND q.question_status = '1'";
        return $this->db->query($sql)->result();
    }

    public function select_descriptive_question_currect_ans($question_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_question_option as qo"
                . " WHERE"
                . "         q.question_id = '$question_id' "
                . "     AND qo.question_id = q.question_id "
                . "     AND qo.question_option_status = 1";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_fill_blank_question_currect_ans($question_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_question_option as qo"
                . " WHERE"
                . "         q.question_id = '$question_id' "
                . "     AND qo.question_id = q.question_id "
                . "     AND qo.question_option_status = 1";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_descriptive_question_question($quiz_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_quiz as qz"
                . " WHERE"
                . "         qz.quiz_id = '$quiz_id' "
                . "     AND qz.quiz_id = q.quiz_id "
                . "     AND q.question_type = 3 ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_fill_blank_question_question($quiz_id) {
        $sql = "SELECT * "
                . "FROM tbl_question as q, tbl_quiz as qz"
                . " WHERE"
                . "         qz.quiz_id = '$quiz_id' "
                . "     AND qz.quiz_id = q.quiz_id "
                . "     AND q.question_type = 4 ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_course() {
        $this->db->select('*');
        $this->db->from('tbl_course_category');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_topic() {
        $this->db->select('*');
        $this->db->from('tbl_topic');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_quiz_active_topic() {
        $this->db->select('*');
        $this->db->select('topic_status', 1);
        $this->db->from('tbl_topic');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_quiz_publish_and_approved_topic() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_topic as t, "
                . "     tbl_url as u "
                . " WHERE "
                . "         t.url_id = u.url_id "
                . "     AND (t.topic_status = 1 OR t.topic_status = 4)"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_all_active_group($person_id) {
        $this->db->select('*');
        $this->db->select('group_status', 1);
        $this->db->select('group_created_by', $person_id);
        $this->db->from('tbl_group');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_tt_group_by_id_list($id_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group as g, "
                . "     tbl_url as u, "
                . "     tbl_person as p "
                . " WHERE "
                . "         (p.person_role = 1 OR p.person_role = 6) "
                . "     AND p.person_id = g.group_created_by "
                . "     AND g.url_id = u.url_id "
                . "     AND g.group_status = 1 ";
        if ($id_list) {
            $sql.= " AND g.group_id IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_tt_group_by_search_text($search_text, $id_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group as g, "
                . "     tbl_url as u, "
                . "     tbl_person as p "
                . " WHERE "
                . "         (p.person_role = 1 OR p.person_role = 6) "
                . "     AND p.person_id = g.group_created_by "
                . "     AND g.url_id = u.url_id "
                . "     AND g.group_status = 1 ";
        if ($search_text) {
            $sql .= " AND g.group_name LIKE '%" . $search_text . "%'";
        }

        if ($id_list) {
            $sql.= " AND g.group_id NOT IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_course_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c "
                . " WHERE "
                . "         c.person_id = '$person_id' "
                . "     AND c.course_status = 4 "
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_tt_course_by_search_text($search_text, $id_list) {
        $sql = "SELECT *  FROM 
            tbl_course as c 
            WHERE (c.course_status = 1 OR c.course_status = 4)";
        if ($search_text) {
            $sql .= " AND c.course_name LIKE '%" . $search_text . "%'";
        }

        if ($id_list) {
            $sql.= " AND c.course_id NOT IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    //tania 03-
    public function select_course_by_search_text($id_list) {
        $sql = "SELECT * FROM tbl_course as c WHERE (c.course_status = 1 OR c.course_status = 4) AND c.course_id NOT IN ($id_list)";
        $sql.= " LIMIT 9";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_tt_course_by_id_list($id_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course as c "
                . " WHERE "
                . "         (c.course_status = 1 OR c.course_status = 4)  "
        ;

        if ($id_list) {
            $sql.= " AND c.course_id IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_tt_video_course_by_search_text($search_text, $id_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm "
                . " WHERE "
                . "         (vm.video_management_status = 1 OR vm.video_management_status = 4)  "
        ;

        if ($search_text) {
            $sql .= " AND vm.video_course_title LIKE '%" . $search_text . "%'";
        }

        if ($id_list) {
            $sql.= " AND vm.video_management_id NOT IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_tt_video_course_by_id_list($id_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm "
                . " WHERE "
                . "         (vm.video_management_status = 1 OR vm.video_management_status = 4)  "
        ;

        if ($id_list) {
            $sql.= " AND vm.video_management_id IN ($id_list)";
        }
        $sql.= " LIMIT 9";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function quiz_selected_id($data) {
        if ($data['quiz_info']->quiz_pulication_status == 4) {
            $data['quiz_group'] = $this->super_admin_quiz_model->select_quiz_group_permission($data['quiz_info']->quiz_public_id);
            foreach ($data['quiz_group'] as $value) {
                $id_list[] = $value->group_id;
            }
        } else if ($data['quiz_info']->quiz_pulication_status == 5) {
            $data['quiz_courses'] = $this->select_quiz_course_permission($data['quiz_info']->quiz_public_id);
            foreach ($data['quiz_courses'] as $value) {
                $id_list[] = $value->course_id;
            }
        } else if ($data['quiz_info']->quiz_pulication_status == 6) {
            $data['quiz_video_courses'] = $this->select_quiz_video_course_permission($data['quiz_info']->quiz_public_id);
            foreach ($data['quiz_video_courses'] as $value) {
                $id_list[] = $value->video_management_id;
            }
        }
        if ($id_list) {
            return implode(',', $id_list);
        } else {
            return '';
        }
    }

    public function select_question_by_id($question_id) {
        $this->db->select('*');
        $this->db->from('tbl_question_option');
        $this->db->where('question_id', $question_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_quiz_first_question($quiz_id) {

        $sql = "SELECT  * FROM tbl_question as q WHERE q.quiz_id = '$quiz_id' ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function select_question_info_by_id($question_id) {
        $this->db->select('*');
        $this->db->from('tbl_question');
        $this->db->where('question_id', $question_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_all_question_info() {
        $this->db->select('*');
        $this->db->from('tbl_question');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_active_question_info() {
        $this->db->select('*');
        $this->db->from('tbl_question');
        $this->db->where('question_status', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_marks_active_question_info() {
        $sql = "SELECT  SUM(points_per_answer) AS total FROM tbl_question  WHERE  question_status=1";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function select_option_info_by_id($question_id) {
        $this->db->select('*');
        $this->db->from('tbl_question_option');
        $this->db->where('question_id', $question_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    /*
     * calculate the answer right or wrong.
     */

    public function confirm_answer($value) {
        $this->db->select('*');
        $this->db->from('tbl_question_option');
        $this->db->where('question_option_id', $value);
        $this->db->where('status', 1);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    /*
     * end calculation.
     */

    public function select_quiz_result($person_id, $quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND qr.person_id = '$person_id' "
                . "     AND qr.quiz_result_permission = 1 "
                . "     AND qr.quiz_result_status = 1 "
                . " ORDER BY qr.quiz_result_id DESC";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_quiz_result_by_quiz_id($quiz_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND qr.quiz_result_permission = 1 "
                . "     AND qr.quiz_result_status = 1";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_Quiz_result_by_result_id($quiz_result_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         qr.quiz_result_id = '$quiz_result_id' "
                . "     AND qr.quiz_result_permission = 1 "
                . "     AND qr.quiz_result_status = 1"
                . "     AND q.quiz_id = qr.quiz_id ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

//tania 27-07-2016 
    /*
     * Function         : get_quiz_creator_info_by_question_id
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */
    function get_quiz_creator_info_by_question_id($question_id) {
        $sql = " SELECT * FROM 
 	tbl_quiz AS q,
 	tbl_question 	AS qu
 	WHERE 
 	qu.question_id ='$question_id'
 	AND qu.quiz_id = q.quiz_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    //tania 27-07-2016 
    /*
     * Function         : get_quiz_creator_info_by_question_id
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 
     */
    function get_quiz_creator_info_by_quiz_id($quiz_id) {
        $sql = " SELECT * FROM 
 	tbl_quiz AS q,
 	tbl_url AS u,
 	tbl_person AS p
 	WHERE 
 	q.quiz_id= '$quiz_id'
 	AND q.quiz_created_by = p.person_id
 	AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /*
     * Function         : select_fill_in_the_blanks_options_by_question_id
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 01-08-2016
     */

    function select_fill_in_the_blanks_options_by_question_id($question_id) {
        $sql = "SELECT * FROM tbl_question_option as qo
 	WHERE qo.question_id ='$question_id'";
        return $result = $this->db->query($sql)->row();
    }

    /*
     * Function         : select_course_id_from_quiz_permission
     * Used IN          : 
     * Description      : 
     * Parameter        : 
     * return           : 
     * redirect         : 
     * Developed By     : Tania Akter
     * Date             : 03-08-2016
     */

    function select_course_id_from_quiz_permission() {
        $sql = "SELECT GROUP_CONCAT(cp.course_id) AS course_id FROM tbl_course_quiz_permission AS cp";
        return $this->db->query($sql)->row()->course_id;
    }

    //tania 26-08-2016
    function show_question_no($quiz_id, $question_id) {
        $question_info = $this->select_question_by_quiz_id($quiz_id);
        $question_id_array = array();
        foreach ($question_info as $questions) {
            $question_id_array[] = $questions->question_id;
        }
        return (array_search($question_id, $question_id_array) + 1);
    }

//tania 26-08-2016    
    function select_question_by_quiz_id($quiz_id) {
        $sql = "SELECT * FROM tbl_question 
	WHERE quiz_id= '$quiz_id'";
        return $this->db->query($sql)->result();
    }

//tania 29-08-2016    
    function active_quiz_status() {
        $quiz_id = $this->input->post('quiz_id', TRUE);
        $data = array();
        $data['quiz_status'] = 1; //unpublished=0;published=1;archived=2;pending=3;
        $this->db->where('quiz_id', $quiz_id);
        $this->db->update('tbl_quiz', $data);
    }

//tania 29-08-2016    
    function inactive_quiz_status() {
        $quiz_id = $this->input->post('quiz_id', TRUE);
        $data = array();
        $data['quiz_status'] = 0; //unpublished=0;published=1;archived=2;pending=3;
        $this->db->where('quiz_id', $quiz_id);
        $this->db->update('tbl_quiz', $data);
    }

//tania 29-08-2016    
    function get_quiz_info_by_quiz_id($quiz_id) {
        $sql = "SELECT * FROM tbl_quiz as q,
               tbl_url as u
               WHERE
               q.quiz_id = '$quiz_id'
               AND q.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

}
