<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Super_admin_profile_model extends CI_Model {
    
   /**
     * @Function            : save_eduIns_model 
     * @Used IN             : @function- 'save_eduIns'
     * @Description         : Saves new education institute to database
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 15-12-2016 04:53 PM  
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */  
   public function save_eduIns_model($data){
       $this->db->insert('tbl_education_institute', $data);
   }
   
   /**
     * @Function            : select_all_eduIns_name_model 
     * @Used IN             : @function- 'view_eduIns'
     * @Description         : gets the name of all the educational institute
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 15-12-2016 05:14 PM  
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     * */ 
   
   public function select_all_eduIns_model() {
       $data =  $this->db->select('*')
                ->from('tbl_education_institute')
                ->limit(10)
                ->get()
                ->result();
       return $data;
   }
   
   /**
     * @Function            : select_eduIns_by_id
     * @Used IN             : @function- 'get_eduIns'
     * @Description         : Select education institute detail by id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-12-2016 04:38 PM  
     * @Parameter           : $eduIns_id
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     * */
   
   public function select_eduIns_by_id($eduIns_id){
       $data = $this->db->select("*")
                        ->from('tbl_education_institute')
                        ->where('education_institute_id', $eduIns_id)
                        ->get()
                        ->row();       
       return $data;
   }
   
   /**
     * @Function            : update_eduIns_model
     * @Used IN             : @function- 'update_eduIns'
     * @Description         : Updates education institute detail by id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-12-2016 02:38 PM  
     * @Parameter           : $data [new eduIns detail], $id[eduIns id]
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     * */
   public function update_eduIns_model($data, $id){
       $this->db->where('education_institute_id', $id);
       $this->db->update('tbl_education_institute', $data);
   }
   
   /**
     * @Function            : delete_eduIns_model
     * @Used IN             : @function- 'delete_eduIns'
     * @Description         : Delete education institute by id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-12-2016 03:00 PM  
     * @Parameter           : $id[eduIns id]
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     * */
   public function delete_eduIns_model($id) {
       $this->db->where('education_institute_id', $id)->delete('tbl_education_institute');
   }
   
    /*
     * @Function            : total_eduIns_model
     * @Used IN             : @function- 'get_pagination_data'
     * @Description         : Counts the number to total education institute
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-12-2016 03:00 PM  
     * @Parameter           : Null
     * @View                : Null
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available
     */
   public function total_eduIns_model($condition = null, $search_text){
//        $data = $this->db->select('*')
//                ->from('tbl_education_institute')
//                ->count_all_results();
//       return $data;
       
       if($condition != null){
            $result = $this->db->select('*')->from('tbl_education_institute')->order_by('education_institute_name', 'ASC')
                               ->where($condition)->like('education_institute_name',$search_text)
                               ->count_all_results();
        }else{
            $result = $this->db->select('*')->from('tbl_education_institute')->order_by('education_institute_name', 'ASC')
                               ->like('education_institute_name',$search_text)
                               ->count_all_results();
        }
        return $result;       
   }
   
   
    /*
     * @Function            : view_eduIns_name_model
     * @Used IN             : @function- 'view_eduIns_name'
     * @Description         : gets the edu Ins detail based on search from db
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 21-12-2016 06:12 PM  
     * @Parameter           : $condition [search input], $search_text[text input for search]
     * @View                : Null
     * @Redirect            : None
     * @Return              : $result
     * @Status              : Available
     */
   public function view_eduIns_name_model($condition = null, $search_text, $current_page){
       if($current_page != ''){
           $limit = ($current_page*10)-10;
       }else{
           $limit = 0;
       }
       
        if($condition != null){
            $result = $this->db->select('*')->from('tbl_education_institute')->order_by('education_institute_name', 'ASC')
                               ->where($condition)->like('education_institute_name',$search_text)
                               ->limit(10, $limit)->get()->result();
        }else{
            $result = $this->db->select('*')->from('tbl_education_institute')->order_by('education_institute_name', 'ASC')
                               ->like('education_institute_name',$search_text)
                               ->limit(10, $limit)->get()->result();
        }
         return $result;   
   }
   
     /*
     * @Function            : select_institute_dropdown
     * @Used IN             : select_institute [profile - controller]
     * @Description         : gets name of the edu ins for dropdown list 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 26-12-2016 06:12 PM
     * @Parameter           : $condition [instype, insStatus, Country, City]
     * @View                : Null
     * @Redirect            : None
     * @Return              : $result
     * @Status              : Available
     */
   public function select_institute_dropdown($condition, $eduinsStatus) {       
       $result = $this->db->select('*')->from('tbl_education_institute')
               ->where($condition)->where_in($eduinsStatus)->order_by('education_institute_name')
               ->get()->result();
       return $result;
   }
   
   
    /*
     * @Function            : approve_edu_ins_model 
     * @Used IN             : @function- 'approve-edu-ins'
     * @Description         : Approve education institute status
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 10-01-2017
     * @Parameter           : $education_institute_id
     * @Status              : Available        
     */
   public function approve_edu_ins_model($education_institute_id){
       $this->db->set('education_institute_status', 3)
                ->where('education_institute_id', $education_institute_id)
                ->update('tbl_education_institute');
   }
   
    /*
     * @Function            : delete_education_detail_information
     * @Used IN             : delete_education [profile - controller]
     * @Description         : Delete education detail information 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 28-12-2016 02:00 PM
     * @Parameter           : $data [person_id, person_education_details_id]
     * @View                : Null
     * @Redirect            : None
     * @Return              : Null
     * @Status              : Available
     */
   public function delete_education_detail_information($data) {
        $this->db->where($data);
        $this->db->delete('tbl_person_education_details');
   }      
    //...............student profile Information ...............
    // $user_id means person_id from Session 
    public function student_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_institute($country, $city, $attended_for) {
        $sql = "SELECT * 
                FROM 
                    tbl_education_institute 
                WHERE
                    education_institute_country = '$country'
                AND education_institute_city = '$city'
                AND education_institute_type = '$attended_for' ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_person_edication_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_education_details as ped, "
                . "     tbl_education_institute as ei "
                . " WHERE "
                . "         ped.person_id = $person_id "
                . "     AND ei.education_institute_id = ped.education_institute_id";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);exit();
        return $result;
    }

    public function select_person_work_by_id($person_id) {
        $sql = "SELECT * FROM tbl_person_work_details as pwd WHERE pwd.person_id = $person_id";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);exit();
        return $result;
    }

    public function select_person_work_by_work_id($person_id, $work_detail_id) {
        $sql = "SELECT * FROM tbl_person_work_details as pwd WHERE pwd.person_id = $person_id AND pwd.person_work_details_id = $work_detail_id";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);exit();
        return $result;
    }

    public function select_person_edication_by_education_id($person_id, $education_detail_id) {
        $sql = "SELECT * "
                . " FROM "
                . "         tbl_person_education_details as ped, "
                . "         tbl_education_institute as ei"
                . " WHERE "
                . "         ped.person_id = $person_id "
                . "     AND ped.person_education_details_id = $education_detail_id"
                . "     AND ei.education_institute_id = ped.education_institute_id";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);exit();
        return $result;
    }


    public function education_school_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_collage_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 2);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_graduation_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 3);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_post_graduation_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 4);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function remove_selected_education_info($person_education_details_id) {
        $this->db->where('person_education_details_id', $person_education_details_id);
        $this->db->delete('tbl_person_education_details');
    }

    public function remove_selected_work_info($person_work_details_id) {
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->delete('tbl_person_work_details');
    }

    public function remove_selected_interest_info($field_of_interest_id) {
        $this->db->where('field_of_interest_id', $field_of_interest_id);
        $this->db->delete('tbl_field_of_interest');
    }

    public function update_education_info_save($education_institution_name, $educational_description, $education_school_id) {
        $this->db->set('education_institution_name', $education_institution_name);
        $this->db->set('educational_description', $educational_description);
        $this->db->where('person_education_details_id', $education_school_id);
        $this->db->update('tbl_person_education_details');
    }

    public function update_work_info_save($person_work_details_id, $company_name, $designation, $company_address, $work_currently_here) {
        $this->db->set('company_name', $company_name);
        $this->db->set('designation', $designation);
        $this->db->set('company_address', $company_address);
        $this->db->set('work_currently_here', $work_currently_here);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->update('tbl_person_work_details');
    }

    public function update_education_status_info($person_education_details_id, $status_id) {
        $this->db->set('person_education_status', $status_id);
        $this->db->where('person_education_details_id', $person_education_details_id);
        $this->db->update('tbl_person_education_details');
    }

    public function update_work_see_status_info($person_work_details_id, $status_id) {
        $this->db->set('work_details_status', $status_id);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->update('tbl_person_work_details');
    }

    public function save_update_interest_field_info($field_of_interest_id, $field_of_interest_name) {
        $this->db->set('field_of_interest_name', $field_of_interest_name);
        $this->db->where('field_of_interest_id', $field_of_interest_id);
        $this->db->update('tbl_field_of_interest');
    }

    /*
     * @author Suddam Hossain
     * function select_user_work_details-> retrive user work information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:05/02/2015
     * return $result(cary work details) to  student_class_room function
     */

    public function select_user_work_details($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_work_details');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_wish_list($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_wish_list_management as wl');
        $this->db->where('person_id', $person_id);
        $this->db->where('wishlist_status', 1);
        $this->db->join('tbl_course as c', 'wl.course_id = c.course_id');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function delete_select_wishlist($wish_list_management_id) {
        $this->db->set('wishlist_status', 0);
        $this->db->where('wish_list_management_id', $wish_list_management_id);
        $this->db->update('tbl_wish_list_management');
    }

    public function update_wishlist($person_id, $course_id) {
        $this->db->set('wishlist_status', 2);
        $this->db->where('person_id', $person_id);
        $this->db->where('course_id', $course_id);
        $this->db->update('tbl_wish_list_management');
    }

    public function all_my_billing_details($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_payment as py');
        $this->db->where('person_id', $person_id);
        $this->db->join('tbl_payment_details_information as pd', 'py.payment_id = pd.payment_id');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    /*
     * @author Suddam Hossain
     * function select_user_education_details-> retrive user education information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:02/05/2015
     * return $result(cary education details) to  student_class_room function
     */

    public function select_user_education_details($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function archive_education_detail_information($education_detail_id) {
        $this->db->set('person_education_status', 0);
        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details');
    }

    public function select_group_details($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_user_education_detail_by_edu_id($education_detail_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS  ed,
                    tbl_education_institute AS ei 
                WHERE 
                    ed.person_education_details_id = '$education_detail_id' 
                AND ed.education_institute_id = ei.education_institute_id";
        return $this->db->query($sql)->row();
    }

//====================selected_group_post_details=========================================    

    public function selected_group_post_details($group_id) {

        $sql = "SELECT pi.*,p.*,pg.* FROM tbl_person as pi, tbl_post as p,tbl_post_group as pg,tbl_group_member as gm WHERE pg.group_id=$group_id AND p.post_id=pg.post_id AND p.posted_by = pi.person_id GROUP BY p.post_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_post_details=========================================    

    public function select_post_details() {
        $sql = "SELECT * FROM tbl_post as po, tbl_person as p WHERE po.posted_by = p.person_id AND po.post_type = 1 ORDER BY po.post_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_my_link_post start model panel=========================================

    public function select_my_link_post_details($person_id) {
        $sql = "SELECT * FROM tbl_post as po,tbl_person_link as pl,tbl_person as p WHERE po.post_type = 3 AND (po.posted_by = pl.person_id OR po.posted_by = pl.requested_person_id) AND (pl.person_id = $person_id OR pl.requested_person_id = $person_id)AND po.posted_by = p.person_id  ORDER BY po.post_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_my_link_post end model panel=========================================

    public function select_post_comment_info($post_id) {
        $sql = "SELECT c.*, pi.* FROM tbl_comment as c, tbl_post as p, tbl_person as pi WHERE c.post_id = $post_id AND c.post_id = p.post_id AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->result();
        return $result;
    }

    public function select_post_comment_info_by_comment_id($post_comment_id) {
        $sql = "SELECT c.*, pi.* FROM tbl_comment as c, tbl_post as p, tbl_person as pi WHERE c.post_comment_id = $post_comment_id AND c.post_id = p.post_id AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function select_reply_comment_info_by_id($comment_replay_id) {
        $sql = "SELECT cr.*,pe.* FROM tbl_comment_replay as cr, tbl_post as p,tbl_comment as c, tbl_person as pe WHERE cr.comment_replay_id= $comment_replay_id AND cr.comment_replay_by=pe.person_id AND cr.post_id = p.post_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();

        return $result;
    }

    public function select_post_comment_replay($post_comment_id) {

        $sql = "SELECT cr.*,pe.* FROM tbl_comment_replay as cr, tbl_post as p,tbl_comment as c, tbl_person as pe "
                . "WHERE cr.post_comment_id= $post_comment_id AND cr.post_comment_id=c.post_comment_id AND cr.post_id = p.post_id AND cr.comment_replay_by = pe.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->result();
        return $result;
    }

    public function post_save($data) {
        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();
        return $post_id;
    }

    public function selected_group_post_save($mdata) {
        $this->db->insert('tbl_post_group', $mdata);
    }

    public function member_comment_save($data) {
        $this->db->insert('tbl_comment', $data);
        $comment_id = $this->db->insert_id();
        return $comment_id;
    }

    public function select_new_comment_info($comment_id) {
        $sql = "SELECT c.* FROM tbl_comment as c, tbl_person as pi WHERE c.post_comment_id =$comment_id AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function comment_replay_save($data) {
        $this->db->insert('tbl_comment_replay', $data);
        $replay_id = $this->db->insert_id();
        return $replay_id;
    }

    public function select_group($text, $person_id) {
        $sql = "SELECT * FROM tbl_group as g,tbl_group_member as gm WHERE gm.person_id = $person_id AND  gm.group_id = g.group_id AND g.group_name LIKE '%$text%' AND g.group_status = 1 ";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function search_person_group_availability($person_id) {
        $sql = "SELECT * FROM tbl_group as g,tbl_group_member as gm WHERE gm.person_id = $person_id AND  gm.group_id = g.group_id AND g.group_status = 1 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//    public function select_user($text) {
//        $sql = "SELECT * FROM tbl_person as pi WHERE pi.person_first_name LIKE '$text%'";
//        $result = $this->db->query($sql)->result();
//        return $result;
//    }
    // save user Educational Informaion=======================================================

    public function save_education_information() {
        $data = array();
        $data['person_id'] = $this->input->post('person_id', TRUE);
        $data['education_institute_id'] = $this->input->post('education_institute_id', TRUE);

        if ($data['education_institute_id'] == 'other') {
            $oei_data['education_institute_country'] = $this->input->post('education_institute_country', TRUE);
            $oei_data['education_institute_city'] = $this->input->post('education_institute_city', TRUE);
            $oei_data['education_institute_name'] = $this->input->post('education_institute_name', TRUE);
            $oei_data['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $oei_data['education_institute_status'] = 1;
            $this->db->insert('tbl_education_institute', $oei_data);
            $data['education_institute_id'] = $this->db->insert_id();
        }
        $data['person_current_education_instute'] = $this->input->post('person_current_education_instute');
        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        if ($data['person_current_education_instute'] == 1) {
            $data['end_time_period'] = NULL;
        } else {
            $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        }
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = 1;

//        echo '<pre>';
//        print_r($data);
//        exit();
        $this->db->insert('tbl_person_education_details', $data);
    }

    public function select_user_education_detail_by_id($id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS ed,
                    tbl_education_institute AS  ei
                WHERE 
                    person_education_details_id = '$id'  
                    AND ed.education_institute_id = ei.education_institute_id";
        return $this->db->query($sql)->row();
//        return $this->db->query($sql)->result();
    }

    public function update_education_information($education_detail_id) {
        $data = array();
        $data['person_id'] = $this->input->post('person_id', TRUE);
        $data['education_institute_id'] = $this->input->post('education_institute_id', TRUE);

        if ($data['education_institute_id'] == 'other') {
            $oei_data['education_institute_country'] = $this->input->post('education_institute_country', TRUE);
            $oei_data['education_institute_city'] = $this->input->post('education_institute_city', TRUE);
            $oei_data['education_institute_name'] = $this->input->post('education_institute_name', TRUE);
            $oei_data['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $oei_data['education_institute_status'] = 0;
            $this->db->insert('tbl_education_institute', $oei_data);
            $data['education_institute_id'] = $this->db->insert_id();
        }
        $data['person_current_education_instute'] = $this->input->post('person_current_education_instute');
        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        if ($data['person_current_education_instute'] == 1) {
            $data['end_time_period'] = NULL;
        } else {
            $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        }
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = 1;
        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details', $data);
    }

    public function active_education_detail_information($education_detail_id) {
        $this->db->set('person_education_status', '1');
        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details');
    }

    public function inactive_education_detail_information($education_detail_id) {
        $this->db->set('person_education_status', '0');
        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details');
    }


    // save user Work Details Informaion=======================================================

    public function save_work_details_information() {
        $wdata = array();
        $wdata['person_id'] = $this->input->post('person_id', TRUE);
        $wdata['company_name'] = $this->input->post('company_name', TRUE);
        $wdata['designation'] = $this->input->post('designation', TRUE);
        $wdata['company_address'] = $this->input->post('company_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('job_start_date', TRUE);
        $wdata['job_end_date'] = $this->input->post('job_end_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_currently_here', TRUE);
        $wdata['job_responsibility_details'] = $this->input->post('job_responsibility_details', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = 1;
//        echo '<pre>';
//        print_r($data);
//        exit();    
        $this->db->insert('tbl_person_work_details', $wdata);
    }

    public function update_work_experience_information($work_detail_id) {
        $wdata = array();
        $wdata['person_id'] = $this->input->post('person_id', TRUE);
        $wdata['company_name'] = $this->input->post('company_name', TRUE);
        $wdata['designation'] = $this->input->post('designation', TRUE);
        $wdata['company_address'] = $this->input->post('company_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('job_start_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_currently_here', TRUE);
        if ($wdata['work_currently_here'] == 1) {
            $wdata['job_end_date'] = NULL;
        } else {
            $wdata['job_end_date'] = $this->input->post('job_end_date', TRUE);
        }
        $wdata['job_responsibility_details'] = $this->input->post('job_responsibility_details', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = 1;
//        echo '<pre>';
//        print_r($wdata);
//        exit();  
        $this->db->where('person_work_details_id', $work_detail_id);
        $this->db->update('tbl_person_work_details', $wdata);
    }

    public function select_user_work_experience_detail_by_id($id) {
        $sql = "SELECT * FROM tbl_person_work_details  WHERE person_work_details_id = '$id'";
        return $this->db->query($sql)->row();
    }

    public function archive_word_detail_information($work_detail_id) {
        $this->db->set('work_details_status', '2');
        $this->db->where('person_work_details_id', $work_detail_id);
        $this->db->update('tbl_person_work_details');
    }

    public function select_user_work_detail_by_edu_id($work_detail_id) {
        $sql = "SELECT * FROM tbl_person_work_details WHERE person_work_details_id = '$work_detail_id'";
        return $this->db->query($sql)->row();
    }

    public function active_word_detail_information($education_detail_id) {
        $this->db->set('work_details_status', '1');
        $this->db->where('person_work_details_id', $education_detail_id);
        $this->db->update('tbl_person_work_details');
    }

    public function inactive_work_detail_information($education_detail_id) {
        $this->db->set('work_details_status', '0');
        $this->db->where('person_work_details_id', $education_detail_id);
        $this->db->update('tbl_person_work_details');
    }

    public function delete_work_detail_information($work_detail_id) {
        $this->db->where('person_work_details_id', $work_detail_id);
        $this->db->delete('tbl_person_work_details');
    }

    // Start Save User PC Information

    function save_person_pc_info($pc_data) {
        $this->db->insert('tbl_person_pc_info', $pc_data);
        return $this->db->insert_id();
    }

    function save_person_logout_time($logout_time, $person_pc_info_id) {
        $this->db->set('person_site_visit_end_time', $logout_time);
        $this->db->set('person_login_status',2);
        $this->db->where('person_pc_info_id', $person_pc_info_id);
        $this->db->update('tbl_person_pc_info');
    }
    
    function save_person_unexpected_value($person_pc_info_id){
        $this->db->set('person_login_status',3);
        $this->db->where('person_pc_info_id', $person_pc_info_id);
        $this->db->update('tbl_person_pc_info');
    }

    // End Save User PC Information
    // Start User Feature Status Details
    function change_email_status($new_status, $person_id) {
        $this->db->set('person_email_view_status', $new_status);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person_info_view_status');
    }

    function change_contact_status($new_status, $person_id) {
        $this->db->set('person_contact_number_view_status', $new_status);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person_info_view_status');
    }

    function change_address_status($new_status, $person_id) {
        $this->db->set('person_address_view_status', $new_status);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person_info_view_status');
    }

    function change_birthday_status($new_status, $person_id) {
        $this->db->set('person_birthday_view_status', $new_status);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person_info_view_status');
    }

    // select user Save Self Assessment Skills Field Informaion=======================================================
    function save_self_assessment_skills($person_id) {
//        $data = array();
////        $data['person_id'] = $person_id;
//        $self_assessment = $this->input->post('self_assessment_skills_name', TRUE);
//        $data = explode(',', $self_assessment);
        $self_assessment_skills_name = $this->input->post('tokenize_placeholder', TRUE);
//        print_r($self_assessment_skills_name);
//        exit();

        for ($i = 0; $i < count($self_assessment_skills_name); $i++) {
            $sql = "INSERT INTO tbl_self_assessment_skills(person_id,self_assessment_skills_name)"
                    . "VALUES('$person_id','$self_assessment_skills_name[$i]')";
            $this->db->query($sql);
        }
//        $data['self_assessment_skills_name'] = $this->input->post('self_assessment_skills_name', TRUE);
//        $this->db->insert('tbl_self_assessment_skills', $data);
    }

    function update_self_assessment_skills($person_id) {
        $this->db->where('person_id', $person_id);
        $this->db->delete('tbl_self_assessment_skills');
        $self_assesment = $this->input->post('tokenize_placeholder_self_asses_edit', TRUE);
        for ($i = 0; $i < count($self_assesment); $i++) {
            $sql = "INSERT INTO tbl_self_assessment_skills(person_id,self_assessment_skills_name)"
                    . "VALUES('$person_id','$self_assesment[$i]')";
            $this->db->query($sql);
        }
    }

    // select user Interest Field Informaion=======================================================

    public function save_interest_field($person_id) {
        $interest_field = $this->input->post('tokenize_placeholder_add_interest', TRUE);
        for ($i = 0; $i < count($interest_field); $i++) {
            $sql = "INSERT INTO tbl_field_of_interest(person_id,field_of_interest_name)"
                    . "VALUES('$person_id','$interest_field[$i]')";
            $this->db->query($sql);
        }
    }

    public function update_interest_field($person_id) {
        $this->db->where('person_id', $person_id);
        $this->db->delete('tbl_field_of_interest');
        $interest_field = $this->input->post('tokenize_placeholder_interest_edit', TRUE);
        for ($i = 0; $i < count($interest_field); $i++) {
            $sql = "INSERT INTO tbl_field_of_interest(person_id,field_of_interest_name)"
                    . "VALUES('$person_id','$interest_field[$i]')";
            $this->db->query($sql);
        }
    }

    public function select_user_interest_field($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $person_id);
        $this->db->limit(5);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    //Language Field =========================

    public function save_language($person_id) {
        $data = array();
        $data['person_id'] = $person_id;
        $data['person_language'] = $this->input->post('person_language', TRUE);
        $data['person_language_proficiency'] = $this->input->post('person_language_proficiency', TRUE);
        $this->db->insert('tbl_person_language', $data);
    }

    public function archive_language_by_id($person_language_id) {
        $this->db->set('person_language_status', 3);
        $this->db->where('person_language_id', $person_language_id);
        $this->db->update('tbl_person_language');
    }

    public function active_language_by_id($person_language_id) {
        $this->db->set('person_language_status', 1);
        $this->db->where('person_language_id', $person_language_id);
        $this->db->update('tbl_person_language');
    }

    public function delete_language_by_id($person_language_id) {
        $this->db->where('person_language_id', $person_language_id);
        $this->db->delete('tbl_person_language');
    }

    public function select_single_language_value($person_language_id) {
        $sql = "SELECT * FROM tbl_person_language WHERE person_language_id = '$person_language_id'";
        return $this->db->query($sql)->row();
    }

    //update user Name ========================= 

    public function update_person_name_save($person_first_name, $person_last_name, $person_id) {
        $this->db->set('person_first_name', $person_first_name);
        $this->db->set('person_last_name', $person_last_name);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_email_save($person_email, $person_id) {
        $this->db->set('person_email', $person_email);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_contact_save($person_contact_number, $person_id) {
        $this->db->set('person_contact_number', $person_contact_number);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_address_save($person_address, $person_id) {
        $this->db->set('person_address', $person_address);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_zip_save($person_zip, $person_id) {
        $this->db->set('person_zip', $person_zip);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    /*
     * @author Suddam Hossain
     * function select_my_friends_details-> retrive my friends information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:03/05/2015
     * return $result(cary friends details) 
     */

    public function select_my_friends_details_part1($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person_link');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function selected_friends_details_part1($requested_person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $requested_person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_my_friends_details_part2($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person_link');
        $this->db->where('requested_person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function selected_friends_details_part2($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function check_group($requested_person_id, $group_id) {
        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $requested_person_id);
        $this->db->where('group_id', $group_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function quiz_info_by_person_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_quiz');
        $this->db->where('person_id', $person_id);
        $this->db->where('quiz_status', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function save_grade_info($data) {
        $this->db->insert('tbl_grade', $data);
    }

    public function select_all_grade_info() {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT gr.*,q.quiz_name FROM tbl_grade as gr,tbl_quiz as q "
                . "WHERE gr.resource_person_id = $person_id  AND gr.quiz_id=q.quiz_id ORDER BY q.quiz_name";
        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_all_certificate_info() {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT c.*,q.quiz_name FROM tbl_certificate as c,tbl_quiz as q "
                . "WHERE c.resource_person_id = $person_id  AND c.quiz_id=q.quiz_id ORDER BY q.quiz_name";
        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function selected_grade_active($grade_id) {
        $this->db->set('grade_status', 1);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function selected_grade_inactive($grade_id) {
        $this->db->set('grade_status', 0);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function select_all_grade_info_by_id($grade_id) {

        $this->db->select('*');
        $this->db->from('tbl_grade');
        $this->db->where('grade_id', $grade_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function update_grade_info($data, $grade_id) {

        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade', $data);
    }

    public function save_certificate_info($data) {
        $this->db->insert('tbl_certificate', $data);
    }

    public function selected_certificate_active($certificate_id) {

        $this->db->set('certificate_share_status', 1);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function selected_certificate_inactive($certificate_id) {

        $this->db->set('certificate_share_status', 0);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function certificate_details($certificate_id) {

        $this->db->select('*');
        $this->db->from('tbl_certificate');
        $this->db->where('certificate_id', $certificate_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function delete_image_by_id($certificate_id) {

        $sql = "SELECT * FROM tbl_certificate WHERE certificate_id=$certificate_id";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();


        unlink("$result->certificate_image");


        $this->db->set('certificate_image', '');
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');

//        return $result;
    }

    public function update_certificate_info($data, $certificate_id) {

        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate', $data);
        $result = $this->db->insert_id();
        return $result;
    }

    public function select_save_comment($insert_id) {

        $this->db->select('*');
        $this->db->from('tbl_comment');
        $this->db->where('insert_id', $insert_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
    }

    public function update_due_payment($payment_details_information_id, $data) {

        $this->db->where('payment_details_information_id', $payment_details_information_id);
        $this->db->update('tbl_payment_details_information', $data);
    }

    public function select_person_link_with_pagination($person_id,$start, $limit) {
//        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl"
                . " WHERE "
                . "         (pl.person_id = $person_id "
                . "     OR pl.requested_person_id = $person_id)"
                . "     AND (pl.add_link_request_status = 1 OR pl.add_link_request_status = 3)"
                . " GROUP BY pl.person_link_id"
        ;
        if ($limit != null) {
            $sql .= " LIMIT $start, $limit ";
        }
        $result = $this->db->query($sql)->result();
        return $result;
    }

}
