<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => all about student information
 *
 * @author Md Jaherul Islam
 */
class Student_model extends CI_Model {

    const tbl_name = 'tbl_student';
    const primary_key = 'student_id';

    private $result;

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : student_registration 
     * @Used IN             : @function-'enroll_course'   course_controller
     * @Description         : Course/Video Course Student registration if course are free or paid
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 10:21 AM  
     * @Parameter           : $course_id/$video_course_id[INTEGER], $student_course_type=>[1 for Course, 2 for Video Course]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function student_registration($student_type, $student_type_id) {
        $s_data = Array();
        $s_data['student_type'] = $student_type;
        $s_data['student_type_id'] = $student_type_id;
        $s_data['person_id'] = $this->session->userdata('person_id');
        $s_data['student_roll_number'] = $this->generate_student_roll_number();
        $s_data['register_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        $this->db->insert('tbl_student', $s_data);
    }

    /**
     * @Function            : generate_student_roll_number 
     * @Used IN             : @function-'student_registration'   this[Model]
     * @Description         : generate student roll number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 10:31 AM  
     * @Modified By         : Md. Delwar Hossain
     * @Modified DateTime   : 29-04-2017 10:31 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function generate_student_roll_number() {
        $date_format = date("Ym", (time() - $this->session->userdata('time_offset')));
        $student_random = mt_rand(100000,999999);
        $student_roll = $date_format . 'tt' . $student_random;
        
        $result = $this->check_student_roll_number_existance($student_roll);
        if ($result > 0) {
            $this->generate_student_roll_number();
        } else {
            return $student_roll;
        }
    }

    /**
     * @Function            : check_student_roll_number_existance 
     * @Used IN             : @function-'generate_student_roll_number'   this[Model]
     * @Description         : check all student roll number existance
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 29-04-2017 10:31 AM  
     * @Parameter           : $student_roll
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function check_student_roll_number_existance($student_roll) {
        $this->db->select('*')
                ->from('tbl_student')
                ->where('student_roll_number',$student_roll);
        return $this->db->count_all_results();
    }

    /**
     * @Function            : get_all_concat_student_list_by_course_id 
     * @Used IN             : @function-'enroll_course'   course[@Controller]
     * @Description         : get all student information by course ID in concat formt
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-09-2016 10:08 AM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_all_concat_student_list_by_course_id($student_type, $student_type_id) {
        $sql = "SELECT GROUP_CONCAT(s.person_id) AS person_id FROM tbl_student AS s WHERE s.student_type = '$student_type' AND s.student_type_id = '$student_type_id'";
        return $this->db->query($sql)->row()->person_id;
    }

    /**
     * @Function            : get_all_concat_student_id_list_by_course_id 
     * @Used IN             : @function-'change_course_status'   super_admn_course[@Controller]
     * @Description         : get all student ID information by course ID in concat formt
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-09-2016 01:13 PM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_all_concat_student_id_list_by_course_id($student_type, $student_type_id) {
        $this->db->select('GROUP_CONCAT(student_id) AS student_id')->from('tbl_student')
                ->where(Array('student_type' => $student_type, 'student_type_id' => $student_type_id));
        return $this->db->get()->row()->student_id;
    }

    /**
     * @Function            : get_all_student_list_by_course_id 
     * @Used IN             : @function-'registered_student_list'   this[Model]
     * @Description         : get all student information bu course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 03:08 PM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_all_student_list_by_course_id($student_type, $student_type_id, $date, $limit) {
        $this->db->select('*')
                ->from('tbl_student AS s')
                ->join('tbl_person AS p', 's.person_id = p.person_id')
                ->join('tbl_url AS u', 'p.url_id = u.url_id')
                ->where(Array('s.student_type' => $student_type, 's.student_type_id' => $student_type_id));
        if ($date) {
            $this->db->where("DATE(s.register_date_time) BETWEEN '$date[sess_start_date]' AND '$date[sess_end_date]'");
        }
        return $this->db->limit(10, $limit)->get()->result();
    }

    /**
     * @Function            : get_all_student_list_by_course_id 
     * @Used IN             : @function-"registered_student_list'   this[Model]
     * @Description         : get all student information bu course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-09-2016 03:08 PM  
     * @Parameter           : $student_type=> Course=1, Video COurse=2
     *                        $student_type_id=> course_id, video_course_id,quiz_id
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_total_student_by_course_id($student_type, $student_type_id, $date) {
        $this->db->select('*')
                ->from('tbl_student')
                ->where(Array('student_type' => $student_type, 'student_type_id' => $student_type_id));
        if ($date) {
            $this->db->where("DATE(register_date_time) BETWEEN '$date[sess_start_date]' AND '$date[sess_end_date]'");
        }
        return $this->db->count_all_results();
    }

    /**
     * @Description         : set student ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:37 PM 
     * */
    private $student_id;

    function set_student_id($student_id) {
        $this->student_id = $student_id;
        return $this;
    }

    /**
     * @Description         : set student type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 09:54 AM 
     * */
    private $type;

    function set_type($type) {
        $this->type = $type;
        return $this;
    }

    /**
     * @Description         : set student type ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 09:54 AM 
     * */
    private $type_id;

    function set_type_id($type_id) {
        $this->type_id = $type_id;
        return $this;
    }

    /**
     * @Description         : set student type ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 09:54 AM 
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * @Description         : set Limit
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 11:04 AM 
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : set register date time
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 12:52 PM 
     * */
    private $register_date_time;

    function set_register_date_time($register_date_time) {
        $this->register_date_time = $register_date_time;
        return $this;
    }

    /**
     * @Description         : set student roll number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 12:54 PM 
     * */
    private $search_input;

    function set_search_input($search_input) {
        $this->search_input = $search_input;
        return $this;
    }

    /**
     * @Description         : set student roll number
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 12:54 PM 
     * */
    private $payment_status;

    function set_payment_status($payment_status) {
        $this->payment_status = $payment_status;
        return $this;
    }

    /**
     * @Description         : set course video ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-01-2016 10:16 AM 
     * */
    function set_course_video_course_id() {
        $this->result = $this->db->select('GROUP_CONCAT(student_type_id) AS id')
                        ->from(self::tbl_name)
                        ->where(['student_type' => $this->type, 'person_id' => $this->person_id])
                        ->get()->row();
        return $this;
    }

    /**
     * @Description         : set total student by course /Video COurse ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:02 AM 
     * */
    function set_total_student_by_course_id() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where(['student_type' => $this->type, 'student_type_id' => $this->type_id])->count_all_results();
        return $this;
    }

    /**
     * @Description         : set student by course /Video COurse ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:02 AM 
     * */
    function set_student_info_corurse() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where_in(['student_type' => $this->type, 'student_type_id' => $this->type_id, 'person_id' => $this->person_id])
                        ->get()->row();
        return $this;
    }

    /**
     * @Description         : set total student by course /Video COurse ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:02 AM 
     * */
    function set_student_info_by_type_id() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where(['student_type' => $this->type, 'student_type_id' => $this->type_id])->get()->result();
        return $this;
    }

    /**
     * @Description         : set student by type[Course/Video Course]
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 10:26 AM 
     * */
    function set_student_by_type() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where(['student_type' => $this->type])->limit(10, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : set student by multiple student ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 02:56 AM 
     * */
    function set_student_by_multiple_student_id() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where_in('student_id', $this->student_id)->limit(10, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : set student by type[Course/Video Course]
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 10:26 AM 
     * */
    function set_total_student_by_type() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where(['student_type' => $this->type])->count_all_results();
        return $this;
    }

    /**
     * @Description         : set student ID by studentregister Date and student Name
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 12:43 PM 
     * */
    function set_student_id_by_student_reg_date_and_name() {
        $this->db->select('GROUP_CONCAT(s.student_id) AS id')
                ->from('tbl_student AS s')
                ->join('tbl_person AS p', 's.person_id = p.person_id')
                ->where('s.student_type', $this->type)
                ->where("(CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$this->search_input%'
                    OR p.person_contact_number LIKE '%$this->search_input%' 
                    OR p.person_email LIKE '%$this->search_input%'
                    OR s.student_roll_number LIKE '%$this->search_input%')");
        if (!empty($this->register_date_time)) {
            $this->db->where("DATE_FORMAT(s.register_date_time,'%Y-%m')", $this->register_date_time);
        }
        $this->result = $this->db->get()->row();
        return $this;
    }

    /**
     * @Description         : set student ID by studentregister Date and student Name
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 05-02-2017 12:43 PM 
     * */
    function set_student_id_by_student_reg_date_name_and_payment_status() {
        $this->db->select('GROUP_CONCAT(s.student_id) AS id')
                ->from('tbl_student AS s')
                ->join('tbl_person AS p', 's.person_id = p.person_id')
                ->join('tbl_payment AS py', 's.person_id = py.person_id AND s.student_type_id = py.payment_type_id')
                ->where('s.student_type', $this->type)->where('py.payment_type', $this->type)
                ->where("(CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$this->search_input%'
                    OR p.person_contact_number LIKE '%$this->search_input%' 
                    OR p.person_email LIKE '%$this->search_input%'
                    OR s.student_roll_number LIKE '%$this->search_input%')");
        if (!empty($this->register_date_time)) {
            $this->db->where("DATE_FORMAT(s.register_date_time,'%Y-%m')", $this->register_date_time);
        }
        if (!empty($this->payment_status)) {
            $this->db->where("py.payment_status", $this->payment_status);
        }
        $this->result = $this->db->get()->row();
        return $this;
    }

    /**
     * @Description         : save student information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-01-2017 03:41 PM 
     * */
    function save() {
        $s_data = [];
        $s_data['student_type'] = $this->type;
        $s_data['student_type_id'] = $this->type_id;
        $s_data['person_id'] = $this->person_id;
        $s_data['student_roll_number'] = $this->generate_student_roll_number();
        $s_data['register_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $this->db->insert(self::tbl_name, $s_data);
        return $this;
    }

    /**
     * @Description         : get result
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:02 AM 
     * */
    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : delete student data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:40 PM 
     * */
    function delete() {
        $this->db->where(self::primary_key, $this->student_id)->delete(self::tbl_name);
    }

}
