<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Sign_Up_Model extends CI_Model {
    public function __construct() {
        parent::__construct();
    }   

    /*
     * @Function            : save_person_information 
     * @Used IN             : function['index'] controller[sign_up]
     * @Description         : used to save person information
     * @parameter           : $person_url_id
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Updated By          : Tania Akter
     * @Update Date         : 25-05-2016
     * @Status              : available      
     */

    function save_person_information($person_url_id) {
        $person_id = $this->save_all_person_information($person_url_id);  //add by tania
        $status_data['person_id'] = $person_id;
        $status_data['person_email_view_status'] = 1;
        $status_data['person_contact_number_view_status'] = 1;
        $status_data['person_address_view_status'] = 1;
        $status_data['person_birthday_view_status'] = 1;
        $status_data['person_self_assessment_skills_view_status'] = 1;
        $this->db->insert('tbl_person_info_view_status', $status_data);
        //$captcha = $this->input->post('captcha', TRUE);
        //$captcha_time = $this->input->post('captcha_time', TRUE);
        //$this->db->query("DELETE FROM tbl_captcha WHERE word = '$captcha' AND time = '$captcha_time'");
        return $person_id;
    }

    /* [This function code was part of (function['save_person_information'] model['registration_model']). In here i have divided (function['save_person_information'] model['registration_model']) only]
     * @Function            : save_all_person_information 
     * @Used IN             : function['save_person_information'] model['registration_model']
     * @Description         : used to save person information
     * @parameter           : $person_url_id
     * @Developed By        : Tania Akter
     * @Start Date          : 25-05-2016
     * @Status              : available      
     */

    function save_all_person_information($person_url_id) {
        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_password'] = md5($this->input->post('person_password', TRUE));
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $country_code = $this->input->post('hidden_country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_role'] = $this->input->post('person_role', TRUE);
        $pdata['person_time_zone'] = $this->input->post('person_time_zone', TRUE); //added by tania       
        $pdata['person_join_tt'] = date('Y-m-d h:i:s', (time()));
        $pdata['person_status'] = '0';
        $pdata['url_id '] = $person_url_id;
        $this->db->insert('tbl_person', $pdata);
        return $person_id = $this->db->insert_id();
    }

    /**
     * @Function            : save_organization_information 
     * @Used IN             : function-'index'      sign_up[Controller]
     * @Description         : Save organization Information 
     * @                    : @Update1 - remove otganization_status and 'feature_price_id' 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-03-2016 02:07 PM
     * @Updated By          : Ripon Jaherul 
     * @updated By          : Tania Akter (update date 24-05-2016)     
     * @Status              : available      
     * */
    public function save_organization_information($data) {
        $odata['person_id'] = $data['person_info']->person_id;
        $org_name = $this->check_org_name_exist($data['person_info']->person_first_name); //tania start
        if ($org_name) {
            $odata['organization_name'] = $org_name;
        } else {
            $odata['organization_name'] = $data['person_info']->person_first_name;
        }        //tania end
        $organization_code_w_space = preg_replace('/[^A-Za-z0-9 ]/', '', $data['person_info']->person_first_name);
        $organization_code_croped = substr($organization_code_w_space, 0, 3);
        $organization_code = $this->check_organization_code_existance($organization_code_croped);
        $odata['organization_code'] = $organization_code;
        $odata['organization_status'] = 1;
        return $this->utility_model->save_information_in_database('tbl_organization', $odata);
    }

    //tania
    /**
     * @Function            : check_org_name_exist 
     * @Used IN             : function-'save_organization_information'      sign_up[@Controller]
     * @Description         : check organization name exist in forbidden table
     * @Developed By        : Tania AKter
     * @Start DateTime      : 24-05-2016     
     * @Status              : available      
     * */
    function check_org_name_exist($org_name) {
        $i = 1;
        $organization_name = $org_name;
        do {
            $sql = "SELECT forbidden_name FROM tbl_forbidden WHERE forbidden_type='3' AND forbidden_name = '$organization_name'";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $organization_name = $org_name;
                $organization_name .= $i;
                $i++;
                $org_name = $organization_name;
            }
        } while ($result);
        return $org_name;
    }

    /**
     * @Function            : check_organization_code_existance 
     * @Used IN             : @function-'save_organization_information'  model['registration_model']  
     * @Description         : used to check organization code exist in tbl_organization  
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown   
     * @parameter           : $organization_code
     * @Status              : available      
     * */
    function check_organization_code_existance($organization_code) {
        $i = 1;
        $code = $organization_code;
        do {
            $sql = "SELECT organization_code FROM tbl_organization WHERE organization_code = '$code'";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $code = $organization_code;
                $code .= $i;
                $i++;
                $organization_code = $code;
            }
        } while ($result);
        return $organization_code;
    }

    /**
     * @Function            : save_resource_person_information
     * @Used IN             : function-'index'    sign_up[Controller]
     * @Description         : save resource person information
     * @                    : @Update1 - remove all free feature issue 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-03-2016 02:09 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    function save_resource_person_information($data) {
        $rdata['person_id'] = $data['person_info']->person_id;
        if ($data['person_info']->person_role == 4) {
            $rdata['resource_person_type'] = 3;
        } else {
            $rdata['resource_person_type'] = 2;
        }
        return $this->utility_model->save_information_in_database('tbl_resource_person', $rdata);
    }

    /* only comment written by tania (25-05-2016)
     * @Function            : check_user_email_info 
     * @Used IN             : function[email_check] controller[sign_up]
     *                        function[email_varify_for_password] controller[sign_in]
     *                        function[check_email_from_forget_password] controller[sign_in]
     *                        function[check_email_forgot_password] controller[sign_in]
     *                        function[email_check] controller[add_teacher_organization]
     * @Description         : check email address exist in tbl_person
     * @parameter           : $code (user email address)
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Status              : available      
     */

    function check_user_email_info($code) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_email', $code);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    /* comment written by tania (25-05-2016)
     * @Function            : select_captcha_word 
     * @Used IN             : function[captcha_check] controller[sign_up]
     *                        function [check_contact_captcha] controller[application]
     *                        function [check_captcha_from_forget_password] controller[sign_in]
     * @Description         : used to match captcha with given captcha word
     * @parameter           : $give_text(captcha word), $captcha_time
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Status              : available      
     */

    /*public function select_captcha_word($give_text, $captcha_time) {
        $expiration = time() - 1800; // Two hour limit
        $this->db->query("DELETE FROM tbl_captcha WHERE time < " . $expiration);

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_captcha"
                . " WHERE "
                . "         word = '$give_text' "
                . "     AND time = '$captcha_time'";
        $result = $this->db->query($sql)->row();
        return $result;
    }*/

    /** tania
     * @Function            : check_exist_sign_up_forbidden 
     * @Used IN             : @function-'check_sign_up_forbidden_exist'     sign_up[@Controller] 
     *                         function[check_email_forbidden_exist]  add_teacher_organization[controller]
     *                         function[check_org_teacher_url_existance] add_teacher_organization[controller
     *                         function[check_name_forbidden_exist] add_teacher_organization[controller]
     * @Description         : check person name exits in tbl_forbidden
     * @Developed By        : Tania Akter
     * @Start DateTime      : 22-05-2016 
     * @Parameter           : $create_name, $type(url=1;name=2;organization=3)
     * @Status              : Available        
     * */
    function check_exist_sign_up_forbidden($create_name, $type) {
        $this->db->select('forbidden_name');
        $this->db->from('tbl_forbidden');
        $this->db->where('forbidden_type', $type);
        $this->db->where('forbidden_name', $create_name);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
    /** 
     * @Function            : select_user_by_person_id 
     * @Used IN             : @function-'active_account'     sign_up[@Controller] 
     * @Description         : used to select person info by id
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown 
     * @Parameter           : $person_id
     * @Status              : Available        
     * */
    function select_user_by_person_id($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
      /** 
     * @Function            : active_user_account 
     * @Used IN             : @function-'active_account'     sign_up[@Controller] 
     * @Description         : used to update person status
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown 
     * @Parameter           : $person_id
     * @Status              : Available        
     * */
    function active_user_account($person_id) {
        $this->db->set('person_status', 1);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }
    
    
     /** tania //02-06-2016  forgot password
     * @Function            : password_recovery_request_status 
     * @Used IN             : @function-'email_varify_for_password'     sign_in[@Controller] 
     * @Description         : used to update password recovery request status
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown 
     * @Parameter           : $person_id
     * @Status              : Available        
     * */
     function password_recovery_request_status($person_id) {
        $date = date("Y/m/d", strtotime("+2 day"));
        $this->db->set('password_recovery_status', 1);
        $this->db->set('password_recovery_time', $date);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }
    
      /** tania //02-06-2016  forgot password
     * @Function            : select_recovery_status 
     * @Used IN             : @function-'reset_password'     sign_in[@Controller] 
     * @Description         : used to select send request for password recovery
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown 
     * @Parameter           : $person_id
     * @Status              : Available        
     * */
    function select_recovery_status($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('password_recovery_status', 1);    //send_request=1;request_accepted=0
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
    
    /** tania // for reset password
     * @Function            : recover_person_password 
     * @Used IN             : @function-'recover_password_matched '     sign_in[@Controller] 
     * @Description         : used to recover (update) password
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown 
     * @Parameter           : $person_id, $person_password
     * @Status              : Available        
     * */
   function recover_person_password($person_id, $person_password) {
        $this->db->set('password_recovery_status', 0);
        $this->db->set('person_password', $person_password);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }


}
