<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => All kind of Resource Person Information Query
 *
 * @author MD Jaherul Islam
 * @Date : 21-07-16
 */
class Resource_person_model extends CI_Model {

    const primary_key = 'resource_person_id';
    const tbl_name = 'tbl_resource_person';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : single_resource_person_information_by_person_id 
     * @Used IN             : @function-'get_all_notify_to_for_add_course'          super_admin_feature_model[@Model]
     * @Description         : get resource persion information using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-07-2016 06:36 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $resource_person_info[ARRAY]      
     * @Status              : available      
     * */
    function single_resource_person_information_by_person_id($person_id) {
        return $this->db->get_where('tbl_resource_person', Array('person_id' => $person_id))->row();
    }

    /**
     * @Function            : select_person_information_by_resource_person_id 
     * @Used IN             : @function-'get_resource_person_id'          notification_course_model[@Model]
     * @Description         : get resource person info by resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:19 AM   
     * @Parameter           : $resource_person_id[INEGER]
     * @Return              : $person_info[ARRAY]       
     * @Status              : available      
     * */
    function select_person_information_by_resource_person_id($resource_person_id) {
        return $this->db->get_where('tbl_resource_person', Array('resource_person_id' => $resource_person_id))->row();
    }

    /**
     * @Function            : person_information_by_resource_person_id 
     * @Used IN             : @function-'manage_course'          super_admin_course[@Controller]
     * @Description         : get person info by resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-08-2016 03:26 PM   
     * @Parameter           : $resource_person_id[INEGER]
     * @Return              : $person_info[ARRAY]       
     * @Status              : available      
     * */
    function person_information_by_resource_person_id($resource_person_id) {
        return $this->db->select('*')->from('tbl_resource_person AS rp')
                        ->join('tbl_person AS p', 'rp.person_id = p.person_id')
                        ->join('tbl_url AS u', 'p.url_id = u.url_id')
                        ->where('rp.resource_person_id', $resource_person_id)
                        ->get()->row();
    }

    /**
     * @Function            : select_resource_person_information_by_person_id 
     * @Used IN             : @function-'get_information_for_add_course'          user_course_model[@Model]
     * @Description         : get resource persion information using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:53 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $resource_person_info[ARRAY]      
     * @Status              : available      
     * */
    public function select_resource_person_information_by_person_id($person_id) {
        $this->db->select('*')
                ->from('tbl_resource_person AS rp')
                ->join('tbl_person AS p', 'rp.person_id = p.person_id')
                ->join('tbl_url AS u', 'p.url_id = u.url_id')
                ->where('rp.person_id', $person_id);
        return $this->db->get()->row();
    }

    /**
     * @Function            : save_resource_person_info 
     * @Used IN             : @function-'save_course_information'        user_course_model[@Model]
     * @                    : @function-'update_course_information'      user_course_model[@Model]
     * @Description         : save resource person informmation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-07-2016 12:24 PM      
     * @Parameter           : $person_id[INTEGER],$resource_person_id[INTEGER],$course_data[ARRAY]
     * @Return              : $resource_person_id[INTEGER]        
     * @Status              : available      
     * */
    function save_resource_person_info($resource_person_id, $course_data) {
        if ($resource_person_id != '') {
            if ($resource_person_id == 'other') {
                // Save peson information
                $saved_person_id = $this->save_person_info_for_resource_person();
                // Save person infor view Status
                $this->person_model->save_person_info_view_status($saved_person_id);
                // save resource person information
                $saved_resource_person_id = $this->save_resource_person_information($saved_person_id);
                // save resource person ID as organization member
                $this->organization_model->save_organization_resource_person($saved_resource_person_id, $course_data['organization_info']->organization_id);
                return $saved_resource_person_id;
            } else {
                return $this->input->post('resource_person_id', TRUE);
            }
        } else {
            return $course_data['resource_person_info']->resource_person_id;
        }
    }

    /**
     * @Function            : save_resource_person_info 
     * @Used IN             : @function-'save_resource_person_info'       this[@Model]
     * @Description         : save person informmation while person are resorce person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-07-2016 12:28 PM      
     * @Parameter           : $person_id[INTEGER],$resource_person_id[INTEGER],$course_data[ARRAY]
     * @Return              : $person_id[INTEGER]        
     * @Status              : available      
     * */
    function save_person_info_for_resource_person() {
        $person_data = Array();
        $person_data['person_first_name'] = $this->input->post('resource_person_name', TRUE);
        $person_data['person_join_tt'] = date('Y-m-d', strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));
        $person_data['person_role'] = 3;
        $person_data['person_status'] = 1;
        $person_data['url_id'] = $this->url_model->create_resource_person_url($person_data['person_first_name']);
        return $this->utility_model->save_information_in_database('tbl_person', $person_data);
    }

    /**
     * @Function            : save_resource_person_information 
     * @Used IN             : @function-'save_resource_person_info'       this[@Model]
     * @Description         : save resource person informmation while person are resorce person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-07-2016 12:31 PM      
     * @Parameter           : $person_id[INTEGER], $saved_person_id[INTEGER]
     * @Return              : $resource_person_id[INTEGER]        
     * @Status              : available      
     * */
    function save_resource_person_information($saved_person_id) {
        $resource_person_data = array();
        $resource_person_data['person_id'] = $saved_person_id;
        $resource_person_data['resource_person_type'] = 3;
        return $this->utility_model->save_information_in_database('tbl_resource_person', $resource_person_data);
    }

    /**
     * @Function            : select_all_resource_persons 
     * @Used IN             : @function-'add_course'            super_admin_course[@controller]
     * @Description         : select all TT resource person 
     *                        @Update1->convert active query 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM 
     * @Updated Date Time   : 07-09-2016 03:53 PM    
     * @Updated By          : Md Jaherul Islam          
     * @Status              : available      
     * */
    public function select_all_tt_resource_persons() {
        $this->db->select('*')
                ->from('tbl_person AS p')->join('tbl_resource_person AS rp', 'rp.person_id=p.person_id')
                ->where('resource_person_type', 1)->where('person_status', 1);
        return $this->db->get()->result();
    }

    /**
     * @Function            : get_all_resource_person_info_by_organizarion_id 
     * @Used IN             : @function-'get_course_information'       user_course_model[@Model]
     * @Description         : get all resource person by organization_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-08-2016 11:25 AM      
     * @Parameter           : $organizarion_id[INTEGER]
     * @Return              : all_resource_person[Array]        
     * @Status              : available      
     * */
    function get_all_resource_person_info_by_organizarion_id($organizarion_id) {
        $this->db->select('*')
                ->from('tbl_organization_resource_person AS orp')
                ->join('tbl_resource_person AS rp', 'orp.resource_person_id = rp.resource_person_id')
                ->join('tbl_person AS p', 'rp.person_id = p.person_id')
                ->where('orp.organization_id', $organizarion_id);
        return $this->db->get()->result();
    }

    /**
     * @Function            : get_resource_person_id 
     * @Used IN             : @function-'save_add_course_notification'    this[@Model]
     * @                    : @function-'send_email_for_add_course'       mailer_model[@Model]
     * @Description         : get person_id by resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:01 AM   
     * @Parameter           : $course_id[[INTEGER], $course_data[[ARRAY]
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_resource_person_id($resource_person_id) {
        $resource_person_info = $this->select_person_information_by_resource_person_id($resource_person_id);
        return $resource_person_info->person_id;
    }

    /**
     * 
     * @Description         : set data
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:54 PM         
     * */
    private $resource_person_data = [];

    function __set($name, $value) {
        $this->resource_person_data[$name] = $value;
        return $this;
    }

    /**
     * 
     * @Description         : set person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:15 PM         
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * 
     * @Description         : set resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:49 PM         
     * */
    function set_resource_person_id($resource_person_id) {
        $this->resource_person_id = $resource_person_id;
        return $this;
    }

    /**
     * 
     * @Description         : set resource person type
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:16 PM         
     * */
    private $resource_person_type;

    function set_resource_person_type($resource_person_type) {
        $this->resource_person_type = $resource_person_type;
        return $this;
    }

    /**
     * 
     * @Description         : save resource person information
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:16 PM         
     * */
    function save() {
        $data = [];
        $data['person_id'] = $this->person_id;
        $data['resource_person_type'] = $this->resource_person_type;
        $this->db->insert(self::tbl_name, $data);
        return $this;
    }

    /**
     * 
     * @Description         : update resource person information
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:55 PM         
     * */
    function update() {
        $this->db->where(self::primary_key, $this->resource_person_id)
                ->update(self::tbl_name, $this->resource_person_data);
    }

    /**
     * 
     * @Description         : create insert ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:21 PM         
     * */
    private $resource_person_id;

    function create_insert_id() {
        $this->resource_person_id = $this->db->insert_id();
        return $this;
    }

    /**
     * 
     * @Description         : return insert ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:22 PM         
     * */
    function get_id() {
        return $this->resource_person_id;
    }

    /**
     * 
     * @Description         : get resource person information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:21 PM         
     * */
    function get_info_by_person_id() {
        return $this->db->get_where(self::tbl_name, Array('person_id' => $this->person_id))->row();
    }

    /**
     * 
     * @Description         : set resource person information by resource person _id
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 12-12-2016 04:41 PM         
     * */
    private $result;

    function set_info_by_resource_person_id() {
        $this->result = $this->db->get_where(self::tbl_name, Array('resource_person_id' => $this->resource_person_id))->row();
        return $this;
    }

    /**
     * 
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 12-12-2016 04:41 PM         
     * */
    function get_result() {
        return $this->result;
    }

    public function __destruct() {
        if (!empty($this->person_id)) {
            unset($this->person_id);
        }
        if (!empty($this->resource_person_id)) {
            unset($this->resource_person_id);
        }
        if (!empty($this->resource_person_type)) {
            unset($this->resource_person_type);
        }
    }

}
