<?php

/**
 * Description of Random Number Model
 *
 * @author User
 */
class Random_number_model extends CI_Model {

    private $primary_key = 'random_id';
    private $tbl_name = 'tbl_random';

    public function __construct() {
        parent::__construct();
    }

    /*
     * @Function            : save_random_number
     * @Description         : save random number
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 31-10-2016 10:58 AM    
     * @Parameter           : $type, $type_id, $random_number
     * @Return              : Null
     * @Status              : available      
     */

    function save_random_number($type, $type_id, $random_number) {
        $data = Array();
        $data['random_type'] = $type;
        $data['random_type_id'] = $type_id;
        $data['random_number'] = $random_number;
        $this->db->insert('tbl_random', $data);
    }

    /*
     * @Function            : set_value
     * @Description         : set value
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 01-11-2016 06:10 PM    
     * @Parameter           : $type, $type_id, $random_number
     * @Return              : Null
     * @Status              : available      
     */

    private $type;
    private $type_id;
    private $random_number;

    function set_value($type, $type_id, $random_number) {
        $this->type = $type;
        $this->type_id = $type_id;
        $this->random_number = $random_number;
        return $this;
    }

    /*
     * @Function            : set_value
     * @Description         : set value
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 03-11-2016 05:59 PM    
     * @Parameter           : $type, $type_id_array
     * @Return              : Null
     * @Status              : available      
     */

    private $field;
    private $type_id_array;

    function set_type_id_array($field, $type, $arr) {
        $this->type = $type;
        $this->field = $field;
        $this->type_id_array = $arr;
        return $this;
    }

    /**
     * @Description         : set random number data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:52 PM   
     * */
    private $random_id;

    function set_random_id($random_id) {
        $this->random_id = $random_id;
        return $this;
    }

    /**
     * @Description         : set salted random number data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 12:06 PM   
     * */
    private $temp_random_id;

    function set_temp_random_id($random_id) {
        $this->temp_random_id = $random_id;
        return $this;
    }

    /**
     * @Description         : process random information information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 11:58 AM   
     * */
    private $random_info;

    function process() {
        // salt random ID
        $random_id = $this->tt_random_number->set_random_number($this->temp_random_id)->filter_number('TT')->get_filter_number();
        // get random information by random ID
        $this->random_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_random', ['random_type' => 1, 'random_number' => $random_id])->get_single_row_info();
        return $this;
    }

    /**
     * @Description         : get salted random number data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 12:12 PM   
     * */
    function get_temp_random_id() {
        return $this->temp_random_id;
    }

    /**
     * @Description         : get information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-11-2016 12:00 AM   
     * */
    function get_info() {
        return $this->random_info;
    }

    /*
     * @Function            : save_random_number
     * @Description         : save random number
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 01-11-2016 06:10 PM    
     * @Parameter           : $type, $type_id, $random_number
     * @Return              : Null
     * @Status              : available      
     */

    function get_type_id() {
        return $this->db->select('random_type_id')->from('tbl_random')->where('random_type', $this->type)
                        ->where('random_number', $this->random_number)->get()->row()->random_type_id;
    }

    /*
     * @Function            : get_random_number_by_type_id
     * @Description         : get random number by multiple type ID
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 03-11-2016 05:53 PM    
     * @Parameter           : Null
     * @Return              : $multiple random number
     * @Status              : available      
     */

    function get_random_number_by_type_id() {
        return $this->db->select($this->field)->from('tbl_random')->where('random_type', $this->type)
                        ->where_in('random_type_id', $this->type_id_array)->get()->result();
    }

    /**
     * @Description         : delete random table data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:42 PM   
     * */
    function delete() {
        $this->db->where($this->primary_key, $this->random_id)->delete($this->tbl_name);
    }

}
