<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Profile_model extends CI_Model {

    //...............student profile Information ...............
    // $user_id means person_id from Session 
    public function student_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person as p');
        $this->db->where('person_id', $person_id);
        $this->db->join('tbl_url as url', 'url.url_id = p.url_id');
        $query_result = $this->db->get();
        $result = $query_result->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function user_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person as p');
        $this->db->where('person_id', $person_id);
        $this->db->join('tbl_url as url', 'url.url_id = p.url_id');
        $query_result = $this->db->get();
        $result = $query_result->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function user_info_by_profile_url($profile_url) {
        $sql = "SELECT * 
                 FROM 
                    tbl_person as p, 
                   tbl_url as u,
		tbl_person_info_view_status AS pvs 
                 WHERE 
                    u.url = '$profile_url' 
                   AND u.url_id = p.url_id 
                   AND p.person_id = pvs.person_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function update_person_image($user_id, $data) {
        $this->db->set('person_image', $data['person_image']);
        $this->db->set('person_image_thumb', $data['person_image_thumb']);
        $this->db->where('person_id', $user_id);
        $this->db->update('tbl_person');
    }

    public function person_course_info_by_id($person_id) {
        $sql = "SELECT * "
                . "FROM tbl_course  "
                . "WHERE person_id = '$person_id'"
                . "AND (course_status = '4' OR course_status = '1')";
        return $this->db->query($sql)->result();
    }

    public function organization_person_course_info_by_id($resouce_person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_course
                WHERE 
                    resource_person_id = '$resouce_person_id'
                    AND (course_status = '4' OR course_status = '1')";
        return $this->db->query($sql)->result();
    }

    public function get_organization_name($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_resource_person AS r,
                    tbl_organization AS o
                WHERE 
                    p.person_id = '$person_id' 
                    AND r.person_id = p.person_id
                    AND o.organization_id = r.organization_id";

        return $this->db->query($sql)->row();
    }

    public function person_organization_name_by_id($person_id) {
        $sql = "SELECT DISTINCT p.person_id AS organization_id,o.organization_name
                FROM 
                    tbl_student AS s, 
                    tbl_course AS c,
                    tbl_person AS p,
                    tbl_organization AS o
                WHERE 
                    s.person_id = '$person_id'
                AND c.course_id= s.course_id
                AND c.person_id = p.person_id
                AND o.person_id = p.person_id";
        return $this->db->query($sql)->result();
    }

    public function person_organization_course_name_by_person_id($person_id, $organization_id) {
        $sql = "SELECT c.course_id,c.course_name 
                FROM 
                    tbl_student AS s,
                    tbl_course AS c
                WHERE 
                    s.person_id = '$person_id'
                    AND c.course_id = s.course_id
                    AND c.person_id = '$organization_id'
                    AND (c.course_status = '1' OR c.course_status = '4')";
        return $this->db->query($sql)->result();
    }

    public function person_info_by_id($person_id) {
        $sql = "SELECT * FROM tbl_person as p, tbl_url as u WHERE p.person_id= '$person_id' AND p.url_id = u.url_id ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_person_info_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_id= '$person_id' "
                . "     AND p.url_id = u.url_id "
                . "     AND p.person_status = 1";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_active_user_info_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_id= '$person_id' "
                . "     AND p.url_id = u.url_id "
                . "     AND p.person_status = 1"
                . "     AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5) ";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_info_by_url($url) {
        $sql = "SELECT * FROM tbl_person as p, tbl_url as u WHERE u.url= '$url' AND p.url_id = u.url_id ";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($url);
//        exit();
        return $result;
    }

    public function select_user_information_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u"
                . " WHERE "
                . "         p.person_id = '$person_id'"
                . "     AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_user_information_by_email($email) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u"
                . " WHERE "
                . "         p.person_email = '$email'"
                . "     AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function organization_info_by_person_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_organization as o "
                . " WHERE "
                . "         o.person_id = '$person_id'"
                . "     AND o.person_id = p.person_id"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($person_id);
//        exit();        
        return $result;
    }

    public function person_info_by_organization_id($organization_id) {
        $sql = "SELECT *, o.person_id "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_organization as o, "
                . "     tbl_resource_person as rp, tbl_url as u  "
                . " WHERE "
                . "         o.organization_id = '$organization_id'"
                . "     AND o.person_id = p.person_id "
                . "     AND p.person_id = rp.person_id "
                . "     AND u.url_id = p.url_id"
//                . " GROUP BY rp.resource_person_id"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();        
        return $result;
    }

    public function person_info_by_person_id($person_id) {
        //for Organization
        $sql = "SELECT *, o.person_id, o.organization_id, rp.resource_person_id"
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_organization as o, "
                . "     tbl_resource_person as rp, "
                . "     tbl_url as u  "
                . " WHERE "
                . "         o.person_id = '$person_id'"
                . "     AND o.person_id = p.person_id "
                . "     AND p.person_id = rp.person_id"
                . "     AND u.url_id = p.url_id";
        $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        //for Organization Teacher
        if (!$result) {
            $sql = "SELECT *, o.person_id as org_person_id"
                    . " FROM "
                    . "     tbl_person as p, "
                    . "     tbl_organization as o, "
                    . "     tbl_resource_person as rp, "
                    . "     tbl_url as u  "
                    . " WHERE "
                    . "         rp.person_id = '$person_id'"
                    . "     AND rp.person_id = p.person_id"
                    . "     AND u.url_id = p.url_id"
                    . " GROUP BY p.person_id"
            ;
            $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        }
        if (!$result) {
            $sql = "SELECT * "
                    . " FROM "
                    . "     tbl_person as p, "
                    . "     tbl_resource_person as rp, tbl_url as u  "
                    . " WHERE "
                    . "         rp.person_id = '$person_id'"
                    . "     AND rp.person_id = p.person_id"
                    . "     AND u.url_id = p.url_id"
            ;
            $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        }
        if (!$result) {
            $sql = "SELECT * "
                    . " FROM "
                    . "     tbl_person as p, tbl_url as u "
                    . " WHERE "
                    . "         p.person_id = '$person_id' "
                    . "     AND u.url_id = p.url_id"
            ;
            $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        }
        if (!$result) {
            $sql = "SELECT * "
                    . " FROM "
                    . "     tbl_person as p, tbl_url as u "
                    . " WHERE "
                    . "         p.person_id = '$person_id'"
                    . "     AND u.url_id = p.url_id"
            ;
            $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        }
        if (!$result) {
            $sql = "SELECT * "
                    . " FROM "
                    . "     tbl_person as p"
                    . " WHERE "
                    . "         p.person_id = '$person_id'"
            ;
            $result = $this->db->query($sql)->row();
//            $this->cf->debug($result);
        }
//            $this->cf->debug($sql);
        return $result;
    }

    public function select_organization_info_by_id($organization_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_organization as o, "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         o.organization_id = '$organization_id'"
                . "     AND p.person_id = o.person_id "
                . "     AND u.url_id = p.url_id "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function virtual_classroom_feature() {
        $person_id = $this->session->userdata('user_id');
        $person_role = $this->session->userdata('person_role');
        $today = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));

        $data['person_info'] = $this->person_info_by_person_id($person_id);

        //START CHECK FEATURE
        $data['last_feature_detail'] = $result = $this->payment_model->select_last_feature_payment_info_by_id($person_id);
        if ($today > $data['last_feature_detail']->feature_price_expire_date) {
            return '1';
        }

        $feature_price_id = explode(',', $data['person_info']->feature_price_id);
        $data['virtual_classroom_feature_info'] = $this->classroom_model->select_active_feature_by_feature_id($feature_price_id[0]);
        if ($data['virtual_classroom_feature_info']) {
            $feature_price_storage = $data['virtual_classroom_feature_info']->feature_price_storage;
            return $feature_price_storage;
        } else {
            return 1;
        }
    }

    public function education_school_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_collage_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 2);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_graduation_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 3);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function education_post_graduation_info_by_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_person_education_details');
        $this->db->where('person_id', $person_id);
        $this->db->where('attended_for', 4);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function remove_selected_education_info($person_education_details_id) {
        $this->db->where('person_education_details_id', $person_education_details_id);
        $this->db->delete('tbl_person_education_details');
    }

    public function remove_selected_work_info($person_work_details_id) {
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->delete('tbl_person_work_details');
    }

    public function remove_selected_interest_info($field_of_interest_id) {
        $this->db->where('field_of_interest_id', $field_of_interest_id);
        $this->db->delete('tbl_field_of_interest');
    }

    public function update_person_interest_field_Information($perosnID, $interest_item) {

        $this->db->select('field_of_interest_name');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $perosnID);
//        $this->db->where('field_of_interest_name', $interest_item);
        $query_result = $this->db->get();
        $result = $query_result->row();

        $data = array();
        $data['person_id'] = $perosnID;
        $data['field_of_interest_name'] = $interest_item;

        if ($result) {
            $this->db->set('field_of_interest_name', $interest_item);
            $this->db->where('person_id', $perosnID);
            $this->db->update('tbl_field_of_interest');
        } else {

            $this->db->insert('tbl_field_of_interest', $data);
        }
    }

    public function update_person_assessment_skill_Information($perosnID, $assessment_skill) {

        $this->db->select('self_assessment_skills_name');
        $this->db->from('tbl_self_assessment_skills');
        $this->db->where('person_id', $perosnID);
//        $this->db->where('field_of_interest_name', $interest_item);
        $query_result = $this->db->get();
        $result = $query_result->row();

        $data = array();
        $data['person_id'] = $perosnID;
        $data['self_assessment_skills_name'] = $assessment_skill;

        if ($result) {
            $this->db->set('self_assessment_skills_name', $assessment_skill);
            $this->db->where('person_id', $perosnID);
            $this->db->update('tbl_self_assessment_skills');
        } else {

            $this->db->insert('tbl_self_assessment_skills', $data);
        }
    }

    public function update_self_assessment_by_id($person_id) {
        $this->db->where('person_id', $person_id);
        $this->db->delete('tbl_self_assessment_skills');
        $self_assesment_name = $this->input->post('self_assesment_name', TRUE);
        $self_assesment_array = explode(",", $self_assesment_name);
        for ($i = 0; $i < count($self_assesment_array) - 1; $i++) {
            $sql = "INSERT INTO tbl_self_assessment_skills(person_id,self_assessment_skills_name)"
                    . "VALUES('$person_id','$self_assesment_array[$i]')";
            $this->db->query($sql);
        }
    }

    public function update_interest_field_by_id($person_id) {
        $this->db->where('person_id', $person_id);
        $this->db->delete('tbl_field_of_interest');
        $field_of_interest_name = $this->input->post('field_of_interest_name', TRUE);
        $field_of_interest_array = explode(",", $field_of_interest_name);
        for ($i = 0; $i < count($field_of_interest_array) - 1; $i++) {
            $sql = "INSERT INTO tbl_field_of_interest(person_id,field_of_interest_name)"
                    . "VALUES('$person_id','$field_of_interest_array[$i]')";
            $this->db->query($sql);
        }
    }

    public function update_education_info_save($education_institution_name, $educational_description, $education_school_id) {
        $this->db->set('education_institution_name', $education_institution_name);
        $this->db->set('educational_description', $educational_description);
        $this->db->where('person_education_details_id', $education_school_id);
        $this->db->update('tbl_person_education_details');
    }

    /**
     * @Function            : search_company_name_model 
     * @Used IN             : @function 'search_company_name'
     * @Description         : finds company name from database
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 02-01-2017 04:10 PM  
     * @Parameter           : $search_key
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function search_company_name_model($search_key) {
        $result = $this->db->select('company_name')->distinct('company_name')->from('tbl_person_work_details')
                        ->like('company_name', $search_key)->limit(5)->get()->result();
        return $result;
    }

    public function update_work_info_save($person_work_details_id, $company_name, $designation, $company_address, $work_currently_here) {
        $this->db->set('company_name', $company_name);
        $this->db->set('designation', $designation);
        $this->db->set('company_address', $company_address);
        $this->db->set('work_currently_here', $work_currently_here);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->update('tbl_person_work_details');
    }

    public function add_work_information($person_id) {
        $wdata = array();
        $wdata['person_id'] = $person_id;
        $wdata['company_name'] = $this->input->post('company_name', TRUE);
        $wdata['designation'] = $this->input->post('designation', TRUE);
        $wdata['company_address'] = $this->input->post('company_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('job_start_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_currently_here', TRUE);
        if ($wdata['work_currently_here'] == 1) {
            $wdata['job_end_date'] = NULL;
        } else {
            $wdata['job_end_date'] = $this->input->post('job_end_date', TRUE);
        }
        $wdata['job_responsibility_details'] = $this->input->post('job_responsibility_details', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = 1;
//                echo '<pre>';                print_r($wdata);
        $this->db->insert('tbl_person_work_details', $wdata);
    }

//    public function add_new_work_Information($personID, $user_new_company_name, $user_new_designation, $user_new_address, $user_new_responsibility, $user_new_job_start_date, $user_new_job_end_date, $new_work_current_here, $person_new_work_view_status) {
//        $data = array();
//        $data['person_id'] = $personID;
//        $data['company_name'] = $user_new_company_name;
//        $data['designation'] = $user_new_designation;
//        $data['company_address'] = $user_new_address;
//        $data['job_responsibility_details'] = $user_new_responsibility;
//        $data['job_start_date'] = $user_new_job_start_date;
//        $data['job_end_date'] = $user_new_job_end_date;
//        $data['work_currently_here'] = $new_work_current_here;
//        $data['person_work_view_status'] = $person_new_work_view_status;
//        $this->db->insert('tbl_person_work_details', $data);
//
//        $this->db->select('*');
//        $this->db->from('tbl_person_work_details');
//        $this->db->where('person_id', $personID);
//        $query_result = $this->db->get();
//        $result = $query_result->result();
//        return $result;
//    }

    public function update_person_work_experience($personID, $person_work_id, $user_company_name, $user_designation, $user_address, $user_responsibility, $user_job_start_date, $user_job_end_date, $work_current_here, $account_type) {
        $this->db->set('company_name', $user_company_name);
        $this->db->set('designation', $user_designation);
        $this->db->set('company_address', $user_address);
        $this->db->set('job_responsibility_details', $user_responsibility);
        $this->db->set('job_start_date', $user_job_start_date);
        $this->db->set('job_end_date', $user_job_end_date);
        $this->db->set('work_currently_here', $work_current_here);
        $this->db->set('person_work_view_status', $account_type);
        $this->db->where('person_work_details_id', $person_work_id);
        $this->db->update('tbl_person_work_details');
    }

    public function select_user_work_experience_detail_by_id($id) {
        $sql = "SELECT * FROM tbl_person_work_details  WHERE person_work_details_id = '$id'";
        return $this->db->query($sql)->row();
    }
    
    
    /*
     * @Function            : delete_work_experience 
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 11-04-2017 
     * @Status              : Available
     */
    public function delete_work_experience($id){
        $this->db->where('person_work_details_id', $id)
                 ->where('person_id', $this->session->person_id)
                 ->delete('tbl_person_work_details');
    }

    public function select_person_latest_active_work_experience($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_work_details  "
                . " WHERE"
                . "         work_currently_here = 1"
                . "     AND person_work_view_status = 1"
                . "     AND person_id = $person_id";

        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_latest_running_education($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_education_details as ed, tbl_education_institute as ei "
                . " WHERE"
                . "         ed.person_current_education_instute = 1"
//                . "     AND ed.person_education_view_status = 1"
                . "     AND ei.education_institute_id = ed.education_institute_id "
                . "     AND ed.person_id = $person_id "
                . " ORDER BY ed.start_time_period DESC"
        ;

        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function update_work_experience_information($work_detail_id) {
        $wdata = array();
        $wdata['person_id'] = $this->input->post('person_id', TRUE);
        $wdata['company_name'] = $this->input->post('company_name', TRUE);
        $wdata['designation'] = $this->input->post('designation', TRUE);
        $wdata['company_address'] = $this->input->post('company_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('job_start_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_currently_here', TRUE);
        if ($wdata['work_currently_here'] == 1) {
            $wdata['job_end_date'] = NULL;
        } else {
            $wdata['job_end_date'] = $this->input->post('job_end_date', TRUE);
        }
        $wdata['job_responsibility_details'] = $this->input->post('job_responsibility_details', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = 1;
//        echo '<pre>';
//        print_r($wdata);
//        exit();  
        $this->db->where('person_work_details_id', $work_detail_id);
        $this->db->update('tbl_person_work_details', $wdata);
    }

    public function update_selected_education_Information($personID, $userEducationID, $attended_date, $finished_date, $education_description, $attended_for, $education_view_type) {
        $this->db->set('start_time_period', $attended_date);
        $this->db->set('end_time_period', $finished_date);
        $this->db->set('educational_description', $education_description);
        $this->db->set('attended_for', $attended_for);
        $this->db->set('person_education_view_status', $education_view_type);
        $this->db->where('person_id', $personID);
        $this->db->where('person_education_details_id', $userEducationID);
        $this->db->update('tbl_person_education_details');
    }

    public function update_personal_Information($personID, $person_join_tt_date, $personal_contact, $person_country_name, $personal_address, $person_city_name, $person_birthday_date) {
        $this->db->set('person_contact_number', $personal_contact);
        $this->db->set('person_join_tt', $person_join_tt_date);
        $this->db->set('person_birthday', $person_birthday_date);
        $this->db->set('person_country', $person_country_name);
        $this->db->set('person_city', $person_city_name);
        $this->db->set('person_address', $personal_address);

        $this->db->where('person_id', $personID);
        $this->db->update('tbl_person');
    }

    /**
     * Created date     : 2016-01-16
     * Name             : Mahabub-A-Mawla
     * Modified date    : 
     * Modifier name    : 
     * Work             : Update person profile url
     */
    public function update_person_url($url_id, $url) {

        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT * FROM tbl_person as p, tbl_url as u WHERE p.person_id= '$person_id' AND p.url_id = u.url_id ";
        $person_info = $this->db->query($sql)->row();
        $previous_folder = 'content-library/' . $person_info->url;

        if ($person_info->url != $url) {
            $url = preg_replace('/[^A-Za-z0-9 -]/', '', $url);
            $url = str_replace('.', '-', $url);
            $url = str_replace(' ', '-', $url);
            $url = $temp_url = strtolower($url);
            $i = 1;
            do {
                $sql = "SELECT * FROM tbl_url as u WHERE u.url = '$temp_url'";
                $result = $this->db->query($sql)->row();
                if ($result) {
                    $temp_url = $url;
                    $temp_url .=$i;
                    $i++;
                }
            } while ($result);

            $profile_url = $temp_url;
            $this->db->set('url', $profile_url);
            $this->db->where('url_id', $url_id);
            $this->db->update('tbl_url');

            $new_folder = 'content-library/' . $profile_url;
            if (is_dir($previous_folder)) {
                rename("$previous_folder", "$new_folder");
            }

            $sdata['profile_id'] = $profile_url;
            $sdata['view_person_url'] = $profile_url;
            $this->session->set_userdata($sdata);
        }
    }

    // End update_person_url

    public function update_education_status_info($person_education_details_id, $status_id) {
        $this->db->set('person_education_status', $status_id);
        $this->db->where('person_education_details_id', $person_education_details_id);
        $this->db->update('tbl_person_education_details');
    }

    public function update_work_see_status_info($person_work_details_id, $status_id) {
        $this->db->set('work_details_status', $status_id);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->update('tbl_person_work_details');
    }

    public function save_update_interest_field_info($field_of_interest_id, $field_of_interest_name) {
        $this->db->set('field_of_interest_name', $field_of_interest_name);
        $this->db->where('field_of_interest_id', $field_of_interest_id);
        $this->db->update('tbl_field_of_interest');
    }

    /*
     * @author Suddam Hossain
     * function select_user_work_details-> retrive user work information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:05/02/2015
     * return $result(cary work details) to  student_class_room function
     */

    public function select_user_work_details($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_work_details
                WHERE 
                    person_id = '$person_id'
                ORDER by 
                    work_currently_here ASC,
                    job_start_date DESC";
        return $this->db->query($sql)->result();

//        $this->db->select('*');
//        $this->db->from('tbl_person_work_details');
//        $this->db->where('person_id', $person_id);
//        $query_result = $this->db->get();
//        $result = $query_result->result();
////        echo '<pre>';
////        print_r($result);
////        exit();
//        return $result;
    }
    
    public function select_user_limit_work_details($person_id, $limit_offset) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_work_details
                WHERE 
                    person_id = '$person_id'
                ORDER by 
                    work_currently_here ASC,
                    job_start_date DESC LIMIT 10 OFFSET $limit_offset";
        return $this->db->query($sql)->result();
    }

    public function select_wish_list($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_wish_list_management as wl, "
                . "     tbl_course as c, "
                . "     tbl_url as u, "
                . "     (SELECT "
                . "             rp.*, "
                . "             p.person_first_name as resource_person_first_name,"
                . "             p.person_last_name as resource_person_last_name, "
                . "             u.url as resource_person_url "
                . "         FROM "
                . "             tbl_resource_person as rp, "
                . "             tbl_url as u, "
                . "             tbl_person as p "
                . "         WHERE "
                . "                 p.person_id = rp.person_id "
                . "             AND p.url_id = u.url_id "
                . "     ) as rp_info"
                . " WHERE "
                . "         wl.person_id = '$person_id' "
                . "     AND wl.wish_list_management_status = 1 "
                . "     AND wl.course_id = c.course_id "
                . "     AND rp_info.resource_person_id = c.resource_person_id "
                . "     AND c.url_id = u.url_id ";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_course_wish_info($course_id, $person_id) {
        $sql = "SELECT * FROM tbl_wish_list_management as wlm WHERE wlm.course_id = '$course_id' AND wlm.person_id = '$person_id' ";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_video_course_wish_info($video_management_id, $person_id) {
//        $sql = "SELECT * FROM tbl_wish_list_management as wlm WHERE wlm.video_management_id = '$video_management_id' AND wlm.person_id = '$person_id' ";
//        $result = $this->db->query($sql)->row();
////        echo '<pre>';
////        print_r($result);
////        exit();
//        return $result;
    }

    public function delete_select_wishlist($wish_list_management_id) {
//        echo '<pre>';
//        print_r($wish_list_management_id);
//        exit();
        $this->db->set('wish_list_management_status', 3);
        $this->db->where('wish_list_management_id', $wish_list_management_id);
        $this->db->update('tbl_wish_list_management');
    }

    public function update_wishlist($person_id, $course_id) {
        $this->db->set('wish_list_management_status', 2);
        $this->db->where('person_id', $person_id);
        $this->db->where('course_id', $course_id);
        $this->db->update('tbl_wish_list_management');
    }

    public function all_my_billing_details($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_payment as py');
        $this->db->where('person_id', $person_id);
        $this->db->join('tbl_payment_details_information as pd', 'py.payment_id = pd.payment_id');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    /*
     * @author Suddam Hossain
     * function select_user_education_details-> retrive user education information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:02/05/2015
     * return $result(cary education details) to  student_class_room function
     */

    public function select_user_education_details($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS ed,
                    tbl_education_institute AS ei
                WHERE 
                    ed.person_id = '$person_id' 
                    AND 
                        ed.education_institute_id = ei.education_institute_id
                ORDER BY 
                    person_current_education_instute ASC,attended_for DESC, start_time_period DESC";
        return $this->db->query($sql)->result();
    }
    
    public function select_limited_user_education_details($person_id, $limit_offset) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS ed,
                    tbl_education_institute AS ei
                WHERE 
                    ed.person_id = '$person_id' 
                    AND 
                        ed.education_institute_id = ei.education_institute_id
                ORDER BY 
                    person_current_education_instute ASC,attended_for DESC, start_time_period DESC LIMIT 10 OFFSET $limit_offset";
        return $this->db->query($sql)->result();
    }
    
    public function select_user_limited_education_details($person_id, $limit_offset) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS ed,
                    tbl_education_institute AS ei
                WHERE 
                    ed.person_id = '$person_id' 
                    AND 
                        ed.education_institute_id = ei.education_institute_id
                ORDER BY 
                    person_current_education_instute ASC,attended_for DESC, start_time_period DESC LIMIT 10 OFFSET $limit_offset";
        return $this->db->query($sql)->result();
    }

    public function select_group_details($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_groups_by_person_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_group_member_by_person_and_group_id($person_id, $group_id) {

        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $person_id);
        $this->db->where('group_id', $group_id);
        $this->db->where('group_member_status', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

//====================selected_group_post_details=========================================    

    public function selected_group_post_details($group_id) {

        $sql = "SELECT pi.*,p.*,pg.* FROM tbl_person as pi, tbl_post as p,tbl_post_group as pg,tbl_group_member as gm WHERE pg.group_id='$group_id' AND p.post_id=pg.post_id AND p.posted_by = pi.person_id GROUP BY p.post_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_post_details=========================================    

    public function select_post_details() {
        $sql = "SELECT * FROM tbl_post as po, tbl_person as p WHERE po.posted_by = p.person_id AND po.post_type = 1 ORDER BY po.post_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_my_link_post start model panel=========================================

    public function select_my_link_post_details($person_id) {
        $sql = "SELECT * FROM tbl_post as po,tbl_person_link as pl,tbl_person as p WHERE po.post_type = 3 AND (po.posted_by = pl.person_id OR po.posted_by = pl.requested_person_id) AND (pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id')AND po.posted_by = p.person_id  ORDER BY po.post_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//====================select_my_link_post end model panel=========================================

    public function select_post_comment_info($post_id) {
        $sql = "SELECT c.*, pi.* FROM tbl_comment as c, tbl_post as p, tbl_person as pi WHERE c.post_id = $post_id AND c.post_id = p.post_id AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->result();
        return $result;
    }

    public function select_post_comment_info_by_comment_id($post_comment_id) {
        $sql = "SELECT c.*, pi.* FROM tbl_comment as c, tbl_post as p, tbl_person as pi WHERE c.post_comment_id = '$post_comment_id' AND c.post_id = p.post_id AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function select_reply_comment_info_by_id($comment_replay_id) {
        $sql = "SELECT cr.*,pe.* FROM tbl_comment_replay as cr, tbl_post as p,tbl_comment as c, tbl_person as pe WHERE cr.comment_replay_id= '$comment_replay_id' AND cr.comment_replay_by=pe.person_id AND cr.post_id = p.post_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();

        return $result;
    }

    public function select_post_comment_replay($post_comment_id) {

        $sql = "SELECT cr.*,pe.* FROM tbl_comment_replay as cr, tbl_post as p,tbl_comment as c, tbl_person as pe "
                . "WHERE cr.post_comment_id= '$post_comment_id' AND cr.post_comment_id=c.post_comment_id AND cr.post_id = p.post_id AND cr.comment_replay_by = pe.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->result();
        return $result;
    }

    public function post_save($data) {
        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();
        return $post_id;
    }

    public function selected_group_post_save($mdata) {
        $this->db->insert('tbl_post_group', $mdata);
    }

    public function member_comment_save($data) {
        $this->db->insert('tbl_comment', $data);
        $comment_id = $this->db->insert_id();
        return $comment_id;
    }

    public function select_new_comment_info($comment_id) {
        $sql = "SELECT c.* FROM tbl_comment as c, tbl_person as pi WHERE c.post_comment_id ='$comment_id' AND c.post_comment_by = pi.person_id ";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();
        return $result;
    }

    public function comment_replay_save($data) {
        $this->db->insert('tbl_comment_replay', $data);
        $replay_id = $this->db->insert_id();
        return $replay_id;
    }

    public function select_group($text, $person_id) {
        $sql = "SELECT * FROM tbl_group as g,tbl_group_member as gm WHERE gm.person_id = '$person_id' AND  gm.group_id = g.group_id AND g.group_name LIKE '%$text%' AND g.group_status = 1 ";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function search_person_group_availability($person_id) {
        $sql = "SELECT * FROM tbl_group as g,tbl_group_member as gm WHERE gm.person_id = '$person_id' AND  gm.group_id = g.group_id AND g.group_status = 1 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//    public function select_user($text) {
//        $sql = "SELECT * FROM tbl_person as pi WHERE pi.person_first_name LIKE '$text%'";
//        $result = $this->db->query($sql)->result();
//        return $result;
//    }
    // save user Educational Informaion=======================================================

    public function save_education_information($person_id) {
        $data = array();
        $edata = array();
        $data['person_id'] = $person_id;
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['education_institute_id'] = $this->input->post('education_institute_id', TRUE);
        if ($data['education_institute_id'] == 'other') {
            $edata['education_institute_country'] = $this->input->post('education_institute_country', TRUE);
            $edata['education_institute_city'] = $this->input->post('education_institute_city', TRUE);
            $edata['education_institute_name'] = $this->input->post('education_institute_name', TRUE);
            $edata['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $edata['education_institute_status'] = 1;
            $this->db->insert('tbl_education_institute', $edata);
            $data['education_institute_id'] = $this->db->insert_id();
//            $data['education_institute_id'] = 5;
        }
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        $data['person_current_education_instute'] = $this->input->post('person_current_education_instute', TRUE);
        if ($data['person_current_education_instute'] == 2) {
            $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        } else {
            $data['end_time_period'] = NULL;
        }
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = 1;
        $this->db->insert('tbl_person_education_details', $data);
    }

    function update_education_information($education_detail_id) {
        $data = array();
        $edata = array();
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['education_institute_id'] = $this->input->post('education_institute_id', TRUE);
        if ($data['education_institute_id'] == 'other') {
            $edata['education_institute_country'] = $this->input->post('education_institute_country', TRUE);
            $edata['education_institute_city'] = $this->input->post('education_institute_city', TRUE);
            $edata['education_institute_name'] = $this->input->post('education_institute_name', TRUE);
            $edata['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $edata['education_institute_status'] = 1;
            $this->db->insert('tbl_education_institute', $edata);
            $data['education_institute_id'] = $this->db->insert_id();
//            $data['education_institute_id'] = 5;
        }
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        $data['person_current_education_instute'] = $this->input->post('person_current_education_instute', TRUE);
        if ($data['person_current_education_instute'] == 2) {
            $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        } else {
            $data['end_time_period'] = NULL;
        }
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = 1;

        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details', $data);
    }

    public function select_user_education_detail_by_id($education_detail_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_education_details AS ped,
                    tbl_education_institute AS ei
                WHERE 
                    ped.person_education_details_id = '$education_detail_id'
                AND ei.education_institute_id = ped.education_institute_id";
        return $this->db->query($sql)->row();
    }

    // save user Work Details Informaion=======================================================

    public function save_work_details_information($data) {
        $this->db->insert('tbl_person_work_details', $data);
    }

    public function save_interest_field($data) {
        $this->db->insert('tbl_field_of_interest', $data);
    }

    // select user Interest Field Informaion=======================================================
    public function select_user_interest_field($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $person_id);
        $this->db->limit(5);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function Selected_work_Information($personID, $workID) {
        $this->db->select('*');
        $this->db->from('tbl_person_work_details');
        $this->db->where('person_work_details_id', $workID);
        $query_result = $this->db->get();
        $result = $query_result->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function Selected_education_Information($EducationID) {
        $this->db->select('*');
        $this->db->from('tbl_person_education_details as pe');
        $this->db->where('person_education_details_id', $EducationID);
        $this->db->join('tbl_education_institute as ei', 'pe.education_institute_id = ei.education_institute_id');
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_person_interest_field($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_person_assessment_skill_info($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_self_assessment_skills');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_user_interest_field_all($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    // Start person Language 

    public function save_language($person_id) {
        $l_data['person_id'] = $person_id;
        $l_data['person_language'] = $this->input->post('person_language', TRUE);
        $l_data['person_language_proficiency'] = $this->input->post('person_language_proficiency', TRUE);
        $l_data['person_language_status'] = 1;
        $this->db->insert('tbl_person_language', $l_data);
    }

    public function select_person_language_without_language_id($person_id, $person_language_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_language
                WHERE 
                    person_id = '$person_id' AND person_language_id != '$person_language_id' ";
        return $this->db->query($sql)->result();
    }
    public function select_person_language_by_language_id($person_id, $person_language_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_language
                WHERE 
                    person_id = '$person_id' AND person_language_id != '$person_language_id' LIMIT 10 OFFSET 0";
        return $this->db->query($sql)->result();
    }

    public function get_selected_language($person_language_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_language
                WHERE 
                    person_language_id = '$person_language_id'";
        return $this->db->query($sql)->row();
    }

    public function update_language_by_language_id($language_id) {
        $data['person_language'] = $this->input->post('person_language');
        $data['person_language_proficiency'] = $this->input->post('person_language_proficiency');
        $this->db->where('person_language_id', $language_id);
        $this->db->update('tbl_person_language', $data);
    }

    public function delete_language_by_id($person_language_id) {
        $this->db->where('person_language_id', $person_language_id);
        $this->db->delete('tbl_person_language');
    }

    // End person Language
    //update user Name ========================= 

    public function update_user_name($first_name, $last_name, $perosnID) {
        if ($last_name == 'null') {
            $this->db->set('person_first_name', $first_name);
            $this->db->set('person_last_name', '');
            $this->db->where('person_id', $perosnID);
            $this->db->update('tbl_person');
        } else {
            $this->db->set('person_first_name', $first_name);
            $this->db->set('person_last_name', $last_name);
            $this->db->where('person_id', $perosnID);
            $this->db->update('tbl_person');
        }
    }

    public function update_company_name($CompanyName, $perosnID) {
        $this->db->set('company_name', $CompanyName);
        $this->db->where('person_id', $perosnID);
        $this->db->update('tbl_person_work_details');
    }

    public function update_Higher_EducationName($Higher_EducationName, $personHigher_Education_Institute_id, $perosnID) {
        $this->db->set('education_institute_name', $Higher_EducationName);
        $this->db->where('education_institute_id', $personHigher_Education_Institute_id);
        $this->db->update('tbl_education_institute');
    }

    public function update_person_Designation_Name($person_designation, $person_work_details_id, $perosnID) {
        $this->db->set('designation', $person_designation);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->where('person_id', $perosnID);
        $this->db->update('tbl_person_work_details');
    }

    public function update_person_Company_title($person_Company_title, $person_work_details_id, $perosnID) {
        $this->db->set('company_name', $person_Company_title);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->where('person_id', $perosnID);
        $this->db->update('tbl_person_work_details');
    }

    public function update_person_job_responsibility($job_responsibility, $person_work_details_id, $perosnID) {
        $this->db->set('job_responsibility_details', $job_responsibility);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->where('person_id', $perosnID);
        $this->db->update('tbl_person_work_details');
    }

    public function update_person_Company_Address($Person_Company_Address, $person_work_details_id, $perosnID) {
        $this->db->set('company_address', $PersonCompanyAddress);
        $this->db->where('person_work_details_id', $person_work_details_id);
        $this->db->where('person_id', $perosnID);
        $this->db->update('tbl_person_work_details');
    }

    public function update_person_name_save($person_first_name, $person_last_name, $person_id) {
        $this->db->set('person_first_name', $person_first_name);
        $this->db->set('person_last_name', $person_last_name);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_email_save($person_email, $person_id) {
        $this->db->set('person_email', $person_email);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_contact_save($person_contact_number, $person_id) {
        $this->db->set('person_contact_number', $person_contact_number);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_address_save($person_address, $person_id) {
        $this->db->set('person_address', $person_address);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_person_zip_save($person_zip, $person_id) {
        $this->db->set('person_zip', $person_zip);
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function update_personal_information_by_id($person_id) {
        $country_code = $this->input->post('person_country_code', TRUE);
        $contact_number = $this->input->post('person_contact_number', TRUE);
        $data['person_email'] = $this->input->post('person_email', TRUE);
        $data['person_contact_number'] = $country_code . ' ' . $contact_number;
        $data['person_country'] = $this->input->post('person_country', TRUE);
        $data['person_city'] = $this->input->post('person_city', TRUE);
        $data['person_address'] = $this->input->post('person_address', TRUE);
        $data['person_gender'] = $this->input->post('person_gender', TRUE);
        $data['person_birthday'] = $this->input->post('person_birthday', TRUE);

        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person', $data);
    }

    /*
     * @author Suddam Hossain
     * function select_my_friends_details-> retrive my friends information Details form database 
     * parameter $person_id
     * $person_id use for individul Information Select form table
     * date:03/05/2015
     * return $result(cary friends details) 
     */

    public function select_my_friends_details_part1($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person_link');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function selected_friends_details_part1($requested_person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $requested_person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_my_friends_details_part2($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person_link');
        $this->db->where('requested_person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function selected_friends_details_part2($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function check_group($requested_person_id, $group_id) {
        $this->db->select('*');
        $this->db->from('tbl_group_member');
        $this->db->where('person_id', $requested_person_id);
        $this->db->where('group_id', $group_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function quiz_info_by_person_id($person_id) {

        $this->db->select('*');
        $this->db->from('tbl_quiz');
        $this->db->where('quiz_created_by', $person_id);
        $this->db->where('quiz_status', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function save_grade_info($data) {
        $this->db->insert('tbl_grade', $data);
    }

    public function select_all_grade_info() {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT gr.*,q.quiz_name FROM tbl_grade as gr,tbl_quiz as q "
                . "WHERE gr.resource_person_id = '$person_id'  AND gr.quiz_id=q.quiz_id ORDER BY q.quiz_name";
        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function select_all_certificate_info() {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT c.*,q.quiz_name FROM tbl_certificate as c,tbl_quiz as q "
                . "WHERE c.resource_person_id = '$person_id'  AND c.quiz_id=q.quiz_id ORDER BY q.quiz_name";
        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function selected_grade_active($grade_id) {
        $this->db->set('grade_status', 1);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function selected_grade_inactive($grade_id) {
        $this->db->set('grade_status', 0);
        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade');
    }

    public function select_all_grade_info_by_id($grade_id) {

        $this->db->select('*');
        $this->db->from('tbl_grade');
        $this->db->where('grade_id', $grade_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function update_grade_info($data, $grade_id) {

        $this->db->where('grade_id', $grade_id);
        $this->db->update('tbl_grade', $data);
    }

    public function save_certificate_info($data) {
        $this->db->insert('tbl_certificate', $data);
    }

    public function selected_certificate_active($certificate_id) {

        $this->db->set('certificate_share_status', 1);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function selected_certificate_inactive($certificate_id) {

        $this->db->set('certificate_share_status', 0);
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');
    }

    public function certificate_details($certificate_id) {

        $this->db->select('*');
        $this->db->from('tbl_certificate');
        $this->db->where('certificate_id', $certificate_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function delete_image_by_id($certificate_id) {

        $sql = "SELECT * FROM tbl_certificate WHERE certificate_id='$certificate_id'";
        $query_result = $this->db->query($sql);
        $result = $query_result->row();


        unlink("$result->certificate_image");


        $this->db->set('certificate_image', '');
        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate');

//        return $result;
    }

    public function update_certificate_info($data, $certificate_id) {

        $this->db->where('certificate_id', $certificate_id);
        $this->db->update('tbl_certificate', $data);
        $result = $this->db->insert_id();
        return $result;
    }

    public function select_save_comment($insert_id) {

        $this->db->select('*');
        $this->db->from('tbl_comment');
        $this->db->where('insert_id', $insert_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
    }

    public function update_due_payment($payment_details_information_id, $data) {

        $this->db->where('payment_details_information_id', $payment_details_information_id);
        $this->db->update('tbl_payment_details_information', $data);
    }

    /*
     * Person Profile information for Other
     */

    public function person_public_Education_details($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_education_details as ped,"
                . "     tbl_education_institute as ei "
                . " WHERE "
                . "         ped.person_id = '$person_id' "
                . "     AND ped.person_education_status = 1 "
                . "     AND ped.person_education_view_status = 1 "
                . "     AND ped.education_institute_id = ei.education_institute_id "
                . "     ";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function get_perrson_id($education_details_id) {
        $sql = "Select person_id FROM tbl_person_education_details WHERE person_education_details_id = '$education_details_id'";
        return $this->db->query($sql)->row();
    }

    public function person_public_work_details($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_work_details as pwd "
                . " WHERE "
                . "         pwd.person_id = '$person_id' "
                . "     AND pwd.work_details_status = 1 "
                . "     AND pwd.person_work_view_status = 1 ";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_attended_public_quiz($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group_member as gm, "
                . "     tbl_group as g,"
                . "     tbl_member_quiz as mq, "
                . "     tbl_quiz as q"
                . " WHERE "
                . "         gm.person_id = '$person_id' "
                . "     AND gm.group_member_status = 1"
                . "     AND g.group_id =gm.group_id "
                . "     AND g.group_permission = 1"
                . "     AND g.group_status = 1"
                . "     AND mq.group_member_id = gm.group_member_id"
                . "     AND q.quiz_id = mq.quiz_id "
                . "     AND q.quiz_status = 1 "
                . "     AND q.quiz_pulication_status = 1 "
                . "     GROUP BY q.quiz_id";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_quiz_result($person_id, $quiz_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_quiz_result as qr, "
                . "     tbl_quiz as q "
                . " WHERE "
                . "         q.quiz_id = '$quiz_id' "
                . "     AND qr.person_id = '$person_id' "
                . "     AND qr.quiz_result_permission = 1 "
                . "     AND qr.quiz_result_status = 1";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_connected_public_group($person_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_group_member as gm, "
                . "     tbl_group as g,"
                . "     tbl_member_quiz as mq, "
                . "     tbl_url as u"
                . " WHERE "
                . "         gm.person_id = '$person_id' "
                . "     AND gm.group_member_status = 1"
                . "     AND g.group_id =gm.group_id "
                . "     AND g.group_permission = 1"
                . "     AND g.group_status = 1"
                . "     AND mq.group_member_id = gm.group_member_id"
                . "     AND u.url_id = g.url_id"
                . "     GROUP BY g.group_id";
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_courses($person_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_student as s, "
                . "     tbl_person as pc, "
                . "     tbl_course as c, "
                . "     tbl_course_category as cc, "
                . "     tbl_url as u"
                . " WHERE "
                . "         s.person_id = '$person_id'"
                . "     AND s.course_id = c.course_id"
                . "     AND c.course_status = 1 "
                . "     AND course_access_level = 1 "
                . "     AND u.url_id = c.url_id"
                . "     GROUP BY c.course_id"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_field_of_interest($person_id) {

        $sql = "SELECT foi.* "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_field_of_interest as foi"
                . " WHERE "
                . "         p.person_id = '$person_id' "
                . "     AND foi.person_id = p.person_id "
                . "     AND foi.field_of_interest_access_level = 1 "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_to_person_link($person_id2) {
        $person_id1 = $this->session->userdata('user_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl "
                . " WHERE "
                . "         ((pl.person_id = '$person_id1' AND pl.requested_person_id = '$person_id2')"
                . "     OR (pl.person_id = '$person_id2' AND pl.requested_person_id = '$person_id1'))"
                . "     AND (pl.add_link_request_status = 1)"
        ;
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function save_tt_link_information($data) {
        $this->db->insert('tbl_person_link', $data);
        return $this->db->insert_id();
    }

    public function select_person_link() {
        $person_id = $this->session->userdata('person_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl,"
                . "     tbl_person as p "
                . " WHERE "
                . "         (pl.person_id = '$person_id' "
                . "     OR pl.requested_person_id = '$person_id')"
                . "     AND pl.person_id = p.person_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_active_link() {
        $person_id = $this->session->userdata('person_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl,"
                . "     tbl_person as p "
                . " WHERE "
                . "         (pl.person_id = '$person_id' "
                . "     OR pl.requested_person_id = '$person_id')"
                . "     AND pl.person_id = p.person_id "
                . "     AND pl.add_link_request_status = 1 "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_link_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl,"
                . "     tbl_person as p "
                . " WHERE "
                . "         (pl.person_id = '$person_id' "
                . "     OR pl.requested_person_id = '$person_id')"
                . "     AND pl.person_id = p.person_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_link_with_pagination($start, $limit) {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl"
                . " WHERE "
                . "         (pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id')"
                . "     AND (pl.add_link_request_status = 1 OR pl.add_link_request_status = 3)"
                . " GROUP BY pl.person_link_id"
        ;
//        if ($limit != null) {
//            $sql .= " LIMIT $start, $limit ";
//        }
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_accepted_link($person_id) {
//        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl"
                . " WHERE "
                . "         (pl.person_id = '$person_id' "
                . "     OR pl.requested_person_id = '$person_id')"
                . "     AND (pl.add_link_request_status = 1)"
                . " GROUP BY pl.person_link_id"
        ;
//        if ($limit != null) {
//            $sql .= " LIMIT $start, $limit ";
//        }
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function person_link_info_by_link_person_id($link_person_id) {
        $person_id = $this->session->userdata('user_id');
//        echo $link_person_id;exit();
        $sql = "SELECT pl.person_link_id, pl.person_id as pl_person_id, pl.requested_person_id, pl.add_link_request_status, p.*, u.* "
                . " FROM tbl_person_link as pl, tbl_person as p, tbl_url as u "
                . " WHERE "
                . "         ((pl.person_id = '$person_id' AND pl.requested_person_id = '$link_person_id') "
                . "     OR   (pl.person_id = '$link_person_id' AND pl.requested_person_id = '$person_id'))"
                . "     AND p.person_id = '$link_person_id' AND p.url_id = u.url_id";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_user_in_resource_person_link($user_id, $person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person_link as pl "
                . " WHERE "
                . "         ( pl.person_id = '$user_id'               AND pl.requested_person_id = '$person_id'     AND pl.add_link_request_status = 1 ) "
                . "     OR  ( pl.requested_person_id = '$user_id'     AND pl.person_id = '$person_id'                AND pl.add_link_request_status = 1 ) ";

        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($user_id);
//        print_r($result);
//        print_r($sql);
//        exit();
        return $result;
    }

    public function person_link_info_by_requested_person_id($link_person_id) {
        $person_id = $this->session->userdata('user_id');
//        echo $link_person_id;exit();
        $sql = "SELECT * "
                . " FROM tbl_person_link as pl, tbl_person as p, tbl_url as u "
                . " WHERE "
                . "         ((pl.person_id = '$person_id' AND pl.requested_person_id = '$link_person_id') "
                . "           OR (pl.person_id = '$link_person_id' AND pl.requested_person_id = '$person_id')"
                . "         )"
                . "     AND p.person_id = '$link_person_id' AND p.url_id = u.url_id";

        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function reconnect_person_link($person_link_id, $person_id, $requested_person_id) {
//        $person_id = $this->session->userdata('user_id');
        $sql = "UPDATE tbl_person_link "
                . " SET "
                . "     add_link_request_status = 3, "
                . "     person_id = $person_id, "
                . "     requested_person_id = $requested_person_id "
                . " WHERE "
                . "         person_link_id = '$person_link_id' "
                . "     AND ((person_id = '$person_id' AND requested_person_id = '$requested_person_id') "
                . "         OR (person_id = '$requested_person_id' AND requested_person_id = '$person_id'))";

        $this->db->query($sql);
        return $person_link_id;
    }

    public function accept_person_link($person_link_id, $link_person_id) {
        $person_id = $this->session->userdata('user_id');
        $sql = "UPDATE tbl_person_link "
                . " SET add_link_request_status = 1 "
                . " WHERE "
                . "         person_link_id = '$person_link_id' "
                . "     AND ((person_id = '$person_id' AND requested_person_id = '$link_person_id') "
                . "         OR (person_id = '$link_person_id' AND requested_person_id = '$person_id'))";
//        echo '<pre>';
//        print_r($sql);
//        exit();
        $this->db->query($sql);
    }

    public function cancel_person_link($person_link_id, $link_person_id) {
        $person_id = $this->session->userdata('user_id');
        $sql = "UPDATE tbl_person_link "
                . " SET add_link_request_status = 0 "
                . " WHERE "
                . "         person_link_id = '$person_link_id' "
                . "     AND ((person_id = '$person_id' AND requested_person_id = '$link_person_id') "
                . "         OR (person_id = '$link_person_id' AND requested_person_id = '$person_id'))";
//        echo '<pre>';
//        print_r($sql);
//        exit();
        $this->db->query($sql);
    }

    public function block_person_link($person_link_id, $link_person_id, $requested_person_id) {
        $person_id = $this->session->userdata('user_id');
        $sql = "UPDATE tbl_person_link "
                . " SET add_link_request_status = 5, "
                . "     person_id = '$link_person_id', "
                . "     requested_person_id = '$requested_person_id' "
                . " WHERE "
                . "         person_link_id = '$person_link_id' ";
//        echo '<pre>';
//        print_r($sql);
//        exit();
        $this->db->query($sql);
    }

    public function insert_block_person_link($person_link_id, $link_person_id, $requested_person_id) {
        $person_id = $this->session->userdata('user_id');

        $this->db->insert('tbl_person_link', $data);
        $this->db->query($sql);
    }

    public function remove_person_link($person_link_id, $link_person_id) {
        $person_id = $this->session->userdata('user_id');
        $sql = "UPDATE tbl_person_link "
                . " SET add_link_request_status = 2 "
                . " WHERE "
                . "         person_link_id = '$person_link_id' "
                . "     AND ((person_id = '$person_id' AND requested_person_id = '$link_person_id') "
                . "         OR (person_id = '$link_person_id' AND requested_person_id = '$person_id'))";
        $this->db->query($sql);
    }

    public function select_suggested_link() {
        $person_id = $this->session->userdata('person_id');
        $sql = "SELECT "
                . "     DISTINCT pl.person_link_id, "
                . "     pl.person_id , "
                . "     pl.requested_person_id, "
                . "     linked_person.link_id1, "
                . "     linked_person.link_id2 "
                . " FROM "
                . "     tbl_person_link as pl, "
                . "     ( SELECT "
                . "             pl.person_id as link_id1 , "
                . "             pl.requested_person_id as link_id2  "
                . "       FROM "
                . "             tbl_person_link as pl  "
                . "       WHERE "
                . "             pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id' AND pl.add_link_request_status = 1) as linked_person "
                . " WHERE "
                . "     ( linked_person.link_id1 = pl.person_id "
                . "     OR linked_person.link_id1 = pl.requested_person_id "
                . "     OR linked_person.link_id2 = pl.person_id "
                . "     OR linked_person.link_id2 = pl.requested_person_id) "
                . "     AND ( pl.person_id != '$person_id'   AND  pl.requested_person_id != '$person_id' )"
                . "     AND pl.add_link_request_status = 1 "
                . " GROUP BY pl.person_link_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_link_person_info($person_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_id = '$person_id' "
                . "     AND p.person_status = 1 "
                . "     AND p.url_id = u.url_id ";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function update_person_time_zine($person_id) {
        $this->db->set('person_time_zone', $this->input->post('person_time_zone', true))
                ->where('person_id', $person_id)
                ->update('tbl_person');
    }

    public function check_url_existance($url) {
        $sql = "SELECT * FROM tbl_url
                WHERE 
                url = '$url'";
        return $this->db->query($sql)->row();
    }

    public function check_email_existance($person_id, $url) {
        $sql = "SELECT *
                FROM tbl_person
                WHERE 
                    person_email = '$url' AND person_id != '$person_id'";
        return $this->db->query($sql)->row();
    }

    public function person_available_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->person_available_disk_space($each);
        }
        return $size;
    }

    //---------------------------------- Start Front End Deshboard Post----------------------------- 

    function select_all_post_person_id($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u 
                WHERE 
                    p.posted_by = '$person_id'
                    AND p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    ORDER BY post_date_time DESC";
        return $this->db->query($sql)->result();
    }

    function save_note($person_id) {
        $time_zone = $this->input->post('time_zone', TRUE);
        $data['post_details'] = $this->input->post('post_details', TRUE);
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', (time() - $time_zone));
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = '';
        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id,group_id)"
                        . "VALUES('$post_id','$selected_group_array[$i]')";
                $this->db->query($sql);
            }
        }
    }

    function get_single_note($post_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u 
                WHERE 
                    post_id = '$post_id'
                    AND p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    function save_alert($person_id) {
        $time_zone = $this->input->post('time_zone', TRUE);
        $data['post_details'] = $this->input->post('post_details', TRUE);
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', (time() - $time_zone));
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = '';
        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id,group_id)"
                        . "VALUES('$post_id','$selected_group_array[$i]')";
                $this->db->query($sql);
            }
        }
    }

    function save_assignment_file($person_id, $url) {
        $time_zone = $this->input->post('time_zone', TRUE);
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', (time() - $time_zone));
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = $_FILES["assignment_file"]["name"];
//
        $fileName = $_FILES["assignment_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["assignment_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileType = $_FILES["assignment_file"]["type"]; // The type of file it is
        $fileSize = $_FILES["assignment_file"]["size"]; // File size in bytes
        $fileErrorMsg = $_FILES["assignment_file"]["error"]; // 0 for false... and 1 for true
        $new_file_name = $url . '-' . date('h-i-s-a-m-d-Y', (time() - $time_zone));

        if (!$fileTmpLoc) { // if file not chosen
            echo "ERROR: Please browse for a file before clicking the upload button.";
//            exit();
        } else {
            if ($fileSize < 50485760) {
                $folder = 'content-library/' . $url . '/assignment-file/';
                $target_file = $folder . $fileName;
                if (move_uploaded_file($fileTmpLoc, $target_file)) {
                    $file_explode = explode('.', $fileName);
                    $file_extention = $file_explode[count($file_explode) - 1];

                    rename("$target_file", "$folder$new_file_name.$file_extention");
                    $data['post_details'] = "$folder$new_file_name.$file_extention";
                    $this->db->insert('tbl_post', $data);

                    $post_id = $this->db->insert_id();

                    if ($data['post_publication_status'] == 4) {
                        $selected_group = $this->input->post('selected_group', TRUE);
                        $selected_group_array = explode(",", $selected_group);
                        for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                            $sql = "INSERT INTO tbl_post_group(post_id,group_id)"
                                    . "VALUES('$post_id','$selected_group_array[$i]')";
                            $this->db->query($sql);
                        }
                    }
                }
            } else {
                echo 'File size must less then 10 Mb';
            }
        }
    }

    function save_image_or_video_file($person_id, $url) {
        $time_zone = $this->input->post('time_zone', TRUE);
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', (time() - $time_zone));
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = '';
//
        $fileName = $_FILES["image_video_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["image_video_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileType = $_FILES["image_video_file"]["type"]; // The type of file it is
        $fileSize = $_FILES["image_video_file"]["size"]; // File size in bytes
        $fileErrorMsg = $_FILES["image_video_file"]["error"]; // 0 for false... and 1 for true
        $new_file_name = $url . '-' . date('h-i-s-a-m-d-Y', (time() - $time_zone));

        if (!$fileTmpLoc) { // if file not chosen
            echo "ERROR: Please browse for a file before clicking the upload button.";
//            exit();
        } else {
            switch ($data['post_type']) {
                case 4:
                    if ($fileSize < 5097152) {
                        $folder = 'content-library/' . $url . '/my-image/';
                        $target_file = $folder . $fileName;
                        if (move_uploaded_file($fileTmpLoc, $target_file)) {
                            $file_explode = explode('.', $fileName);
                            $file_extention = $file_explode[count($file_explode) - 1];

                            rename("$target_file", "$folder$new_file_name.$file_extention");
                            $data['post_details'] = "$folder$new_file_name.$file_extention";
                            $this->db->insert('tbl_post', $data);

                            $post_id = $this->db->insert_id();

                            if ($data['post_publication_status'] == 4) {
                                $selected_group = $this->input->post('selected_group', TRUE);
                                $selected_group_array = explode(",", $selected_group);
                                for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                                    $sql = "INSERT INTO tbl_post_group(post_id,group_id)"
                                            . "VALUES('$post_id','$selected_group_array[$i]')";
                                    $this->db->query($sql);
                                }
                            }
                        }
                    } else {
                        echo 'Image size must less then 2 Mb';
                    }
                    break;
                case 5:
                    if ($fileSize < 50485760) {
                        $folder = 'content-library/' . $url . '/my-video/';
                        $target_file = "$folder$new_file_name";
                        if (move_uploaded_file($fileTmpLoc, $target_file)) {
                            $file_explode = explode('.', $fileName);
                            $file_extention = $file_explode[count($file_explode) - 1];

                            $directory_path = "$folder$new_file_name.$file_extention";
                            $destination_path = "$folder$new_file_name.mp4";
                            exec("ffmpeg -i " . $directory_path . " -f mp4 " . $destination_path . " ");
//                            unlink("$directory_path");

                            rename("$target_file", "$destination_path");
                            $data['post_details'] = "$destination_path";
                            $this->db->insert('tbl_post', $data);

                            $post_id = $this->db->insert_id();

                            if ($data['post_publication_status'] == 4) {
                                $selected_group = $this->input->post('selected_group', TRUE);
                                $selected_group_array = explode(",", $selected_group);
                                for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                                    $sql = "INSERT INTO tbl_post_group(post_id,group_id)"
                                            . "VALUES('$post_id','$selected_group_array[$i]')";
                                    $this->db->query($sql);
                                }
                            }
                        }
                    } else {
                        echo 'Image size must less then 2 Mb';
                    }
                    break;
            }
        }
    }

    function get_profile_url($person_id) {
        $sql = "SELECT url 
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    u.url_id = p.url_id
                AND p.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    public function select_person_list_by_education($person_all_education) {
        $person_id = $this->session->userdata('user_id');
        $today = date('Y-m-d', (time()));
        $all_result = array();
        foreach ($person_all_education as $v_education) {
            $sql = "SELECT DISTINCT ped.person_id "
                    . " FROM "
                    . "     tbl_person_education_details as ped, tbl_person as p, "
                    . "     (SELECT * FROM tbl_education_institute as ei WHERE ei.education_institute_name = '$v_education->education_institute_name') as common_institute"
                    . " WHERE ";

            $sql .= "( common_institute.education_institute_id = ped.education_institute_id ";
            if ($v_education->start_time_period) {
                $sql .= "     AND ("
                        . "             '$v_education->start_time_period'  BETWEEN ped.start_time_period AND ped.end_time_period "
                        . "         OR  '$v_education->end_time_period'  BETWEEN ped.start_time_period AND ped.end_time_period"
                        . "     ) ";
            } else {
                $sql .= "     AND ("
                        . "             '$v_education->start_time_period'  BETWEEN ped.start_time_period AND ped.end_time_period "
                        . "         OR  '$today'  BETWEEN ped.start_time_period AND ped.end_time_period"
                        . "     ) ";
            }
            $sql .= " )  AND not ped.person_id IN ($person_id) AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5)";
            $result = $this->db->query($sql)->result();
            $all_result = array_merge($all_result, $result);

            $sql = "SELECT DISTINCT ped.person_id "
                    . " FROM "
                    . "     tbl_person_education_details as ped, tbl_person as p, "
                    . "     (SELECT * FROM tbl_education_institute as ei WHERE ei.education_institute_name = '$v_education->education_institute_name') as common_institute "
                    . " WHERE "
                    . "         common_institute.education_institute_id = ped.education_institute_id"
                    . "     AND not ped.person_id IN ($person_id) AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5)";
            $result = $this->db->query($sql)->result();
            $all_result = array_merge($all_result, $result);
        }
        return $all_result;
    }

    public function select_person_list_by_work($person_all_work) {
        $person_id = $this->session->userdata('user_id');
        $today = date('Y-m-d', (time()));
        $all_result = array();

        foreach ($person_all_work as $v_work) {
            $sql = "SELECT DISTINCT pwd.person_id  "
                    . " FROM "
                    . "     tbl_person_work_details as pwd, tbl_person as p "
                    . " WHERE ";

            $sql .= "( pwd.company_name = '$v_work->company_name' ";
            if ($v_work->job_end_date) {
                $sql .= "     AND ("
                        . "             '$v_work->job_start_date'  BETWEEN pwd.job_start_date AND pwd.job_end_date "
                        . "         OR  '$v_work->job_end_date'  BETWEEN pwd.job_start_date AND pwd.job_end_date"
                        . "     ) "
                ;
            } else {
                $sql .= "     AND ("
                        . "             '$v_work->job_start_date'  BETWEEN pwd.job_start_date AND pwd.job_end_date "
                        . "          OR '$today'  BETWEEN pwd.job_start_date AND pwd.job_end_date "
                        . "     ) "
                ;
            }
            $sql .= " ) AND not pwd.person_id IN ($person_id)  AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5)";

            $result = $this->db->query($sql)->result();
            $all_result = array_merge($all_result, $result);

            $sql = "SELECT DISTINCT pwd.person_id  "
                    . " FROM "
                    . "     tbl_person_work_details as pwd, tbl_person as p"
                    . " WHERE "
                    . "         pwd.company_name = '$v_work->company_name' "
                    . "     AND not pwd.person_id IN ($person_id) AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5)";

            $result = $this->db->query($sql)->result();
            $all_result = array_merge($all_result, $result);
        }

//        echo '<pre>';
//        print_r($all_result);
//        exit();

        return $all_result;
    }

    public function select_person_list_by_interest($person_all_interest) {
        $person_id = $this->session->userdata('user_id');
        $sql = "SELECT DISTINCT foi.person_id "
                . " FROM "
                . "     tbl_field_of_interest as foi "
                . " WHERE ";

        //adding person travel
        $sql .= "( foi.field_of_interest_name = '' ";
        foreach ($person_all_interest as $v_interest) {
            $sql .= " OR foi.field_of_interest_name = '$v_interest->field_of_interest_name' ";
        }

        $sql .= " )";

        $result = $this->db->query($sql)->result();
        //adding person current cities
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    /**
     * @Function            : get_single_person_information_by_person_id 
     * @Used IN             : @function-'add_teacher'                           client_admin[@controller],
     * @                    : @function-'add_course'                            user_course[@controller],
     * @                    : @function-'enroll_course'                         welcome[@controller] 2-times
     * @                    : @function-'view_invoice'                          user_payment[@controller] 2-times
     * @                    : @function-'get_user_total_storage'                user_course[@controller]
     * @                    : @function-'add_video'                             user_video[@controller]
     * @                    : @function-'view_invoice'                          user_payment[@controller]
     * @                    : @function-'schedule_class'                        classroom[@controller]
     * @                    : @function-'check_course_feature_information'      super_admin_feature_model[@Model]
     * @                    : @function-'org_upcoming/running/previois_class'   classroom[@Controller]
     * @                    : @function-'tec_upcoming/running/previois_class'   classroom[@Controller]
     * @                    : @function-'get_person_id_by_person_information'   this[@Model]
     * @                    : @function-'upcoming/running/previous'             super_admin_controller[@Controller]
     * @Description         : get person information using person_id
     * @Developed By        : Copied from -'super_admin_model'
     * @Start DateTime      : 01-03-2016 06:33 PM      
     * @Status              : available      
     * */
    public function get_single_person_information_by_person_id($person_id) {
        $sql = "SELECT *
                FROM
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_person_info_view_status AS pivs
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id
                AND p.person_id = pivs.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_person_information_by_person_id 
     * @Used IN             : @function-'my_billing'      user_payment[@controller]
     * @Description         : get person information using person_id
     * @Developed By        : Copied from -'super_admin_model'
     * @Start DateTime      : 01-03-2016 06:33 PM      
     * @Status              : available      
     * */
    public function get_single_person_information_by_person_url($person_url) {
        $sql = "SELECT *
                FROM
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_person_info_view_status AS pivs
                WHERE
                    u.url = '$person_url'
                    AND p.url_id = u.url_id
                    AND pivs.person_id = p.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_organization_info 
     * @Used IN             : @function-'save_person_information'      client_admin_model[@Model]
     * @                    : @function-'add_course'                   user_course[@Controller]
     * @                    : @function-'view_invoice'                 user_payment[@Controller]
     * @                    : @function-'enroll_course'                welcome[@Controller]
     * @Description         : get organization information using person_id
     * @Developed By        : Copied from -'super_admin_model'
     * @Start DateTime      : 01-03-2016 06:33 PM      
     * @Status              : available      
     * */
    public function select_organization_info($person_id) {
        $sql = "SELECT * FROM
			tbl_person AS p,
			tbl_url AS u,
			tbl_person_info_view_status AS pvs,
			tbl_organization AS o,
			tbl_resource_person AS rp
                WHERE
                    o.person_id = '$person_id'
                AND p.person_id = o.person_id
                AND u.url_id = p.url_id
                AND pvs.person_id = o.person_id
                AND rp.person_id = o.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_resource_person_info 
     * @Used IN             : @function-'add_course'                            user_course[@Controller]
     * @                    : @function-'view_invoice'                          user_payment[@Controller]
     * @                    : @function-'enroll_course'                         user_payment[@Controller]
     * @                    : @function-'check_course_feature_information'      super_admin_feature_model[@Model]
     * @                    : @function-'get_person_id_by_person_information'   this[@Model] - 2 times
     * @Description         : get resource persion information using person_id
     * @Developed By        : Copied from -'super_admin_model'
     * @Start DateTime      : 01-03-2016 07:10 PM      
     * @Status              : available      
     * */
    public function select_resource_person_info($person_id) {
        $sql = "SELECT *
                FROM
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_person_info_view_status AS pvs
                WHERE
                    rp.person_id = '$person_id'
                AND rp.person_id = p.person_id
                AND rp.person_id = pvs.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_resource_person_info 
     * @Used IN             : @function-'organization_upcoming_class'                 Classroom[@Controller]
     * @                    : @function-'check_tt_resource_person_feature_sataus'     Classroom[@Controller]
     * @Description         : get resource persion information using resource person_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 11:03 PM      
     * @Status              : available      
     * */
    public function select_resource_person_info_by_resource_person_id($resource_person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    rp.resource_person_id = '$resource_person_id'
                AND rp.person_id = p.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_organization_info_by_organization_id 
     * @Used IN             : @function-'add_course'      user_course[@Controller]
     * @Description         : get resource persion information using person_id
     * @Developed By        : Copied from -'super_admin_model'
     * @Start DateTime      : 01-03-2016 07:10 PM      
     * @Status              : available      
     * */
    public function select_organization_info_by_organization_id($organization_id) {
        $sql = "SELECT * 
                  FROM
                    tbl_organization AS o,
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_resource_person AS rp
                WHERE 
                    o.organization_id = '$organization_id'
                AND o.person_id = p.person_id
                AND p.url_id = u.url_id
                AND p.person_id = rp.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_all_resource_person_info_by_organizarion_id 
     * @Used IN             : @function-'select_organization_category_by_organization_id'               user_course_model[@Model]
     * @                    : @function-'select_categories_organization_course_by_organization_id'      user_course_model[@Model]
     * @Description         : get resource persion information using person_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-03-2016 03:51 PM      
     * @Status              : available      
     * */
    function get_all_resource_person_info_by_organizarion_id($organizaton_id) {
        $sql = "SELECT *
                FROM 
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    rp.organization_id = '$organizaton_id'
                AND rp.resource_person_type = '3'
                AND rp.person_id = p.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_resource_person_info_by_organizarion_id 
     * @Used IN             : @function-'get_front_end_group_name'    user_video[@Model]
     * @Description         : get resource persion information using person_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 12:05 PM      
     * @Status              : available      
     * */
    function get_all_resource_person_info_by_organizarion_id1($organizaton_id) {
        $sql = "SELECT group_concat(rp.person_id) as person_id_string
                FROM 
                    tbl_resource_person AS rp
                WHERE 
                    rp.organization_id = '$organizaton_id'
                AND rp.resource_person_type = '3'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_all_resource_person_information_by_resource_person_type 
     * @Used IN             : @function-'get_all_resource_person_id_by_resource_person_type'       this[@Model]
     * @Description         : get resource persion information using person_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 01:05 PM      
     * @Status              : available      
     * */
    function select_all_resource_person_information_by_resource_person_type($resource_person_type) {
        $sql = "SELECT * 
                FROM 
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE	
                    rp.resource_person_type = '$resource_person_type'
                AND rp.person_id = p.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_resource_person_id_by_resource_person_type 
     * @Used IN             : @function-'schedule_classroom'                   super_admin_classroom[@Controller]
     * @                    : @function-'get_selected_course_by_category_id'   super_admin_classroom[@Controller]
     * @                    : @function-'edit_schedule_classroom'              super_admin_classroom[@Controller]
     * @Description         : get resource person ID using resource type
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 01:05 PM      
     * @Status              : available      
     * */
    function get_all_resource_person_id_by_resource_person_type($resource_person_type) {
        $resource_person_id_array = Array();
        $resource_person_info = $this->select_all_resource_person_information_by_resource_person_type($resource_person_type);
        foreach ($resource_person_info as $resource_person_value) {
            $resource_person_id_array[] = $resource_person_value->resource_person_id;
        }
        return $resource_person_id_array;
    }

    /**
     * @Function            : get_all_person_id_by_orgnaization_id 
     * @Used IN             : @function-'get_person_id_by_person_information'         this[@Model] - 2 times
     * @Description         : get all person ID using organization ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 12:37 AM      
     * @Status              : available      
     * */
    function get_all_person_id_by_orgnaization_id($organization_id) {
        $all_person_id_array = array();
        $all_resource_person = $this->get_all_resource_person_info_by_organizarion_id($organization_id);
        foreach ($all_resource_person as $resource_person_value) {
            $all_person_id_array[] = $resource_person_value->person_id;
        }
        return $all_person_id_array;
    }

    /**
     * @Function            : get_person_id_by_person_information 
     * @Used IN             : @function-'check_date_time_feature_status'            classroom[@Controller]
     * @                    : @function-'check_classroom_start_date_with_feature'   classroom[@Controller]
     * @                    : @function-'check_class_start_date'                    classroom[@Controller]
     * @                    : @function-'check_class_duration'                      classroom[@Controller]
     * @                    : @function-'organization_upcoming_class'               classroom[@Controller]
     * @Description         : get person id by person role 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 12:37 AM    
     * @Status              : available      
     * */
    function get_person_id_by_person_information($person_id) {
        $data['person_info'] = $this->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->select_resource_person_info($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                return $person_id;
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                return $person_id;
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $person_id1 = $this->get_all_person_id_by_orgnaization_id($data['resource_person_info']->organization_id);
                return implode(',', $person_id1);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->select_resource_person_info($data['person_info']->person_id);
            $person_id1 = $this->get_all_person_id_by_orgnaization_id($data['resource_person_info']->organization_id);
            return implode(',', $person_id1);
        }
    }

    /**
     * @Function            : get_person_id_by_person_information 
     * @Used IN             : @function-'check_date_time_feature_status'       classroom[@Controller]
     * @Description         : get person id by person role 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-03-2016 12:37 AM    
     * @Status              : available      
     * */
    function select_all_front_end_group_by_search($all_person_id, $search_group_name, $selected_group_list) {
        $sql = "SELECT * 
                FROM 
                    tbl_group AS g
                WHERE 
                    g.group_created_by IN ($all_person_id)
                AND g.group_status = '1'
                AND g.group_name LIKE '%$search_group_name%'";
        if ($selected_group_list != '') {
            $sql.= " AND g.group_id NOT IN ($selected_group_list)";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_front_end_selected_group 
     * @Used IN             : @function-'get_front_end_group_name'       user_video[@Controller]
     * @Description         : get person id by person role 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 01:11 AM    
     * @Status              : available      
     * */
    function select_all_front_end_selected_group($all_person_id, $selected_group_list) {
        $sql = "SELECT * 
                FROM 
                    tbl_group AS g
                WHERE 
                    g.group_created_by IN ($all_person_id)
                AND g.group_id IN ($selected_group_list)";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_link_person_by_search 
     * @Used IN             : @function-'front_end_special_user_name'       user_video[@Controller]
     * @Description         : get link person ID by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 08:59 AM    
     * @Status              : available      
     * */
    function select_all_link_person_by_search($person_id, $user_search_value, $selected_user_list) {
        $all_link_person = $this->get_all_linked_person1($person_id);
        if ($all_link_person != '') {
            $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.person_id IN ($all_link_person)
                AND p.url_id = u.url_id
                AND p.person_id != '$person_id'
                AND p.person_first_name LIKE '%$user_search_value%'";
            if ($selected_user_list != '') {
                $sql.=" AND p.person_id NOT IN ($selected_user_list)";
            }
            return $this->db->query($sql)->result();
        } else {
            return '';
        }
    }

    /**
     * @Function            : get_all_selected_person 
     * @Used IN             : @function-'front_end_special_user_name'       user_video[@Controller]
     * @Description         : get person info by selected_user_list
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 09:25 AM    
     * @Status              : available      
     * */
    function get_all_selected_person($selected_user_list) {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.person_id IN ($selected_user_list)
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_linked_person 
     * @Used IN             : @function-'select_all_link_person_by_search'       user_video[@Controller]
     * @Description         : get link person ID by person ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 09:02 AM    
     * @Status              : available      
     * */
    function get_all_linked_person($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_person_link AS pl
                WHERE 
                    pl.add_link_request_status = '1'
                AND (pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id')";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_linked_person1 
     * @Used IN             : @function-'get_all_linked_person'       user_video[@Controller]
     * @Description         : get link person ID by person ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 09:06 AM    
     * @Status              : available      
     * */
    function get_all_linked_person1($person_id) {
        $link_array = array();
        $my_link = $this->get_all_linked_person($person_id);
        if ($my_link) {
            foreach ($my_link as $link_value) {
                $link_array[] = $link_value->person_id;
                $link_array[] = $link_value->requested_person_id;
            }
        }
        $link_array1 = array_unique($link_array);
        return implode(",", $link_array1);
    }

    //---------------------------------- End Front End Deshboard Post----------------------------- 
    //------------------------------------start afrin jahan noumin-----------------------------------
    //for teacher resource person status check
    public function select_resource_person_info_for_teacher($person_id) {
        $sql = "SELECT * FROM tbl_resource_person WHERE  person_id='$person_id' ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_all_course_url($url_id) {
        $sql = "SELECT * FROM tbl_url WHERE url_id='$url_id' ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    //------------------------------------END afrin jahan noumin-----------------------------------

    /*
      -----------@@@RIPON@ Start Changed password field Part----------------------------------
     */

    /**
     * @Function            : set_image_height_width 
     * @Used IN             : @function-'upload_profile_image'     profile[@Controller]
     * @Description         : check Image height and width
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-06-2016 09:35 AM  
     * @Parameter           : $image_path[STRING]
     * @Return              : Image_heigth,image_width 
     * @Status              : Available        
     * */
    function set_image_height_width($image_path) {
        $image_dimension = Array();
        list($image_width, $image_height) = getimagesize($image_path);
        if ($image_width > $image_height) {
            if ($image_width > 450) {
                $image_dimension['image_width'] = 450;
                $image_dimension['image_height'] = $this->get_image_dimension($image_width, $image_height, 450);
            } else {
                $image_dimension['image_width'] = $image_width;
                $image_dimension['image_height'] = $image_height;
            }
        }
        if ($image_height > $image_width) {
            if ($image_height > 350) {
                $image_dimension['image_height'] = 350;
                $image_dimension['image_width'] = $this->get_image_dimension($image_height, $image_width, 350);
            } else {
                $image_dimension['image_height'] = $image_height;
                $image_dimension['image_width'] = $image_width;
            }
        }
        if ($image_height == $image_width) {
            if ($image_height > 350) {
                $image_dimension['image_height'] = 350;
                $image_dimension['image_width'] = 350;
            } else {
                $image_dimension['image_height'] = $image_height;
                $image_dimension['image_width'] = $image_width;
            }
        }
        return $image_dimension;
    }
    
    /**
     * @Function            : resize_image_height_width 
     * @Used IN             : @function-'upload_profile_image'     profile[@Controller]
     * @Description         : resize Image 
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 5-06-2016 011:35 AM  
     * @Parameter           : $image_path[STRING]
     * @Return              : Image_heigth,image_width 
     * @Status              : Available        
     * */
    public function resize_image_height_width ($image_path){
        $new_image_width = '450';
        $new_image_height = '300';
        
        list($image_width, $image_height) = getimagesize($image_path);
        if ($image_width > $new_image_width && $image_height > $new_image_height) {
            $config['image_library'] = 'GD2';
            $config['new_image'] = $image_path;
            $config['source_image'] = $image_path;
            $config['maintain_ratio'] = TRUE;
            $config['width'] = '450';
            $config['height'] = '300';

            $this->image_lib->clear();
            $this->image_lib->initialize($config);
            $this->image_lib->resize();
        }
        elseif($image_width > $new_image_width && $image_height < $new_image_height) {
            $config['image_library'] = 'GD2';
            $config['new_image'] = $image_path;
            $config['source_image'] = $image_path;
            $config['maintain_ratio'] = TRUE;
            $config['width'] = '450';
            $config['height'] = $image_height;

            $this->image_lib->clear();
            $this->image_lib->initialize($config);
            $this->image_lib->resize();
        }
        elseif($image_width < $new_image_width && $image_height > $new_image_height) {
            $config['image_library'] = 'GD2';
            $config['new_image'] = $image_path;
            $config['source_image'] = $image_path;
            $config['maintain_ratio'] = TRUE;
            $config['width'] = $image_width;
            $config['height'] = '300';

            $this->image_lib->clear();
            $this->image_lib->initialize($config);
            $this->image_lib->resize();
        }
        else{
            $config['image_library'] = 'GD2';
            $config['new_image'] = $image_path;
            $config['source_image'] = $image_path;
            $config['maintain_ratio'] = TRUE;
            $config['width'] = '450';
            $config['height'] = '300';

            $this->image_lib->clear();
            $this->image_lib->initialize($config);
            $this->image_lib->resize();
        }
        return $config;
    }

    /**
     * @Function            : get_image_dimension 
     * @Used IN             : @function-'set_image_height_width'     profile_model[@Model]
     * @Description         : check Image height and width
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-06-2016 09:59 AM  
     * @Parameter           : $size1[INTEGER], $size2[INTEGER], $fixed_size[INTEGER]
     * @Return              : $size1[INTEGER] 
     * @Status              : Available        
     * */
    function get_image_dimension($size1, $size2, $fixed_size) {
        $ratio = $size1 / $fixed_size;
        return floor($size2 / $ratio);
    }

    /**
     * @Function            : check_person_password 
     * @Used IN             : @function-'check_current_password'     profile[@Controller]
     * @                    : @function-'update_user_password'       profile[@Controller]
     * @Description         : check password by person_id nad user typed password
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-04-2016 04:49 PM
     * @Updated By          : Md Mashqur Ul Alam
     * @Update DateTime     : 29-12-16 04.04  
     * @Parameter           : person_id[INTEGER], current_password[STRING]
     * @Return              : person_info[if matched person_id and parson_password]    
     * @Status              : Available        
     * */
    function check_person_password($person_id, $current_password) {

        $result = $this->db->select('*')->from('tbl_person')
                        ->where('person_id', $person_id)
                        ->where('person_password', MD5($current_password))
                        ->get()->result();

        return $result;
    }

    /**
     * @Function            : update_password_model 
     * @Used IN             : @function-'update_changed_password'     profile[@Controller]
     * @Description         : Updates the users password
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 31-12-2016 03:07 PM  
     * @Parameter           : $person_id, $new_pass
     * @Return              : NUll
     * @Status              : Available        
     * */
    public function update_password_model($person_id, $new_pass) {
        $this->db->set('person_password', md5($new_pass))
                ->where('person_id', $person_id)
                ->update('tbl_person');
    }

    /**
     * @Function            : check_profile_url_change_status 
     * @Used IN             : @function-'edit_profile'     profile[@Controller]
     * @Description         : check prifile url if changed
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 09-06-2016 01:07 PM  
     * @Parameter           : $data[Array]
     * @Return              : $data[Array]  
     * @Status              : Available        
     * */
    function check_profile_url_change_status($data) {
        if ($data['person_info']->person_last_change_url_date) {
            $user_date = $data['person_info']->person_last_change_url_date;
            $current_date = date('Y-m-d', time() - $this->session->userdata('time_offset'));
            $data['url_change_different'] = $this->cf->dateDifference($current_date, $user_date);
        } else {
            $data['url_change_different'] = '';
        }
        return $data;
    }

    /**
     * @Function            : get_all_course_created_by_person_id 
     * @Used IN             : @function-'edit_profile'     profile[@Controller]
     * @Description         : get all courses by person ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 09-06-2016 01:07 PM  
     * @Parameter           : $data[Array], $person_id[INTEGER]
     * @Return              : $data[Array]  
     * @Status              : Available        
     * */
    function get_all_course_created_by_person_id($data, $person_id) {
        if ($data['person_info']->person_role == 6 || $data['person_info']->person_role == 1) {
            $data['person_course_info'] = $this->person_course_info_by_id($person_id);
        } else if ($data['person_info']->person_role == 3) {
            $result = $this->organization_model->orgnization_info_with_resource_person_by_person_id($person_id);
            if ($result) {
                $data['person_course_info'] = $this->organization_person_course_info_by_id($result->resource_person_id);
                $data['organization_name'] = $result->organization_name;
                $data['person_course_with_organization_info'] = $this->person_course_info_by_id($result->person_id);
            } else {
                $data['person_course_info'] = $this->person_course_info_by_id($person_id);
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['person_course_info'] = $this->person_course_info_by_id($person_id);
        } elseif ($data['person_info']->person_role == 5) {
            //$data['person_organization_name'] = $this->person_organization_name_by_id($person_id);
            //foreach ($data['person_organization_name'] as $o_value) {
            //$data['person_orgaanization_course_name'][$o_value->organization_id] = $this->person_organization_course_name_by_person_id($person_id, $o_value->organization_id);
            //}
        }
        return $data;
    }

    /**
     * @Function            : get_total_friends 
     * @Used IN             : @function-'edit_profile'     profile[@Controller]
     * @Description         : get total friends
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 09-06-2016 01:21 PM  
     * @Parameter           : $data[Array], $person_id[INTEGER]
     * @Return              : $data[Array]  
     * @Status              : Available        
     * */
    function get_total_friends($data, $person_id) {
        $data['friends_details_part1'] = $this->select_my_friends_details_part1($person_id);
        $part1_total = count($data['friends_details_part1']);
        $data['friends_details_part2'] = $this->select_my_friends_details_part2($person_id);
        $part2_total = count($data['friends_details_part2']);
        $data['total_friends'] = $part1_total + $part2_total;
        return $data;
    }

    /**
     * @Function            : get_profiled_person_information 
     * @Used IN             : @function-'edit_profile'     profile[@Controller]
     * @Description         : get all profiled ingformation
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 09-06-2016 01:28 PM  
     * @Parameter           : $data[Array], $person_id[INTEGER]
     * @Return              : $data[Array]  
     * @Status              : Available        
     * */
    function get_profiled_person_information($data, $person_id) {
        $data['interest_field_info'] = $this->select_user_interest_field($person_id);
        $data['person_language'] = $this->super_admin_model->select_person_limited_language_by_id($person_id, 0);
        $data['interest_field_info_all'] = $this->select_user_interest_field_all($person_id);
        $data['person_interest_field_info'] = $this->select_person_interest_field($person_id);
        $data['person_self_assessmet_skills'] = $this->super_admin_model->select_self_assessment_skills_by_id($person_id);
        $data['user_work_details'] = $this->get_work_details($person_id , 0);
        $data['user_education_details'] = $this->get_education_details($person_id, 0);
        $data['person_feature_details'] = $this->super_admin_model->select_person_feature_details_by_id($person_id);
        
        $page_number = 1;
        //work_experience_pagination_link
        $work_detail_count_list = count($this->select_user_work_details($person_id));
        $params = array('url' => '', 'div_id' => 'work_experience_pagination', 'total_row' => $work_detail_count_list, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['work_experience_pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        
        //language_pagination_link
        $total_person_language = count($this->super_admin_model->select_person_language_by_id($person_id));        
        $params = array('url' => '', 'div_id' => 'profile_language_pagination', 'total_row' => $total_person_language, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['profile_language_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        //education_pagination_link
        $total_education = count($this->select_user_education_details($person_id));        
        $params = array('url' => '', 'div_id' => 'profile_education_pagination', 'total_row' => $total_education, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['profile_education_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        return $data;
    }
   
   /**
     * @Function            : get_education_details
     * @Description         : prepare the education detail for person profile 
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 15-04-17
     * @Parameter           : $person_id [ person_id of the profile]
     * @Status              : Available       
     * */
    function get_education_details($person_id, $limit_offset = NULL){
        $edu_detail = [];
        $linked_person_id = $this->get_linked_person_id($person_id);        
        $edu_list = count($this->select_user_education_details($person_id));
        $limited_edu_list = $this->select_user_limited_education_details($person_id, $limit_offset);
        if($person_id == $this->session->person_id){
            return $limited_edu_list;
        }
        foreach($limited_edu_list AS $edu){
            if($edu->person_education_view_status == 1){
                $edu_detail[] = $edu;
            }elseif(($edu->person_education_view_status == 2) && $this->session->person_id){
                $edu_detail[] = $edu;
            }elseif(($edu->person_education_view_status == 3 && in_array($this->session->person_id, $linked_person_id))){
                $edu_detail[] = $edu;
            }
        }
        return $edu_detail;
    }
    
    
    /**
     * @Function            : get_linked_person_id
     * @Description         : get array of the person_id of linked users
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 15-04-17
     * @Parameter           : $person_id [ person_id of the profile]
     * @Status              : Available       
     * */
    function get_linked_person_id($person_id){
        $link =  $this->db->select('person_id, requested_person_id')
                ->from('tbl_person_link')
                ->where('person_id', $person_id)
                ->or_where('requested_person_id', $person_id)
                ->get()->result_array();        
    return  array_unique(array_merge(array_column($link, 'person_id'), array_column($link, 'requested_person_id')));
    }
    
    
    /**
     * @Function            : get_work_details
     * @Description         : prepare work details for profile
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 15-04-17
     * @Parameter           : $person_id [ person_id of the profile]
     * @Status              : Available       
     * */
    function get_work_details($person_id , $limit_offset = NULL){
        $work_detail = [];
        $linked_person_id = $this->get_linked_person_id($person_id); 
        $work_detail_count_list = count($this->select_user_work_details($person_id));
        $work_detail_list = $this->select_user_limit_work_details($person_id, $limit_offset);
        if($person_id == $this->session->person_id){
            return $work_detail_list;
        }
        foreach($work_detail_list AS $work){
            if($work->person_work_view_status == 1){
                $work_detail[] = $work;
            }elseif(($work->person_work_view_status == 2) && $this->session->person_id){
                $work_detail[] = $work;
            }elseif(($work->person_work_view_status == 3 && in_array($this->session->person_id, $linked_person_id))){
                $work_detail[] = $work;
            }
        }
        return $work_detail;
    }

    /**
     * @Function            : update_profile_image_into_database 
     * @Used IN             : @function-'save_profile_image'        -       this@Controller
     * @Description         : update person image in to database 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-06-2016 09:35 AM
     * @Parameter           : NULL
     * @View                : None 
     * @Status              : Available       
     * */
    function update_profile_image_into_database($user_id, $file_data) {
        $data['person_image'] = 'my-image/profile-image/' . $file_data['file_name']; // update person image 
        $content_data['content_library_type_id'] = $user_id;
        $content_data['content_library_location'] = $data['person_image'];
        $content_data['content_library_type'] = 1;
        $this->db->insert('tbl_content_library', $content_data);
    }

    /**
     * @Function            : get_person_all_image_data_by_person_id 
     * @Used IN             : @function-'edit_profile'        -       profile@Controller
     * @Description         : update person image in to database 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 02:18 PM
     * @Parameter           : $person_id[INTEGER]
     * @View                : None 
     * @Status              : Available       
     * */
    function get_person_all_image_data_by_person_id($data) {
        $data['content_result'] = $this->person_model->get_person_content_library_by_person_id($data['person_info']->person_id);
        $data['post_result'] = $this->post_model->get_person_post_details_by_person_id($data['person_info']->person_id, 4);
        return $data;
    }

    /**
     * @Function            : get_profile_learner_course
     * @Description         : get learner course detail for profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-03-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_profile_learner_course($person_id, $offset = 0, $count = FALSE) {
        $this->db->select('ts.student_type_id, ts.student_roll_number, tu.url AS course_url, '
                        . 'tc.course_name, tc.upcoming_course, tsc.student_certificate_id')
                ->from('tbl_student AS ts')
                ->join('tbl_course AS tc', 'tc.course_id = ts.student_type_id')
                ->join('tbl_url AS tu', 'tu.url_id = tc.url_id')
                ->join('tbl_student_certificate AS tsc', 'tsc.student_roll_number = ts.student_roll_number', 'left')
                ->where('ts.person_id', $person_id)
                ->where('ts.student_type', 1)
                ->where('tc.course_status', 1)
                ->order_by('tc.upcoming_course', 'DESC');
        if ($count) {
            $result = $this->db->count_all_results();
        } else {
            $result = $this->db->limit(5, $offset)->get()->result();
        }

        return $result;
    }

    /**
     * @Function            : get_profile_teacher_course
     * @Description         : get teacher course detail for profile
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_profile_teacher_course($person_id, $offset = 0, $count = FALSE) {
        $this->db->select('tc.course_id, tc.upcoming_course, tc.course_level,'
                        . 'tc.course_name, tc.course_type, '
                        . 'tc.course_rating, tp.person_first_name, '
                        . 'tp.person_last_name, tp.person_role, tu.url')
                ->from('tbl_course AS tc')
                ->join('tbl_resource_person AS trp', 'trp.resource_person_id = tc.resource_person_id')
                ->join('tbl_url AS tu', 'tu.url_id = tc.url_id')
                ->join('tbl_person AS tp', 'tp.person_id = tc.person_id')
                ->where('trp.person_id', $person_id)
                ->where('tc.course_status', 1);
        if ($count) {
            $result = $this->db->count_all_results();
        } else {
            $result = $this->db->limit(5, $offset)->get()->result();
        }
        return $result;
    }
      
    /**
     * @Function            : get_org_id_by_teacher_id
     * @Description         : get organization id using tearher person id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $teacher_id
     * @Status              : Available       
     * */
    function get_org_id_by_teacher_id($teacher_id) {
        $result = $this->db->select('to.person_id')
                        ->from('tbl_organization AS to')
                        ->join('tbl_organization_resource_person AS torp', 'torp.organization_id = to.organization_id')
                        ->join('tbl_resource_person AS trp', 'trp.resource_person_id = torp.resource_person_id')
                        ->where('trp.person_id', $teacher_id)
                        ->get()->row();
        return $result->person_id;
    }

    /**
     * @Function            : get_profile_organization_course
     * @Description         : get organization course detail from database
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */
    function get_profile_organization_course($org_person_id, $offset = 0, $count = FALSE) {
        $this->db->select('tc.course_id, tc.upcoming_course, tc.course_level,'
                        . 'tc.course_name, tc.course_type, '
                        . 'tc.course_rating, tp.person_first_name, '
                        . 'tp.person_last_name, tu.url')
                ->from('tbl_course AS tc')
                ->join('tbl_url AS tu', 'tu.url_id = tc.url_id')
                ->join('tbl_person AS tp', 'tp.person_id = tc.person_id')
                ->where('tc.person_id', $org_person_id)
                ->order_by('tc.upcoming_course', 'ASC');
        if ($count) {
            $result = $this->db->count_all_results();
        } else {
            $result = $this->db->limit(5, $offset)->get()->result();
        }
        return $result;
    }
    
    /**
     * @Function            : get_profile_teacher_video_course
     * @Description         : get teacher video course detail for profile
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 12-06-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_profile_teacher_video_course($person_id, $offset = 0, $count = FALSE){
        $this->db->select('vm.video_management_id, vm.video_management_level,'
                        . 'vm.video_course_title, vm.video_course_type, vm.video_course_price,vm.video_course_price_currency,'
                        . 'vm.video_course_price_currency, vm.video_management_rating, tp.person_first_name, '
                        . 'tp.person_last_name, tp.person_role, tu.url')
                ->from('tbl_video_management AS vm')
                ->join('tbl_resource_person AS trp', 'trp.resource_person_id = vm.resource_person_id')
                ->join('tbl_url AS tu', 'tu.url_id = vm.url_id')
                ->join('tbl_person AS tp', 'tp.person_id = vm.person_id')
                ->where('trp.person_id', $person_id)
                ->where('vm.video_management_status', 1);
        if ($count) {
            $result = $this->db->count_all_results();
        } else {
            $result = $this->db->limit(5, $offset)->get()->result();
        }
        return $result;
    }
    
    /**
     * @Function            : get_profile_organization_video_course
     * @Description         : get organization video course detail from database
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 13-06-17
     * @Parameter           : $org_person_id
     * @Status              : Available       
     * */
    function get_profile_organization_video_course($org_person_id, $offset = 0, $count = FALSE) {
        $this->db->select('vm.video_management_id, vm.video_management_level,'
                        . 'vm.video_course_title, vm.video_course_type, vm.video_course_price,vm.video_course_price_currency,'
                        . 'vm.video_course_price_currency, vm.video_management_rating, tp.person_first_name, '
                        . 'tp.person_last_name, tp.person_role, tu.url')
                ->from('tbl_video_management AS vm')
                ->join('tbl_url AS tu', 'tu.url_id = vm.url_id')
                ->join('tbl_person AS tp', 'tp.person_id = vm.person_id')
                ->where('vm.person_id', $org_person_id);
        if ($count) {
            $result = $this->db->count_all_results();
        } else {
            $result = $this->db->limit(5, $offset)->get()->result();
        }
        return $result;
    }

    /**
     * @Function            : get_course_price
     * @Description         : get course price by course id
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $course_id
     * @Status              : Available       
     * */
    function get_course_price($course_id) {
        $result = $this->db->select('*')
                        ->from('tbl_price')
                        ->where('price_type', 1)
                        ->where('price_type_id', $course_id)
                        ->get()->row();
        return $result;
    }

    /**
     * @Function            : get_course_registered_student_number
     * @Description         : counts the number of registered student of a course
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-03-17
     * @Parameter           : $course_id
     * @Status              : Available       
     * */
    function get_course_registered_student_number($course_id) {
        $result = $this->db->from('tbl_student')
                ->where('student_type', 1)
                ->where('student_type_id', $course_id)
                ->count_all_results();
        return $result;
    }
    
    /*
     * @Function            : user_public_work_education_details
     * @Used IN             : @function-'user_profile,' 
     * @Description         : get the details of users work and education
     * @Developed By        : Md. Delwar Hossain 
     * @Start DateTime      : 22-3-2017 2:40 PM    
     * @Parameter           : $person_id
     * @Return              : $data   
     * @Status              : available      
     */
    function user_public_work_education_details($person_id){
        $data['user_detail'] = $this->db->select('*')
                ->from('tbl_person')
                ->where_in('person_id', $person_id)                
                ->get()
                ->result();
        
        $data['user_public_work'] = $this->db->select('*')
                        ->from('tbl_person_work_details')
                        ->where('person_id', $person_id)
                        ->where('person_work_view_status', 1)
                        ->where('work_details_status', 1)
                        ->get()->result();
        
        $data['user_public_education'] = $this->db->select('*')
                ->from('tbl_person_education_details')
                ->where_in('person_id', $person_id)
                ->where('person_education_view_status', 1)
                ->where('person_education_status', 1)
                ->get()->result();
        
        return $data;
    }
    
    
    /**
     * @Function            : get_profile_image_album_content
     * @Description         : get profile image location from database
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-04-17
     * @Status              : Available       
     * */
    public function get_profile_image_album_content(){
        $person_detail = $this->user_info_by_id($this->session->person_id);        
        $this->db->select('content_library_location AS image_location')
                ->from('tbl_content_library')
                ->where('content_library_type_id', $this->session->person_id)
                ->where('content_library_type', 1)
                ->where('content_deletion_status', 1)
                ->where('content_library_location !=', $person_detail->person_image);
        $result = $this->db->get()->result();
        return $result;
    }
    
    
    /**
     * @Function            : get_post_image_album_content
     * @Description         : get post image location from database
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-04-17
     * @Status              : Available       
     * */
    public function get_post_image_album_content(){
        $result = $this->db->select('post_details AS image_location')
                       ->from('tbl_post')
                       ->where('posted_by', $this->session->person_id)
                       ->where('post_type', 4)
                       ->where('post_status', 1)
                       ->get()->result();
        return $result;
    }
    
    /**
     * @Function            : get_last_post_image_content
     * @Description         : get last post image location from database
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 16-05-17 11:00 AM
     * @Status              : Available       
     * */
    public function get_last_post_image_content(){
        $result = $this->db->select('post_details AS image_location')
                       ->from('tbl_post')
                       ->where('posted_by', $this->session->person_id)
                       ->where('post_type', 4)
                       ->where('post_status', 1)
                       ->order_by('post_id', 'desc')
                       ->get()->row();
        return $result;
    }
    
    
        /**
     * @Function            : delete_profile_image_album_content
     * @Description         : update the database content_deletion_status
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-04-17
     * @Status              : Available       
     * */
    public function delete_profile_image_album_content($content_library_location){
        $this->db->set('content_deletion_status', 2)
                ->where('content_library_type_id', $this->session->person_id)
                ->where('content_library_type', 1)
                ->where('content_library_location', $content_library_location)
                ->update('tbl_content_library');
    }
    
    /**
     * @Function            : delete_post_image_album_content
     * @Description         : update the database post_status
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-04-17
     * @Status              : Available       
     * */
    public function delete_post_image_album_content($content_library_location){
        $this->db->set('post_status', 4)
                ->where('posted_by', $this->session->person_id)
                ->where('post_type', 4)
                ->where('post_details', $content_library_location)
                ->update('tbl_post');
    }
    
    /**
     * @Function            : check_tt_requst
     * @Description         : Check talha user request
     * @Moved By            : Md Delwar Hossain
     * @Moved From          : $f_end_model
     * @Moved DateTime      : 06-05-2017 4:20 PM
     * @Status              : Available       
     * */
    public function check_tt_requst($user_id, $person_id) {
        $this->db->select('*');
        $this->db->from('tbl_person_link');
        $this->db->where('requested_person_id', $user_id);
        $this->db->where('person_id', $person_id);

        $this->db->or_where('requested_person_id', $person_id);
        $this->db->where('person_id', $user_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }
}
