<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of person_link_model
 *
 * @author MD Jaherul Islam
 */
class Person_link_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : linked_person_id 
     * @Used IN             : @function-''     this[@Model] 
     * @Description         : get all person id seperated by comma whixh linked with Parameter (person_id)
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-08-2016 11:53 AM
     * @Parameter           : $person_id[INTEGER] (get all linked person id by this person ID)
     * @Return              : $person_id[STRING]      
     * @Status              : available      
     * */
    function linked_person_id($person_id, $status = '') {
        $sql = "SELECT CONCAT(GROUP_CONCAT(DISTINCT(pl.requested_person_id)),',',
             GROUP_CONCAT(DISTINCT(pl.person_id))) AS linked_person_id 
                FROM 
                    tbl_person_link AS pl
                WHERE (pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id')";
        if ($status != '') {
            $sql.=" AND pl.add_link_request_status IN ($status)";
        } else {
            $sql.=" AND pl.add_link_request_status IN (1)";
        }
        $linked_person_array = array_unique(explode(',', $this->db->query($sql)->row()->linked_person_id)); //all linked person id 
        $key = array_search($person_id, $linked_person_array); // find the login person array index
        unset($linked_person_array[$key]); // remove login person id from linked array
        return implode(',', $linked_person_array); // return linked person id seperated by comma
    }

}
