<?php

/**
 * Description of Payment_process_model
 *
 * @author MD Jaherul Islam
 */
class Payment_process_model extends CI_Model {

    private $number_reg_exp = '/^\d+(?:\.\d{1,2})?$/';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set value in model
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:20 PM   
     * */
    public $set_array = [];

    public function __set($name, $value) {
        $this->set_array[$name] = $value;
    }

    /**
     * @Description         : get single variable by $key in _get() magic method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:20 PM   
     * */
    public function get($key) {
        if (function_exists($key) == FALSE) {
            if (array_key_exists($key, $this->set_array)) {
                return $this->set_array[$key];
            }
        }
    }

    /**
     * @Description         : set primary key
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 11:40 AM   
     * */
    private $primary_key;

    function set_primary_key($primary_key) {
        $this->primary_key = $primary_key;
        return $this;
    }

    /**
     * @Description         : set primary key
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 11:40 AM   
     * */
    private $primary_key_value;

    function set_primary_key_value($key_value) {
        $this->primary_key_value = $key_value;
        return $this;
    }

    /**
     * @Description         : set table name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:32 PM   
     * */
    private $table_name;

    function set_table_name($table_name) {
        $this->table_name = $table_name;
        return $this;
    }

    /**
     * @Description         : save information into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:24 PM   
     * */
    function save() {
        $this->db->insert($this->table_name, $this->set_array);
        return $this;
    }

    /**
     * @Description         : update information into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-12-2016 12:24 PM   
     * */
    function update() {
        $this->db->where($this->primary_key, $this->primary_key_value)
                ->update($this->table_name, $this->set_array);
        return $this;
    }

    /**
     * @Description         : delete information into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 12:29 PM   
     * */
    function delete() {
        $this->db->where($this->primary_key, $this->primary_key_value)
                ->delete($this->table_name);
        return $this;
    }

    /**
     * @Description         : get insert ID [if payment data saved into database]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:28 PM    
     * */
    private $insert_id;

    function set_insert_id() {
        $this->insert_id = $this->db->insert_id();
        return $this;
    }

    /**
     * @Description         : get payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:28 PM    
     * */
    function get_id() {
        return $this->insert_id;
    }

    /**
     * @Description         : get payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:28 PM    
     * */
    function get_all_receipt_number() {
        return $this->db->select('GROUP_CONCAT(LOWER(receipt_number)) AS receipt_number')
                        ->from('tbl_payment_cash')->get()->row()->receipt_number;
    }

    /**
     * @Description         : check receipt number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2017 04:15 PM    
     * */
    function check_receipt_number($receipt_number) {
        $this->result = $this->db->select('*')
                        ->from('tbl_payment_cash')
                        ->where('receipt_number', $receipt_number)->get()->row();
        return $this;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-01-2017 04:18 PM    
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : check payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:28 PM    
     * */
    function check_payment_amount($invoice_id, $paid_amount) {
        // get payment ID by invoice ID
        $payment_id = $this->utility_model
                        ->get_table_information('payment_id', 'tbl_invoice', ['invoice_id' => $invoice_id])->payment_id;
        // get due amount
        $due_amont = $this->payment_model->set_payment_id($payment_id)
                        ->set_currency($this->input->post('currency_type', TRUE))
                        ->generate_due_amount()->get_due_amount();

        if (!preg_match($this->number_reg_exp, $paid_amount)) {
            return 1;
        } else if ($paid_amount < 1) {
            return 1;
        } else if ($paid_amount > $due_amont) {
            return 1;
        } else {
            return '';
        }
    }

    /**
     * @Description         : unset all variable by destructior megic method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 12:28 PM   
     * */
    public function __destruct() {
        if (!empty($this->insert_id)) {
            unset($this->insert_id);
        }
        if (!empty($this->table_name)) {
            unset($this->table_name);
        }
        if (!empty($this->set_array)) {
            unset($this->set_array);
        }
    }

}
