<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Payment_model extends CI_Model {

    private $payment_arr = [];

    const primary_id = 'payment_id';
    const tbl_name = 'tbl_payment';

    public function __construct() {
        parent::__construct();
        $this->load->model(['invoice_model', 'invoice_payment_model',
            'payment_process_model', 'admin_payment_model', 'bank_model', 'bank_branch_model']);
    }

    /**
     * @Description         : set magic method for set variable
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 10:15 AM   
     * */
    public function __set($name, $value) {
        $this->payment_arr[$name] = $value;
        return $this;
    }

    /**
     * @Description         : set person ID for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:40 PM   
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * @Description         : set type[Course=1, VIdeo_course =2] for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:41 PM   
     * */
    private $type;

    function set_type($type) {
        $this->type = $type;
        return $this;
    }

    /**
     * @Description         : set type_id[Course_id, VIdeo_course_id] for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:43 PM   
     * */
    private $type_id;

    function set_type_id($type_id) {
        $this->type_id = $type_id;
        return $this;
    }

    /**
     * @Description         : set currency for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:42 PM   
     * */
    private $currency;

    function set_currency($currency) {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @Description         : set Unit price ID for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:41 PM   
     * */
    private $unit_price;

    function set_unit_price($unit_price) {
        $this->unit_price = $unit_price;
        return $this;
    }

    /**
     * @Description         : set Discount price ID for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:41 PM   
     * */
    private $discounted_price;

    function set_discounted_price($discounted_price) {
        $this->discounted_price = $discounted_price;
        return $this;
    }

    /**
     * @Description         : set total price ID for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:41 PM   
     * */
    private $total_price;

    function set_total_price($total_price) {
        $this->total_price = $total_price;
        return $this;
    }

    /**
     * @Description         : set status for payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:41 PM   
     * */
    private $status;

    function set_status($status) {
        $this->status = $status;
        return $this;
    }

    /**
     * @Description         : set payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 06:49 PM   
     * */
    function set_payment_id($payment_id) {
        $this->payment_id = $payment_id;
        return $this;
    }

    /**
     * @Description         : set filed name ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-12-2016 05:11 PM   
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * @Description         : get insert ID [if payment data saved into database]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:52 PM   
     * */
    function get_insert_id() {
        $this->payment_id = $this->db->insert_id();
        return $this;
    }

    /**
     * @Description         : get payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:54 PM   
     * */
    function get_id() {
        return $this->payment_id;
    }

    /**
     * @Description         : generate payment INFO
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 05:15 PM   
     * */
    private $payment_info;

    function set_info() {
        $this->payment_info = $this->utility_model
                ->get_table_information('*', self::tbl_name, [self::primary_id => $this->payment_id]);
        return $this;
    }

    /**
     * @Description         : set payment information by person ID and course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-01-2016 03:44 PM   
     * */
    function set_payment_info_by_person_and_course_id() {
        $this->payment_info = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where(['person_id' => $this->person_id, 'payment_type' => $this->type, 'payment_type_id' => $this->type_id])->get()->row();
        return $this;
    }

    /**
     * @Description         : get payment INFO
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 05:13 PM   
     * */
    function get_info() {
        return $this->payment_info;
    }

    /**
     * @Description         : get payment amount status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 12:35 PM   
     * */
    private $total_paid_amount;

    function get_payment_amount_status() {
        // generate paid amount
        $this->generate_paid_amount();

        // if payment amount does not zero
        if (!empty($this->total_paid_amount)) {
            $currency_type = $this->invoice_payment_model->get_currency_type();
            // get payment information by payment ID
            $payment_info = $this->utility_model
                    ->get_table_information('payment_currency,discounted_price,unit_price,total_price', 'tbl_payment', ['payment_id' => $this->payment_id]);

            // if currency are same
            if ($currency_type == $payment_info->payment_currency) {
                $converted_amount = $this->total_paid_amount;
            }

            if (($currency_type == 1) && ($payment_info->payment_currency == 2)) {
                $converted_amount = $this->tt_currency->set($this->total_paid_amount, 'BDT', 'USD')->convert_currency()->get();
            }

            if (($currency_type == 2) && ($payment_info->payment_currency == 1)) {
                $converted_amount = $this->tt_currency->set($this->total_paid_amount, 'USD', 'BDT')->convert_currency()->get();
            }

            $payment_price = $payment_info->total_price - $payment_info->discounted_price;
//            // if paid all amount then return=>1 OR return=>2
            return ((ceil($converted_amount + 1)) >= $payment_price) ? 1 : 2;
        } else {
            return 2;
        }
    }

    /**
     * @Description         : get paid amount by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 12:35 PM   
     * */
    function generate_paid_amount() {
        // get all invoice ID by payment ID for check paid amount
        $all_invoice_id = $this->invoice_model->set_payment_id($this->payment_id)->get_all_id_by_payment_id();
        // get total paid amount by all invoice ID
        $this->total_paid_amount = $this->invoice_payment_model->set_invoice_id_array(explode(',', $all_invoice_id))
                ->get_paid_amount();
        return $this;
    }

    /**
     * @Description         : get total paid amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 03:04 PM   
     * */
    function get_total_paid_amount() {
        return $this->total_paid_amount;
    }

    /**
     * @Description         : get all payment ID by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 06:36 PM   
     * */
    function get_all_id_by_person_id() {
        return $this->db->select('GROUP_CONCAT(payment_id) AS id')
                        ->from(self::tbl_name)->where('person_id', $this->person_id)->get()->row()->id;
    }
    
    /**
     * @Description         : get_partial_payment_id
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 02-04-2017 10:22 AM   
     * */
    function get_partial_payment_id($person_id, $course_url){
        $this->db->select('payment_id')
            ->from('tbl_url AS u')
            ->join('tbl_course AS c','u.url_id = c.url_id')
            ->join('tbl_payment AS p','c.course_id = p.payment_type_id')
            ->where('p.person_id', $person_id)
            ->where('u.url', $course_url);
        
        return $this->db->get()->row()->payment_id;
    }

    /**
     * @Description         : get all payment ID by course/video course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:49 PM   
     * */
    function set_all_id_by_type_id() {
        $this->payment_info = $this->db->select('GROUP_CONCAT(payment_id) AS id')
                        ->from(self::tbl_name)->where(['payment_type' => $this->type, 'payment_type_id' => $this->type_id])->get()->row();
        return $this;
    }
    
    /**
     * @Description         : get_total_invoice_info_by_person_id
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 3-4-2017 10:30 AM   
     * */
    function get_total_invoice_info_by_person_id($person_id){
        $this->db->select('*')
                ->from('tbl_invoice AS inv')
                ->join('tbl_payment AS p','p.payment_id = inv.payment_id')
                ->where('p.person_id', $person_id);
        return $this->db->get()->result_array();
        
    }
    /**
     * @Description         : get_total_invoice_payment_info_by_person_id
     * @Developed By        : MD Delwar Hossain
     * @Start DateTime      : 3-4-2017 11:40 AM   
     * */
    function get_total_invoice_payment_info_by_person_id($person_id){
        $this->db->select('p.payment_id, invp.paid_amount, invp.currency_type, inv.invoice_id')
                ->from('tbl_invoice_payment AS invp')
                ->join('tbl_invoice AS inv', 'invp.invoice_id = inv.invoice_id')
                ->join('tbl_payment AS p','p.payment_id = inv.payment_id')
                ->where('p.person_id', $person_id);
        return $this->db->get()->result_array();
    }
    
    /**
     * @Description         : generate due amount by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-11-2016 06:21 PM    
     * */
    function generate_due_amount() {
        // get payment information by payment information ID
        $payment_info = $this->utility_model
                ->get_table_information('payment_currency,total_price,discounted_price', 'tbl_payment', ['payment_id' => $this->payment_id]);

        // get total paid amount
        $paid_amount = $this->generate_paid_amount()->get_total_paid_amount();

        // get due amount
        $due_amount = (($payment_info->total_price - $payment_info->discounted_price) - $paid_amount);

        if ($this->currency == $payment_info->payment_currency) {
            $this->due_amount = $due_amount;
        }

        if (($this->currency == 1) && ($payment_info->payment_currency == 2)) {
            $this->due_amount = $this->tt_currency->set($due_amount, 'USD', 'BDT')->convert_currency()->get();
        }

        if (($this->currency == 2) && ($payment_info->payment_currency == 1)) {
            $this->due_amount = $this->tt_currency->set($due_amount, 'BDT', 'USD')->convert_currency()->get();
        }
        return $this;
    }

    /**
     * @Description         : set payment person country code
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:05 AM    
     * */
    private $country_code;

    function set_country_code($country_code) {
        $this->country_code = $country_code;
        return $this;
    }

    /**
     * @Description         : set payment amount data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 11:07 AM    
     * */
    private $payment_amount_data = [];

    function set_payment_amount_data($payment_amount_data) {
        $this->payment_amount_data = $payment_amount_data;
        return $this;
    }

    /**
     * @Description         : generate payment amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:05 AM    
     * */
    function generate_invoice_payment_amount() {
        // if user are BDT and payment currency are BDT
        if ($this->country_code == 'BD' && $this->payment_info->payment_currency == 1) {
            $this->set_payment_amount();
        }

        // if user are BDT and payment currency are USD
        if ($this->country_code == 'BD' && $this->payment_info->payment_currency == 2) {
            $this->convert_usd_to_bdt();
        }

        // if user are USD and payment currency are BDT
        if ($this->country_code != 'BD' && $this->payment_info->payment_currency == 1) {
            $this->convert_bdt_to_usd();
        }

        // if user are USD and payment currency are USD
        if ($this->country_code != 'BD' && $this->payment_info->payment_currency == 2) {
            $this->set_payment_amount();
        }
        return $this;
    }

    /**
     * @Description         : get same invoice amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:18 AM    
     * */
    function set_payment_amount() {
        $this->payment_amount_data['total_price'] = $total = $this->payment_info->total_price;
        $this->payment_amount_data['unit_price'] = $this->payment_info->unit_price;
        $this->payment_amount_data['discount_price'] = $discount = $this->payment_info->discounted_price;
        $this->payment_amount_data['paid_amount'] = $paid = (empty($this->total_paid_amount)) ? 0 : $this->total_paid_amount;
        $this->payment_amount_data['due_amount'] = (($total - $discount) - $paid);
        $this->payment_amount_data['currency_sign'] = ($this->currency == 1) ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
        return $this;
    }

    /**
     * @Description         : convert payment amount BDT to USD
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:23 AM    
     * */
    function convert_bdt_to_usd() {
        $this->payment_amount_data['total_price'] = $total = $this->tt_currency->set($this->payment_info->total_price, 'BDT', 'USD')->convert_currency()->get();
        $this->payment_amount_data['unit_price'] = $this->tt_currency->set($this->payment_info->unit_price, 'BDT', 'USD')->convert_currency()->get();
        $this->payment_amount_data['discount_price'] = $discount = ($this->payment_info->discounted_price != 0) ?
                $this->tt_currency->set($this->payment_info->discounted_price, 'BDT', 'USD')->convert_currency()->get() : 0;
        $this->payment_amount_data['paid_amount'] = $paid = (empty($this->total_paid_amount)) ? 0 : $this->total_paid_amount;
        $this->payment_amount_data['due_amount'] = (($total - $discount) - $paid);
        $this->payment_amount_data['currency_sign'] = ($this->currency == 1) ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
        return $this;
    }

    /**
     * @Description         : convert payment amount USD to BDT
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:30 AM    
     * */
    function convert_usd_to_bdt() {
        $this->payment_amount_data['total_price'] = $total = $this->tt_currency->set($this->payment_info->total_price, 'USD', 'BDT')->convert_currency()->get();
        $this->payment_amount_data['unit_price'] = $this->tt_currency->set($this->payment_info->unit_price, 'USD', 'BDT')->convert_currency()->get();
        $this->payment_amount_data['discount_price'] = $discount = ($this->payment_info->discounted_price != 0) ?
                $this->tt_currency->set($this->payment_info->discounted_price, 'USD', 'BDT')->convert_currency()->get() : 0;
        $this->payment_amount_data['paid_amount'] = $paid = (empty($this->total_paid_amount)) ? 0 : $this->total_paid_amount;
        $this->payment_amount_data['due_amount'] = (($total - $discount) - $paid);
        $this->payment_amount_data['currency_sign'] = ($this->currency == 1) ? '&nbsp;&#x9f3;' : '&nbsp;&#x24;';
        return $this;
    }

    /**
     * @Description         : get payment amount for invoice
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 10:38 AM    
     * */
    function get_payment_amount() {
        return $this->payment_amount_data;
    }

    /**
     * @Description         : get due amount by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-11-2016 06:21 PM    
     * */
    private $due_amount;

    function get_due_amount() {
        return $this->due_amount;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 04:44 PM    
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : set limit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-12-2016 04:58 PM    
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : set payment earning infomation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-12-2016 04:41 PM    
     * */
    function set_earning_info() {
        $this->payment_info = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where('payment_type', $this->type)
                        ->where_in('payment_type_id', $this->type_id)
                        ->group_by('payment_type_id')
                        ->limit(10, $this->limit)->get()->result();
        return $this;
    }
    
    

    /**
     * @Description         : set payment information by course/Video Course ID and Person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-01-2017 12:03 PM    
     * */    
    function set_payment_info_by_person_id() {
        $this->result = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where('payment_type', $this->type)
                        ->where('payment_type_id', $this->type_id)
                        ->where('person_id', $this->person_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set all organization person ID if there any course register any student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2017 11:58 AM    
     * */
    function set_organization_id_course_payment_info() {
        $this->db->select('GROUP_CONCAT(DISTINCT(p.person_id)) AS id')
                ->from('tbl_payment AS py')
                ->join('tbl_course AS c', 'py.payment_type_id = c.course_id')
                ->join('tbl_person AS p', 'c.person_id = p.person_id')
                ->where('py.payment_type', 1)->where('p.person_role', 4);
        $this->result = $this->db->get()->row();
        return $this;
    }

    /**
     * @Description         : set all Individual teacher ID if there any course register any student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-02-2017 12:02 PM    
     * */
    function set_individual_teacher_id_course_payment_info() {
        $this->db->select('GROUP_CONCAT(DISTINCT(p.person_id)) AS id')
                ->from('tbl_payment AS py')
                ->join('tbl_course AS c', 'py.payment_type_id = c.course_id')
                ->join('tbl_person AS p', 'c.person_id = p.person_id')
                ->where('py.payment_type', 1)->where('p.person_role', 3);
        $this->result = $this->db->get()->row();
        return $this;
    }

    /**
     * @Description         :view payment notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-12-2016 04:11 PM    
     * */
    function view_payment_notification() {
        $data = [];
        $todays_date = date('Y/m/d', (time() - $this->session->time_offset));
        $data['todays_notification'] = $this->notification_model
                        ->set_notify_to($this->person_id)
                        ->set_notification_type([7, 8])
                        ->set_notification_date_time($todays_date)
                        ->total_notification_by_date()->get_result();

        $data['read_notification'] = $this->notification_model
                        ->total_read_notification()->get_result();

        $data['unread_notification'] = $this->notification_model
                        ->total_unread_notification()->get_result();
        $this->result = $data;
        return $this;
    }

    /**
     * @Description         : get all payment info by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-01-2017 11:01 AM   
     * */
    function all_payment_info_by_person_id() {
        $this->result = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where('person_id', $this->person_id)
                        ->where('payment_type', $this->type)
                        ->where_in('payment_status', $this->status)
                        ->get()->result();
        return $this;
    }

    /**
     * @Description         : set all payment information by Course/Video Course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-02-2017 03:49 PM   
     * */
    function set_payment_info_by_payment_type_id() {
        $this->result = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where('payment_type', $this->type)
                        ->where_in('payment_type_id', $this->type_id)
                        ->where_in('payment_status', $this->status)
                        ->get()->result();
        return $this;
    }

    /**
     * @Description         : set all payment ID by Course/Video Course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-02-2017 03:49 PM   
     * */
    function set_payment_id_by_payment_type_id() {
        $this->result = $this->db->select('GROUP_CONCAT(payment_id) AS id')->from(self::tbl_name)
                        ->where('payment_type', $this->type)
                        ->where_in('payment_type_id', $this->type_id)
                        ->where_in('payment_status', $this->status)
                        ->get()->row();
        return $this;
    }
    

    /**
     * @Description         : save paymnet information in payment table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:45 PM   
     * */
    private $payment_id;

    function save() {
        $data = [];
        $data['person_id'] = $this->person_id;
        $data['payment_type'] = $this->type;
        $data['payment_type_id'] = $this->type_id;
        $data['payment_currency'] = $this->currency;
        $data['unit_price'] = $this->unit_price;
        $data['discounted_price'] = $this->discounted_price;
        $data['total_price'] = $this->total_price;
        $data['payment_status'] = $this->status;
        $this->db->insert(self::tbl_name, $data);
        return $this;
    }

    /**
     * @Description         : update payment table data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 10:13 AM   
     * */
    function update() {
        $this->db->where(self::primary_id, $this->payment_id)
                ->update(self::tbl_name, $this->payment_arr);
        return $this;
    }

    /**
     * @Description         : delete payment table data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:42 PM   
     * */
    function delete() {
        $this->db->where(self::primary_id, $this->payment_id)->delete(self::tbl_name);
    }

    /**
     * @Description         : destruct all variable
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 02:39 PM   
     * */
    function __destruct() {
        if (!empty($this->currency)) {
            unset($this->currency);
        }
        if (!empty($this->discounted_price)) {
            unset($this->discounted_price);
        }
        if (!empty($this->payment_arr)) {
            unset($this->payment_arr);
        }
        if (!empty($this->payment_id)) {
            unset($this->payment_id);
        }
        if (!empty($this->person_id)) {
            unset($this->person_id);
        }
        if (!empty($this->status)) {
            unset($this->status);
        }
        if (!empty($this->total_price)) {
            unset($this->total_price);
        }
        if (!empty($this->type)) {
            unset($this->type);
        }
        if (!empty($this->type_id)) {
            unset($this->type_id);
        }
        if (!empty($this->unit_price)) {
            unset($this->unit_price);
        }        
        if(!empty($this->payment_status)){
            unset($this->payment_status);
        }
    }
    
    /**
     * @Function            : get_user_payment_method_info
     * @Description         : Get User Payment Method
     * @Developed By        : Md. Delwar Hossain
     * @Start DateTime      : 19-4-2017 04:39 PM   
     * */
    function get_user_payment_method_info($person_id){
        $data['bkash_info'] = $this->db->select('*')
                ->from('tbl_person_bkash_payment_info')
                ->where('person_id', $person_id)
                ->get()->row();
        
        $data['check_info'] = $this->db->select('*')
                ->from('tbl_person_check_payment_info')
                ->where('person_id', $person_id)
                ->get()->row();
        
        return $data;
    }

    /*
      ---------------------------------------------------------------------------------------------
     */
    
    /*====================================
    Payment withdral section start here
    ====================================*/
    
    /**
     * @Function            : send_payment_request 
     * @Description         : saves payment request to database
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $payment_request_detail
     * @Status              : Available       
     * */
    public function send_payment_request($payment_request_detail){
        $this->db->insert('tbl_person_payment_request', $payment_request_detail);
    }
    
    
    /**
     * @Function            : check_payment_request_exist 
     * @Description         : Checks payment request already exist or not
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $payment_type_id
     * @Status              : Available       
     * */
    public function check_payment_request_exist($payment_type_id){
        $result = $this->db->select('*')->from('tbl_person_payment_request')
                       ->where('person_id', $this->session->person_id)
                       ->where('payment_type_id', $payment_type_id)
                       ->where('person_payment_request_status', 1)
                       ->count_all_results();
        return $result;
    }
    
    
    /**
     * @Function            : update_payment_status 
     * @Description         : Updates the payment status in payment table
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 27-04-17
     * @Parameter           : $payment_id
     * @Status              : Available       
     * */
    public function update_payment_status($payment_id){
        $this->db->set('payment_status', 9)
                 ->where_in('payment_id', $payment_id)
                 ->update('tbl_payment');
    }
    
    /**
     * @Function            : get_confirmed_payment_by_person_id 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 29-04-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_confirmed_payment_by_person_id($person_id){
        $result = $this->db->select('payment_amount')
                        ->from('tbl_person_payment_request')
                        ->where('person_id', $person_id)
                        ->where('person_payment_request_status', 2)
                        ->get()->result();
        return $result;
    }
    
    
    /**
     * @Function            : get_all_payment_request_by_course_url 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 29-04-17
     * @Parameter           : $course_url
     * @Status              : Available       
     * */
    function get_all_payment_request_by_course_url($course_url){
        $result = $this->db->select('tppr.*, tu.*, tc.course_name')
                    ->from('tbl_person_payment_request AS tppr')
                    ->join('tbl_course AS tc', 'tc.course_id = tppr.payment_type_id')
                    ->join('tbl_url AS tu','tu.url_id = tc.url_id')
                    ->where('tu.url', $course_url)
                    ->where('tu.url_type', 5)
                    ->get()->result(); 
        
        return $result;
    }
    
    
    /**
     * @Function            : confirm_payment_request 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Parameter           : $course_id
     * @Status              : Available       
     * */
    function confirm_payment_request($course_id){
        $this->db->where('payment_type_id', $course_id)
                ->where('person_payment_request_status', 1)
                ->set('person_payment_request_status', 2)
                ->update('tbl_person_payment_request');
    }
    
    
    /**
     * @Function            : get_course_id_by_url 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Status              : Available       
     * */
    function get_course_id_by_url(){
        $course_url = trim($this->input->post('course_url', TRUE));
        $result = $this->db->select('tc.course_id')
                        ->from('tbl_url AS tu')
                        ->join('tbl_course AS tc', 'tc.url_id = tu.url_id')
                        ->where('tu.url', $course_url)
                        ->where('tu.url_type', 5)
                        ->get()->row();
        return $result;
    }
    
    
    /**
     * @Function            : get_course_id_by_url 
     * @Developed By        : Md. Md Mashqur Ul Alam
     * @Start DateTime      : 30-04-17
     * @Parameter           : $person_id
     * @Status              : Available       
     * */
    function get_all_payment_request_by_user_id($person_id){
        $result = $this->db->select('*')
                           ->from('tbl_person_payment_request')
                           ->where('person_id', $person_id)
                           ->get()->result();
        return $result;
    }
    
}
