<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => All kind of Organization Information Query
 *
 * @author MD Jaherul Islam
 * @Date : 21-07-16
 */
class Organization_model extends CI_Model {

    private $tbl_name = '';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : select_single_organization_info_by_person_id 
     * @Used IN             : @function-'save_resource_person_info'      this[@Model] 
     * @Description         : get single organization information using person_id
     *                        @Update1=> Convert Active Query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 12:04 PM
     * @Updated Date Time   : 07-09-2016 06:21 PM
     * @Updated By          : MD Jaherul Islam      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $organization_info[ARRAY]         
     * @Status              : available      
     * */
    function select_single_organization_info_by_person_id($person_id) {
        return $this->db->get_where('tbl_organization', Array('person_id' => $person_id))->row();
    }

    /**
     * @Function            : orgnization_info_with_resource_person_by_person_id 
     * @Used IN             : @function-'get_all_course_created_by_person_id'      profile_model[@Model] 
     * @Description         : get single organization information using  person ID 
     *                        @Update1=> Convert Active Query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-08-2016 06:43 PM 
     * @Updated Date Time   : 07-09-2016 06:21 PM
     * @Updated By          : MD Jaherul Islam           
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $organization_info[ARRAY]         
     * @Status              : available      
     * */
    function orgnization_info_with_resource_person_by_person_id($person_id) {
        return $this->db->select('*')
                        ->from('tbl_resource_person AS rp')
                        ->join('tbl_organization_resource_person AS orp', 'rp.resource_person_id = orp.resource_person_id')
                        ->join('tbl_organization AS o', 'orp.organization_id = o.organization_id')
                        ->join('tbl_person AS p', 'o.person_id = p.person_id')
                        ->join('tbl_url AS u', 'p.url_id = u.url_id')
                        ->where('rp.person_id', $person_id)->get()->row();
    }

    /**
     * @Function            : organization_information_by_resource_person_id 
     * @Used IN             : @function-'get_information_for_course'      user_course_model[@Model] 
     * @Description         : get single organization information using resource_person_id
     *                        @Update1=> Convert Active Query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-08-2016 10:37 AM 
     * @Updated Date Time   : 07-09-2016 06:21 PM
     * @Updated By          : MD Jaherul Islam           
     * @Parameter           : $resource_person_id[INTEGER]
     * @Return              : $organization_info[ARRAY]         
     * @Status              : available      
     * */
    function organization_information_by_resource_person_id($resource_person_id) {
        return $this->db->select('*')
                        ->from('tbl_organization_resource_person AS orp')
                        ->join('tbl_organization AS o', 'orp.organization_id = o.organization_id')
                        ->where('orp.resource_person_id', $resource_person_id)
                        ->get()->row();
    }

    /**
     * @Function            : save_organization_resource_person 
     * @Used IN             : @function-'save_resource_person_info'      resource_person_model[@Model] 
     * @Description         : save organization resource person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-08-2016 10:53 AM      
     * @Parameter           : $resource_person_id[INTEGER](new Resource person ID if select 'other' option),
     *                        $organization_id[INTEGER]
     * @Return              : Null      
     * @Status              : available      
     * */
    function save_organization_resource_person($resource_person_id, $organization_id) {
        $data = Array();
        $data['organization_id'] = $organization_id;
        $data['resource_person_id'] = $resource_person_id;
        $this->db->insert('tbl_organization_resource_person', $data);
    }

    /**
     * 
     * @Description         : set organization data
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:22 PM         
     * */
    private $org_data = [];

    function __set($name, $value) {
        $this->org_data[$name] = $value;
        return $this;
    }

    /**
     * 
     * @Description         : set blank array
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 05:47 PM         
     * */
    function set_empty() {
        $this->org_data = [];
        return $this;
    }

    /**
     * 
     * @Description         : set table name
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 05:51 PM         
     * */
    function set_table_name($table_name) {
        $this->tbl_name = $table_name;
        return $this;
    }

    /**
     * 
     * @Description         : save organization data
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:24 PM         
     * */
    function save() {
        $this->db->insert($this->tbl_name, $this->org_data);
        return $this;
    }

    /**
     * 
     * @Description         : create insert ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:26 PM         
     * */
    private $organization_id;

    function create_insert_id() {
        $this->organization_id = $this->db->insert_id();
        return $this;
    }

    /**
     * 
     * @Description         : get organization ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 04:26 PM         
     * */
    function get_id() {
        return $this->organization_id;
    }

}
