<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of notification_model
 *
 * @author Afrin Jahan Noumin
 */
class Notification_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : delete_after_one_month_notification
     * @Description         : delete notification after one month
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-10-2016 03:57 PM  
     * @Parameter           : Null
     * @Return              : Null
     * @Status              : available      
     * */
    function delete_after_one_month_notification() {
        $notification_id = $this->get_after_one_month_notification();

        if ($notification_id != '') {
            $this->utility_model->delete_multiple_field_in_table('tbl_notification', 'notification_id', $notification_id);
            $this->utility_model->delete_multiple_field_in_table('tbl_notification_type_info', 'notification_id', $notification_id);
        }
    }

    /*
      -----------@@@RIPON@ Start manage front end View notification (29-09-16)----------------------------------
     */

    /**
     * @Function            : notification view
     * @Used IN             : @function-'view_notification'      notification[@Conroller]
     * @Description         : view all notification for front end User
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-09-2016 12:00 PM 
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $data[notification_info]
     * @Status              : available      
     * */
    function get_all_notification_data($data, $person_id, $selected_date, $start_limit, $end_limit) {
        $data['all_notification'] = $this->get_all_notification_by_person_id($person_id, $selected_date, $start_limit, $end_limit);
        
        foreach ($data['all_notification'] as $notification_value) {
            $data['notify_by_info'][$notification_value->notification_id] = $this->person_model
                    ->set_person_id($notification_value->notify_by)
                    ->set_field_name('person_first_name,person_last_name,person_image,url,person_role')
                    ->set_info_with_url_by_id()
                    ->get_info();

            $data['notification_seen_info'][$notification_value->notification_id] = $this->tt_notification
                    ->get_notification_seen_info($person_id, $notification_value->notification_view_by);

            $data['notification_message'][$notification_value->notification_id] = $this->set_person_id($person_id)
                    ->set_notification_description($notification_value->notification_description)
                    ->get_notification_message();

            $data['notification_date_time'][$notification_value->notification_id] = $this->tt_notification->calculate_notification_date_time($notification_value->notification_date_time);
        }
        return $data;
    }

    /**
     * @Function            : get_all_notification_by_person_id
     * @Used IN             : @function-'get_all_notification_data'      this[@Model]
     * @Description         : get all notification by user ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-09-2016 12:28 PM 
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $notification_data[Array]
     * @Status              : available      
     * */
    function get_all_notification_by_person_id($person_id, $selected_date, $start_limit, $end_limit) {
        $this->db->select('*')->from('tbl_notification AS n')
                ->join('tbl_notification_type_info AS nti', 'n.notification_id = nti.notification_id')
                ->where("FIND_IN_SET('$person_id',n.notify_to)!=", 0);
        if ($selected_date == '') {
            $this->db->where('(DATE(n.notification_date_time) > CURDATE() - INTERVAL 30 DAY)');
        } else {
            $this->db->where("DATE(n.notification_date_time)", $selected_date);
        }
        $this->db->order_by('n.notification_id', 'desc')->limit($end_limit, $start_limit);
        return $this->db->get()->result();
    }

    /**
     * @Function            : get_all_unseen_notifiction_id
     * @Used IN             : @function-'mark_all_as_read'      notification[@Controller]
     * @Description         : get all unseen notification ID by person ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-10-2016 10:38 PM 
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $all_notification[String]
     * @Status              : available      
     * */
    function get_all_unseen_notifiction_id($person_id, $selected_date = '') {
        $sql = "SELECT GROUP_CONCAT(notification_id) AS id
                FROM tbl_notification 
                WHERE FIND_IN_SET('$person_id',notify_to) 
                AND (notification_view_by IS NULL OR NOT FIND_IN_SET('$person_id',notification_view_by))";
        if ($selected_date != '') {
            $sql.="AND DATE(notification_date_time) = '$selected_date'";
        }
        return $this->db->query($sql)->row()->id;
    }

    /**
     * @Function            : get_total_unseen_notification
     * @Used IN             : @function-'get_all_notification_data'      this[@Model]
     * @Description         : get total unseen notification by nperson ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 05:46 PM 
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $total_notification[INTEGER]
     * @Status              : available      
     * */
    function get_total_unseen_notification($person_id) {
        $sql = "SELECT count(*) AS total 
                FROM tbl_notification 
                WHERE FIND_IN_SET('$person_id',notify_to) 
                AND (notification_view_by IS NULL OR NOT FIND_IN_SET('$person_id',notification_view_by))";
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : get_after_one_month_notification
     * @Used IN             : @function-'delete_after_one_month_notification'      notification[@Controller]
     * @Description         : get after one month notification ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-10-2016 04:04 PM 
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $notification_id[String]
     * @Status              : available      
     * */
    function get_after_one_month_notification() {
        $sql = "SELECT GROUP_CONCAT(notification_id) AS id
                FROM tbl_notification 
                WHERE (DATE(notification_date_time) < CURDATE() - INTERVAL 30 DAY)";
        return $this->db->query($sql)->row()->id;
    }

    /*
      -----------@@@RIPON@ End manage front end View notification (29-09-16)----------------------------------
     */

    /**
     * @Function            : select_person_by_person_id()
     * @Used IN             : get notificaqtion sender person info
     * @Description         : get notificaqtion sender person info 
     * @Developed By        : Afrin jahan noumin
     * @Start DateTime      : 19/04/2016  
     * @Status              : available      
     * */
    function select_person_by_person_id($notify_by) {
        $sql = "SELECT * FROM tbl_person as p , tbl_url as u WHERE p.person_id='$notify_by' AND u.url_id= p.url_id ";
        $result = $this->db->query($sql)->row();
        return $result;

// return result
    }

    /**
     * @Function            : view_count_all_notification_for_user
     * @Used IN             : @views/user.master.php,
     * @Description         : get latest 5 notification for user header notification menu 
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $user_id -> logged in person id from session
     * @View                : None
     * @Redirect            : None
     * @Return              : $result -> return all latest 5 notification for that user    
     * @Status              : Available       
     */
    function view_count_all_notification_for_user($user_id) {
        $sql = "SELECT * FROM tbl_notification WHERE FIND_IN_SET('$user_id',notify_to) ORDER BY  notification_date_time DESC  LIMIT 5";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            : count_all_unseen_notification
     * @Used IN             : @views/user.master.php,
     * @Description         : get totall number of unseen notification
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $person_id -> logged in person id from session
     * @View                : None
     * @Redirect            : None
     * @Return              : $result -> return all unseen notification for that user    
     * @Status              : Available       
     */
    function count_all_unseen_notification($person_id) {
        $sql = "SELECT * FROM tbl_notification WHERE FIND_IN_SET('$person_id',notify_to) AND (notification_view_by IS NULL OR NOT FIND_IN_SET('$person_id',notification_view_by))";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            : get_all_read_notification 
     * @Used IN             : @function-'view_admin_notification_information'   this[@Model],
     * @Description         : get all read notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 05:21 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_all_read_notification($person_id) {
        $sql = "SELECT count(*) AS total 
                FROM tbl_notification 
                WHERE 
                    FIND_IN_SET('$person_id',notify_to) 
                AND FIND_IN_SET('$person_id',notification_view_by)";
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : get_all_unread_notification 
     * @Used IN             : @function-'view_admin_notification_information'   this[@Model],
     * @Description         : get all unread notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 05:21 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_all_unread_notification($person_id) {
        $sql = "SELECT count(*) AS total  
                FROM tbl_notification 
                WHERE 
                    FIND_IN_SET('$person_id',notify_to) 
                AND (notification_view_by IS NULL OR NOT FIND_IN_SET('$person_id',notification_view_by))";
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : get_todays_all_notification 
     * @Used IN             : @function-'view_admin_notification_information'   this[@Model],
     * @Description         : get todays all notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 06:02 PM
     * @Parameter           : $person_id[INTEGER],$date[DATE]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_todays_all_notification($person_id, $date) {
        $sql = "SELECT count(*) AS total  
                FROM tbl_notification AS n
                WHERE 
                    FIND_IN_SET('$person_id',notify_to)
                    AND DATE(n.notification_date_time) = '$date'";
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : check_user_id_exit_in_notification_view_or_not
     * @Used IN             : in various function for check person already seen a notification or not 
     * @Description         : check  person's id already in  notification_view_by in tbl_notification or not
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $user_id -> logged in person id from session,$notification_id->for specific notification
     * @View                : None
     * @Redirect            : None
     * @Return              : $result -> return result if notification seen by that person    
     * @Status              : Available       
     */
    function check_user_id_exit_in_notification_view_or_not($user_id, $notification_id) {
        $sql = "SELECT * FROM tbl_notification WHERE notification_id='$notification_id' AND FIND_IN_SET('$user_id',notification_view_by)";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : check_another_user_id_exit_notification_view_or_not
     * @Used IN             : in various function for check another person  seen a notification or not 
     * @Description         : check another person's id already in  notification_view_by in tbl_notification or not.
      if another person is already in notification_view_by  then it will save comma saparatedly;
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $notification_id->for specific notification
     * @View                : None
     * @Redirect            : None
     * @Return              : $result -> return result if notification seen by that another person    
     * @Status              : Available       
     */
    function check_another_user_id_exit_notification_view_or_not($notification_id) {
        $sql = "SELECT * FROM tbl_notification WHERE notification_id='$notification_id' AND notification_view_by IS NOT NULL   ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : check_user_id_exit_in_notification_view_or_not
     * @Used IN             : in various function for check person already seen a notification or not 
     * @Description         : check  person's id already in  notification_view_by in tbl_notification or not
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $user_id -> logged in person id from session,$notification_id->for specific notification
     * @View                : None
     * @Redirect            : None
     * @Return              : $result -> return result if notification seen by that person    
     * @Status              : Available       
     */
    function select_this_notification_seen_or_unseen($notification_id, $user_id) {
        $sql = "SELECT * FROM tbl_notification WHERE   notification_id='$notification_id' AND (FIND_IN_SET('$user_id',notification_view_by) )";
        $result = $this->db->query($sql)->row();
        return $result;
    }

//................................ start view all notification in view notification................

    /**
     * @Function            : select_all_30days_notification
     * @Used IN             : @controller(notification.php)function(view_notification)
     * @Description         : select all notification for 30 days for specific person
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $person_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result-> 30 days notification notfication for that user 
     * @Status              : Available       
     */
    function select_all_30days_notification($person_id) {
        $sql = "SELECT * , DATE_FORMAT(notification_date_time, '%m/%d/%Y') FROM tbl_notification WHERE FIND_IN_SET('$person_id',notify_to) AND  (DATE(notification_date_time) > CURDATE() - INTERVAL 30 DAY )   ORDER BY  notification_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            : select_date_wise_notification
     * @Used IN             : @controller(notification.php)function(view_notification)
     * @Description         : select date_wise_notification  for specific person
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $person_id
     * @View                : None
     * @Redirect            : None
     * @Return              :  $result->date wise notification notfication for that user  
     * @Status              : Available       
     */
    function select_date_wise_notification($all_notification_id_array, $all_notification_id) {
        if (count($all_notification_id) > 1) {
            $sql = "SELECT * FROM tbl_notification WHERE notification_id IN ($all_notification_id_array)";
            $result = $this->db->query($sql)->result();
            return $result;
        } else if (count($all_notification_id) == 1) {
            $sql = "SELECT * FROM tbl_notification WHERE notification_id = '$all_notification_id_array' ";
            $result = $this->db->query($sql)->result();
            return $result;
        }
    }

    /**
     * @Function            : view_all_date_notification_for_user
     * @Used IN             : @controller(notification.php)function(getdateTime())
     * @Description         : select date_wise_notification  for specific person
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 19/04/2016
     * @Updated By          :       
     * @Parameter           : $person_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result->all notfication for that user   
     * @Status              : Available       
     */
    function view_all_date_notification_for_user($user_id) {
        $sql = "SELECT * FROM tbl_notification WHERE FIND_IN_SET('$user_id',notify_to) ORDER BY  notification_date_time DESC";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//................................ end view all notification in view notification................
//-------save notification for group post----------
    /**
     * @Function            : save_post_notification_for_group_post
     * @Used IN             : @controller post.php in various function
     * @Description         : If a user post a note/alert/assignment/video or image then a notification is saved in tbl_notification
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $group_id_array->group ids in which user post a note, $selected_id-> type info id (post_id),$type->1(note),2(alert),3(assignment),4(photo/video).
     * @View                : None
     * @Redirect            : None
     * @Return              : None   
     * @Status              : Available       
     */
    function save_post_notification_for_group_post($group_id_array, $post_id, $type, $status) {
        $member_person_id_array = array();

        if ($group_id_array[count($group_id_array) - 1] == '') {
            array_pop($group_id_array);
        }
        $group_id_by_comma = implode(",", $group_id_array);
        $member_list = $this->select_group_member_for_notification($group_id_by_comma, $group_id_array);
        foreach ($member_list as $val_member) {
            $member_person_id_array[] = $val_member->person_id;
        }
        $member_person_id = array_filter(array_unique($member_person_id_array));

        $person_info = $this->person_model->set_person_id($this->session->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();

        $all_group_name = $this->group_model->get_concat_multiple_group_name_by_post_id($post_id);
        $group_name = (strlen($all_group_name) > 50) ? mb_substr($all_group_name, 0, 50, 'utf-8') . '..' : $all_group_name;

        $notification_description = [];
        $notification_description[1] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> have ' . $status . ' ' . $type . ' in group <strong>' . $group_name . '</strong>';
        $notification_description[$this->session->person_id] = '<strong>You</strong> have ' . $status . ' ' . $type . ' in group <strong>' . $group_name . '</strong>';

        if (count($member_person_id) > 0) {
            foreach ($member_person_id as $value) {
                if ($value != $this->session->person_id) {
                    $notification_description[$value] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> have ' . $status . ' ' . $type . ' in group <strong>' . $group_name . '</strong>';
                }
            }
        }

        $this->notification_description = serialize($notification_description);
        $this->notify_by = $this->session->person_id;
        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_type = 3;
        $this->notification_type_id = $post_id;

        $this->save_notification();
    }

    /**
     * @Description         : save notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-01-2016 06:40 PM   
     * */
    function save_notification() {
        // save notification information
        $this->notification_model
                ->set_notify_by($this->notify_by)
                ->set_notify_to($this->notify_to)
                ->set_notification_description($this->notification_description)
                ->set_notification_type($this->notification_type)
                ->save();

        // save notification type 
        $this->notification_model->set_insert_id()
                ->set_notification_type_info_id($this->notification_type_id)
                ->save_type_info();
        return $this;
    }

    /**
     * @Function            : select_group_member_for_notification
     * @Used IN             : @model notification_model.php(function select_group_member_for_notification)
     * @Description         : when give a post to groups it fetch all the member of the selected group.
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $group_id_array->group ids in which user post a note, $group_id-> all the group id in array.
     * @View                : None
     * @Redirect            : None
     * @Return              : $result  
     * @Status              : Available       
     */
    function select_group_member_for_notification($group_id, $group_id_array) {
        if (count($group_id_array) == 1) {
            $sql = "SELECT * FROM  tbl_group_member WHERE group_id =$group_id";
            $result = $this->db->query($sql)->result();
            return $result;
        } else if (count($group_id_array) > 1) {
            $sql = "SELECT * FROM  tbl_group_member WHERE group_id IN ($group_id)";
            $result = $this->db->query($sql)->result();
            return $result;
        }
    }

    /**
     * @Function            : save_group_post_notification
     * @Used IN             : @model notification_model.php (save_post_notification_for_group_post)
     * @Description         : save notification for group post in tbl_notification .
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $person_id_by_comma->group_member’s_id ,$selected_id->group’s_id
     * @View                : None
     * @Redirect            : None
     * @Return              : None   
     * @Status              : Available       
     */
    function save_group_post_notification($person_id_by_comma, $selected_id) {
        $data = array();
        $sdata = array();
        $notify_by = $this->session->userdata('user_id');
        $time = date('Y/m/d H:i:s', (time()));
        $data['notification_date_time'] = $time;
        $data['notify_by'] = $notify_by;
        $data['notify_to'] = $person_id_by_comma;
        $data['notification_type'] = 3; // type>3 for person's post to a scpecific groups.     
        $this->db->insert('tbl_notification', $data);
        $notification_id = $this->db->insert_id();

        if ($selected_id) {

            $sdata['notification_id'] = $notification_id;
            $sdata['notification_type_id'] = $selected_id;
            $this->db->insert('tbl_notification_type_info', $sdata);
        }
    }

    /**
     * @Function            : select_group_info_for_notification
     * @Used IN             : save_group_post_notification
     * @Description         : Select group information
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $group_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result->group info  
     * @Status              : Available       
     */
    function select_group_info_for_notification($group_id) {
        $sql = "SELECT * FROM  tbl_group WHERE group_id ='$group_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : select_all_notification_type_info
     * @Used IN             : Header_menu.php
      view_notification.php
     * @Description         : Select notification type info 
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 19/04/2016
     * @Updated Date Time   : 07/06/2016   
     * @Updated By          :   
     * @Parameter           : $notification_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result-> notification info id for that  notfication for that user   
     * @Status              : Available       
     */
    function select_all_notification_type_info($notification_id) {
        $sql = "SELECT * FROM  tbl_notification_type_info WHERE notification_id ='$notification_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : select_all_post_info_for_notification
     * @Used IN             : header_menu, view_notification
     * @Description         : Select post info for group post for notification
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 07/06/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $post_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result->post info for that post id   
     * @Status              : Available       
     */
    function select_all_post_info_for_notification($post_id) {
        $sql = "SELECT * FROM  tbl_post WHERE post_id ='$post_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : check_post_group_id
     * @Used IN             : header_menu, view_notification
     * @Description         : for which groups this post is given
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 07/06/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $post_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result   
     * @Status              : Available       
     */
    function check_post_group_id($post_id) {
        $sql = "SELECT * FROM  tbl_post_group WHERE post_id ='$post_id'";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            : update_notification_while_editing_group_post
     * @Used IN             : post_model.php(update_note_details)
     * @Description         : while edit a post then check that notification previously exits in notification tbl and delete that notification.
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 07/06/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $post_info
     * @View                : None
     * @Redirect            : None
     * @Return              : $result   
     * @Status              : Available       
     */
    function update_notification_while_editing_group_post($post_info, $value) {
        $post_id = $post_info->post_id;
        $check_post = $this->check_post_notification_exitence($post_id, $value);
        if ($check_post) {
            $this->delete_notification_for_that_post($check_post->notification_id);
        }
    }

    /**
     * @Function            : check_post_notification_exitence
     * @Used IN             : oost_model.php(update_note_details)
     * @Description         : while edit a post then check that notification previously exits in notification tbl.
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 07/06/2016
     * @Updated Date Time   : 07/06/2016
     * @Updated By          :       
     * @Parameter           : $post_info
     * @View                : None
     * @Redirect            : None
     * @Return              : $result   
     * @Status              : Available       
     */
    function check_post_notification_exitence($post_id, $value) {
        $sql = "SELECT *  FROM tbl_notification_type_info as nt , tbl_notification as n "
                . " WHERE nt.notification_type_id='$post_id'"
                . " AND n.notification_id=nt.notification_id";
        if ($value == 4) {
            $sql.= " AND n.notification_type=3  ";
        } else if ($value == 3) {
            $sql.= " AND n.notification_type=12  ";
        }
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : delete_notification_for_that_post
     * @Used IN             : post_model.php(update_note_details)
     * @Description         : delete notification while editiing
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 09/06/2016
     * @Updated Date Time   : 09/06/2016
     * @Updated By          :       
     * @Parameter           : $post_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result   
     * @Status              : Available       
     */
    function delete_notification_for_that_post($notification_id) {
        $this->db->where('notification_id', $notification_id);
        $this->db->delete('tbl_notification');
        $this->db->where('notification_id', $notification_id);
        $this->db->delete('tbl_notification_type_info');
    }

//-------end save notification for group post--------
//------start notification for group join request and accept request--------
    /**
     * @Function            : save_group_request_notification_to_creator
     * @Used IN             : @controller(group.php)
     * @Description         : save notification for group join request send
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 31/05/2016
     * @Updated Date Time   : 08/06/2016
     * @Updated By          :       
     * @Parameter           : $user_id,$group_info
     * @View                : None
     * @Redirect            : None
     * @Return              : 
     * @Status              : Available       
     */
    function save_group_request_notification_to_creator($user_id, $group_info) {
        $data = array();
        $sdata = array();
        $group_id = $group_info->group_id;
        $group_creator = $group_info->group_created_by;
        $time = date('Y/m/d H:i:s', (time()));
        $data['notification_date_time'] = $time;
        $data['notify_by'] = $user_id;
        $data['notify_to'] = $group_creator;
        $data['notification_description'] = $this->group_join_request_description($data['notify_by'], $data['notify_to'], $group_info->group_name);
        $data['notification_type'] = 4;  // type->4 for  group join request to sender notification    
        $this->db->insert('tbl_notification', $data);
        $last_inserted_id = $this->db->insert_id();

        if ($last_inserted_id) {
            $sdata['notification_id'] = $last_inserted_id;
            $sdata['notification_type_id'] = $group_id;
            $this->db->insert('tbl_notification_type_info', $sdata);
        }
    }
    
    
    /*
     * @Function            : group_join_request_description
     * @Description         : Prepare notification description for group join request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 08-06-17 
     * @Parameter           : $notify_by, $notify_to, $group_name
     * @Status              : available
     */
    public function group_join_request_description($notify_by, $notify_to, $group_name){
        $notify_by_name = $this->get_person_name($notify_by);        
        $description[$notify_by] = "You Have Sent a Request to Join $group_name";
        $description[$notify_to] = "Join Request for Group $group_name Pending from $notify_by_name";
        return serialize($description);
    }
    
    
    /*
     * @Function            : get_person_name
     * @Description         : gets person name using person id
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $person_id
     * @Status              : available
     */
    public function get_person_name($person_id){
        $result  = $this->db->select('person_first_name, person_last_name')
                        ->where('person_id', $person_id)
                        ->from('tbl_person')->get()->row();
        return $result->person_first_name.' '.$result->person_last_name;
    }

    /**
     * @Function            : select_group_info_by_group_id_for_notification
     * @Used IN             : header_menu.php,view_notification.php
     * @Description         : Select group information
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 1/06/2016
     * @Updated Date Time   : 1/06/2016
     * @Updated By          :       
     * @Parameter           : $group_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result->group info  
     * @Status              : Available       
     */
    function select_group_info_by_group_id_for_notification($group_id) {
        $sql = "SELECT * FROM  tbl_group as g, "
                . " tbl_url as u"
                . " WHERE g.group_id ='$group_id'"
                . " AND g.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : save_group_member_active_notification
     * @Used IN             : @controller(group.php)
     * @Description         : save group member activation notification
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 1/06/2016
     * @Updated Date Time   : 1/06/2016
     * @Updated By          :       
     * @Parameter           : $person_id, $group_member_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result->group info  
     * @Status              : Available       
     */
    function save_group_member_active_notification($person_id, $group_member_id) {
        $data = array();
        $sdata = array();
        $group_info = $this->select_all_group_info_by_group_member_id($group_member_id);
        $group_id = $group_info->group_id;
        $time = date('Y/m/d H:i:s', (time()));
        $data['notification_date_time'] = $time;
        $data['notify_by'] = $person_id;
        $data['notify_to'] = $group_info->person_id;
        $data['notification_description'] = $this->group_member_active_description($data['notify_by'], $data['notify_to'], $group_info->group_name);
        $data['notification_type'] = 5;  // type->5 for group join request acceptance notification    
        $this->db->insert('tbl_notification', $data);
        $last_inserted_id = $this->db->insert_id();

        if ($last_inserted_id) {
            $sdata['notification_id'] = $last_inserted_id;
            $sdata['notification_type_id'] = $group_id;
            $this->db->insert('tbl_notification_type_info', $sdata);
        }
    }
    
    /*
     * @Function            : group_member_active_description
     * @Description         : Prepare notification description for group member activation
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 08-06-17 
     * @Parameter           : $notify_by, $notify_to, $group_name
     * @Status              : available
     */
    public function group_member_active_description($notify_by, $notify_to, $group_name){
        $notify_to_name = $this->get_person_name($notify_to);
        $description[$notify_by] = "You Have Accepted Group Join Request From $notify_to_name";
        $description[$notify_to] = "Join Request for Group $group_name Has Been Accepted !";
        return serialize($description);
    }

    /**
     * @Function            : select_all_group_info_by_group_member_id
     * @Used IN             : save_group_member_active_notification
     * @Description         : Select group information by group member id
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 1/06/2016
     * @Updated Date Time   : 1/06/2016
     * @Updated By          :       
     * @Parameter           : $group_id
     * @View                : None
     * @Redirect            : None
     * @Return              : $result-> group member info/group info
     * @Status              : Available       
     */
    function select_all_group_info_by_group_member_id($group_member_id) {
        $sql = "SELECT * FROM tbl_group_member as gm,"
                . " tbl_group as g"
                . " WHERE gm.group_member_id='$group_member_id'"
                . " AND gm.group_id=g.group_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

//------------end notification for group join request and accept request-------------
//----------------------------------------save notification for link post----------------------------------
    /**
     * @Function            : save_notification_for_link_post
     * @Used IN             : post_model.php()
     * @Description         : save notification for post which is given in link
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 5/06/2016
     * @Parameter           : $post_id
     * @Return              : $result  
     * @Status              : Available       
     */
    function save_notification_for_link_post($post_id, $type, $status) {
        $person_id = $this->session->userdata('user_id');
        $linked_person_info = $this->select_linked_person_info($person_id);
        if ($linked_person_info) {
            foreach ($linked_person_info as $val_link) {
                $linked_person[] = $val_link->person_id;
                $link_person[] = $val_link->requested_person_id;
            }
            $link_array = array_merge($linked_person, $link_person);
            $person_link_id = array_filter(array_unique($link_array));

            $person_info = $this->person_model->set_person_id($this->session->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();

            $notification_description = [];
            $notification_description[1] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> have ' . $status . ' ' . $type . '';
            $notification_description[$this->session->person_id] = '<strong>You</strong> have ' . $status . ' ' . $type . '';

            if (count($person_link_id) > 0) {
                foreach ($person_link_id as $value) {
                    if ($value != $this->session->person_id) {
                        $notification_description[$value] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> have ' . $status . ' ' . $type . '';
                    }
                }
            }

            $this->notification_description = serialize($notification_description);
            $this->notify_by = $this->session->person_id;
            $this->notify_to = implode(',', array_keys($notification_description));
            $this->notification_type = 3;
            $this->notification_type_id = $post_id;

            $this->save_notification();
        }
    }

    /**
     * @Function            : save_notification_for_link_post
     * @Used IN             : post_model.php()
     * @Description         : select link for post 
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 5/06/2016
     * @Parameter           : $post_id
     * @Return              : $result  
     * @Status              : Available       
     */
    function select_linked_person_info($person_id) {
        $sql = "SELECT * FROM tbl_person_link WHERE person_id='$person_id' OR  requested_person_id='$person_id' ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

//-----------------------save notification for link post-----------------
    /**
     * @Function            : view_admin_notification_information 
     * @Description         : view_admin_notification_information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 05:15 PM   
     * @Parameter           : $notification_id[INTEGER], $notification_type_id[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function view_admin_notification_information($person_id) {
        $todays_date = date('Y/m/d', (time() - $this->session->userdata('time_offset')));
        $data['todays_notification'] = $this->get_todays_all_notification($person_id, $todays_date);
        $data['read_notification'] = $this->get_all_read_notification($person_id);
        $data['unread_notification'] = $this->get_all_unread_notification($person_id);
        return $data;
    }

    /**
     * @Function            : save_notification_type_info 
     * @Description         : save notification type information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:34 AM   
     * @Parameter           : $notification_id[INTEGER], $notification_type_id[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_notification_type_info($notification_id, $notification_type_id) {
        $data = Array();
        $data['notification_id'] = $notification_id;
        $data['notification_type_id'] = $notification_type_id;
        $this->db->insert('tbl_notification_type_info', $data);
    }

    /**
     * @Function            : select_notification_info_by_notification_id 
     * @Description         : get notification information by notification ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:53 AM   
     * @Parameter           : $notification_id[INTEGER]
     * @Return              : $notification_info[ARRAY]    
     * @Status              : available      
     * */
    function select_notification_info_by_notification_id($notification_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_notification AS n,
                    tbl_notification_type_info AS nt
                WHERE 
                    n.notification_id = '$notification_id'
                AND n.notification_id = nt.notification_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : update_view_notification 
     * @Description         : update_view_notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-07-2016 12:09 AM   
     * @Parameter           : $person_id[INTEGER], $notification_id[INTEGER]
     * @Return              : $notification_info[ARRAY]    
     * @Status              : available      
     * */
    function update_view_notification($person_id, $notification_id) {
        $notification_info = $this->select_notification_info_by_notification_id($notification_id);

        if ($notification_info) {
            if ($notification_info->notification_view_by != '') {
                $notification_view_by_array = array_filter(explode(',', preg_replace('/\s+/', '', $notification_info->notification_view_by)));
                $notification_view_by_array[] = $person_id;
                $data['notification_view_by'] = implode(',', array_unique($notification_view_by_array));
            } else {
                $data['notification_view_by'] = $person_id;
            }
            $this->utility_model->update_information_in_database('tbl_notification', 'notification_id', $notification_id, $data);
        }
    }

    /**
     * @Function            : get_notification_id_for_course
     * @Used IN             : 'delete_course'  super_admin_course_model[@Model]
     * @Description         : Get notification ID for course
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 08-09-2016 05:01 PM  
     * @Parameter           : $course_id,$notification_type
     * @Return              : $notification_id  
     * @Status              : Available       
     */
    function get_notification_id_list_by_notification_type_id($notification_type_id, $notification_type) {
        return $this->db->select('GROUP_CONCAT(n.notification_id) AS notification_id')
                        ->from('tbl_notification AS n')
                        ->join('tbl_notification_type_info AS nti', 'nti.notification_id = n.notification_id')
                        ->where('nti.notification_type_id', $notification_type_id)
                        ->where_in('n.notification_type', explode(',', $notification_type))
                        ->get()->row()->notification_id;
    }

    /**
     * @Function            : get_notification_id_for_course
     * @Used IN             : 'delete_course'  super_admin_course_model[@Model]
     * @Description         : Get notification ID for course
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 08-09-2016 05:01 PM  
     * @Parameter           : $course_id,$notification_type
     * @Return              : $notification_id  
     * @Status              : Available       
     */
    function get_notification_type_id_list_by_notification_type_id($course_id, $notification_type) {
        return $this->db->select('GROUP_CONCAT(nti.notification_type_info_id) AS notification_type_id')
                        ->from('tbl_notification AS n')
                        ->join('tbl_notification_type_info AS nti', 'nti.notification_id = n.notification_id')
                        ->where('nti.notification_type_id', $course_id)
                        ->where_in('n.notification_type', explode(',', $notification_type))
                        ->get()->row()->notification_type_id;
    }

    /**
     * @Function            : get_single_notification_info
     * @Used IN             : 'remove_registered_student'  user_course[@Controller]
     * @Description         : Get single notification information for single course and person 
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 08-09-2016 05:01 PM  
     * @Parameter           : $course_id,$notification_type
     * @Return              : $notification_id  
     * @Status              : Available       
     */
    function get_single_notification_info($notification_type, $notification_type_id, $notify_by) {
        return $this->db->select('*')
                        ->from('tbl_notification AS n')
                        ->join('tbl_notification_type_info AS nti', 'n.notification_id = nti.notification_id')
                        ->where('n.notification_type', $notification_type)
                        ->where('nti.notification_type_id', $notification_type_id)
                        ->where('n.notify_by', $notify_by)
                        ->get()->row();
    }

    /**
     * @Description         : set notification data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 11:47 AM 
     * */
    private $type;
    private $type_id;
    private $notify_by;

    function set_data($type, $type_id, $notify_by) {
        $this->type = $type;
        $this->type_id = $type_id;
        $this->notify_by = $notify_by;
        return $this;
    }

    /**
     * @Description         : get notification data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 11:51 AM 
     * */
    function get_data() {
        return $this->db->select('*')
                        ->from('tbl_notification AS n')
                        ->join('tbl_notification_type_info AS nti', 'n.notification_id = nti.notification_id')
                        ->where('n.notification_type', $this->type)
                        ->where('nti.notification_type_id', $this->type_id)
                        ->where('n.notify_by', $this->notify_by)
                        ->get()->row();
    }

    /**
     * @Description         : set notification ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    private $notification_id;

    function set_notification_id($notification_id) {
        $this->notification_id = $notification_id;
        return $this;
    }

    /**
     * @Description         : set notification type ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:54 PM 
     * */
    private $notification_type_id;

    function set_notification_type_id($notification_type_id) {
        $this->notification_type_id = $notification_type_id;
        return $this;
    }

    /**
     * @Description         : set notification type info ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    private $notification_type_info_id;

    function set_notification_type_info_id($notification_type_info_id) {
        $this->notification_type_info_id = $notification_type_info_id;
        return $this;
    }

    /**
     * @Description         : set notification by
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 03:26 PM 
     * */
    function set_notify_by($notify_by) {
        $this->notify_by = $notify_by;
        return $this;
    }

    /**
     * @Description         : set notification by
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 03:26 PM 
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * @Description         : set notify to
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 03:26 PM
     * */
    private $notify_to;

    function set_notify_to($notify_to) {
        $this->notify_to = $notify_to;
        return $this;
    }

    /**
     * @Description         : set notification type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 03:26 PM 
     * */
    private $notification_type;

    function set_notification_type($notification_type) {
        $this->notification_type = $notification_type;
        return $this;
    }

    /**
     * @Description         : set notification date
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-12-2016 03:29 PM 
     * */
    private $notification_date;

    function set_notification_date_time($notification_date) {
        $this->notification_date = $notification_date;
        return $this;
    }

    /**
     * @Description         : set notification description
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-01-2017 12:07 PM 
     * */
    private $notification_description;

    function set_notification_description($notification_description) {
        $this->notification_description = $notification_description;
        return $this;
    }

    /**
     * @Description         : get notification message
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-01-2017 12:07 PM 
     * */
    function get_notification_message() {
        $notification_description = unserialize($this->notification_description);
        return $notification_description[$this->person_id];
    }

    /**
     * @Description         : set notification type info ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    function get_notification_id() {
        return $this->notification_id;
    }

    /**
     * @Description         : get notification to
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    function get_notify_to() {
        return $this->notify_to;
    }

    /**
     * @Description         : set notification type info ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    function get_notify_by() {
        return $this->notify_by;
    }

    /**
     * @Description         : get result
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-12-2016 03:31 PM 
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : save notification data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 02:46 PM 
     * */
    private $tbl_name = 'tbl_notification';
    private $primary_key = 'notification_id';

    function save() {
        $data = [];
        $data['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $data['notification_description'] = $this->notification_description;
        $data['notify_by'] = $this->notify_by;
        $data['notify_to'] = $this->notify_to;
        $data['notification_type'] = $this->notification_type;
        $this->db->insert($this->tbl_name, $data);
        return $this;
    }

    /**
     * @Description         : create insert ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 22-12-2016 02:52 PM 
     * */
    function set_insert_id() {
        $this->notification_id = $this->db->insert_id();
        return $this;
    }

    /**
     * @Description         : delete notification data
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    function delete() {
        $this->db->where($this->primary_key, $this->notification_id)->delete($this->tbl_name);
    }

    /**
     * @Description         : save notification type info
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:26 PM 
     * */
    function save_type_info() {
        $data = [];
        $data['notification_id'] = $this->notification_id;
        $data['notification_type_id'] = $this->notification_type_info_id;
        $this->db->insert($this->type_tbl_name, $data);
        return $this;
    }

    /**
     * @Description         : delete notification type table information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 24-11-2016 12:31 PM 
     * */
    private $type_tbl_name = 'tbl_notification_type_info';
    private $type_primary_key = 'notification_type_info_id';

    function delete_type_info() {
        $this->db->where($this->type_primary_key, $this->notification_type_info_id)->delete($this->type_tbl_name);
    }

    //--------------------------get notification data fot dashboard-----------------------------------------

    /**
     * @Description         : total notification by date and type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-11-2016 03:26 PM 
     * */
    function total_notification_by_date() {
        $this->db->select('*')->from($this->tbl_name)
                ->where("FIND_IN_SET('$this->notify_to',notify_to)!=", 0)
                ->where("DATE(notification_date_time)", $this->notification_date)
                ->where_in('notification_type', $this->notification_type);
        $this->result = $this->db->count_all_results();
        return $this;
    }

    /**
     * @Description         : total read notification by notify by and type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-11-2016 03:51 PM 
     * */
    function total_read_notification() {
        $this->db->select('*')->from($this->tbl_name)
                ->where("FIND_IN_SET('$this->notify_to',notify_to)!=", 0)
                ->where("FIND_IN_SET('$this->notify_to',notification_view_by)!=", 0)
                ->where_in('notification_type', $this->notification_type);
        $this->result = $this->db->count_all_results();
        return $this;
    }

    /**
     * @Description         : total unread notification by notify by and type
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-11-2016 03:51 PM 
     * */
    function total_unread_notification() {
        $this->db->select('*')->from($this->tbl_name)
                ->where("FIND_IN_SET('$this->notify_to',notify_to)!=", 0)
                ->where("(notification_view_by IS NULL OR NOT FIND_IN_SET('$this->notify_to',notification_view_by))!=", 0)
                ->where_in('notification_type', $this->notification_type);
        $this->result = $this->db->count_all_results();
        return $this;
    }

}
