<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Notification_course_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : select_notification_info_by_notification_id
     * @Used IN             : notification_course_model.php(notification_course_create_view_for_indvi_or_tt_teacher())
     * @Description         : Select notification by notification id
     * @Developed By        : Afrin jahan noumin 
     * @Start DateTime      : 14/06/2016
     * @Parameter           : $notification_id
     * @Return              :   
     * @Status              : Available       
     */
    function select_notification_info_by_notification_id($notification_id) {
        $sql = "SELECT * FROM tbl_notification WHERE notification_id='$notification_id'";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@@ Start add Course Notification (18-07-16)----------------------------------
     */

    /**
     * @Function            : save_add_course_notification 
     * @Used IN             : @function-'save_course_information'    super_admin_course_model[@Model]
     * @Description         : save add course notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:01 AM   
     * @Parameter           : $course_id[[INTEGER], $course_data[[ARRAY]
     * @Return              : Null    
     * @Status              : available      
     * */
    private $notify_to;
    private $notification_description;

    function save_add_course_notification($course_id, $course_data) {
        $nData = array();
        $person_id = $this->session->person_id;
        $this->get_all_notify_to_for_add_course($person_id, $course_data);
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $nData['notify_by'] = $person_id;
        $nData['notify_to'] = $this->notify_to;
        $nData['notification_description'] = $this->notification_description;
        $nData['notification_type'] = 6;  // type->6 for add Course   
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for add course
        $this->notification_model->save_notification_type_info($notification_id, $course_id); // save notofication information
        return $notification_id;
    }

    /**
     * @Function            : get_all_notify_to_for_add_course 
     * @Used IN             : @function-'save_add_course_notification'    this[@Model]
     * @Description         : get all notify to for add course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 04:22 PM   
     * @Parameter           : $course_id[[INTEGER], $course_data[[ARRAY]
     * @Return              : $all_person_id[INTEGER]    
     * @Status              : available      
     * */
    function get_all_notify_to_for_add_course($person_id, $course_data) {
        $notification_descritpion = [];
        $person_info = $this->person_model->get_single_person_info_by_person_id($person_id);
        $resource_person_id = $this->get_resource_person_id($course_data['resource_person_id']);
        if (in_array($this->session->person_role, Array(1, 6, 9))) { // if course created by Talhatraining
            $notification_descritpion[1] = '<strong>Talha Training</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            $notification_descritpion[$resource_person_id] = '<strong>Talha Training</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
        }

        if ($this->session->person_role == 3) { // if course created by TT Teacher/Ind Teacher/Org Teacher
            $resource_person_info = $this->resource_person_model->single_resource_person_information_by_person_id($person_id);
            $person_info = $this->person_model->set_person_id($resource_person_info->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();
            // if Course Created by TT Teacher, Ind Teacher
            $notification_descritpion[1] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';

            if (in_array($resource_person_info->resource_person_type, Array(1, 2))) {
                $notification_descritpion[$resource_person_info->person_id] = '<strong>You</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            } else {
                $course_creator_id = $course_data['person_id'];
                $notification_descritpion[$course_creator_id] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                $notification_descritpion[$resource_person_info->person_id] = '<strong>You</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            }
        }

        if ($this->session->person_role == 4) {  // if course created by Any Organization
            $notification_descritpion[1] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';

            $course_person_id = $this->get_resource_person_id($course_data['resource_person_id']);
            if ($person_id == $course_person_id) {
                $notification_descritpion[$person_id] = '<strong>You</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            } else {
                $notification_descritpion[$person_id] = '<strong>You</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                $notification_descritpion[$course_person_id] = '<strong>' . $person_info->person_first_name . ' ' . $person_info->person_last_name . '</strong> created a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            }
        }

        $this->notify_to = implode(',', array_keys($notification_descritpion));
        $this->notification_description = serialize($notification_descritpion);
    }

    /**
     * @Function            : get_resource_person_id 
     * @Used IN             : @function-'save_add_course_notification'    this[@Model]
     * @                    : @function-'send_email_for_add_course'       mailer_model[@Model]
     * @Description         : get person_id by resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-07-2016 11:01 AM   
     * @Parameter           : $resource_person_id[[INTEGER]
     * @Return              : $person_id[INTEGER]    
     * @Status              : available      
     * */
    function get_resource_person_id($resource_person_id) {
        $resource_person_info = $this->resource_person_model->select_person_information_by_resource_person_id($resource_person_id);
        return $resource_person_info->person_id;
    }

    /*
      -----------@@@RIPON@@ End add Course Notification (18-07-16)----------------------------------
     */

    /*
      -----------@@@RIPON@@ Start Edit Course Notification (05-09-16)----------------------------------
     */

    /**
     * @Function            : save_update_course_notification 
     * @Used IN             : @function-'update_course_information'    super_admin_course_model[@Model]
     * @Description         : save update course notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-08-2016 03:56 PM   
     * @Parameter           : $course_id[[INTEGER], $course_data[[ARRAY]
     *                        $type->1[for back end], 2[for front end]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_update_course_notification($course_id, $data, $course_data, $type) {
        $this->get_all_notify_to_for_edit_course($data, $course_data);
        $nData = array();
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        $nData['notify_by'] = ($type == 1) ? $data['course_info']->course_creator_id : $this->get_resource_person_id($course_data['resource_person_id']);
        $nData['notify_to'] = $this->notify_to;
        $nData['notification_description'] = $this->notification_description;
        $nData['notification_type'] = 6;  // type->6 for Update Course   
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for edit course
        $this->notification_model->save_notification_type_info($notification_id, $course_id); // save notofication information
        return $notification_id;
    }

    /**
     * @Function            : get_all_notify_to_for_edit_course 
     * @Used IN             : @function-'update_course_information'    super_admin_course_model[@Model]
     * @Description         : get all person ID for notification in edit course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-08-2016 03:56 PM   
     * @Parameter           : $data[[ARRAY], $course_data[[ARRAY]
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_all_notify_to_for_edit_course($data, $course_data) {
        $course_person_id = $this->get_resource_person_id($course_data['resource_person_id']);
        $login_person_info = $this->person_model->set_person_id($this->session->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();
        
        if (in_array($this->session->person_role, Array(1, 6, 9))) { // if course created by Talhatraining
            $notification_descritpion[1] = '<strong>Talha Training</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            $notification_descritpion[$course_person_id] = '<strong>Talha Training</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
        }
        if ($this->session->person_role == 3) { // if course created by TT Teacher/Ind Teacher/Org Teacher
            $person_info = $this->person_model->set_person_id($data['course_creator_info']->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();
            $resource_person_info = $this->resource_person_model->single_resource_person_information_by_person_id($data['course_creator_info']->person_id);

            // if Course Created by TT Teacher, Ind Teacher
            $notification_descritpion[1] = '<strong>' . $login_person_info->person_first_name . ' ' . $login_person_info->person_last_name . '</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';    
            if(isset($resource_person_info)){
                if (in_array($resource_person_info->resource_person_type, Array(1, 2))) {
                    $notification_descritpion[$resource_person_info->person_id] = '<strong>You</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                } else {
                    $course_creator_id = $course_data['resource_person_id'];
                    $notification_descritpion[$course_creator_id] = '<strong>' . $login_person_info->person_first_name . ' ' . $login_person_info->person_last_name . '</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                    $notification_descritpion[$resource_person_info->person_id] = '<strong>You</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                }
            }
        }
        if ($data['course_creator_info']->person_role == 4) {  // if course created by Any Organization
            $person_info = $this->person_model->set_person_id($data['course_creator_info']->person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();

            $notification_descritpion[1] = '<strong>' . $login_person_info->person_first_name . ' ' . $login_person_info->person_last_name . '</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            $person_id = $this->session->userdata('person_id');
            $course_person_id = $this->get_resource_person_id($course_data['resource_person_id']);
            if ($data['course_creator_info']->person_id == $course_person_id) {
                $notification_descritpion[$person_id] = '<strong>You</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            } else {
                $notification_descritpion[$person_id] = '<strong>You</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
                $notification_descritpion[$course_person_id] = '<strong>' . $login_person_info->person_first_name . ' ' . $login_person_info->person_last_name . '</strong> updated a course <strong>' . mb_substr($course_data['course_name'], 0, 15) . '...</strong>';
            }
        }

        $this->notify_to = implode(',', array_keys($notification_descritpion));
        $this->notification_description = serialize($notification_descritpion);
    }

    /*
      -----------@@@RIPON@@ End Edit Course Notification (05-09-16)----------------------------------
     */



    /*
      -----------@@@RIPON@@ Start Change Course Notification Part (05-09-16)----------------------------------
     */

    /**
     * @Function            : save_course_status_change_notification 
     * @Used IN             : @function-'chnage_course_permission'    super_admin_course[@Controller]
     * @Description         : save course status notification
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-09-2016 12:09 PM   
     * @Parameter           : $course_info[[ARRAY],$notify_by[who change this status]
     *                        $status->1 [for course permission]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_course_status_change_notification($course_info, $notify_by, $notification_type) {
        $this->get_all_notify_to_for_change_course_status($course_info, $notification_type);
        $nData = array();
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $nData['notify_by'] = $notify_by;
        $nData['notify_to'] = $this->notify_to;
        $nData['notification_description'] = $this->notification_description;
        $nData['notification_type'] = 6;
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for edit course
        $this->notification_model->save_notification_type_info($notification_id, $course_info->course_id); // save notofication information
        return $notification_id;
    }

    /**
     * @Function            : get_notification_type 
     * @Used IN             : @function-'change_course_status'    this[@Model]
     * @Description         : get notification type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-09-2016 12:09 PM   
     * @Parameter           : $status->1 [for course permission]
     *                        $status->2 [for course upcomming status]
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_notification_type($status) {
        $notification_type = '';
        switch ($status) {
            case 1: // Active course
                $notification_type = 11;
                break;
            case 2:  // Archive course
                $notification_type = 13;
                break;
            case 3:  // Pending course
                $notification_type = 14;
                break;
            case 4:  // Apporved course
                $notification_type = 15;
                break;
            case 5:  // Draft course
                $notification_type = 16;
                break;
            case 6:  // InActive course
                $notification_type = 12;
                break;
        }
        return $notification_type;
    }

    /**
     * @Function            : get_notification_type_msg 
     * @Used IN             : @function-'save_course_status_change_notification'    this[@Model]
     * @Description         : get notification type message
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-09-2016 12:09 PM   
     * @Parameter           : $notification_type
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_notification_type_msg($notification_type) {
        $notification_msg = '';
        switch ($notification_type) {
            case 9: // Active course
                $notification_msg = 'updated permission';
                break;
            case 10:  // Archive course
                $notification_msg = 'upcomming for';
                break;
            case 11:  // Active course
                $notification_msg = 'actived';
                break;
            case 12:  // inactive course
                $notification_msg = 'inactived';
                break;
            case 13:  // Archive course
                $notification_msg = 'archived';
                break;
            case 14:  // Pending course
                $notification_msg = 'pending';
                break;
            case 15:  // Apporved course
                $notification_msg = 'apporved';
                break;
            case 16:  // Draft course
                $notification_msg = 'draft';
                break;
        }
        return $notification_msg;
    }

    /**
     * @Function            : get_all_notify_to_for_change_course_status 
     * @Used IN             : @function-'chnage_course_permission'    super_admin_course[@Controller]
     * @Description         : get all notify to fo course change status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-09-2016 12:05 PM   
     * @Parameter           : $course_info[[ARRAY]
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_all_notify_to_for_change_course_status($course_info, $notification_type) {
        $notification_descritpion = [];
        $course_creator_info = $this->person_model->get_single_person_info_by_person_id($course_info->person_id);
        $resource_person_id = $this->get_resource_person_id($course_info->resource_person_id);
        $notification_message = $this->get_notification_type_msg($notification_type);

        if ($notification_type == 13) {
            $this->update_course_previous_notification($course_info->course_id);
        }

        if (in_array($this->session->person_role, Array(1, 6, 8, 9))) { // for->back end user
            $notification_descritpion[1] = '<strong>Talha Training</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';

            if ($course_info->course_status != 2) {
                if ($course_info->person_id != 1) {
                    $notification_descritpion[$course_info->person_id] = '<strong>Talha Training</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                    $notification_descritpion[$resource_person_id] = '<strong>Talha Training</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                }else{
                    $notification_descritpion[$resource_person_id] = '<strong>Talha Training</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                }
            }
        }

        if (in_array($this->session->person_role, Array(3, 4))) {  // for->Organization and Ind Teacher User
            if ($course_creator_info->person_id == $resource_person_id) {
                $notification_descritpion[1] = '<strong>' . $course_creator_info->person_first_name . ' ' . $course_creator_info->person_last_name . '</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                if ($course_info->course_status != 2) {
                    $notification_descritpion[$course_creator_info->person_id] = '<strong>' . $course_creator_info->person_first_name . ' ' . $course_creator_info->person_last_name . '</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                }
            } else {
                $notification_descritpion[1] = '<strong>' . $course_creator_info->person_first_name . ' ' . $course_creator_info->person_last_name . '</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                if ($course_info->course_status != 2) {
                    $notification_descritpion[$course_creator_info->person_id] = '<strong>' . $course_creator_info->person_first_name . ' ' . $course_creator_info->person_last_name . '</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                    $notification_descritpion[$resource_person_id] = '<strong>' . $course_creator_info->person_first_name . ' ' . $course_creator_info->person_last_name . '</strong> ' . $notification_message . ' a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                }
            }
        }

        $this->notify_to = implode(',', array_keys($notification_descritpion));
        $this->notification_description = serialize($notification_descritpion);
    }

    /**
     * @Function            : update_course_previous_notification 
     * @Used IN             : @function-'get_all_notify_to_for_change_course_status'    super_admin_course[@Controller]
     * @Description         : update course previous status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-10-2016 12:45 PM   
     * @Parameter           : $course_id[[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function update_course_previous_notification($course_id) {
        $course_notification_type = Array(6);
        $notification_id_list = $this->notification_model->get_notification_id_list_by_notification_type_id($course_id, implode(',', $course_notification_type));

        if ($notification_id_list != '') {
            $data = Array();
            $data['notify_to'] = 1;
            $this->db->where_in('notification_id', explode(',', $notification_id_list))->update('tbl_notification', $data);
        }
    }

    /*
      -----------@@@RIPON@@ End Change Course Notification Part (05-09-16)----------------------------------
     */


    /*
      -----------@@@RIPON@@ Start Course Register Notification (02-09-16)----------------------------------
     */

    /**
     * @Function            : save_course_registration_notification 
     * @Used IN             : @function-'enroll_course'    course[@Controller]
     * @Description         : save notification for course registration
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-09-2016 11:26 AM   
     * @Parameter           : $register_person_id=>register stuent id, $course_info[Course infotmation]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_course_registration_notification($register_person_id, $course_info) {
        $this->get_all_notify_to_for_course_registration($register_person_id, $course_info);
        $nData = array();
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->userdata('time_offset')));
        $nData['notify_by'] = $register_person_id;
        $nData['notify_to'] = $this->notify_to;
        $nData['notification_description'] = $this->notification_description;
        $nData['notification_type'] = 6;  // type->8 for Course Registration   
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for edit course
        $this->notification_model->save_notification_type_info($notification_id, $course_info->course_id); // save notofication information
        return $notification_id;
    }

    /**
     * @Function            : get_all_notify_to_for_course_registration 
     * @Used IN             : @function-'save_course_registration_notification'    this[@Model]
     * @Description         : get all notify to for course registration
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-09-2016 11:31 AM   
     * @Parameter           : $course_info[Course infotmation]
     * @Return              : Null    
     * @Status              : available      
     * */
    function get_all_notify_to_for_course_registration($register_person_id, $course_info) {
        $notification_description = [];
        $course_creator_info = $this->person_model->get_single_person_info_by_person_id($course_info->course_creator_id);
        $resource_person_id = $this->get_resource_person_id($course_info->resource_person_id);
        $register_person_info = $this->person_model->set_person_id($register_person_id)->set_field_name('person_first_name,person_last_name')->set_info_by_id()->get_info();

        if (in_array($course_creator_info->person_role, Array(1, 6, 8, 9))) { // for->back end user
            $notification_description[1] = '<strong>' . $register_person_info->person_first_name . ' ' . $register_person_info->person_last_name . '</strong> registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
            $notification_description[$register_person_id] = '<strong>You</strong> successfully registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';

            if ($course_info->course_resource_person_edit == '1') {
                $notification_description[$resource_person_id] = '<strong>' . $register_person_info->person_first_name . ' ' . $register_person_info->person_last_name . '</strong> registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
            }
        }

        if (in_array($course_creator_info->person_role, Array(3, 4))) {  // for->Organization and Ind Teacher User
            $notification_description[1] = '<strong>' . $register_person_info->person_first_name . ' ' . $register_person_info->person_last_name . '</strong> registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
            $notification_description[$course_creator_info->person_id] = '<strong>' . $register_person_info->person_first_name . ' ' . $register_person_info->person_last_name . '</strong> registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
            $notification_description[$register_person_id] = '<strong>You</strong> successfully registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
            if ($course_creator_info->person_id != $resource_person_id) {
                if ($course_info->course_resource_person_edit == '1') {
                    $notification_description[$resource_person_id] = '<strong>' . $register_person_info->person_first_name . ' ' . $register_person_info->person_last_name . '</strong> registered a course <strong>' . mb_substr($course_info->course_name, 0, 15) . '...</strong>';
                }
            }
        }

        $this->notify_to = implode(',', array_keys($notification_description));
        $this->notification_description = serialize($notification_description);
    }

    /*
      -----------@@@RIPON@@ End Course Register Notification (02-09-16)----------------------------------
     */

    /**
     * @Function            : get_course_notification_message
     * @Used IN             : @function-'get_notification_message'      this[@Model]
     * @Description         : view course notification message
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 09:39 AM 
     * @Parameter           : $course_id[INTEGER]
     * @Return              : $notification_message
     * @Status              : available      
     * */
    function get_course_notification_message($notification_type, $course_id) {
        $course_info = $this->utility_model->get_single_table_information('*', 'tbl_course', 'course_id', $course_id);
        $type_message = $this->tt_notification->get_notification_course_type_msg($notification_type);
        $course_name = (strlen($course_info->course_name) > 50) ? mb_substr($course_info->course_name, 0, 50, 'utf-8') . '..' : $course_info->course_name;
        return $type_message . ' a course <span style="color: #4d4d4d !important; font-weight: bold !important;">' . $course_name . '</span>';
    }

}
