<?php

/**
 * Description of Manage_language_model
 *
 * @author Talha Training
 */
class Manage_language_model extends CI_Model{
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for inserting the language
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $data
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function add_language_info($data){
        $this->db->insert('tbl_language',$data);
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for taking all the language information by id
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              : $result   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function select_all_language_info(){
        $result = $this->db->select('*')
                ->from('tbl_language')
                ->order_by('language_id','desc')
                ->get()
                ->result();
        return $result;
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for taking the first 10 language by id(for pagination)
 * @view                : language/ajax_view/manage_language
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $limit_offset
 * @Return              : $result     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function select_limited_language_info($limit_offset){
        $result = $this->db->select('*')
                ->from('tbl_language')
                ->order_by('language_id','desc')
                ->limit(10,$limit_offset)
                ->get()
                ->result();
        return $result;
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for taking one language by id
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $language_id
 * @Return              : $data 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function select_language_by_id($language_id){
       $data = $this->db->select('*')
                ->from('tbl_language')
                ->where('language_id',$language_id)
                ->get()->row();
        return $data;
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for updating language by id
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $data, $language_id
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_language_info($data, $language_id){
        $this->db->where('language_id',$language_id)
                ->update('tbl_language',$data);
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for deleting language by id
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           :$language_id
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_language_info($language_id) {
       $this->db->where('language_id', $language_id)
               ->delete('tbl_language');
   }
   /*
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for searching language
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           :$condition = null, $search_text
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
   public function search_language_info($search_text, $condition = null){
      
       if($condition != null){
            $result = $this->db->select('*')->from('tbl_language')->order_by('language_name', 'ASC')
                               ->where($condition)->like('language_name',$search_text)
                               ->get()->result();
        }else{
            $result = $this->db->select('*')->from('tbl_language')->order_by('language_name', 'ASC')
                               ->like('language_name',$search_text)
                               ->get()->result();
        }
         return $result;  
   }
   
   /*
 * @Author              : Kazol 
 * @CreatedDate         : 12-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for paginating the searching language
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           :$condition = null, $search_text,$limit_offset
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
   public function pagination_language_info($condition = null,$search_text, $limit_offset ){
       
       if($condition != null){
            $result = $this->db->select('*')->from('tbl_language')->order_by('language_name', 'ASC')
                               ->where($condition)->like('language_name',$search_text)
                               ->limit(10, $limit_offset)->get()->result();
        }else{
            $result = $this->db->select('*')->from('tbl_language')->order_by('language_name', 'ASC')
                               ->like('language_name',$search_text)
                               ->limit(10, $limit_offset)->get()->result();
        }
         return $result;  
   }
   /*
 * @Author              : Kazol 
 * @CreatedDate         : 12-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for checking the existing language
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           :$language_name
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
   public function check_language_name_exit($language_name){
       if ($this->db->table_exists('tbl_language') )
    {
        $result = $this->db->select('*')
                ->from('tbl_language')
                ->where('language_name',$language_name)
                ->get()
                ->row();
        }else{
            $result = 'Table not exits';
        }
           return $result;
    }

/*
 * @Author              : Kazol 
 * @CreatedDate         : 17-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for collecting the existing language id
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           :$language_name
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
 public function check_language_id_exit($language_name){
       if ($this->db->table_exists('tbl_language') )
    {
        $result = $this->db->select('*')
                ->from('tbl_language')
                ->where('language_name',$language_name)
                ->get()
                ->row();
        }else{
            $result = 'Table not exits';
        }
           return $result;
    }
}
