<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Mailer_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->library('cf');
    }

    /**
     * @Description         : send mamil for add user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:25 AM       
     * */
    public function send_email_to_add_new_user($mdata) {
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from_address'], $mdata['admin_name']);
        $this->email->to($mdata['to_address']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . 'add_user_email_view', $mdata, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    /**
     * @Description         : send mamil for update user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:26 AM       
     * */
    public function send_email_to_update_user($mData) {
        $this->email->set_mailtype('html');
        $this->email->from($mData['from_address'], $mData['admin_name']);
        $this->email->to($mData['to_address']);
        $this->email->subject($mData['subject']);
        $body = $this->load->view('mailScripts/' . 'update_user_email_view', $mData, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    /**
     * sendEmail
     * @author Md. Shafiul Alam
     * @param --- $data - information to place in the mail 
     * $templateName - html template to use in mail body          
     * @return --- none
     * modified by ----- Shafiul Alam
     * date --- 12/04/2009 (mm/dd/yyyy  )
     */
    function sendEmailToNewUser($data, $templateName) {
        $this->email->set_mailtype('html');
        $this->email->from($data['from_address'], $data['admin_name']);
        $this->email->to($data['to_address']);
        $this->email->subject($data['subject']);
        $body = $this->load->view('mailScripts/' . $templateName, $data, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    public function send_email_to_users($data, $templateNmae) {
        $this->email->set_mailtype('html');
        $this->email->from($data['from_address'], $data['admin_name']);
        $this->email->to($data['to_address']);
        $this->email->subject($data['subject']);
        $body = $this->load->view('mailScripts/' . 'email_to_user', $data, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    public function send_email_to_learners($data, $templateNmae) {


        $this->email->set_mailtype('html');
        $this->email->from($data['from_address'], $data['admin_name']);
        $this->email->to($data['to_address']);
        $this->email->subject($data['subject']);
        $body = $this->load->view('mailScripts/' . $templateNmae, $data, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    function sendEmail($mdata, $templateName) {
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from_address']);
        $this->email->to($mdata['to_address']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . 'email_to_admin', $mdata, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    function send_user_Email($mdata, $templateName) {

        $this->email->set_mailtype('html');
        $this->email->from($mdata['from_address']);
        $this->email->to($mdata['to_address']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . 'user_email', $mdata, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

    /**
     * @Function            : send_email 
     * @Used IN             : function-'send_email_to_user_for_account_activation'  'sign_up'[controller],
     *                        function [send_recover_password_successfull_mail] sign_in[controller]
     *                        function[send_email_to_user_for_forgot_password] sign_in[controller]
     * @Description         : send email to user 
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Status              : available      
     * */
    public function send_email($mdata, $templateNmae) {
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from_address'], $mdata['admin_name']);
        $this->email->to($mdata['to_address']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . $templateNmae, $mdata, true);
        //echo $body;
        //exit();
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();
    }

//tania
    /**
     * @Function            : send_contact_email_user
     * @Used IN             : @function['send_contact_email'] @controller['application']  line- 276
     * @Description         : This function is used to send contact email to the user.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 25/04/2016  
     * @Status              : available      
     * */
    function send_contact_email_user($templateName) {
        $data = array();
        $data['admin_name'] = 'TalhaTraining ';
        $data['site_link'] = base_url();
        $data['from'] = 'no-reply@talhatraining.com';
        $data['person_name'] = $this->input->post('person_name', true);
        $data['to'] = $this->input->post('email_address', true);
        //$data['cc'] = 'training@talhatraining.com';
        $data['describe_request'] = $this->input->post('describe_request', true);
        $data['subject'] = 'Thank You for Contacting TalhaTraining';
        $this->email->set_mailtype('html');
        $this->email->from($data['from'], $data['admin_name']);
        $this->email->to($data['to']);
        $this->email->subject($data['subject']);
        $body = $this->load->view('mailScripts/' . $templateName, $data, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear(); //Initializes all the email variables to an empty state
    }

    /**
     * @Function            : send_contact_email_talhatraining
     * @Used IN             : @function['send_contact_email'] @controller['application']  line- 277
     * @Description         : This function is used to send contact email to the Talha Training Administrator.
     * @Developed By        : Tania Akter
     * @Start DateTime      : 25/04/2016  
     * @Status              : available      
     * */
    function send_contact_email_talhatraining($templateName) {
        $mdata = array();
        $mdata['select_contact_for'] = $this->input->post('select_contact_for', true);
        $mdata['contact_reason'] = $this->input->post('contact_reason', true);
        $mdata['describe_request'] = $this->input->post('describe_request', true);
        $mdata['person_name'] = $this->input->post('person_name', true);
        $mdata['person_country'] = $this->input->post('person_country', true);
        $mdata['person_contact_number'] = $this->input->post('person_contact_number', true);
        $mdata['from'] = 'no-reply@talhatraining.com';
        $mdata['to'] = 'training@talhatraining.com';
        $mdata['subject'] = 'Email Receive from Contact Page';
        $mdata['contact_person_email'] = $this->input->post('email_address', true);
        $mdata['name'] = 'TalhaTraining Contact';
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from'], $mdata['name']);
        $this->email->to($mdata['to']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . $templateName, $mdata, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();     //Initializes all the email variables to an empty state
    }

    /**
     * @Function            : send_email_for_add_course 
     * @Used IN             : @function-'save_course_more_information'    user_course_model[@Model]
     * @Description         : send Email for add Course from front end OR back end
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-07-2016 03:09 PM   
     * @Parameter           : $notification_id[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function send_email_for_add_course($notification_id) {
        $notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);
        $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($notification_info->notification_type_id);
        $assign_person_id = $this->resource_person_model->get_resource_person_id($course_info->resource_person_id);

        $person_id_array = explode(',', $notification_info->notify_to);

        for ($i = 0; $i < count($person_id_array); $i++) {
            $mdata['name'] = 'TalhaTraining Contact';
            $mdata['from'] = 'no-reply@talhatraining.com';
            $mdata['subject'] = get_message('add_course_message');
            $mdata['title_message'] = 'Talha Training';
            $mdata['site_link'] = base_url() . $course_info->url;
            $mail_sender_info = $this->person_model->get_single_person_info_by_person_id($person_id_array[$i]);

            if ($mail_sender_info->person_message_setting == 1) {
                if ($notification_info->notify_by == $person_id_array[$i]) {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = get_message('add_course_succ_message');
                } else if ($assign_person_id == $person_id_array[$i]) {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = get_message('add_course_r_person_message', $mdata['person_name']);
                } else {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = get_message('add_course_all_person_message', $mdata['person_name']);
                }

                $this->send_mail_to_user($mdata, 'send_email_for_course');
            }
        }
    }

    /**
     * @Function            : send_email_for_edit_course 
     * @Used IN             : @function-'update_course_more_information'    super_admin_course_model[@Model]
     * @Description         : send Email for update Course from front end OR back end
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-08-2016 10:36 AM   
     * @Parameter           : $notification_id[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function send_email_for_edit_course($notification_id) {
        $notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);
        $course_info = $this->user_course_model->get_course_information_with_url_by_course_id($notification_info->notification_type_id);
        $assign_person_id = $this->resource_person_model->get_resource_person_id($course_info->resource_person_id);

        $person_id_array = explode(',', $notification_info->notify_to);

        for ($i = 0; $i < count($person_id_array); $i++) {
            $mdata['name'] = 'TalhaTraining Contact';
            $mdata['from'] = 'no-reply@talhatraining.com';
            $mdata['subject'] = get_message('edit_course_message');
            $mdata['title_message'] = 'Talha Training';
            $mdata['site_link'] = base_url() . $course_info->url;
            $mail_sender_info = $this->person_model->get_single_person_info_by_person_id($person_id_array[$i]);

            if ($mail_sender_info->person_message_setting == 1) {
                if ($notification_info->notify_by == $person_id_array[$i]) {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = get_message('edit_course_succ_message');
                } else if ($assign_person_id == $person_id_array[$i]) {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = $mdata['message'] = get_message('edit_course_r_person_message', $mdata['person_name']);
                } else {
                    $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                    $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                    $mdata['message'] = $mdata['message'] = get_message('edit_course_all_person_message', $mdata['person_name']);
                }

                $this->send_mail_to_user($mdata, 'send_email_for_course');
            }
        }
    }

    /**
     * @Function            : save_course_status_change_notification 
     * @Used IN             : @function-'change_course_status'    super_admin_course[@Controller]
     * @Description         : send Email for change Course status from front end OR back end
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-09-2016 05:10 PM   
     * @Parameter           : $notification_id[INTEGER],$course_info[ARRAY]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_course_status_change_email($notification_id, $person_id, $course_info) {
        $notification_info = $this->notification_model->select_notification_info_by_notification_id($notification_id);
        $person_id_array = array_filter(explode(',', $notification_info->notify_to));
        $notification_msg = $this->notification_course_model->get_notification_type_msg($notification_info->notification_type);
        $person_info = $this->person_model->get_single_person_info_by_person_id($person_id);
        $person_name = $person_info->person_first_name . ' ' . $person_info->person_last_name;

        for ($i = 0; $i < count($person_id_array); $i++) {
            $mail_sender_info = $this->person_model->get_single_person_info_by_person_id($person_id_array[$i]);
            if ($mail_sender_info->person_message_setting == 1) {
                $mdata['name'] = 'TalhaTraining Contact';
                $mdata['from'] = 'no-reply@talhatraining.com';
                $mdata['subject'] = get_message('edit_course_message');
                $mdata['title_message'] = 'Talha Training';
                $mdata['site_link'] = base_url() . $course_info->url;
                $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                $mdata['message'] = get_message('change_course_change_email_msg', $person_name, $course_info->course_name, $notification_msg);
                // Email send to user
                $this->send_mail_to_user($mdata, 'send_email_for_course');
            }
        }
    }

    /**
     * @Function            : send_email_for_course_registration 
     * @Used IN             : @function-'course_registration'    course[@Controller]
     * @Description         : send Email for Course Register from front end
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-09-2016 10:36 AM   
     * @Parameter           : $notification_id[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function send_email_for_course_registration($notification_info, $course_info, $invoice_number = '') {
        $person_id_array = array_filter(explode(',', $notification_info->notify_to));

        for ($i = 0; $i < count($person_id_array); $i++) {
            $mail_sender_info = $this->person_model->get_single_person_info_by_person_id($person_id_array[$i]);
            if ($mail_sender_info->person_message_setting == 1) {
                $mdata['name'] = 'TalhaTraining Contact';
                $mdata['from'] = 'no-reply@talhatraining.com';
                $mdata['subject'] = get_message('course_register_email_title_message');
                $mdata['title_message'] = 'Talha Training';
                $mdata['site_link'] = base_url() . $course_info->url;
                $mdata['to'] = ($mail_sender_info->person_id == 1) ? 'Super Admin' : $mail_sender_info->person_email;
                $mdata['person_name'] = $mail_sender_info->person_first_name . ' ' . $mail_sender_info->person_last_name;
                $mdata['message'] = ($notification_info->notify_by == $person_id_array[$i]) ? get_message('course_registration_learner_succ_email_message') : get_message('course_registration_admin_succ_email_message', $mdata['person_name']);
                // Email send to user
                $this->send_mail_to_user($mdata, 'send_email_for_course');
            }
        }
    }

    /**
     * @Description         : send mail to add payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-12-2016 02:31 PM   
     * */
    function send_to_add_payment_method_mail($person_id) {
        $person_info = $this->person_model->set_person_id($person_id)
                        ->set_field_name('person_first_name', 'person_last_name', 'person_email', 'person_role')
                        ->set_info_by_id()->get_info();
    }

    /**
     * @Function            : send_mail_to_user 
     * @Used IN             : @function-'send_email_for_add_course'    this[@Model]
     * @Description         : send Email format to email
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-07-2016 04:35 PM   
     * @Parameter           : $mdata[Array],$mailView[STRING]
     * @Return              : Null    
     * @Status              : available      
     * */
    function send_mail_to_user($mdata, $mailView) {
        $this->email->set_mailtype('html');
        $this->email->from($mdata['from'], $mdata['name']);
        $this->email->to($mdata['to']);
        $this->email->subject($mdata['subject']);
        $body = $this->load->view('mailScripts/' . $mailView, $mdata, TRUE);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();     //Initializes all the email variables to an empty state
    }

    function send_mail_to_org_teacher($templateName) {
        $data = array();
        $data['admin_name'] = 'TalhaTraining ';
        $data['site_link'] = base_url();
        $data['from'] = 'no-reply@talhatraining.com';
        $data['person_name'] = $this->input->post('person_first_name', true);
        $data['person_password'] = $this->input->post('person_password', TRUE);
        $data['to'] = $this->input->post('person_email', TRUE);
        $data['cc'] = 'training@localhost.com';
        $data['describe_request'] = $this->input->post('describe_request', true);
        $data['subject'] = 'Organisation added you in Talha Training as their Teacher';
        $this->email->set_mailtype('html');
        $this->email->from($data['from'], $data['admin_name']);
        $this->email->to($data['to']);
        $this->email->subject($data['subject']);
        $body = $this->load->view('mailScripts/' . $templateName, $data, true);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear(); //Initializes all the email variables to an empty state
    }

    // send mail format
    private $mail_data;
    private $mail_view_page;

    /**
     * @Description         : set mail data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-01-2016 11:32 AM   
     * */
    function set_mail_data($mail_data) {
        $this->mail_data = $mail_data;
        return $this;
    }

    /**
     * @Description         : set mail view page
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-01-2016 11:32 AM   
     * */
    function set_mail_view_page($mail_view_page) {
        $this->mail_view_page = $mail_view_page;
        return $this;
    }

    /**
     * @Description         : send mail
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-01-2016 11:32 AM   
     * */
    function send_mail() {
        $this->email->set_mailtype('html');
        $this->email->from($this->mail_data['from'], $this->mail_data['name']);
        $this->email->to($this->mail_data['to']);
        $this->email->subject($this->mail_data['subject']);
        $body = $this->load->view('mailScripts/' . $this->mail_view_page, $this->mail_data, TRUE);
        $this->email->message($body);
        $this->email->send();
        $this->email->clear();     //Initializes all the email variables to an empty state
    }

}
