<?php

/**
 * Description of Invoice_payment_model
 *
 * @author MD Jaherul Islam
 */
class Invoice_payment_model extends CI_Model {

    const tbl_name = 'tbl_invoice_payment';
    const primary_key = 'invoice_payment_id';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set invoice  ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:04 PM   
     * */
    private $invoice_id;

    function set_invoice_id($invoice_id) {
        $this->invoice_id = $invoice_id;
        return $this;
    }

    /**
     * @Description         : set invoice payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-01-2017 11:09 AM   
     * */
    function set_invoice_payment_id($invoice_payment_id) {
        $this->invoice_payment_id = $invoice_payment_id;
        return $this;
    }

    /**
     * @Description         : set invoice type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:04 PM   
     * */
    private $type;

    function set_type($type) {
        $this->type = $type;
        return $this;
    }

    /**
     * @Description         : set invoice type ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:04 PM   
     * */
    private $type_id;

    function set_type_id($type_id) {
        $this->type_id = $type_id;
        return $this;
    }

    /**
     * @Description         : set currency type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-11-2016 06:26 PM   
     * */
    private $currency_type;

    function set_currency_type($currency_type) {
        $this->currency_type = $currency_type;
        return $this;
    }

    /**
     * @Description         : get currency type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 30-11-2016 10:08 AM   
     * */
    function get_currency() {
        return $this->currency_type;
    }

    /**
     * @Description         : set invoice paid amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:04 PM   
     * */
    private $paid_amount;

    function set_paid_amount($paid_amount) {
        $this->paid_amount = $paid_amount;
        return $this;
    }

    /**
     * @Description         : create date time format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 02:32 PM   
     * */
    private $datetime;

    function datetime() {
        $this->datetime = date('Y-m-d h:i:s', (time() - $this->session->time_offset));
        return $this;
    }

    /**
     * @Description         : get insert ID [if payment data saved into database]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:06 PM   
     * */
    private $invoice_payment_id;

    function set_insert_id() {
        $this->invoice_payment_id = $this->db->insert_id();
        return $this;
    }

    /**
     * @Description         : set field name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-01-2017 10:43 AM   
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * @Description         : get invoice_payment_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:06 PM   
     * */
    function get_id() {
        return $this->invoice_payment_id;
    }

    /**
     * @Description         : save Invoice Payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-11-2016 03:08 PM   
     * */
    function save() {
        $data = [];
        $data['invoice_id'] = $this->invoice_id;
        $data['invoice_payment_type'] = $this->type;
        $data['invoice_payment_type_id'] = $this->type_id;
        $data['currency_type'] = $this->currency_type;
        $data['paid_amount'] = $this->paid_amount;
        $data['invoice_paid_date'] = $this->datetime;
        $this->db->insert(self::tbl_name, $data);
        return $this;
    }

    /**
     * @Description         : delete Invoice Payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-01-2017 11:12 AM   
     * */
    function delete() {
        $this->db->where(self::primary_key, $this->invoice_payment_id)
                ->delete(self::tbl_name);
        return $this;
    }

    /**
     * @Description         : set invoice ID array
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 06:35 PM   
     * */
    private $invoice_id_array;

    function set_invoice_id_array($invoice_id_array) {
        $this->invoice_id_array = $invoice_id_array;
        return $this;
    }

    /**
     * @Description         : get currency type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-11-2016 02:54 PM   
     * */
    function get_currency_type() {
        return $this->db->select('currency_type')
                        ->from(self::tbl_name)
                        ->where_in('invoice_id', $this->invoice_id_array)->get()->row()->currency_type;
    }

    /**
     * @Description         : get currency information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2016 03:18 PM   
     * */
    function set_currency_info() {
        $this->result = $this->db->select('currency_type')
                        ->from(self::tbl_name)
                        ->where_in('invoice_id', $this->invoice_id_array)->get()->row();
        return $this;
    }

    /**
     * @Description         : get invoice paid amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 04:40 PM   
     * */
    function get_paid_amount() {
        return $this->db->select('SUM(paid_amount) AS total')
                        ->from(self::tbl_name)
                        ->where_in('invoice_id', $this->invoice_id_array)->get()->row()->total;
    }

    /**
     * @Description         : get invoice payment information by invoice ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-01-2017 10:41 AM   
     * */
    function get_invoice_payment_info_by_invoice_id() {
        $this->result = $this->db->select($this->field_name)
                        ->from(self::tbl_name)->where('invoice_id', $this->invoice_id)->get()->row();
        return $this;
    }
    
    /**
     * @Description         : get invoice payment information by multiple invoice ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-02-2017 04:20 PM   
     * */
    function get_invoice_payment_info_by_multiple_invoice_id() {
        $this->result = $this->db->select($this->field_name)
                        ->from(self::tbl_name)->where_in('invoice_id', $this->invoice_id)->get()->result();
        return $this;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-01-2016 03:17 PM   
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

}
