<?php

/**
 * Description=> View all kind of invoice information
 *
 * @author Ripon Jaherul
 */
class Invoice_model extends CI_Model {

    const tbl_name = 'tbl_invoice';
    const primary_key = 'invoice_id';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set payment ID for Invoice Table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 01:57 PM   
     * */
    private $payment_id;

    function set_payment_id($payment_id) {
        $this->payment_id = $payment_id;
        return $this;
    }

    /**
     * @Description         : create date time format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 02:32 PM   
     * */
    private $datetime;

    function datetime() {
        $this->datetime = date('Y-m-d h:i:s', (time() - $this->session->time_offset));
        return $this;
    }

    /**
     * @Description         : set description for Invoice Table
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 02:25 PM   
     * */
    private $description;

    function set_description($description) {
        $this->description = $description;
        return $this;
    }

    /**
     * @Description         : set date for view all Invouce
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 02:07 PM
     * */
    private $date;

    function set_date($date) {
        $this->date = $date;
        return $this;
    }

    /**
     * @Description         : set status for view all Invouce
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 02:07 PM   
     * */
    private $status;

    function set_status($status) {
        $this->status = $status;
        return $this;
    }

    /**
     * @Description         : set limit for view all Invouce
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 02:07 PM   
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : set invoice ID 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 10:22 AM   
     * */
    function set_invoice_id($invoice_id) {
        $this->invoice_id = $invoice_id;
        return $this;
    }

    /**
     * @Description         : get insert ID [if payment data saved into database]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:52 PM   
     * */
    private $invoice_id;

    function get_insert_id() {
        $this->invoice_id = $this->db->insert_id();
        return $this;
    }

    /**
     * @Description         : get payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 12:54 PM   
     * */
    function get_id() {
        return $this->invoice_id;
    }

    /**
     * @Description         : get all Invoice ID by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-11-2016 05:48 PM   
     * */
    function get_all_id_by_payment_id() {
        return $this->db->select('(GROUP_CONCAT(invoice_id)) AS id')
                        ->from(self::tbl_name)
                        ->where('payment_id', $this->payment_id)->get()->row()->id;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:53 PM   
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : get all Invoice Information by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 06:44 PM   
     * */
    function get_info_by_payment_id() {
        $this->db->select('*')->from(self::tbl_name . ' AS i')
                ->join('tbl_payment AS p', 'i.payment_id = p.payment_id')
                ->where_in('i.payment_id', $this->payment_id);
        if ($this->date) {
            $start_date = $this->date['invoice_start_date'];
            $end_date = $this->date['invoice_end_date'];
            $this->db->where("DATE(i.invoice_created_date) BETWEEN '$start_date' AND '$end_date'");
        }
        if (!empty($this->status)) {
            $this->db->where('p.payment_status', $this->status);
        }
        $this->result = $this->db->order_by(self::primary_key, 'DESC')
                        ->limit(10, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : get total Invoice by multiple payment ID [Person ID]
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-11-2016 12:10 PM   
     * */
    function total_invoice() {
        $this->db->select('*')->from(self::tbl_name . ' AS i')
                ->join('tbl_payment AS p', 'i.payment_id = p.payment_id')
                ->where_in('i.payment_id', $this->payment_id);
        if ($this->date) {
            $start_date = $this->date['invoice_start_date'];
            $end_date = $this->date['invoice_end_date'];
            $this->db->where("DATE(i.invoice_created_date) BETWEEN '$start_date' AND '$end_date'");
        }
        if (!empty($this->status)) {
            $this->db->where('p.payment_status', $this->status);
        }
        return $this->db->count_all_results();
    }

    /**
     * @Description         : set all invoice information by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-12-2016 10:02 AM   
     * */
    function set_all_invoice_info_by_payment_id() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where('payment_id', $this->payment_id)->get()->result();
        return $this;
    }

    /**
     * @Description         : set all invoice ID by payment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-12-2016 10:02 AM   
     * */
    function set_all_invoice_id_by_payment_id() {
        $this->result = $this->db->select('GROUP_CONCAT(invoice_id) AS id')->from(self::tbl_name)
                        ->where_in('payment_id', $this->payment_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : save Invoice information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-11-2016 02:27 PM   
     * */
    function save() {
        $data = [];
        $data['payment_id'] = $this->payment_id;
        $data['invoice_created_date'] = $this->datetime;
        $data['invoice_description'] = $this->description;
        $this->db->insert(self::tbl_name, $data);
        return $this;
    }

    /**
     * @Description         : delete Invoice information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-11-2016 10:17 PM   
     * */
    function delete() {
        $this->db->where(self::primary_key, $this->invoice_id)
                ->delete(self::tbl_name);
    }

}
