<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Front_End_Support_Model extends CI_Model {
   
    
    /**
     * Function            : select_all_knowledgebase_info
     * Used IN             : function['support'] controller['front_end_support']
     * Description         : get all knowledgebase information and arrange by decending order
     * Developed By        : Tania Akter
     * Start DateTime      : 28/04/2016  
     * Status              : available      
     * */
    function select_all_knowledgebase_info() {
        $sql = "SELECT * FROM tbl_support WHERE support_type='1' AND support_status = '1' ORDER BY support_id DESC";
        return $this->db->query($sql)->result();
    }   
    
     /**
     * Function            : get_knowledgebase_info
     * Used IN             : function['support_knowledgebase'] controller['front_end_support']
     * Description         : get knowledgebase info by support id
     * Developed By        : Tania Akter
     * Start DateTime      : 28/04/2016  
     * Status              : available      
     * */
    function get_knowledgebase_info($support_id) {
        $sql = "SELECT * FROM tbl_support WHERE support_id='$support_id' ";
        return $this->db->query($sql)->row();
    }
    
     /**
     * Function            : select_related_knowledgebase_info
     * Used IN             : function['support_more_knowledgebase', 'support_knowledgebase'] controller['front_end_support'] 
     * Description         : used to get related knowledgebase
     * Developed By        : Tania Akter
     * Start DateTime      : 28/04/2016  
     * Status              : available      
     * */
    function select_related_knowledgebase_info($number) {
        $sql = "SELECT * FROM tbl_support WHERE support_type='1' AND support_status='1' ORDER BY support_id DESC LIMIT $number";
        return $this->db->query($sql)->result();
    }
     /**
     * Function            : select_total_related_knowledgebase_info
     * Used IN             : function['support_more_knowledgebase', 'support_knowledgebase'] controller['front_end_support'] 
     * Description         : get total numbers of active knowledgebase
     * Developed By        : Tania Akter
     * Start DateTime      : 30/04/2016  
     * Status              : available      
     * */
    function select_total_related_knowledgebase_info() {
        $sql = "SELECT "
                . "count(*) AS total_knowledgebase "
                . "FROM "
                . "tbl_support "
                . "WHERE support_type='1' AND support_status='1'";
        return $this->db->query($sql)->row();
    }
   
     /**
     * Function            : select_all_ideas_info
     * Used IN             : function['ideas'] controller['front_end_support'] 
     * Description         : used to get all active ideas
     * Developed By        : Tania Akter
     * Start DateTime      : 30/04/2016  
     * Status              : available      
     * */
    function select_all_ideas_info() {
        $sql = "SELECT * FROM tbl_support WHERE support_type='2' AND support_status = '1' ORDER BY support_id DESC";
        return $result = $this->db->query($sql)->result();
    }
    
     /**
     * @Function            : get_profile_url
     * @Used IN             :function['add_idea']['add_reply_idea']['bug_report_add'] controller['front_end_support']  
     * @Description         : used to get person url
     * @Developed By        : Tania Akter
     * @Start DateTime      : 2/04/2016  
     * @Status              : available      
     * */
    function get_profile_url($person_id) {
        $sql = "SELECT url
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->url;
    } 
    
        /**
     * @Function            : save_idea
     * @Used IN             : function['add_idea'] controller['front_end_support'] 
     * @Description         : used to save idea with attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 2/05/2016  
     * @Status              : available      
     * */
    function save_idea($user_id, $person_url) {
        $today = date('Y-m-d H:i:s', strtotime(gmdate("Y-m-d H:i:s")));
        $data = array();
        $data['person_id'] = $user_id;
        $data['support_title'] = $this->input->post('idea_title', TRUE);
        $data['support_description'] = $this->input->post('idea_describe', TRUE);
        $data['support_type'] = 2; // here, 1 means support type is knowledgebase
        $data['support_status'] = 0; // here, 1 means support status is active
        $data['support_date_time'] = $today;
        $this->db->insert('tbl_support', $data);
        $support_type_id = $this->db->insert_id();
        if ($_FILES['idea_file']) {
            $this->file_upload($person_url, $support_type_id);
        }
    }
    
    
        /**
     * @Function            : file_upload
     * @Used IN             : *function[save_idea], *model[super_admin_support_model];
     * @Description         : used to upload file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 2/05/2016  
     * @Status              : available      
     * */
    function file_upload($person_url, $support_type_id) {
        $fileName = $_FILES["idea_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["idea_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["idea_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->idea_file_move($support_type_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : idea_file_move
     * @Used IN             : *function[file_upload], *model[super_admin_support_model];
     * @Description         : used to move idea assignment file in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function idea_file_move($support_type_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->save_idea_file($support_type_id, $support_attachment_location);
    }

    /**
     * @Function            : save_idea_file
     * @Used IN             : *function[idea_file_move], *model[super_admin_support_model];
     * @Description         : used to save idea assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function save_idea_file($support_type_id, $support_attachment_location) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 1; //here, 1 means support_type 
        $data['support_type_id'] = $support_type_id;
        $this->db->insert('tbl_support_attachment', $data);
    }

    
      /**
     * @Function            : sign_in_person_all_info
     * @Used IN             : *function[support_idea] *controller[front_end_support] line--165
     *                        *function['support_bug_report'] *controller[front_end_support]
     * @Description         : used to get person info who are signed in
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function sign_in_person_all_info($user_id) {
        $sql = "SELECT * FROM  tbl_person AS p, tbl_url AS u WHERE  p.url_id= u.url_id  AND p.person_id= '$user_id' ";
        return $this->db->query($sql)->row();
    }
    
       /**
     * @Function            : get_idea_info
     * @Used IN             : *function['support_idea','reply_support_idea'][view_support_idea], *controller['front_end_support'];
     * @Description         : used to get information about idea 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function get_idea_info($support_id) {
        $sql = "SELECT *, s.person_id AS support_creator_id
                FROM tbl_support AS s,
                tbl_person AS p,
                tbl_url AS u
                WHERE s.person_id = p.person_id
                AND p.url_id = u.url_id
                AND s.support_id= '$support_id' ";
        return $this->db->query($sql)->row();
    } 
        /**
     * @Function            : select_related_idea_info
     * @Used IN             : *function['support_idea'],,['support_more_idea'],['support_bug_report'] *controller['front_end_support'];
     * @Description         : used to get related info (idea/ bug report)
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function select_related_info($number, $type) {
        $sql = "SELECT * FROM tbl_support WHERE support_type= '$type' AND support_status= '1' ORDER BY support_id DESC LIMIT $number";
        return $this->db->query($sql)->result();
    }
    
     /**
     * @Function            : select_total_related_idea_info
     * @Used IN             : *function['support_idea'],['support_more_idea'], *controller['front_end_support'];
     * @Description         : get total numbers of idea file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function select_total_related_idea_info() {
        $sql = "SELECT count(*) AS total_idea FROM tbl_support WHERE support_type= '2' AND support_status= '1'";
        return $this->db->query($sql)->row();
    }
      /**
     * @Function            : get_all_idea_reply
     * @Used IN             : *function['support_idea'],*controller['front_end_support'];
     * @Description         : used to get  file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function get_all_idea_reply($support_id) {
        $sql = " SELECT *
         FROM 
            tbl_support_reply AS r,            
            tbl_url AS u,
            tbl_person AS p    
        WHERE 
             r.support_id = '$support_id'
             AND r.person_id = p.person_id
             AND p.url_id = u.url_id             
            ";
        return $this->db->query($sql)->result();
    }
    
      /**
     * @Function            : get_reply_download_info
     * @Used IN             : *function['support_idea'],*controller['front_end_support'];
     * @Description         : used to idea/bug report reply download info
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function get_reply_download_info($support_reply_id, $type) {
        $sql = "SELECT * 
	FROM tbl_support_attachment AS a,
			tbl_support_reply AS r,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			r.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=r.support_reply_id
                        AND
                        r.support_reply_id= '$support_reply_id'
			AND a.support_attachment_type='$type'";
        return $this->db->query($sql)->row();
    }
    
        /**
     * @Function            : get_download_info
     * @Used IN             : *function['support_idea']['support_bug_report'],*controller['front_end_support'];
     * @Description         : used to get  attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function get_download_info($support_id, $type) {
        $sql = "SELECT * 
	FROM tbl_support_attachment AS a,
			tbl_support AS s,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			s.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=s.support_id
                        AND
                        a.support_type_id= $support_id
			AND a.support_attachment_type='$type'";
        return $this->db->query($sql)->row();
    }
    
        /**
     * @Function            : save_reply_idea
     * @Used IN             : *function['add_reply_idea'], *controller['front_end_support'];
     * @Description         : used to save reply idea file with attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function save_reply_idea($user_id, $person_url, $support_id) {
        $today = date('Y-m-d H:i:s', strtotime(gmdate("Y-m-d H:i:s")));
        $data = array();
        $data['person_id'] = $user_id;
        $data['support_id'] = $support_id;
        $data['support_reply_description'] = $this->input->post('support_reply_description', TRUE);
        $data['support_reply_date_time'] = $today;
        $this->db->insert('tbl_support_reply', $data);
        $support_idea_reply_type_id = $this->db->insert_id();
        if ($_FILES['idea_reply_file']) {
            $this->idea_reply_file_upload($person_url, $support_idea_reply_type_id);
        }
    }

    /**
     * @Function            : idea_reply_file_upload
     * @Used IN             : *function[save_reply_idea], *model[super_admin_support_model];
     * @Description         : used to reply upload file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function idea_reply_file_upload($person_url, $support_idea_reply_type_id) {
        $fileName = $_FILES["idea_reply_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["idea_reply_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["idea_reply_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->idea_reply_file_move($support_idea_reply_type_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : idea_reply_file_move
     * @Used IN             : *function[idea_reply_file_upload], *model[super_admin_support_model];
     * @Description         : used to move idea reply assignment file in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function idea_reply_file_move($support_idea_reply_type_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->save_idea_reply_file($support_attachment_location, $support_idea_reply_type_id);
    }

    /**
     * @Function            : save_idea_reply_file
     * @Used IN             : *function[idea_reply_file_upload], *model[super_admin_support_model];
     * @Description         : used to save idea reply assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 08/05/2016  
     * @Status              : available      
     * */
    function save_idea_reply_file($support_attachment_location, $support_idea_reply_type_id) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 2; //here, 1 means support_type 
        $data['support_type_id'] = $support_idea_reply_type_id;
        $this->db->insert('tbl_support_attachment', $data);
    }
    
        /**
     * @Function            : get_reply_idea_doenload_file_info
     * @Used IN             : *function[download_idea_reply_file],[download_bug_report_reply_attachment]
     *                          *controller[super_admin_support_model]  line--265
     * @Description         : used to download idea reply file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function get_reply_idea_doenload_file_info($support_attachment_id) {
        $sql = "SELECT *
            FROM tbl_support_attachment AS sa,
            tbl_support_reply AS sr,
            tbl_person AS p,
            tbl_url AS u
                WHERE sa.support_attachment_id = '$support_attachment_id'
                AND sa.support_attachment_type = '2'
                AND sa.support_type_id = sr.support_reply_id
                AND sr.person_id = p.person_id
                AND p.url_id = u.url_id
                AND u.url_type = '10' ";
        return $this->db->query($sql)->row();
    }
         /**
     * Function            : select_all_bug_reports_info
     * Used IN             : function['bug_report'] controller['front_end_support'] 
     * Description         : used to get all active bug reports
     * Developed By        : Tania Akter
     * Start DateTime      : 16/05/2016  
     * Status              : available      
     * */
    function select_all_bug_reports_info() {
        $sql = "SELECT * FROM tbl_support WHERE support_type='3' AND support_status = '1' ORDER BY support_id DESC";
        return $result = $this->db->query($sql)->result();
    }
    
    
        /**
     * Function            : save_bug_report
     * Used IN             : function['bug_report_add'] controller['front_end_support']
     * Description         : used to save bug report
     * Developed By        : Tania Akter
     * Start DateTime      : 15/05/2016  
     * Status              : available      
     * */
    function save_bug_report($user_id, $person_url){
         $today = date('Y-m-d H:i:s', strtotime(gmdate("Y-m-d H:i:s")));
        $data = array();
        $data['person_id'] = $user_id;
        $data['support_title'] = $this->input->post('bug_subject', TRUE);
        $data['support_description'] = $this->input->post('bug_describe', TRUE);
        $data['support_type'] = 3; // here, 3 means support type is bug report
        $data['support_status'] = 0; // here, 0 means support status is inactive
        $data['support_date_time'] = $today;
        $this->db->insert('tbl_support', $data);
        $support_type_id = $this->db->insert_id();
        if ($_FILES['bug_file']) {
            $this->bug_report_attach_upload($person_url, $support_type_id);
        }
    }
    
        /**
     * Function            : bug_report_attach_upload
     * Used IN             : function['save_bug_report'] model['super_admin_support_model']
     * Description         : used to upload bug report attachment
     * Developed By        : Tania Akter
     * Start DateTime      : 15/05/2016  
     * Status              : available      
     * */
    
    function bug_report_attach_upload($person_url, $support_type_id) {
        $fileName = $_FILES["bug_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["bug_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["bug_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->bug_report_attach_move($support_type_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : idea_file_move
     * @Used IN             : *function[bug_report_attach_upload], *model[super_admin_support_model];
     * @Description         : used to move  bug report attachment file in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function bug_report_attach_move($support_type_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->save_bug_report_attach($support_type_id, $support_attachment_location);
    }

    /**
     * @Function            : save_bug_report_attach
     * @Used IN             : *function[bug_report_attach_move], *model[super_admin_support_model];
     * @Description         : used to save bug report assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 15/05/2016  
     * @Status              : available      
     * */
    function save_bug_report_attach($support_type_id, $support_attachment_location) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 1; //here, 1 means support_type 
        $data['support_type_id'] = $support_type_id;
        $this->db->insert('tbl_support_attachment', $data);
    }
           /**
     * @Function            : get_bug_report_info
     * @Used IN             : *function['support_bug_report'] *controller['front_end_support'];               
     * @Description         : used to get information about bug report 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function get_bug_report_info($support_id) {
        $sql = "SELECT *, s.person_id AS support_creator_id
                FROM tbl_support AS s,
                tbl_person AS p,
                tbl_url AS u
                WHERE s.person_id = p.person_id
                AND p.url_id = u.url_id
                AND s.support_id= '$support_id' ";
        return $this->db->query($sql)->row();
    }
        /**
     * @Function            : select_total_related_bug_report_info
     * @Used IN             : *function['support_more_bug_report'],['support_bug_report'], *controller['front_end_support'];
     * @Description         : get total numbers of bug report file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function select_total_related_bug_report_info() {
        $sql = "SELECT count(*) AS total_bug_report FROM tbl_support WHERE support_type= '3' AND support_status= '1'";
        return $this->db->query($sql)->row();
    }
        /**
     * @Function            : get_all_bug_report_reply
     * @Used IN             : *function['support_bug_report'],*controller['front_end_support'];
     *                       *function[view_support_bug_report],['reply_support_bug_report'] *controller['super_admin_support'];
     * @Description         : used to get  bug report reply 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function get_all_bug_report_reply($support_id) {
        $sql = " SELECT *
         FROM 
            tbl_support_reply AS r,            
            tbl_url AS u,
            tbl_person AS p    
        WHERE 
             r.support_id = '$support_id'
             AND r.person_id = p.person_id
             AND p.url_id = u.url_id             
            ";
        return $this->db->query($sql)->result();
    }
        /**
     * @Function            : get_idea_doenload_file_info
     * @Used IN             : *function[download_idea_file][download_bug_report_attachment], *model[super_admin_support_model];
     * @Description         : used to get  file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function get_idea_download_file_info($support_attachment_id) {
        // $sql = "SELECT * FROM tbl_support_attachment WHERE support_attachment_id = $support_attachment_id";
        $sql = "SELECT * "
                . "FROM "
                . "tbl_support AS s, "
                . "tbl_person AS p, "
                . "tbl_url AS u, "
                . "tbl_support_attachment AS t "
                . "WHERE "
                . "s.person_id = p.person_id "
                . "AND p.url_id= u.url_id "
                . "AND s.support_id= t.support_type_id "
                . "AND t.support_attachment_id= '$support_attachment_id' ";
        return $this->db->query($sql)->row();
    }
        /**
     * @Function            : save_reply_bug_report
     * @Used IN             : *function['add_reply_bug_report'], *controller['front_end_support'];
     * @Description         : used to save reply bug report with attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function save_reply_bug_report($user_id, $person_url, $support_id) {
        $today = date('Y-m-d H:i:s', strtotime(gmdate("Y-m-d H:i:s")));
        $data = array();
        $data['person_id'] = $user_id;
        $data['support_id'] = $support_id;
        $data['support_reply_description'] = $this->input->post('reply_bug_report_description', TRUE);
        $data['support_reply_date_time'] = $today;
        $this->db->insert('tbl_support_reply', $data);
        $support_idea_reply_type_id = $this->db->insert_id();
        if ($_FILES['bug_report_reply_file']) {
            $this->bug_report_reply_file_upload($person_url, $support_idea_reply_type_id);
        }
    }

    /**
     * @Function            : bug_report_reply_file_upload
     * @Used IN             : *function[save_reply_bug_report], *model[super_admin_support_model];
     * @Description         : used to bug report reply upload file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function bug_report_reply_file_upload($person_url, $support_idea_reply_type_id) {
        $fileName = $_FILES["bug_report_reply_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["bug_report_reply_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["bug_report_reply_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->bug_report_reply_file_move($support_idea_reply_type_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : bug_report_reply_file_move
     * @Used IN             : *function[bug_report_reply_file_upload], *model[super_admin_support_model];
     * @Description         : used to move bug report reply assignment file in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function bug_report_reply_file_move($support_idea_reply_type_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->save_bug_report_reply_file($support_attachment_location, $support_idea_reply_type_id);
    }

    /**
     * @Function            : save_idea_reply_file
     * @Used IN             : *function[bug_report_reply_file_move], *model[super_admin_support_model];
     * @Description         : used to save bug report reply assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function save_bug_report_reply_file($support_attachment_location, $support_idea_reply_type_id) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 2; //here, 1 means support_type 
        $data['support_type_id'] = $support_idea_reply_type_id;
        $this->db->insert('tbl_support_attachment', $data);
    }
}
