<?php

/**
 * Description of Coupon_model
 *
 * @author MD Jaherul Islam
 */
class Coupon_model extends CI_Model {

    const tbl_name = 'tbl_coupon';
    const primary_key = 'coupon_id';

    private $coupon_arr = [];

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set field name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 04:49 PM   
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * @Description         : set coupon type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 04:49 PM   
     * */
    private $coupon_id;

    function set_coupon_id($coupon_id) {
        $this->coupon_id = $coupon_id;
        return $this;
    }

    /**
     * @Description         : set coupon type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 04:49 PM   
     * */
    private $coupon_type;

    function set_coupon_type($coupon_type) {
        $this->coupon_type = $coupon_type;
        return $this;
    }

    /**
     * @Description         : set date
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 05:02 PM   
     * */
    private $date;

    function set_date($date) {
        $this->date = $date;
        return $this;
    }

    /**
     * @Description         : set coupon status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 05:03 PM   
     * */
    private $coupon_status;

    function set_coupon_status($coupon_status) {
        $this->coupon_status = $coupon_status;
        return $this;
    }

    /**
     * @Description         : set price
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2016 06:03 PM   
     * */
    private $price_currency;

    function set_price_currency($price_currency) {
        $this->price_currency = $price_currency;
        return $this;
    }

    /**
     * @Description         : set price
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2016 06:03 PM   
     * */
    private $price;

    function set_price($price) {
        $this->price = $price;
        return $this;
    }

    /**
     * @Description         : set coupon information by coupon ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-01-2016 04:37 PM   
     * */
    function set_coupon_info_by_coupon_id() {
        $this->result = $this->db->select($this->field_name)
                        ->from(self::tbl_name)->where('coupon_id', $this->coupon_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set coupon data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 04:49 PM   
     * */
    function set_coupon_data() {
        $this->result = $this->db->select($this->field_name)->from(self::tbl_name)->where('coupon_type', $this->coupon_type)
                        ->where("(('$this->date' BETWEEN coupon_start_date AND coupon_finish_date) OR coupon_can_use_number != 0)")
                        ->where('coupon_status', $this->coupon_status)->get()->result();
        return $this;
    }

    /**
     * @Description         : calculate coupon discount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 04:49 PM   
     * */
    function calculate_coupon_discount() {
        $coupon_info = $this->set_field_name('coupon_id,coupon_price_type,coupon_discount_amount,coupon_can_use_number')->set_coupon_id($this->coupon_id)
                        ->set_coupon_info_by_coupon_id()->get_result();

        if ($coupon_info->coupon_price_type == 1) {
            // update coupon use number
            $this->update_coupon_can_use_number($coupon_info);
            $this->result = (($this->price * $coupon_info->coupon_discount_amount) / 100);
        }

        if ($coupon_info->coupon_price_type == 2) {
            if ($this->price_currency == 2) {
                $this->result = $this->tt_currency->set($coupon_info->coupon_discount_amount, 'BDT', 'USD')->convert_currency()->get();
            } else {
                $this->result = $coupon_info->coupon_discount_amount;
            }
        }
        return $this;
    }

    /**
     * @Description         : update coupon use number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 17-01-2016 10:45 AM   
     * */
    function update_coupon_can_use_number($coupon_info) {
        $this->coupon_arr['coupon_can_use_number'] = --$coupon_info->coupon_can_use_number;
        $this->set_coupon_id($coupon_info->coupon_id)->update();
        return $this;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-01-2016 05:04 PM   
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : update payment table data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 22-11-2016 10:13 AM   
     * */
    function update() {
        $this->db->where(self::primary_key, $this->coupon_id)
                ->update(self::tbl_name, $this->coupon_arr);
        return $this;
    }

    /**
     * @Description         : coupon create table query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-10-2016 03:51 PM   
     * */
    function coupon_table_query() {
        $sql = "CREATE TABLE `tbl_coupon` (
	`coupon_id` INT(11) NOT NULL AUTO_INCREMENT,
	`coupon_name` VARCHAR(256) NULL DEFAULT NULL,
	`coupon_can_use_number` INT(11) NULL DEFAULT NULL COMMENT 'how_many_times_coupon_can_use',
	`coupon_start_date` DATE NULL DEFAULT NULL,
	`coupon_finish_date` DATE NULL DEFAULT NULL,
	`coupon_code` VARCHAR(50) NULL DEFAULT NULL COMMENT 'a_z_0_9_A_Z',
	`coupon_discount_amount` DECIMAL(10,2) NULL DEFAULT NULL,
	`coupon_status` TINYINT(4) NULL DEFAULT NULL COMMENT 'active=1;inactive=2(after_finish_date_it_will_be_inactive_automatically)',
	`coupon_expire_type` TINYINT(4) NULL DEFAULT NULL COMMENT 'number=1;date=2',
	`coupon_price_type` TINYINT(4) NULL DEFAULT NULL COMMENT 'percentage=1;fixed=2',
	`coupon_type` TINYINT(4) NULL DEFAULT NULL COMMENT 'feature=1;course=2;video_course=3',
	PRIMARY KEY (`coupon_id`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=3
;";
    }

}
