<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of content_library_model
 *
 * @author MD Jaherul Islam
 */
class Content_library_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : save_content_library_file 
     * @Used IN             : @function-'save_file_path'         tinymce_model[@Model]
     * @Description         : save content library information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 28-07-2016 11:59 AM 
     * @Parameter           : $file_path[STRING], $type[INTEGER],$id[INTEGER]
     * @Return              : $id[INTEGER]           
     * @Status              : available      
     * */
    function save_content_library_file($file_path, $type, $type_id) {
        $data = Array();
        $data['content_library_location'] = $file_path;
        $data['content_library_type'] = $type;
        $data['content_library_type_id'] = $type_id;
        return $this->utility_model->save_information_in_database('tbl_content_library', $data);
    }

    /**
     * @Function            : get_content_library_info_by_content_library_id 
     * @Used IN             : @function-'view_tinymce_hiperlink_file'         tinymce_model[@Model]
     * @                    : @function-'view_tinymce_source_file'            tinymce_model[@Model]
     * @Description         : get content library information by content library ID
     *                        @Update1=> Convert Active Query
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 17-07-2016 10:00 AM 
     * @Updated Date Time   : 07-09-2016 07:02 PM
     * @Updated By          : MD Jaherul Islam 
     * @Parameter           : $content_library_id[INTEGER]
     * @Return              : $data[ARRAY]        
     * @Status              : available      
     * */
    function get_content_library_info_by_content_library_id($content_library_id) {
        return $this->db->get_where('tbl_content_library', Array('content_library_id' => $content_library_id))->row();
    }

    /**
     * @Function            : get_content_library_infomation 
     * @Description         : get content library information by content library ID, type and status
     *                        @Update1=> Convert Active Query
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 28-07-2016 11:39 AM 
     * @Updated Date Time   : 07-09-2016 07:02 PM
     * @Updated By          : MD Jaherul Islam 
     * @Parameter           : $type[STRING], $type_id[INTEGER], $status[STRING]
     * @Return              : $data[ARRAY]        
     * @Status              : available      
     * */
    function get_content_library_infomation($type, $type_id, $status) {
        return $this->db->get_where('tbl_content_library', Array('content_library_type' => $type,
                    'content_library_type_id' => $type_id,
                    'content_deletion_status' => $status))->result();
    }

    /**
     * @Function            : check_content_library_path 
     * @Used IN             : @function-'check_folder_for_tinymce'  tinymce_model[@Model],
     * @Description         : check content librart path using path
     *                        @Update1=> Convert Active Query
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 30-07-2016 02:39 PM 
     * @Updated Date Time   : 07-09-2016 07:02 PM
     * @Updated By          : MD Jaherul Islam 
     * @Parameter           : $type[INTEGER](Which Type = Course/Video Course/Quiz.....), 
     *                        $id[INTEGER] (Course id/Video Course Id/Quiz ID.....),
     *                        $path[STRING] (check file path)
     * @Return              : $data[ARRAY]        
     * @Status              : available      
     * */
    function check_content_library_path($type, $id, $path) {
        return $this->db->get_where('tbl_content_library', Array('content_library_type' => $type,
                    'content_library_type_id' => $id,
                    'content_library_location' => $path))->row();
    }

    /**
     * @Function            : get_total_content_library_path 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : get total content library if content_path remaining several times 
     *                        @Update1=> Convert Active Query
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-06-2016 11:26 AM 
     * @Updated Date Time   : 07-09-2016 07:02 PM
     * @Updated By          : MD Jaherul Islam  
     * @Parameter           : $id[INTEGER], $type[INTEGER], $file_path[STRING]
     * @Return              : $total_row[INTEGER]  
     * @Status              : available      
     * */
    function get_total_content_library_path($id, $type, $file_path) {
        return $this->db->select('*')
                        ->from('tbl_content_library')
                        ->where(Array('content_library_type' => $type,
                            'content_library_type_id' => $id,
                            'content_library_location' => $file_path))->count_all_results();
    }

    /**
     * @Function            : remove_content_library_file 
     * @Used IN             : @function-'remove_multiple_content_library_file'    this[@Model]
     * @Description         : remove content library file
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:27 AM   
     * @Parameter           : $id[INTEGER](Course id/Video Course Id/Quiz ID.....),  
     *                        $old_content_id_array[ARRAY], 
     *                        $content_library_type[INTEGER], 
     *                        $upload_dir[STRING]
     * @Return              : Null  
     * @Status              : available      
     * */
    function remove_content_library_file($id, $old_content_id_array, $type, $upload_dir) {
        foreach ($old_content_id_array as $value) {
            $content_library_info = $this->get_content_library_info_by_content_library_id($value);
            $total_content_library = $this->get_total_content_library_path($id, $type, $content_library_info->content_library_location);
            if ($total_content_library == 1) {
                $remove_file = $upload_dir . '/' . $content_library_info->content_library_location;
                if (is_file($remove_file)) {
                    unlink($remove_file);
                }
            }
            $this->utility_model->delete_information_in_database('tbl_content_library', 'content_library_id', $value);
        }
    }

    /**
     * @Function            : delete_content_library 
     * @Used IN             : @function-'update_tinymce_information'  user_course_model[@Model]
     * @Description         : delete content library info into Database
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 30-07-2016 03:44 PM   
     * @Parameter           : $old_content_id_array[ARRAY]
     * @Return              : Null
     * @Status              : available      
     * */
    function delete_content_library($old_content_id_array) {
        foreach ($old_content_id_array as $value) {
            $this->utility_model->delete_information_in_database('tbl_content_library', 'content_library_id', $value);
        }
    }

    /**
     * @Function            : remove_multiple_content_library_file 
     * @Used IN             : @function-'update_course_all_tinymce_information'  user_course[@Model]
     * @Description         : remove multiple content library file
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:37 AM   
     * @Parameter           : $person_url[STRING], $course_url[STRING], $old_content_id_array[ARRAY]
     * @Return              : $content_path_array[ARRAY]  
     * @Status              : available      
     * */
    function remove_multiple_content_library_file($id, $description, $type, $upload_dir) {
        $update_content_id_array = $this->get_all_content_library_id_from_tinymce($description);
        if ($update_content_id_array) { // IF delete some file from tinymce
            $this->remove_content_library_file($id, $update_content_id_array, $type, $upload_dir);
        }
    }

    /**
     * @Function            : get_all_content_library_path_tinymce 
     * @Used IN             : @function-''  [@Model]
     * @Description         : get content library path array using Tinymce Description
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:37 AM   
     * @Parameter           : $person_url[STRING], $course_url[STRING], $old_content_id_array[ARRAY]
     * @Return              : $content_path_array[ARRAY]  
     * @Status              : available      
     * */
    function get_all_content_library_path_by_id($person_url, $url, $old_content_id_array) {
        $old_content_path_array = Array();
        for ($i = 0; $i < count($old_content_id_array); $i++) {
            $content_library_info = $this->get_content_library_info_by_content_library_id($old_content_id_array[$i]);
            if ($content_library_info) {
                $old_content_path_array[] = 'content-library/' . $person_url . '/my-work-file/' . $url . '/' . $content_library_info->content_library_location;
            }
        }
        return $old_content_path_array;
    }

    /**
     * @Function            : get_all_content_library_id_tinymce 
     * @Used IN             : @function-'update_tinymce_information'  tinymce_model[@Model]
     * @Description         : get content library ID using Tinymce Description
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 27-07-2016 11:39 AM   
     * @Parameter           : $description[STRING]
     * @Return              : $content_library_id[ARRAY]  
     * @Status              : available      
     * */
    function get_all_content_library_id_from_tinymce($description) {
        $old_href_match = $old_src_match = Array();
        preg_match_all('@href="([^"]+)"@', $this->tinymce_model->changed_text_to_special_character($description), $old_href_match);
        preg_match_all('@src="([^"]+)"@', $this->tinymce_model->changed_text_to_special_character($description), $old_src_match);

        $href_match = $this->utility_model->get_integer_value_from_array($old_href_match[1]);
        $src_match = $this->utility_model->get_integer_value_from_array($old_src_match[1]);
        return array_merge($href_match, $src_match);
    }

    /**
     * @Function            : delete_person_content_library 
     * @Used IN             : @function-'_construct'    welcome[@Controller]
     * @Description         : delete person content library if they change status before
     * @Developed By        : MD Jaherul ISlam
     * @Start DateTime      : 26-06-2016 09:16 AM   
     * @Status              : available      
     * */
    function delete_person_content_library() {
        $person_id = $this->session->userdata('person_id');
        $person_url = $this->person_model->get_profile_url($person_id);
        $content_info = $this->get_content_library_infomation(1, $person_id, 2);
        foreach ($content_info as $content_value) {
            $file_directory = 'content-library/' . $person_url . '/' . $content_value->content_library_location;
            if (file_exists($file_directory)) {
                unlink($file_directory);
            }
            $this->utility_model->delete_information_in_database('tbl_content_library', 'content_library_id', $content_value->content_library_id);
        }
    }

}
