<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Category_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : check_course_category_name_exists 
     * @Used IN             : @function-'course_category_name_check'    user_video[@controller] - [146]
     * @Description         : check category name existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-03-2016 09:53 PM    
     * @Parameter           : $category_name[STRING]
     * @Return              : category_info    
     * @Status              : available      
     * */
    function check_course_category_name_exists($category_name) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS cc
                WHERE 
                    cc.course_category_name = '$category_name'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : save_category 
     * @Used IN             : @function-'save_video_course_information1'      user_video_model[@Model] - [98]
     * @                    : @function-'save_course_information'             user_course_model[@Model] - [53]
     * @Description         : save category if user select other catgory
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 09:55 AM  
     * @Parameter           : $person_id[INTEGER], $catgory_id[INTEGER]
     * @Return              : $catgory_id[INTEGER]    
     * @Status              : Available        
     * */
    function save_category($person_id, $catgory_id) {
        if ($catgory_id == 'other') {
            $cat_data['person_id'] = $person_id;
            $cat_data['course_category_name'] = $this->input->post('course_category_name', TRUE);
            $cat_data['course_category_status'] = 4;

            // create course URl and save url id in course category database
            $cat_data['url_id'] = $this->url_model->create_course_category_url($cat_data['course_category_name']);
            return $this->utility_model->save_information_in_database('tbl_course_category', $cat_data);
        } else {
            return $catgory_id;
        }
    }

    /**
     * @Function            : select_all_available_category 
     * @Used IN             : @function-'add_video_course'    user_video[@controller]
     * @                    : @function-'add_course'          user_course[@controller]
     * @Description         : get all available course categoryand pending created by whose person
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 19-03-2016 09:37 PM   
     * @Parameter           : $person_id[INTEGER]
     * @Return              : all_course_category     
     * @Status              : available      
     * */
    function select_all_available_category($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS cc
                WHERE 
                    cc.course_category_status IN (1,5)
                OR (cc.person_id = '$person_id' AND cc.course_category_status IN (1,4,5))";
        return $this->db->query($sql)->result();
    }

}
