<?php

/**
 * Description of Bank_model
 *
 * @author User
 */
class Bank_model extends CI_Model {

    const tbl_name = 'tbl_bank';
    const primary_key = 'bank_id';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:13 AM      
     * */
    private $data = [];

    public function __set($name, $value) {
        $this->data[$name] = $value;
        return $this;
    }

    /**
     * @Description         : set bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:13 PM      
     * */
    private $bank_id;

    function set_bank_id($bank_id) {
        $this->bank_id = $bank_id;
        return $this;
    }

    /**
     * @Description         : set bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:13 PM      
     * */
    private $bank_name_value;

    function set_bank_name($bank_name) {
        $this->bank_name_value = $bank_name;
        return $this;
    }

    /**
     * @Description         : set search inut
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 05:54 PM      
     * */
    private $search_input;

    function set_search_input($search_input) {
        $this->search_input = $search_input;
        return $this;
    }

    /**
     * @Description         : set limit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 04:42 PM      
     * */
    private $limit;

    function set_limit($limit) {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @Description         : select all bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:11 AM      
     * */
    function select_all_bank_info() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->like('bank_name', $this->search_input)->limit(10, $this->limit)->get()->result();
        return $this;
    }

    /**
     * @Description         : select total bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:11 AM      
     * */
    function total_bank() {
        $this->result = $this->db->select('*')->like('bank_name', $this->search_input)
                        ->from(self::tbl_name)->count_all_results();
        return $this;
    }

    /**
     * @Description         : set bank information for edit bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 10:51 AM      
     * */
    function set_bank_info_by_bank_name() {
        $this->result = $this->db->select('*')->from(self::tbl_name)
                        ->where('bank_name', $this->bank_name_value)->get()->row();
        return $this;
    }
    
    /**
     * @Description         : set bank information for edit bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 10:51 AM      
     * */
    function set_bank_info_for_edit() {
        $this->result = $this->db->select('*')->from(self::tbl_name)->where_not_in(self::primary_key, $this->bank_id)
                        ->where('bank_name', $this->bank_name_value)->get()->row();
        return $this;
    }

    /**
     * @Description         : set all bank ID by bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 10:37 AM      
     * */
    function set_all_bank_id_by_bank_name() {
        $this->result = $this->db->select('GROUP_CONCAT(bank_id) AS id')->from(self::tbl_name)->where_not_in(self::primary_key, $this->bank_id)
                        ->where('bank_name', $this->bank_name_value)->get()->row();
        return $this;
    }

    /**
     * @Description         : get bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 04:42 PM      
     * */
    function get_bank_id() {
        return $this->bank_id;
    }

    /**
     * @Description         : get result
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 02:14 PM      
     * */
    private $result;

    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : save data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 11:19 AM      
     * */
    function save() {
        $this->db->insert(self::tbl_name, $this->data);
        return $this;
    }

    /**
     * @Description         : set insert ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 04:29 PM      
     * */
    function set_insert_id() {
        $this->set_bank_id($this->db->insert_id());
        return $this;
    }

    /**
     * @Description         : Update data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:25 PM      
     * */
    function update() {
        $this->db->where(self::primary_key, $this->bank_id)->update(self::tbl_name, $this->data);
    }

    /**
     * @Description         : delete data into database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-12-2016 12:35 PM      
     * */
    function delete() {
        $this->db->where(self::primary_key, $this->bank_id)->delete(self::tbl_name);
    }

}
